/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.web;

import edu.ku.brc.af.core.db.MySQLBackupService;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HttpLargeFileTransfer {
    protected static final Logger log = Logger.getLogger(HttpLargeFileTransfer.class);
    public static final int BUFFER_SIZE = 4096;
    public static final int MAX_CHUNK_SIZE = 4096000;
    public static final String SERVICE_NUMBER = "Transfer-Server-Number";
    public static final String FILE_NAME_HEADER = "Transfer-File-Name";
    public static final String CLIENT_ID_HEADER = "Transfer-Client-ID";
    public static final String FILE_CHUNK_HEADER = "Transfer-File-Chunk";
    public static final String FILE_CHUNK_COUNT_HEADER = "Transfer-File-Chunk-Count";
    public static final String IS_SITE_FILE = "Transfer-File-IS-SITE-FILE";

    public boolean compressFile(final String infileName, final String outFileName, final PropertyChangeListener propChgListener) {
        long fileSize;
        final File file = new File(infileName);
        if (file.exists() && (fileSize = file.length()) > 0L) {
            SwingWorker<Integer, Integer> backupWorker = new SwingWorker<Integer, Integer>(){
                protected String errorMsg = null;
                protected FileInputStream fis = null;
                protected GZIPOutputStream fos = null;

                @Override
                protected Integer doInBackground() throws Exception {
                    block18: {
                        try {
                            try {
                                int len;
                                Thread.sleep(100L);
                                long totalSize = file.length();
                                long bytesCnt = 0L;
                                FileInputStream fis = new FileInputStream(infileName);
                                GZIPOutputStream fos = new GZIPOutputStream(new FileOutputStream(outFileName));
                                byte[] bytes = new byte[40960];
                                while ((len = fis.read(bytes)) > 0) {
                                    fos.write(bytes, 0, len);
                                    this.firePropertyChange("MEGS", 0, (int)((double)(bytesCnt += (long)len) / (double)totalSize * 100.0));
                                }
                                fis.close();
                                fos.close();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                this.errorMsg = ex.toString();
                                try {
                                    if (this.fis != null) {
                                        this.fis.close();
                                    }
                                    if (this.fos != null) {
                                        this.fos.close();
                                    }
                                    break block18;
                                }
                                catch (IOException ex2) {
                                    this.errorMsg = ex2.toString();
                                }
                                break block18;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (this.fis != null) {
                                    this.fis.close();
                                }
                                if (this.fos != null) {
                                    this.fos.close();
                                }
                            }
                            catch (IOException ex) {
                                this.errorMsg = ex.toString();
                            }
                            throw throwable;
                        }
                        try {
                            if (this.fis != null) {
                                this.fis.close();
                            }
                            if (this.fos != null) {
                                this.fos.close();
                            }
                        }
                        catch (IOException ex) {
                            this.errorMsg = ex.toString();
                        }
                    }
                    this.firePropertyChange("MEGS", 0, 100);
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                    UIRegistry.getStatusBar().setProgressDone(HttpLargeFileTransfer.class.toString());
                    if (StringUtils.isNotEmpty((String)this.errorMsg)) {
                        UIRegistry.showError(this.errorMsg);
                    }
                    if (propChgListener != null) {
                        propChgListener.propertyChange(new PropertyChangeEvent(HttpLargeFileTransfer.this, "Done", 0, 1));
                    }
                }
            };
            final JStatusBar statusBar = UIRegistry.getStatusBar();
            statusBar.setIndeterminate(HttpLargeFileTransfer.class.toString(), true);
            UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("Compressing Backup...", new Object[0]), 24);
            backupWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MEGS".equals(evt.getPropertyName())) {
                        Integer value = (Integer)evt.getNewValue();
                        double val = (double)value.intValue() / 10.0;
                        statusBar.setText(UIRegistry.getLocalizedMessage("MySQLBackupService.BACKUP_MEGS", val));
                    }
                }
            });
            backupWorker.execute();
        }
        return false;
    }

    public static boolean uncompressFile(String infileName, String outFileName) {
        long fileSize;
        File file = new File(infileName);
        if (file.exists() && (fileSize = file.length()) > 0L) {
            try {
                int len;
                GZIPInputStream fis = new GZIPInputStream(new FileInputStream(infileName));
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(outFileName));
                byte[] bytes = new byte[40960];
                while ((len = fis.read(bytes)) > 0) {
                    fos.write(bytes, 0, len);
                }
                fis.close();
                fos.close();
                return true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public void transferFile(final String fileName, final String urlStr, final boolean isSiteFile, final PropertyChangeListener propChgListener) {
        long fileSize;
        final String prgName = HttpLargeFileTransfer.class.toString();
        final File file = new File(fileName);
        if (file.exists() && (fileSize = file.length()) > 0L) {
            SwingWorker<Integer, Integer> backupWorker = new SwingWorker<Integer, Integer>(){
                protected String errorMsg = null;
                protected FileInputStream fis = null;
                protected OutputStream fos = null;
                protected int nChunks = 0;

                @Override
                protected Integer doInBackground() throws Exception {
                    try {
                        Thread.sleep(100L);
                        this.fis = new FileInputStream(file);
                        this.nChunks = (int)(fileSize / 4096000L);
                        if (fileSize % 4096000L > 0L) {
                            ++this.nChunks;
                        }
                        byte[] buf = new byte[4096];
                        long bytesRemaining = fileSize;
                        String clientID = String.valueOf((long)(-9.223372036854776E18 * Math.random()));
                        URL url = new URL(urlStr);
                        UIRegistry.getStatusBar().setProgressRange(prgName, 0, this.nChunks);
                        int i = 0;
                        while (i < this.nChunks) {
                            this.firePropertyChange(prgName, i - 1, i == this.nChunks - 1 ? Integer.MAX_VALUE : i);
                            if (i == this.nChunks - 1) {
                                Thread.sleep(500L);
                                int x = 0;
                                ++x;
                            }
                            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                            conn.setRequestMethod("PUT");
                            conn.setDoOutput(true);
                            conn.setDoInput(true);
                            conn.setUseCaches(false);
                            int chunkSize = (int)(bytesRemaining > 4096000L ? 4096000L : bytesRemaining);
                            bytesRemaining -= (long)chunkSize;
                            conn.setRequestProperty("Content-Type", "application/octet-stream");
                            conn.setRequestProperty("Content-Length", String.valueOf(chunkSize));
                            conn.setRequestProperty(HttpLargeFileTransfer.CLIENT_ID_HEADER, clientID);
                            conn.setRequestProperty(HttpLargeFileTransfer.FILE_NAME_HEADER, fileName);
                            conn.setRequestProperty(HttpLargeFileTransfer.FILE_CHUNK_COUNT_HEADER, String.valueOf(this.nChunks));
                            conn.setRequestProperty(HttpLargeFileTransfer.FILE_CHUNK_HEADER, String.valueOf(i));
                            conn.setRequestProperty(HttpLargeFileTransfer.SERVICE_NUMBER, "10");
                            conn.setRequestProperty(HttpLargeFileTransfer.IS_SITE_FILE, Boolean.toString(isSiteFile));
                            this.fos = conn.getOutputStream();
                            int cnt = 0;
                            int bytesRead = 0;
                            while (bytesRead < chunkSize) {
                                int read = this.fis.read(buf);
                                if (read == -1) break;
                                if (read > 0) {
                                    bytesRead += read;
                                    this.fos.write(buf, 0, read);
                                }
                                ++cnt;
                            }
                            this.fos.close();
                            if (conn.getResponseCode() != 200) {
                                System.err.println(String.valueOf(conn.getResponseMessage()) + " " + conn.getResponseCode() + " ");
                                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                                String line = null;
                                StringBuilder sb = new StringBuilder();
                                while ((line = in.readLine()) != null) {
                                    sb.append(line);
                                    sb.append("\n");
                                }
                                System.out.println(sb.toString());
                                in.close();
                            } else {
                                System.err.println("OK");
                            }
                            this.firePropertyChange(prgName, i - 1, i == this.nChunks - 1 ? Integer.MAX_VALUE : i);
                            ++i;
                        }
                    }
                    catch (IOException ex) {
                        this.errorMsg = ex.toString();
                    }
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                    UIRegistry.getStatusBar().setProgressDone(prgName);
                    UIRegistry.clearSimpleGlassPaneMsg();
                    if (StringUtils.isNotEmpty((String)this.errorMsg)) {
                        UIRegistry.showError(this.errorMsg);
                    }
                    if (propChgListener != null) {
                        propChgListener.propertyChange(new PropertyChangeEvent(HttpLargeFileTransfer.this, "Done", 0, 1));
                    }
                }
            };
            final JStatusBar statusBar = UIRegistry.getStatusBar();
            statusBar.setIndeterminate(HttpLargeFileTransfer.class.toString(), true);
            UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("Transmitting...", new Object[0]), 24);
            backupWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    System.out.println(String.valueOf(evt.getPropertyName()) + "  " + evt.getNewValue());
                    if (prgName.equals(evt.getPropertyName())) {
                        Integer value = (Integer)evt.getNewValue();
                        if (value == Integer.MAX_VALUE) {
                            statusBar.setIndeterminate(prgName, true);
                            UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("Transfering data into the database.", new Object[0]), 24);
                        } else {
                            statusBar.setValue(prgName, value);
                        }
                    }
                }
            });
            backupWorker.execute();
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println("=================================");
        String fileName = req.getHeader(FILE_NAME_HEADER);
        if (fileName == null) {
            resp.sendError(500, "Filename not specified");
            return;
        }
        String clientID = req.getHeader(CLIENT_ID_HEADER);
        if (clientID == null) {
            resp.sendError(500, "Missing Client ID");
            return;
        }
        String serviceNumber = req.getHeader(SERVICE_NUMBER);
        if (serviceNumber == null) {
            resp.sendError(500, "Missing Service Number");
            return;
        }
        String databaseName = StringUtils.replace((String)serviceNumber, (String)".", (String)"_");
        int numChunks = req.getIntHeader(FILE_CHUNK_COUNT_HEADER);
        int chunkCnt = req.getIntHeader(FILE_CHUNK_HEADER);
        if (numChunks == -1 || chunkCnt == -1) {
            resp.sendError(500, "Missing chunk information");
            return;
        }
        FileOutputStream fos = null;
        fos = numChunks == 1 ? new FileOutputStream(fileName) : new FileOutputStream(HttpLargeFileTransfer.getTempFile(clientID), chunkCnt > 0);
        ServletInputStream fis = req.getInputStream();
        byte[] buf = new byte[4096];
        int totalLen = 0;
        while (true) {
            int len;
            if ((len = fis.read(buf)) > 0) {
                totalLen += len;
                ((OutputStream)fos).write(buf, 0, len);
                continue;
            }
            if (len == -1) break;
        }
        fis.close();
        ((OutputStream)fos).close();
        File destFile = new File(fileName);
        boolean isOK = true;
        if (numChunks > 1 && chunkCnt == numChunks - 1) {
            File tmpFile = new File(HttpLargeFileTransfer.getTempFile(clientID));
            if (destFile.exists()) {
                destFile.delete();
            }
            if (!tmpFile.renameTo(destFile)) {
                isOK = false;
                resp.sendError(500, "Unable to create file");
                return;
            }
        }
        if (isOK) {
            String fullDestPath = destFile + ".sql";
            if (HttpLargeFileTransfer.uncompressFile(destFile.getAbsolutePath(), fullDestPath)) {
                MySQLBackupService backupService = new MySQLBackupService();
                databaseName = "db";
                if (backupService.doRestore(fullDestPath, "/usr/local/mysql/bin/mysql", databaseName, "root", "root")) {
                    resp.setStatus(200);
                } else {
                    resp.sendError(500, "error restoring");
                }
            } else {
                resp.sendError(500);
            }
        } else {
            resp.sendError(500, "error decompressing");
        }
    }

    private static String getTempFile(String clientID) {
        return String.valueOf(clientID) + ".tmp";
    }
}

