/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.web;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanelIFace;
import edu.ku.brc.specify.tasks.subpane.ExpressSearchResultsPaneIFace;
import edu.ku.brc.specify.ui.db.ResultSetTableModel;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ExplorerESPanel
implements ExpressSearchResultsPaneIFace {
    protected Vector<ResultSetTableModel> rsCollectors = new Vector();

    public synchronized void reset() {
        this.rsCollectors.clear();
    }

    @Override
    public synchronized void addSearchResults(QueryForIdResultsIFace queryDef) {
        ResultSetTableModel rsm = new ResultSetTableModel(null, queryDef, true);
        this.rsCollectors.add(rsm);
    }

    @Override
    public void addTable(ESResultsTablePanelIFace table) {
    }

    @Override
    public boolean hasResults() {
        return false;
    }

    @Override
    public void removeTable(ESResultsTablePanelIFace table) {
    }

    @Override
    public void revalidateScroll() {
    }

    @Override
    public boolean doQueriesSynchronously() {
        return true;
    }

    @Override
    public void done() {
    }

    public JSONArray getTables() {
        Vector<Integer> orderList = new Vector<Integer>();
        Hashtable<Integer, ResultSetTableModel> hash = new Hashtable<Integer, ResultSetTableModel>();
        for (ResultSetTableModel rsm : this.rsCollectors) {
            Integer order = rsm.getQueryForIdResults().getDisplayOrder();
            orderList.add(order);
            hash.put(order, rsm);
        }
        Collections.sort(orderList);
        JSONArray tableArray = new JSONArray();
        int i = 0;
        for (Integer order : orderList) {
            ResultSetTableModel rsm = (ResultSetTableModel)hash.get(order);
            if (rsm.getRowCount() <= 0) continue;
            tableArray.add((Object)this.createJSON(rsm.getQueryForIdResults(), rsm));
            ++i;
        }
        return tableArray;
    }

    private JSONObject createJSON(QueryForIdResultsIFace queryDef, ResultSetTableModel rsm) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        try {
            int totalWidth = 600;
            List<ERTICaptionInfo> infoList = queryDef.getVisibleCaptionInfo();
            int colWidth = (totalWidth - (rsm.getRowCount() > 14 ? 20 : 4)) / infoList.size();
            int i = 0;
            JSONArray colModel = new JSONArray();
            for (ERTICaptionInfo info : infoList) {
                String colName = info.getColName();
                JSONObject colObj = new JSONObject();
                if (i == 0) {
                    colObj.accumulate("id", (Object)colName);
                }
                colObj.accumulate("header", (Object)info.getColLabel());
                colObj.accumulate("width", colWidth);
                colObj.accumulate("sortable", true);
                colObj.accumulate("dataIndex", (Object)colName);
                colModel.add((Object)colObj);
                ++i;
            }
            JSONArray headerModel = new JSONArray();
            for (ERTICaptionInfo info : infoList) {
                String colName = info.getColName();
                Class<?> cls = info.getColClass();
                JSONObject hdr = new JSONObject();
                hdr.accumulate("name", (Object)colName);
                String type = "string";
                if (cls == Float.class) {
                    type = "float";
                } else if (cls == Boolean.class) {
                    type = "bool";
                }
                hdr.accumulate("type", (Object)type);
                headerModel.add((Object)hdr);
            }
            JSONArray dataModel = new JSONArray();
            int rowInx = 0;
            while (rowInx < rsm.getRowCount()) {
                JSONArray row = new JSONArray();
                Object[] data = new Object[infoList.size()];
                int inx = 0;
                while (inx < data.length) {
                    ERTICaptionInfo info = infoList.get(inx);
                    Object dataObj = rsm.getCacheValueAt(rowInx, inx);
                    if (dataObj != null) {
                        if (Date.class.isAssignableFrom(dataObj.getClass()) || Calendar.class.isAssignableFrom(dataObj.getClass())) {
                            if (dataObj instanceof GregorianCalendar) {
                                GregorianCalendar gDate = (GregorianCalendar)dataObj;
                                dataObj = sdf.format(gDate.getTime());
                            } else {
                                dataObj = sdf.format((Date)dataObj);
                            }
                        } else {
                            UIFieldFormatterIFace fmt = info.getUiFieldFormatter();
                            if (fmt != null) {
                                dataObj = fmt.formatToUI(dataObj);
                            }
                        }
                    } else {
                        dataObj = "";
                    }
                    row.add(dataObj);
                    ++inx;
                }
                dataModel.add((Object)row);
                ++rowInx;
            }
            JSONObject tableJSON = new JSONObject();
            tableJSON.accumulate("title", (Object)queryDef.getTitle());
            tableJSON.accumulate("column_model", (Object)colModel);
            tableJSON.accumulate("headers", (Object)headerModel);
            tableJSON.accumulate("rows", (Object)dataModel);
            return tableJSON;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ExplorerESPanel.class, ex);
            ex.printStackTrace();
            return null;
        }
    }
}

