/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.web;

import edu.ku.brc.specify.web.AdditionalDisplayField;
import edu.ku.brc.specify.web.FieldDisplayInfo;
import edu.ku.brc.specify.web.StatsDisplayInfo;
import edu.ku.brc.specify.web.TitleGetterIFace;
import java.util.Hashtable;
import java.util.Vector;

public class ClassDisplayInfo
implements Comparable<ClassDisplayInfo> {
    protected static String packageName;
    protected String className;
    protected Class<?> classObj;
    protected String indexName;
    protected Class<?> indexClass;
    protected boolean useIdentityTitle;
    protected String linkField;
    protected TitleGetterIFace titleGetter = null;
    protected String titleField = null;
    protected Vector<FieldDisplayInfo> fields = new Vector();
    protected Vector<FieldDisplayInfo> order = new Vector();
    protected Hashtable<String, FieldDisplayInfo> fieldHash = new Hashtable();
    protected Vector<AdditionalDisplayField> additional = new Vector();
    protected Hashtable<String, AdditionalDisplayField> additionalHash = new Hashtable();
    protected Vector<StatsDisplayInfo> stats = new Vector();

    public ClassDisplayInfo(String className, Class<?> classObj, String indexName, Class<?> indexClass, String linkField, boolean useIdentityTitle) {
        this.className = className;
        this.classObj = classObj;
        this.indexName = indexName;
        this.indexClass = indexClass;
        this.linkField = linkField;
        this.useIdentityTitle = useIdentityTitle;
    }

    public String getTitleField() {
        return this.titleField;
    }

    public void setTitleField(String titleField) {
        this.titleField = titleField;
    }

    public TitleGetterIFace getTitleGetter() {
        return this.titleGetter;
    }

    public void setTitleGetter(TitleGetterIFace titleGetter) {
        this.titleGetter = titleGetter;
    }

    public void addOrdered(FieldDisplayInfo field) {
        this.order.add(field);
        this.fields.add(field);
        this.fieldHash.put(field.getName(), field);
    }

    public void addSkipped(FieldDisplayInfo field) {
        field.setSkipped(true);
        this.fields.add(field);
        this.fieldHash.put(field.getName(), field);
    }

    public void addAdditional(AdditionalDisplayField field) {
        this.additional.add(field);
        this.additionalHash.put(field.getFieldName(), field);
    }

    public void addStat(StatsDisplayInfo field) {
        this.stats.add(field);
    }

    public FieldDisplayInfo getField(String fName) {
        return this.fieldHash.get(fName);
    }

    public boolean isFieldSkipped(String name) {
        FieldDisplayInfo field = this.fieldHash.get(name);
        if (field != null) {
            return field.isSkipped();
        }
        return false;
    }

    public Vector<FieldDisplayInfo> getFields() {
        return this.fields;
    }

    public Hashtable<String, FieldDisplayInfo> getHash() {
        return this.fieldHash;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullName() {
        return this.classObj.getName();
    }

    public Class<?> getClassObj() {
        return this.classObj;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Class<?> getIndexClass() {
        return this.indexClass;
    }

    public String getLinkField() {
        return this.linkField;
    }

    public boolean isUseIdentityTitle() {
        return this.useIdentityTitle;
    }

    public Vector<FieldDisplayInfo> getOrder() {
        return this.order;
    }

    public Vector<StatsDisplayInfo> getStats() {
        return this.stats;
    }

    public Vector<AdditionalDisplayField> getAdditional() {
        return this.additional;
    }

    @Override
    public int compareTo(ClassDisplayInfo o) {
        return this.className.compareTo(o.className);
    }

    public static String getPackageName() {
        return packageName;
    }

    public static void setPackageName(String packageName) {
        ClassDisplayInfo.packageName = packageName;
    }
}

