/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps.sp5utils;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.FrameworkAppIFace;
import edu.ku.brc.af.core.MacOSAppHandler;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.SpecifyDBConverter;
import edu.ku.brc.specify.conversion.TableDataChecker;
import edu.ku.brc.specify.utilapps.ERDVisualizer;
import edu.ku.brc.specify.utilapps.sp5utils.FieldCellModel;
import edu.ku.brc.specify.utilapps.sp5utils.FormCellModel;
import edu.ku.brc.specify.utilapps.sp5utils.FormFieldInfo;
import edu.ku.brc.specify.utilapps.sp5utils.FormInfo;
import edu.ku.brc.specify.utilapps.sp5utils.SchemaLocaleUpdater;
import edu.ku.brc.specify.utilapps.sp5utils.TableInfoMapping;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class Sp5Forms
extends JFrame
implements FrameworkAppIFace {
    protected static final Logger log = Logger.getLogger(Sp5Forms.class);
    protected Pair<String, String> namePair = null;
    protected String hostName;
    protected Pair<String, String> itUsrPwd;
    protected Vector<FormInfo> forms = new Vector();
    protected Vector<String> missingFields = new Vector();
    protected HashMap<String, FormInfo> formHash = new HashMap();
    protected HashMap<String, TableInfoMapping> tblNameOldToNewHash = new HashMap();
    protected HashMap<String, TableInfoMapping> tblNameNewToOldHash = new HashMap();
    protected JList formsList;
    protected JList missingFieldsList;
    protected FieldCellModel fieldsTableModel;
    protected JTable formsTable;
    protected JTable fieldsTable;
    protected FormInfo selectedForm = null;
    protected JPanel mainPanel;
    protected JFrame formFrame = null;
    protected JButton reportBtn;
    protected JButton schemaBtn;
    protected JButton showBtn;
    protected JButton dataCheckerBtn;
    protected Sp6FieldComboBoxEditor sp6FieldEditor;
    protected Sp6FieldComboBoxRenderer sp6FieldRenderer;
    protected boolean hasChanged = false;
    protected Timer timer = null;
    protected JFrame frame;
    protected int formIndex;
    protected String formName;

    protected void createUI() {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p,p:g", "p,2px,f:p:g,4px,p,2px,p,10px,p"));
        this.missingFieldsList = new JList(new DefaultListModel());
        this.formsTable = new JTable(new FormCellModel(this.forms));
        this.formsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (Sp5Forms.this.formsTable.getSelectedRow() > -1) {
                    Sp5Forms.this.formSelected();
                }
            }
        });
        this.fieldsTableModel = new FieldCellModel();
        this.fieldsTable = new JTable(this.fieldsTableModel);
        TableColumn col = this.fieldsTable.getColumnModel().getColumn(1);
        this.sp6FieldEditor = new Sp6FieldComboBoxEditor();
        col.setCellEditor(this.sp6FieldEditor);
        UIHelper.calcColumnWidths(this.formsTable);
        PanelBuilder pbBtn = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g,p,f:p:g,p,f:p:g,p,f:p:g", "p"));
        this.reportBtn = UIHelper.createButton("Create Form Images");
        this.showBtn = UIHelper.createButton("Show");
        this.schemaBtn = UIHelper.createButton("Schema");
        this.dataCheckerBtn = UIHelper.createButton("Check For Nulls");
        pbBtn.add((Component)this.reportBtn, cc.xy(2, 1));
        pbBtn.add((Component)this.schemaBtn, cc.xy(4, 1));
        pbBtn.add((Component)this.showBtn, cc.xy(6, 1));
        pbBtn.add((Component)this.dataCheckerBtn, cc.xy(8, 1));
        pb.add((Component)UIHelper.createLabel("Forms", 0), cc.xy(1, 1));
        pb.add((Component)UIHelper.createLabel("Missing Fields", 0), cc.xy(3, 1));
        pb.add((Component)UIHelper.createScrollPane(this.formsTable), cc.xy(1, 3));
        pb.add((Component)UIHelper.createScrollPane(this.missingFieldsList), cc.xy(3, 3));
        pb.add((Component)UIHelper.createLabel("Form Fields", 0), cc.xyw(1, 5, 3));
        pb.add((Component)UIHelper.createScrollPane(this.fieldsTable), cc.xyw(1, 7, 3));
        pb.add((Component)pbBtn.getPanel(), cc.xyw(1, 9, 3));
        pb.setDefaultDialogBorder();
        this.setContentPane(new JScrollPane(pb.getPanel()));
        this.showBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sp5Forms.this.showForm();
            }
        });
        this.reportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sp5Forms.this.doCreateFormImages();
            }
        });
        this.schemaBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sp5Forms.this.doSchema();
            }
        });
        this.dataCheckerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDataChecker tdc = new TableDataChecker(DBConnection.getInstance().createConnection());
                tdc.doCheckDB();
            }
        });
    }

    protected void doSchema() {
        SchemaLocaleUpdater dlg = new SchemaLocaleUpdater(this.selectedForm);
        dlg.createUI();
        dlg.setSize(800, 550);
        dlg.pack();
        UIHelper.centerAndShow(dlg);
    }

    protected void formSelected() {
        this.selectedForm = this.forms.get(this.formsTable.getSelectedRow());
        DefaultListModel model = (DefaultListModel)this.missingFieldsList.getModel();
        model.clear();
        for (FormFieldInfo fi : this.selectedForm.getFields()) {
            if (fi.getSp6FieldName() != null) continue;
            model.addElement(fi.getSp5FieldName());
        }
        DefaultComboBoxModel cbxModel = (DefaultComboBoxModel)((JComboBox)this.sp6FieldEditor.getComponent()).getModel();
        cbxModel.removeAllElements();
        cbxModel.addElement("");
        DBTableInfo tblInfo = this.selectedForm.getTblInfo();
        if (tblInfo != null) {
            for (DBFieldInfo fldInfo : tblInfo.getFields()) {
                if (!StringUtils.isNotEmpty((String)fldInfo.getColumn())) continue;
                cbxModel.addElement(fldInfo.getColumn());
            }
            for (DBRelationshipInfo relInfo : tblInfo.getRelationships()) {
                if (!StringUtils.isNotEmpty((String)relInfo.getColName())) continue;
                cbxModel.addElement(relInfo.getColName());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Sp5Forms.this.fieldsTableModel.setSelectedForm(Sp5Forms.this.selectedForm);
                Sp5Forms.this.fieldsTableModel.fireTableDataChanged();
            }
        });
    }

    protected FormPanelInfo createPanel(FormInfo formInfo) {
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel(null);
        int maxWidth = 0;
        int maxHeight = 0;
        int maxCellWidth = 0;
        int maxCellHeight = 0;
        for (FormFieldInfo fi : formInfo.getFields()) {
            System.out.println(fi.getCaption());
            boolean addLbl = true;
            JComponent comp = null;
            switch (fi.getControlTypeNum()) {
                case 4: {
                    comp = UIHelper.createComboBox();
                    break;
                }
                case 5: {
                    JComboBox cbx = UIHelper.createComboBox();
                    cbx.setEditable(true);
                    cbx.getEditor().setItem(fi.getCaption());
                    JPanel cPanel = new JPanel(new BorderLayout());
                    cPanel.add((Component)cbx, "Center");
                    cPanel.add((Component)this.createElipseBtn(), "East");
                    comp = cPanel;
                    addLbl = false;
                    break;
                }
                case 7: {
                    String uniqueKey = FormInfo.getUniqueKey(fi.getRelatedTableName(), "Embedded", fi.getParent().getFormType());
                    FormInfo subForm = this.formHash.get(uniqueKey);
                    if (subForm == null) {
                        uniqueKey = FormInfo.getUniqueKey(fi.getRelatedTableName(), "Embedded", null);
                        subForm = this.formHash.get(uniqueKey);
                    }
                    if (subForm == null) break;
                    Vector<String> headers = new Vector<String>();
                    int i = 0;
                    while (i < subForm.getFields().size()) {
                        headers.add(subForm.getFields().get(i).getCaption());
                        ++i;
                    }
                    JPanel p = new JPanel(new BorderLayout());
                    p.add((Component)UIHelper.createScrollPane(new JTable(new Vector(), headers)), "Center");
                    comp = p;
                    addLbl = false;
                    break;
                }
                case 8: {
                    String uniqueKey = FormInfo.getUniqueKey(fi.getRelatedTableName(), "Embedded", fi.getParent().getFormType());
                    FormInfo subForm = this.formHash.get(uniqueKey);
                    if (subForm == null) {
                        uniqueKey = FormInfo.getUniqueKey(fi.getRelatedTableName(), "Embedded", null);
                        subForm = this.formHash.get(uniqueKey);
                    }
                    comp = subForm != null ? this.createPanel(subForm).getPanel() : new JPanel();
                    addLbl = fi.getControlTypeNum() != 8;
                    break;
                }
                case 9: {
                    comp = this.createElipseBtn();
                    break;
                }
                case 20: {
                    comp = UIHelper.createScrollPane(UIHelper.createTextArea());
                    break;
                }
                case 21: {
                    comp = null;
                    break;
                }
                case 46: {
                    comp = UIHelper.createTextField("URL");
                    break;
                }
                default: {
                    comp = fi.getDataTypeNum() == 4 ? UIHelper.createCheckBox(" ") : UIHelper.createTextField();
                }
            }
            if (comp == null) continue;
            String toolTip = "Field: " + fi.getSp5FieldName() + (StringUtils.isNotEmpty((String)fi.getSp6FieldName()) && fi.getSp6FieldName().equalsIgnoreCase(fi.getSp5FieldName()) ? " Sp6: " + fi.getSp6FieldName() : "");
            comp.setToolTipText(toolTip);
            PanelBuilder pb = new PanelBuilder(new FormLayout("p,1px,f:p:g", "f:p:g,p,f:p:g"));
            pb.getPanel().setToolTipText(toolTip);
            pb.getPanel().setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            if (addLbl) {
                pb.add((Component)UIHelper.createLabel(fi.getCaption()), cc.xy(1, 2));
            }
            pb.add((Component)comp, cc.xy(3, 2));
            panel.add(pb.getPanel());
            maxWidth = Math.max(maxWidth, fi.getLeft() + fi.getWidth());
            maxHeight = Math.max(maxHeight, fi.getTop() + fi.getHeight());
            maxCellWidth = Math.max(maxWidth, fi.getCellX() + fi.getCellWidth());
            maxCellHeight = Math.max(maxHeight, fi.getCellY() + fi.getCellHeight());
            boolean newWay = false;
            if (newWay) {
                Rectangle r = fi.getBoundsFromCellDim();
                pb.getPanel().setLocation(r.x, r.y);
                pb.getPanel().setSize(r.width, r.height);
            } else {
                pb.getPanel().setLocation(fi.getLeft(), fi.getTop());
                pb.getPanel().setSize(fi.getWidth(), fi.getHeight());
            }
            System.out.println("MaxW: " + maxWidth + "  " + maxCellWidth);
            System.out.println("MaxH: " + maxHeight + "  " + maxCellHeight);
        }
        boolean newWay = false;
        if (newWay) {
            int cw = FormFieldInfo.getSegWidth();
            panel.setPreferredSize(new Dimension(maxCellWidth * cw, maxCellHeight * cw));
            panel.setSize(new Dimension(maxCellWidth * cw, maxCellHeight * cw));
        } else {
            panel.setPreferredSize(new Dimension(maxWidth, maxHeight));
            panel.setSize(new Dimension(maxWidth, maxHeight));
        }
        System.out.println("MaxW: " + maxWidth + "  " + maxCellWidth);
        System.out.println("MaxH: " + maxHeight + "  " + maxCellHeight);
        return new FormPanelInfo(formInfo.getTitle(), panel, maxWidth, maxHeight);
    }

    protected JPanel createElipseBtn() {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g", "f:p:g,p,f:p:g"));
        JButton btn = new JButton("...");
        btn.setMargin(new Insets(2, 4, 2, 4));
        btn.setBorder(BorderFactory.createBevelBorder(0));
        pb.add((Component)btn, cc.xy(2, 2));
        return pb.getPanel();
    }

    protected void showForm() {
        if (this.selectedForm != null) {
            if (this.formFrame != null) {
                this.formFrame.setVisible(false);
                this.formFrame.dispose();
            }
            this.formFrame = new JFrame();
            FormPanelInfo formPanelInfo = this.createPanel(this.selectedForm);
            JPanel panel = formPanelInfo.getPanel();
            JLabel label = new JLabel(formPanelInfo.getTitle(), 0);
            Font font = label.getFont();
            label.setFont(font.deriveFont(14.0f).deriveFont(1));
            JPanel container = new JPanel(new BorderLayout());
            container.add((Component)panel, "Center");
            container.add((Component)label, "South");
            this.formFrame.setContentPane(container);
            panel.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
            this.formFrame.setVisible(true);
            this.formFrame.setSize(new Dimension(formPanelInfo.getMaxWidth() + 10, formPanelInfo.getMaxHeight() + 25));
        }
    }

    protected String getFormQuery() {
        File file = XMLHelper.getConfigDir("../demo_files/Sp5ConvInfo.xml");
        try {
            Element root = XMLHelper.readFileToDOM4J(file);
            if (root != null) {
                for (Object tblObj : root.selectNodes("mappings/table")) {
                    Element tblNode = (Element)tblObj;
                    TableInfoMapping tblInfoMap = new TableInfoMapping(XMLHelper.getAttr(tblNode, "newname", null), XMLHelper.getAttr(tblNode, "oldname", null));
                    for (Object fldObj : tblNode.selectNodes("field")) {
                        Element fldNode = (Element)fldObj;
                        tblInfoMap.addFieldMapping(XMLHelper.getAttr(fldNode, "newname", null), XMLHelper.getAttr(fldNode, "oldname", null));
                    }
                    this.tblNameOldToNewHash.put(tblInfoMap.getOldTableName().toLowerCase(), tblInfoMap);
                    this.tblNameNewToOldHash.put(tblInfoMap.getNewTableName().toLowerCase(), tblInfoMap);
                    for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
                        if (this.tblNameNewToOldHash.get(ti.getName()) != null) continue;
                        this.tblNameNewToOldHash.put(ti.getName(), new TableInfoMapping(ti.getName(), ti.getName()));
                    }
                }
                Iterator iterator = root.selectNodes("queries/query").iterator();
                if (iterator.hasNext()) {
                    Object qryObj = iterator.next();
                    Element queryNode = (Element)qryObj;
                    System.out.println(queryNode.getText());
                    return queryNode.getText();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String getStr(Object str) {
        return str == null ? "" : str.toString();
    }

    protected void process() {
        this.forms.clear();
        Connection connection = DBConnection.getInstance().createConnection();
        String sql = this.getFormQuery();
        if (sql != null) {
            Vector<Object[]> rows = BasicSQLUtils.query(connection, sql);
            DBTableInfo tblInfo = null;
            FormInfo formInfo = null;
            String curTblName = "";
            for (Object[] row : rows) {
                DBTableChildIFace childInfo;
                String tableName = row[0].toString();
                String uniqueKey = FormInfo.getUniqueKey(tableName, this.getStr(row[1]), this.getStr(row[12]));
                if (!curTblName.equals(uniqueKey)) {
                    tblInfo = this.getTableInfo(tableName);
                    formInfo = new FormInfo(tableName, this.getStr(row[1]), this.getStr(row[12]), tblInfo);
                    this.forms.add(formInfo);
                    curTblName = uniqueKey;
                    this.formHash.put(uniqueKey, formInfo);
                    System.out.println(uniqueKey);
                }
                String sp5FieldName = this.getStr(row[2]);
                String sp6FieldName = null;
                String caption = this.getStr(row[3]);
                String controlType = this.getStr(row[4]);
                String datatype = this.getStr(row[5]);
                String relatedTableName = this.getStr(row[6]);
                Integer left = (Integer)row[7];
                Integer top = (Integer)row[8];
                Integer width = (Integer)row[9];
                Integer height = (Integer)row[10];
                Integer dataTypeNum = (Integer)row[16];
                Integer controlTypeNum = (Integer)row[17];
                FormFieldInfo fld = new FormFieldInfo(sp5FieldName, sp6FieldName, caption, controlType, datatype, relatedTableName, top, left, width, height, controlTypeNum, dataTypeNum);
                if (tblInfo != null && (childInfo = this.getFieldInfo(tblInfo, fld)) != null) {
                    sp6FieldName = childInfo instanceof DBFieldInfo ? ((DBFieldInfo)childInfo).getColumn() : ((DBRelationshipInfo)childInfo).getName();
                    fld.setSp6FieldName(sp6FieldName);
                }
                fld.setParent(formInfo);
                formInfo.getFields().add(fld);
            }
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected DBTableInfo getTableInfo(String oldTblName) {
        TableInfoMapping timp = this.tblNameOldToNewHash.get(oldTblName.toLowerCase());
        String tblName = timp == null ? oldTblName : timp.getNewTableName();
        DBTableIdMgr mgr = DBTableIdMgr.getInstance();
        DBTableInfo tblInfo = mgr.getByShortClassName(tblName);
        if (tblInfo == null) {
            TableInfoMapping tblMapping = this.tblNameOldToNewHash.get(tblName);
            if (tblMapping != null) {
                tblInfo = mgr.getByShortClassName(tblMapping.getNewTableName());
                if (tblInfo == null) {
                    log.error((Object)("getTableInfo - Old Table Name: " + tblName + " was not found in DBTableIdMgr"));
                }
            } else {
                log.error((Object)("getTableInfo - Old Table Name: " + tblName + " was not mapped in Hash."));
            }
        }
        return tblInfo;
    }

    protected DBTableChildIFace getFieldInfo(DBTableInfo tblInfo, FormFieldInfo fieldInfo) {
        String oldFieldName = fieldInfo.getSp5FieldName();
        if (fieldInfo.getDataTypeNum() == 6 || fieldInfo.getDataTypeNum() == 7 || fieldInfo.getDataTypeNum() == 8) {
            oldFieldName = fieldInfo.getRelatedTableName();
            DBTableChildIFace childInfo = this.getFieldInfoInternal(tblInfo, fieldInfo, oldFieldName);
            if (childInfo == null && oldFieldName.endsWith("s")) {
                oldFieldName = oldFieldName.substring(0, oldFieldName.length() - 1);
                return this.getFieldInfoInternal(tblInfo, fieldInfo, oldFieldName);
            }
            return childInfo;
        }
        return this.getFieldInfoInternal(tblInfo, fieldInfo, oldFieldName);
    }

    protected DBTableChildIFace getFieldInfoInternal(DBTableInfo tblInfo, FormFieldInfo fieldInfo, String oldFieldName) {
        DBTableChildIFace childInfo = null;
        if (tblInfo != null && (childInfo = tblInfo.getItemByName(oldFieldName)) == null) {
            TableInfoMapping tblMapping = this.tblNameNewToOldHash.get(tblInfo.getName());
            if (tblMapping != null) {
                String newChildName = tblMapping.getNewName(oldFieldName);
                if (newChildName != null) {
                    childInfo = tblInfo.getItemByName(newChildName);
                    if (childInfo == null) {
                        log.error((Object)("getFieldInfo - New Child Name that was mapped wasn't found in DBTableInfo: [" + newChildName + "] tbl: [" + tblInfo.getName() + "]"));
                    }
                } else {
                    log.error((Object)("getFieldInfo - Old Child Name wasn't mapped: [" + oldFieldName + "] tbl: [" + tblInfo.getName() + "]"));
                }
            } else {
                log.error((Object)("getFieldInfo - New Table Name: " + tblInfo.getName() + " was not mapped in Hash."));
            }
        }
        return childInfo;
    }

    protected void startup() {
        try {
            SpecifyDBConverter converter = new SpecifyDBConverter();
            if (converter.selectedDBsToConvert(true)) {
                this.namePair = converter.chooseTable("Select a DB for Forms", "Select a Form", true);
                this.hostName = converter.getHostName();
                this.itUsrPwd = converter.getItUsrPwd();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showConfirmDialog(null, "The Converter was unable to login.", "Error", -1);
        }
        if (this.namePair != null) {
            DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver("MySQL");
            String oldConnStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, this.hostName, (String)this.namePair.second, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverInfo.getName());
            if (!UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), (String)this.namePair.second, oldConnStr, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second)) {
                log.error((Object)("Failed connection string: " + driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, this.hostName, (String)this.namePair.second, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverInfo.getName())));
                throw new RuntimeException("Couldn't login into [" + (String)this.namePair.second + "] " + DBConnection.getInstance().getErrorMsg());
            }
            this.process();
        } else {
            JOptionPane.showConfirmDialog(null, "The Converter was unable to login.", "Error", -1);
            System.exit(0);
        }
    }

    protected static DBConnection getNewDBConnection() {
        Pair<String, String> namePair = null;
        Pair<String, String> usrNmPwd = null;
        SpecifyDBConverter converter = new SpecifyDBConverter();
        try {
            if (converter.selectedDBsToConvert(true)) {
                namePair = converter.chooseTable("Choose", "Select a Specify 6 Database", false);
                usrNmPwd = converter.getItUsrPwd();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showConfirmDialog(null, "The Sp5Forms was unable to login.", "Error", -1);
        }
        if (namePair != null) {
            DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver("MySQL");
            String oldConnStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, converter.getHostName(), (String)namePair.second, (String)usrNmPwd.first, (String)usrNmPwd.second, driverInfo.getName());
            DBConnection dbConn = DBConnection.createInstance(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), (String)namePair.second, oldConnStr, (String)usrNmPwd.first, (String)usrNmPwd.second);
            Connection connection = dbConn.createConnection();
            if (connection != null) {
                try {
                    connection.close();
                    return dbConn;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private void openDB() {
        this.startup();
        this.formsTable.setModel(new FormCellModel(this.forms));
    }

    private void openXML() {
        FileDialog fileDlg = new FileDialog((Frame)UIRegistry.getTopWindow(), "", 0);
        fileDlg.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        fileDlg.setVisible(true);
        String fileName = fileDlg.getFile();
        if (fileName != null) {
            File iFile = new File(String.valueOf(fileDlg.getDirectory()) + File.separator + fileName);
            XStream xstream = new XStream();
            FormInfo.configXStream(xstream);
            FormFieldInfo.configXStream(xstream);
            try {
                this.forms = (Vector)xstream.fromXML((InputStream)FileUtils.openInputStream((File)iFile));
                this.formsTable.setModel(new FormCellModel(this.forms));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveXML() {
        XStream xstream = new XStream();
        FormInfo.configXStream(xstream);
        FormFieldInfo.configXStream(xstream);
        try {
            String dbName = String.valueOf(DBConnection.getInstance().getDatabaseName()) + ".xml";
            PrintWriter pw = new PrintWriter(new File(dbName));
            xstream.toXML(this.forms, (Writer)pw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void doCreateFormImages() {
        boolean doJustIndex = false;
        if (doJustIndex) {
            this.createIndex();
            return;
        }
        this.formIndex = 0;
        this.advance();
    }

    public synchronized void advance() {
        boolean doSkip;
        if (this.timer != null) {
            System.out.println("Task Cancelled. " + this.timer.hashCode());
            this.timer.cancel();
        }
        if (this.formIndex >= 0) {
            this.generate();
        }
        if (doSkip = false) {
            FormInfo fi;
            do {
                ++this.formIndex;
                System.out.println(this.formIndex);
                if (this.formIndex < this.forms.size()) continue;
                System.out.println("***** Done");
                this.generate();
                return;
            } while (!(fi = this.forms.get(this.formIndex)).isFull() && this.formIndex < this.forms.size());
        } else {
            ++this.formIndex;
            System.out.println(this.formIndex);
            if (this.formIndex >= this.forms.size()) {
                System.out.println("***** Done");
                this.generate();
                this.createIndex();
                return;
            }
        }
        this.timer = new Timer();
        System.out.println("Scheduling next task. " + this.timer.hashCode());
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                System.out.println("***** Timer Done");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Sp5Forms.this.advance();
                    }
                });
            }
        }, 1500L);
    }

    public void generate() {
        File dir;
        BufferedImage bufImage = null;
        if (this.formFrame != null) {
            Container topComp = this.formFrame.getContentPane();
            Rectangle rect = topComp.getBounds();
            if (rect.width < 1 || rect.height < 1) {
                System.err.println("Can't create image. " + this.selectedForm.getTitle());
            } else {
                bufImage = new BufferedImage(rect.width, rect.height, 2);
                Graphics2D g2 = bufImage.createGraphics();
                ((Component)topComp).paint(g2);
                g2.dispose();
            }
        }
        if (this.formIndex < this.forms.size()) {
            this.selectedForm = this.forms.get(this.formIndex);
            this.showForm();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            (this).Sp5Forms.this.formFrame.pack();
                            (this).Sp5Forms.this.formFrame.repaint();
                        }
                    });
                }
            });
        }
        if (!(dir = new File("conversions" + File.separator + (String)this.namePair.second + "_6" + File.separator + "forms")).exists()) {
            dir.mkdirs();
        }
        if (bufImage != null) {
            String fName = String.valueOf(dir.getAbsolutePath()) + File.separator + this.formName + ".png";
            try {
                File imgFile = new File(fName);
                ImageIO.write((RenderedImage)bufImage, "PNG", imgFile);
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ERDVisualizer.class, e);
                e.printStackTrace();
            }
        }
        if (this.formIndex >= this.forms.size()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).Sp5Forms.this.formFrame != null) {
                                (this).Sp5Forms.this.formFrame.setVisible(false);
                            }
                            Sp5Forms.this.createIndex();
                            UIRegistry.showLocalizedMsg("Done");
                        }
                    });
                }
            });
        }
        if (this.selectedForm != null) {
            this.formName = this.selectedForm.getFileName();
        }
    }

    private void createIndex() {
        String dirName = "conversions" + File.separator + (String)this.namePair.second + "_6" + File.separator + "forms";
        String fName = String.valueOf(dirName) + File.separator + "index.html";
        try {
            File dir = new File(dirName);
            PrintWriter pw = new PrintWriter(new File(fName));
            pw.println("<html><body><h2>Forms For " + (String)this.namePair.second + "</h2><table border='0'>");
            Vector fileList = new Vector();
            Collections.addAll(fileList, dir.list());
            Collections.sort(fileList);
            for (String fileName : fileList) {
                if (!fileName.endsWith("png")) continue;
                String name = FilenameUtils.getBaseName((String)fileName);
                pw.print("<tr><td>");
                pw.print("<a href='");
                pw.print(fileName);
                pw.print("'>");
                pw.print(name);
                pw.println("</a></td></tr>");
            }
            pw.println("</body></html>");
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doAbout() {
    }

    @Override
    public boolean doExit(boolean doAppExit) {
        System.exit(0);
        return true;
    }

    @Override
    public void doPreferences() {
    }

    public static void main(String[] args) {
        Logger logger;
        String appdatadir;
        UIRegistry.setAppName("Specify");
        log.debug((Object)("********* Current [" + new File(".").getAbsolutePath() + "]"));
        UIRegistry.setEmbeddedDBPath(UIRegistry.getDefaultEmbeddedDBPath());
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] pairs = s.split("=");
            if (pairs.length == 2) {
                if (pairs[0].startsWith("-D")) {
                    System.setProperty(pairs[0].substring(2, pairs[0].length()), pairs[1]);
                }
            } else {
                String symbol = pairs[0].substring(2, pairs[0].length());
                System.setProperty(symbol, symbol);
            }
            ++n2;
        }
        String appDir = System.getProperty("appdir");
        if (StringUtils.isNotEmpty((String)appDir)) {
            UIRegistry.setDefaultWorkingPath(appDir);
        }
        if (StringUtils.isNotEmpty((String)(appdatadir = System.getProperty("appdatadir")))) {
            UIRegistry.setBaseAppDataDir(appdatadir);
        }
        if ((logger = LogManager.getLogger((String)"edu.ku.brc")) != null) {
            logger.setLevel(Level.ALL);
            System.out.println("Setting " + logger.getName() + " to " + logger.getLevel());
        }
        if ((logger = LogManager.getLogger(HibernateUtil.class)) != null) {
            logger.setLevel(Level.INFO);
            System.out.println("Setting " + logger.getName() + " to " + logger.getLevel());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!System.getProperty("os.name").equals("Mac OS X")) {
                        UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
                    }
                    final Sp5Forms frame = new Sp5Forms();
                    frame.setDefaultCloseOperation(3);
                    frame.setBounds(0, 0, 800, 800);
                    new MacOSAppHandler(frame);
                    frame.startup();
                    frame.createUI();
                    JMenuBar mb = new JMenuBar();
                    JMenu fileMenu = new JMenu("File");
                    JMenuItem openMI = new JMenuItem("Open XML File");
                    fileMenu.add(openMI);
                    openMI.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            frame.openXML();
                        }
                    });
                    JMenuItem openDBMI = new JMenuItem("Open Database");
                    fileMenu.add(openDBMI);
                    openDBMI.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            frame.openDB();
                        }
                    });
                    JMenuItem saveMI = new JMenuItem("Save");
                    fileMenu.add(saveMI);
                    saveMI.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            frame.saveXML();
                        }
                    });
                    if (!UIHelper.isMacOS()) {
                        fileMenu.addSeparator();
                        JMenuItem mi = new JMenuItem("Exit");
                        fileMenu.add(mi);
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                System.exit(0);
                            }
                        });
                    }
                    mb.add(fileMenu);
                    frame.setJMenuBar(mb);
                    UIHelper.centerAndShow(frame);
                }
                catch (Exception e) {
                    log.error((Object)"Can't change L&F: ", (Throwable)e);
                }
            }
        });
    }

    class FormPanelInfo {
        private String title;
        private JPanel panel;
        private int maxHeight;
        private int maxWidth;

        public FormPanelInfo(String title, JPanel panel, int maxHeight, int maxWidth) {
            this.title = title;
            this.panel = panel;
            this.maxHeight = maxHeight;
            this.maxWidth = maxWidth;
        }

        public String getTitle() {
            return this.title;
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }
    }

    public class Sp6FieldComboBoxEditor
    extends DefaultCellEditor {
        public Sp6FieldComboBoxEditor() {
            super(new JComboBox(new DefaultComboBoxModel()));
        }
    }

    public class Sp6FieldComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public Sp6FieldComboBoxRenderer() {
            super(new DefaultComboBoxModel());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

