/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps.sp5utils;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.utilapps.sp5utils.FormFieldInfo;
import edu.ku.brc.specify.utilapps.sp5utils.FormInfo;
import edu.ku.brc.specify.utilapps.sp5utils.Sp5Forms;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;

public class SchemaLocaleUpdater
extends CustomDialog {
    protected JTable table;
    protected DefaultTableModel tblModel;
    protected Vector<FormFieldInfo> fields = new Vector();
    protected FormInfo formInfo;
    protected JButton hideAll;
    protected JButton showAll;
    protected JButton showSp5Items;

    public SchemaLocaleUpdater(FormInfo formInfo) throws HeadlessException {
        super((Frame)null, "Update Schema Localizer", true, 3, (Component)null);
        HashMap<String, FormFieldInfo> ffiHash = new HashMap<String, FormFieldInfo>();
        for (FormFieldInfo ffi : formInfo.getFields()) {
            this.fields.add(ffi);
            ffiHash.get(ffi.getSp6FieldName());
        }
        DBTableInfo tblInfo = formInfo.getTblInfo();
        if (tblInfo != null) {
            FormFieldInfo ffi;
            for (DBFieldInfo fldInfo : tblInfo.getFields()) {
                if (!StringUtils.isNotEmpty((String)fldInfo.getColumn()) || ffiHash.get(fldInfo.getColumn()) != null) continue;
                ffi = new FormFieldInfo(fldInfo.getColumn(), fldInfo.getTitle(), fldInfo.isHidden());
                this.fields.add(ffi);
                ffiHash.put(fldInfo.getColumn(), ffi);
            }
            for (DBRelationshipInfo relInfo : tblInfo.getRelationships()) {
                if (!StringUtils.isNotEmpty((String)relInfo.getColName())) continue;
                ffi = new FormFieldInfo(relInfo.getColName(), relInfo.getTitle(), relInfo.isHidden());
                this.fields.add(ffi);
                ffiHash.put(relInfo.getColName(), ffi);
            }
        }
    }

    @Override
    public void createUI() {
        super.createUI();
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,2px,f:p:g,4px,p"));
        this.tblModel = new FieldsModel();
        this.table = new JTable(this.tblModel);
        pb.add((Component)UIHelper.createScrollPane(this.table), cc.xy(1, 3));
        PanelBuilder pbBtn = new PanelBuilder(new FormLayout("f:p:g,p,4px,p,4px,p", "p"));
        this.hideAll = UIHelper.createButton("Hide All");
        pbBtn.add((Component)this.hideAll, cc.xy(2, 1));
        this.showAll = UIHelper.createButton("Show All");
        pbBtn.add((Component)this.showAll, cc.xy(4, 1));
        this.showSp5Items = UIHelper.createButton("Show Sp5 Fields");
        pbBtn.add((Component)this.showSp5Items, cc.xy(6, 1));
        pb.add((Component)pbBtn.getPanel(), cc.xy(1, 5));
        pb.setDefaultDialogBorder();
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.hideAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (FormFieldInfo ffi : SchemaLocaleUpdater.this.fields) {
                    ffi.setIsHidden(true);
                }
                SchemaLocaleUpdater.this.tblModel.fireTableDataChanged();
            }
        });
        this.showAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (FormFieldInfo ffi : SchemaLocaleUpdater.this.fields) {
                    ffi.setIsHidden(false);
                }
                SchemaLocaleUpdater.this.tblModel.fireTableDataChanged();
            }
        });
        this.showSp5Items.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (FormFieldInfo ffi : SchemaLocaleUpdater.this.fields) {
                    if (ffi.getSp5FieldName() == null) continue;
                    ffi.setIsHidden(false);
                }
                SchemaLocaleUpdater.this.tblModel.fireTableDataChanged();
            }
        });
    }

    protected void updateSchema() {
        DBConnection newConn = Sp5Forms.getNewDBConnection();
        if (newConn != null) {
            newConn.close();
        }
    }

    class FieldsModel
    extends DefaultTableModel {
        protected String[] header = new String[]{"Sp6 Caption", "Sp6 Name", "Hidden"};

        FieldsModel() {
        }

        @Override
        public int getColumnCount() {
            return this.header != null ? this.header.length : 0;
        }

        @Override
        public String getColumnName(int column) {
            return this.header != null ? this.header[column] : "";
        }

        @Override
        public int getRowCount() {
            return SchemaLocaleUpdater.this.fields != null ? SchemaLocaleUpdater.this.fields.size() : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            FormFieldInfo ffi = SchemaLocaleUpdater.this.fields.get(row);
            switch (column) {
                case 0: {
                    return ffi.getCaption();
                }
                case 1: {
                    return ffi.getSp6FieldName();
                }
                case 2: {
                    return ffi.getIsHidden();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0 || column == 2;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            FormFieldInfo ffi = SchemaLocaleUpdater.this.fields.get(row);
            switch (column) {
                case 0: {
                    ffi.setCaption((String)value);
                    break;
                }
                case 1: {
                    ffi.setSp6FieldName((String)value);
                    break;
                }
                case 2: {
                    ffi.setIsHidden((Boolean)value);
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return String.class;
        }
    }
}

