/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps.sp5utils;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.utilapps.sp5utils.FormFieldInfo;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class FormInfo {
    private String tableName;
    private String formVersion;
    private String formType;
    protected DBTableInfo tblInfo;
    ArrayList<FormFieldInfo> fields = new ArrayList();

    public FormInfo(String tableName, String formVersion, String formType, DBTableInfo tblInfo) {
        this.tableName = tableName;
        this.formVersion = formVersion;
        this.formType = formType;
        this.tblInfo = tblInfo;
    }

    public boolean isFull() {
        return this.formVersion != null && this.formVersion.equalsIgnoreCase("full");
    }

    public DBTableInfo getTblInfo() {
        return this.tblInfo;
    }

    public String toString() {
        return FormInfo.getUniqueKey(this.tableName, this.formVersion, this.formType);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFormVersion() {
        return this.formVersion;
    }

    public String getFormType() {
        return this.formType;
    }

    public ArrayList<FormFieldInfo> getFields() {
        return this.fields;
    }

    public String getTitle() {
        return String.valueOf(this.tableName) + (StringUtils.isNotEmpty((String)this.formVersion) ? " " + this.formVersion : "") + (StringUtils.isNotEmpty((String)this.formType) ? " " + this.formType : "");
    }

    public String getFileName() {
        return String.valueOf(this.tableName) + (StringUtils.isNotEmpty((String)this.formVersion) ? "_" + this.formVersion : "") + (StringUtils.isNotEmpty((String)this.formType) ? "_" + this.formType : "");
    }

    public static String getUniqueKey(String tableName, String formVersion, String formType) {
        return String.valueOf(tableName) + "/" + formVersion + (StringUtils.isNotEmpty((String)formType) ? "/" + formType : "");
    }

    public static void configXStream(XStream xstream) {
        xstream.alias("form", FormInfo.class);
        xstream.aliasAttribute(FormInfo.class, "tableName", "tableName");
        xstream.aliasAttribute(FormInfo.class, "formVersion", "formVersion");
        xstream.aliasAttribute(FormInfo.class, "formType", "formType");
    }
}

