/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps.sp5utils;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.specify.utilapps.sp5utils.FormInfo;
import java.awt.Rectangle;

public class FormFieldInfo {
    private static int segWidth = 10;
    private String sp5FieldName;
    private String sp6FieldName;
    private String caption;
    private String controlType;
    private String dataType;
    private String relatedTableName;
    private Integer top;
    private Integer left;
    private Integer width;
    private Integer height;
    private Integer controlTypeNum;
    private Integer dataTypeNum;
    private Boolean isHidden;
    private FormInfo parent;
    private boolean hasChanged = false;

    public FormFieldInfo(String sp5FieldName, String sp6FieldName, String caption, String controlType, String dataType, String relatedTableName, Integer top, Integer left, Integer width, Integer height, Integer controlTypeNum, Integer dataTypeNum) {
        this.sp5FieldName = sp5FieldName;
        this.sp6FieldName = sp6FieldName;
        this.caption = caption;
        this.controlType = controlType;
        this.dataType = dataType;
        this.relatedTableName = relatedTableName;
        this.top = top;
        this.left = left;
        this.width = width;
        this.height = height;
        this.controlTypeNum = controlTypeNum;
        this.dataTypeNum = dataTypeNum;
    }

    public FormFieldInfo(String sp6FieldName, String caption, Boolean isHidden) {
        this.sp5FieldName = null;
        this.sp6FieldName = sp6FieldName;
        this.caption = caption;
        this.controlType = null;
        this.dataType = null;
        this.relatedTableName = null;
        this.top = null;
        this.left = null;
        this.width = null;
        this.height = null;
        this.controlTypeNum = null;
        this.dataTypeNum = null;
        this.isHidden = isHidden;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public void setCaption(String caption) {
        this.caption = caption;
        this.hasChanged = true;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public void setIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
        this.hasChanged = true;
    }

    public void setTop(Integer top) {
        this.top = top;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public int getCellX() {
        return this.left / segWidth;
    }

    public int getCellY() {
        return this.top / segWidth;
    }

    public int getCellWidth() {
        return this.width / segWidth;
    }

    public int getCellHeight() {
        return this.height / segWidth;
    }

    public Rectangle getBoundsFromCellDim() {
        Rectangle r = new Rectangle(this.getCellX() * segWidth, this.getCellY() * segWidth, this.getCellWidth() * segWidth, this.getCellHeight() * segWidth);
        return r;
    }

    public void setSp6FieldName(String sp6FieldName) {
        this.sp6FieldName = sp6FieldName;
        this.hasChanged = true;
    }

    public void setParent(FormInfo parent) {
        this.parent = parent;
    }

    public String toString() {
        return this.sp5FieldName;
    }

    public String getSp5FieldName() {
        return this.sp5FieldName;
    }

    public String getSp6FieldName() {
        return this.sp6FieldName;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getControlType() {
        return this.controlType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getRelatedTableName() {
        return this.relatedTableName;
    }

    public Integer getTop() {
        return this.top;
    }

    public Integer getLeft() {
        return this.left;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getControlTypeNum() {
        return this.controlTypeNum;
    }

    public Integer getDataTypeNum() {
        return this.dataTypeNum;
    }

    public FormInfo getParent() {
        return this.parent;
    }

    public static int getSegWidth() {
        return segWidth;
    }

    public static void setSegWidth(int segWidth) {
        FormFieldInfo.segWidth = segWidth;
    }

    public static void configXStream(XStream xstream) {
        xstream.alias("field", FormFieldInfo.class);
        xstream.aliasAttribute(FormFieldInfo.class, "sp5FieldName", "sp5FieldName");
        xstream.aliasAttribute(FormFieldInfo.class, "sp6FieldName", "sp6FieldName");
        xstream.aliasAttribute(FormFieldInfo.class, "caption", "caption");
        xstream.aliasAttribute(FormFieldInfo.class, "controlType", "controlType");
        xstream.aliasAttribute(FormFieldInfo.class, "dataType", "dataType");
        xstream.aliasAttribute(FormFieldInfo.class, "relatedTableName", "relatedTableName");
        xstream.aliasAttribute(FormFieldInfo.class, "top", "top");
        xstream.aliasAttribute(FormFieldInfo.class, "left", "left");
        xstream.aliasAttribute(FormFieldInfo.class, "width", "width");
        xstream.aliasAttribute(FormFieldInfo.class, "height", "height");
        xstream.aliasAttribute(FormFieldInfo.class, "controlTypeNum", "controlTypeNum");
        xstream.aliasAttribute(FormFieldInfo.class, "dataTypeNum", "dataTypeNum");
        xstream.aliasAttribute(FormFieldInfo.class, "isHidden", "isHidden");
        xstream.omitField(FormFieldInfo.class, "parent");
    }
}

