/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps.morphbank;

import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.utilapps.morphbank.BatchAttachFiles;
import edu.ku.brc.specify.utilapps.morphbank.FileNameParserIFace;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;

public class SDStateFileNameParser
implements FileNameParserIFace {
    public static final int SpecPic = 0;
    public static final int DorsalPic = 1;
    public static final int VentralPic = 2;
    protected String prefix = "Picture Files/Specimen Pics/";
    protected int picType;
    protected String srchFieldName;
    protected String suffix;
    protected Connection testConnection;

    @Override
    public List<Integer> getRecordIds(String fileName) {
        String sql;
        Vector<Integer> result = new Vector<Integer>();
        String id = fileName.replace("_", "");
        id = String.valueOf(this.prefix) + fileName;
        Connection conn = this.testConnection != null ? this.testConnection : DBConnection.getInstance().getConnection();
        Vector<Object> idObjs = BasicSQLUtils.querySingleCol(conn, sql = "select CollectionObjectID from collectionobject co inner join collectionobjectattribute coa on coa.collectionobjectattributeid = co.collectionobjectattributeid where coa." + this.srchFieldName + " = '" + id + "'");
        if (idObjs != null) {
            for (Object idObj : idObjs) {
                result.add((Integer)idObj);
            }
        }
        return result;
    }

    @Override
    public Integer getTableId() {
        return CollectionObject.getClassTableId();
    }

    public Connection getTestConnection() {
        return this.testConnection;
    }

    public void setTestConnection(Connection testConnection) {
        this.testConnection = testConnection;
    }

    public static void main(String[] args) {
        String picDirName = "/media/Terror/ConversionsAndFixes/sdstate/SpSub31OCT10/PictureFiles/SpecimenPics";
        String[] exts = new String[]{"jpg", "JPG"};
        try {
            boolean fileExists;
            String fileName;
            File picDir = new File(picDirName);
            Vector<File> files = BatchAttachFiles.bldFilesFromDir(picDir, exts);
            SDStateFileNameParser p = new SDStateFileNameParser();
            String connStr = "jdbc:mysql://localhost/sdstate6202?characterEncoding=UTF-8&autoReconnect=true";
            Connection conn = DriverManager.getConnection(connStr, "Master", "Master");
            p.setTestConnection(conn);
            p.setPicType(0);
            int fileCount = 0;
            int filesOfTypeCount = 0;
            int idCount = 0;
            for (File f : files) {
                System.out.print(String.valueOf(f.getName()) + " - ");
                if (p.looksLikePicOfCurrentType(f.getName())) {
                    ++filesOfTypeCount;
                }
                List<Integer> ids = p.getRecordIds(f.getName());
                for (Integer id : ids) {
                    System.out.print(id + ", ");
                    ++idCount;
                }
                System.out.println();
                ++fileCount;
            }
            System.out.println("files: " + fileCount + ", files of type: " + filesOfTypeCount + ", ids: " + idCount);
            String sql = "select distinct text3 from collectionobjectattribute where text3 is not null order by 1";
            Vector<Object> fileNamesFromDB = BasicSQLUtils.querySingleCol(conn, sql);
            Vector<String> missingFiles = new Vector<String>();
            for (Object dbFileNameObj : fileNamesFromDB) {
                fileName = ((String)dbFileNameObj).replace("Picture Files/Specimen Pics/", "");
                fileExists = false;
                for (File f : files) {
                    if (!f.getName().equalsIgnoreCase(fileName)) continue;
                    fileExists = true;
                    break;
                }
                if (fileExists) continue;
                missingFiles.add(fileName);
            }
            sql = "select distinct text1 from collectionobjectattribute where text1 is not null order by 1";
            fileNamesFromDB = BasicSQLUtils.querySingleCol(conn, sql);
            for (Object dbFileNameObj : fileNamesFromDB) {
                fileName = ((String)dbFileNameObj).replace("Picture Files/Specimen Pics/", "");
                fileExists = false;
                for (File f : files) {
                    if (!f.getName().equalsIgnoreCase(fileName)) continue;
                    fileExists = true;
                    break;
                }
                if (fileExists) continue;
                missingFiles.add(fileName);
            }
            sql = "select distinct text2 from collectionobjectattribute where text2 is not null order by 1";
            fileNamesFromDB = BasicSQLUtils.querySingleCol(conn, sql);
            for (Object dbFileNameObj : fileNamesFromDB) {
                fileName = ((String)dbFileNameObj).replace("Picture Files/Specimen Pics/", "");
                fileExists = false;
                for (File f : files) {
                    if (!f.getName().equalsIgnoreCase(fileName)) continue;
                    fileExists = true;
                    break;
                }
                if (fileExists) continue;
                missingFiles.add(fileName);
            }
            System.out.println("There are " + missingFiles.size() + " missing files: ");
            for (String mf : missingFiles) {
                System.out.println(mf);
            }
            FileUtils.writeLines((File)new File("/media/Terror/ConversionsAndFixes/sdstate/MissingFiles.txt"), missingFiles);
            sql = "select distinct Title from attachment order by 1";
            Vector<Object> filesAttached = BasicSQLUtils.querySingleCol(conn, sql);
            Vector<String> filesNotAttached = new Vector<String>();
            for (File f : files) {
                String fName = f.getName();
                boolean fileWasAttached = false;
                for (Object obj : filesAttached) {
                    if (!fName.equalsIgnoreCase(obj.toString())) continue;
                    fileWasAttached = true;
                    break;
                }
                if (fileWasAttached) continue;
                filesNotAttached.add(fName);
            }
            System.out.println("Files that were not attached:");
            for (String fna : filesNotAttached) {
                System.out.println(fna);
            }
            FileUtils.writeLines((File)new File("/media/Terror/ConversionsAndFixes/sdstate/UnattachedFiles.txt"), filesNotAttached);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getPicType() {
        return this.picType;
    }

    public boolean looksLikePicOfCurrentType(String fileName) {
        return fileName.endsWith(String.valueOf(this.suffix) + ".jpg") || fileName.endsWith(String.valueOf(this.suffix) + " .jpg") || fileName.endsWith(String.valueOf(this.suffix) + ".JPG") || fileName.endsWith(String.valueOf(this.suffix) + " .JPG") || fileName.endsWith(String.valueOf(this.suffix.toLowerCase()) + ".jpg") || fileName.endsWith(String.valueOf(this.suffix.toLowerCase()) + " .jpg") || fileName.endsWith(String.valueOf(this.suffix.toLowerCase()) + ".JPG") || fileName.endsWith(String.valueOf(this.suffix.toLowerCase()) + " .JPG");
    }

    public void setPicType(int picType) {
        this.picType = picType;
        if (picType == 0) {
            this.srchFieldName = "Text3";
            this.suffix = "S";
        } else if (picType == 1) {
            this.srchFieldName = "Text1";
            this.suffix = "D";
        } else {
            this.srchFieldName = "Text2";
            this.suffix = "V";
        }
    }
}

