/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps.morphbank;

import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionObjectAttachment;
import edu.ku.brc.specify.plugins.morphbank.CollectionObjectFieldMapper;
import edu.ku.brc.specify.plugins.morphbank.DwcMapper;
import edu.ku.brc.specify.plugins.morphbank.MorphBankTest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import net.morphbank.mbsvc3.xml.Credentials;
import net.morphbank.mbsvc3.xml.Request;
import net.morphbank.mbsvc3.xml.XmlUtils;
import org.apache.commons.io.FileUtils;

public class BatchMorphbankSubmit {
    protected final int requestsPerFile;
    protected final Class<?> tblClass;
    protected final Class<?> attachmentClass;
    protected final List<Integer> keysToSubmit;
    protected final String fileNameBase;
    protected final File destinationDir;
    protected final int dwcMapId;
    protected DwcMapper dwcMapper = null;
    protected Integer mbUserID = 691554;
    protected Integer mbGroupID = 692592;

    public BatchMorphbankSubmit(int requestsPerFile, Class<?> tblClass, Class<?> attachmentClass, List<Integer> keysToSubmit, String fileNameBase, File destinationDir, int dwcMapId) {
        this.requestsPerFile = requestsPerFile;
        this.tblClass = tblClass;
        this.attachmentClass = attachmentClass;
        this.keysToSubmit = keysToSubmit;
        this.fileNameBase = fileNameBase;
        this.destinationDir = destinationDir;
        this.dwcMapId = dwcMapId;
        this.dwcMapper = new DwcMapper(dwcMapId);
    }

    public void generateSubmissions() throws Exception {
        if (!this.tblClass.equals(CollectionObject.class)) {
            throw new Exception("Class not supported: " + this.tblClass.getName());
        }
        Vector<Request> submissions = new Vector<Request>();
        int counter = 0;
        int fileCount = 1;
        for (Integer key : this.keysToSubmit) {
            try {
                submissions.add(this.generateSubmission(key));
                if (++counter != this.requestsPerFile) continue;
                this.writeToFile(submissions, fileCount++);
                submissions.clear();
                counter = 0;
            }
            catch (DwcMapper.MissingRecordException mrex) {
                System.out.println(mrex.getMessage());
            }
        }
        if (counter > 0) {
            this.writeToFile(submissions, fileCount);
        }
    }

    protected Request generateSubmission(Integer key) throws Exception {
        return MorphBankTest.createRequestFromCollectionObjectId(key, new Credentials(691554, 692592), new Credentials(this.mbUserID.intValue(), this.mbGroupID.intValue()), this.dwcMapper);
    }

    protected void writeToFile(List<Request> submissions, int fileNum) throws IOException {
        String num = String.valueOf(fileNum);
        while (num.length() < 4) {
            num = "0" + num;
        }
        String fileName = this.destinationDir + File.separator + this.fileNameBase + "_" + num + ".xml";
        FileWriter outFile = new FileWriter(fileName);
        PrintWriter out = new PrintWriter(outFile);
        for (Request request : submissions) {
            XmlUtils.printXml((PrintWriter)out, (Object)request);
        }
        out.close();
        outFile.close();
        File f = new File(fileName);
        List objLines = FileUtils.readLines((File)f);
        Vector<String> lines = new Vector<String>(objLines.size());
        for (Object obj : objLines) {
            lines.add((String)obj);
        }
        String header = (String)lines.get(0);
        String requestHeaderStart = "<mb:request xsi:";
        String requestFooter = "</mb:request>";
        String insertHeader = "<insert>";
        String insertFooter = "</insert>";
        int numLines = lines.size();
        int l = numLines - 1;
        while (l > 0) {
            String line = (String)lines.get(l);
            if (header.equals(line)) {
                lines.remove(l);
            } else if (line.trim().startsWith(requestHeaderStart)) {
                if (l > 2) {
                    lines.remove(l + 4);
                    lines.remove(l + 3);
                    lines.remove(l + 2);
                    lines.remove(l + 1);
                    lines.remove(l);
                } else {
                    lines.set(l, "<ns2:request xsi:schemaLocation=\"http://www.morphbank.net/mbsvc3/ http://www.morphbank.net/schema/mbsvc3.xsd\" xmlns:dwc=\"http://rs.tdwg.org/dwc/dwcore/\" xmlns:ns2=\"http://www.morphbank.net/mbsvc3/\" xmlns:dwcg=\"http://rs.tdwg.org/dwc/geospatial/\" xmlns:dwce=\"http://rs.tdwg.org/dwc/dwelement\" xmlns:dwcc=\"http://rs.tdwg.org/dwc/curatorial/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
                }
            } else if (requestFooter.equals(line.trim())) {
                if (l == numLines - 1) {
                    lines.set(l, "</ns2:request>");
                } else {
                    lines.remove(l);
                }
            } else if (insertFooter.equals(line.trim())) {
                if (l != numLines - 2) {
                    lines.remove(l);
                }
            } else if (insertHeader.equals(line.trim())) {
                if (l > 7) {
                    lines.remove(l + 4);
                    lines.remove(l + 3);
                    lines.remove(l + 2);
                    lines.remove(l + 1);
                    lines.remove(l);
                }
            } else if (line.contains("CatalogNumberNumeric")) {
                lines.set(l, line.replace(".0</", "</"));
            }
            --l;
        }
        FileUtils.writeLines((File)f, (String)"ISO-8859-1", lines);
    }

    public int getRequestsPerFile() {
        return this.requestsPerFile;
    }

    public Class<?> getTblClass() {
        return this.tblClass;
    }

    public Class<?> getAttachmentClass() {
        return this.attachmentClass;
    }

    public List<Integer> getKeysToSubmit() {
        return this.keysToSubmit;
    }

    public static void main(String[] args) {
        try {
            String connStr = "jdbc:mysql://localhost/auburn?characterEncoding=UTF-8&autoReconnect=true";
            CollectionObjectFieldMapper.connection = DwcMapper.connection = DriverManager.getConnection(connStr, "Master", "Master");
            Statement stmt = DwcMapper.connection.createStatement();
            ResultSet rs = stmt.executeQuery("select collectionobjectid from collectionobjectattachment order by 1");
            Vector<Integer> keys = new Vector<Integer>();
            while (rs.next()) {
                keys.add(rs.getInt(1));
            }
            rs.close();
            stmt.close();
            BatchMorphbankSubmit mbs = new BatchMorphbankSubmit(100, CollectionObject.class, CollectionObjectAttachment.class, keys, "auburn", new File("/media/Terror/ConversionsAndFixes/auburn"), 2);
            mbs.generateSubmissions();
            System.out.println("done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

