/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps.morphbank;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.DatabaseLoginListener;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.utilapps.morphbank.BarCodeFileNameParser;
import edu.ku.brc.specify.utilapps.morphbank.BatchAttachFiles;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.FileStoreAttachmentManager;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BatchAttachLauncher
implements DatabaseLoginListener {
    protected static final Logger log = Logger.getLogger(BatchAttachLauncher.class);

    @Override
    public void cancelled() {
        System.exit(0);
    }

    @Override
    public void loggedIn(Window window, String databaseName, String userName) {
        AppPreferences.shutdownRemotePrefs();
        if (window != null) {
            window.setVisible(false);
        }
        AppContextMgr.CONTEXT_STATUS status = AppContextMgr.getInstance().setContext(databaseName, userName, true, true, true);
        SpecifyAppPrefs.initialPrefs();
        if (status == AppContextMgr.CONTEXT_STATUS.OK) {
            if (AppContextMgr.getInstance().getClassObject(Discipline.class) == null) {
                return;
            }
            int disciplineeId = AppContextMgr.getInstance().getClassObject(Discipline.class).getDisciplineId();
            SchemaI18NService.getInstance().loadWithLocale(SpLocaleContainer.CORE_SCHEMA, disciplineeId, DBTableIdMgr.getInstance(), Locale.getDefault());
        } else if (status == AppContextMgr.CONTEXT_STATUS.Error && AppContextMgr.getInstance().getClassObject(Collection.class) == null) {
            JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("Specify.LOGIN_USER_MISMATCH"), UIRegistry.getResourceString("Specify.LOGIN_USER_MISMATCH_TITLE"), 0);
            System.exit(0);
        }
        boolean canOpen = true;
        if (AppContextMgr.isSecurityOn()) {
            PermissionSettings permissions = SecurityMgr.getInstance().getPermission("Task.ExportMappingTask");
            canOpen = permissions.canView();
        }
        Thumbnailer thumb = new Thumbnailer();
        File thumbnailDir = null;
        try {
            thumbnailDir = XMLHelper.getConfigDir("thumbnail_generators.xml");
            thumb.registerThumbnailers(thumbnailDir);
        }
        catch (Exception e1) {
            throw new RuntimeException("Couldn't find thumbnailer xml [" + (thumbnailDir != null ? thumbnailDir.getAbsolutePath() : "") + "]");
        }
        thumb.setQuality(0.5f);
        thumb.setMaxHeight(128);
        thumb.setMaxWidth(128);
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        FileStoreAttachmentManager attachMgr = null;
        File attachmentLocation = null;
        File location = UIRegistry.getAppDataSubDir("AttachmentStorage", true);
        try {
            String path = localPrefs.get("attachment.path", null);
            File file = attachmentLocation = path != null && !UIRegistry.isMobile() ? new File(path) : location;
            if (!AttachmentUtils.isAttachmentDirMounted(attachmentLocation)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UIRegistry.showLocalizedError("AttachmentUtils.LOC_BAD");
                    }
                });
            } else {
                attachMgr = new FileStoreAttachmentManager(attachmentLocation);
            }
            if (path == null) {
                localPrefs.put("attachment.path", location.getAbsolutePath());
            }
        }
        catch (IOException e1) {
            log.warn((Object)("Problems setting the FileStoreAttachmentManager at [" + location + "]"));
        }
        AttachmentUtils.setAttachmentManager(attachMgr);
        AttachmentUtils.setThumbnailer(thumb);
        if (canOpen) {
            this.openBatchAttacher();
        } else {
            JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("SchemaExportLauncher.PERMISSION_DENIED"), UIRegistry.getResourceString("SchemaExportLauncher.PERMISSION_DENIED_TITLE"), 0);
            System.exit(0);
        }
    }

    protected void openBatchAttacher() {
        try {
            BatchAttachFiles baf = new BatchAttachFiles(CollectionObject.class, new BarCodeFileNameParser("altCatalogNumber"), new File("/media/Terror/ConversionsAndFixes/auburn/ImageFileNames.txt"));
            baf.attachFiles();
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            System.exit(-1);
        }
    }
}

