/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps.morphbank;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.AccessionAttachment;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectingEventAttachment;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionObjectAttachment;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.LocalityAttachment;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonAttachment;
import edu.ku.brc.specify.dbsupport.PostDeleteEventListener;
import edu.ku.brc.specify.dbsupport.PostInsertEventListener;
import edu.ku.brc.specify.dbsupport.PostUpdateEventListener;
import edu.ku.brc.specify.tools.export.ExportPanel;
import edu.ku.brc.specify.tools.ireportspecify.MainFrameSpecify;
import edu.ku.brc.specify.utilapps.morphbank.BatchAttachLauncher;
import edu.ku.brc.specify.utilapps.morphbank.FileNameParserIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.Pair;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;

public class BatchAttachFiles {
    protected static final Logger log = Logger.getLogger(BatchAttachFiles.class);
    protected static String[] exts = new String[]{"TIF", "JPG", "PNG", "jpg"};
    protected final Class<?> tblClass;
    protected final Class<?> attachmentClass;
    protected final FileNameParserIFace fnParser;
    protected final File directory;
    protected List<File> files;
    protected List<Pair<String, String>> errors = new Vector<Pair<String, String>>();
    protected DataProviderSessionIFace session;
    protected String errLogName = "errors";

    public BatchAttachFiles(Class<?> tblClass, FileNameParserIFace fnParser, File directory) throws Exception {
        this.tblClass = tblClass;
        this.fnParser = fnParser;
        this.directory = directory;
        this.attachmentClass = this.determineAttachmentClass();
        if (directory.isDirectory()) {
            this.files = BatchAttachFiles.bldFilesFromDir(directory, exts);
        } else {
            this.bldFilesFromList();
        }
    }

    protected Class<?> determineAttachmentClass() throws Exception {
        if (this.tblClass.equals(CollectionObject.class)) {
            return CollectionObjectAttachment.class;
        }
        throw new Exception(String.format(UIRegistry.getResourceString("BatchAttachFiles.ClassNotSupported"), this.tblClass.getName()));
    }

    public Class<?> getTblClass() {
        return this.tblClass;
    }

    public FileNameParserIFace getFnParser() {
        return this.fnParser;
    }

    public File getDirectory() {
        return this.directory;
    }

    public static Vector<File> bldFilesFromDir(File directory, String[] exts) {
        Vector<File> result = new Vector<File>();
        Collection fs = FileUtils.listFiles((File)directory, (String[])exts, (boolean)false);
        for (Object f : fs) {
            result.add((File)f);
        }
        return result;
    }

    protected void bldFilesFromList() throws IOException {
        this.files = new Vector<File>();
        List fileNames = FileUtils.readLines((File)this.directory);
        for (Object f : fileNames) {
            this.files.add(new File((String)f));
        }
    }

    public void attachFiles() throws Exception {
        this.errors.clear();
        for (File f : this.files) {
            this.attachFile(f);
        }
        if (this.errors.size() > 0) {
            Vector<String> errLines = new Vector<String>();
            for (Pair<String, String> error : this.errors) {
                String errLine = String.valueOf(error.getFirst()) + ": " + error.getSecond();
                System.out.println(errLine);
                errLines.add(errLine);
            }
            FileUtils.writeLines((File)new File(this.errLogName), errLines);
        } else {
            System.out.println("All files in the directory were attached.");
        }
    }

    protected void attachFile(File f) {
        List<Integer> ids = this.fnParser.getRecordIds(f.getName());
        if (ids.size() == 0) {
            this.errors.add(new Pair<String, String>(f.getName(), UIRegistry.getResourceString("BatchAttachFiles.FileNameParseError")));
            return;
        }
        for (Integer id : ids) {
            this.attachFileTo(f, id);
        }
    }

    public String getErrLogName() {
        return this.errLogName;
    }

    public void setErrLogName(String errLogName) {
        this.errLogName = errLogName;
    }

    protected ObjectAttachmentIFace<? extends DataModelObjBase> getAttachmentObject(Class<?> cls) {
        DataModelObjBase result = null;
        if (cls.equals(Accession.class)) {
            result = new AccessionAttachment();
        }
        if (cls.equals(Taxon.class)) {
            result = new TaxonAttachment();
        }
        if (cls.equals(Locality.class)) {
            result = new LocalityAttachment();
        }
        if (cls.equals(CollectingEvent.class)) {
            result = new CollectingEventAttachment();
        }
        if (cls.equals(CollectionObject.class)) {
            result = new CollectionObjectAttachment();
        }
        if (result != null) {
            ((DataModelObjBase)result).initialize();
        }
        return result;
    }

    protected void attachFileTo(File f, Integer attachTo) {
        block16: {
            DataProviderSessionIFace localSession = DataProviderFactory.getInstance().createSession();
            boolean tblTransactionOpen = false;
            if (localSession != null) {
                try {
                    AttachmentOwnerIFace<?> rec = this.getAttachmentOwner(localSession, attachTo);
                    localSession.beginTransaction();
                    tblTransactionOpen = true;
                    Set<?> attachees = rec.getAttachmentReferences();
                    int ordinal = 0;
                    Attachment attachment = new Attachment();
                    attachment.initialize();
                    if (f.exists()) {
                        attachment.setOrigFilename(f.getPath());
                    } else {
                        attachment.setOrigFilename(f.getName());
                    }
                    attachment.setTitle(f.getName());
                    ObjectAttachmentIFace<? extends DataModelObjBase> oaif = this.getAttachmentObject(rec.getClass());
                    oaif.setAttachment(attachment);
                    oaif.setObject((DataModelObjBase)((Object)rec));
                    oaif.setOrdinal(ordinal);
                    attachees.add(oaif);
                    BusinessRulesIFace busRule = DBTableIdMgr.getInstance().getBusinessRule(rec.getClass());
                    if (busRule != null) {
                        busRule.beforeSave(rec, localSession);
                    }
                    localSession.saveOrUpdate(rec);
                    if (busRule != null && !busRule.beforeSaveCommit(rec, localSession)) {
                        localSession.rollback();
                        throw new Exception("Business rules processing failed");
                    }
                    if (f.exists()) {
                        AttachmentUtils.getAttachmentManager().setStorageLocationIntoAttachment(oaif.getAttachment(), false);
                        oaif.getAttachment().storeFile(false);
                    }
                    localSession.commit();
                    tblTransactionOpen = false;
                    if (busRule != null) {
                        busRule.afterSaveCommit(rec, localSession);
                    }
                    attachees = null;
                    attachment = null;
                    rec = null;
                    oaif = null;
                }
                catch (HibernateException he) {
                    if (tblTransactionOpen) {
                        localSession.rollback();
                    }
                    this.errors.add(new Pair<String, String>(f.getName(), he.getLocalizedMessage()));
                    localSession.close();
                    break block16;
                }
                catch (Exception ex) {
                    try {
                        if (tblTransactionOpen) {
                            localSession.rollback();
                        }
                        this.errors.add(new Pair<String, String>(f.getName(), ex.getLocalizedMessage()));
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        localSession.close();
                    }
                }
                localSession.close();
                break block16;
            }
            this.errors.add(new Pair<String, String>(f.getName(), UIRegistry.getResourceString("BatchAttachFiles.UnableToAttach")));
        }
        System.out.println("attachFileTo Exit: " + Runtime.getRuntime().freeMemory());
    }

    protected AttachmentOwnerIFace<?> getAttachmentOwner(DataProviderSessionIFace sessionArg, Integer recId) {
        return (AttachmentOwnerIFace)sessionArg.get(this.tblClass, recId);
    }

    public static void main(String[] args) {
        String embeddeddbdir;
        String embeddedStr;
        String mobile;
        String appdatadir;
        log.debug((Object)("********* Current [" + new File(".").getAbsolutePath() + "]"));
        UIRegistry.setAppName("Specify");
        UIRegistry.setEmbeddedDBPath(UIRegistry.getDefaultEmbeddedDBPath());
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] pairs = s.split("=");
            if (pairs.length == 2) {
                if (pairs[0].startsWith("-D")) {
                    System.setProperty(pairs[0].substring(2, pairs[0].length()), pairs[1]);
                }
            } else {
                String symbol = pairs[0].substring(2, pairs[0].length());
                System.setProperty(symbol, symbol);
            }
            ++n2;
        }
        String appDir = System.getProperty("appdir");
        if (StringUtils.isNotEmpty((String)appDir)) {
            UIRegistry.setDefaultWorkingPath(appDir);
        }
        if (StringUtils.isNotEmpty((String)(appdatadir = System.getProperty("appdatadir")))) {
            UIRegistry.setBaseAppDataDir(appdatadir);
        }
        if (StringUtils.isNotEmpty((String)(mobile = System.getProperty("mobile")))) {
            UIRegistry.setMobile(true);
        }
        if (StringUtils.isNotEmpty((String)(embeddedStr = System.getProperty("embedded")))) {
            UIRegistry.setEmbedded(true);
        }
        if (StringUtils.isNotEmpty((String)(embeddeddbdir = System.getProperty("embeddeddbdir")))) {
            UIRegistry.setEmbeddedDBPath(embeddeddbdir);
        } else {
            UIRegistry.setEmbeddedDBPath(UIRegistry.getDefaultEmbeddedDBPath());
        }
        IconManager.setApplicationClass(Specify.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
        System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
        System.setProperty("edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory", "edu.ku.brc.specify.ui.SpecifyDraggableRecordIdentiferFactory");
        System.setProperty("edu.ku.brc.dbsupport.AuditInterceptor", "edu.ku.brc.specify.dbsupport.AuditInterceptor");
        System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
        System.setProperty("edu.ku.brc.ui.db.PickListDBAdapterFactory", "edu.ku.brc.specify.ui.db.PickListDBAdapterFactory");
        System.setProperty("edu.ku.brc.dbsupport.CustomQueryFactory", "edu.ku.brc.specify.dbsupport.SpecifyCustomQueryFactory");
        System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr");
        System.setProperty("edu.ku.brc.af.core.ExpressSearchSQLAdjuster", "edu.ku.brc.specify.dbsupport.SpecifyQueryAdjusterForDomain");
        System.setProperty("edu.ku.brc.af.core.SchemaI18NService", "edu.ku.brc.specify.config.SpecifySchemaI18NService");
        System.setProperty("edu.ku.brc.ui.weblink.WebLinkMgr", "edu.ku.brc.specify.config.SpecifyWebLinkMgr");
        System.setProperty("edu.ku.brc.af.auth.SecurityMgr", "edu.ku.brc.af.auth.specify.SpecifySecurityMgr");
        System.setProperty(DBMSUserMgr.factoryName, "edu.ku.brc.dbsupport.MySQLDMBSUserMgr");
        System.setProperty("edu.ku.brc.af.core.db.SchmeaUpdateService", "edu.ku.brc.specify.dbsupport.SpecifySchemaUpdateService");
        System.setProperty("edu.ku.brc.af.core.CollectionObjLSIDGenFactory", "edu.ku.brc.specify.config.SpecifyLSIDGeneratorFactory");
        final AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        BatchAttachFiles.adjustLocaleFromPrefs();
        final String iRepPrefDir = localPrefs.getDirPath();
        int mark = iRepPrefDir.lastIndexOf(UIRegistry.getAppName(), iRepPrefDir.length());
        final String SpPrefDir = String.valueOf(iRepPrefDir.substring(0, mark)) + "Specify";
        HibernateUtil.setListener("post-commit-update", new PostUpdateEventListener());
        HibernateUtil.setListener("post-commit-insert", new PostInsertEventListener());
        HibernateUtil.setListener("post-commit-delete", new PostDeleteEventListener());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIHelper.OSTYPE osType = UIHelper.getOSType();
                    if (osType == UIHelper.OSTYPE.Windows) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                    } else if (osType == UIHelper.OSTYPE.Linux) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ExportPanel.class, e);
                    log.error((Object)"Can't change L&F: ", (Throwable)e);
                }
                DatabaseLoginPanel.MasterPasswordProviderIFace usrPwdProvider = new DatabaseLoginPanel.MasterPasswordProviderIFace(){

                    @Override
                    public boolean hasMasterUserAndPwdInfo(String username, String password, String dbName) {
                        if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
                            UserAndMasterPasswordMgr.getInstance().set(username, password, dbName);
                            boolean result = false;
                            try {
                                try {
                                    AppPreferences.getLocalPrefs().flush();
                                    AppPreferences.getLocalPrefs().setDirPath(SpPrefDir);
                                    AppPreferences.getLocalPrefs().setProperties(null);
                                    result = UserAndMasterPasswordMgr.getInstance().hasMasterUsernameAndPassword();
                                }
                                finally {
                                    AppPreferences.getLocalPrefs().flush();
                                    AppPreferences.getLocalPrefs().setDirPath(iRepPrefDir);
                                    AppPreferences.getLocalPrefs().setProperties(null);
                                }
                            }
                            catch (Exception e) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                                result = false;
                            }
                            return result;
                        }
                        return false;
                    }

                    @Override
                    public Pair<String, String> getUserNamePassword(String username, String password, String dbName) {
                        UserAndMasterPasswordMgr.getInstance().set(username, password, dbName);
                        Pair<String, String> result = null;
                        try {
                            try {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(SpPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                                result = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
                            }
                            finally {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(iRepPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                            }
                        }
                        catch (Exception e) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                            result = null;
                        }
                        return result;
                    }

                    @Override
                    public boolean editMasterInfo(String username, String dbName, boolean askFroCredentials) {
                        boolean result = false;
                        try {
                            try {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(SpPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                                result = UserAndMasterPasswordMgr.getInstance().editMasterInfo(username, dbName, askFroCredentials);
                            }
                            finally {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(iRepPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                            }
                        }
                        catch (Exception e) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                            result = false;
                        }
                        return result;
                    }
                };
                String nameAndTitle = UIRegistry.getResourceString("BatchAttachFiles.AppTitle");
                UIRegistry.setRelease(true);
                UIHelper.doLogin(usrPwdProvider, true, false, false, new BatchAttachLauncher(), Specify.getLargeIconName(), nameAndTitle, nameAndTitle, "SpecifyWhite32", "login");
                localPrefs.load();
            }
        });
    }

    protected static void adjustLocaleFromPrefs() {
        String language = AppPreferences.getLocalPrefs().get("locale.lang", null);
        if (language != null) {
            String country = AppPreferences.getLocalPrefs().get("locale.country", null);
            String variant = AppPreferences.getLocalPrefs().get("locale.var", null);
            Locale prefLocale = new Locale(language, country, variant);
            Locale.setDefault(prefLocale);
            UIRegistry.setResourceLocale(prefLocale);
        }
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, ex);
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
    }
}

