/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class UIControlTOHTML {
    protected String[] fileExt = new String[]{"_pt", "_pt_bz"};
    protected Langs currentLang = Langs.ePT;
    protected String englishXSLT = "specifyschema.xslt";
    protected String foreignXSLT = String.format("specifyschema%s.xslt", this.fileExt[this.currentLang.ordinal()]);
    protected String englishOUT = "SpecifySchema.html";
    protected String foreignOUT = String.format("SpecifySchema%s.html", this.fileExt[this.currentLang.ordinal()]);

    protected void process() throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        boolean doUIControls = false;
        boolean doForeign = false;
        String outFileName = "UIControls.html";
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (doUIControls) {
            Transformer transformer = tFactory.newTransformer(new StreamSource("src/edu/ku/brc/specify/utilapps/uicontrols.xslt"));
            transformer.transform(new StreamSource("UIControls.xml"), new StreamResult(new FileOutputStream("UIControls.html")));
        } else {
            String xsltFileName = doForeign ? this.foreignXSLT : this.englishXSLT;
            outFileName = doForeign ? this.foreignOUT : this.englishOUT;
            String filePath = "src/edu/ku/brc/specify/utilapps/" + xsltFileName;
            File transFile = new File(filePath);
            if (!transFile.exists()) {
                System.err.println("File path[" + filePath + "] doesn't exist!");
                System.exit(1);
            }
            System.out.println(filePath);
            Transformer transformer = tFactory.newTransformer(new StreamSource(filePath));
            try {
                String xmlStr = FileUtils.readFileToString((File)new File("config/specify_datamodel.xml"));
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = factory.newDocumentBuilder();
                InputSource inStream = new InputSource();
                inStream.setCharacterStream(new StringReader(xmlStr));
                Document doc1 = db.parse(inStream);
                transformer.transform(new DOMSource(doc1), new StreamResult(new FileOutputStream(outFileName)));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UIControlTOHTML.class, ex);
                ex.printStackTrace();
            }
        }
        System.out.println("** The output file[" + outFileName + "] is written.");
    }

    public static void main(String[] args) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        UIControlTOHTML uth = new UIControlTOHTML();
        uth.process();
    }

    protected static enum Langs {
        ePT,
        ePTBZ;

    }
}

