/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerXMLHelper;
import edu.ku.brc.specify.utilapps.ERDTable;
import edu.ku.brc.specify.utilapps.NodeInfo;
import java.awt.Font;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;

public class TableTracker {
    protected Vector<ERDTable> list;
    protected Font font;
    protected Hashtable<String, Boolean> usedHash = new Hashtable();
    protected Hashtable<String, NodeInfo> nodeInfoHash = new Hashtable();
    protected Hashtable<String, ERDTable> hash = new Hashtable();
    protected NodeInfo defaultNodeInfo = new NodeInfo();
    protected NodeInfo defaultSkipNodeInfo = new NodeInfo(true, false, false, true, null);
    protected DBTableIdMgr tableMgr;

    public TableTracker() {
        boolean doWorkBench = false;
        if (doWorkBench) {
            this.tableMgr = new DBTableIdMgr(false);
            this.tableMgr.initialize(new File(XMLHelper.getConfigDirPath("specify_workbench_datamodel.xml")));
            SchemaLocalizerXMLHelper schemaLocalizer = new SchemaLocalizerXMLHelper(SpLocaleContainer.WORKBENCH_SCHEMA, this.tableMgr);
            schemaLocalizer.load(true);
            schemaLocalizer.setTitlesIntoSchema();
        } else {
            this.tableMgr = DBTableIdMgr.getInstance();
        }
        this.font = new JLabel().getFont().deriveFont(11.0f);
        this.list = new Vector();
        this.defaultNodeInfo.setClassName("defaultNodeInfo");
        this.defaultNodeInfo.setClassName("defaultSkipNodeInfo");
        for (DBTableInfo tbl : this.tableMgr.getTables()) {
            ERDTable table = new ERDTable(tbl);
            table.build(this.font);
            this.list.add(table);
            this.hash.put(table.getTable().getClassName(), table);
        }
        Collections.sort(this.list);
    }

    public Hashtable<String, ERDTable> getHash() {
        return this.hash;
    }

    public Hashtable<String, Boolean> getUsedHash() {
        return this.usedHash;
    }

    public Vector<ERDTable> getList() {
        return this.list;
    }

    public ERDTable getTable(String name) {
        return this.hash.get("edu.ku.brc.specify.datamodel." + name);
    }

    public ERDTable getTableByClassName(String fullClassName) {
        return this.hash.get(fullClassName);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public NodeInfo getNodeInfo(ERDTable table) {
        if (table == null) {
            return this.defaultSkipNodeInfo;
        }
        NodeInfo ni = this.nodeInfoHash.get(table.getClassName());
        if (ni == null) {
            return this.defaultNodeInfo;
        }
        return ni;
    }

    protected void fillListFromTree(ERDTable table, Vector<ERDTable> nList) {
        nList.add(table);
        for (ERDTable kid : table.getKids()) {
            this.fillListFromTree(kid, nList);
        }
    }

    public Vector<ERDTable> getTreeAsList(ERDTable table) {
        Vector<ERDTable> nList = new Vector<ERDTable>();
        this.fillListFromTree(table, nList);
        return nList;
    }

    public NodeInfo getNodeInfo(String name) {
        ERDTable table = this.getTable(name);
        if (table != null) {
            NodeInfo ni = this.nodeInfoHash.get(table.getClassName());
            if (ni == null) {
                return this.defaultNodeInfo;
            }
            return ni;
        }
        return null;
    }

    public NodeInfo addNodeInfo(String name, boolean skip, boolean processKids, boolean alwaysAKid, boolean processAnyRel, ERDTable okWhenParent) {
        ERDTable table = this.getTable(name);
        if (table != null) {
            NodeInfo ni = new NodeInfo(skip, processKids, alwaysAKid, processAnyRel, okWhenParent);
            ni.setClassName(name);
            this.nodeInfoHash.put(table.getClassName(), ni);
            return ni;
        }
        System.out.println("Couldn't find [" + name + "]");
        return null;
    }
}

