/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.Journal;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.ReferenceWork;
import edu.ku.brc.specify.datamodel.Shipment;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonCitation;
import edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.FileStoreAttachmentManager;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.Session;

public class SiteGen {
    private final Logger log = Logger.getLogger(SiteGen.class);
    protected static Session session = null;
    protected static MyFmtMgr fmtMgr = null;
    protected SimpleDateFormat dateFormatter;
    protected Hashtable<Class<?>, Boolean> classHash = new Hashtable();
    protected String template = "";

    public SiteGen() {
        File dir = new File("site");
        if (!dir.exists()) {
            dir.mkdir();
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith("html") && !f.getName().startsWith("template")) {
                f.delete();
            }
            ++n2;
        }
        this.dateFormatter = new SimpleDateFormat("yyyy/MM/dd");
        try {
            this.template = FileUtils.readFileToString((File)new File("site/template.html"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected Writer createWriter(FormDataObjIFace dataObj) {
        BufferedWriter oFile = null;
        try {
            oFile = new BufferedWriter(new FileWriter(new File("site/" + this.makeFileName(dataObj))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return oFile;
    }

    protected void setUpSystemProperties() {
        System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
        System.setProperty("edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory", "edu.ku.brc.specify.ui.SpecifyDraggableRecordIdentiferFactory");
        System.setProperty("edu.ku.brc.dbsupport.AuditInterceptor", "edu.ku.brc.specify.dbsupport.AuditInterceptor");
        System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
        System.setProperty("edu.ku.brc.ui.db.PickListDBAdapterFactory", "edu.ku.brc.specify.ui.db.PickListDBAdapterFactory");
        System.setProperty("edu.ku.brc.dbsupport.CustomQueryFactory", "edu.ku.brc.specify.dbsupport.SpecifyCustomQueryFactory");
        System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.utilapps.LocalDiskUIFieldFormatterMgr");
        System.setProperty("edu.ku.brc.ui.forms.formatters.DataObjFieldFormatMgr", "edu.ku.brc.specify.config.SpecifyDataObjFieldFormatMgr");
    }

    public boolean setupDatabase(DatabaseDriverInfo driverInfo, String hostName, String dbName, String username, String password, String firstName, String lastName, String email, DisciplineType disciplineType) {
        this.log.info((Object)("Logging into " + dbName + "...."));
        String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Create, hostName, dbName);
        if (connStr == null) {
            connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, dbName);
        }
        Pair<String, String> usernamePassword = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
        if (!UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, connStr, (String)usernamePassword.first, (String)usernamePassword.second)) {
            this.log.info((Object)"Login Failed!");
            return false;
        }
        session = HibernateUtil.getCurrentSession();
        this.log.info((Object)("Creating database " + dbName + "...."));
        try {
            Thumbnailer thumb = new Thumbnailer();
            File thumbFile = XMLHelper.getConfigDir("thumbnail_generators.xml");
            thumb.registerThumbnailers(thumbFile);
            thumb.setQuality(0.5f);
            thumb.setMaxHeight(128);
            thumb.setMaxWidth(128);
            FileStoreAttachmentManager attachMgr = new FileStoreAttachmentManager(UIRegistry.getAppDataSubDir("AttachmentStorage", true));
            AttachmentUtils.setAttachmentManager(attachMgr);
            AttachmentUtils.setThumbnailer(thumb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        SpecifyAppPrefs.initialPrefs();
        fmtMgr = new MyFmtMgr();
        return true;
    }

    public void setUp() {
        UIRegistry.setAppName("Specify");
        this.setUpSystemProperties();
        DisciplineType disciplineType = DisciplineType.getDiscipline("fish");
        DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver("MySQL");
        this.setupDatabase(driverInfo, "localhost", "testfish", "rods", "rods", "rods", "rods", "guest@ku.edu", disciplineType);
    }

    protected Object getData(Field field, Object dataObj) throws Exception {
        try {
            String methodName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            Method method = dataObj.getClass().getMethod(methodName, null);
            if (method != null) {
                return method.invoke(dataObj, null);
            }
            this.log.error((Object)("Missing method add(Object) for this type of set [" + dataObj.getClass() + "]"));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    protected String formatFDI(FormDataObjIFace fdi) {
        if (this.classHash.get(fdi.getDataClass()) != null) {
            return "<a href=\"" + this.makeFileName(fdi) + "\">" + fdi.getIdentityTitle() + "</a>";
        }
        return fdi.getIdentityTitle();
    }

    protected String formatValue(Object data) {
        if (data instanceof FormDataObjIFace) {
            return this.formatFDI((FormDataObjIFace)data);
        }
        if (data instanceof String || data instanceof Integer) {
            return data.toString();
        }
        if (data instanceof Date) {
            return this.dateFormatter.format((Date)data);
        }
        if (data instanceof Calendar) {
            return this.dateFormatter.format(((Calendar)data).getTime());
        }
        if (data instanceof Float) {
            return String.format("%5.2f", data);
        }
        if (data instanceof Double) {
            return String.format("%5.2f", data);
        }
        return data.toString();
    }

    protected String makeFileName(FormDataObjIFace dataObj) {
        return String.valueOf(dataObj.getDataClass().getSimpleName()) + dataObj.getId() + ".html";
    }

    protected void processDataObj(FormDataObjIFace dataObj) {
        this.processDataObj(dataObj, true);
    }

    protected void processDataObj(FormDataObjIFace dataObj, boolean doChildrenSets) {
        StringBuilder sb = new StringBuilder();
        try {
            Object data;
            Field field;
            sb.append("<table>\n");
            Field[] fieldArray = dataObj.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                field = fieldArray[n2];
                if (!field.getName().endsWith("Id")) {
                    try {
                        data = this.getData(field, dataObj);
                        if (data != null && !(data instanceof Set)) {
                            sb.append("<tr><td align=\"right\">" + UIHelper.makeNamePretty(field.getName()) + ":</td><td nowrap=\"true\">" + this.formatValue(data) + "</td></tr>\n");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++n2;
            }
            sb.append("</table>\n");
            if (doChildrenSets) {
                fieldArray = dataObj.getClass().getDeclaredFields();
                n = fieldArray.length;
                n2 = 0;
                while (n2 < n) {
                    field = fieldArray[n2];
                    try {
                        Set set;
                        data = this.getData(field, dataObj);
                        if (data != null && data instanceof Set && (set = (Set)data).size() > 0) {
                            sb.append("<br/>" + UIHelper.makeNamePretty(field.getName()) + "<br/>\n");
                            sb.append("<table width=\"100%\" cellspacing=\"0\" class=\"brdr\">\n");
                            int cnt = 1;
                            for (Object setDataObj : set) {
                                String fdiStr = this.formatFDI((FormDataObjIFace)setDataObj);
                                sb.append("<tr><td class=\"brdr" + (cnt % 2 == 0 ? "even" : "odd") + "\">" + fdiStr + "</td></tr>\n");
                                ++cnt;
                            }
                            sb.append("</table>\n");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++n2;
                }
            }
            Writer output = this.createWriter(dataObj);
            String content = this.template;
            content = StringUtils.replace((String)content, (String)"<!-- Title -->", (String)dataObj.getIdentityTitle());
            content = StringUtils.replace((String)content, (String)"<!-- Content -->", (String)sb.toString());
            output.write(content);
            output.flush();
            output.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.log.info((Object)("Done " + this.makeFileName(dataObj)));
    }

    public void process(Class<?> clazz) {
        this.process(clazz, true);
    }

    public void process(Class<?> clazz, boolean doChildrenSets) {
        block21: {
            Connection connection = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBConnection.getInstance().createConnection();
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery("select " + clazz.getSimpleName() + "ID from " + clazz.getSimpleName().toLowerCase());
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        Object dataObj = session.createQuery("from " + clazz.getSimpleName() + " where id = " + id).list().get(0);
                        this.processDataObj((FormDataObjIFace)dataObj, doChildrenSets);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block21;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.log.info((Object)"Done");
    }

    public void process() {
        Collection collection = (Collection)session.createCriteria(Collection.class).list().get(0);
        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
        Class[] classes = new Class[]{CollectionObject.class, CollectingEvent.class, Determination.class, Preparation.class, Agent.class, Locality.class, Taxon.class, Storage.class, Geography.class, Collector.class, Shipment.class, TaxonCitation.class, ReferenceWork.class, Journal.class};
        this.process(classes);
    }

    public void process(Class<?>[] classes) {
        Class<?> cls;
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            cls = classArray[n2];
            this.classHash.put(cls, true);
            ++n2;
        }
        classArray = classes;
        n = classes.length;
        n2 = 0;
        while (n2 < n) {
            cls = classArray[n2];
            this.process(cls);
            ++n2;
        }
    }

    public void doAlphaIndexPage(Class<?> clazz, String fieldName) {
        StringBuilder sb;
        block25: {
            sb = new StringBuilder();
            Connection connection = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBConnection.getInstance().createConnection();
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery("select " + clazz.getSimpleName() + "ID, " + fieldName + " from " + clazz.getSimpleName().toLowerCase() + " order by " + fieldName + " asc");
                    char currChar = '_';
                    while (rs.next()) {
                        String name = rs.getString(2);
                        int id = rs.getInt(1);
                        if (StringUtils.isEmpty((String)name)) {
                            name = rs.getString(1);
                        }
                        if (currChar != name.charAt(0)) {
                            currChar = name.charAt(0);
                            sb.append("<br/>" + currChar + "<br/>\n");
                        }
                        sb.append("<a href=\"" + clazz.getSimpleName() + id + ".html\">" + name + "</a><br/>\n");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block25;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BufferedWriter oFile = null;
        try {
            oFile = new BufferedWriter(new FileWriter(new File("site/" + clazz.getSimpleName() + ".html")));
            String content = this.template;
            content = StringUtils.replace((String)content, (String)"<!-- Title -->", (String)clazz.getSimpleName());
            content = StringUtils.replace((String)content, (String)"<!-- Content -->", (String)sb.toString());
            oFile.write(content);
            ((Writer)oFile).flush();
            ((Writer)oFile).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.log.info((Object)"Done");
    }

    public static void main(String[] args) {
        SiteGen siteGen = new SiteGen();
        siteGen.setUp();
        siteGen.process();
        siteGen.doAlphaIndexPage(Taxon.class, "fullName");
        siteGen.doAlphaIndexPage(Geography.class, "name");
        siteGen.doAlphaIndexPage(Storage.class, "fullName");
        siteGen.doAlphaIndexPage(CollectionObject.class, "catalogNumber");
    }

    class MyFmtMgr
    extends SpecifyUIFieldFormatterMgr {
        public MyFmtMgr() {
            this.load();
        }

        @Override
        protected Element getDOM() throws Exception {
            return XMLHelper.readDOMFromConfigDir("backstop/uiformatters.xml");
        }

        public UIFieldFormatterIFace getFmt(String name) {
            return this.getFormatterInternal(name);
        }
    }
}

