/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.specify.utilapps.CollectionChoice;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

class SetUpBuildDlg
extends CustomDialog {
    protected String databaseName;
    protected DatabaseDriverInfo dbDriver;
    protected boolean isCancelled = false;
    protected String dbDriverName;
    protected Pair<String, String> dbUser;
    protected Pair<String, String> saUser;
    protected Pair<String, String> cmUser;
    protected JTextField dbUsernameTxtFld;
    protected JPasswordField dbPasswdTxtFld;
    protected JTextField saUsernameTxtFld;
    protected JPasswordField saPasswdTxtFld;
    protected JTextField usrUsernameTxtFld;
    protected JPasswordField usrPasswdTxtFld;
    protected JTextField databaseNameTxt;
    protected JComboBox drivers;
    protected JCheckBox extraCollectionsChk;
    protected Vector<DatabaseDriverInfo> driverList;
    protected boolean wasClosed = false;
    protected BuildSampleDatabase bldSampleDatabase;
    protected JTable choiceTable;
    protected Vector<UIFieldFormatterIFace> catNumFmtList;
    protected Hashtable<String, UIFieldFormatterIFace> catNumFmtHash = new Hashtable();
    protected Vector<CollectionChoice> collChoiceList = new Vector();
    protected Hashtable<String, UIFieldFormatterIFace> accNumFmtHash = new Hashtable();
    protected Vector<UIFieldFormatterIFace> accNumFmtList;
    protected Hashtable<String, String> catNumGrpHash = new Hashtable();
    protected Vector<String> catNumGrpList;
    protected Hashtable<String, String> accNumGrpHash = new Hashtable();
    protected Vector<String> accNumGrpList;

    public SetUpBuildDlg(String databaseName, String dbDriverName, Pair<String, String> dbUser, Pair<String, String> saUser, Pair<String, String> cmUser, BuildSampleDatabase bldSampleDatabase) {
        super((Frame)null, "Setup Collection", true, (Component)null);
        this.bldSampleDatabase = bldSampleDatabase;
        this.databaseName = databaseName;
        this.dbDriverName = dbDriverName;
        this.dbUser = dbUser;
        this.saUser = saUser;
        this.cmUser = cmUser;
    }

    @Override
    public void createUI() {
        super.createUI();
        Specify.setUpSystemProperties();
        UIFieldFormatterMgr.setDoingLocal(true);
        this.driverList = DatabaseDriverInfo.getDriversList();
        int inx = Collections.binarySearch(this.driverList, new DatabaseDriverInfo(this.dbDriverName, null, null, false, null));
        this.drivers = UIHelper.createComboBox(this.driverList);
        this.drivers.setSelectedIndex(inx);
        this.catNumFmtList = (Vector)UIFieldFormatterMgr.getInstance().getFormatterList(CollectionObject.class, "catalogNumber");
        Collections.sort(this.catNumFmtList, new Comparator<UIFieldFormatterIFace>(){

            @Override
            public int compare(UIFieldFormatterIFace o1, UIFieldFormatterIFace o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        for (UIFieldFormatterIFace fmt : this.catNumFmtList) {
            this.catNumFmtHash.put(fmt.getName(), fmt);
        }
        this.accNumFmtList = (Vector)UIFieldFormatterMgr.getInstance().getFormatterList(Accession.class, "accessionNumber");
        Collections.sort(this.accNumFmtList, new Comparator<UIFieldFormatterIFace>(){

            @Override
            public int compare(UIFieldFormatterIFace o1, UIFieldFormatterIFace o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        for (UIFieldFormatterIFace fmt : this.accNumFmtList) {
            this.accNumFmtHash.put(fmt.getName(), fmt);
        }
        this.catNumGrpList = new Vector();
        this.catNumGrpList.add("None");
        this.catNumGrpList.add("Cat Global");
        this.catNumGrpList.add("Cat Test Group #1");
        this.catNumGrpList.add("Cat Test Group #2");
        for (DisciplineType d : DisciplineType.getDisciplineList()) {
            this.catNumGrpList.add("Cat " + d.getTitle() + " Group");
        }
        this.accNumGrpList = new Vector();
        this.accNumGrpList.add("None");
        this.accNumGrpList.add("Acc Global");
        this.accNumGrpList.add("Acc Test Group #1");
        this.accNumGrpList.add("Acc Test Group #2");
        for (DisciplineType d : DisciplineType.getDisciplineList()) {
            this.accNumGrpList.add("Acc " + d.getTitle() + " Group");
        }
        this.databaseNameTxt = (JTextField)UIHelper.addAutoSelect(UIHelper.createTextField(this.databaseName, 15));
        this.dbUsernameTxtFld = (JTextField)UIHelper.addAutoSelect(UIHelper.createTextField((String)this.dbUser.first, 15));
        this.dbPasswdTxtFld = (JPasswordField)UIHelper.addAutoSelect(UIHelper.createPasswordField((String)this.dbUser.second, 15));
        this.saUsernameTxtFld = (JTextField)UIHelper.addAutoSelect(UIHelper.createTextField((String)this.saUser.first, 15));
        this.saPasswdTxtFld = (JPasswordField)UIHelper.addAutoSelect(UIHelper.createPasswordField((String)this.saUser.second, 15));
        this.usrUsernameTxtFld = (JTextField)UIHelper.addAutoSelect(UIHelper.createTextField((String)this.cmUser.first, 15));
        this.usrPasswdTxtFld = (JPasswordField)UIHelper.addAutoSelect(UIHelper.createPasswordField((String)this.cmUser.second, 15));
        this.extraCollectionsChk = UIHelper.createCheckBox("Create Extra Collections");
        this.extraCollectionsChk.setSelected(true);
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,p,10px,p,2px,p,10px,p,2px,p,p:g", String.valueOf(UIHelper.createDuplicateJGoodiesDef("P", "2px", 9)) + ",f:p:g,4px,p"));
        CellConstraints cc = new CellConstraints();
        int y = 1;
        builder.addSeparator("Username and Passwords", cc.xyw(1, y, 12));
        builder.add((Component)UIHelper.createLabel("IT Username:", 4), cc.xy(1, y += 2));
        builder.add((Component)this.dbUsernameTxtFld, cc.xy(3, y));
        builder.add((Component)UIHelper.createLabel("Master Username:", 4), cc.xy(5, y));
        builder.add((Component)this.saUsernameTxtFld, cc.xy(7, y));
        builder.add((Component)UIHelper.createLabel("User Username:", 4), cc.xy(9, y));
        builder.add((Component)this.usrUsernameTxtFld, cc.xy(11, y));
        builder.add((Component)UIHelper.createLabel("IT Password:", 4), cc.xy(1, y += 2));
        builder.add((Component)this.dbPasswdTxtFld, cc.xy(3, y));
        builder.add((Component)UIHelper.createLabel("Master Password:", 4), cc.xy(5, y));
        builder.add((Component)this.saPasswdTxtFld, cc.xy(7, y));
        builder.add((Component)UIHelper.createLabel("User Password:", 4), cc.xy(9, y));
        builder.add((Component)this.usrPasswdTxtFld, cc.xy(11, y));
        builder.addSeparator("Database Info", cc.xyw(1, y += 2, 12));
        builder.add((Component)UIHelper.createLabel("Database Name:", 4), cc.xy(1, y += 2));
        builder.add((Component)this.databaseNameTxt, cc.xy(3, y));
        builder.add((Component)UIHelper.createLabel("Driver:", 4), cc.xy(1, y += 2));
        builder.add((Component)this.drivers, cc.xy(3, y));
        builder.addSeparator("Collection Options", cc.xyw(1, y += 2, 12));
        y += 2;
        this.collChoiceList = this.loadPersistedChoices();
        this.fillChoicesWithDefaults();
        this.choiceTable = new JTable(new DisciplineSetupModel());
        this.choiceTable.setRowHeight(new JComboBox<E>().getPreferredSize().height);
        TableColumn col = this.choiceTable.getColumnModel().getColumn(2);
        col.setCellEditor(new MyComboBoxEditor(this.catNumFmtList, this.catNumFmtHash));
        col.setCellRenderer(new MyLabelRenderer(this.catNumFmtHash));
        col = this.choiceTable.getColumnModel().getColumn(3);
        col.setCellEditor(new MyComboBoxStringEditor(this.catNumGrpList));
        col = this.choiceTable.getColumnModel().getColumn(4);
        col.setCellEditor(new MyComboBoxEditor(this.accNumFmtList, this.accNumFmtHash));
        col = this.choiceTable.getColumnModel().getColumn(5);
        col.setCellEditor(new MyComboBoxStringEditor(this.accNumGrpList));
        UIHelper.makeTableHeadersCentered(this.choiceTable, false);
        SetUpBuildDlg.calcColumnWidths(this.choiceTable);
        builder.add((Component)UIHelper.createScrollPane(this.choiceTable), cc.xywh(1, y, 12, 1));
        y += 2;
        JButton catGblBtn = UIHelper.createButton("Global Cat Nums");
        JButton accGblBtn = UIHelper.createButton("Global Acc Nums");
        JButton selectAllBtn = UIHelper.createButton("Select All");
        JButton deSelectAll = UIHelper.createButton("Deselect All");
        JButton defBtn = UIHelper.createButton("Revert");
        PanelBuilder btnBar = new PanelBuilder(new FormLayout("f:p:g," + UIHelper.createDuplicateJGoodiesDef("p", "4px", 5), "p"));
        btnBar.add((Component)catGblBtn, cc.xy(2, 1));
        btnBar.add((Component)accGblBtn, cc.xy(4, 1));
        btnBar.add((Component)selectAllBtn, cc.xy(6, 1));
        btnBar.add((Component)deSelectAll, cc.xy(8, 1));
        btnBar.add((Component)defBtn, cc.xy(10, 1));
        builder.add((Component)btnBar.getPanel(), cc.xywh(1, y, 12, 1));
        y += 2;
        catGblBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SetUpBuildDlg.this.setCatNumGroup("Cat Group");
            }
        });
        accGblBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SetUpBuildDlg.this.setAccNumGroup("Acc Group");
            }
        });
        selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SetUpBuildDlg.this.selectAll(true);
            }
        });
        deSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SetUpBuildDlg.this.selectAll(false);
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SetUpBuildDlg.this.closeDlg(true);
            }
        });
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SetUpBuildDlg.this.saveChoices(SetUpBuildDlg.this.collChoiceList);
                SetUpBuildDlg.this.closeDlg(false);
            }
        });
        defBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SetUpBuildDlg.this.resetDefaults(SetUpBuildDlg.this.collChoiceList);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SetUpBuildDlg.this.cancelBtn.doClick();
            }
        });
        builder.setDefaultDialogBorder();
        this.contentPanel = builder.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        Dimension size = this.getSize();
        size.width = Math.max(size.width, 900);
        this.setSize(size);
    }

    protected void fillChoicesWithDefaults() {
        if (this.collChoiceList == null || this.collChoiceList.size() == 0) {
            CollectionChoice[] choicesArray = new CollectionChoice[]{new CollectionChoice(DisciplineType.STD_DISCIPLINES.fish, false, true), new CollectionChoice(DisciplineType.STD_DISCIPLINES.fish, true, true), new CollectionChoice(DisciplineType.STD_DISCIPLINES.botany, false, true), new CollectionChoice(DisciplineType.STD_DISCIPLINES.invertpaleo, false, true)};
            this.collChoiceList = new Vector();
            Collections.addAll(this.collChoiceList, choicesArray);
            DisciplineType.STD_DISCIPLINES[] sTD_DISCIPLINESArray = DisciplineType.STD_DISCIPLINES.values();
            int n = sTD_DISCIPLINESArray.length;
            int n2 = 0;
            while (n2 < n) {
                DisciplineType dType;
                File file;
                DisciplineType.STD_DISCIPLINES disp = sTD_DISCIPLINESArray[n2];
                if (disp != DisciplineType.STD_DISCIPLINES.botany && disp != DisciplineType.STD_DISCIPLINES.invertpaleo && disp != DisciplineType.STD_DISCIPLINES.paleobotany && disp != DisciplineType.STD_DISCIPLINES.fish && (file = XMLHelper.getConfigDir(String.valueOf((dType = DisciplineType.getDiscipline(disp)).getFolder()) + File.separator + "taxon_init.xml")) != null && file.exists()) {
                    CollectionChoice collChoice = new CollectionChoice(disp, false, true);
                    this.collChoiceList.add(collChoice);
                }
                ++n2;
            }
            for (CollectionChoice collChoice : this.collChoiceList) {
                collChoice.setCatalogNumberingFmtName("CatalogNumberNumeric");
                collChoice.setAccessionNumberingFmtName("AccessionNumber");
                DisciplineType dType = DisciplineType.getDiscipline(collChoice.getType());
                collChoice.setCatNumGroup("Cat " + dType.getTitle() + " Group");
                collChoice.setAccNumGroup("Acc " + dType.getTitle() + " Group");
            }
        }
    }

    protected void selectAll(boolean isSelected) {
        for (CollectionChoice collChoice : this.collChoiceList) {
            collChoice.setSelected(isSelected);
        }
        ((DisciplineSetupModel)this.choiceTable.getModel()).fireChanged();
    }

    protected void setCatNumGroup(String name) {
        for (CollectionChoice collChoice : this.collChoiceList) {
            collChoice.setCatNumGroup(name);
        }
        ((DisciplineSetupModel)this.choiceTable.getModel()).fireChanged();
    }

    protected void setAccNumGroup(String name) {
        for (CollectionChoice collChoice : this.collChoiceList) {
            collChoice.setAccNumGroup(name);
        }
        ((DisciplineSetupModel)this.choiceTable.getModel()).fireChanged();
    }

    public List<CollectionChoice> getSelectedColleectionChoices() {
        Vector<CollectionChoice> items = new Vector<CollectionChoice>();
        for (CollectionChoice cc : this.collChoiceList) {
            if (!cc.isSelected()) continue;
            items.add(cc);
        }
        return items;
    }

    protected Vector<CollectionChoice> loadPersistedChoices() {
        XStream xstream = new XStream();
        CollectionChoice.config(xstream);
        File file = new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "bld_coll_choices.xml");
        if (file.exists()) {
            try {
                Vector list = (Vector)xstream.fromXML(FileUtils.readFileToString((File)file));
                for (CollectionChoice cc : new Vector(list)) {
                    try {
                        cc.initialize();
                    }
                    catch (Exception ex) {
                        list.remove(cc);
                    }
                }
                return list;
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SetUpBuildDlg.class, ex);
                ex.printStackTrace();
            }
        }
        return new Vector<CollectionChoice>();
    }

    public void resetDefaults(Vector<CollectionChoice> choices) {
        choices.clear();
        this.fillChoicesWithDefaults();
        ((DisciplineSetupModel)this.choiceTable.getModel()).fireChanged();
    }

    public void saveChoices(Vector<CollectionChoice> choices) {
        XStream xstream = new XStream();
        CollectionChoice.config(xstream);
        System.out.println("Start");
        File file = new File(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + "bld_coll_choices.xml");
        try {
            FileUtils.writeStringToFile((File)file, (String)xstream.toXML(choices));
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SetUpBuildDlg.class, ex);
            ex.printStackTrace();
        }
        System.out.println("Stop");
    }

    public void closeDlg(boolean wasCancelled) {
        if (!this.wasClosed) {
            this.isCancelled = wasCancelled;
            if (!this.isCancelled) {
                this.databaseName = this.databaseNameTxt.getText();
                if (StringUtils.isEmpty((String)this.databaseName)) {
                    this.isCancelled = true;
                } else if (this.drivers.getSelectedIndex() > -1) {
                    this.dbDriver = (DatabaseDriverInfo)this.drivers.getSelectedItem();
                } else {
                    this.isCancelled = true;
                }
            }
            this.setVisible(false);
            if (!this.isCancelled) {
                try {
                    this.dbUser.first = this.dbUsernameTxtFld.getText();
                    this.dbUser.second = new String(this.dbPasswdTxtFld.getPassword());
                    this.saUser.first = this.saUsernameTxtFld.getText();
                    this.saUser.second = new String(this.saPasswdTxtFld.getPassword());
                    this.cmUser.first = this.usrUsernameTxtFld.getText();
                    this.cmUser.second = new String(this.usrPasswdTxtFld.getPassword());
                    this.bldSampleDatabase.startBuild(this.databaseName, this.dbDriver.getName(), this.dbUser, this.saUser, this.cmUser, this.getSelectedColleectionChoices());
                    this.dispose();
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SetUpBuildDlg.class, ex);
                    ex.printStackTrace();
                }
            } else {
                System.exit(0);
            }
            this.wasClosed = true;
        }
    }

    public static void calcColumnWidths(JTable table) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int margin = columns.getColumnMargin();
        int rowCount = data.getRowCount();
        int totalWidth = 0;
        int i = columns.getColumnCount() - 1;
        while (i >= 0) {
            TableColumn column = columns.getColumn(i);
            int columnIndex = column.getModelIndex();
            int width = -1;
            TableCellRenderer h = column.getHeaderRenderer();
            if (h == null) {
                h = defaultHeaderRenderer;
            }
            if (h != null) {
                Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, i);
                width = c.getPreferredSize().width;
            }
            int row = rowCount - 1;
            while (row >= 0) {
                TableCellRenderer r = table.getCellRenderer(row, i);
                Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, i);
                width = Math.max(width, c.getPreferredSize().width + 10);
                --row;
            }
            if (width >= 0) {
                column.setPreferredWidth(width + margin);
            }
            totalWidth += column.getPreferredWidth();
            --i;
        }
    }

    class DisciplineSetupModel
    extends DefaultTableModel {
        protected String[] titles = null;

        DisciplineSetupModel() {
        }

        @Override
        public int getColumnCount() {
            if (this.titles == null) {
                this.titles = new String[]{" ", "Name", "Catalog Numbering", "Catalog Group", "Accession Numbering", "Accession Group"};
            }
            return this.titles.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.titles[column];
        }

        @Override
        public int getRowCount() {
            return SetUpBuildDlg.this.collChoiceList.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            CollectionChoice choice = SetUpBuildDlg.this.collChoiceList.get(row);
            switch (column) {
                case 0: {
                    return choice.isSelected;
                }
                case 1: {
                    return choice.toString();
                }
                case 2: {
                    return choice.getCatalogNumberingFmtName();
                }
                case 3: {
                    return choice.getCatNumGroup();
                }
                case 4: {
                    return choice.getAccessionNumberingFmtName();
                }
                case 5: {
                    return choice.getAccNumGroup();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
            }
            return null;
        }

        protected void fixCatNumsForGroup(String groupName, String fmtName) {
            for (CollectionChoice choice : SetUpBuildDlg.this.collChoiceList) {
                if (!choice.getCatNumGroup().equals(groupName)) continue;
                choice.setCatalogNumberingFmtName(fmtName);
            }
        }

        protected void fixAccNumsForGroup(String groupName, String fmtName) {
            for (CollectionChoice choice : SetUpBuildDlg.this.collChoiceList) {
                if (!choice.getAccNumGroup().equals(groupName)) continue;
                choice.setAccessionNumberingFmtName(fmtName);
            }
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            CollectionChoice choice = SetUpBuildDlg.this.collChoiceList.get(row);
            switch (column) {
                case 0: {
                    choice.isSelected = (Boolean)value;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    choice.setCatalogNumberingFmtName(((UIFieldFormatterIFace)value).getName());
                    if (choice.getCatNumberFormatter().getAutoNumber() == null) {
                        choice.setCatNumGroup(SetUpBuildDlg.this.catNumGrpList.get(0));
                    }
                    this.fixCatNumsForGroup(choice.getCatNumGroup(), choice.getCatalogNumberingFmtName());
                    break;
                }
                case 3: {
                    choice.setCatNumGroup((String)value);
                    this.fixCatNumsForGroup(choice.getCatNumGroup(), choice.getCatalogNumberingFmtName());
                    break;
                }
                case 4: {
                    choice.setAccessionNumberingFmtName(((UIFieldFormatterIFace)value).getName());
                    if (choice.getAccNumberFormatter().getAutoNumber() == null) {
                        choice.setAccNumGroup(SetUpBuildDlg.this.accNumGrpList.get(0));
                    }
                    this.fixCatNumsForGroup(choice.getCatNumGroup(), choice.getCatalogNumberingFmtName());
                    break;
                }
                case 5: {
                    choice.setAccNumGroup((String)value);
                    this.fixAccNumsForGroup(choice.getAccNumGroup(), choice.getAccessionNumberingFmtName());
                }
            }
        }

        public void fireChanged() {
            super.fireTableDataChanged();
        }
    }

    public class MyComboBoxEditor
    extends DefaultCellEditor {
        protected Hashtable<String, UIFieldFormatterIFace> hash;

        public MyComboBoxEditor(Vector<?> items, Hashtable<String, UIFieldFormatterIFace> hash) {
            super(new JComboBox(items));
            this.hash = hash;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox cbx = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            UIFieldFormatterIFace fmt = this.hash.get(value);
            cbx.setSelectedItem(fmt);
            return cbx;
        }
    }

    public class MyComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        protected Hashtable<String, UIFieldFormatterIFace> hash;

        public MyComboBoxRenderer(Vector<?> items, Hashtable<String, UIFieldFormatterIFace> hash) {
            super(items);
            this.setOpaque(true);
            this.hash = hash;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(isSelected);
            if (isSelected) {
                this.setForeground(Color.BLACK);
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            UIFieldFormatterIFace fmt = this.hash.get(value);
            this.setSelectedItem(fmt);
            return this;
        }
    }

    public class MyComboBoxStringEditor
    extends DefaultCellEditor {
        public MyComboBoxStringEditor(Vector<?> items) {
            super(new JComboBox(items));
        }
    }

    public class MyLabelRenderer
    extends DefaultTableCellRenderer {
        protected Hashtable<String, UIFieldFormatterIFace> hash;

        public MyLabelRenderer(Hashtable<String, UIFieldFormatterIFace> hash) {
            this.hash = hash;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            UIFieldFormatterIFace fmt = this.hash.get(value);
            if (fmt != null) {
                label.setText(fmt.getTitle());
            }
            return label;
        }
    }
}

