/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.FrameworkAppIFace;
import edu.ku.brc.af.core.MacOSAppHandler;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.helpers.BrowserLauncher;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.utilapps.RegProcEntry;
import edu.ku.brc.specify.utilapps.RegProcessor;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.CustomFrame;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class RegisterApp
extends JPanel
implements FrameworkAppIFace {
    protected static boolean INCL_ANON = false;
    protected String connectStr = "jdbc:mysql://localhost/stats";
    protected String username = "root";
    protected String password = "root";
    protected boolean doLocal = false;
    protected JFrame frame;
    protected String title = "Registration and Statistics Tool";
    protected JTree tree;
    protected JTable propsTable;
    protected Hashtable<String, String> fullDescHash = null;
    protected JList trackItemsList;
    protected Hashtable<String, Hashtable<String, Integer>> trackUsageHash;
    protected CustomFrame chartFrame = null;
    protected Hashtable<String, String> trackDescHash = new Hashtable();
    protected CustomFrame classFrame = null;
    protected JList classList;
    protected RegProcessor rp = new RegProcessor();
    protected Comparator<Pair<String, Integer>> countComparator = null;
    protected Comparator<Pair<String, Integer>> titleComparator = null;

    public RegisterApp() {
        super(new BorderLayout());
        new MacOSAppHandler(this);
        DBConnection dbConn = DBConnection.getInstance();
        dbConn.setConnectionStr(this.connectStr);
        dbConn.setDatabaseName("stats");
        dbConn.setUsernamePassword(this.username, this.password);
        dbConn.setDriver("com.mysql.jdbc.Driver");
        this.createUI();
        for (Pair<String, String> p : this.rp.getTrackKeyDescPairs()) {
            this.trackDescHash.put((String)p.first, (String)p.second);
        }
        this.countComparator = new Comparator<Pair<String, Integer>>(){

            @Override
            public int compare(Pair<String, Integer> o1, Pair<String, Integer> o2) {
                if (o1.second != null && o2.second != null) {
                    return ((Integer)o1.second).compareTo((Integer)o2.second);
                }
                return 0;
            }
        };
        this.titleComparator = new Comparator<Pair<String, Integer>>(){

            @Override
            public int compare(Pair<String, Integer> o1, Pair<String, Integer> o2) {
                return ((String)o1.first).compareTo((String)o2.first);
            }
        };
    }

    protected void createUI() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.rp = new RegProcessor();
        this.rp.processSQL();
        this.tree = new JTree(this.rp.getRoot(INCL_ANON));
        this.propsTable = new JTable();
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                RegisterApp.this.fillPropsTable();
            }
        });
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        JScrollPane topComp = UIHelper.createScrollPane(this.tree);
        JScrollPane botComp = UIHelper.createScrollPane(this.propsTable);
        JSplitPane splitPane = new JSplitPane(0, topComp, botComp);
        splitPane.setDividerLocation(0.5);
        splitPane.setOneTouchExpandable(true);
        splitPane.setLastDividerLocation(300);
        Dimension minimumSize = new Dimension(200, 400);
        ((Component)topComp).setMinimumSize(minimumSize);
        ((Component)botComp).setMinimumSize(minimumSize);
        tabbedPane.add("Registration", splitPane);
        final List<Pair<String, String>> trackDescPairs = this.rp.getTrackKeyDescPairs();
        Vector<String> trkItems = new Vector<String>();
        for (Pair<String, String> p : trackDescPairs) {
            trkItems.add((String)p.second);
        }
        final JList list = new JList(trkItems);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int inx;
                if (!e.getValueIsAdjusting() && (inx = list.getSelectedIndex()) > -1) {
                    RegisterApp.this.fillUsageItemsList((String)((Pair)trackDescPairs.get((int)inx)).first);
                }
            }
        });
        tabbedPane.add("Reg Stats", this.getStatsPane("Registration", this.rp.getRegNumHash().values(), "register"));
        DefaultListModel model = new DefaultListModel();
        this.trackItemsList = new JList(model);
        topComp = UIHelper.createScrollPane(list);
        botComp = UIHelper.createScrollPane(this.trackItemsList);
        splitPane = new JSplitPane(0, topComp, botComp);
        splitPane.setDividerLocation(0.5);
        splitPane.setOneTouchExpandable(true);
        ((Component)topComp).setMinimumSize(minimumSize);
        ((Component)botComp).setMinimumSize(minimumSize);
        splitPane.setDividerLocation(0.5);
        this.trackUsageHash = this.rp.getTrackCatsHash();
        tabbedPane.add("Usage Tracking", splitPane);
        tabbedPane.add("User Stats", this.getStatsPane("Tracking", this.rp.getTrackIdHash().values(), "track"));
        this.add((Component)tabbedPane, "Center");
    }

    protected void fillUsageItemsList(String catName) {
        String sql = "SELECT Name, Total FROM (SELECT Name, SUM(CountAmt) as Total FROM trackitem WHERE CountAmt < 100000 AND SUBSTRING(Name, 1, 8) = 'Usage_" + catName + "' GROUP BY Name) AS T1 ORDER BY Total";
        System.out.println(sql);
        Vector<Object[]> rows = BasicSQLUtils.query(sql);
        DefaultListModel model = (DefaultListModel)this.trackItemsList.getModel();
        if (rows != null && rows.size() > 0) {
            boolean isCatOK = catName.length() == 2;
            boolean isDataEntry = catName.equals("DE");
            boolean isDatabase = catName.equals("DB");
            Hashtable<String, Boolean> clsHash = new Hashtable<String, Boolean>();
            Vector<Pair<String, Integer>> values = new Vector<Pair<String, Integer>>();
            int total = 0;
            for (Object[] colData : rows) {
                String str;
                String name = (String)colData[0];
                int val = ((BigDecimal)colData[1]).intValue();
                if (name.startsWith("Usage_")) {
                    name = name.substring(6);
                }
                if (isCatOK && name.charAt(2) == '_') {
                    str = name.substring(catName.length() + 1);
                    if (str.startsWith("VIEW_")) {
                        str = str.substring(5);
                    }
                    if (isDataEntry) {
                        String clsName = str;
                        if (clsName.endsWith("_RS")) {
                            clsName = clsName.substring(0, clsName.length() - 3);
                        }
                        clsHash.put(clsName, true);
                    } else if (isDatabase) {
                        int inx = str.lastIndexOf(95);
                        String clsName = str.substring(inx + 1);
                        clsHash.put(clsName, true);
                    }
                } else {
                    str = name;
                }
                values.add(new Pair<String, Integer>(str, val));
                total += val;
            }
            Collections.sort(values, this.countComparator);
            this.createBarChart(this.trackDescHash.get(catName), "Actions", values);
            model.clear();
            sql = "SELECT DISTINCT(Name) FROM trackitem WHERE SUBSTRING(Name, 1, 8) = 'Usage_" + catName + "' ORDER BY Name";
            rows = BasicSQLUtils.query(sql);
            if (rows != null && rows.size() > 0) {
                for (Object[] colData : rows) {
                    model.addElement(colData[0]);
                }
            }
            if (clsHash.size() > 0) {
                this.showClassList(clsHash);
            } else if (this.classFrame != null && this.classFrame.isVisible()) {
                this.classFrame.setVisible(false);
            }
        } else {
            model.clear();
            if (this.chartFrame != null && this.chartFrame.isVisible()) {
                this.chartFrame.setVisible(false);
            }
        }
    }

    private void showClassList(Hashtable<String, Boolean> clsHash) {
        boolean wasVisible = false;
        boolean wasCreated = false;
        if (this.classFrame == null) {
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
            this.classList = new JList(new DefaultListModel());
            pb.add((Component)UIHelper.createScrollPane(this.classList), cc.xy(1, 1));
            pb.setDefaultDialogBorder();
            this.classFrame = new CustomFrame("Used Classes", 1, pb.getPanel());
            this.classFrame.setOkLabel("Close");
            this.classFrame.createUI();
            wasCreated = true;
        } else {
            wasVisible = this.classFrame.isVisible();
        }
        Hashtable<String, Boolean> allClassesHash = new Hashtable<String, Boolean>();
        for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
            allClassesHash.put(ti.getShortClassName(), true);
        }
        for (String key : clsHash.keySet()) {
            allClassesHash.remove(key);
        }
        ((DefaultListModel)this.classList.getModel()).clear();
        TreeSet keys = new TreeSet(allClassesHash.keySet());
        for (String key : keys) {
            ((DefaultListModel)this.classList.getModel()).addElement(key);
        }
        Rectangle r = this.classFrame.getBounds();
        ++r.height;
        this.classFrame.setBounds(r);
        --r.height;
        this.classFrame.setBounds(r);
        if (wasCreated) {
            this.classFrame.pack();
        }
        if (!wasVisible) {
            UIHelper.centerAndShow(this.classFrame);
        }
    }

    @Override
    public void doAbout() {
    }

    @Override
    public boolean doExit(boolean doAppExit) {
        RegProcEntry.cleanUp();
        System.exit(0);
        return true;
    }

    @Override
    public void doPreferences() {
    }

    private Vector<String> getKeyWordsList(Collection<RegProcEntry> entries) {
        Properties props = new Properties();
        Hashtable<String, Boolean> statKeywords = new Hashtable<String, Boolean>();
        for (RegProcEntry entry : entries) {
            props.clear();
            props.putAll((Map<?, ?>)entry.getProps());
            String os = props.getProperty("os_name");
            String ver = props.getProperty("os_version");
            props.put("platform", String.valueOf(os) + " " + ver);
            for (Object keywordObj : props.keySet()) {
                statKeywords.put(keywordObj.toString(), true);
            }
        }
        String[] trackKeys = this.rp.getTrackKeys();
        for (String keyword : new Vector(statKeywords.keySet())) {
            if (keyword.startsWith("Usage") || keyword.startsWith("num_") || keyword.endsWith("_portal") || keyword.endsWith("_number") || keyword.endsWith("_website") || keyword.endsWith("id") || keyword.endsWith("os_name") || keyword.endsWith("os_version")) {
                statKeywords.remove(keyword);
                continue;
            }
            String[] stringArray = trackKeys;
            int n = trackKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (keyword.startsWith(key)) {
                    statKeywords.remove(keyword);
                }
                ++n2;
            }
        }
        statKeywords.remove("date");
        statKeywords.put("by_date", true);
        statKeywords.put("by_month", true);
        statKeywords.put("by_year", true);
        return new Vector<String>(statKeywords.keySet());
    }

    private JPanel getStatsPane(final String chartPrefixTitle, Collection<RegProcEntry> entries, final String tableName) {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
        Hashtable<String, String> keyDescPairsHash = this.rp.getAllDescPairsHash();
        final Hashtable<String, String> desc2KeyPairsHash = new Hashtable<String, String>();
        for (String key : keyDescPairsHash.keySet()) {
            desc2KeyPairsHash.put(keyDescPairsHash.get(key), key);
        }
        Vector<String> keywords = new Vector<String>();
        for (String keyword : this.getKeyWordsList(entries)) {
            if (keyword.endsWith("_name") || keyword.endsWith("_type") || keyword.endsWith("ISA_Number") || keyword.endsWith("reg_isa")) continue;
            String desc = keyDescPairsHash.get(keyword);
            if (desc != null) {
                keywords.add(desc);
                continue;
            }
            System.out.println("Desc for keyword[" + keyword + "] is null.");
        }
        Vector<Object[]> rvList = BasicSQLUtils.query("SELECT DISTINCT(Name) FROM registeritem WHERE SUBSTRING(Name, 1, 4) = 'num_'");
        for (Object[] array : rvList) {
            keywords.add((String)array[0]);
        }
        Collections.sort(keywords);
        final JList list = new JList(keywords);
        pb.add((Component)UIHelper.createScrollPane(list), cc.xy(1, 1));
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DateType dateType;
                    String statName = (String)list.getSelectedValue();
                    if (desc2KeyPairsHash.get(statName) != null) {
                        statName = (String)desc2KeyPairsHash.get(statName);
                    }
                    if ((dateType = RegisterApp.this.convertDateType(statName)) == DateType.None) {
                        Vector<Pair<String, Integer>> values;
                        if (statName.startsWith("num_")) {
                            values = RegisterApp.this.getCollNumValuesFromList(statName);
                            Hashtable<String, Boolean> hash = new Hashtable<String, Boolean>();
                            for (Pair<String, Integer> p : values) {
                                if (hash.get(p.first) == null) {
                                    hash.put((String)p.first, true);
                                    continue;
                                }
                                int i = 0;
                                String name = (String)p.first;
                                while (hash.get(p.first) != null) {
                                    p.first = String.valueOf(name) + " _" + i;
                                    ++i;
                                }
                                hash.put((String)p.first, true);
                            }
                        } else {
                            values = RegisterApp.this.getCollValuesFromList(statName);
                        }
                        Collections.sort(values, RegisterApp.this.countComparator);
                        Vector<Pair<String, Integer>> top10Values = new Vector<Pair<String, Integer>>();
                        int i = 1;
                        while (i < Math.min(11, values.size())) {
                            top10Values.insertElementAt(values.get(values.size() - i), 0);
                            ++i;
                        }
                        RegisterApp.this.createBarChart(String.valueOf(chartPrefixTitle) + " " + statName, statName, top10Values);
                    } else {
                        String desc = RegisterApp.this.getByDateDesc(dateType);
                        Vector values = tableName.equals("track") ? RegisterApp.this.getDateValuesFromListByTable(dateType, tableName) : RegisterApp.this.getDateValuesFromList(dateType);
                        Collections.sort(values, RegisterApp.this.titleComparator);
                        RegisterApp.this.createBarChart(String.valueOf(chartPrefixTitle) + " " + desc, desc, values);
                    }
                }
            }
        });
        return pb.getPanel();
    }

    protected Vector<Pair<String, Integer>> getCollValuesFromList(String statName) {
        String sql = "SELECT Value, COUNT(Value) AS CNT FROM registeritem WHERE Name = '" + statName + "' GROUP BY Value ORDER BY CNT";
        System.err.println(sql);
        Vector<Pair<String, Integer>> values = new Vector<Pair<String, Integer>>();
        Vector<Object[]> list = BasicSQLUtils.query(sql);
        int i = 0;
        while (i < list.size()) {
            Object[] row = list.get(i);
            values.add(new Pair<String, Integer>(row[0].toString(), ((Long)row[1]).intValue()));
            ++i;
        }
        return values;
    }

    protected Vector<Pair<String, Integer>> getCollNumValuesFromList(String statName) {
        String sql = "SELECT RegisterID, Value, CountAmt FROM registeritem WHERE Name = '" + statName + "' OR Name = 'Collection_name' ORDER BY RegisterID";
        Vector<Pair<String, Integer>> values = new Vector<Pair<String, Integer>>();
        for (RegProcEntry entry : this.rp.getRoot(INCL_ANON).getKids()) {
            entry.get("reg_type").equals("Collection");
        }
        Vector<Object[]> list = BasicSQLUtils.query(sql);
        int i = 0;
        while (i < list.size()) {
            Object[] row1 = list.get(i);
            if (++i < list.size()) {
                int id2;
                Object[] row2 = list.get(i);
                int id1 = (Integer)row1[0];
                if (id1 == (id2 = ((Integer)row2[0]).intValue())) {
                    String desc = (String)(row1[1] != null ? row1[1] : row2[1]);
                    Integer count = (Integer)(row1[2] != null ? row1[2] : row2[2]);
                    values.add(new Pair<String, Integer>(desc, count));
                } else {
                    --i;
                }
            }
            ++i;
        }
        return values;
    }

    private DateType convertDateType(String name) {
        if (name != null) {
            if (name.equals("by_date")) {
                return DateType.Date;
            }
            if (name.equals("by_month")) {
                return DateType.Monthly;
            }
            if (name.equals("by_year")) {
                return DateType.Yearly;
            }
            if (name.equals("time")) {
                return DateType.Time;
            }
        }
        return DateType.None;
    }

    private String getByDateDesc(DateType dateType) {
        String[] desc = new String[]{"None", "By Date", "By Month", "By Year", "By Time"};
        return desc[dateType.ordinal()];
    }

    /*
     * WARNING - void declaration
     */
    private Vector<Pair<String, Integer>> getDateValuesFromList(DateType dateType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        System.out.println(this.rp.getRegNumHash().values().size());
        Hashtable<void, Pair<void, Integer>> hash = new Hashtable<void, Pair<void, Integer>>();
        for (RegProcEntry entry : this.rp.getRoot(INCL_ANON).getKids()) {
            void var7_8;
            if (!entry.get("reg_type").equals("Institution")) continue;
            Object var7_9 = null;
            Timestamp ts = entry.getTimestampCreated();
            cal.setTime(ts);
            switch (dateType) {
                case Time: {
                    String string = Integer.toString(cal.get(11));
                    break;
                }
                case Monthly: {
                    String string = Integer.toString(cal.get(2));
                    break;
                }
                case Yearly: {
                    String string = Integer.toString(cal.get(1));
                    break;
                }
                case Date: {
                    String string = sdf.format(ts);
                    break;
                }
            }
            Pair<void, Integer> pair = (Pair<void, Integer>)hash.get(var7_8);
            if (pair == null) {
                pair = new Pair<void, Integer>(var7_8, 1);
                hash.put(var7_8, pair);
                continue;
            }
            pair.second = (Integer)pair.second + 1;
        }
        Vector<Pair<String, Integer>> values = new Vector<Pair<String, Integer>>(hash.values());
        int total = 0;
        for (Pair pair : values) {
            total += ((Integer)pair.second).intValue();
        }
        System.err.println("Total: " + total);
        return values;
    }

    private Vector<Pair<String, Integer>> getDateValuesFromListByTable(DateType dateType, String tableName) {
        String sql = "";
        switch (dateType) {
            case Time: {
                sql = "SELECT hrs, COUNT(hrs) FROM (SELECT (hr + mn + sc) as hrs FROM (SELECT HOUR(TimestampCreated) as hr, ROUND(MINUTE(TimestampCreated) / 60) as mn, ROUND(SECOND(TimestampCreated) / 3600) as sc FROM " + tableName + " WHERE TimestampCreated > '2009-04-12') AS T1) as T2 GROUP BY hrs";
                break;
            }
            case Monthly: {
                sql = "SELECT nm,COUNT(mon) FROM (SELECT MONTH(TimestampCreated) as mon, MONTHNAME(TimestampCreated) as nm FROM " + tableName + " WHERE TimestampCreated > '2009-04-12') AS T1 GROUP BY mon";
                break;
            }
            case Yearly: {
                sql = "SELECT yr,count(yr) FROM (SELECT YEAR(TimestampCreated) as yr FROM " + tableName + " WHERE TimestampCreated > '2009-04-12') AS T1 group by yr";
                break;
            }
            case Date: {
                sql = "SELECT dt,count(dt) FROM (SELECT DATE(TimestampCreated) as dt FROM " + tableName + " WHERE TimestampCreated > '2009-04-12') AS T1 group by dt";
                break;
            }
        }
        Vector<Pair<String, Integer>> values = new Vector<Pair<String, Integer>>();
        for (Object[] colData : BasicSQLUtils.query(sql)) {
            Comparable<Long> val;
            Long longVal = (Long)colData[1];
            String desc = "";
            if (colData[0] instanceof String) {
                desc = (String)colData[0];
            } else if (colData[0] instanceof Long) {
                val = (Long)colData[0];
                desc = ((Long)val).toString();
            } else if (colData[0] instanceof Date) {
                val = (Date)colData[0];
                desc = ((Date)val).toString();
            } else if (colData[0] instanceof Integer) {
                val = (Integer)colData[0];
                desc = ((Integer)val).toString();
            } else if (colData[0] instanceof BigDecimal) {
                val = (BigDecimal)colData[0];
                desc = String.format("%02d", ((BigDecimal)val).intValue());
            } else if (colData[0] instanceof byte[]) {
                desc = new String((byte[])colData[0]);
            } else {
                System.out.println(colData[0].getClass());
            }
            values.add(new Pair<String, Integer>(desc, longVal.intValue()));
        }
        return values;
    }

    private void createBarChart(String chartTitle, String xTitle, Vector<Pair<String, Integer>> values) {
        String cat = "";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Pair<String, Integer> p : values) {
            dataset.addValue((Number)p.second, (Comparable)p.first, (Comparable)((Object)cat));
        }
        JFreeChart chart = ChartFactory.createBarChart3D((String)chartTitle, (String)xTitle, (String)"Occurrence", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setAntiAlias(true);
        chart.setTextAntiAlias(true);
        ChartPanel panel = new ChartPanel(chart, true, true, true, true, true);
        boolean wasVisible = false;
        boolean wasCreated = false;
        if (this.chartFrame == null) {
            panel.setPreferredSize(new Dimension(800, 600));
            this.chartFrame = new CustomFrame("Statistics", 1, null);
            this.chartFrame.setOkLabel("Close");
            this.chartFrame.createUI();
            wasCreated = true;
        } else {
            wasVisible = this.chartFrame.isVisible();
        }
        this.chartFrame.setContentPane((Container)panel);
        Rectangle r = this.chartFrame.getBounds();
        ++r.height;
        this.chartFrame.setBounds(r);
        --r.height;
        this.chartFrame.setBounds(r);
        if (wasCreated) {
            this.chartFrame.pack();
        }
        if (!wasVisible) {
            UIHelper.centerAndShow(this.chartFrame);
        }
    }

    protected void fillPropsTable() {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            RegProcEntry rpe = (RegProcEntry)path.getLastPathComponent();
            Vector<String> keys = new Vector<String>();
            for (Object obj : rpe.keySet()) {
                keys.add(obj.toString());
            }
            Collections.sort(keys);
            if (this.fullDescHash == null) {
                this.fullDescHash = this.rp.getAllDescPairsHash();
            }
            Object[][] rows = new Object[keys.size()][2];
            int inx = 0;
            for (Object e : keys) {
                String titleStr = this.fullDescHash.get(e);
                if (titleStr == null) {
                    titleStr = e.toString();
                }
                rows[inx][0] = titleStr;
                rows[inx][1] = rpe.get(e.toString());
                ++inx;
            }
            this.propsTable.setModel(new DefaultTableModel(rows, new String[]{"Property", "Value"}));
        } else {
            this.propsTable.setModel(new DefaultTableModel());
        }
    }

    private boolean hasReg(RegProcEntry inst) {
        for (RegProcEntry div : inst.getKids()) {
            for (RegProcEntry disp : div.getKids()) {
                for (RegProcEntry col : disp.getKids()) {
                    if (!StringUtils.isNotEmpty((String)col.getISANumber())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private int count(RegProcEntry inst, CountType type) {
        int divs = inst.getKids().size();
        int disps = 0;
        int cols = 0;
        for (RegProcEntry div : inst.getKids()) {
            disps += div.getKids().size();
            for (RegProcEntry disp : div.getKids()) {
                cols += disp.getKids().size();
            }
        }
        switch (type) {
            case Divs: {
                return divs;
            }
            case Disps: {
                return disps;
            }
            case Cols: {
                return cols;
            }
        }
        return 0;
    }

    private int createTable(StringBuilder sb, String tableTitle, Vector<RegProcEntry> entries, boolean hasReg) {
        int count = 0;
        Hashtable<String, RegProcEntry> collHash = this.rp.getCollectionHash();
        sb.append("<table class=\"brd\" border=\"0\" cellspacing=\"0\">\n");
        sb.append("<tr>");
        sb.append("<th colspan=\"8\">");
        sb.append(tableTitle);
        sb.append("</th>");
        sb.append("</tr>");
        sb.append("<tr><th>Institution</th><th>Division</th><th>Discipline</th><th>Collection</th><th>ISA Number</th><th>Phone</th><th>EMail</th><th>Last Opened</th></tr>\n");
        for (RegProcEntry inst : entries) {
            if (this.hasReg(inst) != hasReg) continue;
            int cols = this.count(inst, CountType.Cols);
            sb.append("<tr>\n  <td valign=\"top\" rowspan=\"" + cols + "\">" + inst.getName() + "</td>\n");
            ++count;
            int divsCnt = 0;
            for (RegProcEntry div : inst.getKids()) {
                if (divsCnt > 0) {
                    sb.append("<tr>\n");
                }
                int dispsCnt = 0;
                int disps = this.count(div, CountType.Disps);
                sb.append("  <td valign=\"top\" " + (divsCnt == 0 ? " rowspan=\"" + disps + "\"" : "") + ">" + div.getName() + "</td>\n");
                for (RegProcEntry disp : div.getKids()) {
                    if (dispsCnt > 0) {
                        sb.append("<tr>\n");
                    }
                    sb.append("  <td valign=\"top\" " + (dispsCnt == 0 ? " rowspan=\"" + disp.getKids().size() + "\"" : "") + ">" + disp.getName() + "</td>\n");
                    int colsCnt = 0;
                    for (RegProcEntry col : disp.getKids()) {
                        RegProcEntry colEntry = collHash.get(col.get("reg_number"));
                        if (colEntry != null) {
                            String dateStr = colEntry.get("date");
                            Date lastUsedDate = new Date(this.rp.getDate(dateStr));
                            dateStr = this.rp.getDateFmt().format(lastUsedDate);
                            col.put("last_used_date", dateStr);
                        } else {
                            col.put("last_used_date", "&nbsp;");
                        }
                        if (colsCnt > 0) {
                            sb.append("<tr>\n");
                        }
                        String isa = col.getISANumber();
                        sb.append("  <td>" + col.getName() + "</td>\n  <td>" + (StringUtils.isNotEmpty((String)isa) ? isa : "&nbsp;") + "</td>");
                        String phone = col.get("Phone");
                        String email = col.get("User_email");
                        String ludate = col.get("last_used_date");
                        sb.append("<td>" + (StringUtils.isNotEmpty((String)phone) ? phone : "&nbsp;") + "</td>\n  <td>" + (StringUtils.isNotEmpty((String)email) ? email : "&nbsp;") + "</td>\n  <td>" + (StringUtils.isNotEmpty((String)ludate) ? ludate : "&nbsp;"));
                        sb.append("</tr>\n");
                        ++colsCnt;
                    }
                    ++dispsCnt;
                }
                ++divsCnt;
            }
            sb.append("<tr>\n");
        }
        sb.append("</table>\n");
        return count;
    }

    public void createRegReport() {
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy");
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head>\n<title>Registrations</title>\n");
        sb.append("<style>");
        sb.append("body { font-family: sans-serif; font-size:10pt; }");
        sb.append("td, th { font-family: sans-serif; font-size:10pt; }");
        sb.append("table { border-top: 1px gray solid; border-left: 1px gray solid; }");
        sb.append("table td { border-bottom: 1px gray solid; border-right: 1px gray solid; }");
        sb.append("table th { border-bottom: 1px gray solid; border-right: 1px gray solid; }");
        sb.append("</style>");
        sb.append("</head><body>\n<div style=\"text-align: left;\"><img src=\"" + UIRegistry.getResourceString("CGI_BASE_URL") + "/images/logosmaller.png\" height=\"42\" width=\"117\"></div>\n");
        StringBuilder tsb = new StringBuilder();
        int cnt = this.createTable(tsb, "ISA Registrations - " + sdf.format(Calendar.getInstance().getTime()), this.rp.getRoot(INCL_ANON).getKids(), true);
        if (cnt > 0) {
            sb.append((CharSequence)tsb);
            sb.append("<br><br>");
        }
        this.createTable(sb, "No ISA Registrations - " + sdf.format(Calendar.getInstance().getTime()), this.rp.getRoot(INCL_ANON).getKids(), false);
        sb.append("</body></html>");
        try {
            File file = new File("report.html");
            FileUtils.writeStringToFile((File)file, (String)sb.toString());
            BrowserLauncher.openURL(file.toURI().toString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected int calcStat(StringBuilder sb, Collection<RegProcEntry> entries, String key, String desc, String discipline) {
        int total = 0;
        for (RegProcEntry entry : entries) {
            String val;
            String disp = null;
            RegProcEntry parent = (RegProcEntry)entry.getParent();
            if (parent != null) {
                disp = parent.getName();
            }
            if (discipline != null && (disp == null || !discipline.equals(disp)) || (val = entry.get(key)) == null) continue;
            total += Integer.parseInt(val);
        }
        sb.append("<tr><td>");
        sb.append(desc);
        sb.append("</td><td align=\"right\">");
        sb.append(Integer.toString(total));
        sb.append("</td></tr>\n");
        return total;
    }

    public void createStatsReport() {
        if (this.fullDescHash == null) {
            this.fullDescHash = this.rp.getAllDescPairsHash();
        }
        String[] statsArray = new String[]{"num_co", "num_tx", "num_txu", "num_geo", "num_geou", "num_loc", "num_locgr", "num_preps", "num_prpcnt", "num_litho", "num_lithou", "num_gtp", "num_gtpu"};
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head>\n<title>Statistics</title>\n");
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + UIRegistry.getResourceString("CGI_BASE_URL") + "/css/report.css\">\n");
        sb.append("</head><body>\n<div style=\"text-align: left;\"><img src=\"" + UIRegistry.getResourceString("CGI_BASE_URL") + "/images/logosmaller.png\" height=\"42\" width=\"117\"></div>\n");
        sb.append("<center\n<table class=\"brd\" border=\"0\" cellspacing=\"0\">\n");
        sb.append("<tr>");
        sb.append("<th colspan=\"2\">");
        sb.append("Statistics - All Collections");
        sb.append("</th>");
        sb.append("</tr>");
        sb.append("<tr><th>Name</th><th>Total</th></tr>\n");
        Collection<RegProcEntry> collEntries = this.rp.getCollectionsHash().values();
        int[] values = new int[statsArray.length];
        int i = 0;
        while (i < statsArray.length) {
            values[i] = this.calcStat(sb, collEntries, statsArray[i], this.fullDescHash.get(statsArray[i]), null);
            ++i;
        }
        sb.append("</table>");
        Hashtable<String, Boolean> dispHash = new Hashtable<String, Boolean>();
        for (RegProcEntry entry : collEntries) {
            String disp = null;
            RegProcEntry parent = (RegProcEntry)entry.getParent();
            if (parent == null || (disp = parent.getName()) == null) continue;
            dispHash.put(disp, true);
        }
        for (String disp : dispHash.keySet()) {
            DisciplineType discipline = DisciplineType.getDiscipline(disp);
            String dTitle = discipline != null ? discipline.getTitle() : disp;
            sb.append("<br><br><table class=\"brd\" border=\"0\" cellspacing=\"0\">\n");
            sb.append("<tr>");
            sb.append("<th colspan=\"2\">");
            sb.append("Statistics for " + dTitle);
            sb.append("</th>");
            sb.append("</tr>");
            sb.append("<tr><th>Name</th><th>Total</th></tr>\n");
            values = new int[statsArray.length];
            int i2 = 0;
            while (i2 < statsArray.length) {
                values[i2] = this.calcStat(sb, collEntries, statsArray[i2], this.fullDescHash.get(statsArray[i2]), disp);
                ++i2;
            }
            sb.append("</table>");
        }
        sb.append("</center></body></html>");
        try {
            File file = new File("stats.html");
            FileUtils.writeStringToFile((File)file, (String)sb.toString());
            BrowserLauncher.openURL(file.toURI().toString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void doSetVersion() {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,2px,f:p:g"));
        Vector<String> versionsList = new Vector<String>();
        Hashtable<String, String> verToDateHash = new Hashtable<String, String>();
        try {
            SimpleDateFormat mmddyyyy = new SimpleDateFormat("MM/dd/yyyy");
            SimpleDateFormat yyyymmdd = new SimpleDateFormat("yyyy/MM/dd");
            List lines = FileUtils.readLines((File)this.rp.getDataFromWeb(String.valueOf(UIRegistry.getResourceString("CGI_BASE_URL")) + "/specifydownloads/specify6/alpha/versions.txt", false));
            for (String line : lines) {
                String[] toks = line.split(",");
                if (toks.length <= 2) continue;
                String ver = StringUtils.remove((String)toks[1].trim(), (String)"Alpha ");
                versionsList.insertElementAt(ver, 0);
                String dateStr = toks[2].trim();
                dateStr = StringUtils.replace((String)dateStr, (String)".", (String)"/");
                try {
                    Date date = mmddyyyy.parse(dateStr);
                    verToDateHash.put(ver, yyyymmdd.format(date));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            versionsList.insertElementAt("Clear", 0);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        final JList list = new JList(versionsList);
        final CustomDialog dlg = new CustomDialog(null, "Set Version", true, pb.getPanel());
        pb.add((Component)UIHelper.createLabel("Versions", 0), cc.xy(1, 1));
        pb.add((Component)UIHelper.createScrollPane(list), cc.xy(1, 3));
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    dlg.getOkBtn().setEnabled(list.getSelectedIndex() > -1);
                }
            }
        });
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    dlg.getOkBtn().doClick();
                }
            }
        });
        pb.setDefaultDialogBorder();
        dlg.createUI();
        dlg.getOkBtn().setEnabled(false);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            int inx = list.getSelectedIndex();
            String version = (String)list.getSelectedValue();
            if (version.equals("Clear")) {
                this.rp.setVersionDates(null, null, null);
                this.frame.setTitle(this.title);
            } else {
                String prevVersion = inx == list.getModel().getSize() - 1 ? null : (String)list.getModel().getElementAt(inx + 1);
                this.rp.setVersionDates(version, prevVersion, verToDateHash);
                this.frame.setTitle(String.valueOf(this.title) + " for " + version);
            }
        }
    }

    protected void doStart() {
        this.frame = new JFrame();
        JMenuBar mb = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu rptMenu = new JMenu("Reports");
        this.frame.setTitle(this.title);
        JMenuItem doISARegReportMI = new JMenuItem("ISA Reg Report");
        rptMenu.add(doISARegReportMI);
        JMenuItem doStatsMI = new JMenuItem("Registration");
        rptMenu.add(doStatsMI);
        JMenuItem doSetVersionMI = new JMenuItem("Set Version");
        fileMenu.add(doSetVersionMI);
        if (!UIHelper.isMacOS()) {
            fileMenu.addSeparator();
            JMenuItem doExitMI = new JMenuItem("Exit");
            fileMenu.add(doExitMI);
            doExitMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RegisterApp.this.doExit(true);
                }
            });
        }
        mb.add(fileMenu);
        mb.add(rptMenu);
        this.frame.setJMenuBar(mb);
        this.frame.setContentPane(this);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setBounds(0, 0, 600, 768);
        UIHelper.centerAndShow(this.frame);
        doISARegReportMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegisterApp.this.createRegReport();
            }
        });
        doStatsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegisterApp.this.createStatsReport();
            }
        });
        doSetVersionMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegisterApp.this.doSetVersion();
            }
        });
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    String[] pairs = s.split("=");
                    if (pairs.length == 2 && pairs[0].startsWith("-D")) {
                        System.setProperty(pairs[0].substring(2, pairs[0].length()), pairs[1]);
                    }
                    ++n2;
                }
                IconManager.setApplicationClass(Specify.class);
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
                new RegisterApp().doStart();
            }
        });
    }

    private static enum CountType {
        Divs,
        Disps,
        Cols;

    }

    private static enum DateType {
        None,
        Date,
        Monthly,
        Yearly,
        Time;

    }

    class MyTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree treeArg, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
            ImageIcon myIcon;
            super.getTreeCellRendererComponent(treeArg, value, bSelected, bExpanded, bLeaf, iRow, bHasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            String labelText = node.toString();
            this.setText(labelText);
            String iconName = null;
            RegProcEntry entry = (RegProcEntry)node;
            String regType = entry.get("reg_type");
            if (entry.getName().equals("Root")) {
                iconName = "InstBldg";
            } else if (regType != null) {
                if (regType.equals("Discipline")) {
                    iconName = entry.get("Discipline_type");
                    if (iconName == null) {
                        iconName = regType;
                    }
                } else if (!entry.getName().equals("Root")) {
                    iconName = regType;
                }
            }
            if (iconName != null && (myIcon = IconManager.getIcon(iconName, IconManager.IconSize.Std16)) != null) {
                this.setOpenIcon(myIcon);
                this.setClosedIcon(myIcon);
                this.setLeafIcon(myIcon);
                this.setIcon(myIcon);
            }
            return this;
        }
    }
}

