/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.config.init.RegisterSpecify;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.utilapps.RegProcEntry;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;

public class RegProcessor {
    protected String versionNum = null;
    protected String prevVersionNum = null;
    protected SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy/MM/dd");
    protected FileReader fr = null;
    protected BufferedReader br = null;
    protected Hashtable<String, Hashtable<String, RegProcEntry>> typeHash = new Hashtable();
    protected Hashtable<String, RegProcEntry> regNumHash = new Hashtable();
    protected Hashtable<String, RegProcEntry> trackRegNumHash = new Hashtable();
    protected Hashtable<String, RegProcEntry> trackIdHash = new Hashtable();
    protected Hashtable<String, Boolean> trackUsageHash = new Hashtable();
    protected Hashtable<String, Hashtable<String, Integer>> trackCatsHash = new Hashtable();
    protected Hashtable<String, RegProcEntry> collHash = new Hashtable();
    protected Hashtable<String, String> verToDateHash = null;
    protected Vector<Long> dateList = new Vector();
    protected Hashtable<Long, String> dateToVer = new Hashtable();
    protected Hashtable<String, RegProcEntry> prvRegNumHash = new Hashtable();
    protected Hashtable<String, Boolean> prvTrackUsageHash = new Hashtable();
    protected Hashtable<String, Hashtable<String, Integer>> prvTrackCatsHash = new Hashtable();
    protected Vector<Pair<String, String>> dateTimeVector = new Vector();
    protected Hashtable<String, Boolean> regNumOKHash = new Hashtable();
    protected Hashtable<String, String> idToIPHash = null;
    protected int lineNo = 0;
    protected String[] TYPES = new String[]{"Institution", "Division", "Discipline", "Collection"};
    protected RegProcEntry root = new RegProcEntry("Root");
    public static Connection connection = null;
    public static Statement stmt = null;
    public static String tableName = null;
    public static String tableItemName = null;

    public void processFile() {
        try {
            this.process(new File("/Users/rods/reg.dat"), true);
            this.process(new File("/Users/rods/track.dat"), false);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public SimpleDateFormat getDateFmt() {
        return this.dateFmt;
    }

    public RegProcEntry getRoot(boolean inclAnonymous) {
        Vector<RegProcEntry> kids = new Vector<RegProcEntry>(this.root.getKids());
        if (!inclAnonymous) {
            for (RegProcEntry entry : kids) {
                if (!entry.getName().equals("Anonymous")) continue;
                this.root.getKids().remove(entry);
            }
        }
        Collections.sort(this.root.getKids(), new Comparator<RegProcEntry>(){

            @Override
            public int compare(RegProcEntry o1, RegProcEntry o2) {
                String date1 = o1.get("date");
                String date2 = o2.get("date");
                return date1 != null && date2 != null ? date1.compareTo(date2) : 0;
            }
        });
        return this.root;
    }

    public void setVersionDates(String versionStr, String preVersionStr, Hashtable<String, String> verToDateHashArg) {
        this.typeHash.clear();
        this.regNumHash.clear();
        this.trackRegNumHash.clear();
        this.trackIdHash.clear();
        this.trackUsageHash.clear();
        this.trackCatsHash.clear();
        this.collHash.clear();
        this.dateList.clear();
        this.dateToVer.clear();
        this.prvRegNumHash.clear();
        this.prvTrackUsageHash.clear();
        this.prvTrackCatsHash.clear();
        if (verToDateHashArg != null) {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
            this.verToDateHash = verToDateHashArg;
            for (String ver : this.verToDateHash.keySet()) {
                String dateStr = this.verToDateHash.get(ver);
                try {
                    long time = df.parse(dateStr).getTime();
                    this.dateToVer.put(time, ver);
                    this.dateList.add(time);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            }
            Collections.sort(this.dateList);
        }
        this.versionNum = versionStr;
        this.prevVersionNum = preVersionStr;
    }

    protected void addToTracks(String key, String valueStr, Hashtable<String, Boolean> trackUsageHashArg, Hashtable<String, Hashtable<String, Integer>> trackCatsHashArg) {
        trackUsageHashArg.put(key, true);
        String category = this.getCategoryKey(key);
        if (category != null) {
            Hashtable<String, Integer> countHash = trackCatsHashArg.get(category);
            if (countHash == null) {
                countHash = new Hashtable();
                trackCatsHashArg.put(category, countHash);
            }
            Integer count = countHash.get(key);
            int valNum = Integer.parseInt(valueStr);
            count = count == null ? Integer.valueOf(valNum) : Integer.valueOf(count + valNum);
            countHash.put(key, count);
        }
    }

    private String getCategoryKey(String key) {
        int inx = -1;
        inx = key.equals("RunCount") ? key.length() : key.indexOf(95);
        if (inx > -1) {
            return key.substring(0, inx);
        }
        return null;
    }

    protected void subtractPrevious() {
        if (this.prvRegNumHash.size() > 0) {
            String value;
            String pName;
            RegProcEntry entry;
            Hashtable<String, Boolean> trkUsageHash = new Hashtable<String, Boolean>();
            Hashtable<String, Hashtable<String, Integer>> trkCatsHash = new Hashtable<String, Hashtable<String, Integer>>();
            Vector<String> collectionNumbers = new Vector<String>(this.trackRegNumHash.keySet());
            System.out.println("========================");
            for (String colKey : collectionNumbers) {
                entry = this.trackRegNumHash.get(colKey);
                System.out.println("CUR " + entry.get("date") + "  " + colKey);
                for (Object keyObj : entry.keySet()) {
                    pName = keyObj.toString();
                    value = entry.get(pName);
                    if (pName.startsWith("Usage_")) {
                        this.addToTracks(pName.substring(6), value, trkUsageHash, trkCatsHash);
                        continue;
                    }
                    if (!pName.startsWith("DE_") && !pName.startsWith("WB_") && !pName.startsWith("SS_") && !pName.startsWith("RS_") && !pName.startsWith("QB_") && !pName.startsWith("TREE_OPEN_") && !pName.startsWith("RunCount") && !pName.startsWith("Tools_")) continue;
                    this.addToTracks(pName, value, trkUsageHash, trkCatsHash);
                }
            }
            System.out.println("========================!");
            this.prvTrackUsageHash.clear();
            this.prvTrackCatsHash.clear();
            for (String colKey : collectionNumbers) {
                entry = this.prvRegNumHash.get(colKey);
                if (entry == null) continue;
                System.out.println("PRV " + entry.get("date") + "  " + colKey);
                for (Object keyObj : entry.keySet()) {
                    pName = keyObj.toString();
                    value = entry.get(pName);
                    if (pName.startsWith("Usage_")) {
                        this.addToTracks(pName.substring(6), value, this.prvTrackUsageHash, this.prvTrackCatsHash);
                        continue;
                    }
                    if (!pName.startsWith("DE_") && !pName.startsWith("WB_") && !pName.startsWith("SS_") && !pName.startsWith("RS_") && !pName.startsWith("QB_") && !pName.startsWith("TREE_OPEN_") && !pName.startsWith("RunCount") && !pName.startsWith("Tools_")) continue;
                    this.addToTracks(pName, value, this.prvTrackUsageHash, this.prvTrackCatsHash);
                }
            }
            for (String category : trkCatsHash.keySet()) {
                Hashtable<String, Integer> prvCountHash = this.prvTrackCatsHash.get(category);
                Hashtable countHash = (Hashtable)trkCatsHash.get(category);
                if (prvCountHash == null || countHash == null) continue;
                for (String cntKey : countHash.keySet()) {
                    Integer cnt = (Integer)countHash.get(cntKey);
                    Integer prvCnt = prvCountHash.get(cntKey);
                    if (cnt == null || prvCnt == null) continue;
                    if (prvCnt > cnt) {
                        System.out.println("   " + String.format("%5d %5d %s %s ", cnt, prvCnt, category, cntKey));
                        continue;
                    }
                    cnt = cnt - prvCnt;
                    countHash.put(cntKey, cnt);
                    System.out.println("OK " + String.format("%5d %5d %s %s ", cnt, prvCnt, category, cntKey));
                }
            }
            this.trackUsageHash = trkUsageHash;
            this.trackCatsHash = trkCatsHash;
        }
    }

    public File getDataFromWeb(String urlKey, boolean inclDmp) {
        try {
            HttpClient httpClient = new HttpClient();
            httpClient.getParams().setParameter("http.useragent", (Object)RegisterSpecify.class.getName());
            String urlStr = UIRegistry.getResourceString(urlKey);
            PostMethod postMethod = new PostMethod(String.valueOf(urlStr) + (inclDmp ? "?dmp=1&" : ""));
            try {
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream iStream = postMethod.getResponseBodyAsStream();
                File tempFile = File.createTempFile("web", "data");
                byte[] bytes = new byte[8196];
                PrintWriter pw = new PrintWriter(tempFile);
                int numBytes = 0;
                do {
                    if ((numBytes = iStream.read(bytes)) <= 0) continue;
                    pw.write(new String(bytes, 0, numBytes));
                } while (numBytes > 0);
                pw.close();
                return tempFile;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RegisterSpecify.ConnectionException(e);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String[] getTrackKeys() {
        return new String[]{"DE", "WB", "SS", "RS", "QB", "TR", "TD", "ST", "IR", "DB", "IN", "RP", "AP", "RunCount", "Tools"};
    }

    public Hashtable<String, String> getAllDescPairsHash() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (Pair<String, String> p : this.getAllKeyDescPairs()) {
            hash.put((String)p.first, (String)p.second);
        }
        return hash;
    }

    public Vector<Pair<String, String>> getDateTimeVector() {
        for (Pair<String, String> p : this.dateTimeVector) {
            System.out.println(String.valueOf((String)p.first) + "  " + (String)p.second);
        }
        return this.dateTimeVector;
    }

    public List<Pair<String, String>> getRegKeyDescPairs() {
        Vector<Pair<String, String>> list = new Vector<Pair<String, String>>();
        list.add(new Pair<String, String>("java_version", "Java Version"));
        list.add(new Pair<String, String>("java_vendor", "Java Vendor"));
        list.add(new Pair<String, String>("os_version", "OS Version"));
        list.add(new Pair<String, String>("os_name", "OS Name"));
        list.add(new Pair<String, String>("date", "Date"));
        list.add(new Pair<String, String>("reg_type", "Registration Type"));
        list.add(new Pair<String, String>("platform", "Platform"));
        list.add(new Pair<String, String>("reg_isa", "Registration ISA"));
        list.add(new Pair<String, String>("ip", "IP Number"));
        list.add(new Pair<String, String>("ISA_Number", "ISA Number"));
        list.add(new Pair<String, String>("User_email", "User EMail"));
        list.add(new Pair<String, String>("app_version", "App Version"));
        list.add(new Pair<String, String>("by_date", "By Date"));
        list.add(new Pair<String, String>("by_month", "By Month"));
        list.add(new Pair<String, String>("by_year", "By Year"));
        list.add(new Pair<String, String>("time", "Time"));
        return list;
    }

    public List<Pair<String, String>> getTrackKeyDescPairs() {
        Vector<Pair<String, String>> list = new Vector<Pair<String, String>>();
        list.add(new Pair<String, String>("DE", "Data Entry"));
        list.add(new Pair<String, String>("WB", "WorkBench"));
        list.add(new Pair<String, String>("SS", "System Configuration"));
        list.add(new Pair<String, String>("RS", "RecordSets"));
        list.add(new Pair<String, String>("QB", "Query Builder"));
        list.add(new Pair<String, String>("TR", "Tree"));
        list.add(new Pair<String, String>("TD", "Tree Def"));
        list.add(new Pair<String, String>("ST", "Statistics"));
        list.add(new Pair<String, String>("IR", "Information Request"));
        list.add(new Pair<String, String>("DB", "Database Save/Update/Remove"));
        list.add(new Pair<String, String>("IN", "Interactions"));
        list.add(new Pair<String, String>("RP", "Reports"));
        list.add(new Pair<String, String>("AP", "Application"));
        list.add(new Pair<String, String>("RunCount", "Run Count"));
        list.add(new Pair<String, String>("Tools", "Plugins"));
        return list;
    }

    public List<Pair<String, String>> getAllKeyDescPairs() {
        Vector<Pair<String, String>> list = new Vector<Pair<String, String>>();
        list.add(new Pair<String, String>("num_co", "Collections"));
        list.add(new Pair<String, String>("num_tx", "Taxon Records"));
        list.add(new Pair<String, String>("num_txu", "Taxon Records Used"));
        list.add(new Pair<String, String>("num_geo", "Geography Records"));
        list.add(new Pair<String, String>("num_geou", "Geography Records Used"));
        list.add(new Pair<String, String>("num_loc", "Locality Records"));
        list.add(new Pair<String, String>("num_locgr", "Locality Records Used"));
        list.add(new Pair<String, String>("num_preps", "Preparations Records"));
        list.add(new Pair<String, String>("num_prpcnt", "Count of Preparations"));
        list.add(new Pair<String, String>("num_litho", "Lithostratigraphy Records"));
        list.add(new Pair<String, String>("num_lithou", "Lithostratigraphy Records Used"));
        list.add(new Pair<String, String>("num_gtp", "Chronostratigraphy Records"));
        list.add(new Pair<String, String>("num_gtpu", "Chronostratigraphy Records Used"));
        list.add(new Pair<String, String>("Phone", "Phone"));
        list.add(new Pair<String, String>("Address", "Address"));
        list.add(new Pair<String, String>("Institution_number", "Institution Number"));
        list.add(new Pair<String, String>("Institution_name", "Institution"));
        list.add(new Pair<String, String>("Division_number", "Division Number"));
        list.add(new Pair<String, String>("Division_name", "Division"));
        list.add(new Pair<String, String>("Discipline_number", "Discipline Number"));
        list.add(new Pair<String, String>("Discipline_type", "Discipline"));
        list.add(new Pair<String, String>("Collection_name", "Collection Name"));
        list.add(new Pair<String, String>("Collection_number", "Collection Number"));
        list.add(new Pair<String, String>("Collection_estsize", "Collection Estimated Size"));
        list.add(new Pair<String, String>("reg_number", "Registration Number"));
        list.add(new Pair<String, String>("id", "Id"));
        list.add(new Pair<String, String>("last_used_date", "Last Opened Date"));
        list.add(new Pair<String, String>("hostname", "Host Name"));
        list.addAll(this.getRegKeyDescPairs());
        list.addAll(this.getTrackKeyDescPairs());
        return list;
    }

    public Hashtable<String, RegProcEntry> getCollectionsHash() {
        return this.typeHash.get("Collection");
    }

    public Hashtable<String, RegProcEntry> getRegNumHash() {
        return this.regNumHash;
    }

    public Hashtable<String, RegProcEntry> getCollectionHash() {
        return this.collHash;
    }

    public Hashtable<String, RegProcEntry> getTrackIdHash() {
        return this.trackIdHash;
    }

    public Hashtable<String, Hashtable<String, Integer>> getTrackCatsHash() {
        return this.trackCatsHash;
    }

    public long getDate(String dateStrArg) {
        String dateStr = dateStrArg;
        try {
            if (dateStr.indexOf(32) == 8) {
                dateStr = dateStr.substring(0, 8);
            }
            return this.dateFmt.parse(String.valueOf(dateStr.length() == 8 ? "20" : "") + dateStr).getTime();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public void mergeStats() {
        this.subtractPrevious();
        for (RegProcEntry entry : this.regNumHash.values()) {
            RegProcEntry colEntry;
            String colNum;
            String colType = entry.get("reg_type");
            if (!StringUtils.isNotEmpty((String)colType) || !colType.equals("Collection") || !StringUtils.isNotEmpty((String)(colNum = entry.get("reg_number"))) || (colEntry = this.collHash.get(colNum)) == null) continue;
            for (Object keyObj : colEntry.keySet()) {
                String key = keyObj.toString();
                if (!key.startsWith("num_")) continue;
                entry.put(key, colEntry.get(key));
            }
        }
    }

    public Vector<String> getTrackUsageNames() {
        Vector<String> names = new Vector<String>(this.trackUsageHash.keySet());
        Collections.sort(names);
        return names;
    }

    protected RegProcEntry getParentFromHash(RegProcEntry entry, String className, String propName) {
        return this.typeHash.get(className).get(entry.get(propName));
    }

    public void processSQL() {
        block30: {
            String sql = "SELECT r.RegisterID, r.RegNumber, ri.Name, ri.Value, ri.CountAmt, r.TimestampCreated, r.IP FROM register r INNER JOIN registeritem ri ON r.RegisterID = ri.RegisterID WHERE r.TimestampCreated > '2009-04-12' ORDER BY r.RegNumber";
            System.err.println(sql);
            try {
                try {
                    stmt = DBConnection.getInstance().getConnection().createStatement();
                    ResultSet rs = stmt.executeQuery(sql);
                    int prevId = Integer.MAX_VALUE;
                    RegProcEntry currEntry = null;
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        if (id != prevId) {
                            if (currEntry != null) {
                                String regType = currEntry.get("reg_type");
                                if (regType != null) {
                                    Hashtable<String, RegProcEntry> entryHash = this.typeHash.get(regType);
                                    if (entryHash == null) {
                                        entryHash = new Hashtable();
                                        this.typeHash.put(regType, entryHash);
                                    }
                                    currEntry.put("reg_number", currEntry.getId());
                                    currEntry.setType(currEntry.get("reg_type"));
                                    if (entryHash.get(currEntry.getId()) == null) {
                                        entryHash.put(currEntry.getId(), currEntry);
                                    } else {
                                        System.err.println("Already there: " + currEntry.getId());
                                    }
                                } else {
                                    System.err.println("1Skipping: " + rs.getString(2));
                                }
                            }
                            String regNumber = rs.getString(2);
                            String ip = rs.getString(7);
                            currEntry = this.regNumHash.get(regNumber);
                            if (currEntry == null) {
                                if (ip != null) {
                                    currEntry = new RegProcEntry();
                                    this.regNumHash.put(regNumber, currEntry);
                                    currEntry.setId(regNumber);
                                    currEntry.setTimestampCreated(rs.getTimestamp(6));
                                    currEntry.put("ip", ip);
                                } else {
                                    System.err.println("IP is null for " + regNumber);
                                    ip = "N/A";
                                }
                            } else {
                                System.err.println("Already " + regNumber);
                            }
                            prevId = id;
                        } else if (prevId == Integer.MAX_VALUE) {
                            prevId = id;
                        }
                        String value = rs.getString(4);
                        if (value == null) {
                            value = rs.getString(5);
                        }
                        String propName = rs.getString(3);
                        if (currEntry == null || value == null || propName == null) continue;
                        currEntry.put(propName, value);
                    }
                    rs.close();
                    Hashtable<String, RegProcEntry> checkHash = new Hashtable<String, RegProcEntry>();
                    Hashtable<String, RegProcEntry> instHash = this.typeHash.get("Institution");
                    for (RegProcEntry entry : new Vector<RegProcEntry>(this.regNumHash.values())) {
                        entry.setName(null);
                        String ip = entry.get("ip");
                        if (ip == null || ip.startsWith("129.") || ip.startsWith("24.")) {
                            System.out.println("Removing ip: " + ip);
                            instHash.remove(entry.getId());
                            this.regNumHash.remove(entry.getId());
                            continue;
                        }
                        RegProcEntry e = (RegProcEntry)checkHash.get(ip);
                        if (e == null) {
                            checkHash.put(ip, entry);
                            continue;
                        }
                        instHash.remove(e.getId());
                        this.regNumHash.remove(e.getId());
                        checkHash.put(ip, entry);
                        System.out.println("Compressing ip: " + ip);
                    }
                    this.buildTree();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    if (stmt == null) break block30;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected void buildTree() {
        String[] regList;
        String[] stringArray = regList = new String[]{"Institution", "Division", "Discipline", "Collection"};
        int n = regList.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            System.out.println("\n" + key);
            Hashtable<String, RegProcEntry> h = this.typeHash.get(key);
            if (h == null || h.values() == null) {
                System.out.println("Skipping: " + key);
            } else {
                System.out.println("Adding: " + key);
                Vector<RegProcEntry> items = new Vector<RegProcEntry>(h.values());
                Collections.sort(items);
                for (RegProcEntry entry : items) {
                    RegProcEntry parent;
                    String reg_type = entry.get("reg_type");
                    if (reg_type.equals("Collection")) {
                        String dspNum = entry.get("Discipline_number");
                        Hashtable<String, RegProcEntry> hash = this.typeHash.get("Discipline");
                        if (hash == null) continue;
                        RegProcEntry parent2 = this.typeHash.get("Discipline").get(dspNum);
                        if (entry != null && parent2 != null) {
                            parent2.getKids().add(entry);
                            entry.setParent(parent2);
                            System.out.println(String.valueOf(parent2.getName()) + " " + entry.getName());
                            continue;
                        }
                        System.err.println("Couldn't find Discipline Num[" + dspNum + "]");
                        continue;
                    }
                    if (reg_type.equals("Discipline")) {
                        String divNum = entry.get("Division_number");
                        parent = this.typeHash.get("Division").get(divNum);
                        if (entry != null && parent != null) {
                            parent.getKids().add(entry);
                            entry.setParent(parent);
                            continue;
                        }
                        System.err.println("Couldn't find Division Num[" + divNum + "]");
                        continue;
                    }
                    if (reg_type.equals("Division")) {
                        String instNum = entry.get("Institution_number");
                        parent = this.typeHash.get("Institution").get(instNum);
                        if (entry != null && parent != null) {
                            parent.getKids().add(entry);
                            entry.setParent(parent);
                            continue;
                        }
                        System.err.println("Couldn't find Inst Num[" + instNum + "]");
                        continue;
                    }
                    if (reg_type.equals("Institution")) {
                        this.root.getKids().add(entry);
                        entry.setParent(this.root);
                        continue;
                    }
                    System.err.println("Unknown");
                }
            }
            ++n2;
        }
    }

    protected void printEntries(RegProcEntry parent, int level) {
        int i = 0;
        while (i < level) {
            System.out.print("  ");
            ++i;
        }
        System.out.println(String.valueOf(parent.getName()) + " " + parent.get("reg_number"));
        for (RegProcEntry kid : parent.getKids()) {
            this.printEntries(kid, level + 1);
        }
    }

    protected Hashtable<String, String> getIdToIPHash() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        String sql = "SELECT DISTINCT(registeritem.Value), register.IP FROM register INNER JOIN registeritem ON register.RegisterID = registeritem.RegisterID WHERE Name = 'id'";
        Vector<Object[]> rows = BasicSQLUtils.query(DBConnection.getInstance().getConnection(), sql);
        for (Object[] row : rows) {
            hash.put(row[0].toString(), row[1].toString());
        }
        return hash;
    }

    protected boolean processEntry() throws IOException {
        String line = this.br.readLine();
        Properties props = new Properties();
        do {
            String[] tokens;
            if ((tokens = StringUtils.split((String)line, (String)"=")).length == 2) {
                props.put(tokens[0].trim(), tokens[1]);
            } else if (tokens.length > 2) {
                System.err.println("Length: " + tokens.length + "  [" + line + "]");
            }
            line = this.br.readLine();
            if (line != null && !line.startsWith("----------")) continue;
            String ip = props.getProperty("ip");
            String regNumber = props.getProperty("reg_number");
            if (StringUtils.isNotEmpty((String)ip) && StringUtils.isNotEmpty((String)regNumber)) {
                if (!ip.startsWith("129.") && !ip.startsWith("24.")) {
                    this.regNumOKHash.put(regNumber, Boolean.TRUE);
                    System.out.println("OK: " + regNumber + "  " + ip);
                } else {
                    System.out.println("SK: " + regNumber + "  " + ip);
                }
            } else {
                System.err.println("Skipping: " + regNumber + "  " + ip);
            }
            return line != null;
        } while (line != null);
        return false;
    }

    protected boolean fixProcessEntry() throws IOException {
        String line = this.br.readLine();
        Properties props = new Properties();
        do {
            String[] tokens;
            if ((tokens = StringUtils.split((String)line, (String)"=")).length == 2) {
                props.put(tokens[0], tokens[1]);
            } else if (tokens.length > 2) {
                System.err.println("Length: " + tokens.length + "  [" + line + "]");
            }
            line = this.br.readLine();
            if (line != null && !line.startsWith("----------")) continue;
            String ip = props.getProperty("ip");
            String regNumber = props.getProperty("reg_number");
            if (StringUtils.isNotEmpty((String)ip) && StringUtils.isNotEmpty((String)regNumber)) {
                String sql = "UPDATE register SET IP='" + ip + "' WHERE RegNumber = '" + regNumber + "'";
                BasicSQLUtils.update(DBConnection.getInstance().getConnection(), sql);
            } else {
                System.err.println("Skipping: " + regNumber + "  " + ip);
            }
            return line != null;
        } while (line != null);
        return false;
    }

    protected boolean fixTrackEntry() throws IOException {
        String line = this.br.readLine();
        ++this.lineNo;
        Properties props = new Properties();
        do {
            String[] tokens;
            if ((tokens = StringUtils.split((String)line, (String)"=")).length == 2) {
                props.put(tokens[0].trim(), tokens[1]);
            } else if (tokens.length > 2) {
                System.err.println("Length: " + tokens.length + "  [" + line + "]");
            }
            line = this.br.readLine();
            ++this.lineNo;
            if (line != null && !line.startsWith("----------")) continue;
            String id = props.getProperty("id");
            String ip = props.getProperty("ip");
            if (StringUtils.isNotEmpty((String)id)) {
                if (ip != null) {
                    String sql = "UPDATE track SET IP='" + ip + "' WHERE Id = '" + id + "'";
                    BasicSQLUtils.update(DBConnection.getInstance().getConnection(), sql);
                } else {
                    System.err.println("No Id->IP: " + id);
                }
            } else {
                System.err.println("Track Skipping: " + id + "  line: " + this.lineNo);
            }
            return line != null;
        } while (line != null);
        return false;
    }

    public void process(File inFile, boolean doReg) throws IOException {
        this.lineNo = 0;
        this.fr = new FileReader(inFile);
        this.br = new BufferedReader(this.fr);
        this.br.readLine();
        boolean rv = true;
        while (rv) {
            rv = doReg ? this.processEntry() : false;
        }
        this.br.close();
        this.fr.close();
    }
}

