/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;

public class RegProcEntry
extends DefaultMutableTreeNode
implements Comparable<RegProcEntry> {
    protected RegProcEntry parent;
    protected String type;
    protected String name = null;
    protected String id;
    protected Properties props = null;
    protected Vector<RegProcEntry> kids = new Vector();
    protected String isaNumber = null;
    protected boolean isSorted = false;
    protected Timestamp timestampCreated;
    protected String hostName = null;
    private static final String HASH_FILENAME = "hash.xml";
    private static HashMap<String, String> ipHash = null;

    static {
        RegProcEntry.loadIPHash();
    }

    public RegProcEntry() {
        this.props = new Properties();
    }

    public RegProcEntry(String name) {
        this(name, new Properties());
    }

    public RegProcEntry(Properties props) {
        this.props = props;
        this.type = props.getProperty("reg_type");
        this.discoverHostName();
    }

    public RegProcEntry(String name, Properties props) {
        this.name = name;
        this.props = props;
        this.discoverHostName();
    }

    private static void loadIPHash() {
        if (ipHash == null) {
            try {
                File hashFile = new File(HASH_FILENAME);
                if (hashFile.exists()) {
                    XStream xstream = new XStream();
                    xstream.alias("hashmap", HashMap.class);
                    ipHash = (HashMap)xstream.fromXML((InputStream)new FileInputStream(hashFile));
                } else {
                    ipHash = new HashMap();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void cleanUp() {
        try {
            File hashFile = new File(HASH_FILENAME);
            XStream xstream = new XStream();
            xstream.alias("hashmap", HashMap.class);
            xstream.toXML(ipHash, (OutputStream)new FileOutputStream(hashFile));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sortKids() {
        Collections.sort(this.kids);
    }

    private void discoverHostName() {
        if (this.hostName == null) {
            String ip = this.props.getProperty("ip");
            if (ip == null) {
                ip = "";
                this.hostName = "";
                this.props.put("hostname", this.hostName);
            } else {
                this.hostName = ipHash.get(ip);
            }
            if (this.hostName == null) {
                try {
                    InetAddress addr = InetAddress.getByName(ip);
                    this.hostName = addr.getHostName();
                    ipHash.put(ip, this.hostName);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
            this.props.put("hostname", this.hostName);
        }
    }

    public String get(String propName) {
        return this.props.getProperty(propName);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.props.getProperty(String.valueOf(this.type) + "_name");
            if (this.name == null) {
                this.name = this.props.getProperty(String.valueOf(this.type) + "_type");
                if (this.name == null) {
                    this.name = "Anonymous";
                }
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Properties getProps() {
        return this.props;
    }

    public Set<Object> keySet() {
        return this.props.keySet();
    }

    public void put(String key, String value) {
        this.props.put(key, value);
        if (this.hostName == null && key.equals("ip")) {
            this.discoverHostName();
        }
    }

    public Vector<RegProcEntry> getKids() {
        return this.kids;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersion() {
        String verStr = this.props.getProperty("app_version");
        if (verStr == null) {
            verStr = "Unknown";
        }
        return verStr;
    }

    public boolean isRegistered() {
        return StringUtils.isNotEmpty((String)this.getISANumber());
    }

    public String getISANumber() {
        if (this.type != null && this.type.equals("Collection") && this.isaNumber == null) {
            this.isaNumber = this.props.getProperty("ISA_Number", "");
        }
        return this.isaNumber == null ? "" : this.isaNumber;
    }

    public Timestamp getTimestampCreated() {
        return this.timestampCreated;
    }

    public void setTimestampCreated(Timestamp timestampCreated) {
        this.timestampCreated = timestampCreated;
    }

    @Override
    public String toString() {
        if (this.parent != null) {
            return String.valueOf(this.getName()) + (this.isRegistered() ? "  (Registered)" : "");
        }
        this.getISANumber();
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.name != null ? "Name: " + this.name : "") + (this.type != null ? " Type: " + this.type : "") + (this.id != null ? " id: " + this.id : ""));
        sb.append("\n");
        for (Object key : this.props.keySet()) {
            if (key.equals("id")) continue;
            sb.append("  ");
            sb.append(key);
            sb.append("=");
            sb.append(this.props.get(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setParent(RegProcEntry parent) {
        this.parent = parent;
    }

    public Enumeration children() {
        return this.kids.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (!this.isSorted) {
            Collections.sort(this.kids);
            this.isSorted = true;
        }
        return this.kids.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.kids.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.kids.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.kids.size() == 0;
    }

    @Override
    public int compareTo(RegProcEntry obj) {
        return this.getName().compareTo(obj.getName());
    }
}

