/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import edu.ku.brc.helpers.UIFileFilter;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.rstools.ExportFileConfigurationFactory;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ImportFileSplitter
extends CustomDialog {
    private static final Logger log = Logger.getLogger(ImportFileSplitter.class);
    protected final int defaultChunkSize = WorkbenchTask.MAX_ROWS;
    protected JTextField fileName;
    protected JCheckBox headerChk;
    protected PosIntTextField fileSize;
    protected JProgressBar progBar;
    protected SwingWorker<ChunkageReport, Integer> worker = null;

    public ImportFileSplitter() {
        super((Frame)null, UIRegistry.getResourceString("ImportFileSplitter.Title"), true, 7, (Component)null);
    }

    @Override
    public void createUI() {
        super.createUI();
        this.setOkLabel(UIRegistry.getResourceString("ImportFileSplitter.SplitBtn"));
        this.setCancelLabel(UIRegistry.getResourceString("CLOSE"));
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, f:p, 1dlu, f:max(150dlu;p):g, 1dlu, f:p, 5dlu", "8dlu, p, 2dlu, p, 2dlu, p, 9dlu"));
        CellConstraints cc = new CellConstraints();
        pb.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("ImportFileSplitter.FileToSplit")), cc.xy(2, 2));
        this.fileName = UIHelper.createTextField();
        pb.add((Component)this.fileName, cc.xy(4, 2));
        JButton chooseBtn = UIHelper.createButton(UIRegistry.getResourceString("ImportFileSplitter.ChooseFile"));
        chooseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportFileSplitter.this.chooseFile();
            }
        });
        pb.add((Component)chooseBtn, cc.xy(6, 2));
        this.headerChk = UIHelper.createCheckBox(UIRegistry.getResourceString("ImportFileSplitter.FirstLineHeaders"));
        this.headerChk.setSelected(true);
        pb.add((Component)this.headerChk, cc.xy(4, 4));
        pb.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("ImportFileSplitter.FileSize")), cc.xy(2, 6));
        this.fileSize = new PosIntTextField(10000);
        this.fileSize.setText(String.valueOf(this.defaultChunkSize));
        pb.add((Component)this.fileSize, cc.xy(4, 6));
        PanelBuilder mainPb = new PanelBuilder(new FormLayout("f:p:g", "p, f:max(15dlu;p)"));
        PanelBuilder progPb = new PanelBuilder(new FormLayout("5dlu, f:p:g, 5dlu", "p"));
        this.progBar = new JProgressBar();
        this.progBar.setVisible(false);
        this.progBar.setMinimum(0);
        this.progBar.setMaximum(100);
        this.progBar.setValue(0);
        progPb.add((Component)this.progBar, cc.xy(2, 1));
        mainPb.add((Component)pb.getPanel(), cc.xy(1, 1));
        mainPb.add((Component)progPb.getPanel(), cc.xy(1, 2));
        ImageIcon icon = IconManager.getIcon("Splicer");
        if (icon != null) {
            JLabel iconLbl = new JLabel(icon);
            iconLbl.setBorder(BorderFactory.createEmptyBorder(10, 10, 2, 2));
            PanelBuilder contentPb = new PanelBuilder(new FormLayout("f:p, f:p:g", "f:p:g"));
            contentPb.add((Component)iconLbl, cc.xy(1, 1));
            contentPb.add((Component)mainPb.getPanel(), cc.xy(2, 1));
            this.contentPanel = contentPb.getPanel();
        } else {
            this.contentPanel = mainPb.getPanel();
        }
        this.mainPanel.add(this.contentPanel, "Center");
        this.setHelpContext("slicer");
        this.pack();
    }

    protected void chooseFile() {
        JFileChooser chooser = new JFileChooser();
        UIFileFilter ff = new UIFileFilter();
        ff.setDescription(UIRegistry.getResourceString("ImportFileSplitter.ExcelAndCSVFiles"));
        ff.addExtension("xls");
        ff.addExtension("csv");
        ff.addExtension("txt");
        chooser.setDialogTitle(UIRegistry.getResourceString("ImportFileSplitter.FileDlgTitle"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(ff);
        int choice = chooser.showOpenDialog(this);
        if (choice == 0) {
            this.fileName.setText(chooser.getSelectedFile().getPath());
        }
    }

    protected String getMimeType(File file) {
        String extension = FilenameUtils.getExtension((String)file.getName()).toLowerCase();
        if (extension.equalsIgnoreCase("xls")) {
            return ExportFileConfigurationFactory.XLS_MIME_TYPE;
        }
        if (extension.equalsIgnoreCase("csv") || extension.equalsIgnoreCase("txt")) {
            return ExportFileConfigurationFactory.CSV_MIME_TYPE;
        }
        return "";
    }

    protected boolean isXLS(File file) {
        return this.getMimeType(file).equals(ExportFileConfigurationFactory.XLS_MIME_TYPE);
    }

    protected boolean isCSV(File file) {
        return this.getMimeType(file).equals(ExportFileConfigurationFactory.CSV_MIME_TYPE);
    }

    @Override
    protected void okButtonPressed() {
        File toChunk = new File(this.fileName.getText());
        if (!toChunk.exists()) {
            UIRegistry.displayErrorDlg(UIRegistry.getResourceString("ImportFileSplitter.InvalidFileName"));
            return;
        }
        if (this.fileSize.getValue() > this.defaultChunkSize && !UIRegistry.displayConfirmLocalized("ImportFileSplitter.BigLinesConfirmTitle", "ImportFileSplitter.BigLinesConfirmMsg", "OK", "Cancel", 2)) {
            return;
        }
        this.chunkFile(toChunk, this.fileSize.getValue());
    }

    @Override
    protected void cancelButtonPressed() {
        boolean cancelled = true;
        if (this.worker != null && !this.worker.isDone()) {
            cancelled = this.worker.cancel(true);
        }
        if (cancelled) {
            super.cancelButtonPressed();
        } else {
            UIRegistry.showLocalizedMsg("ImportFileSplitter.TooLateToCancel");
        }
    }

    protected void chunkFile(final File toChunk, final int aChunkSize) {
        if (!this.isXLS(toChunk) && !this.isCSV(toChunk)) {
            UIRegistry.displayErrorDlg("ImportFileSplitter.UnrecognizedFileType");
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportFileSplitter.this.progBar.setIndeterminate(true);
                ImportFileSplitter.this.progBar.setVisible(true);
                ImportFileSplitter.this.pack();
            }
        });
        this.worker = new SwingWorker<ChunkageReport, Integer>(){
            ChunkageReport result = null;
            InputStream input = null;
            POIFSFileSystem fs = null;
            HSSFWorkbook workBook = null;
            HSSFSheet sheet = null;
            int maxCols = 0;
            int chunkSize;
            boolean hasHeaders;
            {
                this.chunkSize = n;
                this.hasHeaders = ImportFileSplitter.this.headerChk.isSelected();
            }

            protected void writeXLSChunk(File toChunkArg, HSSFWorkbook workBookOut, int fileNum, int numFiles, String firstLine) throws FileNotFoundException, IOException {
                String fName = toChunkArg.getAbsolutePath();
                String ext = "." + FilenameUtils.getExtension((String)fName);
                fName = String.valueOf(fName.substring(0, fName.lastIndexOf(ext))) + "_" + fileNum;
                FileOutputStream fos = new FileOutputStream(String.valueOf(fName) + ext);
                workBookOut.write((OutputStream)fos);
                fos.close();
                Float ratio = new Float((float)fileNum / (float)numFiles);
                Float prog = new Float(Math.max(0.0, Math.min(100.0, (double)ratio.floatValue() * 100.0)));
                this.setProgress(prog.intValue());
                this.result.addChunk(fName, firstLine);
            }

            protected void checkXLS() {
                Iterator rows = this.sheet.rowIterator();
                int numRows = this.sheet.getLastRowNum() - this.sheet.getFirstRowNum() + 1;
                int rowNum = 0;
                this.setProgress(0);
                while (rows.hasNext()) {
                    HSSFRow row = (HSSFRow)rows.next();
                    ++rowNum;
                    short maxRowCol = row.getLastCellNum();
                    if (maxRowCol > this.maxCols) {
                        this.maxCols = maxRowCol;
                    }
                    Float ratio = new Float((float)rowNum / (float)numRows);
                    Float prog = new Float(Math.max(0.0, Math.min(100.0, (double)ratio.floatValue() * 100.0)));
                    this.setProgress(prog.intValue());
                }
            }

            protected ChunkageReport chunkXLS(File toChunkArg) {
                block34: {
                    this.result = new ChunkageReport(toChunkArg);
                    this.result.setSuccess(false);
                    if (this.hasHeaders) {
                        ++this.chunkSize;
                    }
                    try {
                        this.input = new FileInputStream(toChunkArg);
                        this.fs = new POIFSFileSystem(this.input);
                        this.workBook = new HSSFWorkbook(this.fs);
                        this.sheet = this.workBook.getSheetAt(0);
                        HSSFRow headerRow = null;
                        int numRows = this.sheet.getLastRowNum() - this.sheet.getFirstRowNum() + 1;
                        if (this.hasHeaders) {
                            --numRows;
                        }
                        int numFiles = numRows / aChunkSize;
                        int leftover = numRows - numFiles * aChunkSize;
                        ++numFiles;
                        this.checkXLS();
                        boolean go = false;
                        if (!this.isCancelled()) {
                            String msg = leftover > 0 ? String.format(UIRegistry.getResourceString("ImportFileSplitter.FileInfo"), numRows, numFiles - 1, aChunkSize, leftover) : String.format(UIRegistry.getResourceString("ImportFileSplitter.FileInfoCleanCut"), numRows, numFiles - 1, aChunkSize);
                            go = UIRegistry.displayConfirm(UIRegistry.getResourceString("ImportFileSplitter.FileInfoTitle"), msg, UIRegistry.getResourceString("OK"), UIRegistry.getResourceString("CANCEL"), 1);
                        }
                        if (!go || this.isCancelled()) {
                            this.result.setCancelled(true);
                            break block34;
                        }
                        this.setProgress(0);
                        int fileNum = 0;
                        boolean newFile = true;
                        Iterator rows = this.sheet.rowIterator();
                        HSSFWorkbook workBookOut = null;
                        HSSFSheet sheetOut = null;
                        int rowNum = 0;
                        short styleIdxOffset = 0;
                        String firstLine = null;
                        boolean wroteHeaders = false;
                        while (rows.hasNext()) {
                            HSSFRow rowIn;
                            if (newFile) {
                                if (workBookOut != null) {
                                    ++fileNum;
                                    try {
                                        this.writeXLSChunk(toChunkArg, workBookOut, fileNum, numFiles, firstLine);
                                    }
                                    catch (Exception e) {
                                        this.result.setMessage(e.getMessage());
                                        return this.result;
                                    }
                                }
                                workBookOut = new HSSFWorkbook();
                                styleIdxOffset = workBookOut.getNumCellStyles();
                                short s = 0;
                                while (s < this.workBook.getNumCellStyles()) {
                                    workBookOut.createCellStyle();
                                    workBookOut.getCellStyleAt(s).cloneStyleFrom(this.workBook.getCellStyleAt(s));
                                    s = (short)(s + 1);
                                }
                                sheetOut = workBookOut.createSheet();
                                newFile = false;
                                rowNum = 0;
                                wroteHeaders = false;
                            }
                            if (this.hasHeaders && !wroteHeaders) {
                                if (headerRow == null) {
                                    headerRow = (HSSFRow)rows.next();
                                }
                                rowIn = headerRow;
                                wroteHeaders = true;
                            } else {
                                rowIn = (HSSFRow)rows.next();
                            }
                            HSSFRow rowOut = sheetOut.createRow(rowNum);
                            int cellNum = 0;
                            block18: while (cellNum < this.maxCols) {
                                String msg;
                                HSSFCell cellIn = rowIn.getCell(cellNum, HSSFRow.CREATE_NULL_AS_BLANK);
                                HSSFCell cellOut = rowOut.createCell(cellNum);
                                ++cellNum;
                                cellOut.setCellType(cellIn.getCellType());
                                short styleIdx = -1;
                                HSSFCellStyle inStyle = cellIn.getCellStyle();
                                short s = 0;
                                while (s < this.workBook.getNumCellStyles()) {
                                    if (this.workBook.getCellStyleAt(s).equals((Object)inStyle)) {
                                        styleIdx = (short)(s + styleIdxOffset);
                                        break;
                                    }
                                    s = (short)(s + 1);
                                }
                                if (styleIdx != -1) {
                                    try {
                                        cellOut.setCellStyle(workBookOut.getCellStyleAt(styleIdx));
                                    }
                                    catch (Exception ex) {
                                        msg = String.format(UIRegistry.getResourceString("ImportFileSplitter.CellStyleCopyErrMsg"), rowNum + 1, cellNum + 1, fileNum, String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getLocalizedMessage());
                                        log.error((Object)msg);
                                        this.result.setProblems(true);
                                        this.result.getReport().add(msg);
                                    }
                                }
                                switch (cellIn.getCellType()) {
                                    case 0: {
                                        cellOut.setCellValue(cellIn.getNumericCellValue());
                                        break;
                                    }
                                    case 1: {
                                        cellOut.setCellValue(cellIn.getRichStringCellValue());
                                        break;
                                    }
                                    case 4: {
                                        cellOut.setCellValue(cellIn.getBooleanCellValue());
                                        break;
                                    }
                                    case 2: {
                                        try {
                                            cellOut.setCellFormula(cellIn.getCellFormula());
                                        }
                                        catch (Exception ex) {
                                            msg = String.format(UIRegistry.getResourceString("ImportFileSplitter.FormulaCellCopyErrMsg"), rowNum + 1, cellNum + 1, fileNum, String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getLocalizedMessage());
                                            log.error((Object)msg);
                                            this.result.setProblems(true);
                                            this.result.getReport().add(msg);
                                        }
                                        continue block18;
                                    }
                                    case 5: {
                                        cellOut.setCellErrorValue(cellIn.getErrorCellValue());
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    default: {
                                        throw new Exception(String.format(UIRegistry.getResourceString("ImportFileSplitter.UnrecognizedCellTypeNotCopied"), cellIn.getCellType()));
                                    }
                                }
                            }
                            if (rowNum == 0 && !this.hasHeaders || rowNum == 1 && this.hasHeaders) {
                                StringBuilder bldr = new StringBuilder();
                                Iterator cells = rowOut.cellIterator();
                                while (cells.hasNext()) {
                                    HSSFCell cell = (HSSFCell)cells.next();
                                    bldr.append(cell.toString());
                                    if (!cells.hasNext()) continue;
                                    bldr.append("\t");
                                }
                                firstLine = bldr.toString();
                            }
                            boolean bl = newFile = ++rowNum == this.chunkSize;
                        }
                        if (rowNum > 0) {
                            this.writeXLSChunk(toChunkArg, workBookOut, ++fileNum, numFiles, firstLine);
                        }
                        this.result.setSuccess(true);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                        this.result.setMessage(String.valueOf(ex.getClass().getSimpleName()) + (StringUtils.isBlank((String)ex.getLocalizedMessage()) ? "" : ": " + ex.getLocalizedMessage()));
                    }
                }
                return this.result;
            }

            protected ChunkageReport chunkCSV(File toChunkArg) {
                this.result = new ChunkageReport(toChunkArg);
                this.result.setSuccess(false);
                if (this.hasHeaders) {
                    ++this.chunkSize;
                }
                try {
                    LineIterator it = FileUtils.lineIterator((File)toChunkArg);
                    int numRows = 0;
                    while (it.hasNext()) {
                        ++numRows;
                        it.next();
                    }
                    if (this.hasHeaders) {
                        --numRows;
                    }
                    int numFiles = numRows / aChunkSize;
                    int leftover = numRows - numFiles * aChunkSize;
                    String msg = leftover > 0 ? String.format(UIRegistry.getResourceString("ImportFileSplitter.FileInfo"), numRows, numFiles - 1, aChunkSize, leftover) : String.format(UIRegistry.getResourceString("ImportFileSplitter.FileInfoCleanCut"), numRows, ++numFiles - 1, aChunkSize);
                    boolean go = UIRegistry.displayConfirm(UIRegistry.getResourceString("ImportFileSplitter.FileInfoTitle"), msg, UIRegistry.getResourceString("OK"), UIRegistry.getResourceString("CANCEL"), 1);
                    if (!go || this.isCancelled()) {
                        this.result.setCancelled(true);
                    } else {
                        this.setProgress(0);
                        int fileNum = 0;
                        String firstLine = null;
                        boolean wroteHeaders = false;
                        Vector<String> outLines = new Vector<String>(this.chunkSize);
                        it = FileUtils.lineIterator((File)toChunkArg);
                        String headerLine = null;
                        String lineIn = null;
                        while (it.hasNext()) {
                            if (outLines.size() == this.chunkSize) {
                                this.writeCSVChunk(toChunkArg, outLines, ++fileNum, numFiles, firstLine);
                                outLines.clear();
                                wroteHeaders = false;
                            }
                            if (this.hasHeaders && !wroteHeaders) {
                                if (headerLine == null) {
                                    headerLine = it.nextLine();
                                }
                                lineIn = headerLine;
                                wroteHeaders = true;
                            } else {
                                lineIn = it.nextLine();
                            }
                            outLines.add(lineIn);
                            if ((outLines.size() != 1 || this.hasHeaders) && (outLines.size() != 2 || !this.hasHeaders)) continue;
                            firstLine = lineIn;
                        }
                        if (outLines.size() > 0) {
                            this.writeCSVChunk(toChunkArg, outLines, ++fileNum, numFiles, firstLine);
                        }
                        this.result.setSuccess(true);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    this.result.setMessage(String.valueOf(ex.getClass().getSimpleName()) + (StringUtils.isBlank((String)ex.getLocalizedMessage()) ? "" : ": " + ex.getLocalizedMessage()));
                }
                return this.result;
            }

            protected void writeCSVChunk(File toChunkArg, Vector<String> outLines, int fileNum, int numFiles, String firstLine) throws IOException {
                String fName = toChunkArg.getAbsolutePath();
                String ext = "." + FilenameUtils.getExtension((String)fName);
                fName = String.valueOf(fName.substring(0, fName.lastIndexOf(ext))) + "_" + fileNum;
                File file = new File(String.valueOf(fName) + ext);
                FileUtils.writeLines((File)file, outLines);
                Float ratio = new Float((float)fileNum / (float)numFiles);
                Float prog = new Float(Math.max(0.0, Math.min(100.0, (double)ratio.floatValue() * 100.0)));
                this.setProgress(prog.intValue());
                this.result.addChunk(fName, firstLine);
            }

            @Override
            protected ChunkageReport doInBackground() throws Exception {
                try {
                    if (ImportFileSplitter.this.isXLS(toChunk)) {
                        return this.chunkXLS(toChunk);
                    }
                    if (ImportFileSplitter.this.isCSV(toChunk)) {
                        return this.chunkCSV(toChunk);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    this.result = new ChunkageReport(toChunk);
                    this.result.setSuccess(false);
                    this.result.setMessage(String.valueOf(ex.getClass().getSimpleName()) + (StringUtils.isBlank((String)ex.getLocalizedMessage()) ? "" : ": " + ex.getLocalizedMessage()));
                    return this.result;
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).ImportFileSplitter.this.progBar.setVisible(false);
                        (this).ImportFileSplitter.this.progBar.setValue(0);
                    }
                });
                if (this.result != null && !this.isCancelled()) {
                    if (this.result.isSuccess()) {
                        String msg = UIRegistry.getResourceString("ImportFileSplitter.Success");
                        if (this.result.areProblems()) {
                            String logName = toChunk.getAbsolutePath();
                            String ext = "." + FilenameUtils.getExtension((String)logName);
                            logName = String.valueOf(logName.substring(0, logName.lastIndexOf(ext))) + ".log";
                            try {
                                FileUtils.writeLines((File)new File(logName), this.result.getReport());
                            }
                            catch (IOException ex) {
                                logName = UIRegistry.getResourceString("ImportFileSplitter.LogFileSaveError");
                            }
                            msg = String.valueOf(msg) + "\n\n" + String.format(UIRegistry.getResourceString("ImportFileSplitter.CheckLogFile"), logName);
                        }
                        UIRegistry.displayInfoMsgDlg(msg);
                    } else if (!this.result.isCancelled()) {
                        UIRegistry.displayErrorDlg(StringUtils.isBlank((String)this.result.getMessage()) ? "File could not be split." : this.result.getMessage());
                    }
                }
            }
        };
        this.worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    if (!ImportFileSplitter.this.progBar.isVisible()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                (this).ImportFileSplitter.this.progBar.setVisible(true);
                                ImportFileSplitter.this.pack();
                            }
                        });
                    }
                    if (ImportFileSplitter.this.progBar.isIndeterminate()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                (this).ImportFileSplitter.this.progBar.setIndeterminate(false);
                            }
                        });
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            (this).ImportFileSplitter.this.progBar.setValue((Integer)evt.getNewValue());
                        }
                    });
                }
            }
        });
        this.worker.execute();
    }

    public static void main(String[] args) {
        String appdatadir;
        UIRegistry.setAppName("ImportFileSplitter");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] pairs = s.split("=");
            if (pairs.length == 2) {
                if (pairs[0].startsWith("-D")) {
                    System.setProperty(pairs[0].substring(2, pairs[0].length()), pairs[1]);
                }
            } else {
                String symbol = pairs[0].substring(2, pairs[0].length());
                System.setProperty(symbol, symbol);
            }
            ++n2;
        }
        String appDir = System.getProperty("appdir");
        if (StringUtils.isNotEmpty((String)appDir)) {
            UIRegistry.setDefaultWorkingPath(appDir);
        }
        if (StringUtils.isNotEmpty((String)(appdatadir = System.getProperty("appdatadir")))) {
            UIRegistry.setBaseAppDataDir(appdatadir);
        }
        IconManager.setApplicationClass(Specify.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons.xml"));
        ImageIcon icon = IconManager.getIcon("AppIcon", IconManager.IconSize.Std16);
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
        try {
            if (!System.getProperty("os.name").equals("Mac OS X")) {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        ImageIcon helpIcon = IconManager.getIcon("AppIcon", IconManager.IconSize.Std16);
        HelpMgr.initializeHelp("SpecifyHelp", helpIcon.getImage());
        ImportFileSplitter chunker = new ImportFileSplitter();
        chunker.setTitle(UIRegistry.getResourceString("ImportFileSplitter.Title"));
        chunker.setIconImage(icon.getImage());
        chunker.setHelpContext("slicer");
        UIHelper.centerAndShow(chunker);
        System.exit(0);
    }

    public class ChunkageReport {
        protected File chunked;
        protected int rows = 0;
        protected int chunks = 0;
        protected Vector<String> report = new Vector();
        protected boolean problems = false;
        protected boolean success = false;
        protected String message = null;
        protected boolean cancelled = false;

        public ChunkageReport(File chunked) {
            this.chunked = chunked;
        }

        public void addChunk(String chunkFileName, String chunkReport) {
            ++this.chunks;
            this.report.add(String.valueOf(chunkFileName) + ": ");
        }

        public int getRows() {
            return this.rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public File getChunked() {
            return this.chunked;
        }

        public int getChunks() {
            return this.chunks;
        }

        public Vector<String> getReport() {
            return this.report;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public boolean areProblems() {
            return this.problems;
        }

        public void setProblems(boolean problems) {
            this.problems = problems;
        }
    }

    private class PosIntTextField
    extends JTextField {
        private final int maxVal;

        public PosIntTextField(int maxVal) {
            this.maxVal = maxVal;
        }

        @Override
        protected Document createDefaultModel() {
            return new IntTextDocument();
        }

        @Override
        public boolean isValid() {
            try {
                Integer val = this.getValue();
                return val >= 1 && val <= this.maxVal;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public int getValue() {
            block3: {
                try {
                    if (this.getDocument() != null) break block3;
                    return 0;
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            return Integer.parseInt(this.getText());
        }

        class IntTextDocument
        extends PlainDocument {
            IntTextDocument() {
            }

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                String oldString = this.getText(0, this.getLength());
                String newString = String.valueOf(oldString.substring(0, offs)) + str + oldString.substring(offs);
                try {
                    Integer newVal = Integer.parseInt(String.valueOf(newString) + "0");
                    if (newVal >= 1 && newVal <= PosIntTextField.this.maxVal * 10) {
                        super.insertString(offs, str, a);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

