/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerXMLHelper;
import edu.ku.brc.specify.utilapps.ERDPanel;
import edu.ku.brc.specify.utilapps.ERDTable;
import edu.ku.brc.specify.utilapps.NodeInfo;
import edu.ku.brc.specify.utilapps.TableTracker;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class ERDVisualizer
extends JFrame {
    protected static Locale currLang = new Locale("en");
    protected static boolean doShadow = true;
    protected String contentTag = "<!-- Content -->";
    protected int MARGIN = 10;
    protected int HGAP = 60;
    protected int VGAP = 30;
    protected TableTracker tblTracker;
    protected ERDPanel mainPanel;
    protected int inx = 0;
    protected String mapTemplate = "";
    protected File schemaDir;
    protected Timer timer;
    protected boolean doPNG = true;
    protected HashSet<String> pngNameHash = new HashSet();

    public ERDVisualizer() {
        boolean showTreeHierarchy = false;
        Locale.setDefault(currLang);
        UIRegistry.setResourceLocale(currLang);
        Vector<DBTableInfo> tables = DBTableIdMgr.getInstance().getTables();
        Collections.sort(tables);
        SchemaLocalizerXMLHelper schemaXMLHelper = new SchemaLocalizerXMLHelper(SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance());
        schemaXMLHelper.load(true);
        schemaXMLHelper.setTitlesIntoSchema();
        ERDTable.setDisplayType(showTreeHierarchy ? ERDTable.DisplayType.Title : ERDTable.DisplayType.All);
        this.tblTracker = new TableTracker();
        String schemDirName = this.adjustFileNameForLocale("schema%s");
        File localSchemaDir = new File(schemDirName);
        if (!localSchemaDir.exists()) {
            localSchemaDir.mkdir();
        } else {
            try {
                FileUtils.cleanDirectory((File)localSchemaDir);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ERDVisualizer.class, ex);
                ex.printStackTrace();
            }
        }
        this.schemaDir = localSchemaDir;
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.mainPanel = new ERDPanel(this.tblTracker);
        p.add((Component)this.mainPanel, "Center");
        this.setContentPane(new JScrollPane(p));
        p.setBackground(Color.WHITE);
        this.mainPanel.setBackground(Color.WHITE);
        try {
            File templateFile = new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "site/template.html");
            this.mapTemplate = FileUtils.readFileToString((File)templateFile);
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ERDVisualizer.class, ex);
            ex.printStackTrace();
        }
        if (StringUtils.isEmpty((String)this.mapTemplate)) {
            System.err.println("The template file is empty!");
        }
        try {
            File srcDir = new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "site");
            File[] fileArray = srcDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.getName().startsWith(".")) {
                    File dst = new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + schemDirName + File.separator + f.getName());
                    if (!FilenameUtils.getExtension((String)f.getName()).toLowerCase().equals("html")) {
                        FileUtils.copyFile((File)f, (File)dst);
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ERDVisualizer.class, ex);
            ex.printStackTrace();
        }
        if (!showTreeHierarchy) {
            this.advance();
            int period = ERDVisualizer.isDoShadow() ? 10000 : 1000;
            int delay = ERDVisualizer.isDoShadow() ? 5000 : 1000;
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    ERDVisualizer.this.advance();
                }
            }, period, (long)delay);
        } else {
            ERDTable.setDisplayType(ERDTable.DisplayType.Title);
            ERDTable root = null;
            boolean doCollectionSchema = true;
            if (doCollectionSchema) {
                root = this.tblTracker.getTable("Discipline");
                this.tblTracker.addNodeInfo("Agent", false, true, true, false, null);
                this.tblTracker.addNodeInfo("Determination", false, true, true, true, null);
                this.tblTracker.addNodeInfo("ConservDescription", false, true, true, true, null);
                this.tblTracker.addNodeInfo("Attachment", true, true, true, false, null);
                this.tblTracker.addNodeInfo("AttributeDef", true, true, true, false, null);
                this.tblTracker.addNodeInfo("SpAppResourceDir", true, true, true, false, null);
                this.tblTracker.addNodeInfo("SpLocaleContainer", true, true, true, false, null);
                this.tblTracker.addNodeInfo("DeaccessionPreparation", true, true, true, false, null);
                this.tblTracker.addNodeInfo("OtherIdentifier", true, true, true, false, null);
                this.tblTracker.addNodeInfo("CollectionRelationship", true, true, true, false, null);
                this.tblTracker.addNodeInfo("ProjectCollectionObject", true, true, true, false, null);
                this.tblTracker.addNodeInfo("CollectionObjectAttr", true, true, true, false, null);
                this.tblTracker.addNodeInfo("CollectionObjectAttachment", true, true, true, false, null);
                this.tblTracker.addNodeInfo("ConservDescriptionAttachment", true, true, true, false, null);
                this.tblTracker.addNodeInfo("ConservEventAttachment", true, true, true, false, null);
                this.tblTracker.addNodeInfo("Discipline", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Collection", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Taxon", false, false, true, false, null);
                this.tblTracker.addNodeInfo("TaxonCitation", false, false, true, false, null);
                this.tblTracker.addNodeInfo("ReferenceWork", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Journal", false, false, true, false, null);
                this.tblTracker.addNodeInfo("CollectingEvent", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Locality", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Geography", false, false, true, false, null);
                this.tblTracker.addNodeInfo("PaleoContext", false, false, true, false, null);
                this.tblTracker.addNodeInfo("LithoStrat", false, false, true, false, null);
                this.tblTracker.addNodeInfo("GeologicTimePeriod", false, false, true, false, null);
                this.tblTracker.addNodeInfo("CollectionObjectCitation", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Accession", false, false, true, false, null);
                this.tblTracker.addNodeInfo("AccessionAuthorization", false, false, true, false, null);
                this.tblTracker.addNodeInfo("AccessionAgent", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Agent", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Preparation", false, false, true, false, null);
                this.tblTracker.addNodeInfo("PrepType", false, false, true, false, null);
                this.tblTracker.addNodeInfo("RepositoryAgreement", false, false, true, false, null);
                this.tblTracker.addNodeInfo("ConservEvent", false, false, true, false, null);
                this.tblTracker.addNodeInfo("DNASequence", false, false, true, false, null);
                this.tblTracker.addNodeInfo("TreatmentEvent", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Ipm", false, false, true, false, null);
                this.tblTracker.addNodeInfo("FieldNotebook", false, false, true, false, null);
                this.tblTracker.addNodeInfo("FieldNotebookPageSet", false, false, true, false, null);
                this.tblTracker.addNodeInfo("FieldNotebookPage", false, false, true, false, null);
                NodeInfo det = this.tblTracker.getNodeInfo("Determination");
                det.addKid(this.tblTracker.getTable("Taxon"));
                NodeInfo ni = this.tblTracker.getNodeInfo("Taxon");
                ni.addKid(this.tblTracker.getTable("TaxonCitation"));
                ni = this.tblTracker.getNodeInfo("Discipline");
                ni.addKid(this.tblTracker.getTable("Collection"));
                ni = this.tblTracker.getNodeInfo("Collection");
                ni.addKid(this.tblTracker.getTable("FieldNotebook"));
                ni.addKid(this.tblTracker.getTable("CollectionObject"));
                ni = this.tblTracker.getNodeInfo("CollectionObjectCitation");
                ni.addKid(this.tblTracker.getTable("ReferenceWork"));
                ni = this.tblTracker.getNodeInfo("TaxonCitation");
                ni.addKid(this.tblTracker.getTable("ReferenceWork"));
                ni = this.tblTracker.getNodeInfo("ReferenceWork");
                ni.setOkToDuplicate(true);
                ni.addKid(this.tblTracker.getTable("Journal"));
                ni = this.tblTracker.getNodeInfo("GeologicTimePeriod");
                ni.setOkToDuplicate(true);
                ni = this.tblTracker.getNodeInfo("Journal");
                ni.setOkToDuplicate(true);
                ni = this.tblTracker.getNodeInfo("CollectingEvent");
                ni.addKid(this.tblTracker.getTable("Locality"));
                ni = this.tblTracker.getNodeInfo("CollectionObject");
                ni.addKid(this.tblTracker.getTable("CollectingEvent"));
                ni.addKid(this.tblTracker.getTable("PaleoContext"));
                ni.addKid(this.tblTracker.getTable("Accession"));
                ni.addKid(this.tblTracker.getTable("DNASequence"));
                ni.addKid(this.tblTracker.getTable("TreatmentEvent"));
                ni.addKid(this.tblTracker.getTable("Ipm"));
                ni = this.tblTracker.getNodeInfo("Locality");
                ni.addKid(this.tblTracker.getTable("Geography"));
                ni = this.tblTracker.getNodeInfo("PaleoContext");
                ni.addKid(this.tblTracker.getTable("LithoStrat"));
                ni.addKid(this.tblTracker.getTable("GeologicTimePeriod"));
                ni = this.tblTracker.getNodeInfo("DeterminationCitation");
                ni.addKid(this.tblTracker.getTable("ReferenceWork"));
                ni = this.tblTracker.getNodeInfo("Preparation");
                ni.addKid(this.tblTracker.getTable("PrepType"));
                ni = this.tblTracker.getNodeInfo("Accession");
                ni.addKid(this.tblTracker.getTable("AccessionAuthorization"));
                ni.addKid(this.tblTracker.getTable("AccessionAgent"));
                ni.addKid(this.tblTracker.getTable("RepositoryAgreement"));
                ni = this.tblTracker.getNodeInfo("ConservEvent");
                ni.addKid(this.tblTracker.getTable("ConservRecommendation"));
                ni = this.tblTracker.getNodeInfo("FieldNotebook");
                ni.addKid(this.tblTracker.getTable("FieldNotebookPageSet"));
                ni = this.tblTracker.getNodeInfo("FieldNotebookPageSet");
                ni.addKid(this.tblTracker.getTable("FieldNotebookPage"));
            } else {
                root = this.tblTracker.getTable("SpAppResourceDir");
                this.tblTracker.addNodeInfo("SpAppResourceData", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Collection", false, false, true, false, null);
                this.tblTracker.addNodeInfo("Discipline", false, false, true, false, null);
                this.tblTracker.addNodeInfo("SpecifyUser", false, false, true, false, null);
                this.tblTracker.addNodeInfo("SpAppResource", false, false, true, false, null);
                this.tblTracker.addNodeInfo("SpViewSetObj", false, false, true, false, null);
                this.tblTracker.addNodeInfo("SpUIViewSet", false, false, true, false, null);
                this.tblTracker.addNodeInfo("SpUIView", false, false, true, false, null);
                this.tblTracker.addNodeInfo("SpUIViewDef", false, false, true, false, null);
                this.tblTracker.addNodeInfo("SpUIAltView", false, false, true, false, null);
                this.tblTracker.addNodeInfo("SpUIColumn", false, false, true, false, null);
                this.tblTracker.addNodeInfo("SpUIRow", false, false, true, false, null);
                this.tblTracker.addNodeInfo("SpUICell", false, false, true, false, null);
                NodeInfo ni = this.tblTracker.getNodeInfo("SpAppResourceDir");
                ni.addKid(this.tblTracker.getTable("SpAppResource"));
                ni.addKid(this.tblTracker.getTable("SpViewSetObj"));
                ni = this.tblTracker.getNodeInfo("SpAppResource");
                ni.addKid(this.tblTracker.getTable("SpAppResourceData"));
                ni = this.tblTracker.getNodeInfo("SpViewSetObj");
                ni.addKid(this.tblTracker.getTable("SpAppResourceData"));
                ni.addKid(this.tblTracker.getTable("SpUIViewSet"));
                ni = this.tblTracker.getNodeInfo("SpUIViewSet");
                ni.addKid(this.tblTracker.getTable("SpUIView"));
                ni.addKid(this.tblTracker.getTable("SpUIViewDef"));
                ni = this.tblTracker.getNodeInfo("SpUIView");
                ni.addKid(this.tblTracker.getTable("SpUIAltView"));
                ni = this.tblTracker.getNodeInfo("SpUIViewDef");
                ni.addKid(this.tblTracker.getTable("SpUIColumn"));
                ni.addKid(this.tblTracker.getTable("SpUIRow"));
                ni = this.tblTracker.getNodeInfo("SpUIRow");
                ni.addKid(this.tblTracker.getTable("SpUICell"));
                ni = this.tblTracker.getNodeInfo("SpAppResourceData");
                ni.setOkToDuplicate(true);
            }
            this.processAsTree(root, 0);
            this.mainPanel.addTree(root);
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(ERDVisualizer.class, ex);
                        ex.printStackTrace();
                    }
                    return null;
                }

                @Override
                public void finished() {
                    ERDVisualizer.this.generate();
                    System.out.println("Done.");
                }
            };
            worker.start();
        }
        this.createIndexFile();
    }

    private String adjustFileNameForLocale(String fileName) {
        if (currLang.getLanguage().equals("en")) {
            return String.format(fileName, "");
        }
        return String.format(fileName, "_" + currLang.getLanguage());
    }

    protected void createIndexFile() {
        HashSet<String> nameHash = new HashSet<String>();
        String fName = String.valueOf(this.schemaDir.getAbsolutePath()) + File.separator + "index.html";
        try {
            File html = new File(fName);
            BufferedWriter output = new BufferedWriter(new FileWriter(html));
            int index = this.mapTemplate.indexOf(this.contentTag);
            String subContent = this.mapTemplate.substring(0, index);
            subContent = StringUtils.replace((String)subContent, (String)"<!-- Updated -->", (String)new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime()));
            output.write(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)"Schema Index"));
            output.write("<UL>");
            output.write("<LI><a href=\"CollectionOverview.html\">Schema Overview</a></LI>\n");
            for (ERDTable t : this.tblTracker.getList()) {
                DBTableInfo ti = t.getTable();
                String outFileName = ti.getShortClassName();
                int i = 1;
                while (nameHash.contains(outFileName)) {
                    outFileName = String.valueOf(ti.getShortClassName()) + i;
                    ++i;
                }
                nameHash.add(outFileName);
                output.write("<LI><a href=\"" + outFileName + ".html\">" + StringEscapeUtils.escapeHtml((String)ti.getTitle()) + "</a></LI>\n");
            }
            output.write("</UL>");
            output.write(this.mapTemplate.substring(index + this.contentTag.length() + 1, this.mapTemplate.length()));
            output.close();
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ERDVisualizer.class, e);
            e.printStackTrace();
        }
    }

    public static boolean isDoShadow() {
        return doShadow;
    }

    public synchronized void advance() {
        if (this.inx >= 0) {
            this.generate();
        }
        if (this.inx >= this.tblTracker.getList().size()) {
            this.timer.cancel();
            return;
        }
        this.addTables();
        ++this.inx;
        this.validate();
        final ERDVisualizer frame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        frame.repaint();
                    }
                });
            }
        });
    }

    public ERDPanel getPanel() {
        return this.mainPanel;
    }

    protected synchronized void addTables() {
        ERDTable relTable;
        this.mainPanel.setIgnorePaint(true);
        this.mainPanel.clear();
        ERDTable table = this.tblTracker.getList().get(this.inx);
        int relCount = 0;
        for (DBRelationshipInfo r : table.getTable().getRelationships()) {
            relTable = this.tblTracker.getHash().get(r.getClassName());
            if (relTable == table) continue;
            ++relCount;
        }
        this.mainPanel.addTable(table);
        this.mainPanel.setSize(this.mainPanel.getPreferredSize());
        for (DBRelationshipInfo r : table.getTable().getRelationships()) {
            relTable = this.tblTracker.getHash().get(r.getClassName());
            if (relTable == table) continue;
            if (relTable != null) {
                this.mainPanel.addTable(relTable);
                relTable.setSize(relTable.getPreferredSize());
                continue;
            }
            System.out.println("Couldn't find " + r.getClassName());
        }
        this.mainPanel.initTables();
        this.mainPanel.setIgnorePaint(false);
    }

    public void generate() {
        Rectangle rect = this.getPanel().getParent().getBounds();
        System.out.println("MAIN[" + rect + "]");
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        BufferedImage bufImage = new BufferedImage(rect.width, rect.height, this.doPNG ? 2 : 1);
        Graphics2D g2 = bufImage.createGraphics();
        if (!this.doPNG) {
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, rect.width, rect.height);
        }
        g2.setRenderingHints(ERDVisualizer.createTextRenderingHints());
        g2.setFont(this.tblTracker.getFont());
        this.getPanel().getParent().paint(g2);
        g2.dispose();
        Container stop = this.getPanel().getParent();
        Point p = new Point(0, 0);
        this.calcLoc(p, this.getPanel().getMainTable(), stop);
        String name = StringUtils.substringAfterLast((String)this.getPanel().getMainTable().getClassName(), (String)".");
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getByShortClassName(name);
        String fName = String.valueOf(this.schemaDir.getAbsolutePath()) + File.separator + name;
        try {
            String origName = fName;
            int i = 1;
            while (this.pngNameHash.contains(fName)) {
                fName = String.valueOf(origName) + i;
            }
            this.pngNameHash.add(fName);
            File html = new File(String.valueOf(fName) + ".html");
            BufferedWriter output = new BufferedWriter(new FileWriter(html));
            int index = this.mapTemplate.indexOf(this.contentTag);
            String subContent = this.mapTemplate.substring(0, index);
            output.write(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)tblInfo.getTitle()));
            File imgFile = new File(String.valueOf(fName) + (this.doPNG ? ".png" : ".jpg"));
            output.write("<map name=\"schema\" id=\"schema\">\n");
            Vector<ERDTable> nList = this.mainPanel.isRoot() ? this.tblTracker.getTreeAsList(this.mainPanel.getMainTable()) : this.getPanel().getRelTables();
            for (ERDTable erdt : nList) {
                p = new Point(0, 0);
                this.calcLoc(p, erdt, stop);
                Dimension s = erdt.getSize();
                String linkname = StringUtils.substringAfterLast((String)erdt.getClassName(), (String)".");
                output.write("<area shape=\"rect\" coords=\"" + p.x + "," + p.y + "," + (p.x + s.width) + "," + (p.y + s.height) + "\" href=\"" + linkname + ".html\"/>\n");
            }
            output.write("</map>\n");
            output.write("<img border=\"0\" usemap=\"#schema\" src=\"" + imgFile.getName() + "\"/>\n");
            output.write(this.mapTemplate.substring(index + this.contentTag.length() + 1, this.mapTemplate.length()));
            output.close();
            File oFile = new File(this.schemaDir + File.separator + imgFile.getName());
            System.out.println(oFile.getAbsolutePath());
            if (this.doPNG) {
                ImageIO.write((RenderedImage)bufImage, "PNG", oFile);
            } else {
                this.writeJPEG(oFile, bufImage, 0.75f);
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ERDVisualizer.class, e);
            e.printStackTrace();
        }
    }

    public void writeJPEG(File outfile, BufferedImage bufferedImage, float compressionQuality) {
        try {
            long start = System.currentTimeMillis();
            boolean oldWay = true;
            if (oldWay) {
                ImageWriter writer = null;
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                if (iter.hasNext()) {
                    writer = iter.next();
                }
                ImageOutputStream ios = ImageIO.createImageOutputStream(outfile);
                writer.setOutput(ios);
                MyImageWriteParam iwparam = new MyImageWriteParam();
                iwparam.setCompressionMode(2);
                ((ImageWriteParam)iwparam).setCompressionQuality(compressionQuality);
                writer.write(null, new IIOImage(bufferedImage, null, null), null);
                ios.flush();
                writer.dispose();
                ios.close();
            } else {
                FileOutputStream out = new FileOutputStream(outfile);
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bufferedImage);
                param.setQuality(0.75f, false);
                encoder.encode(bufferedImage, param);
            }
            System.out.println(System.currentTimeMillis() - start);
        }
        catch (IOException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ERDVisualizer.class, e);
            e.printStackTrace();
        }
    }

    public static RenderingHints createTextRenderingHints() {
        RenderingHints renderingHints2;
        RenderingHints renderingHints = renderingHints2 = new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        Object value = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        try {
            Field declaredField = RenderingHints.class.getDeclaredField("VALUE_TEXT_ANTIALIAS_LCD_HRGB");
            value = declaredField.get(null);
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ERDVisualizer.class, e);
        }
        renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, value);
        return renderingHints;
    }

    public static JLabel mkLabel(Font font, String name, int align) {
        JLabel lbl = new JLabel(name, align);
        lbl.setFont(font);
        lbl.setOpaque(false);
        return lbl;
    }

    public void calcLoc(Point p, Component src, Component stop) {
        if (src != stop) {
            Point sp = src.getLocation();
            p.translate(sp.x, sp.y);
            this.calcLoc(p, src.getParent(), stop);
        }
    }

    protected void processAsTree(ERDTable table, int level) {
        NodeInfo ni = this.tblTracker.getNodeInfo(table);
        boolean skip = false;
        if (ni.getOkWhenParent() != null) {
            boolean bl = skip = ni.getOkWhenParent() != table.getTreeParent();
        }
        if (ni.isSkip()) {
            this.tblTracker.getUsedHash().put(table.getClassName(), true);
            return;
        }
        if (skip || !ni.isAlwaysAKid() || this.tblTracker.getUsedHash().get(table) != null) {
            return;
        }
        Dimension tableSize = table.getPreferredSize();
        table.getSpace().width = tableSize.width;
        table.getSpace().height = tableSize.height;
        int maxHeight = 0;
        int maxWidth = 0;
        if (ni.isProcessKids() || ni.getKids().size() > 0) {
            Hashtable<String, Boolean> usedRelClasses = new Hashtable<String, Boolean>();
            for (DBRelationshipInfo r : table.getTable().getRelationships()) {
                ERDTable rTable = this.tblTracker.getHash().get(r.getClassName());
                if (rTable == null || usedRelClasses.get(r.getClassName()) != null) continue;
                usedRelClasses.put(r.getClassName(), true);
                NodeInfo kni = this.tblTracker.getNodeInfo(rTable);
                boolean kidOK = true;
                boolean override = false;
                if (!ni.isProcessKids()) {
                    kidOK = ni.getKids().contains(rTable);
                    override = true;
                } else {
                    if (kni.isSkip()) {
                        this.tblTracker.getUsedHash().put(rTable.getClassName(), true);
                        continue;
                    }
                    if (ni.getKids().contains(rTable)) {
                        override = true;
                    }
                }
                if (kni.isOkToDuplicate()) {
                    System.out.println("Duplicating [" + rTable.getClassName() + "]");
                    rTable = rTable.duplicate(this.tblTracker.getFont());
                }
                if (!kidOK || !override && r.getType() != DBRelationshipInfo.RelationshipType.OneToMany || !table.addKid(rTable)) continue;
                rTable.setTreeParent(table);
                this.processAsTree(rTable, level + 1);
                Dimension size = rTable.getSpace();
                maxWidth += size.width + 10;
                maxHeight = Math.max(maxHeight, size.height + this.VGAP);
            }
        }
        table.getSpace().width = Math.max(tableSize.width, maxWidth);
        table.getSpace().height = tableSize.height + maxHeight;
        System.out.println("Table " + table.getClassName() + " " + table.getSpace().width + " " + table.getSpace().height);
        this.tblTracker.getUsedHash().put(table.getClassName(), true);
    }

    public static void main(String[] args) {
        System.setProperty("edu.ku.brc.af.core.SchemaI18NService", "edu.ku.brc.specify.config.SpecifySchemaI18NServiceXML");
        SchemaI18NService.getInstance().loadWithLocale(SpLocaleContainer.CORE_SCHEMA, 1, DBTableIdMgr.getInstance(), SchemaI18NService.getCurrentLocale());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ERDVisualizer frame = new ERDVisualizer();
                frame.setDefaultCloseOperation(3);
                frame.setBounds(0, 0, 800, 2000);
                frame.setVisible(true);
            }
        });
    }

    public class MyImageWriteParam
    extends JPEGImageWriteParam {
        public MyImageWriteParam() {
            super(Locale.getDefault());
        }

        @Override
        public void setCompressionQuality(float quality) {
            if (quality < 0.0f || quality > 1.0f) {
                throw new IllegalArgumentException("Quality out-of-bounds!");
            }
            this.compressionQuality = 256.0f - quality * 256.0f;
        }
    }
}

