/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.utilapps.ERDVisualizer;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.ShadowFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public class ERDTable
extends JPanel
implements Comparable<ERDTable> {
    protected static int BRD_GAP = 6;
    protected static DisplayType displayType = DisplayType.All;
    protected Hashtable<DBRelationshipInfo, JComponent> relUIHash = new Hashtable();
    protected DBTableInfo table;
    protected JPanel inner;
    protected static final int SHADOW_SIZE = 10;
    protected BufferedImage shadowBuffer = null;
    protected BufferedImage buffer = null;
    protected double ratio = 0.0;
    protected Dimension preferredRenderSize = new Dimension(0, 0);
    protected Vector<ERDTable> kids = new Vector();
    protected Dimension space = new Dimension(0, 0);
    protected int shiftX = 0;
    protected String yesStr = UIRegistry.getResourceString("ERD_YES");
    protected ERDTable treeParent = null;
    protected Position pos = new Position();

    public ERDTable(DBTableInfo table) {
        super(new BorderLayout());
        this.table = table;
        if (ERDVisualizer.isDoShadow()) {
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
    }

    public DBTableInfo getTable() {
        return this.table;
    }

    public String getClassName() {
        return this.table.getClassName();
    }

    public Hashtable<DBRelationshipInfo, JComponent> getRelUIHash() {
        return this.relUIHash;
    }

    public void build(PanelBuilder p, DBFieldInfo f, Font font, int y, boolean all) {
        String typ = StringUtils.substringAfterLast((String)f.getType(), (String)".");
        if (StringUtils.isEmpty((String)typ)) {
            typ = f.getType();
        }
        String lenStr = f.getLength() > 0 && f.getLength() < 65000 ? Integer.toString(f.getLength()) : "";
        CellConstraints cc = new CellConstraints();
        p.add((Component)ERDVisualizer.mkLabel(font, f.getTitle(), 2), cc.xy(1, y));
        p.add((Component)ERDVisualizer.mkLabel(font, typ, 0), cc.xy(3, y));
        p.add((Component)ERDVisualizer.mkLabel(font, lenStr, 0), cc.xy(5, y));
        if (all) {
            p.add((Component)ERDVisualizer.mkLabel(font, f.isRequired() ? this.yesStr : "", 0), cc.xy(7, y));
            p.add((Component)ERDVisualizer.mkLabel(font, f.isRequired() ? this.yesStr : "", 0), cc.xy(9, y));
        }
    }

    public void build(PanelBuilder p, DBTableInfo tbl, Font font, int y, boolean all) {
        String typ = StringUtils.substringAfterLast((String)tbl.getIdType(), (String)".");
        if (StringUtils.isEmpty((String)typ)) {
            typ = tbl.getIdType();
        }
        CellConstraints cc = new CellConstraints();
        p.add((Component)ERDVisualizer.mkLabel(font, tbl.getIdColumnName(), 2), cc.xy(1, y));
        p.add((Component)ERDVisualizer.mkLabel(font, typ, 0), cc.xy(3, y));
        p.add((Component)ERDVisualizer.mkLabel(font, "", 0), cc.xy(5, y));
        if (all) {
            p.add((Component)ERDVisualizer.mkLabel(font, this.yesStr, 0), cc.xy(7, y));
            p.add((Component)ERDVisualizer.mkLabel(font, this.yesStr, 0), cc.xy(9, y));
        }
    }

    public JComponent build(PanelBuilder p, DBRelationshipInfo r, Font font, int y, boolean all) {
        String type = r.getType().toString().toLowerCase();
        type = UIRegistry.getResourceString(type);
        CellConstraints cc = new CellConstraints();
        p.add((Component)ERDVisualizer.mkLabel(font, StringUtils.substringAfterLast((String)r.getClassName(), (String)"."), 2), cc.xy(1, y));
        p.add((Component)ERDVisualizer.mkLabel(font, StringUtils.capitalize((String)r.getTitle()), 2), cc.xy(3, y));
        JLabel comp = ERDVisualizer.mkLabel(font, type, 0);
        p.add((Component)comp, cc.xy(5, y));
        if (all) {
            comp = ERDVisualizer.mkLabel(font, r.isRequired() ? this.yesStr : "", 0);
            p.add((Component)comp, cc.xy(7, y));
        }
        return comp;
    }

    public void build(Font font) {
        int yy;
        String colsDef;
        boolean doingAll;
        int numRows = 7;
        switch (displayType) {
            case All: {
                numRows = 7;
                break;
            }
            case MainFields: {
                numRows = 7;
                break;
            }
            case Title: {
                numRows = 1;
                break;
            }
            case TitleAndRel: {
                numRows = 4;
            }
        }
        Font bold = new Font(font.getFamily(), 1, font.getSize());
        Font italic = new Font(font.getFamily(), 2, font.getSize());
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", UIHelper.createDuplicateJGoodiesDef("p", "2px", numRows)));
        CellConstraints cc = new CellConstraints();
        String className = StringUtils.substringAfterLast((String)this.table.getClassName(), (String)".");
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getByShortClassName(className);
        if (tblInfo == null) {
            throw new RuntimeException("Couldn't find table for className[" + className + "]");
        }
        String tblName = tblInfo.getTitle();
        int y = 1;
        pb.add((Component)ERDVisualizer.mkLabel(bold, tblName, 0), cc.xy(1, y));
        y += 2;
        boolean bl = doingAll = displayType == DisplayType.All;
        if (displayType == DisplayType.All || displayType == DisplayType.MainFields) {
            pb.addSeparator("", cc.xy(1, y));
            pb.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_FIELDS"), 0), cc.xy(1, y += 2));
            y += 2;
            colsDef = "p:g,4px,p:g,4px" + (doingAll ? ",p:g,4px,p:g,4px" : "") + ",f:p:g";
            PanelBuilder fieldsPB = new PanelBuilder(new FormLayout(colsDef, UIHelper.createDuplicateJGoodiesDef("p", "2px", this.table.getFields().size() + 2)));
            yy = 1;
            fieldsPB.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_FIELD"), 2), cc.xy(1, yy));
            fieldsPB.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_TYPE"), 0), cc.xy(3, yy));
            fieldsPB.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_LENGTH"), 0), cc.xy(5, yy));
            if (doingAll) {
                fieldsPB.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_REQUIRED"), 0), cc.xy(7, yy));
                fieldsPB.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_UNIQUE"), 0), cc.xy(9, yy));
            }
            yy += 2;
            if (StringUtils.isNotEmpty((String)this.table.getIdColumnName())) {
                this.build(fieldsPB, this.table, font, yy, doingAll);
                yy += 2;
            }
            for (DBFieldInfo f : this.table.getFields()) {
                this.build(fieldsPB, f, font, yy, doingAll);
                yy += 2;
            }
            pb.add((Component)fieldsPB.getPanel(), cc.xy(1, y));
            y += 2;
        }
        if ((displayType == DisplayType.All || displayType == DisplayType.TitleAndRel) && this.table.getRelationships().size() > 0) {
            pb.addSeparator("", cc.xy(1, y));
            pb.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_RELATIONSHIPS"), 0), cc.xy(1, y += 2));
            y += 2;
            colsDef = "p:g,4px,p:g,4px" + (doingAll ? ",p:g,4px" : "") + ",f:p:g";
            PanelBuilder relsPB = new PanelBuilder(new FormLayout(colsDef, UIHelper.createDuplicateJGoodiesDef("p", "2px", this.table.getRelationships().size() + 1)));
            yy = 1;
            relsPB.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_TABLE"), 2), cc.xy(1, yy));
            relsPB.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_NAME"), 0), cc.xy(3, yy));
            relsPB.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_TYPE"), 0), cc.xy(5, yy));
            if (doingAll) {
                relsPB.add((Component)ERDVisualizer.mkLabel(italic, UIRegistry.getResourceString("ERD_REQUIRED"), 0), cc.xy(7, yy));
            }
            yy += 2;
            Vector<DBRelationshipInfo> orderedList = new Vector<DBRelationshipInfo>(this.table.getRelationships());
            Collections.sort(orderedList, new Comparator<DBRelationshipInfo>(){

                @Override
                public int compare(DBRelationshipInfo o1, DBRelationshipInfo o2) {
                    String name2;
                    String name1 = o1.getClassName();
                    if (name1.startsWith("Sp")) {
                        name1 = name1.substring(2, name1.length());
                    }
                    if ((name2 = o2.getClassName()).startsWith("Sp")) {
                        name2 = name2.substring(2, name2.length());
                    }
                    return name1.compareTo(name2);
                }
            });
            for (DBRelationshipInfo r : orderedList) {
                if (r.getName().toLowerCase().endsWith("iface")) continue;
                JComponent p = this.build(relsPB, r, font, yy, doingAll);
                this.relUIHash.put(r, p);
                yy += 2;
            }
            pb.add((Component)relsPB.getPanel(), cc.xy(1, y));
            y += 2;
        }
        this.inner = pb.getPanel();
        this.inner.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(BRD_GAP, BRD_GAP, BRD_GAP, BRD_GAP)));
        this.setBackground(Color.WHITE);
        this.add((Component)this.inner, "Center");
    }

    private BufferedImage getBackgroundImageBuffer() {
        if (this.shadowBuffer == null) {
            ShadowFactory factory = new ShadowFactory(10, 0.17f, Color.BLACK);
            Dimension size = this.inner.getSize();
            BufferedImage image = new BufferedImage(size.width, size.height, 2);
            Graphics2D g2 = image.createGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.dispose();
            this.shadowBuffer = factory.createShadow(image);
        }
        return this.shadowBuffer;
    }

    public void clear() {
        this.shadowBuffer = null;
    }

    @Override
    public void setBackground(Color bg) {
        if (this.inner != null) {
            this.inner.setBackground(bg);
            int i = 0;
            while (i < this.inner.getComponentCount()) {
                this.inner.getComponent(i).setBackground(bg);
                ++i;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!ERDVisualizer.isDoShadow()) {
            super.paint(g);
        } else {
            if (this.shadowBuffer == null) {
                this.getBackgroundImageBuffer();
                Graphics2D gg = this.shadowBuffer.createGraphics();
                this.inner.paint(gg);
                gg.dispose();
            }
            g.drawImage(this.shadowBuffer, 0, 0, null);
        }
    }

    @Override
    public int compareTo(ERDTable arg0) {
        return this.table.getTitle().compareTo(arg0.getTable().getTitle());
    }

    public static DisplayType getDisplayType() {
        return displayType;
    }

    public static void setDisplayType(DisplayType displayType) {
        ERDTable.displayType = displayType;
    }

    public boolean addKid(ERDTable kid) {
        if (!this.kids.contains(kid)) {
            this.kids.add(kid);
            return true;
        }
        return false;
    }

    public Vector<ERDTable> getKids() {
        return this.kids;
    }

    public void setKids(Vector<ERDTable> kids) {
        this.kids = kids;
    }

    public Dimension getSpace() {
        return this.space;
    }

    public Position getPos() {
        return this.pos;
    }

    public void setPos(Position pos) {
        this.pos = pos;
    }

    public ERDTable getTreeParent() {
        return this.treeParent;
    }

    public void setTreeParent(ERDTable treeParent) {
        this.treeParent = treeParent;
    }

    public boolean isRoot() {
        return this.treeParent == null;
    }

    public int getShiftX() {
        return this.shiftX;
    }

    public void setShiftX(int shiftX) {
        this.shiftX = shiftX;
    }

    protected ERDTable duplicate(Font font) {
        ERDTable newTable = new ERDTable(this.table);
        displayType = DisplayType.Title;
        newTable.build(font);
        newTable.relUIHash = new Hashtable<DBRelationshipInfo, JComponent>(this.relUIHash);
        newTable.shadowBuffer = this.shadowBuffer;
        newTable.buffer = this.buffer;
        newTable.ratio = this.ratio;
        newTable.preferredRenderSize = new Dimension(this.preferredRenderSize);
        return newTable;
    }

    public static enum DisplayType {
        All,
        MainFields,
        Title,
        TitleAndRel;

    }

    public class Position {
        public int x = 0;
        public int y = 0;
        public int width;
        public int ascent = 0;
        public int descent = 0;
        public int shift = 0;
        public Rectangle2D bounds;
    }
}

