/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.specify.utilapps.ERDTable;
import edu.ku.brc.specify.utilapps.NodeInfo;
import edu.ku.brc.specify.utilapps.TableTracker;
import edu.ku.brc.ui.UIHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

class ERDPanel
extends JPanel {
    protected Color[] colors = new Color[]{Color.BLACK, Color.GREEN, Color.BLUE, Color.YELLOW, Color.BLUE.darker(), Color.MAGENTA, Color.MAGENTA.darker(), Color.ORANGE, Color.RED, Color.CYAN, Color.PINK};
    protected int colorInx = 0;
    protected boolean doDebugBoxes = false;
    protected TableTracker tableTracker;
    protected Vector<ERDTable> tables = new Vector();
    protected Hashtable<String, ERDTable> tblHash = new Hashtable();
    protected Hashtable<ERDTable, Boolean> usedHash = new Hashtable();
    protected Vector<DBRelationshipInfo> orderedList;
    protected ERDTable mainTable = null;
    protected Vector<ERDTable> relTables = new Vector();
    protected PanelBuilder outer;
    protected PanelBuilder leftPB;
    protected PanelBuilder rightPB;
    protected boolean ignorePaint = false;
    protected boolean firstPaint = true;
    protected int aboveCnt = 0;
    protected int belowCnt = 0;
    protected Color mainColor = new Color(239, 251, 214);
    protected Color relColor = new Color(219, 239, 176);
    protected Color lineColor1 = new Color(113, 38, 0);
    protected Color lineColor2 = Color.BLACK;
    protected ERDTable root = null;
    protected Dimension preferredSize = null;

    public ERDPanel(TableTracker tableOrg) {
        super(null);
        this.tableTracker = tableOrg;
    }

    public ERDTable getMainTable() {
        return this.mainTable != null ? this.mainTable : this.root;
    }

    public Vector<ERDTable> getRelTables() {
        return this.relTables;
    }

    public boolean isRoot() {
        return this.root != null;
    }

    public void clear() {
        for (ERDTable t : this.tblHash.values()) {
            t.clear();
        }
        this.setLayout(null);
        this.removeAll();
        this.mainTable = null;
        this.relTables.clear();
        this.tblHash.clear();
        this.firstPaint = true;
        if (this.orderedList != null) {
            this.orderedList.clear();
        }
    }

    public synchronized void setIgnorePaint(boolean ignorePaint) {
        this.ignorePaint = ignorePaint;
    }

    public void setup(int numTables) {
        int gapWidth = numTables * 6 + 20;
        this.outer = new PanelBuilder(new FormLayout("p," + gapWidth + "px,p", "t:p:g"), (JPanel)this);
        this.leftPB = new PanelBuilder(new FormLayout("p", "t:p"));
        this.rightPB = new PanelBuilder(new FormLayout("p", UIHelper.createDuplicateJGoodiesDef("p:g", "10px", numTables)));
        CellConstraints cc = new CellConstraints();
        this.outer.add((Component)this.leftPB.getPanel(), cc.xy(1, 1));
        this.outer.add((Component)this.rightPB.getPanel(), cc.xy(3, 1));
        this.setBackground(Color.WHITE);
        this.leftPB.getPanel().setBackground(Color.WHITE);
        this.rightPB.getPanel().setBackground(Color.WHITE);
    }

    public synchronized void addTable(ERDTable table) {
        if (table == null) {
            return;
        }
        this.tables.add(table);
        if (this.mainTable == null) {
            this.mainTable = table;
            table.setBackground(this.mainColor);
            this.orderedList = new Vector<DBRelationshipInfo>(this.mainTable.getTable().getRelationships());
            Collections.sort(this.orderedList, new Comparator<DBRelationshipInfo>(){

                @Override
                public int compare(DBRelationshipInfo o1, DBRelationshipInfo o2) {
                    String name2;
                    String name1 = o1.getClassName();
                    if (name1.startsWith("Sp")) {
                        name1 = name1.substring(2, name1.length());
                    }
                    if ((name2 = o2.getClassName()).startsWith("Sp")) {
                        name2 = name2.substring(2, name2.length());
                    }
                    return name1.compareTo(name2);
                }
            });
        } else {
            this.relTables.add(table);
            table.setBackground(this.relColor);
        }
        this.tblHash.put(table.getTable().getClassName(), table);
        System.out.println("Adding [" + table.getTable().getName() + "] " + this.tblHash.size());
    }

    public void initTables() {
        this.relTables.clear();
        int cnt = 0;
        for (DBRelationshipInfo t : this.orderedList) {
            ERDTable table = this.tblHash.get(t.getClassName());
            if (table == null || table == this.mainTable || this.relTables.contains(table)) continue;
            ++cnt;
        }
        this.setup(cnt);
        CellConstraints cc = new CellConstraints();
        this.leftPB.add((Component)this.mainTable, cc.xy(1, 1));
        for (DBRelationshipInfo t : this.orderedList) {
            System.out.println(String.valueOf(t.getName()) + "  " + t.getClassName());
            ERDTable table = this.tblHash.get(t.getClassName());
            if (table != null) {
                if (table == this.mainTable || this.relTables.contains(table)) continue;
                this.relTables.add(table);
                this.rightPB.add((Component)table, cc.xy(1, this.relTables.size() * 2 - 1));
                continue;
            }
            System.out.println("Couldn't find [" + t.getClassName() + "]");
        }
    }

    protected void drawTreeLines(ERDTable pNode, Graphics g) {
        Rectangle r = pNode.getBounds();
        int x = r.x + (r.width - 20) / 2;
        int y = r.y + r.height - 20;
        for (ERDTable k : pNode.getKids()) {
            Rectangle kr = k.getBounds();
            int kx = kr.x + (kr.width - 20) / 2;
            int ky = kr.y;
            g.setColor(this.lineColor1);
            g.drawLine(x, y, kx, ky - 1);
            this.drawTreeLines(k, g);
        }
        if (this.doDebugBoxes) {
            g.setColor(this.colors[this.colorInx % this.colors.length]);
            g.drawRect(pNode.getShiftX(), r.y, pNode.getSpace().width, pNode.getSpace().height);
            g.drawString(pNode.getTable().getName(), x, y + 20);
            ++this.colorInx;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.root != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.lineColor1);
            g2d.setStroke(new BasicStroke(2.0f));
            this.drawTreeLines(this.root, g);
            return;
        }
        if (!this.ignorePaint && this.mainTable != null) {
            if (this.firstPaint) {
                this.firstPaint = false;
                this.aboveCnt = 0;
                this.belowCnt = 0;
                for (DBRelationshipInfo rel : this.orderedList) {
                    String mName;
                    String rName = rel.getClassName();
                    if (rName.equals(mName = this.mainTable.getTable().getClassName())) continue;
                    JComponent src = this.mainTable.getRelUIHash().get(rel);
                    Rectangle srcB = src.getBounds();
                    Rectangle srcBP = src.getParent().getBounds();
                    int offsetY = srcB.y + srcBP.y;
                    JPanel dst = this.tblHash.get(rel.getClassName());
                    if (dst == null) {
                        System.out.println("Couldn't find [" + rel.getClassName() + "] " + this.tblHash.size());
                        continue;
                    }
                    Rectangle rDst = dst.getBounds();
                    Rectangle rDstP = dst.getParent().getBounds();
                    int y = offsetY + srcB.height / 2;
                    int dy = rDst.y + rDstP.y;
                    if (y > dy) {
                        ++this.aboveCnt;
                        continue;
                    }
                    ++this.belowCnt;
                }
            }
            Integer aboveGap = null;
            Integer belowGap = null;
            int xPosAbove = 0;
            int xPosBelow = 0;
            int cnt = 1;
            for (DBRelationshipInfo rel : this.orderedList) {
                String mName;
                String rName = rel.getClassName();
                if (rName.equals(mName = this.mainTable.getTable().getClassName())) continue;
                JComponent src = this.mainTable.getRelUIHash().get(rel);
                Rectangle srcB = src.getBounds();
                Rectangle srcBP = src.getParent().getBounds();
                int offsetX = srcB.x + srcBP.x;
                int offsetY = srcB.y + srcBP.y;
                JPanel dst = this.tblHash.get(rel.getClassName());
                if (dst == null) {
                    System.out.println("Couldn't find [" + rel.getClassName() + "] " + this.tblHash.size());
                    continue;
                }
                Rectangle rDst = dst.getBounds();
                Rectangle rDstP = dst.getParent().getBounds();
                int x = offsetX + srcB.width + 5;
                int y = offsetY + srcB.height / 2;
                int dx = rDst.x + rDstP.x;
                int dy = rDst.y + rDstP.y;
                if (aboveGap == null) {
                    aboveGap = (dx - x) / (this.aboveCnt + 1);
                    belowGap = (dx - x) / (this.belowCnt + 1);
                    xPosBelow = belowGap * (this.belowCnt + 1);
                }
                FontMetrics fm = g.getFontMetrics();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(cnt % 2 == 0 ? this.lineColor2 : this.lineColor1);
                g2d.setStroke(new BasicStroke(2.0f));
                int pos = y > (dy += fm.getAscent() / 2) ? (xPosAbove += aboveGap.intValue()) : (xPosBelow -= belowGap.intValue());
                if (rel.getType() == DBRelationshipInfo.RelationshipType.ManyToMany || rel.getType() == DBRelationshipInfo.RelationshipType.ManyToOne) {
                    g2d.fill(new Arc2D.Double(x + 1 - 5, y - 5, 10.0, 10.0, 270.0, 180.0, 0));
                }
                if (rel.getType() == DBRelationshipInfo.RelationshipType.OneToMany || rel.getType() == DBRelationshipInfo.RelationshipType.ManyToMany) {
                    g2d.fill(new Arc2D.Double(dx - 5, dy - 5, 10.0, 10.0, 90.0, 180.0, 0));
                }
                g.drawLine(x + 2, y, x + pos - 1, y);
                int ey = dy + (dy < y ? 1 : -1);
                g.drawLine(x + pos, y, x + pos, ey);
                g.drawLine(x + pos, dy, dx - 1, dy);
                ++cnt;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            System.out.println("ERDPanel getPreferredSize " + this.preferredSize);
            return this.preferredSize;
        }
        Dimension d = super.getPreferredSize();
        System.out.println("ERDPanel getPreferredSize " + d);
        return d;
    }

    public int addNode(ERDTable pNode, int xPos, int yPos, int level) {
        NodeInfo ni = this.tableTracker.getNodeInfo(pNode);
        if (this.usedHash.get(pNode) != null && !ni.isOkToDuplicate()) {
            return -1;
        }
        this.add(pNode);
        this.usedHash.put(pNode, true);
        Dimension space = pNode.getSpace();
        Dimension pSize = pNode.getPreferredSize();
        Dimension size = this.getSize();
        if (space.width > size.width || space.height > size.height) {
            int width = Math.max(size.width, space.width);
            int height = Math.max(size.height, space.height);
            this.setSize(width, height);
        }
        int x = xPos + (space.width - pSize.width) / 2;
        int y = yPos;
        pNode.setLocation(x, y);
        pNode.setSize(pSize);
        pNode.setShiftX(xPos);
        y = yPos + pSize.height + 10;
        int shiftedX = xPos;
        if (pNode.getKids().size() == 1) {
            shiftedX += (pNode.getSpace().width - pNode.getKids().get((int)0).getSpace().width) / 2;
        }
        for (ERDTable kid : pNode.getKids()) {
            int w = this.addNode(kid, shiftedX, y + pSize.height + 10, level + 1);
            if (w <= 0) continue;
            shiftedX += kid.getSpace().width + 10;
        }
        return pSize.width;
    }

    public void addTree(ERDTable root) {
        this.setLayout(null);
        this.addNode(root, 10, 10, 0);
        this.root = root;
        this.preferredSize = this.getSize();
        System.out.println(this.preferredSize + "\n" + super.getPreferredSize());
        if (ERDTable.getDisplayType() == ERDTable.DisplayType.Title) {
            this.preferredSize.width += 200;
        }
    }
}

