/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Appraisal;
import edu.ku.brc.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class DataModelClassGenerator
extends JFrame {
    private Hashtable<String, Boolean> baseClassHash = new Hashtable();
    protected Class<?> dataClass;
    protected JTextArea logArea;
    protected JTextField tableIdTxt;
    protected JTextField devTxt;
    protected Vector<UIRow> rows = new Vector();
    protected Hashtable<Field, UIRow> fieldRowhash = new Hashtable();

    public DataModelClassGenerator(Class<?> dataClass) {
        Class[] baseClasses;
        this.dataClass = dataClass;
        Class[] classArray = baseClasses = new Class[]{Boolean.class, Integer.class, Double.class, String.class, Float.class, Character.class, Short.class, Byte.class, BigDecimal.class, Date.class, Calendar.class};
        int n = baseClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            this.baseClassHash.put(cls.getSimpleName(), true);
            ++n2;
        }
        int cnt = 0;
        Field[] fieldArray = dataClass.getDeclaredFields();
        int n3 = fieldArray.length;
        n = 0;
        while (n < n3) {
            Field field = fieldArray[n];
            if (field.getType() == String.class || Collection.class.isAssignableFrom(field.getType())) {
                ++cnt;
            }
            ++n;
        }
        Font font = new Font("Courier", 0, 10);
        this.logArea = new JTextArea();
        this.logArea.setFont(font);
        this.tableIdTxt = new JTextField(10);
        this.devTxt = new JTextField(10);
        PanelBuilder outer = new PanelBuilder(new FormLayout("p,2px,p,2px,f:p:g", "200px:g,4px,f:300px:g,4px,p"));
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p,2px,l:p:g,2px,l:p", UIHelper.createDuplicateJGoodiesDef("p", "2px", cnt + 2)));
        CellConstraints cc = new CellConstraints();
        pb.add((Component)new JLabel("Table Id"), cc.xy(1, 1));
        pb.add((Component)this.tableIdTxt, cc.xywh(3, 1, 3, 1));
        pb.add((Component)new JLabel("Dev"), cc.xy(1, 3));
        pb.add((Component)this.devTxt, cc.xywh(3, 3, 3, 1));
        int y = 5;
        Field[] fieldArray2 = dataClass.getDeclaredFields();
        int n4 = fieldArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            UIRow row;
            Field field = fieldArray2[n5];
            if (field.getType() == String.class) {
                row = new UIRow(DataType.String, field);
                pb.add((Component)new JLabel(field.getName()), cc.xy(1, y));
                pb.add((Component)row.getSizetxt(), cc.xywh(3, y, 1, 1));
                y += 2;
                this.rows.add(row);
                this.fieldRowhash.put(field, row);
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                row = new UIRow(DataType.Set, field);
                pb.add((Component)new JLabel(field.getName()), cc.xy(1, y));
                pb.add((Component)row.getSizetxt(), cc.xywh(3, y, 3, 1));
                pb.add((Component)new JLabel("(Set)", 2), cc.xy(7, y));
                y += 2;
                this.rows.add(row);
                this.fieldRowhash.put(field, row);
            }
            ++n5;
        }
        JButton processBtn = UIHelper.createButton("Process");
        JButton cancelBtn = UIHelper.createButton("Cancel");
        processBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataModelClassGenerator.this.process();
            }
        });
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataModelClassGenerator.this.setVisible(false);
            }
        });
        pb.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel panel = ButtonBarFactory.buildGrowingBar((JButton[])new JButton[]{processBtn, cancelBtn});
        outer.add((Component)new JScrollPane(pb.getPanel(), 20, 30), cc.xywh(1, 1, 5, 1));
        outer.add((Component)new JScrollPane(this.logArea, 20, 30), cc.xywh(1, 3, 5, 1));
        outer.add((Component)panel, cc.xy(5, 5));
        this.setDefaultCloseOperation(2);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)outer.getPanel(), "Center");
        this.setContentPane(p);
        this.pack();
        this.setSize(500, this.getSize().height);
    }

    public void process() {
        String template = "";
        try {
            File templateFile = new File("src/edu/ku/brc/specify/utilapps/DataModelGenTemplate.txt");
            template = FileUtils.readFileToString((File)templateFile);
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataModelClassGenerator.class, ex);
            ex.printStackTrace();
            return;
        }
        String className = this.dataClass.getSimpleName();
        String noCapClassName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1);
        String idName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1) + "Id";
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy");
        template = StringUtils.replace((String)template, (String)"<!-- TableName -->", (String)className.toLowerCase());
        template = StringUtils.replace((String)template, (String)"<!-- ClassName -->", (String)className);
        template = StringUtils.replace((String)template, (String)"<!-- Id -->", (String)idName);
        template = StringUtils.replace((String)template, (String)"<!-- IdNum -->", (String)this.tableIdTxt.getText());
        template = StringUtils.replace((String)template, (String)"<!-- Dev -->", (String)this.devTxt.getText());
        template = StringUtils.replace((String)template, (String)"<!-- Date -->", (String)sdf.format(Calendar.getInstance().getTime()));
        Hashtable<String, Boolean> duplicateClassNames = new Hashtable<String, Boolean>();
        Field[] fieldArray = this.dataClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            UIRow row = this.fieldRowhash.get(field);
            String fieldsType = row != null && row.getSizetxt() != null ? row.getSizetxt().getText() : field.getType().getSimpleName();
            Boolean bool = (Boolean)duplicateClassNames.get(fieldsType);
            if (bool == null) {
                duplicateClassNames.put(fieldsType, false);
            } else if (!bool.booleanValue()) {
                duplicateClassNames.put(fieldsType, true);
            }
            ++n2;
        }
        StringBuilder declarationsSB = new StringBuilder();
        StringBuilder initersSB = new StringBuilder();
        StringBuilder methodsSB = new StringBuilder();
        StringBuilder osDeclarationsSB = new StringBuilder();
        StringBuilder osInitersSB = new StringBuilder();
        StringBuilder osMethodsSB = new StringBuilder();
        int maxWidth = 0;
        Field[] fieldArray2 = this.dataClass.getDeclaredFields();
        int n3 = fieldArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Field field = fieldArray2[n4];
            UIRow row = this.fieldRowhash.get(field);
            String typeStr = row != null && row.isSet() ? String.valueOf(field.getType().getSimpleName()) + "<" + row.getSizetxt().getText() + ">" : field.getType().getSimpleName();
            maxWidth = Math.max(maxWidth, typeStr.length());
            ++n4;
        }
        int initerMaxWidth = 0;
        Field[] fieldArray3 = this.dataClass.getDeclaredFields();
        int n5 = fieldArray3.length;
        n3 = 0;
        while (n3 < n5) {
            Field field = fieldArray3[n3];
            initerMaxWidth = Math.max(initerMaxWidth, field.getName().length());
            ++n3;
        }
        String prevType = "";
        Field[] fieldArray4 = this.dataClass.getDeclaredFields();
        int n6 = fieldArray4.length;
        n5 = 0;
        while (n5 < n6) {
            boolean isNewOSClassType;
            Field field = fieldArray4[n5];
            String fieldName = field.getName();
            UIRow row = this.fieldRowhash.get(field);
            boolean isSet = row != null && row.isSet();
            boolean isThereMoreThanOne = false;
            String othersideClassType = "";
            String othersideFieldName = "";
            String othersideMethodName = "";
            String otherSideID = "";
            boolean isFieldObj = false;
            String fieldsType = row != null ? (isSet ? row.getSizetxt().getText() : field.getType().getSimpleName()) : field.getType().getSimpleName();
            if (!isSet) {
                boolean bl = isFieldObj = this.baseClassHash.get(fieldsType) != null;
                if (!isFieldObj) {
                    othersideClassType = "Set<" + className + ">";
                    boolean bl2 = isThereMoreThanOne = duplicateClassNames.get(fieldsType) != null && (Boolean)duplicateClassNames.get(fieldsType) != false;
                    if (isThereMoreThanOne) {
                        String fName = fieldName.substring(0, fieldName.length() - 1);
                        othersideFieldName = String.valueOf(fName) + className + "s";
                        othersideMethodName = String.valueOf(StringUtils.capitalize((String)fName)) + className + "s";
                        otherSideID = String.valueOf(fName) + className + "ID";
                    } else {
                        othersideFieldName = String.valueOf(noCapClassName) + "s";
                        othersideMethodName = String.valueOf(className) + "s";
                        otherSideID = String.valueOf(className) + "ID";
                    }
                }
            } else {
                othersideClassType = className;
                boolean bl = isThereMoreThanOne = duplicateClassNames.get(fieldsType) != null && (Boolean)duplicateClassNames.get(fieldsType) != false;
                if (isThereMoreThanOne) {
                    String fName = fieldName.substring(0, fieldName.length() - 1);
                    othersideFieldName = String.valueOf(fName) + className;
                    othersideMethodName = String.valueOf(StringUtils.capitalize((String)fName)) + className;
                    otherSideID = String.valueOf(fName) + className + "ID";
                } else {
                    othersideFieldName = noCapClassName;
                    othersideMethodName = className;
                    otherSideID = String.valueOf(className) + "ID";
                }
            }
            boolean bl = isNewOSClassType = !fieldsType.equals(prevType);
            if (isNewOSClassType) {
                prevType = fieldsType;
            }
            boolean doOtherSide = isSet || !isFieldObj;
            String typeStr = row != null && row.isSet() ? String.valueOf(field.getType().getSimpleName()) + "<" + row.getSizetxt().getText() + ">" : field.getType().getSimpleName();
            declarationsSB.append("    protected ");
            declarationsSB.append(typeStr);
            int i = 0;
            while (i < maxWidth - typeStr.length() + 1) {
                declarationsSB.append(' ');
                ++i;
            }
            declarationsSB.append(field.getName());
            declarationsSB.append(";\n");
            if (doOtherSide) {
                if (isNewOSClassType) {
                    osDeclarationsSB.append("\n\n    // Copy this Code into Class " + fieldsType + "\n\n");
                }
                osDeclarationsSB.append("    protected ");
                osDeclarationsSB.append(othersideClassType);
                i = 0;
                while (i < maxWidth - typeStr.length() + 1) {
                    osDeclarationsSB.append(' ');
                    ++i;
                }
                osDeclarationsSB.append(othersideFieldName);
                osDeclarationsSB.append(";\n");
            }
            typeStr = row != null && row.isSet() ? "new HashSet<" + row.getSizetxt().getText() + ">()" : "null";
            initersSB.append("        ");
            initersSB.append(field.getName());
            i = 0;
            while (i < initerMaxWidth - field.getName().length() + 1) {
                initersSB.append(' ');
                ++i;
            }
            initersSB.append(" = ");
            initersSB.append(typeStr);
            initersSB.append(";\n");
            if (doOtherSide && !isFieldObj) {
                if (isNewOSClassType) {
                    osInitersSB.append("\n\n    // Copy this Code into Class " + fieldsType + "\n\n");
                }
                osInitersSB.append("        ");
                osInitersSB.append(othersideFieldName);
                i = 0;
                while (i < initerMaxWidth - field.getName().length() + 1) {
                    osInitersSB.append(' ');
                    ++i;
                }
                osInitersSB.append(" = ");
                if (othersideClassType.startsWith("Set")) {
                    osInitersSB.append("new HashSet<" + (row != null ? row.getSizetxt().getText() : className) + ">()");
                } else {
                    osInitersSB.append("null");
                }
                osInitersSB.append(";\n");
            }
            if (isSet) {
                typeStr = String.valueOf(field.getType().getSimpleName()) + "<" + row.getSizetxt().getText() + ">";
                isSet = true;
            } else {
                typeStr = field.getType().getSimpleName();
            }
            methodsSB.append("    /**\n");
            methodsSB.append("     *\n");
            methodsSB.append("     */\n");
            String size = "";
            if (row != null) {
                if (row.isCBXString()) {
                    size = row.getSizetxt().getText();
                } else if (row.getType() != DataType.Set) {
                    methodsSB.append("    @Lob\n");
                }
            } else if (field.getType() == Date.class || field.getType() == Calendar.class) {
                methodsSB.append("    @Temporal(TemporalType.DATE)\n");
            }
            if (isSet) {
                String singularFieldName = field.getName().substring(0, fieldName.length() - 1);
                methodsSB.append("    @OneToMany(cascade = {}, fetch = FetchType.LAZY, mappedBy = \"" + singularFieldName + "\")\n");
            } else if (this.baseClassHash.get(field.getType()) != null) {
                methodsSB.append("    @Column(name = \"" + StringUtils.capitalize((String)fieldName) + "\", unique = false, nullable = true, insertable = true, updatable = true" + (StringUtils.isNotEmpty((String)size) ? ", length = " + size : "") + ")\n");
            } else {
                methodsSB.append("    @ManyToOne(cascade = {}, fetch = FetchType.LAZY)\n");
                methodsSB.append("    @Cascade( { CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK })\n");
                methodsSB.append("    @JoinColumn(name = \"" + className + "ID\", unique = false, nullable = true, insertable = true, updatable = true)\n");
            }
            methodsSB.append("    public " + typeStr + " get" + StringUtils.capitalize((String)fieldName) + "()\n    {\n");
            methodsSB.append("        return this." + fieldName + ";\n");
            methodsSB.append("    }\n\n");
            methodsSB.append("    public void set" + StringUtils.capitalize((String)fieldName) + "(final " + typeStr + " " + fieldName + ")\n    {\n");
            methodsSB.append("        this." + fieldName + " = " + fieldName + ";\n");
            methodsSB.append("    }\n\n");
            if (fieldsType.startsWith("Agent")) {
                int x = 0;
                ++x;
            }
            if (doOtherSide && !isFieldObj) {
                if (isNewOSClassType) {
                    osMethodsSB.append("\n\n    // Copy this Code into Class " + fieldsType + "\n\n");
                }
                osMethodsSB.append("    /**\n");
                osMethodsSB.append("     *\n");
                osMethodsSB.append("     */\n");
                if (isSet) {
                    osMethodsSB.append("    @OneToMany(cascade = {}, fetch = FetchType.LAZY, mappedBy = \"" + fieldName + "\")\n");
                } else {
                    osMethodsSB.append("    @ManyToOne(cascade = {}, fetch = FetchType.LAZY)\n");
                    osMethodsSB.append("    @Cascade( { CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK })\n");
                    osMethodsSB.append("    @JoinColumn(name = \"" + otherSideID + "\", unique = false, nullable = true, insertable = true, updatable = true)\n");
                }
                osMethodsSB.append("    public " + othersideClassType + " get" + othersideMethodName + "()\n    {\n");
                osMethodsSB.append("        return this." + othersideFieldName + ";\n");
                osMethodsSB.append("    }\n\n");
                osMethodsSB.append("    public void set" + othersideMethodName + "(final " + othersideClassType + " " + othersideFieldName + ")\n    {\n");
                osMethodsSB.append("        this." + othersideFieldName + " = " + othersideFieldName + ";\n");
                osMethodsSB.append("    }\n\n");
            }
            ++n5;
        }
        template = StringUtils.replace((String)template, (String)"<!-- Fields -->", (String)declarationsSB.toString());
        template = StringUtils.replace((String)template, (String)"<!-- Initers -->", (String)initersSB.toString());
        template = StringUtils.replace((String)template, (String)"<!-- Methods -->", (String)methodsSB.toString());
        StringBuilder sb = new StringBuilder();
        sb.append("/* ---------------------------------------------\n");
        sb.append((CharSequence)osDeclarationsSB);
        sb.append((CharSequence)osInitersSB);
        sb.append((CharSequence)osMethodsSB);
        sb.append("\n*/");
        this.logArea.setText(String.valueOf(template) + sb.toString());
        try {
            File outFile = new File(String.valueOf(className) + ".java");
            FileUtils.writeStringToFile((File)outFile, (String)(String.valueOf(template) + sb.toString()));
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataModelClassGenerator.class, ex);
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIHelper.OSTYPE osType = UIHelper.getOSType();
                    if (osType == UIHelper.OSTYPE.Windows) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                    } else if (osType == UIHelper.OSTYPE.Linux) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(DataModelClassGenerator.class, e);
                }
                DataModelClassGenerator dmcg = new DataModelClassGenerator(Appraisal.class);
                UIHelper.centerAndShow(dmcg);
            }
        });
    }

    static enum DataType {
        String,
        Memo,
        Set;

    }

    class UIRow {
        protected Field field;
        protected JTextField sizetxt;
        protected JComboBox typeCBX = null;
        protected DataType type;

        public UIRow(DataType type, Field field) {
            this.type = type;
            this.field = field;
            this.sizetxt = new JTextField(type == DataType.String ? 5 : 15);
            if (type != DataType.Set) {
                this.typeCBX = UIHelper.createComboBox(new String[]{"Memo", "String"});
                this.typeCBX.setSelectedIndex(0);
            }
        }

        public JTextField getSizetxt() {
            return this.sizetxt;
        }

        public JComboBox getTypeCBX() {
            return this.typeCBX;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public boolean isSet() {
            return this.type == DataType.Set;
        }

        public boolean isCBXString() {
            return this.sizetxt.getText() != null;
        }

        public DataType getType() {
            return this.type;
        }
    }
}

