/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerXMLHelper;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.DatamodelHelper;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class CreateTextSchema {
    private static Locale currLang = new Locale("en");
    private static byte SCHEMATYPE = SpLocaleContainer.CORE_SCHEMA;
    protected static String schemaOutputHTMLName = "SpecifySchema%s.html";
    protected static String NBSP = "&nbsp;";
    protected static String VERSION = "<!-- Version -->";
    protected static DBTableIdMgr tableMgr;
    protected String basePath = "src/edu/ku/brc/specify/utilapps/";
    protected PrintWriter po = null;

    public CreateTextSchema() {
        System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
        if (SCHEMATYPE == SpLocaleContainer.CORE_SCHEMA) {
            tableMgr = DBTableIdMgr.getInstance();
        } else {
            tableMgr = new DBTableIdMgr(false);
            tableMgr.initialize(new File(XMLHelper.getConfigDirPath("specify_workbench_datamodel.xml")));
        }
    }

    protected void processRel(DBRelationshipInfo field, boolean includeIndexCol) {
        String clsName = field.getClassName();
        int inx = clsName.lastIndexOf(46);
        clsName = inx > -1 ? clsName.substring(inx + 1) : clsName;
        DBTableInfo toTable = tableMgr.getInfoByTableName(clsName = clsName.toLowerCase());
        if (toTable != null) {
            clsName = toTable.getTitle();
        }
        this.po.write("<tr>\n");
        this.po.write("<td align=\"center\" colspan=\"2\">\n");
        this.po.write(field.getType().toString());
        this.po.write("</td>\n");
        this.po.write("<td align=\"center\" colspan=\"" + (includeIndexCol ? 2 : 1) + "\">\n");
        this.po.write(field.getTitle());
        this.po.write("</td>\n");
        this.po.write("<td align=\"center\" colspan=\"1\">\n");
        this.po.write(clsName);
        this.po.write("</td>\n");
        this.po.write("</tr>\n");
    }

    protected void processField(DBFieldInfo field, boolean isID, boolean includeIndexCol) {
        String type = field.getType();
        int inx = type.lastIndexOf(46);
        type = inx > -1 ? type.substring(inx + 1) : type;
        this.po.write("<tr>\n");
        this.po.write("<td align=\"center\">\n");
        this.po.write(field.getTitle());
        this.po.write("</td>\n");
        this.po.write("<td align=\"center\">\n");
        this.po.write(type.equals("text") ? "Memo" : type);
        this.po.write("</td>\n");
        this.po.write("        <td align=\"center\">\n");
        this.po.write(field.getLength() > -1 ? Integer.toString(field.getLength()) : NBSP);
        this.po.write("        </td>\n");
        if (includeIndexCol) {
            this.po.write("        <td align=\"center\">\n");
            this.po.write(isID ? field.getTitle() : field.getName());
            this.po.write("        </td>\n");
        }
        if (field.getDescription() != null && field.getDescription().equals(field.getName())) {
            field.setDescription(null);
        }
        this.po.write("<td align=\"left\">\n");
        this.po.write(isID ? UIRegistry.getResourceString("PrimaryKey") : this.getStr(field.getDescription()));
        this.po.write("</td>\n");
        this.po.write("</tr>\n");
    }

    protected void makeIndex(Vector<DBTableInfo> tables) {
        for (DBTableInfo tn : tables) {
            DBTableInfo tblInfo = tableMgr.getInfoByTableName(tn.getName());
            this.po.write("<LI> <a href=\"#" + tn.getName() + "\">" + tblInfo.getTitle() + "</a></LI>\n");
        }
    }

    protected void makeTableDesc(Vector<DBTableInfo> tables) {
        for (DBTableInfo tn : tables) {
            DBTableInfo tblInfo = tableMgr.getInfoByTableName(tn.getName());
            this.po.write("<LI> <a href=\"#" + tn.getName() + "\">" + tblInfo.getTitle() + "</a></LI>\n");
        }
    }

    protected void makeTableIndexes(Vector<DBTableInfo> tables) {
        this.po.write("    <tr>\n");
        this.po.write("        <td class=\"hd\" colspan=\"1\">" + UIRegistry.getResourceString("IndexName") + "</td>\n");
        this.po.write("        <td class=\"hd\" colspan=\"1\">" + UIRegistry.getResourceString("ColumnName") + "</td>\n");
        this.po.write("        <td class=\"hd\" colspan=\"1\">" + UIRegistry.getResourceString("Table") + "</td>\n");
        this.po.write("    </tr>\n");
        for (DBTableInfo tn : tables) {
            System.out.println("Indexing " + tn.getName());
            Hashtable<String, String> colToTitle = new Hashtable<String, String>();
            for (DBFieldInfo fi : tn.getFields()) {
                colToTitle.put(fi.getColumn(), StringUtils.isNotEmpty((String)fi.getTitle()) ? fi.getTitle() : fi.getColumn());
            }
            if (tn.getTableIndexMap() == null) continue;
            Vector<String> keys = new Vector<String>(tn.getTableIndexMap().keySet());
            Collections.sort(keys);
            for (String key : keys) {
                String title = (String)colToTitle.get(key);
                if (StringUtils.isNotEmpty((String)title)) {
                    title = key;
                }
                this.po.write("<tr>\n");
                this.po.write("<td align=\"center\">");
                this.po.write(tn.getTableIndexMap().get(key));
                this.po.write("</td>\n");
                this.po.write("<td align=\"center\">");
                this.po.write(key);
                this.po.write("</td>\n");
                this.po.write("<td align=\"center\">");
                this.po.write("    <a href=\"#" + tn.getName() + "\">");
                this.po.write(tn.getTitle());
                this.po.write("</a>");
                this.po.write("</td>\n");
                this.po.write("</tr>\n");
            }
        }
    }

    private String getStr(String str) {
        return StringUtils.isNotEmpty((String)str) ? str : NBSP;
    }

    protected void processDescs(Vector<DBTableInfo> tables) {
        this.po.write("    <tr>\n");
        this.po.write("        <td class=\"hd\" colspan=\"1\">" + UIRegistry.getResourceString("Table") + "</td>\n");
        this.po.write("        <td class=\"hd\" colspan=\"1\">" + UIRegistry.getResourceString("Description") + "</td>\n");
        this.po.write("    </tr>\n");
        for (DBTableInfo tn : tables) {
            this.po.write("<tr>\n");
            this.po.write("<td nowrap=\"true\" align=\"left\">");
            this.po.write("    <a href=\"#" + tn.getName() + "\">");
            this.po.write(tn.getTitle());
            this.po.write("</a>");
            this.po.write("</td>\n");
            this.po.write("<td align=\"left\">");
            this.po.write(this.getStr(tn.getDescription()));
            this.po.write("</td>\n");
            this.po.write("</tr>\n");
        }
    }

    protected void processTables(Vector<DBTableInfo> tables, boolean includeIndexCol) {
        for (DBTableInfo tn : tables) {
            System.out.println("Processing " + tn.getName());
            this.po.write("<a name=\"" + tn.getName() + "\"></a>\n");
            this.po.write("<table class=\"tbl\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\"\n");
            this.po.write("    width=\"75%\">\n");
            this.po.write("    <tr>\n");
            this.po.write("        <td colspan=\"5\" class=\"hdbig\">\n");
            this.po.write("            " + tn.getTitle() + "\n");
            if (StringUtils.isNotEmpty((String)tn.getDescription())) {
                this.po.write("            <br />\n");
                this.po.write("            <div class=\"desc\">\n");
                this.po.write("                " + tn.getDescription() + "\n");
                this.po.write("            </div>\n");
            }
            this.po.write("        </td>\n");
            this.po.write("    </tr>\n");
            this.po.write("    <tr>\n");
            this.po.write("        <td class=\"hd\">" + UIRegistry.getResourceString("Field") + "</td>\n");
            this.po.write("        <td class=\"hd\">" + UIRegistry.getResourceString("Type") + "</td>\n");
            this.po.write("        <td class=\"hd\">" + UIRegistry.getResourceString("Length") + "</td>\n");
            if (includeIndexCol) {
                this.po.write("        <td class=\"hd\">" + UIRegistry.getResourceString("IndexName") + "</td>\n");
            }
            this.po.write("        <td class=\"hd\">" + UIRegistry.getResourceString("Descriptions") + "</td>\n");
            this.po.write("    </tr>\n");
            DBFieldInfo primaryField = new DBFieldInfo(tn, tn.getIdColumnName(), tn.getIdColumnName(), tn.getIdType(), -1, true, false, true, true, false, null);
            this.processField(primaryField, true, includeIndexCol);
            for (DBFieldInfo fn : tn.getFields()) {
                this.processField(fn, false, includeIndexCol);
            }
            this.po.write("    <tr>\n");
            this.po.write("        <td colspan=\"5\" class=\"subhead\">" + UIRegistry.getResourceString("Relationships") + "</td>\n");
            this.po.write("    </tr>\n");
            this.po.write("    <tr>\n");
            this.po.write("        <td class=\"hd\" colspan=\"2\">" + UIRegistry.getResourceString("Type") + "</td>\n");
            this.po.write("        <td class=\"hd\" colspan=\"" + (includeIndexCol ? 2 : 1) + "\">" + UIRegistry.getResourceString("Name") + "</td>\n");
            this.po.write("        <td class=\"hd\" colspan=\"1\">" + UIRegistry.getResourceString("ToTable") + "</td>\n");
            this.po.write("    </tr>\n");
            for (DBRelationshipInfo rn : tn.getRelationships()) {
                this.processRel(rn, includeIndexCol);
            }
            this.po.write("</table>\n");
            this.po.write("<br />\n");
            this.po.write("<br />\n");
        }
    }

    private String adjustFileNameForLocale(String fileName) {
        if (currLang.getLanguage().equals("en")) {
            return String.format(fileName, "");
        }
        return String.format(fileName, "_" + currLang.getLanguage());
    }

    protected void process(String versionNum) {
        try {
            File oFile = new File(this.adjustFileNameForLocale(schemaOutputHTMLName));
            this.po = new PrintWriter(oFile, "UTF8");
            System.out.println("Opening " + XMLHelper.getConfigDirPath(DatamodelHelper.getOutputFileName()));
            System.out.println("Writing " + oFile.getAbsolutePath());
            Vector<DBTableInfo> tables = tableMgr.getTables();
            Collections.sort(tables);
            SchemaLocalizerXMLHelper schemaXMLHelper = new SchemaLocalizerXMLHelper(SCHEMATYPE, tableMgr);
            schemaXMLHelper.load(true);
            schemaXMLHelper.setTitlesIntoSchema();
            List lines = FileUtils.readLines((File)new File(String.valueOf(this.basePath) + this.adjustFileNameForLocale("SpecifySchemaTemplate%s.html")));
            for (String line : lines) {
                if (StringUtils.contains((String)line, (String)"<!-- Table Defs -->")) {
                    this.processTables(tables, false);
                } else if (StringUtils.contains((String)line, (String)"<!-- Table Contents -->")) {
                    this.makeIndex(tables);
                } else if (StringUtils.contains((String)line, (String)"<!-- Table Descs -->")) {
                    this.processDescs(tables);
                } else if (StringUtils.contains((String)line, (String)"<!-- Date -->")) {
                    Calendar cal = Calendar.getInstance();
                    SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy");
                    line = StringUtils.replace((String)line, (String)"<!-- Date -->", (String)sdf.format(cal.getTime()));
                } else if (StringUtils.contains((String)line, (String)"<!-- Indexes -->")) {
                    this.makeTableIndexes(tables);
                } else if (StringUtils.contains((String)line, (String)VERSION)) {
                    line = StringUtils.replace((String)line, (String)VERSION, (String)versionNum);
                }
                this.po.write(line);
                this.po.write("\n");
            }
            this.po.flush();
            this.po.close();
            System.out.println(oFile.getAbsolutePath());
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(CreateTextSchema.class, ex);
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIHelper.OSTYPE osType = UIHelper.getOSType();
                    if (osType == UIHelper.OSTYPE.Windows) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                    } else if (osType == UIHelper.OSTYPE.Linux) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                    }
                }
                catch (Exception osType) {
                    // empty catch block
                }
                String schemaVersion = JOptionPane.showInputDialog("Enter Schema Version:");
                Locale.setDefault(currLang);
                try {
                    ResourceBundle.getBundle("resources", Locale.getDefault());
                }
                catch (MissingResourceException ex) {
                    Locale.setDefault(Locale.ENGLISH);
                    UIRegistry.setResourceLocale(Locale.ENGLISH);
                }
                CreateTextSchema cts = new CreateTextSchema();
                cts.process(schemaVersion);
                JOptionPane.showMessageDialog(null, "Done");
            }
        });
    }
}

