/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.specify.config.DisciplineType;

public class CollectionChoice {
    protected DisciplineType.STD_DISCIPLINES type;
    protected String name;
    protected boolean isTissue;
    protected boolean isSelected;
    protected String catalogNumberingFmtName;
    protected String accessionNumberingFmtName;
    protected String catNumScheme;
    protected String accNumScheme;
    protected UIFieldFormatterIFace catNumberFormatter = null;
    protected UIFieldFormatterIFace accNumberFormatter = null;

    public CollectionChoice() {
    }

    public CollectionChoice(DisciplineType.STD_DISCIPLINES type, boolean isTissue, boolean isSelected) {
        this.type = type;
        this.isTissue = isTissue;
        this.isSelected = isSelected;
        this.name = type.toString();
    }

    public void initialize() {
        this.type = DisciplineType.STD_DISCIPLINES.valueOf(this.name);
    }

    public DisciplineType.STD_DISCIPLINES getType() {
        return this.type;
    }

    public void setType(DisciplineType.STD_DISCIPLINES type) {
        this.type = type;
        this.name = type.toString();
    }

    public boolean isTissue() {
        return this.isTissue;
    }

    public void setTissue(boolean isTissue) {
        this.isTissue = isTissue;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCatalogNumberingFmtName() {
        return this.catalogNumberingFmtName;
    }

    public void setCatalogNumberingFmtName(String catalogNumberingFmtName) {
        this.catalogNumberingFmtName = catalogNumberingFmtName;
        this.catNumberFormatter = null;
    }

    public String getAccessionNumberingFmtName() {
        return this.accessionNumberingFmtName;
    }

    public void setAccessionNumberingFmtName(String accessionNumberingFmtName) {
        this.accessionNumberingFmtName = accessionNumberingFmtName;
        this.accNumberFormatter = null;
    }

    public String getCatNumGroup() {
        return this.catNumScheme;
    }

    public void setCatNumGroup(String catNumGroup) {
        this.catNumScheme = catNumGroup;
    }

    public String getAccNumGroup() {
        return this.accNumScheme;
    }

    public void setAccNumGroup(String accNumGroup) {
        this.accNumScheme = accNumGroup;
    }

    public UIFieldFormatterIFace getCatNumberFormatter() {
        if (this.catNumberFormatter == null) {
            this.catNumberFormatter = UIFieldFormatterMgr.getInstance().getFormatter(this.catalogNumberingFmtName);
        }
        return this.catNumberFormatter;
    }

    public void setCatNumberFormatter(UIFieldFormatterIFace catNumberFormatter) {
        this.catNumberFormatter = catNumberFormatter;
    }

    public UIFieldFormatterIFace getAccNumberFormatter() {
        if (this.accNumberFormatter == null) {
            this.accNumberFormatter = UIFieldFormatterMgr.getInstance().getFormatter(this.accessionNumberingFmtName);
        }
        return this.accNumberFormatter;
    }

    public void setAccNumberFormatter(UIFieldFormatterIFace accNumberFormatter) {
        this.accNumberFormatter = accNumberFormatter;
    }

    public String toString() {
        DisciplineType dType = DisciplineType.getDiscipline(this.type);
        return String.valueOf(dType.getTitle()) + (this.isTissue ? " Tissue" : "");
    }

    public static void config(XStream xstream) {
        xstream.alias("choice", CollectionChoice.class);
        xstream.useAttributeFor(CollectionChoice.class, "name");
        xstream.useAttributeFor(CollectionChoice.class, "isTissue");
        xstream.useAttributeFor(CollectionChoice.class, "isSelected");
        xstream.useAttributeFor(CollectionChoice.class, "accessionNumberingFmtName");
        xstream.useAttributeFor(CollectionChoice.class, "catalogNumberingFmtName");
        xstream.useAttributeFor(CollectionChoice.class, "catNumScheme");
        xstream.useAttributeFor(CollectionChoice.class, "accNumScheme");
        xstream.omitField(CollectionChoice.class, "type");
        xstream.omitField(CollectionChoice.class, "catNumberFormatter");
        xstream.omitField(CollectionChoice.class, "accNumberFormatter");
    }
}

