/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.utilapps;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.BackupServiceFactory;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.AttributeIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.init.BldrPickList;
import edu.ku.brc.specify.config.init.BldrPickListItem;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.config.init.HiddenTableMgr;
import edu.ku.brc.specify.config.init.TaxonLoadSetupPanel;
import edu.ku.brc.specify.config.init.TreeDefRow;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.AccessionAgent;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AgentAttachment;
import edu.ku.brc.specify.datamodel.AgentVariant;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.AttachmentMetadata;
import edu.ku.brc.specify.datamodel.AttributeDef;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectingEventAttr;
import edu.ku.brc.specify.datamodel.CollectingTrip;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionObjectAttr;
import edu.ku.brc.specify.datamodel.CollectionRelType;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.ConservDescription;
import edu.ku.brc.specify.datamodel.ConservEvent;
import edu.ku.brc.specify.datamodel.DNASequence;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.DataType;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeographyTreeDefItem;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDefItem;
import edu.ku.brc.specify.datamodel.GroupPerson;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.Journal;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.LithoStratTreeDefItem;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.LocalityCitation;
import edu.ku.brc.specify.datamodel.Permit;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.ReferenceWork;
import edu.ku.brc.specify.datamodel.RepositoryAgreement;
import edu.ku.brc.specify.datamodel.SpLocaleBase;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpLocaleContainerItem;
import edu.ku.brc.specify.datamodel.SpLocaleItemStr;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpQueryField;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.StorageTreeDefItem;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonCitation;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.specify.datamodel.TreeDefItemStandardEntry;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchRowImage;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.dbsupport.BuildFromGeonames;
import edu.ku.brc.specify.dbsupport.HibernateDataProviderSession;
import edu.ku.brc.specify.dbsupport.SpecifyDeleteHelper;
import edu.ku.brc.specify.tools.SpecifySchemaGenerator;
import edu.ku.brc.specify.tools.schemalocale.DisciplineBasedContainer;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerXMLHelper;
import edu.ku.brc.specify.treeutils.NodeNumberer;
import edu.ku.brc.specify.treeutils.TreeFactory;
import edu.ku.brc.specify.treeutils.TreeHelper;
import edu.ku.brc.specify.utilapps.CollectionChoice;
import edu.ku.brc.specify.utilapps.SetUpBuildDlg;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.FileStoreAttachmentManager;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.dom4j.Element;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class BuildSampleDatabase {
    private static final Logger log = Logger.getLogger(BuildSampleDatabase.class);
    private static String[] TaxonIndexNames = new String[]{"family common name", "species author", "species source", "species lsid", "species common name", "subspecies author", "subspecies source", "subspecies lsid", "subspecies common name"};
    private static String[] TaxonFieldNames = new String[]{"CommonName", "Author", "Source", "GUID", "CommonName", "Author", "Source", "GUID", "CommonName"};
    private static int FAMILY_COMMON_NAME = 0;
    private static int SPECIES_AUTHOR = 1;
    private static int SPECIES_SOURCE = 2;
    private static int SPECIES_LSID = 3;
    private static int SPECIES_COMMON_NAME = 4;
    private static int SUBSPECIES_AUTHOR = 5;
    private static int SUBSPECIES_SOURCE = 6;
    private static int SUBSPECIES_LSID = 7;
    private static int SUBSPECIES_COMMON_NAME = 8;
    private static String SHOW = "show";
    private static String NAME = "name";
    private static String RANK = "rank";
    protected Hashtable<String, Integer> taxonExtraColsIndexes = new Hashtable();
    protected Hashtable<String, Integer> taxonIndexes = new Hashtable();
    protected static boolean debugOn = false;
    protected static final int TIME_THRESHOLD = 3000;
    protected static Hashtable<String, Boolean> fieldsToHideHash = new Hashtable();
    protected static Hashtable<String, Boolean> fieldsToSkipHash = new Hashtable();
    protected static List<Object> locs = null;
    protected Calendar calendar = Calendar.getInstance();
    protected Session session;
    protected int steps = 0;
    protected ProgressFrame frame;
    protected Properties initPrefs = null;
    protected Properties backstopPrefs = null;
    protected SetUpBuildDlg setupDlg = null;
    protected boolean hideFrame = false;
    protected boolean doAddQueries = false;
    protected boolean copyToUserDir = true;
    protected boolean doShallowTaxonTree = false;
    protected List<CollectionChoice> selectedChoices = null;
    protected Hashtable<Class<?>, Vector<AutoNumberingScheme>> numberingSchemesHash = new Hashtable();
    protected Random rand = new Random(12345678L);
    protected Vector<Locality> globalLocalities = new Vector();
    protected Vector<Agent> globalAgents = new Vector();
    protected int stationFieldNumberCounter = 100;
    protected String STATION_FIELD_FORMAT = "RS%03d";
    protected int NUM_LOCALTIES = 50000;
    protected int NUM_COLOBJS = 50000;
    protected boolean doHugeBotany = false;
    protected DataType dataType;
    protected StorageTreeDef stgTreeDef = null;
    protected int createStep = 0;
    protected Transaction trans = null;
    protected static Timestamp now = new Timestamp(System.currentTimeMillis());
    protected static SimpleDateFormat dateTimeFormatter;
    protected static SimpleDateFormat dateFormatter;
    protected static String nowStr;
    protected LinkedList<Pair<String, Integer>> recycler = new LinkedList();
    protected StringBuilder gSQLStr = new StringBuilder();
    protected NumberFormat numFmt = NumberFormat.getInstance();
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    protected int recCnt = 0;

    public BuildSampleDatabase() {
        dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        nowStr = "'" + dateTimeFormatter.format(now) + "'";
        this.numFmt.setMinimumFractionDigits(0);
        this.numFmt.setMaximumFractionDigits(20);
        this.numFmt.setGroupingUsed(false);
    }

    public Session getSession() {
        return this.session;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setSession(Session s) {
        this.session = s;
    }

    public ProgressFrame getFrame() {
        return this.frame;
    }

    protected void standardQueries(Vector<Object> dataObjects, Agent userAgent) {
        if (this.doAddQueries) {
            Byte greq = SpQueryField.OperatorType.GREATERTHANEQUALS.getOrdinal();
            Byte lteq = SpQueryField.OperatorType.LESSTHANEQUALS.getOrdinal();
            Byte asc = SpQueryField.SortType.ASC.getOrdinal();
            SpQuery query = DataBuilder.createQuery("CO " + AppContextMgr.getInstance().getClassObject(Collection.class).getCollectionName(), "CollectionObject", 1, AppContextMgr.getInstance().getClassObject(SpecifyUser.class), userAgent);
            DataBuilder.createQueryField(query, (short)0, "catalogNumber", "Catalog Number", false, greq, lteq, "102", "103", asc, true, "1", 1);
            query.setIsFavorite(true);
            dataObjects.add(query);
        }
    }

    private AutoNumberingScheme getAutoNumberingScheme(Class<?> clazz, String name) {
        Vector<AutoNumberingScheme> numberingSchemes = this.numberingSchemesHash.get(clazz);
        if (numberingSchemes != null) {
            for (AutoNumberingScheme ans : numberingSchemes) {
                if (!ans.getSchemeName().equals(name)) continue;
                return ans;
            }
        }
        return null;
    }

    private void addAutoNumberingScheme(Class<?> clazz, AutoNumberingScheme ans) {
        Vector<AutoNumberingScheme> numberingSchemes = this.numberingSchemesHash.get(clazz);
        if (numberingSchemes == null) {
            numberingSchemes = new Vector();
            this.numberingSchemesHash.put(clazz, numberingSchemes);
        }
        numberingSchemes.add(ans);
    }

    protected void adjustLocaleFromPrefs() {
        String language = AppPreferences.getLocalPrefs().get("locale.lang", null);
        if (language != null) {
            String country = AppPreferences.getLocalPrefs().get("locale.country", null);
            String variant = AppPreferences.getLocalPrefs().get("locale.var", null);
            Locale prefLocale = new Locale(language, country, variant);
            Locale.setDefault(prefLocale);
            UIRegistry.setResourceLocale(prefLocale);
        }
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
    }

    public boolean createEmptyInstitution(Properties props, boolean doCreateDiv, boolean doCreateDisp, boolean doFromWizard) {
        AppContextMgr.getInstance().setHasContext(true);
        this.createStep = 0;
        if (this.frame != null) {
            this.frame.setProcess(0, 10);
        }
        if (this.frame != null) {
            this.frame.setProcess(++this.createStep);
        }
        Institution institution = null;
        String username = props.getProperty("usrUsername");
        String password = props.getProperty("usrPassword");
        this.startTx();
        System.out.println("----- User Agent -----");
        System.out.println("Userame:   " + username);
        institution = DataBuilder.createInstitution(props.getProperty("instName"));
        institution.setCode(props.getProperty("instAbbrev"));
        institution.setIsAccessionsGlobal((Boolean)props.get("accglobal"));
        Address instAddress = new Address();
        instAddress.initialize();
        instAddress.setAddress(props.getProperty("addr1"));
        instAddress.setAddress2(props.getProperty("addr2"));
        instAddress.setCity(props.getProperty("city"));
        instAddress.setCountry(props.getProperty("country"));
        instAddress.setState(props.getProperty("state"));
        instAddress.setPostalCode(props.getProperty("zip"));
        instAddress.setPhone1(props.getProperty("phone"));
        institution.setAddress(instAddress);
        instAddress.getInsitutions().add(institution);
        institution.setIsSecurityOn((Boolean)props.get("security_on"));
        if (this.stgTreeDef == null) {
            this.stgTreeDef = DataBuilder.createStorageTreeDef("Storage");
            institution.setStorageTreeDef(this.stgTreeDef);
            this.stgTreeDef.getInstitutions().add(institution);
            this.persist((Object)this.stgTreeDef);
        }
        String storXML = props.getProperty("StorageTreeDef.treedefs");
        Vector<Object> storages = new Vector<Object>();
        BuildSampleDatabase.createStorageDefFromXML(storages, this.stgTreeDef, storXML);
        this.persist(storages);
        String email = props.getProperty("email");
        String userType = props.getProperty("userType");
        String encrypted = Encryption.encrypt(password, password);
        SpecifyUser specifyAdminUser = DataBuilder.createAdminGroupAndUser(this.session, institution, null, username, email, encrypted, userType);
        this.dataType = DataBuilder.createDataType("Biota");
        this.persist((Object)institution);
        this.persist((Object)specifyAdminUser);
        this.persist((Object)this.dataType);
        this.commitTx();
        AppContextMgr.getInstance().setClassObject(SpecifyUser.class, specifyAdminUser);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        if (this.frame != null) {
            this.frame.setProcess(++this.createStep);
        }
        if (doCreateDiv) {
            DisciplineType disciplineType = (DisciplineType)props.get("disciplineType");
            return this.createEmptyDivision(institution, disciplineType, specifyAdminUser, props, doCreateDisp, doFromWizard, false) != null;
        }
        return true;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public Division createEmptyDivision(Institution institution, DisciplineType disciplineType, SpecifyUser specifyAdminUser, Properties props, boolean doCreateDisp, boolean doFromWizard, boolean doSetProgressRange) {
        Pair<Discipline, Collection> dc;
        if (doSetProgressRange && this.frame != null) {
            this.frame.setProcess(0, 19);
        }
        this.startTx();
        Division division = DataBuilder.createDivision(institution, disciplineType.getName(), props.getProperty("divName"), props.getProperty("divAbbrev"), null);
        this.frame.incOverall();
        this.persist((Object)division);
        String title = props.getProperty("title", "mr");
        String firstName = props.getProperty("firstName", "Test");
        String lastName = props.getProperty("lastName", "User");
        String midInit = props.getProperty("middleInitial", "A");
        String abbrev = props.getProperty("abbrev", "");
        String email = props.getProperty("email");
        this.frame.incOverall();
        Agent userAgent = AppContextMgr.getInstance().getClassObject(Agent.class);
        Agent newUserAgent = null;
        boolean fromWiz = UIHelper.getProperty(props, "fromwizard", false);
        if (userAgent == null || doFromWizard && fromWiz) {
            userAgent = DataBuilder.createAgent(title, firstName, midInit, lastName, abbrev, email, division, null);
        } else {
            try {
                HibernateUtil.attach(specifyAdminUser, this.session);
                List agentList = this.session.createQuery("FROM Agent WHERE id = " + userAgent.getId()).list();
                Agent cloneableAgent = (Agent)agentList.get(0);
                newUserAgent = (Agent)cloneableAgent.clone();
                Agent.initializeSets(newUserAgent);
                specifyAdminUser.getAgents().add(newUserAgent);
                newUserAgent.setSpecifyUser(specifyAdminUser);
                newUserAgent.setDivision(division);
                this.session.saveOrUpdate((Object)newUserAgent);
                this.session.saveOrUpdate((Object)specifyAdminUser);
                userAgent = newUserAgent;
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
        try {
            userAgent = (Agent)this.session.merge((Object)userAgent);
            AppContextMgr.getInstance().setClassObject(Agent.class, userAgent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        specifyAdminUser.addReference(userAgent, "agents");
        this.persist((Object)specifyAdminUser);
        this.commitTx();
        if (doCreateDisp && (dc = this.createEmptyDisciplineAndCollection(division, props, disciplineType, userAgent, specifyAdminUser, true, false)) == null) {
            return null;
        }
        this.frame.incOverall();
        return division;
    }

    public Pair<Discipline, Collection> createEmptyDisciplineAndCollection(Division division, Properties props, DisciplineType disciplineType, Agent userAgent, SpecifyUser specifyAdminUser, boolean doCollection, boolean doSetProgressRange) {
        Object pltObj;
        String dispName;
        log.debug((Object)("In createEmptyDisciplineAndCollection - createStep: " + this.createStep));
        if (doSetProgressRange) {
            this.frame.setProcess(0, 17);
        }
        if (StringUtils.isEmpty((String)(dispName = props.getProperty("dispName")))) {
            dispName = disciplineType.getTitle();
        }
        boolean preLoadTaxon = (pltObj = props.get("preloadtaxon")) == null ? false : (Boolean)pltObj;
        String taxonXML = props.getProperty("TaxonTreeDef.treedefs");
        String taxonFileName = props.getProperty("taxonfilename");
        String geoXML = props.getProperty("GeographyTreeDef.treedefs");
        Boolean doUserProvidedFile = (Boolean)props.get("othertaxonfile");
        this.frame.incOverall();
        Discipline discipline = this.createEmptyDiscipline(division, dispName, disciplineType, userAgent, preLoadTaxon, taxonFileName, doUserProvidedFile != null ? doUserProvidedFile : false, taxonXML, geoXML, props);
        if (discipline != null) {
            Institution inst;
            this.frame.setProcess(0, 17);
            this.frame.setProcess(++this.createStep);
            this.frame.setDesc("Loading Schema...");
            boolean isAccGlobal = false;
            isAccGlobal = props.get("accglobal") == null ? (inst = AppContextMgr.getInstance().getClassObject(Institution.class)) != null && inst.getIsAccessionsGlobal() != false : (Boolean)props.get("accglobal");
            Pair<AutoNumberingScheme, AutoNumberingScheme> ansPair = this.localizeDisciplineSchema(division, discipline, props, isAccGlobal);
            boolean fromWiz = UIHelper.getProperty(props, "fromwizard", false);
            if (fromWiz) {
                BuildSampleDatabase.doShowHideTablesAndFields(null, discipline);
            }
            BuildSampleDatabase.doShowHideTablesAndFields(disciplineType.getName(), discipline);
            this.frame.setProcess(0, 17);
            this.frame.setProcess(++this.createStep);
            Collection collection = null;
            if (doCollection) {
                collection = this.createEmptyCollection(discipline, props.getProperty("collPrefix").toString(), props.getProperty("collName").toString(), userAgent, specifyAdminUser, (AutoNumberingScheme)ansPair.first, disciplineType.isEmbeddedCollecingEvent());
            }
            this.startTx();
            if (ansPair.second != null) {
                division.addReference((FormDataObjIFace)ansPair.second, "numberingSchemes");
                this.persist(ansPair.second);
                this.persist((Object)division);
            }
            this.commitTx();
            DataBuilder.buildDarwinCoreSchema(discipline);
            log.debug((Object)("Out createEmptyDisciplineAndCollection - createStep: " + this.createStep));
            return new Pair<Discipline, Collection>(discipline, collection);
        }
        return null;
    }

    public Discipline createEmptyDiscipline(Division division, String dispTitle, DisciplineType disciplineType, Agent userAgent, boolean preLoadTaxon, String taxonFileName, boolean doUserProvidedFile, String taxonDefXML, String geoDefXML, Properties props) {
        boolean isPaleo;
        log.debug((Object)("In createEmptyDiscipline - createStep: " + this.createStep));
        this.startTx();
        TaxonTreeDef taxonTreeDef = DataBuilder.createTaxonTreeDef("Taxon");
        GeographyTreeDef geoTreeDef = DataBuilder.createGeographyTreeDef("Geography");
        GeologicTimePeriodTreeDef gtpTreeDef = DataBuilder.createGeologicTimePeriodTreeDef("Chronos Stratigraphy");
        LithoStratTreeDef lithoStratTreeDef = DataBuilder.createLithoStratTreeDef("LithoStrat");
        this.frame.incOverall();
        Discipline discipline = DataBuilder.createDiscipline(division, disciplineType.getName(), dispTitle, this.dataType, taxonTreeDef, geoTreeDef, gtpTreeDef, lithoStratTreeDef);
        this.persist((Object)division);
        this.persist((Object)discipline);
        this.persist((Object)userAgent);
        this.frame.incOverall();
        this.frame.setProcess(++this.createStep);
        this.frame.setDesc("Building Trees...");
        Vector<Object> taxa = new Vector<Object>();
        taxonTreeDef.setDiscipline(discipline);
        taxa.add(taxonTreeDef);
        this.commitTx();
        this.frame.setProcess(++this.createStep);
        boolean bl = isPaleo = disciplineType.getDisciplineType() == DisciplineType.STD_DISCIPLINES.paleobotany || disciplineType.getDisciplineType() == DisciplineType.STD_DISCIPLINES.vertpaleo || disciplineType.getDisciplineType() == DisciplineType.STD_DISCIPLINES.invertpaleo;
        if (isPaleo) {
            this.startTx();
            LithoStratTreeDefItem earth = DataBuilder.createLithoStratTreeDefItem(lithoStratTreeDef, "Surface", 0, false);
            LithoStratTreeDefItem superGrp = DataBuilder.createLithoStratTreeDefItem(earth, "Super Group", 100, false);
            LithoStratTreeDefItem lithoGrp = DataBuilder.createLithoStratTreeDefItem(superGrp, "Litho Group", 200, false);
            LithoStratTreeDefItem formation = DataBuilder.createLithoStratTreeDefItem(lithoGrp, "Formation", 300, false);
            LithoStratTreeDefItem member = DataBuilder.createLithoStratTreeDefItem(formation, "Member", 400, false);
            LithoStratTreeDefItem bed = DataBuilder.createLithoStratTreeDefItem(member, "Bed", 500, true);
            member.setIsInFullName(true);
            bed.setIsInFullName(true);
            this.persist((Object)earth);
            LithoStrat earthNode = new LithoStrat();
            earthNode.initialize();
            earthNode.setName(UIRegistry.getResourceString("Earth"));
            earthNode.setFullName(earthNode.getName());
            earthNode.setNodeNumber(1);
            earthNode.setHighestChildNodeNumber(1);
            earthNode.setRankId(0);
            earthNode.setDefinition(lithoStratTreeDef);
            earthNode.setDefinitionItem(earth);
            earth.getTreeEntries().add(earthNode);
            this.persist((Object)earthNode);
            this.commitTx();
            this.convertChronoStratFromXLS(gtpTreeDef, userAgent);
        }
        this.frame.incOverall();
        Vector<Object> geos = new Vector<Object>();
        this.startTx();
        HashSet<String> colNameHash = null;
        if (StringUtils.isNotEmpty((String)taxonFileName)) {
            colNameHash = this.getColumnNamesFromXLS(taxonFileName, doUserProvidedFile);
        }
        boolean taxonWasBuilt = this.createTaxonDefFromXML(taxa, colNameHash, taxonTreeDef, taxonDefXML);
        this.frame.incOverall();
        log.debug((Object)(" taxonWasBuilt " + taxonWasBuilt));
        if (!taxonWasBuilt) {
            TaxonTreeDefItem ttdi = new TaxonTreeDefItem();
            ttdi.initialize();
            ttdi.setTreeDef(taxonTreeDef);
            taxonTreeDef.getTreeDefItems().add(ttdi);
            ttdi.setName(UIRegistry.getResourceString("Root"));
            ttdi.setRankId(0);
            ttdi.setParent((TaxonTreeDefItem)null);
            ttdi.setFullNameSeparator(null);
            ttdi.setIsEnforced(true);
            ttdi.setIsInFullName(false);
            Taxon tx = new Taxon();
            tx.initialize();
            tx.setDefinition(taxonTreeDef);
            tx.setDefinitionItem(ttdi);
            ttdi.getTreeEntries().add(tx);
            tx.setName(UIRegistry.getResourceString("Life"));
            tx.setFullName(tx.getName());
            tx.setNodeNumber(1);
            tx.setHighestChildNodeNumber(1);
            this.persist((Object)ttdi);
            this.persist((Object)tx);
        }
        this.frame.setProcess(++this.createStep);
        this.frame.incOverall();
        BuildSampleDatabase.createGeographyDefFromXML(geos, geoTreeDef, geoDefXML);
        this.frame.setProcess(++this.createStep);
        this.persist(taxa);
        this.persist(geos);
        this.commitTx();
        this.frame.setProcess(++this.createStep);
        this.frame.incOverall();
        log.debug((Object)(" preLoadTaxon [" + preLoadTaxon + "]"));
        log.debug((Object)(" fileName     [" + taxonFileName + "]"));
        if (preLoadTaxon && taxonFileName != null) {
            this.convertTaxonFromXLS(taxonTreeDef, taxonFileName, doUserProvidedFile);
        }
        this.frame.setProcess(++this.createStep);
        this.frame.incOverall();
        this.frame.setProcess(++this.createStep);
        String itUsername = props.getProperty("dbUserName");
        String itPassword = props.getProperty("dbPassword");
        if (StringUtils.isEmpty((String)itUsername) || StringUtils.isEmpty((String)itPassword)) {
            this.frame.setVisible(false);
            Pair<String, String> usrPwd = DatabaseLoginPanel.getITUsernamePwd();
            this.frame.setVisible(true);
            if (usrPwd != null) {
                itUsername = (String)usrPwd.first;
                itPassword = (String)usrPwd.second;
            } else {
                return null;
            }
        }
        Geography earth = this.createGeographyFromGeonames(discipline, userAgent, itUsername, itPassword);
        this.frame.setProcess(++this.createStep);
        this.frame.incOverall();
        log.debug((Object)("Out createEmptyDiscipline - createStep: " + this.createStep));
        return discipline;
    }

    public Collection createEmptyCollection(Discipline discipline, String collPrefix, String collName, Agent userAgent, SpecifyUser specifyAdminUser, AutoNumberingScheme catNumScheme, boolean isEmbeddedCE) {
        log.debug((Object)("In createEmptyCollection - createStep: " + this.createStep));
        this.frame.setProcess(++this.createStep);
        this.startTx();
        log.info((Object)"Creating a Collection");
        this.frame.setDesc("Creating a Collection");
        Collection collection = DataBuilder.createCollection(collPrefix, collName, catNumScheme.getFormatName(), catNumScheme, discipline, isEmbeddedCE);
        collection.setDiscipline(discipline);
        collection.getTechnicalContacts().add(userAgent);
        collection.getContentContacts().add(userAgent);
        this.persist((Object)collection);
        this.persist((Object)catNumScheme);
        this.frame.setProcess(++this.createStep);
        this.persist(this.loadPrepTypes(discipline.getType(), collection, userAgent));
        Map<String, SpPrincipal> groupMap = DataBuilder.createStandardGroups(this.session, collection);
        SpPrincipal userPrin = DataBuilder.createUserPrincipal(specifyAdminUser, collection);
        this.persist((Object)userPrin);
        this.persist((Object)specifyAdminUser);
        specifyAdminUser.addUserToSpPrincipalGroup(groupMap.get(SpecifyUserTypes.UserType.Manager.toString()));
        this.commitTx();
        log.info((Object)"Creating picklists");
        this.frame.setDesc("Creating Common PickLists...");
        this.frame.setProcess(++this.createStep);
        BuildSampleDatabase.createPickLists(this.session, null, false, collection);
        this.frame.setProcess(++this.createStep);
        this.frame.setDesc("Creating PickLists...");
        BuildSampleDatabase.createPickLists(this.session, discipline, false, collection);
        this.frame.setProcess(++this.createStep);
        log.debug((Object)("Out createEmptyCollection - createStep: " + this.createStep));
        return collection;
    }

    public AutoNumberingScheme createAutoNumScheme(Properties props, String propName, String schemeName, int tableId) {
        String numFmtName;
        Object numFmtObj = props.get(propName);
        UIFieldFormatterIFace numFormat = numFmtObj instanceof UIFieldFormatterIFace ? (UIFieldFormatterIFace)numFmtObj : null;
        boolean isNumFmtNumeric = false;
        String string = numFormat != null ? numFormat.getName() : (numFmtName = numFmtObj != null ? numFmtObj.toString() : null);
        if (numFormat != null) {
            isNumFmtNumeric = numFormat.isNumeric();
        } else if (StringUtils.isNotEmpty((String)numFmtName) && (numFormat = UIFieldFormatterMgr.getInstance().getFormatter(numFmtName)) != null) {
            isNumFmtNumeric = numFormat.isNumeric();
        }
        AutoNumberingScheme autoNumScheme = null;
        if (numFormat != null) {
            autoNumScheme = DataBuilder.createAutoNumberingScheme(schemeName, "", numFmtName, isNumFmtNumeric, tableId);
        }
        return autoNumScheme;
    }

    public Pair<AutoNumberingScheme, AutoNumberingScheme> localizeDisciplineSchema(Division division, Discipline discipline, Properties props, boolean isAccGlobal) {
        AutoNumberingScheme catNumScheme = this.createAutoNumScheme(props, "catnumfmt", "Catalog Numbering Scheme", CollectionObject.getClassTableId());
        AutoNumberingScheme accNumScheme = null;
        boolean isFromScratch = props.getProperty("instName") != null;
        String postFix = "FROM autonumberingscheme ans INNER JOIN autonumsch_div ad ON ans.AutoNumberingSchemeID = ad.AutoNumberingSchemeID INNER JOIN division d ON ad.DivisionID = d.UserGroupScopeId WHERE d.UserGroupScopeId = " + division.getId();
        String sql = "SELECT COUNT(*) " + postFix;
        log.debug((Object)sql);
        int numOfDivAns = BasicSQLUtils.getCountAsInt(sql);
        if (!isAccGlobal || isFromScratch) {
            if (numOfDivAns == 0) {
                accNumScheme = this.createAutoNumScheme(props, "accnumfmt", "Accession Numbering Scheme", Accession.getClassTableId());
            } else {
                sql = "SELECT ans.AutoNumberingSchemeID " + postFix;
                log.debug((Object)sql);
                int ansId = BasicSQLUtils.getCountAsInt(sql);
                HibernateDataProviderSession hSession = new HibernateDataProviderSession(this.session);
                List<?> list = hSession.getDataList("FROM AutoNumberingScheme WHERE id = " + ansId);
                if (list != null && list.size() == 1) {
                    accNumScheme = (AutoNumberingScheme)list.get(0);
                }
            }
        } else {
            HibernateDataProviderSession hSession = new HibernateDataProviderSession(this.session);
            List<?> list = hSession.getDataList("FROM AutoNumberingScheme WHERE tableNumber = " + Accession.getClassTableId());
            if (list != null && list.size() == 1) {
                accNumScheme = (AutoNumberingScheme)list.get(0);
            }
        }
        this.startTx();
        DBTableIdMgr dbMgr = new DBTableIdMgr(true);
        dbMgr.initialize();
        this.loadSchemaLocalization(discipline, SpLocaleContainer.CORE_SCHEMA, dbMgr, catNumScheme.getFormatName(), accNumScheme != null ? accNumScheme.getFormatName() : null);
        DBTableIdMgr wbTableMgr = new DBTableIdMgr(false);
        wbTableMgr.initialize(new File(XMLHelper.getConfigDirPath("specify_workbench_datamodel.xml")));
        this.loadSchemaLocalization(discipline, SpLocaleContainer.WORKBENCH_SCHEMA, wbTableMgr, null, null, UpdateType.eBuildNew, null);
        this.frame.setProcess(++this.createStep);
        this.persist((Object)discipline);
        this.frame.setProcess(++this.createStep);
        this.commitTx();
        return new Pair<AutoNumberingScheme, AutoNumberingScheme>(catNumScheme, accNumScheme);
    }

    public static void createGeographyDefFromXML(List<Object> geoList, GeographyTreeDef geoTreeDef, String geoXML) {
        if (StringUtils.isNotEmpty((String)geoXML)) {
            XStream xstream = new XStream();
            TreeDefRow.configXStream(xstream);
            Vector treeDefList = (Vector)xstream.fromXML(geoXML);
            GeographyTreeDefItem parent = null;
            int cnt = 0;
            for (TreeDefRow row : treeDefList) {
                GeographyTreeDefItem gtdi = new GeographyTreeDefItem();
                gtdi.initialize();
                gtdi.setTreeDef(geoTreeDef);
                geoTreeDef.getTreeDefItems().add(gtdi);
                gtdi.setName(row.getDefName());
                gtdi.setTitle(row.getTitle());
                gtdi.setRankId(row.getRank());
                gtdi.setParent(parent);
                gtdi.setFullNameSeparator(row.getSeparator());
                gtdi.setIsEnforced(row.isEnforced());
                gtdi.setIsInFullName(row.isInFullName());
                geoList.add(gtdi);
                if (parent != null) {
                    parent.getChildren().add(gtdi);
                }
                parent = gtdi;
                ++cnt;
            }
        }
    }

    public boolean createTaxonDefFromXML(List<Object> taxonList, HashSet<String> colNameHash, TaxonTreeDef taxonTreeDef, String taxonDefXML) {
        if (StringUtils.isNotEmpty((String)taxonDefXML)) {
            XStream xstream = new XStream();
            TreeDefRow.configXStream(xstream);
            Vector treeDefList = (Vector)xstream.fromXML(taxonDefXML);
            if (colNameHash != null) {
                Hashtable<String, TreeDefItemStandardEntry> stdTreeLevelsHash = new Hashtable<String, TreeDefItemStandardEntry>();
                for (TreeDefItemStandardEntry entry : TaxonTreeDef.getStandardLevelsStatic()) {
                    stdTreeLevelsHash.put(entry.getName().toLowerCase(), entry);
                }
                Hashtable<String, TreeDefRow> xmlTreeLevelsHash = new Hashtable<String, TreeDefRow>();
                for (TreeDefRow row : treeDefList) {
                    xmlTreeLevelsHash.put(row.getDefName().toLowerCase(), row);
                }
                block2: for (String columnName : colNameHash) {
                    String colName = columnName.toLowerCase();
                    TreeDefRow treeDefRow = (TreeDefRow)xmlTreeLevelsHash.get(colName);
                    if (treeDefRow == null) {
                        log.debug((Object)(String.valueOf(colName) + " NOT found in XML, checking std."));
                        TreeDefItemStandardEntry entry = (TreeDefItemStandardEntry)stdTreeLevelsHash.get(colName);
                        if (entry != null) {
                            int i = 0;
                            while (i < treeDefList.size()) {
                                if (i < treeDefList.size() && entry.getRank() < ((TreeDefRow)treeDefList.get(i)).getRank()) {
                                    log.debug((Object)String.format("Adding '%s' as rank %d.", colName, entry.getRank()));
                                    TreeDefRow newRow = new TreeDefRow(entry.getName(), entry.getTitle(), entry.getRank(), true, false, false, false, ",");
                                    treeDefList.insertElementAt(newRow, i);
                                    continue block2;
                                }
                                ++i;
                            }
                            continue;
                        }
                        log.debug((Object)String.format("The wizard was unable to find '%s' as a standard Taxonomy level.", colName));
                        continue;
                    }
                    log.debug((Object)(String.valueOf(colName) + " found in XML"));
                }
                for (TreeDefRow row : treeDefList) {
                    log.debug((Object)(String.valueOf(row.getDefName()) + "  " + row.getTitle() + "  " + row.getRank()));
                }
            }
            TaxonTreeDefItem ttdiRoot = null;
            Taxon txRoot = null;
            TaxonTreeDefItem parent = null;
            int cnt = 0;
            for (TreeDefRow row : treeDefList) {
                if (!row.isIncluded() && (row.getDefName() == null || colNameHash != null && !colNameHash.contains(row.getDefName().toLowerCase()))) continue;
                TaxonTreeDefItem ttdi = new TaxonTreeDefItem();
                ttdi.initialize();
                ttdi.setTreeDef(taxonTreeDef);
                taxonTreeDef.getTreeDefItems().add(ttdi);
                ttdi.setName(row.getDefName());
                ttdi.setTitle(row.getTitle());
                ttdi.setRankId(row.getRank());
                ttdi.setParent(parent);
                ttdi.setFullNameSeparator(row.getSeparator());
                ttdi.setIsEnforced(row.isEnforced());
                ttdi.setIsInFullName(row.isInFullName());
                taxonList.add(ttdi);
                if (cnt == 0) {
                    ttdiRoot = ttdi;
                    Taxon tx = new Taxon();
                    tx.initialize();
                    tx.setDefinition(taxonTreeDef);
                    tx.setDefinitionItem(ttdi);
                    ttdi.getTreeEntries().add(tx);
                    tx.setName(UIRegistry.getResourceString("Life"));
                    tx.setFullName(tx.getName());
                    tx.setNodeNumber(1);
                    tx.setHighestChildNodeNumber(1);
                    txRoot = tx;
                }
                if (parent != null) {
                    parent.getChildren().add(ttdi);
                }
                parent = ttdi;
                ++cnt;
            }
            if (ttdiRoot != null) {
                this.persist((Object)ttdiRoot);
            }
            if (txRoot != null) {
                this.persist((Object)txRoot);
            }
        }
        return true;
    }

    public static void createStorageDefFromXML(List<Object> storageList, StorageTreeDef storageTreeDef, String storageXML) {
        if (StringUtils.isNotEmpty((String)storageXML)) {
            XStream xstream = new XStream();
            TreeDefRow.configXStream(xstream);
            Vector treeDefList = (Vector)xstream.fromXML(storageXML);
            StorageTreeDefItem parent = null;
            int cnt = 0;
            for (TreeDefRow row : treeDefList) {
                if (!row.isIncluded()) continue;
                StorageTreeDefItem stdi = new StorageTreeDefItem();
                stdi.initialize();
                stdi.setTreeDef(storageTreeDef);
                storageTreeDef.getTreeDefItems().add(stdi);
                stdi.setName(row.getDefName());
                stdi.setTitle(row.getTitle());
                stdi.setRankId(row.getRank());
                stdi.setParent(parent);
                stdi.setFullNameSeparator(row.getSeparator());
                stdi.setIsEnforced(row.isEnforced());
                stdi.setIsInFullName(row.isInFullName());
                storageList.add(stdi);
                if (cnt == 0) {
                    Storage stg = new Storage();
                    stg.initialize();
                    stg.setDefinition(storageTreeDef);
                    stg.setDefinitionItem(stdi);
                    stdi.getTreeEntries().add(stg);
                    stg.setName(UIRegistry.getResourceString("Site"));
                    stg.setFullName(stg.getName());
                    stg.setNodeNumber(1);
                    stg.setHighestChildNodeNumber(1);
                }
                if (parent != null) {
                    parent.getChildren().add(stdi);
                }
                parent = stdi;
                ++cnt;
            }
        }
    }

    protected List<?> getObjectsOfClass(Class<?> cls, List<Object> dataObjects) {
        Vector<Object> list = new Vector<Object>();
        for (Object obj : dataObjects) {
            if (obj.getClass() != cls) continue;
            list.add(obj);
        }
        return list;
    }

    protected void addConservatorData(List<Agent> agents, List<CollectionObject> colObjs) {
        ConservDescription desc = new ConservDescription();
        desc.initialize();
        desc.setShortDesc("Short Description");
        desc.addReference(colObjs.get(0), "collectionObject");
        ConservEvent conservEvent = new ConservEvent();
        conservEvent.initialize();
        conservEvent.setExamDate(Calendar.getInstance());
        conservEvent.addReference(agents.get(1), "examinedByAgent");
        conservEvent.addReference(agents.get(2), "treatedByAgent");
        desc.addReference(conservEvent, "events");
        this.persist((Object)desc);
    }

    public static BldrPickList createPickLists(Session localSession, Discipline discipline) {
        return BuildSampleDatabase.createPickLists(localSession, discipline, false, AppContextMgr.getInstance().getClassObject(Collection.class));
    }

    public static BldrPickList createPickLists(Session localSession, Discipline discipline, boolean doCheck, Collection collection) {
        BldrPickList colMethods = null;
        try {
            List<BldrPickList> pickLists;
            Hashtable<String, PickList> nameHash;
            Transaction trans = localSession.beginTransaction();
            Hashtable<String, PickList> hashtable = nameHash = doCheck ? new Hashtable<String, PickList>() : null;
            if (doCheck) {
                for (PickList pl : new Vector<PickList>(collection.getPickLists())) {
                    if (pl.getNumItems() > 0) {
                        nameHash.put(pl.getName(), pl);
                        continue;
                    }
                    if (discipline != null) continue;
                    log.debug((Object)("Deleting PickList: " + pl.getName()));
                    collection.getPickLists().remove(pl);
                    localSession.delete((Object)pl);
                }
            }
            if ((pickLists = DataBuilder.getBldrPickLists(discipline != null ? discipline.getType() : "common")) != null) {
                for (BldrPickList pl : pickLists) {
                    PickList pickList;
                    PickList pickList2 = pickList = doCheck ? (PickList)nameHash.get(pl.getName()) : null;
                    if (pickList != null) {
                        pickList.setIsSystem(true);
                        if (pickList.getNumItems() > 0) {
                            log.info((Object)("Skipping PickList[" + pl.getName() + "]"));
                            continue;
                        }
                    } else {
                        log.info((Object)("Creating PickList[" + pl.getName() + "]"));
                        pickList = DataBuilder.createPickList(pl.getName(), pl.getType(), pl.getTableName(), pl.getFieldName(), pl.getFormatter(), pl.getReadOnly(), pl.getSizeLimit(), pl.getIsSystem(), pl.getSortType(), collection);
                    }
                    pickList.setIsSystem(true);
                    pickList.setCollection(collection);
                    collection.getPickLists().add(pickList);
                    for (BldrPickListItem item : pl.getItems()) {
                        pickList.addItem(item.getTitle(), item.getValue(), item.getOrdinal());
                    }
                    if (localSession != null) {
                        localSession.saveOrUpdate((Object)pickList);
                    }
                    if (!pl.getName().equals("CollectingMethod")) continue;
                    colMethods = pl;
                }
                if (localSession != null) {
                    localSession.saveOrUpdate((Object)collection);
                }
            } else {
                log.error((Object)"No PickList XML");
            }
            trans.commit();
            localSession.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return colMethods;
    }

    protected CollectingEvent createFakeCollectingEvent(List<Agent> agents, Locality farmpond, String method) {
        int year = (int)(this.rand.nextDouble() * 20.0) + 1990;
        int mon = (int)(this.rand.nextDouble() * 11.0) + 1;
        Collector collectorMeg = DataBuilder.createCollector(agents.get(2), 1);
        Collector collectorRod = DataBuilder.createCollector(agents.get(3), 2);
        String stationFieldNumber = String.format(this.STATION_FIELD_FORMAT, this.stationFieldNumberCounter++);
        this.calendar.set(year, mon, 22, 6, 12, 0);
        CollectingEvent ce2 = DataBuilder.createCollectingEvent(farmpond, this.calendar, stationFieldNumber, new Collector[]{collectorMeg, collectorRod});
        ce2.setStartDateVerbatim("22 Apr " + year + ", 6:12 AM");
        this.calendar.set(year, mon, 22, 7, 31, 0);
        ce2.setEndDate(this.calendar);
        ce2.setEndDateVerbatim("22 Apr " + year + ", 7:31 AM");
        ce2.setMethod(method);
        return ce2;
    }

    protected Taxon getRandomTaxon(int rank, List<Object> taxa) {
        Vector<Taxon> species = new Vector<Taxon>();
        for (Object tObj : taxa) {
            Taxon t;
            if (!(tObj instanceof Taxon) || (t = (Taxon)tObj).getRankId() != rank) continue;
            species.add(t);
        }
        int inx = (int)(this.rand.nextDouble() * (double)species.size());
        return (Taxon)species.get(inx);
    }

    protected Agent getRandomAgent(List<Agent> agents) {
        int inx = (int)(this.rand.nextDouble() * (double)agents.size());
        return agents.get(inx);
    }

    protected void createLoanExamples(List<Preparation> preps, List<Agent> agents, Vector<Object> dataObjects) {
    }

    public List<Object> createSingleBotanyCollection(DisciplineType disciplineType, Institution institution, SpecifyUser user, CollectionChoice choice) {
        this.frame.setProcess(0, 16);
        this.frame.setDesc("Creating Botany...");
        this.createStep = 0;
        this.startTx();
        Division division = DataBuilder.createDivision(institution, disciplineType.getName(), "Botany", "BT", "Botany");
        TaxonTreeDef taxonTreeDef = DataBuilder.createTaxonTreeDef("Taxon");
        GeographyTreeDef geoTreeDef = DataBuilder.createGeographyTreeDef("Geography");
        GeologicTimePeriodTreeDef gtpTreeDef = DataBuilder.createGeologicTimePeriodTreeDef("Chronos Stratigraphy");
        LithoStratTreeDef lithoStratTreeDef = DataBuilder.createLithoStratTreeDef("LithoStrat");
        boolean buildStorageTree = false;
        if (this.stgTreeDef == null) {
            this.stgTreeDef = DataBuilder.createStorageTreeDef("Storage");
            institution.setStorageTreeDef(this.stgTreeDef);
            buildStorageTree = true;
        }
        lithoStratTreeDef.setRemarks("A simple super, group, formation, member, bed Litho Stratigraphy tree");
        Discipline discipline = DataBuilder.createDiscipline(division, disciplineType.getName(), disciplineType.getTitle(), this.dataType, taxonTreeDef, geoTreeDef, gtpTreeDef, lithoStratTreeDef);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        ArrayList groups = new ArrayList();
        this.persist((Object)institution);
        this.persist((Object)division);
        this.persist((Object)discipline);
        AppContextMgr.getInstance().setClassObject(Division.class, division);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        this.loadSchemaLocalization(discipline, SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance(), choice.getCatalogNumberingFmtName(), choice.getAccessionNumberingFmtName());
        String title = this.initPrefs.getProperty("useragent.title", "mr");
        String firstName = this.initPrefs.getProperty("useragent.firstname", "Test");
        String lastName = this.initPrefs.getProperty("useragent.lastname", "User");
        String midInit = this.initPrefs.getProperty("useragent.midinit", "A");
        String abbrev = this.initPrefs.getProperty("useragent.abbrev", "tu");
        String email = this.initPrefs.getProperty("useragent.email", "testuser@ku.edu");
        String userType = this.initPrefs.getProperty("useragent.usertype", SpecifyUserTypes.UserType.Manager.toString());
        System.out.println("----- User Agent -----");
        System.out.println("Title:     " + title);
        System.out.println("FirstName: " + firstName);
        System.out.println("LastName:  " + lastName);
        System.out.println("MidInit:   " + midInit);
        System.out.println("Abbrev:    " + abbrev);
        System.out.println("Email:     " + email);
        System.out.println("UserType:  " + userType);
        Agent userAgent = DataBuilder.createAgent(title, firstName, midInit, lastName, abbrev, email);
        discipline.addReference(userAgent, "agents");
        user.addReference(userAgent, "agents");
        this.persist((Object)userAgent);
        this.persist((Object)user);
        this.frame.setProcess(++this.createStep);
        Pair<AutoNumberingScheme, AutoNumberingScheme> pairANS = this.createAutoNumberingSchemes(choice);
        AutoNumberingScheme cns = (AutoNumberingScheme)pairANS.first;
        AutoNumberingScheme accessionNS = (AutoNumberingScheme)pairANS.second;
        this.persist((Object)cns);
        this.persist((Object)accessionNS);
        this.commitTx();
        this.startTx();
        log.info((Object)"Creating a Collection");
        Collection collection = DataBuilder.createCollection("KUBOT", "Botany", choice.getCatalogNumberingFmtName(), cns, discipline);
        this.persist((Object)collection);
        Map<String, SpPrincipal> groupMap = DataBuilder.createStandardGroups(this.session, collection);
        user.addUserToSpPrincipalGroup(groupMap.get(SpecifyUserTypes.UserType.Manager.toString()));
        DataBuilder.createAndAddTesterToCollection(this.session, "botanyuser", "botanyuser@ku.edu", "botanyuser", "mr", "Bob", "", "Botony", "", discipline, division, collection, groupMap, "Guest");
        this.persist((Object)discipline);
        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
        this.persist(groups);
        division.addReference(accessionNS, "numberingSchemes");
        this.persist((Object)division);
        this.commitTx();
        BuildSampleDatabase.doShowHideTablesAndFields(null, discipline);
        BuildSampleDatabase.doShowHideTablesAndFields(disciplineType.getName(), discipline);
        this.frame.setProcess(++this.createStep);
        this.startTx();
        AppContextMgr.getInstance().setClassObject(SpecifyUser.class, user);
        user.addReference(userAgent, "agents");
        this.persist((Object)user);
        Journal journal = BuildSampleDatabase.createJournalsAndReferenceWork();
        this.frame.setProcess(++this.createStep);
        List<Object> taxa = BuildSampleDatabase.createSimpleBotanyTaxonTree(taxonTreeDef);
        List<Object> geos = BuildSampleDatabase.createSimpleGeography(geoTreeDef, true);
        List<Object> gtps = BuildSampleDatabase.createSimpleGeologicTimePeriod(gtpTreeDef, true);
        List<Object> lithoStrats = BuildSampleDatabase.createSimpleLithoStrat(lithoStratTreeDef, true);
        institution.setStorageTreeDef(this.stgTreeDef);
        this.persist((Object)institution);
        this.persist((Object)journal);
        this.persist(taxa);
        this.persist(geos);
        this.persist(buildStorageTree ? BuildSampleDatabase.createSimpleStorage(this.stgTreeDef) : null);
        this.persist(gtps);
        this.persist(lithoStrats);
        this.commitTx();
        AppContextMgr.getInstance().setClassObject(Division.class, division);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating picklists");
        this.frame.setDesc("Creating PickLists...");
        BuildSampleDatabase.createPickLists(this.session, null);
        BuildSampleDatabase.createPickLists(this.session, discipline);
        Vector<Object> dataObjects = new Vector<Object>();
        this.startTx();
        this.standardQueries(dataObjects, userAgent);
        this.persist(dataObjects);
        dataObjects.clear();
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        String POINT = "Point";
        String LINE = "Line";
        String RECT = "Rectangle";
        log.info((Object)"Creating localities");
        Locality forestStream = DataBuilder.createLocality("Unnamed forest stream pond", (Geography)geos.get(12));
        forestStream.setLatLongType(POINT);
        forestStream.setOriginalLatLongUnit(0);
        forestStream.setLat1text("38.925467 deg N");
        forestStream.setLatitude1(new BigDecimal(38.925467));
        forestStream.setLong1text("94.984867 deg W");
        forestStream.setLongitude1(new BigDecimal(-94.984867));
        Locality lake = DataBuilder.createLocality("Deep, dark lake pond", (Geography)geos.get(17));
        lake.setLatLongType(RECT);
        lake.setOriginalLatLongUnit(1);
        lake.setLat1text("41.548842 deg N");
        lake.setLatitude1(new BigDecimal(41.548842));
        lake.setLong1text("93.732129 deg W");
        lake.setLongitude1(new BigDecimal(-93.732129));
        lake.setLat2text("41.642195 deg N");
        lake.setLatitude2(new BigDecimal(41.642195));
        lake.setLong2text("100.403180 deg W");
        lake.setLongitude2(new BigDecimal(-100.40318));
        Locality farmpond = DataBuilder.createLocality("Shoal Creek at Schermerhorn Park, S of Galena at Rt. 26", (Geography)geos.get(11));
        farmpond.setLatLongType(LINE);
        farmpond.setOriginalLatLongUnit(2);
        farmpond.setLat1text("41.642187 deg N");
        farmpond.setLatitude1(new BigDecimal(41.642187));
        farmpond.setLong1text("100.403163 deg W");
        farmpond.setLongitude1(new BigDecimal(-100.403163));
        farmpond.setLat2text("49.647435 deg N");
        farmpond.setLatitude2(new BigDecimal(49.647435));
        farmpond.setLong2text("-55.112163 deg W");
        farmpond.setLongitude2(new BigDecimal(-55.112163));
        this.persist((Object)forestStream);
        this.persist((Object)lake);
        this.persist((Object)farmpond);
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating agents and addresses");
        Vector<Agent> agents = new Vector<Agent>();
        lastName = userAgent.getLastName();
        Agent steveBoyd = DataBuilder.createAgent("mr", "Steve", "D", "Boyd", "jb", "jb@net.edu");
        if (!lastName.equals("Cooper")) {
            agents.add(DataBuilder.createAgent("mr", "Peter", "D", "Cooper", "ds", "ds@whitehouse.gov"));
        }
        if (!lastName.equals("Peck")) {
            agents.add(DataBuilder.createAgent("mr", "David", "H", "Peck", "rb", "beach@net.edu"));
        }
        if (!lastName.equals("Appleton")) {
            agents.add(DataBuilder.createAgent("mrs", "Sally", "H", "Appleton", "jm", "jm@net.edu"));
        }
        if (!lastName.equals("Brown")) {
            agents.add(DataBuilder.createAgent("mr", "Taylor", "C", "Brown", "kcs", "taylor.brown@ku.edu"));
        }
        if (!lastName.equals("Boyd")) {
            agents.add(steveBoyd);
        }
        if (!lastName.equals("Thomas")) {
            agents.add(DataBuilder.createAgent("Mr", "James", "X", "Thomas", "dxt", ""));
        }
        if (!lastName.equals("Peterson")) {
            agents.add(DataBuilder.createAgent("mr", "Pete", "A", "Peterson", "jb", ""));
        }
        if (!lastName.equals("Guttenburg")) {
            agents.add(DataBuilder.createAgent("mr", "Mitch", "A", "Guttenburg", "jb", ""));
        }
        if (!lastName.equals("Ford")) {
            agents.add(DataBuilder.createAgent("mr", "Daniel", "A", "Ford", "mas", "mas@ku.edu"));
        }
        agents.add(userAgent);
        Agent ku = new Agent();
        ku.initialize();
        ku.setAbbreviation("KU");
        ku.setAgentType((byte)0);
        ku.setLastName("University of Kansas");
        ku.setEmail("webadmin@ku.edu");
        ku.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        ku.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(ku);
        ((Agent)agents.get(0)).setOrganization(ku);
        ((Agent)agents.get(1)).setOrganization(ku);
        ((Agent)agents.get(2)).setOrganization(ku);
        ((Agent)agents.get(3)).setOrganization(ku);
        ((Agent)agents.get(8)).setOrganization(ku);
        Agent otherAgent = new Agent();
        otherAgent.initialize();
        otherAgent.setAbbreviation("O");
        otherAgent.setAgentType((byte)2);
        otherAgent.setLastName("The Other Guys");
        otherAgent.setEmail("other@other.com");
        otherAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        otherAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(otherAgent);
        this.commitTx();
        ArrayList<GroupPerson> gpList = new ArrayList<GroupPerson>();
        this.startTx();
        Agent gm1 = DataBuilder.createAgent("mr", "John", "A", "Lyon", "jal", "jal@group.edu");
        Agent gm2 = DataBuilder.createAgent("mr", "Dave", "D", "Jones", "ddj", "ddj@group.edu");
        this.persist((Object)gm1);
        this.persist((Object)gm2);
        this.commitTx();
        Agent groupAgent = new Agent();
        groupAgent.initialize();
        groupAgent.setAbbreviation("GRP");
        groupAgent.setAgentType((byte)3);
        groupAgent.setLastName("The Group");
        groupAgent.setEmail("group@group.com");
        groupAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        groupAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(groupAgent);
        gpList.add(DataBuilder.createGroupPerson(groupAgent, gm1, 0, division));
        gpList.add(DataBuilder.createGroupPerson(groupAgent, gm2, 1, division));
        this.startTx();
        Vector<AgentVariant> agentVariants = new Vector<AgentVariant>();
        agentVariants.add(DataBuilder.createAgentVariant(AgentVariant.VARIANT, "James Variant #1", steveBoyd));
        agentVariants.add(DataBuilder.createAgentVariant(AgentVariant.VERNACULAR, "James VERNACULAR #1", steveBoyd));
        Vector<Address> addrs = new Vector<Address>();
        addrs.add(DataBuilder.createAddress((Agent)agents.get(1), "1600 Pennsylvania Avenue NW", null, "Washington", "DC", "USA", "20500", 0));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(1), "??? Mississippi", null, "Lawrence", "KS", "USA", "66045", 1));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(2), "1 Main St", "", "Lenexa", "KS", "USA", "66071"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(3), "13355 Inverness", "Bldg #3", "Lawrence", "KS", "USA", "66047"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(4), "Natural History Museum", "Cromwell Rd", "London", null, "UK", "SW7 5BD"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(6), "1212 Apple Street", null, "Chicago", "IL", "USA", "01010"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(8), "11911 Oak Ln", null, "Orion", "KS", "USA", "66061"));
        addrs.add(DataBuilder.createAddress(ku, null, null, "Lawrence", "KS", "USA", "66045"));
        addrs.add(DataBuilder.createAddress(userAgent, "1214 East Street", null, "Grinnell", "IA", "USA", "56060"));
        userAgent.setDivision(division);
        this.persist(agents);
        this.persist(agentVariants);
        this.persist(gpList);
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating collecting events, collectors and a collecting trip");
        Collector collectorMitch = DataBuilder.createCollector((Agent)agents.get(7), 2);
        Collector collectorJim = DataBuilder.createCollector((Agent)agents.get(2), 1);
        this.calendar.set(1994, 4, 21, 11, 56, 0);
        String stationFieldNumber = String.format(this.STATION_FIELD_FORMAT, this.stationFieldNumberCounter++);
        CollectingEvent ce1 = DataBuilder.createCollectingEvent(forestStream, this.calendar, stationFieldNumber, new Collector[]{collectorMitch, collectorJim});
        ce1.setStartDateVerbatim("21 Apr 1994, 11:56 AM");
        this.calendar.set(1994, 4, 21, 13, 3, 0);
        ce1.setEndDate(this.calendar);
        ce1.setEndDateVerbatim("21 Apr 1994, 1:03 PM");
        ce1.setMethod("Picked");
        AttributeDef cevAttrDef = DataBuilder.createAttributeDef(AttributeIFace.FieldType.StringType, "ParkName", discipline, null);
        this.persist((Object)cevAttrDef);
        this.commitTx();
        this.startTx();
        CollectingEventAttr cevAttr = DataBuilder.createCollectingEventAttr(ce1, cevAttrDef, "Sleepy Hollow", null);
        Collector collectorMeg = DataBuilder.createCollector((Agent)agents.get(2), 1);
        Collector collectorRod = DataBuilder.createCollector((Agent)agents.get(3), 2);
        stationFieldNumber = String.format(this.STATION_FIELD_FORMAT, this.stationFieldNumberCounter++);
        this.calendar.set(1994, 4, 22, 6, 12, 0);
        CollectingEvent ce2 = DataBuilder.createCollectingEvent(farmpond, this.calendar, stationFieldNumber, new Collector[]{collectorMeg, collectorRod});
        ce2.setStartDateVerbatim("22 Apr 1994, 6:12 AM");
        this.calendar.set(1994, 4, 22, 7, 31, 0);
        ce2.setEndDate(this.calendar);
        ce2.setEndDateVerbatim("22 Apr 1994, 7:31 AM");
        ce2.setMethod("Picked");
        dataObjects.add(ce1);
        dataObjects.add(cevAttr);
        dataObjects.add(ce2);
        dataObjects.add(collectorMitch);
        dataObjects.add(collectorJim);
        dataObjects.add(collectorMeg);
        dataObjects.add(collectorRod);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        log.info((Object)"Creating a permit");
        Calendar issuedDate = Calendar.getInstance();
        issuedDate.set(1993, 1, 12);
        Calendar startDate = Calendar.getInstance();
        startDate.set(1993, 2, 1);
        Calendar endDate = Calendar.getInstance();
        endDate.set(1993, 5, 30);
        Permit permit = DataBuilder.createPermit("1991-PLAN-0001", "US Dept Wildlife", issuedDate, startDate, endDate, null);
        permit.setIssuedTo(ku);
        permit.setIssuedBy((Agent)agents.get(4));
        dataObjects.add(permit);
        log.info((Object)"Creating a repository agreement");
        RepositoryAgreement repoAg = new RepositoryAgreement();
        repoAg.initialize();
        repoAg.setDivision(division);
        repoAg.setRepositoryAgreementNumber("KU-1990-01");
        repoAg.setOriginator(ku);
        Calendar received = Calendar.getInstance();
        received.set(1992, 2, 10);
        repoAg.setDateReceived(received);
        Calendar repoEndDate = Calendar.getInstance();
        received.set(2010, 2, 9);
        repoAg.setEndDate(repoEndDate);
        dataObjects.add(repoAg);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating collection objects");
        Vector<CollectionObject> collObjs = new Vector<CollectionObject>();
        Collection col = collection;
        Calendar[] catDates = new Calendar[8];
        int i = 0;
        while (i < catDates.length) {
            catDates[i] = Calendar.getInstance();
            int year = 1980 + (int)(this.rand.nextDouble() * 20.0);
            catDates[i].set(year, 1, 12 + i);
            ++i;
        }
        String prefix = "000000";
        int catNo = 100;
        CollectingEvent[] colEves = new CollectingEvent[8];
        int i2 = 0;
        while (i2 < colEves.length) {
            colEves[i2] = this.createFakeCollectingEvent(agents, farmpond, "cut");
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + Integer.toString(catNo), "RSC" + Integer.toString(catNo), (Agent)agents.get(i2), col, 1, colEves[i2], catDates[i2], "BuildSampleDatabase"));
            ++catNo;
            ++i2;
        }
        dataObjects.addAll(collObjs);
        CollectingEvent[] collectingEventArray = colEves;
        int n = colEves.length;
        int n2 = 0;
        while (n2 < n) {
            CollectingEvent ce = collectingEventArray[n2];
            this.persist((Object)ce);
            ++n2;
        }
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating determinations");
        Vector<Determination> determs = new Vector<Determination>();
        Calendar recent = Calendar.getInstance();
        recent.set(2005, 10, 27, 13, 44, 0);
        Calendar longAgo = Calendar.getInstance();
        longAgo.set(1976, 1, 29, 8, 12, 0);
        Calendar whileBack = Calendar.getInstance();
        whileBack.set(2000, 7, 4, 9, 33, 12);
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(0), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(1), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(2), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(3), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(5), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(6), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(7), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(0), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, longAgo));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(1), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(2), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(3), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, longAgo));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, longAgo));
        ((Determination)determs.get(13)).setRemarks("This determination is totally wrong.  What a foolish determination.");
        this.persist(determs);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating preparations");
        Vector<PrepType> prepTypesForSaving = this.loadPrepTypes(discipline.getType());
        PrepType pressed = prepTypesForSaving.get(0);
        Vector<Preparation> preps = new Vector<Preparation>();
        Calendar prepDate = Calendar.getInstance();
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(0), (CollectionObject)collObjs.get(0), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(0), (CollectionObject)collObjs.get(1), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(3), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(2), (CollectionObject)collObjs.get(4), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(2), (CollectionObject)collObjs.get(5), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(3), (CollectionObject)collObjs.get(6), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(3), (CollectionObject)collObjs.get(7), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(0), (Storage)locs.get(11), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(1), (Storage)locs.get(11), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(10), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(2), (CollectionObject)collObjs.get(3), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(3), (CollectionObject)collObjs.get(4), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(0), (CollectionObject)collObjs.get(5), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(6), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(7), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(0), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(1), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(3), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(4), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        dataObjects.addAll(prepTypesForSaving);
        dataObjects.addAll(preps);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating accessions and accession agents");
        this.calendar.set(2006, 10, 27, 23, 59, 59);
        Accession acc1 = DataBuilder.createAccession(division, "gift", "complete", "2000-PL-001", DateFormat.getInstance().format(this.calendar.getTime()), this.calendar, this.calendar);
        acc1.setText1("Ichthyology");
        acc1.setRepositoryAgreement(repoAg);
        Agent donor = (Agent)agents.get(4);
        Agent receiver = (Agent)agents.get(1);
        Agent reviewer = (Agent)agents.get(2);
        Vector<AccessionAgent> accAgents = new Vector<AccessionAgent>();
        accAgents.add(DataBuilder.createAccessionAgent("donor", donor, acc1, null));
        accAgents.add(DataBuilder.createAccessionAgent("receiver", receiver, acc1, null));
        accAgents.add(DataBuilder.createAccessionAgent("reviewer", reviewer, acc1, null));
        Accession acc2 = DataBuilder.createAccession(division, "field_work", "inprocess", "2004-PL-002", DateFormat.getInstance().format(this.calendar.getTime()), this.calendar, this.calendar);
        Agent donor2 = (Agent)agents.get(5);
        Agent receiver2 = (Agent)agents.get(3);
        Agent reviewer2 = (Agent)agents.get(1);
        accAgents.add(DataBuilder.createAccessionAgent("donor", donor2, acc2, null));
        accAgents.add(DataBuilder.createAccessionAgent("receiver", receiver2, acc2, null));
        accAgents.add(DataBuilder.createAccessionAgent("reviewer", reviewer2, acc2, null));
        dataObjects.add(acc1);
        dataObjects.add(acc2);
        dataObjects.addAll(accAgents);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        this.createLoanExamples(preps, agents, dataObjects);
        this.frame.setProcess(++this.createStep);
        this.persist(dataObjects);
        dataObjects.clear();
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        this.commitTx();
        this.frame.setProcess(++this.createStep);
        DataBuilder.buildDarwinCoreSchema(discipline);
        log.info((Object)("Done creating Botany disciplineType database: " + disciplineType.getTitle()));
        return dataObjects;
    }

    public List<Object> createHugeBotanyCollection(DisciplineType disciplineType, Institution institution, SpecifyUser user, CollectionChoice choice) {
        this.frame.setProcess(0, 16);
        this.frame.setDesc("Creating Botany...");
        this.createStep = 0;
        this.startTx();
        Division division = DataBuilder.createDivision(institution, disciplineType.getName(), "Botany", "BT", "Botany");
        TaxonTreeDef taxonTreeDef = DataBuilder.createTaxonTreeDef("Taxon");
        GeographyTreeDef geoTreeDef = DataBuilder.createGeographyTreeDef("Geography");
        GeologicTimePeriodTreeDef gtpTreeDef = DataBuilder.createGeologicTimePeriodTreeDef("Chronos Stratigraphy");
        LithoStratTreeDef lithoStratTreeDef = DataBuilder.createLithoStratTreeDef("LithoStrat");
        boolean buildStorageTree = false;
        if (this.stgTreeDef == null) {
            this.stgTreeDef = DataBuilder.createStorageTreeDef("Storage");
            institution.setStorageTreeDef(this.stgTreeDef);
            buildStorageTree = true;
        }
        lithoStratTreeDef.setRemarks("A simple super, group, formation, member, bed Litho Stratigraphy tree");
        Discipline discipline = DataBuilder.createDiscipline(division, disciplineType.getName(), disciplineType.getTitle(), this.dataType, taxonTreeDef, geoTreeDef, gtpTreeDef, lithoStratTreeDef);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        this.persist((Object)institution);
        this.persist((Object)division);
        this.persist((Object)discipline);
        AppContextMgr.getInstance().setClassObject(Division.class, division);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        this.loadSchemaLocalization(discipline, SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance(), choice.getCatalogNumberingFmtName(), choice.getAccessionNumberingFmtName());
        String title = this.initPrefs.getProperty("useragent.title", "mr");
        String firstName = this.initPrefs.getProperty("useragent.firstname", "Test");
        String lastName = this.initPrefs.getProperty("useragent.lastname", "User");
        String midInit = this.initPrefs.getProperty("useragent.midinit", "A");
        String abbrev = this.initPrefs.getProperty("useragent.abbrev", "tu");
        String email = this.initPrefs.getProperty("useragent.email", "testuser@ku.edu");
        String userType = this.initPrefs.getProperty("useragent.usertype", SpecifyUserTypes.UserType.Manager.toString());
        System.out.println("----- User Agent -----");
        System.out.println("Title:     " + title);
        System.out.println("FirstName: " + firstName);
        System.out.println("LastName:  " + lastName);
        System.out.println("MidInit:   " + midInit);
        System.out.println("Abbrev:    " + abbrev);
        System.out.println("Email:     " + email);
        System.out.println("UserType:  " + userType);
        Agent userAgent = DataBuilder.createAgent(title, firstName, midInit, lastName, abbrev, email);
        discipline.addReference(userAgent, "agents");
        user.addReference(userAgent, "agents");
        this.persist((Object)discipline);
        this.persist((Object)userAgent);
        this.persist((Object)user);
        this.frame.setProcess(++this.createStep);
        Pair<AutoNumberingScheme, AutoNumberingScheme> pairANS = this.createAutoNumberingSchemes(choice);
        AutoNumberingScheme cns = (AutoNumberingScheme)pairANS.first;
        AutoNumberingScheme accessionNS = (AutoNumberingScheme)pairANS.second;
        this.persist((Object)cns);
        this.persist((Object)accessionNS);
        this.commitTx();
        this.startTx();
        log.info((Object)"Creating a Collection");
        Collection collection = DataBuilder.createCollection("KUBOT", "Botany", choice.getCatalogNumberingFmtName(), cns, discipline);
        this.persist((Object)collection);
        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
        division.addReference(accessionNS, "numberingSchemes");
        this.persist((Object)division);
        this.commitTx();
        BuildSampleDatabase.doShowHideTablesAndFields(null, discipline);
        BuildSampleDatabase.doShowHideTablesAndFields(disciplineType.getName(), discipline);
        this.frame.setProcess(++this.createStep);
        this.startTx();
        AppContextMgr.getInstance().setClassObject(SpecifyUser.class, user);
        user.addReference(userAgent, "agents");
        this.persist((Object)user);
        Journal journal = BuildSampleDatabase.createJournalsAndReferenceWork();
        this.frame.setProcess(++this.createStep);
        List<Object> taxa = BuildSampleDatabase.createSimpleBotanyTaxonTree(taxonTreeDef);
        List<Object> geos = BuildSampleDatabase.createSimpleGeography(geoTreeDef, true);
        List<Object> gtps = BuildSampleDatabase.createSimpleGeologicTimePeriod(gtpTreeDef, true);
        List<Object> lithoStrats = BuildSampleDatabase.createSimpleLithoStrat(lithoStratTreeDef, true);
        this.persist((Object)journal);
        this.persist(taxa);
        this.persist(geos);
        this.persist(buildStorageTree ? BuildSampleDatabase.createSimpleStorage(this.stgTreeDef) : null);
        this.persist(gtps);
        this.persist(lithoStrats);
        this.commitTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating picklists");
        this.frame.setDesc("Creating PickLists...");
        BuildSampleDatabase.createPickLists(this.session, null);
        BuildSampleDatabase.createPickLists(this.session, discipline);
        Vector<Object> dataObjects = new Vector<Object>();
        this.startTx();
        this.standardQueries(dataObjects, userAgent);
        this.persist(dataObjects);
        dataObjects.clear();
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        String POINT = "Point";
        this.frame.setDesc("Creating localities");
        log.info((Object)"Creating localities");
        this.frame.setProcess(0, this.NUM_LOCALTIES);
        Vector<Locality> localities = new Vector<Locality>();
        Vector<DataModelObjBase> evictList = new Vector<DataModelObjBase>();
        int i = 0;
        while (i < this.NUM_LOCALTIES) {
            Locality locality = DataBuilder.createLocality("Unnamed forest stream pond", (Geography)geos.get(12));
            locality.setLatLongType(POINT);
            locality.setOriginalLatLongUnit(0);
            locality.setLat1text("38.925467 deg N");
            locality.setLatitude1(new BigDecimal(38.925467));
            locality.setLong1text("94.984867 deg W");
            locality.setLongitude1(new BigDecimal(-94.984867));
            this.persist((Object)locality);
            evictList.add(locality);
            localities.add(locality);
            if ((i + 1) % 10 == 0) {
                this.commitTx();
                for (Object e : evictList) {
                    this.session.evict(e);
                }
                evictList.clear();
                this.startTx();
                this.frame.setProcess(i);
            }
            ++i;
        }
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating agents and addresses");
        Vector<Agent> agents = new Vector<Agent>();
        lastName = userAgent.getLastName();
        Agent steveBoyd = DataBuilder.createAgent("mr", "Steve", "D", "Boyd", "jb", "jb@net.edu");
        if (!lastName.equals("Cooper")) {
            agents.add(DataBuilder.createAgent("mr", "Peter", "D", "Cooper", "ds", "ds@whitehouse.gov"));
        }
        if (!lastName.equals("Peck")) {
            agents.add(DataBuilder.createAgent("mr", "David", "H", "Peck", "rb", "beach@net.edu"));
        }
        if (!lastName.equals("Appleton")) {
            agents.add(DataBuilder.createAgent("mrs", "Sally", "H", "Appleton", "jm", "jm@net.edu"));
        }
        if (!lastName.equals("Brown")) {
            agents.add(DataBuilder.createAgent("mr", "Taylor", "C", "Brown", "kcs", "taylor.brown@ku.edu"));
        }
        if (!lastName.equals("Boyd")) {
            agents.add(steveBoyd);
        }
        if (!lastName.equals("Thomas")) {
            agents.add(DataBuilder.createAgent("Mr", "James", "X", "Thomas", "dxt", ""));
        }
        if (!lastName.equals("Peterson")) {
            agents.add(DataBuilder.createAgent("mr", "Pete", "A", "Peterson", "jb", ""));
        }
        if (!lastName.equals("Guttenburg")) {
            agents.add(DataBuilder.createAgent("mr", "Mitch", "A", "Guttenburg", "jb", ""));
        }
        if (!lastName.equals("Ford")) {
            agents.add(DataBuilder.createAgent("mr", "Daniel", "A", "Ford", "mas", "mas@ku.edu"));
        }
        agents.add(userAgent);
        Agent agent = new Agent();
        agent.initialize();
        agent.setAbbreviation("KU");
        agent.setAgentType((byte)0);
        agent.setLastName("University of Kansas");
        agent.setEmail("webadmin@ku.edu");
        agent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        agent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(agent);
        ((Agent)agents.get(0)).setOrganization(agent);
        ((Agent)agents.get(1)).setOrganization(agent);
        ((Agent)agents.get(2)).setOrganization(agent);
        ((Agent)agents.get(3)).setOrganization(agent);
        ((Agent)agents.get(8)).setOrganization(agent);
        Agent otherAgent = new Agent();
        otherAgent.initialize();
        otherAgent.setAbbreviation("O");
        otherAgent.setAgentType((byte)2);
        otherAgent.setLastName("The Other Guys");
        otherAgent.setEmail("other@other.com");
        otherAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        otherAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(otherAgent);
        this.commitTx();
        ArrayList<GroupPerson> gpList = new ArrayList<GroupPerson>();
        this.startTx();
        Agent gm1 = DataBuilder.createAgent("mr", "John", "A", "Lyon", "jal", "jal@group.edu");
        Agent gm2 = DataBuilder.createAgent("mr", "Dave", "D", "Jones", "ddj", "ddj@group.edu");
        this.persist((Object)gm1);
        this.persist((Object)gm2);
        this.commitTx();
        Agent groupAgent = new Agent();
        groupAgent.initialize();
        groupAgent.setAbbreviation("GRP");
        groupAgent.setAgentType((byte)3);
        groupAgent.setLastName("The Group");
        groupAgent.setEmail("group@group.com");
        groupAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        groupAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(groupAgent);
        gpList.add(DataBuilder.createGroupPerson(groupAgent, gm1, 0, division));
        gpList.add(DataBuilder.createGroupPerson(groupAgent, gm2, 1, division));
        this.startTx();
        Vector<AgentVariant> agentVariants = new Vector<AgentVariant>();
        agentVariants.add(DataBuilder.createAgentVariant(AgentVariant.VARIANT, "James Variant #1", steveBoyd));
        agentVariants.add(DataBuilder.createAgentVariant(AgentVariant.VERNACULAR, "James VERNACULAR #1", steveBoyd));
        Vector<Address> addrs = new Vector<Address>();
        addrs.add(DataBuilder.createAddress((Agent)agents.get(1), "1600 Pennsylvania Avenue NW", null, "Washington", "DC", "USA", "20500", 0));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(1), "??? Mississippi", null, "Lawrence", "KS", "USA", "66045", 1));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(2), "1 Main St", "", "Lenexa", "KS", "USA", "66071"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(3), "13355 Inverness", "Bldg #3", "Lawrence", "KS", "USA", "66047"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(4), "Natural History Museum", "Cromwell Rd", "London", null, "UK", "SW7 5BD"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(6), "1212 Apple Street", null, "Chicago", "IL", "USA", "01010"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(8), "11911 Oak Ln", null, "Orion", "KS", "USA", "66061"));
        addrs.add(DataBuilder.createAddress(agent, null, null, "Lawrence", "KS", "USA", "66045"));
        addrs.add(DataBuilder.createAddress(userAgent, "1214 East Street", null, "Grinnell", "IA", "USA", "56060"));
        userAgent.setDivision(division);
        this.persist(agents);
        this.persist(agentVariants);
        this.persist(gpList);
        this.commitTx();
        this.startTx();
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        log.info((Object)"Creating collection objects");
        Calendar[] catDates = new Calendar[300];
        int i2 = 0;
        while (i2 < catDates.length) {
            catDates[i2] = Calendar.getInstance();
            int year = 1980 + (int)(this.rand.nextDouble() * 20.0);
            catDates[i2].set(year, 1, 12 + i2);
            ++i2;
        }
        Vector<PrepType> prepTypesForSaving = this.loadPrepTypes(discipline.getType());
        dataObjects.addAll(prepTypesForSaving);
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        this.commitTx();
        PrepType pressed = prepTypesForSaving.get(0);
        this.startTx();
        this.frame.setProcess(0, this.NUM_COLOBJS);
        evictList.clear();
        this.frame.setDesc("Creating Collection Objects");
        int catNo = 100;
        int i3 = 0;
        while (i3 < this.NUM_COLOBJS) {
            int years20 = (int)(this.rand.nextDouble() * 20.0);
            int years10 = (int)(this.rand.nextDouble() * 10.0);
            int years50 = (int)(this.rand.nextDouble() * 50.0);
            Calendar recent = Calendar.getInstance();
            recent.set(1950 + years20 + years10, 10, 27, 13, 44, 0);
            Calendar longAgo = Calendar.getInstance();
            longAgo.set(1900 + years50, 1, 29, 8, 12, 0);
            Calendar whileBack = Calendar.getInstance();
            whileBack.set(1960 + years20, 7, 4, 9, 33, 12);
            String catNumStr = String.format("%09d", catNo);
            int inx = (int)(this.rand.nextDouble() * (double)localities.size());
            int agentInx = (int)(this.rand.nextDouble() * (double)agents.size());
            int agentInx2 = (int)(this.rand.nextDouble() * (double)agents.size());
            int calInx = (int)(this.rand.nextDouble() * (double)catDates.length);
            CollectingEvent ce = this.createFakeCollectingEvent(agents, (Locality)localities.get(inx), "cut");
            CollectionObject co = DataBuilder.createCollectionObject(catNumStr, "RSC" + Integer.toString(catNo), (Agent)agents.get(agentInx), collection, 1, ce, catDates[calInx], "BuildSampleDatabase");
            Determination dt = DataBuilder.createDetermination(co, this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent);
            Calendar prepDate = Calendar.getInstance();
            Preparation prep = DataBuilder.createPreparation(pressed, (Agent)agents.get(agentInx2), co, (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate);
            this.persist((Object)ce);
            this.persist((Object)co);
            this.persist((Object)dt);
            this.persist((Object)prep);
            evictList.add(ce);
            evictList.add(co);
            evictList.add(dt);
            evictList.add(prep);
            if ((i3 + 1) % 10 == 0) {
                this.commitTx();
                for (Object e : evictList) {
                    this.session.evict(e);
                }
                evictList.clear();
                this.startTx();
                this.frame.setProcess(i3);
            }
            ++catNo;
            ++i3;
        }
        this.commitTx();
        this.frame.setProcess(++this.createStep);
        DataBuilder.buildDarwinCoreSchema(discipline);
        log.info((Object)("Done creating Botany disciplineType database: " + disciplineType.getTitle()));
        return dataObjects;
    }

    public List<Object> createSingleInvertPaleoCollection(DisciplineType disciplineType, Institution institution, SpecifyUser user, CollectionChoice choice) {
        this.frame.setProcess(0, 16);
        this.frame.setDesc("Creating " + disciplineType.getTitle() + "...");
        this.createStep = 0;
        this.startTx();
        Division division = DataBuilder.createDivision(institution, disciplineType.getName(), disciplineType.getTitle(), "INVP", disciplineType.getTitle());
        TaxonTreeDef taxonTreeDef = DataBuilder.createTaxonTreeDef("Taxon");
        GeographyTreeDef geoTreeDef = DataBuilder.createGeographyTreeDef("Geography");
        GeologicTimePeriodTreeDef gtpTreeDef = DataBuilder.createGeologicTimePeriodTreeDef("Chronos Stratigraphy");
        LithoStratTreeDef lithoStratTreeDef = DataBuilder.createLithoStratTreeDef("LithoStrat");
        boolean buildStorageTree = false;
        if (this.stgTreeDef == null) {
            this.stgTreeDef = DataBuilder.createStorageTreeDef("Storage");
            institution.setStorageTreeDef(this.stgTreeDef);
            buildStorageTree = true;
        }
        lithoStratTreeDef.setRemarks("A simple super, group, formation, member, bed Litho Stratigraphy tree");
        Discipline discipline = DataBuilder.createDiscipline(division, disciplineType.getName(), disciplineType.getTitle(), this.dataType, taxonTreeDef, geoTreeDef, gtpTreeDef, lithoStratTreeDef);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        this.persist((Object)institution);
        this.persist((Object)division);
        this.persist((Object)discipline);
        AppContextMgr.getInstance().setClassObject(Division.class, division);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        this.loadSchemaLocalization(discipline, SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance(), choice.getCatalogNumberingFmtName(), choice.getAccessionNumberingFmtName());
        String title = this.initPrefs.getProperty("useragent.title", "mr");
        String firstName = this.initPrefs.getProperty("useragent.firstname", "Test");
        String lastName = this.initPrefs.getProperty("useragent.lastname", "User");
        String midInit = this.initPrefs.getProperty("useragent.midinit", "A");
        String abbrev = this.initPrefs.getProperty("useragent.abbrev", "tu");
        String email = this.initPrefs.getProperty("useragent.email", "testuser@ku.edu");
        String userType = this.initPrefs.getProperty("useragent.usertype", SpecifyUserTypes.UserType.Manager.toString());
        System.out.println("----- User Agent -----");
        System.out.println("Title:     " + title);
        System.out.println("FirstName: " + firstName);
        System.out.println("LastName:  " + lastName);
        System.out.println("MidInit:   " + midInit);
        System.out.println("Abbrev:    " + abbrev);
        System.out.println("Email:     " + email);
        System.out.println("UserType:  " + userType);
        Agent userAgent = DataBuilder.createAgent(title, firstName, midInit, lastName, abbrev, email);
        discipline.addReference(userAgent, "agents");
        user.addReference(userAgent, "agents");
        this.persist((Object)discipline);
        this.persist((Object)userAgent);
        this.persist((Object)user);
        this.frame.setProcess(++this.createStep);
        Pair<AutoNumberingScheme, AutoNumberingScheme> pairANS = this.createAutoNumberingSchemes(choice);
        AutoNumberingScheme cns = (AutoNumberingScheme)pairANS.first;
        AutoNumberingScheme accessionNS = (AutoNumberingScheme)pairANS.second;
        this.persist((Object)cns);
        this.persist((Object)accessionNS);
        this.commitTx();
        this.startTx();
        log.info((Object)"Creating a Collection");
        Collection collection = DataBuilder.createCollection("KUIVP", disciplineType.getTitle(), choice.getCatalogNumberingFmtName(), cns, discipline);
        this.persist((Object)collection);
        Map<String, SpPrincipal> groupMap = DataBuilder.createStandardGroups(this.session, collection);
        user.addUserToSpPrincipalGroup(groupMap.get(SpecifyUserTypes.UserType.Manager.toString()));
        DataBuilder.createAndAddTesterToCollection(this.session, "ivpuser", "InvertPaleo@ku.edu", "ivpuser", "mr", "Joe", "", "InvertPaleo", "", discipline, division, collection, groupMap, "Guest");
        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
        division.addReference(accessionNS, "numberingSchemes");
        this.persist((Object)division);
        this.commitTx();
        BuildSampleDatabase.doShowHideTablesAndFields(null, discipline);
        BuildSampleDatabase.doShowHideTablesAndFields(disciplineType.getName(), discipline);
        this.frame.setProcess(++this.createStep);
        this.startTx();
        AppContextMgr.getInstance().setClassObject(SpecifyUser.class, user);
        user.addReference(userAgent, "agents");
        this.persist((Object)user);
        Journal journal = BuildSampleDatabase.createJournalsAndReferenceWork();
        this.frame.setProcess(++this.createStep);
        List<Object> taxa = BuildSampleDatabase.createSimpleBotanyTaxonTree(taxonTreeDef);
        List<Object> geos = BuildSampleDatabase.createSimpleGeography(geoTreeDef, true);
        List<Object> gtps = BuildSampleDatabase.createSimpleGeologicTimePeriod(gtpTreeDef, true);
        this.persist((Object)journal);
        this.persist(taxa);
        this.persist(geos);
        this.persist(buildStorageTree ? BuildSampleDatabase.createSimpleStorage(this.stgTreeDef) : null);
        this.persist(gtps);
        this.commitTx();
        LithoStrat earthLithoStrat = this.convertLithoStratFromCSV(lithoStratTreeDef);
        if (earthLithoStrat == null) {
            this.startTx();
            List<Object> lithoStrats = BuildSampleDatabase.createSimpleLithoStrat(lithoStratTreeDef, true);
            this.persist(lithoStrats);
            this.commitTx();
        }
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating picklists");
        this.frame.setDesc("Creating Common PickLists...");
        BuildSampleDatabase.createPickLists(this.session, null);
        this.frame.setDesc("Creating PickLists...");
        BuildSampleDatabase.createPickLists(this.session, discipline);
        Vector<Object> dataObjects = new Vector<Object>();
        this.startTx();
        this.frame.setDesc("Creating Queries...");
        this.standardQueries(dataObjects, userAgent);
        this.persist(dataObjects);
        dataObjects.clear();
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setDesc("Intermediate save....");
        this.commitTx();
        this.frame.setDesc("Creating Localities....");
        this.startTx();
        this.frame.setProcess(++this.createStep);
        String POINT = "Point";
        String LINE = "Line";
        String RECT = "Rectangle";
        log.info((Object)"Creating localities");
        Locality forestStream = DataBuilder.createLocality("Gravel Pit", (Geography)geos.get(12));
        forestStream.setLatLongType(POINT);
        forestStream.setOriginalLatLongUnit(0);
        forestStream.setLat1text("38.925467 deg N");
        forestStream.setLatitude1(new BigDecimal(38.925467));
        forestStream.setLong1text("94.984867 deg W");
        forestStream.setLongitude1(new BigDecimal(-94.984867));
        Locality lake = DataBuilder.createLocality("Deep, dark lake pond", (Geography)geos.get(17));
        lake.setLatLongType(RECT);
        lake.setOriginalLatLongUnit(1);
        lake.setLat1text("41.548842 deg N");
        lake.setLatitude1(new BigDecimal(41.548842));
        lake.setLong1text("93.732129 deg W");
        lake.setLongitude1(new BigDecimal(-93.732129));
        lake.setLat2text("41.642195 deg N");
        lake.setLatitude2(new BigDecimal(41.642195));
        lake.setLong2text("100.403180 deg W");
        lake.setLongitude2(new BigDecimal(-100.40318));
        Locality farmpond = DataBuilder.createLocality("Shoal Creek at Schermerhorn Park, S of Galena at Rt. 26", (Geography)geos.get(11));
        farmpond.setLatLongType(LINE);
        farmpond.setOriginalLatLongUnit(2);
        farmpond.setLat1text("41.642187 deg N");
        farmpond.setLatitude1(new BigDecimal(41.642187));
        farmpond.setLong1text("100.403163 deg W");
        farmpond.setLongitude1(new BigDecimal(-100.403163));
        farmpond.setLat2text("49.647435 deg N");
        farmpond.setLatitude2(new BigDecimal(49.647435));
        farmpond.setLong2text("-55.112163 deg W");
        farmpond.setLongitude2(new BigDecimal(-55.112163));
        this.persist((Object)forestStream);
        this.persist((Object)lake);
        this.persist((Object)farmpond);
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating agents and addresses");
        Vector<Agent> agents = new Vector<Agent>();
        lastName = userAgent.getLastName();
        Agent steveBoyd = DataBuilder.createAgent("mr", "Steve", "D", "Boyd", "jb", "jb@net.edu");
        if (!lastName.equals("Cooper")) {
            agents.add(DataBuilder.createAgent("mr", "Peter", "D", "Cooper", "ds", "ds@whitehouse.gov"));
        }
        if (!lastName.equals("Peck")) {
            agents.add(DataBuilder.createAgent("mr", "David", "H", "Peck", "rb", "beach@net.edu"));
        }
        if (!lastName.equals("Appleton")) {
            agents.add(DataBuilder.createAgent("mrs", "Sally", "H", "Appleton", "jm", "jm@net.edu"));
        }
        if (!lastName.equals("Brown")) {
            agents.add(DataBuilder.createAgent("mr", "Taylor", "C", "Brown", "kcs", "taylor.brown@ku.edu"));
        }
        if (!lastName.equals("Boyd")) {
            agents.add(steveBoyd);
        }
        if (!lastName.equals("Thomas")) {
            agents.add(DataBuilder.createAgent("Mr", "James", "X", "Thomas", "dxt", ""));
        }
        if (!lastName.equals("Peterson")) {
            agents.add(DataBuilder.createAgent("mr", "Pete", "A", "Peterson", "jb", ""));
        }
        if (!lastName.equals("Guttenburg")) {
            agents.add(DataBuilder.createAgent("mr", "Mitch", "A", "Guttenburg", "jb", ""));
        }
        if (!lastName.equals("Ford")) {
            agents.add(DataBuilder.createAgent("mr", "Daniel", "A", "Ford", "mas", "mas@ku.edu"));
        }
        agents.add(userAgent);
        Agent ku = new Agent();
        ku.initialize();
        ku.setAbbreviation("KU");
        ku.setAgentType((byte)0);
        ku.setLastName("University of Kansas");
        ku.setEmail("webadmin@ku.edu");
        ku.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        ku.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(ku);
        ((Agent)agents.get(0)).setOrganization(ku);
        ((Agent)agents.get(1)).setOrganization(ku);
        ((Agent)agents.get(2)).setOrganization(ku);
        ((Agent)agents.get(3)).setOrganization(ku);
        ((Agent)agents.get(8)).setOrganization(ku);
        Agent otherAgent = new Agent();
        otherAgent.initialize();
        otherAgent.setAbbreviation("O");
        otherAgent.setAgentType((byte)2);
        otherAgent.setLastName("The Other Guys");
        otherAgent.setEmail("other@other.com");
        otherAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        otherAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(otherAgent);
        this.commitTx();
        ArrayList<GroupPerson> gpList = new ArrayList<GroupPerson>();
        this.startTx();
        Agent gm1 = DataBuilder.createAgent("mr", "John", "A", "Lyon", "jal", "jal@group.edu");
        Agent gm2 = DataBuilder.createAgent("mr", "Dave", "D", "Jones", "ddj", "ddj@group.edu");
        this.persist((Object)gm1);
        this.persist((Object)gm2);
        this.commitTx();
        Agent groupAgent = new Agent();
        groupAgent.initialize();
        groupAgent.setAbbreviation("GRP");
        groupAgent.setAgentType((byte)3);
        groupAgent.setLastName("The Group");
        groupAgent.setEmail("group@group.com");
        groupAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        groupAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(groupAgent);
        gpList.add(DataBuilder.createGroupPerson(groupAgent, gm1, 0, division));
        gpList.add(DataBuilder.createGroupPerson(groupAgent, gm2, 1, division));
        this.startTx();
        Vector<Address> addrs = new Vector<Address>();
        addrs.add(DataBuilder.createAddress((Agent)agents.get(1), "1600 Pennsylvania Avenue NW", null, "Washington", "DC", "USA", "20500", 0));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(1), "??? Mississippi", null, "Lawrence", "KS", "USA", "66045", 1));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(2), "1 Main St", "", "Lenexa", "KS", "USA", "66071"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(3), "13355 Inverness", "Bldg #3", "Lawrence", "KS", "USA", "66047"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(4), "Natural History Museum", "Cromwell Rd", "London", null, "UK", "SW7 5BD"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(6), "1212 Apple Street", null, "Chicago", "IL", "USA", "01010"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(8), "11911 Oak Ln", null, "Orion", "KS", "USA", "66061"));
        addrs.add(DataBuilder.createAddress(ku, null, null, "Lawrence", "KS", "USA", "66045"));
        addrs.add(DataBuilder.createAddress(userAgent, "1214 East Street", null, "Grinnell", "IA", "USA", "56060"));
        userAgent.setDivision(division);
        this.persist(agents);
        this.persist(gpList);
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating collecting events, collectors and a collecting trip");
        Collector collectorMitch = DataBuilder.createCollector((Agent)agents.get(7), 2);
        Collector collectorJim = DataBuilder.createCollector((Agent)agents.get(2), 1);
        String stationFieldNumber = String.format(this.STATION_FIELD_FORMAT, this.stationFieldNumberCounter++);
        this.calendar.set(1994, 4, 21, 11, 56, 0);
        CollectingEvent ce1 = DataBuilder.createCollectingEvent(forestStream, this.calendar, stationFieldNumber, new Collector[]{collectorMitch, collectorJim});
        ce1.setStartDateVerbatim("21 Apr 1994, 11:56 AM");
        this.calendar.set(1994, 4, 21, 13, 3, 0);
        ce1.setEndDate(this.calendar);
        ce1.setEndDateVerbatim("21 Apr 1994, 1:03 PM");
        ce1.setMethod("Picked");
        AttributeDef cevAttrDef = DataBuilder.createAttributeDef(AttributeIFace.FieldType.StringType, "ParkName", discipline, null);
        this.persist((Object)cevAttrDef);
        this.commitTx();
        this.startTx();
        CollectingEventAttr cevAttr = DataBuilder.createCollectingEventAttr(ce1, cevAttrDef, "Sleepy Hollow", null);
        Collector collectorMeg = DataBuilder.createCollector((Agent)agents.get(2), 1);
        Collector collectorRod = DataBuilder.createCollector((Agent)agents.get(3), 2);
        stationFieldNumber = String.format(this.STATION_FIELD_FORMAT, this.stationFieldNumberCounter++);
        this.calendar.set(1994, 4, 22, 6, 12, 0);
        CollectingEvent ce2 = DataBuilder.createCollectingEvent(farmpond, this.calendar, stationFieldNumber, new Collector[]{collectorMeg, collectorRod});
        ce2.setStartDateVerbatim("22 Apr 1994, 6:12 AM");
        this.calendar.set(1994, 4, 22, 7, 31, 0);
        ce2.setEndDate(this.calendar);
        ce2.setEndDateVerbatim("22 Apr 1994, 7:31 AM");
        ce2.setMethod("Picked");
        dataObjects.add(ce1);
        dataObjects.add(cevAttr);
        dataObjects.add(ce2);
        dataObjects.add(collectorMitch);
        dataObjects.add(collectorJim);
        dataObjects.add(collectorMeg);
        dataObjects.add(collectorRod);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        log.info((Object)"Creating a permit");
        Calendar issuedDate = Calendar.getInstance();
        issuedDate.set(1993, 1, 12);
        Calendar startDate = Calendar.getInstance();
        startDate.set(1993, 2, 1);
        Calendar endDate = Calendar.getInstance();
        endDate.set(1993, 5, 30);
        Permit permit = DataBuilder.createPermit("1980-INVRTP-0001", "US Dept Wildlife", issuedDate, startDate, endDate, null);
        permit.setIssuedTo(ku);
        permit.setIssuedBy((Agent)agents.get(4));
        dataObjects.add(permit);
        log.info((Object)"Creating a repository agreement");
        RepositoryAgreement repoAg = new RepositoryAgreement();
        repoAg.initialize();
        repoAg.setDivision(division);
        repoAg.setRepositoryAgreementNumber("KU-1979-01");
        repoAg.setOriginator(ku);
        Calendar received = Calendar.getInstance();
        received.set(1992, 2, 10);
        repoAg.setDateReceived(received);
        Calendar repoEndDate = Calendar.getInstance();
        received.set(2010, 2, 9);
        repoAg.setEndDate(repoEndDate);
        dataObjects.add(repoAg);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating collection objects");
        Vector<CollectionObject> collObjs = new Vector<CollectionObject>();
        Collection col = collection;
        Calendar[] catDates = new Calendar[8];
        int i = 0;
        while (i < catDates.length) {
            catDates[i] = Calendar.getInstance();
            int year = 1980 + (int)(this.rand.nextDouble() * 20.0);
            catDates[i].set(year, 1, 12 + i);
            ++i;
        }
        String prefix = "000000";
        int catNo = 100;
        CollectingEvent[] colEves = new CollectingEvent[8];
        int i2 = 0;
        while (i2 < colEves.length) {
            colEves[i2] = this.createFakeCollectingEvent(agents, farmpond, "Dug");
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + Integer.toString(catNo), "RSC" + Integer.toString(catNo), (Agent)agents.get(i2), col, 1, colEves[i2], catDates[i2], "BuildSampleDatabase"));
            ++catNo;
            ++i2;
        }
        dataObjects.addAll(collObjs);
        CollectingEvent[] collectingEventArray = colEves;
        int n = colEves.length;
        int n2 = 0;
        while (n2 < n) {
            CollectingEvent ce = collectingEventArray[n2];
            this.persist((Object)ce);
            ++n2;
        }
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating determinations");
        Vector<Determination> determs = new Vector<Determination>();
        Calendar recent = Calendar.getInstance();
        recent.set(2005, 10, 27, 13, 44, 0);
        Calendar longAgo = Calendar.getInstance();
        longAgo.set(1976, 1, 29, 8, 12, 0);
        Calendar whileBack = Calendar.getInstance();
        whileBack.set(2000, 7, 4, 9, 33, 12);
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(0), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(1), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(2), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(3), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(5), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(6), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(7), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(0), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, longAgo));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(1), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(2), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(3), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, longAgo));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, longAgo));
        ((Determination)determs.get(13)).setRemarks("This determination is totally wrong.  What a foolish determination.");
        this.persist(determs);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating preparations");
        Vector<PrepType> prepTypesForSaving = this.loadPrepTypes(discipline.getType());
        PrepType pressed = prepTypesForSaving.get(0);
        Vector<Preparation> preps = new Vector<Preparation>();
        Calendar prepDate = Calendar.getInstance();
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(0), (CollectionObject)collObjs.get(0), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(0), (CollectionObject)collObjs.get(1), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(3), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(2), (CollectionObject)collObjs.get(4), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(2), (CollectionObject)collObjs.get(5), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(3), (CollectionObject)collObjs.get(6), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(3), (CollectionObject)collObjs.get(7), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(0), (Storage)locs.get(11), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(1), (Storage)locs.get(11), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(10), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(2), (CollectionObject)collObjs.get(3), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(3), (CollectionObject)collObjs.get(4), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(0), (CollectionObject)collObjs.get(5), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(6), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(7), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(0), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(1), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(3), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(4), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        dataObjects.addAll(prepTypesForSaving);
        dataObjects.addAll(preps);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating accessions and accession agents");
        this.calendar.set(2006, 10, 27, 23, 59, 59);
        Accession acc1 = DataBuilder.createAccession(division, "gift", "complete", "2000-IP-001", DateFormat.getInstance().format(this.calendar.getTime()), this.calendar, this.calendar);
        acc1.setText1(disciplineType.getTitle());
        acc1.setRepositoryAgreement(repoAg);
        Agent donor = (Agent)agents.get(4);
        Agent receiver = (Agent)agents.get(1);
        Agent reviewer = (Agent)agents.get(2);
        Vector<AccessionAgent> accAgents = new Vector<AccessionAgent>();
        accAgents.add(DataBuilder.createAccessionAgent("donor", donor, acc1, null));
        accAgents.add(DataBuilder.createAccessionAgent("receiver", receiver, acc1, null));
        accAgents.add(DataBuilder.createAccessionAgent("reviewer", reviewer, acc1, null));
        Accession acc2 = DataBuilder.createAccession(division, "field_work", "inprocess", "2004-IP-002", DateFormat.getInstance().format(this.calendar.getTime()), this.calendar, this.calendar);
        Agent donor2 = (Agent)agents.get(5);
        Agent receiver2 = (Agent)agents.get(3);
        Agent reviewer2 = (Agent)agents.get(1);
        accAgents.add(DataBuilder.createAccessionAgent("donor", donor2, acc2, null));
        accAgents.add(DataBuilder.createAccessionAgent("receiver", receiver2, acc2, null));
        accAgents.add(DataBuilder.createAccessionAgent("reviewer", reviewer2, acc2, null));
        dataObjects.add(acc1);
        dataObjects.add(acc2);
        dataObjects.addAll(accAgents);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        this.createLoanExamples(preps, agents, dataObjects);
        this.frame.setProcess(++this.createStep);
        this.persist(dataObjects);
        dataObjects.clear();
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        this.commitTx();
        this.frame.setProcess(++this.createStep);
        DataBuilder.buildDarwinCoreSchema(discipline);
        log.info((Object)("Done creating " + disciplineType.getTitle() + " disciplineType database: " + disciplineType.getTitle()));
        return dataObjects;
    }

    public LithoStrat convertLithoStratFromCSV(LithoStratTreeDef treeDef) {
        Hashtable lithoStratHash = new Hashtable();
        lithoStratHash.clear();
        File file = new File("demo_files/Stratigraphy.csv");
        if (!file.exists()) {
            log.error((Object)("Couldn't file[" + file.getAbsolutePath() + "] checking the config dir"));
            file = XMLHelper.getConfigDir("Stratigraphy.csv");
            if (!file.exists()) {
                file = new File("Specify/demo_files/Stratigraphy.csv");
            }
        }
        if (file == null || !file.exists()) {
            log.error((Object)("Couldn't file[" + file.getAbsolutePath() + "]"));
            return null;
        }
        List lines = null;
        try {
            lines = FileUtils.readLines((File)file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        this.startTx();
        LithoStrat earth = new LithoStrat();
        earth.initialize();
        earth.setName(UIRegistry.getResourceString("Earth"));
        earth.setFullName(earth.getName());
        earth.setNodeNumber(1);
        earth.setHighestChildNodeNumber(1);
        earth.setRankId(0);
        earth.setDefinition(treeDef);
        LithoStratTreeDefItem defItem = treeDef.getDefItemByRank(0);
        earth.setDefinitionItem(defItem);
        this.persist((Object)earth);
        this.frame.setDesc("Adding Stratigraphy Objects");
        this.frame.setProcess(0, lines.size());
        int counter = 0;
        for (String line : lines) {
            String[] columns;
            if (counter == 0) {
                counter = 1;
                continue;
            }
            if (counter % 100 == 0) {
                this.frame.setProcess(counter);
                log.info((Object)("Converted " + counter + " Stratigraphy records"));
            }
            if ((columns = StringUtils.splitPreserveAllTokens((String)line, (char)',')).length < 7) {
                log.error((Object)("Skipping[" + line + "]"));
                continue;
            }
            String superGroup = columns[2];
            String lithoGroup = columns[3];
            String formation = columns[4];
            String member = columns[5];
            String bed = columns[6];
            LithoStrat newStrat = this.convertOldStratRecord(superGroup, lithoGroup, formation, member, bed, earth);
            ++counter;
        }
        this.frame.setProcess(counter);
        log.info((Object)("Converted " + counter + " Stratigraphy records"));
        TreeHelper.fixFullnameForNodeAndDescendants(earth);
        earth.setNodeNumber(1);
        BuildSampleDatabase.fixNodeNumbersFromRoot(earth);
        this.commitTx();
        log.info((Object)("Converted " + counter + " Stratigraphy records"));
        lithoStratHash.clear();
        return earth;
    }

    public Geography createGeographyFromGeonames(Discipline discipline, Agent agent, String itUsername, String itPassword) {
        Geography earth = null;
        BuildFromGeonames bldGeoNames = new BuildFromGeonames(discipline.getGeographyTreeDef(), now, agent, itUsername, itPassword, this.frame);
        try {
            this.startTx();
            earth = bldGeoNames.buildEarth(this.session);
            this.commitTx();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.rollbackTx();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BackupServiceFactory.class, ex);
            return null;
        }
        try {
            for (String nm : BasicSQLUtils.getTableNames(DBConnection.getInstance().getConnection())) {
                System.err.println(nm);
            }
            if (bldGeoNames.loadGeoNamesDB()) {
                bldGeoNames.build(earth.getId());
            }
            this.session.refresh((Object)earth);
            GeographyTreeDef geoTreeDef = discipline.getGeographyTreeDef();
            this.session.refresh((Object)earth);
            this.frame.setDesc("Configuring Geography Tree...");
            Discipline disp = AppContextMgr.getInstance().getClassObject(Discipline.class);
            if (disp == null) {
                AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
            }
            geoTreeDef.updateAllNodes(earth, true, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return earth;
    }

    public Geography convertGeographyFromXLS(GeographyTreeDef treeDef) {
        this.frame.setDesc("Building Geography Tree...");
        Hashtable geoHash = new Hashtable();
        geoHash.clear();
        String fileName = "Geography.xls";
        File file = XMLHelper.getConfigDir("../demo_files/" + fileName);
        if (!file.exists()) {
            log.error((Object)("Couldn't file[" + file.getAbsolutePath() + "] checking the config dir"));
            file = XMLHelper.getConfigDir(fileName);
            if (!file.exists()) {
                file = new File("Specify/demo_files/" + fileName);
            }
        }
        if (file == null || !file.exists()) {
            log.error((Object)("Couldn't file[" + file.getAbsolutePath() + "]"));
            return null;
        }
        Geography earth = new Geography();
        earth.initialize();
        earth.setName(UIRegistry.getResourceString("Earth"));
        earth.setFullName(earth.getName());
        earth.setNodeNumber(1);
        earth.setHighestChildNodeNumber(1);
        earth.setRankId(0);
        earth.setDefinition(treeDef);
        GeographyTreeDefItem defItem = treeDef.getDefItemByRank(0);
        earth.setDefinitionItem(defItem);
        int counter = 0;
        try {
            this.startTx();
            this.persist((Object)earth);
            String[] cells = new String[4];
            FileInputStream input = new FileInputStream(file);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)input);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            HSSFSheet sheet = workBook.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            int lastRowNum = sheet.getLastRowNum();
            if (this.frame != null) {
                final int mx = lastRowNum;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BuildSampleDatabase.this.frame.setProcess(0, mx);
                    }
                });
            }
            while (rows.hasNext()) {
                if (counter == 0) {
                    counter = 1;
                    rows.next();
                    continue;
                }
                if (counter % 100 == 0) {
                    if (this.frame != null) {
                        this.frame.setProcess(counter);
                    }
                    log.info((Object)("Converted " + counter + " Geography records"));
                }
                HSSFRow row = (HSSFRow)rows.next();
                Iterator cellsIter = row.cellIterator();
                int i = 0;
                while (cellsIter.hasNext() && i < 4) {
                    HSSFCell cell = (HSSFCell)cellsIter.next();
                    if (cell == null) continue;
                    cells[i] = StringUtils.trim((String)cell.getRichStringCellValue().getString());
                    ++i;
                }
                int j = i;
                while (j < 4) {
                    cells[j] = null;
                    ++j;
                }
                Geography newGeo = this.convertGeographyRecord(cells[0], cells[1], cells[2], cells[3], earth);
                ++counter;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.frame != null) {
            this.frame.setProcess(counter);
        }
        log.info((Object)("Converted " + counter + " Geography records"));
        this.frame.setDesc("Saving Geography Tree...");
        this.frame.getProcessProgress().setIndeterminate(true);
        TreeHelper.fixFullnameForNodeAndDescendants(earth);
        earth.setNodeNumber(1);
        BuildSampleDatabase.fixNodeNumbersFromRoot(earth);
        this.commitTx();
        log.info((Object)("Converted " + counter + " Stratigraphy records"));
        geoHash.clear();
        return earth;
    }

    public void saveTree(Treeable root) {
        this.persist((Object)root);
        for (Treeable child : root.getChildren()) {
            this.saveTree(child);
        }
    }

    public void printTree(Treeable root, int level) {
        int i = 0;
        while (i < level) {
            System.out.print(" ");
            ++i;
        }
        System.out.println(String.valueOf(root.getName()) + "  " + root.getNodeNumber() + "  " + root.getHighestChildNodeNumber());
        for (Treeable child : root.getChildren()) {
            this.printTree(child, level + 2);
        }
    }

    protected LithoStrat convertOldStratRecord(String superGroup, String lithoGroup, String formation, String member, String bed, LithoStrat stratRoot) {
        String[] levelNames = new String[]{superGroup, lithoGroup, formation, member, bed};
        int levelsToBuild = 0;
        int i = levelNames.length;
        while (i > 0) {
            if (StringUtils.isNotEmpty((String)levelNames[i - 1])) {
                levelsToBuild = i;
                break;
            }
            --i;
        }
        i = 0;
        while (i < levelsToBuild) {
            if (StringUtils.isEmpty((String)levelNames[i])) {
                levelNames[i] = "(Empty)";
            }
            ++i;
        }
        LithoStrat prevLevelStrat = stratRoot;
        int i2 = 0;
        while (i2 < levelsToBuild) {
            LithoStrat newLevelStrat;
            prevLevelStrat = newLevelStrat = this.buildLithoStratLevel(levelNames[i2], prevLevelStrat);
            ++i2;
        }
        return prevLevelStrat;
    }

    protected LithoStrat buildLithoStratLevel(String nameArg, LithoStrat parentArg) {
        String name = nameArg;
        if (name == null) {
            name = "N/A";
        }
        Set<LithoStrat> children = parentArg.getChildren();
        for (LithoStrat child : children) {
            if (!name.equalsIgnoreCase(child.getName())) continue;
            return child;
        }
        LithoStrat newStrat = new LithoStrat();
        newStrat.initialize();
        newStrat.setName(name);
        newStrat.setParent(parentArg);
        parentArg.addChild(newStrat);
        newStrat.setDefinition(parentArg.getDefinition());
        int newGeoRank = parentArg.getRankId() + 100;
        LithoStratTreeDefItem defItem = parentArg.getDefinition().getDefItemByRank(newGeoRank);
        newStrat.setDefinitionItem(defItem);
        newStrat.setRankId(newGeoRank);
        this.persist((Object)newStrat);
        return newStrat;
    }

    protected Geography convertGeographyRecord(String continent, String country, String state, String county, Geography geoRoot) {
        String[] levelNames = new String[]{continent, country, state, county};
        int levelsToBuild = 0;
        int i = levelNames.length;
        while (i > 0) {
            if (StringUtils.isNotEmpty((String)levelNames[i - 1])) {
                levelsToBuild = i;
                break;
            }
            --i;
        }
        i = 0;
        while (i < levelsToBuild) {
            if (StringUtils.isEmpty((String)levelNames[i])) {
                levelNames[i] = "(Empty)";
            }
            ++i;
        }
        Geography prevLevelGeo = geoRoot;
        int i2 = 0;
        while (i2 < levelsToBuild) {
            Geography newLevelGeo;
            prevLevelGeo = newLevelGeo = this.buildGeographyLevel(levelNames[i2], prevLevelGeo);
            ++i2;
        }
        return prevLevelGeo;
    }

    protected Geography buildGeographyLevel(String nameArg, Geography parentArg) {
        String name = nameArg;
        if (name == null) {
            name = "N/A";
        }
        Set<Geography> children = parentArg.getChildren();
        for (Geography child : children) {
            if (!name.equalsIgnoreCase(child.getName())) continue;
            return child;
        }
        Geography newGeo = new Geography();
        newGeo.initialize();
        newGeo.setName(name);
        newGeo.setParent(parentArg);
        parentArg.addChild(newGeo);
        newGeo.setDefinition(parentArg.getDefinition());
        int newGeoRank = parentArg.getRankId() + 100;
        GeographyTreeDefItem defItem = parentArg.getDefinition().getDefItemByRank(newGeoRank);
        newGeo.setDefinitionItem(defItem);
        newGeo.setRankId(newGeoRank);
        this.persist((Object)newGeo);
        return newGeo;
    }

    public List<Object> createGenericCollection(DisciplineType disciplineType, Institution institution, SpecifyUser user, CollectionChoice choice, String method) {
        LithoStrat earthLithoStrat;
        this.frame.setProcess(0, 16);
        this.frame.setDesc("Creating " + disciplineType.getTitle() + "...");
        this.createStep = 0;
        this.startTx();
        Division division = DataBuilder.createDivision(institution, disciplineType.getName(), disciplineType.getTitle(), disciplineType.getAbbrev(), disciplineType.getTitle());
        TaxonTreeDef taxonTreeDef = DataBuilder.createTaxonTreeDef("Taxon");
        GeographyTreeDef geoTreeDef = DataBuilder.createGeographyTreeDef("Geography");
        GeologicTimePeriodTreeDef gtpTreeDef = DataBuilder.createGeologicTimePeriodTreeDef("Chronos Stratigraphy");
        LithoStratTreeDef lithoStratTreeDef = DataBuilder.createLithoStratTreeDef("LithoStrat");
        boolean buildStorageTree = false;
        if (this.stgTreeDef == null) {
            this.stgTreeDef = DataBuilder.createStorageTreeDef("Storage");
            institution.setStorageTreeDef(this.stgTreeDef);
            buildStorageTree = true;
        }
        Discipline discipline = DataBuilder.createDiscipline(division, disciplineType.getName(), disciplineType.getTitle(), this.dataType, taxonTreeDef, geoTreeDef, gtpTreeDef, lithoStratTreeDef);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        this.persist((Object)institution);
        this.persist((Object)division);
        this.persist((Object)discipline);
        AppContextMgr.getInstance().setClassObject(Division.class, division);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        this.frame.setDesc("Loading Schema...");
        this.loadSchemaLocalization(discipline, SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance(), choice.getCatalogNumberingFmtName(), choice.getAccessionNumberingFmtName());
        String title = this.initPrefs.getProperty("useragent.title", "mr");
        String firstName = this.initPrefs.getProperty("useragent.firstname", "Test");
        String lastName = this.initPrefs.getProperty("useragent.lastname", "User");
        String midInit = this.initPrefs.getProperty("useragent.midinit", "A");
        String abbrev = this.initPrefs.getProperty("useragent.abbrev", "tu");
        String email = this.initPrefs.getProperty("useragent.email", "testuser@ku.edu");
        String userType = this.initPrefs.getProperty("useragent.usertype", SpecifyUserTypes.UserType.Manager.toString());
        System.out.println("----- User Agent -----");
        System.out.println("Title:     " + title);
        System.out.println("FirstName: " + firstName);
        System.out.println("LastName:  " + lastName);
        System.out.println("MidInit:   " + midInit);
        System.out.println("Abbrev:    " + abbrev);
        System.out.println("Email:     " + email);
        System.out.println("UserType:  " + userType);
        Agent userAgent = DataBuilder.createAgent(title, firstName, midInit, lastName, abbrev, email);
        discipline.addReference(userAgent, "agents");
        user.addReference(userAgent, "agents");
        this.persist((Object)discipline);
        this.persist((Object)userAgent);
        this.persist((Object)user);
        this.frame.setProcess(++this.createStep);
        Pair<AutoNumberingScheme, AutoNumberingScheme> pairANS = this.createAutoNumberingSchemes(choice);
        AutoNumberingScheme cns = (AutoNumberingScheme)pairANS.first;
        AutoNumberingScheme accessionNS = (AutoNumberingScheme)pairANS.second;
        this.persist((Object)cns);
        this.persist((Object)accessionNS);
        this.commitTx();
        this.startTx();
        log.info((Object)"Creating a Collection");
        this.frame.setDesc("Creating a Collection");
        Collection collection = DataBuilder.createCollection("KU", disciplineType.getTitle(), choice.getCatalogNumberingFmtName(), cns, discipline, disciplineType.isEmbeddedCollecingEvent());
        this.persist((Object)collection);
        Map<String, SpPrincipal> groupMap = DataBuilder.createStandardGroups(this.session, collection);
        user.addUserToSpPrincipalGroup(groupMap.get(SpecifyUserTypes.UserType.Manager.toString()));
        String dspAbbrev = disciplineType.getAbbrev();
        DataBuilder.createAndAddTesterToCollection(this.session, String.valueOf(dspAbbrev) + "Tester", String.valueOf(dspAbbrev) + "tester@brc.ku.edu", String.valueOf(dspAbbrev) + "Tester", "", dspAbbrev, "", "Tester", "", discipline, division, collection, groupMap, "Guest");
        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
        division.addReference(accessionNS, "numberingSchemes");
        this.persist((Object)division);
        this.commitTx();
        BuildSampleDatabase.doShowHideTablesAndFields(null, discipline);
        BuildSampleDatabase.doShowHideTablesAndFields(disciplineType.getName(), discipline);
        this.frame.setProcess(++this.createStep);
        this.startTx();
        this.createTaxonTreeDefFromXML(taxonTreeDef, disciplineType);
        this.persist((Object)taxonTreeDef);
        AppContextMgr.getInstance().setClassObject(SpecifyUser.class, user);
        user.addReference(userAgent, "agents");
        this.persist((Object)user);
        Journal journal = BuildSampleDatabase.createJournalsAndReferenceWork();
        this.frame.setProcess(++this.createStep);
        this.frame.setDesc("Building Trees...");
        Vector<Object> taxa = new Vector<Object>();
        this.createTaxonTreeFromXML(taxa, taxonTreeDef, disciplineType);
        boolean isPaleo = disciplineType.getDisciplineType() == DisciplineType.STD_DISCIPLINES.paleobotany || disciplineType.getDisciplineType() == DisciplineType.STD_DISCIPLINES.vertpaleo || disciplineType.getDisciplineType() == DisciplineType.STD_DISCIPLINES.invertpaleo;
        List<Object> geos = BuildSampleDatabase.createSimpleGeography(geoTreeDef, true);
        List<Object> gtps = BuildSampleDatabase.createSimpleGeologicTimePeriod(gtpTreeDef, true);
        List<Object> lithoStrats = isPaleo ? null : BuildSampleDatabase.createSimpleLithoStrat(lithoStratTreeDef, true);
        this.persist((Object)journal);
        this.persist(taxa);
        this.persist(geos);
        this.persist(buildStorageTree ? BuildSampleDatabase.createSimpleStorage(this.stgTreeDef) : null);
        this.persist(gtps);
        if (lithoStrats != null) {
            this.persist(lithoStrats);
        }
        this.commitTx();
        if (isPaleo && (earthLithoStrat = this.convertLithoStratFromCSV(lithoStratTreeDef)) == null) {
            this.startTx();
            lithoStrats = BuildSampleDatabase.createSimpleLithoStrat(lithoStratTreeDef, true);
            this.persist(lithoStrats);
            this.commitTx();
        }
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating picklists");
        this.frame.setDesc("Creating Common PickLists...");
        BuildSampleDatabase.createPickLists(this.session, null);
        this.frame.setDesc("Creating PickLists...");
        BuildSampleDatabase.createPickLists(this.session, discipline);
        this.startTx();
        Vector<Object> dataObjects = new Vector<Object>();
        this.frame.setDesc("Creating Queries...");
        this.standardQueries(dataObjects, userAgent);
        this.persist(dataObjects);
        dataObjects.clear();
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setDesc("Intermediate save....");
        this.commitTx();
        this.frame.setDesc("Creating Localities....");
        this.startTx();
        this.frame.setProcess(++this.createStep);
        String POINT = "Point";
        String LINE = "Line";
        String RECT = "Rectangle";
        log.info((Object)"Creating localities");
        this.frame.setDesc("Creating localities...");
        Locality forestStream = DataBuilder.createLocality("Gravel Pit", (Geography)geos.get(12));
        forestStream.setLatLongType(POINT);
        forestStream.setOriginalLatLongUnit(0);
        forestStream.setLat1text("38.925467 deg N");
        forestStream.setLatitude1(new BigDecimal(38.925467));
        forestStream.setLong1text("94.984867 deg W");
        forestStream.setLongitude1(new BigDecimal(-94.984867));
        Locality lake = DataBuilder.createLocality("Deep, dark lake pond", (Geography)geos.get(17));
        lake.setLatLongType(RECT);
        lake.setOriginalLatLongUnit(1);
        lake.setLat1text("41.548842 deg N");
        lake.setLatitude1(new BigDecimal(41.548842));
        lake.setLong1text("93.732129 deg W");
        lake.setLongitude1(new BigDecimal(-93.732129));
        lake.setLat2text("41.642195 deg N");
        lake.setLatitude2(new BigDecimal(41.642195));
        lake.setLong2text("100.403180 deg W");
        lake.setLongitude2(new BigDecimal(-100.40318));
        Locality farmpond = DataBuilder.createLocality("Shoal Creek at Schermerhorn Park, S of Galena at Rt. 26", (Geography)geos.get(11));
        farmpond.setLatLongType(LINE);
        farmpond.setOriginalLatLongUnit(2);
        farmpond.setLat1text("41.642187 deg N");
        farmpond.setLatitude1(new BigDecimal(41.642187));
        farmpond.setLong1text("100.403163 deg W");
        farmpond.setLongitude1(new BigDecimal(-100.403163));
        farmpond.setLat2text("49.647435 deg N");
        farmpond.setLatitude2(new BigDecimal(49.647435));
        farmpond.setLong2text("-55.112163 deg W");
        farmpond.setLongitude2(new BigDecimal(-55.112163));
        this.persist((Object)forestStream);
        this.persist((Object)lake);
        this.persist((Object)farmpond);
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating agents and addresses");
        this.frame.setDesc("Creating agents and addresses");
        Vector<Agent> agents = new Vector<Agent>();
        lastName = userAgent.getLastName();
        Agent steveBoyd = DataBuilder.createAgent("mr", "Steve", "D", "Boyd", "jb", "jb@net.edu");
        if (!lastName.equals("Cooper")) {
            agents.add(DataBuilder.createAgent("mr", "Peter", "D", "Cooper", "ds", "ds@whitehouse.gov"));
        }
        if (!lastName.equals("Peck")) {
            agents.add(DataBuilder.createAgent("mr", "David", "H", "Peck", "rb", "beach@net.edu"));
        }
        if (!lastName.equals("Appleton")) {
            agents.add(DataBuilder.createAgent("mrs", "Sally", "H", "Appleton", "jm", "jm@net.edu"));
        }
        if (!lastName.equals("Brown")) {
            agents.add(DataBuilder.createAgent("mr", "Taylor", "C", "Brown", "kcs", "taylor.brown@ku.edu"));
        }
        if (!lastName.equals("Boyd")) {
            agents.add(steveBoyd);
        }
        if (!lastName.equals("Thomas")) {
            agents.add(DataBuilder.createAgent("Mr", "James", "X", "Thomas", "dxt", ""));
        }
        if (!lastName.equals("Peterson")) {
            agents.add(DataBuilder.createAgent("mr", "Pete", "A", "Peterson", "jb", ""));
        }
        if (!lastName.equals("Guttenburg")) {
            agents.add(DataBuilder.createAgent("mr", "Mitch", "A", "Guttenburg", "jb", ""));
        }
        if (!lastName.equals("Ford")) {
            agents.add(DataBuilder.createAgent("mr", "Daniel", "A", "Ford", "mas", "mas@ku.edu"));
        }
        agents.add(userAgent);
        Agent ku = new Agent();
        ku.initialize();
        ku.setAbbreviation("KU");
        ku.setAgentType((byte)0);
        ku.setLastName("University of Kansas");
        ku.setEmail("webadmin@ku.edu");
        ku.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        ku.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(ku);
        ((Agent)agents.get(0)).setOrganization(ku);
        ((Agent)agents.get(1)).setOrganization(ku);
        ((Agent)agents.get(2)).setOrganization(ku);
        ((Agent)agents.get(3)).setOrganization(ku);
        ((Agent)agents.get(8)).setOrganization(ku);
        Agent otherAgent = new Agent();
        otherAgent.initialize();
        otherAgent.setAbbreviation("O");
        otherAgent.setAgentType((byte)2);
        otherAgent.setLastName("The Other Guys");
        otherAgent.setEmail("other@other.com");
        otherAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        otherAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(otherAgent);
        this.commitTx();
        this.frame.setDesc("Group Persons...");
        ArrayList<GroupPerson> gpList = new ArrayList<GroupPerson>();
        this.startTx();
        Agent gm1 = DataBuilder.createAgent("mr", "John", "A", "Lyon", "jal", "jal@group.edu");
        Agent gm2 = DataBuilder.createAgent("mr", "Dave", "D", "Jones", "ddj", "ddj@group.edu");
        this.persist((Object)gm1);
        this.persist((Object)gm2);
        this.commitTx();
        Agent groupAgent = new Agent();
        groupAgent.initialize();
        groupAgent.setAbbreviation("GRP");
        groupAgent.setAgentType((byte)3);
        groupAgent.setLastName("The Group");
        groupAgent.setEmail("group@group.com");
        groupAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
        groupAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
        agents.add(groupAgent);
        gpList.add(DataBuilder.createGroupPerson(groupAgent, gm1, 0, division));
        gpList.add(DataBuilder.createGroupPerson(groupAgent, gm2, 1, division));
        this.startTx();
        Vector<Address> addrs = new Vector<Address>();
        addrs.add(DataBuilder.createAddress((Agent)agents.get(1), "1600 Pennsylvania Avenue NW", null, "Washington", "DC", "USA", "20500", 0));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(1), "??? Mississippi", null, "Lawrence", "KS", "USA", "66045", 1));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(2), "1 Main St", "", "Lenexa", "KS", "USA", "66071"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(3), "13355 Inverness", "Bldg #3", "Lawrence", "KS", "USA", "66047"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(4), "Natural History Museum", "Cromwell Rd", "London", null, "UK", "SW7 5BD"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(6), "1212 Apple Street", null, "Chicago", "IL", "USA", "01010"));
        addrs.add(DataBuilder.createAddress((Agent)agents.get(8), "11911 Oak Ln", null, "Orion", "KS", "USA", "66061"));
        addrs.add(DataBuilder.createAddress(ku, null, null, "Lawrence", "KS", "USA", "66045"));
        addrs.add(DataBuilder.createAddress(userAgent, "1214 East Street", null, "Grinnell", "IA", "USA", "56060"));
        userAgent.setDivision(division);
        this.persist(agents);
        this.persist(gpList);
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        this.frame.setDesc("Creating collecting events, collectors and a collecting trip...");
        log.info((Object)"Creating collecting events, collectors and a collecting trip");
        Collector collectorMitch = DataBuilder.createCollector((Agent)agents.get(7), 2);
        Collector collectorJim = DataBuilder.createCollector((Agent)agents.get(2), 1);
        this.calendar.set(1994, 4, 21, 11, 56, 0);
        String stationFieldNumber = String.format(this.STATION_FIELD_FORMAT, this.stationFieldNumberCounter++);
        CollectingEvent ce1 = DataBuilder.createCollectingEvent(forestStream, this.calendar, stationFieldNumber, new Collector[]{collectorMitch, collectorJim});
        ce1.setStartDateVerbatim("21 Apr 1994, 11:56 AM");
        this.calendar.set(1994, 4, 21, 13, 3, 0);
        ce1.setEndDate(this.calendar);
        ce1.setEndDateVerbatim("21 Apr 1994, 1:03 PM");
        ce1.setMethod("Picked");
        AttributeDef cevAttrDef = DataBuilder.createAttributeDef(AttributeIFace.FieldType.StringType, "ParkName", discipline, null);
        this.persist((Object)cevAttrDef);
        this.commitTx();
        this.startTx();
        CollectingEventAttr cevAttr = DataBuilder.createCollectingEventAttr(ce1, cevAttrDef, "Sleepy Hollow", null);
        Collector collectorMeg = DataBuilder.createCollector((Agent)agents.get(2), 1);
        Collector collectorRod = DataBuilder.createCollector((Agent)agents.get(3), 2);
        this.calendar.set(1994, 4, 22, 6, 12, 0);
        stationFieldNumber = String.format(this.STATION_FIELD_FORMAT, this.stationFieldNumberCounter++);
        CollectingEvent ce2 = DataBuilder.createCollectingEvent(farmpond, this.calendar, stationFieldNumber, new Collector[]{collectorMeg, collectorRod});
        ce2.setStartDateVerbatim("22 Apr 1994, 6:12 AM");
        this.calendar.set(1994, 4, 22, 7, 31, 0);
        ce2.setEndDate(this.calendar);
        ce2.setEndDateVerbatim("22 Apr 1994, 7:31 AM");
        ce2.setMethod("Picked");
        dataObjects.add(ce1);
        dataObjects.add(cevAttr);
        dataObjects.add(ce2);
        dataObjects.add(collectorMitch);
        dataObjects.add(collectorJim);
        dataObjects.add(collectorMeg);
        dataObjects.add(collectorRod);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        log.info((Object)"Creating a permit");
        this.frame.setDesc("Creating a permit...");
        Calendar issuedDate = Calendar.getInstance();
        issuedDate.set(1993, 1, 12);
        Calendar startDate = Calendar.getInstance();
        startDate.set(1993, 2, 1);
        Calendar endDate = Calendar.getInstance();
        endDate.set(1993, 5, 30);
        Permit permit = DataBuilder.createPermit("1980-" + disciplineType.getAbbrev().substring(0, 2) + "-0001", "US Dept Wildlife", issuedDate, startDate, endDate, null);
        permit.setIssuedTo(ku);
        permit.setIssuedBy((Agent)agents.get(4));
        dataObjects.add(permit);
        log.info((Object)"Creating a repository agreement");
        RepositoryAgreement repoAg = new RepositoryAgreement();
        repoAg.initialize();
        repoAg.setDivision(division);
        repoAg.setRepositoryAgreementNumber("KU-" + disciplineType.getAbbrev() + "-01");
        repoAg.setOriginator(ku);
        Calendar received = Calendar.getInstance();
        received.set(1992, 2, 10);
        repoAg.setDateReceived(received);
        Calendar repoEndDate = Calendar.getInstance();
        received.set(2010, 2, 9);
        repoAg.setEndDate(repoEndDate);
        dataObjects.add(repoAg);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating collection objects");
        this.frame.setDesc("Creating collection objects...");
        Vector<CollectionObject> collObjs = new Vector<CollectionObject>();
        Collection col = collection;
        Calendar[] catDates = new Calendar[8];
        int i = 0;
        while (i < catDates.length) {
            catDates[i] = Calendar.getInstance();
            int year = 1980 + (int)(this.rand.nextDouble() * 20.0);
            catDates[i].set(year, 1, 12 + i);
            ++i;
        }
        String prefix = "000000";
        int catNo = 100;
        CollectingEvent[] colEves = new CollectingEvent[8];
        int i2 = 0;
        while (i2 < colEves.length) {
            colEves[i2] = this.createFakeCollectingEvent(agents, farmpond, method);
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + Integer.toString(catNo), "RSC" + Integer.toString(catNo), (Agent)agents.get(i2), col, 1, colEves[i2], catDates[i2], "BuildSampleDatabase"));
            ++catNo;
            ++i2;
        }
        dataObjects.addAll(collObjs);
        CollectingEvent[] collectingEventArray = colEves;
        int n = colEves.length;
        int n2 = 0;
        while (n2 < n) {
            CollectingEvent ce = collectingEventArray[n2];
            this.persist((Object)ce);
            ++n2;
        }
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating determinations");
        this.frame.setDesc("Creating determinations...");
        Vector<Determination> determs = new Vector<Determination>();
        Calendar recent = Calendar.getInstance();
        recent.set(2005, 10, 27, 13, 44, 0);
        Calendar longAgo = Calendar.getInstance();
        longAgo.set(1976, 1, 29, 8, 12, 0);
        Calendar whileBack = Calendar.getInstance();
        whileBack.set(2000, 7, 4, 9, 33, 12);
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(0), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(1), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(2), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(3), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(5), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(6), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(7), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), true, recent));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(0), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, longAgo));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(1), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(2), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(3), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, whileBack));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, longAgo));
        determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), this.getRandomAgent(agents), this.getRandomTaxon(220, taxa), false, longAgo));
        ((Determination)determs.get(13)).setRemarks("This determination is totally wrong.  What a foolish determination.");
        this.persist(determs);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating preparations");
        this.frame.setDesc("Creating preparations...");
        Vector<PrepType> prepTypesForSaving = this.loadPrepTypes(discipline.getType());
        PrepType pressed = prepTypesForSaving.get(0);
        Vector<Preparation> preps = new Vector<Preparation>();
        Calendar prepDate = Calendar.getInstance();
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(0), (CollectionObject)collObjs.get(0), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(0), (CollectionObject)collObjs.get(1), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(3), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(2), (CollectionObject)collObjs.get(4), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(2), (CollectionObject)collObjs.get(5), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(3), (CollectionObject)collObjs.get(6), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(3), (CollectionObject)collObjs.get(7), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(0), (Storage)locs.get(11), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(1), (Storage)locs.get(11), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(10), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(2), (CollectionObject)collObjs.get(3), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(3), (CollectionObject)collObjs.get(4), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(0), (CollectionObject)collObjs.get(5), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(6), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(7), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(0), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(1), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(3), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
        preps.add(DataBuilder.createPreparation(pressed, (Agent)agents.get(1), (CollectionObject)collObjs.get(4), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        dataObjects.addAll(prepTypesForSaving);
        dataObjects.addAll(preps);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating accessions and accession agents");
        this.frame.setDesc("Creating accessions...");
        this.calendar.set(2006, 10, 27, 23, 59, 59);
        Accession acc1 = DataBuilder.createAccession(division, "gift", "complete", "2000-" + disciplineType.getAbbrev().substring(0, 2) + "-001", DateFormat.getInstance().format(this.calendar.getTime()), this.calendar, this.calendar);
        acc1.setText1(disciplineType.getTitle());
        acc1.setRepositoryAgreement(repoAg);
        Agent donor = (Agent)agents.get(4);
        Agent receiver = (Agent)agents.get(1);
        Agent reviewer = (Agent)agents.get(2);
        Vector<AccessionAgent> accAgents = new Vector<AccessionAgent>();
        accAgents.add(DataBuilder.createAccessionAgent("donor", donor, acc1, null));
        accAgents.add(DataBuilder.createAccessionAgent("receiver", receiver, acc1, null));
        accAgents.add(DataBuilder.createAccessionAgent("reviewer", reviewer, acc1, null));
        Accession acc2 = DataBuilder.createAccession(division, "field_work", "inprocess", "2004-" + disciplineType.getAbbrev().substring(0, 2) + "-002", DateFormat.getInstance().format(this.calendar.getTime()), this.calendar, this.calendar);
        Agent donor2 = (Agent)agents.get(5);
        Agent receiver2 = (Agent)agents.get(3);
        Agent reviewer2 = (Agent)agents.get(1);
        accAgents.add(DataBuilder.createAccessionAgent("donor", donor2, acc2, null));
        accAgents.add(DataBuilder.createAccessionAgent("receiver", receiver2, acc2, null));
        accAgents.add(DataBuilder.createAccessionAgent("reviewer", reviewer2, acc2, null));
        dataObjects.add(acc1);
        dataObjects.add(acc2);
        dataObjects.addAll(accAgents);
        this.persist(dataObjects);
        dataObjects.clear();
        this.commitTx();
        this.startTx();
        this.frame.setProcess(++this.createStep);
        this.createLoanExamples(preps, agents, dataObjects);
        this.frame.setProcess(++this.createStep);
        this.persist(dataObjects);
        dataObjects.clear();
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        this.commitTx();
        this.frame.setProcess(++this.createStep);
        DataBuilder.buildDarwinCoreSchema(discipline);
        log.info((Object)("Done creating " + disciplineType.getTitle() + " disciplineType database: " + disciplineType.getTitle()));
        return dataObjects;
    }

    public void createStorageTreeDefFromXML(Vector<Object> storageList, File domFile, StorageTreeDef treeDef, boolean doAddTreeNodes) throws Exception {
        StorageTreeDefItem parent = null;
        Element root = XMLHelper.readFileToDOM4J(domFile);
        for (Element node : root.selectNodes("/tree/treedef/level")) {
            String name = XMLHelper.getAttr(node, NAME, null);
            int rankId = XMLHelper.getAttr(node, RANK, 0);
            boolean infullname = XMLHelper.getAttr(node, "infullname", false);
            boolean isEnforced = XMLHelper.getAttr(node, "enforced", false);
            StorageTreeDefItem tdi = new StorageTreeDefItem();
            tdi.initialize();
            tdi.setName(name);
            tdi.setRankId(rankId);
            tdi.setIsEnforced(isEnforced);
            tdi.setIsInFullName(infullname);
            treeDef.getTreeDefItems().add(tdi);
            tdi.setParent(parent);
            if (parent != null) {
                parent.getChildren().add(tdi);
            }
            tdi.setTreeDef(treeDef);
            this.persist((Object)tdi);
            parent = tdi;
        }
        this.createStorageTreeFromXML(storageList, root, treeDef, doAddTreeNodes);
    }

    protected void createStorageTreeFromXML(Vector<Object> storageList, Element root, StorageTreeDef treeDef, boolean doAddTreeNodes) {
        StorageTreeDefItem rootTTD = null;
        Hashtable<Integer, StorageTreeDefItem> treeDefItemHash = new Hashtable<Integer, StorageTreeDefItem>();
        for (StorageTreeDefItem ttdi : treeDef.getTreeDefItems()) {
            treeDefItemHash.put(ttdi.getRankId(), ttdi);
            if (ttdi.getRankId() != 0) continue;
            rootTTD = ttdi;
        }
        Storage storage = new Storage();
        storage.initialize();
        storage.setRankId(0);
        storage.setName(UIRegistry.getResourceString("Root"));
        storage.setFullName(storage.getName());
        storage.setNodeNumber(1);
        storage.setHighestChildNodeNumber(1);
        storage.setDefinition(treeDef);
        storage.setDefinitionItem(rootTTD);
        rootTTD.getTreeEntries().add(storage);
        storage.setParent((Storage)null);
        this.persist((Object)storage);
        storageList.add(storage);
        if (doAddTreeNodes) {
            for (Element node : root.selectNodes("/tree/nodes/node")) {
                this.traverseTree(storageList, treeDefItemHash, treeDef, node, storage);
            }
        }
        TreeHelper.fixFullnameForNodeAndDescendants(storage);
        storage.setNodeNumber(1);
        BuildSampleDatabase.fixNodeNumbersFromRoot(storage);
    }

    protected void traverseTree(Vector<Object> storageList, Hashtable<Integer, StorageTreeDefItem> treeDefItemHash, StorageTreeDef treeDef, Element root, Storage parent) {
        String name = XMLHelper.getAttr(root, NAME, null);
        int rankId = XMLHelper.getAttr(root, RANK, 0);
        Storage storage = new Storage();
        storage.initialize();
        storage.setRankId(rankId);
        storage.setName(name);
        storage.setFullName(name);
        storage.setDefinition(treeDef);
        storage.setDefinitionItem(treeDefItemHash.get(rankId));
        storage.setParent(parent);
        parent.getChildren().add(storage);
        treeDefItemHash.get(rankId).getTreeEntries().add(storage);
        this.persist((Object)storage);
        storageList.add(storage);
        for (Element node : root.selectNodes("node")) {
            this.traverseTree(storageList, treeDefItemHash, treeDef, node, storage);
        }
    }

    protected void createTaxonTreeDefFromXML(TaxonTreeDef treeDef, DisciplineType disciplineType) {
        TaxonTreeDefItem parent = null;
        Element root = this.getDOMForDiscpline(disciplineType, "taxon_init.xml");
        if (root != null) {
            for (Element node : root.selectNodes("/tree/treedef/level")) {
                String name = XMLHelper.getAttr(node, NAME, null);
                int rankId = XMLHelper.getAttr(node, RANK, 0);
                boolean infullname = XMLHelper.getAttr(node, "infullname", false);
                boolean isEnforced = XMLHelper.getAttr(node, "enforced", false);
                TaxonTreeDefItem tdi = new TaxonTreeDefItem();
                tdi.initialize();
                tdi.setName(name);
                tdi.setRankId(rankId);
                tdi.setIsEnforced(isEnforced);
                tdi.setIsInFullName(infullname);
                treeDef.getTreeDefItems().add(tdi);
                tdi.setParent(parent);
                if (parent != null) {
                    parent.getChildren().add(tdi);
                }
                tdi.setTreeDef(treeDef);
                this.persist((Object)tdi);
                parent = tdi;
            }
        }
    }

    protected void createTaxonTreeFromXML(Vector<Object> taxonList, TaxonTreeDef treeDef, DisciplineType disciplineType) {
        TaxonTreeDefItem rootTTD = null;
        Hashtable<Integer, TaxonTreeDefItem> treeDefItemHash = new Hashtable<Integer, TaxonTreeDefItem>();
        for (TaxonTreeDefItem ttdi : treeDef.getTreeDefItems()) {
            treeDefItemHash.put(ttdi.getRankId(), ttdi);
            if (ttdi.getRankId() != 0) continue;
            rootTTD = ttdi;
        }
        Taxon taxon = new Taxon();
        taxon.initialize();
        taxon.setRankId(0);
        taxon.setName(UIRegistry.getResourceString("Root"));
        taxon.setFullName(taxon.getName());
        taxon.setNodeNumber(1);
        taxon.setHighestChildNodeNumber(1);
        taxon.setDefinition(treeDef);
        taxon.setDefinitionItem(rootTTD);
        rootTTD.getTreeEntries().add(taxon);
        taxon.setParent((Taxon)null);
        this.persist((Object)taxon);
        taxonList.add(taxon);
        Element root = this.getDOMForDiscpline(disciplineType, "taxon_init.xml");
        for (Element node : root.selectNodes("/tree/nodes/node")) {
            this.traverseTree(taxonList, treeDefItemHash, treeDef, node, taxon);
        }
        TreeHelper.fixFullnameForNodeAndDescendants(taxon);
        taxon.setNodeNumber(1);
        BuildSampleDatabase.fixNodeNumbersFromRoot(taxon);
    }

    protected void traverseTree(Vector<Object> taxonList, Hashtable<Integer, TaxonTreeDefItem> treeDefItemHash, TaxonTreeDef treeDef, Element root, Taxon parent) {
        String name = XMLHelper.getAttr(root, NAME, null);
        String common = XMLHelper.getAttr(root, "common", null);
        int rankId = XMLHelper.getAttr(root, RANK, 0);
        Taxon taxon = new Taxon();
        taxon.initialize();
        taxon.setRankId(rankId);
        taxon.setName(name);
        taxon.setFullName(name);
        taxon.setCommonName(common);
        taxon.setDefinition(treeDef);
        taxon.setDefinitionItem(treeDefItemHash.get(rankId));
        taxon.setParent(parent);
        parent.getChildren().add(taxon);
        treeDefItemHash.get(rankId).getTreeEntries().add(taxon);
        this.persist((Object)taxon);
        taxonList.add(taxon);
        for (Element node : root.selectNodes("node")) {
            this.traverseTree(taxonList, treeDefItemHash, treeDef, node, taxon);
        }
    }

    protected Element getDOMForDiscpline(DisciplineType dType, String fileName) {
        return XMLHelper.readDOMFromConfigDir(String.valueOf(dType.getFolder()) + File.separator + fileName);
    }

    public void createFishCollection(DisciplineType disciplineType, Institution institution, SpecifyUser user, CollectionChoice collChoice) {
        this.frame.setDesc("Creating Fish Collection Overhead...");
        this.startTx();
        Division division = DataBuilder.createDivision(institution, disciplineType.getName(), "Ichthyology", "IT", "Ichthyology");
        this.persist((Object)division);
        TaxonTreeDef taxonTreeDef = DataBuilder.createTaxonTreeDef("Taxon");
        GeographyTreeDef geoTreeDef = DataBuilder.createGeographyTreeDef("Geography");
        GeologicTimePeriodTreeDef gtpTreeDef = DataBuilder.createGeologicTimePeriodTreeDef("Chronos Stratigraphy");
        LithoStratTreeDef lithoStratTreeDef = DataBuilder.createLithoStratTreeDef("LithoStrat");
        lithoStratTreeDef.setRemarks("A simple super, group, formation, member, bed Litho Stratigraphy tree");
        boolean buildStorageTree = false;
        if (this.stgTreeDef == null) {
            this.stgTreeDef = DataBuilder.createStorageTreeDef("Storage");
            institution.setStorageTreeDef(this.stgTreeDef);
            buildStorageTree = true;
        }
        Discipline discipline = DataBuilder.createDiscipline(division, disciplineType.getName(), disciplineType.getTitle(), this.dataType, taxonTreeDef, geoTreeDef, gtpTreeDef, lithoStratTreeDef);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        this.persist((Object)institution);
        this.persist((Object)discipline);
        this.commitTx();
        AppContextMgr.getInstance().setClassObject(Division.class, division);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AppContextMgr.getInstance().setClassObject(Institution.class, institution);
        String title = this.initPrefs.getProperty("useragent.title", "mr");
        String firstName = this.initPrefs.getProperty("useragent.firstname", "Test");
        String lastName = this.initPrefs.getProperty("useragent.lastname", "User");
        String midInit = this.initPrefs.getProperty("useragent.midinit", "A");
        String abbrev = this.initPrefs.getProperty("useragent.abbrev", "tu");
        String email = this.initPrefs.getProperty("useragent.email", "testuser@ku.edu");
        String userType = this.initPrefs.getProperty("useragent.usertype", SpecifyUserTypes.UserType.Manager.toString());
        System.out.println("----- User Agent -----");
        System.out.println("Title:     " + title);
        System.out.println("FirstName: " + firstName);
        System.out.println("LastName:  " + lastName);
        System.out.println("MidInit:   " + midInit);
        System.out.println("Abbrev:    " + abbrev);
        System.out.println("Email:     " + email);
        System.out.println("UserType:  " + userType);
        Agent userAgent = DataBuilder.createAgent(title, firstName, midInit, lastName, abbrev, email);
        userAgent.setDivision(division);
        discipline.addReference(userAgent, "agents");
        user.addReference(userAgent, "agents");
        this.startTx();
        this.persist((Object)discipline);
        this.persist((Object)user);
        this.persist((Object)userAgent);
        this.loadSchemaLocalization(discipline, SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance(), collChoice.getCatalogNumberingFmtName(), collChoice.getAccessionNumberingFmtName());
        this.commitTx();
        BuildSampleDatabase.doShowHideTablesAndFields(null, discipline);
        BuildSampleDatabase.doShowHideTablesAndFields(disciplineType.getName(), discipline);
        this.frame.setDesc("Creating Fish Trees...");
        Journal journal = BuildSampleDatabase.createJournalsAndReferenceWork();
        List<Object> taxa = BuildSampleDatabase.createSimpleFishTaxonTree(taxonTreeDef, this.doShallowTaxonTree);
        List<Object> geos = BuildSampleDatabase.createSimpleGeography(geoTreeDef, true);
        List<Object> gtps = BuildSampleDatabase.createSimpleGeologicTimePeriod(gtpTreeDef, true);
        List<Object> lithoStrats = BuildSampleDatabase.createSimpleLithoStrat(lithoStratTreeDef, true);
        this.startTx();
        this.persist((Object)journal);
        this.persist(taxa);
        this.persist(geos);
        this.persist(buildStorageTree ? BuildSampleDatabase.createSimpleStorage(this.stgTreeDef) : null);
        this.persist(gtps);
        this.persist(lithoStrats);
        this.commitTx();
        this.frame.setOverall(this.steps++);
        Collection voucher = null;
        if (this.isChoosen(DisciplineType.STD_DISCIPLINES.fish, false)) {
            voucher = this.createFishCollection(discipline, user, userAgent, division, journal, taxa, geos, "KUFSH", "Fish", true, false, collChoice);
        }
        this.frame.setOverall(this.steps++);
        Collection tissue = null;
        if (this.isChoosen(DisciplineType.STD_DISCIPLINES.fish, true)) {
            tissue = this.createFishCollection(discipline, user, userAgent, division, journal, taxa, geos, "KUTIS", "Fish Tissue", false, true, collChoice);
        }
        if (voucher != null && tissue != null) {
            this.startTx();
            CollectionRelType colRelType = DataBuilder.createCollectionRelType("Voucher Tissue", voucher, tissue);
            this.persist((Object)colRelType);
            this.commitTx();
        }
        DataBuilder.buildDarwinCoreSchema(discipline);
        this.globalLocalities.clear();
    }

    protected boolean isChoosen(DisciplineType.STD_DISCIPLINES type, boolean isTissue) {
        if (this.selectedChoices != null) {
            for (CollectionChoice cc : this.selectedChoices) {
                if (cc.getType() != type || cc.isTissue() != isTissue) continue;
                return true;
            }
        }
        return false;
    }

    protected CollectionChoice getChoice(DisciplineType.STD_DISCIPLINES type, boolean isTissue) {
        if (this.selectedChoices != null) {
            for (CollectionChoice cc : this.selectedChoices) {
                if (cc.getType() != type || cc.isTissue() != isTissue) continue;
                return cc;
            }
        }
        return null;
    }

    protected Vector<PrepType> loadPrepTypes(String discipline) {
        return this.loadPrepTypes(discipline, null, null);
    }

    protected Vector<PrepType> loadPrepTypes(String discipline, Collection collection, Agent createdByAgent) {
        Vector prepTypes = new Vector();
        XStream xstream = new XStream();
        xstream.alias("preptype", PrepType.class);
        xstream.omitField(PrepType.class, "prepTypeId");
        xstream.omitField(PrepType.class, "collection");
        xstream.omitField(PrepType.class, "preparations");
        xstream.omitField(PrepType.class, "attributeDefs");
        xstream.useAttributeFor(PrepType.class, NAME);
        xstream.useAttributeFor(PrepType.class, "isLoanable");
        xstream.aliasAttribute("isloanable", "isLoanable");
        xstream.omitField(DataModelObjBase.class, "timestampCreated");
        xstream.omitField(DataModelObjBase.class, "timestampModified");
        xstream.omitField(DataModelObjBase.class, "lastEditedBy");
        Collection colltn = collection != null ? collection : AppContextMgr.getInstance().getClassObject(Collection.class);
        Agent agent = createdByAgent != null ? createdByAgent : Agent.getUserAgent();
        DisciplineType dType = DisciplineType.getByName(discipline);
        File file = XMLHelper.getConfigDir(String.valueOf(dType.getFolder()) + File.separator + "preptypes.xml");
        if (file.exists()) {
            try {
                prepTypes = (Vector)xstream.fromXML(FileUtils.readFileToString((File)file));
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            Timestamp nowTm = new Timestamp(System.currentTimeMillis());
            for (PrepType pt : prepTypes) {
                pt.setCreatedByAgent(agent);
                pt.setTimestampCreated(nowTm);
                pt.setCollection(colltn);
                pt.setAttributeDefs(new HashSet<AttributeDef>());
            }
            return prepTypes;
        }
        throw new RuntimeException("preptypes.xml is missing for discipline[" + discipline + "]");
    }

    protected void loadQueries() {
        this.loadQueries(XMLHelper.getConfigDirPath("common" + File.separator + "queries.xml"));
        String discipline = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
        this.loadQueries(XMLHelper.getConfigDirPath(String.valueOf(discipline) + File.separator + "queries.xml"));
    }

    protected void loadQueries(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        Vector<SpQuery> queries = new Vector<SpQuery>();
        try {
            Element root = XMLHelper.readFileToDOM4J(file);
            for (Object obj : root.selectNodes("/queries/query")) {
                Element el = (Element)obj;
                SpQuery query = new SpQuery();
                query.initialize();
                query.fromXML(el);
                query.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
                queries.add(query);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        DataProviderSessionIFace localSession = null;
        try {
            try {
                localSession = DataProviderFactory.getInstance().createSession();
                localSession.beginTransaction();
                for (SpQuery query : queries) {
                    query.setName(query.getName());
                    localSession.saveOrUpdate(query);
                }
                localSession.commit();
            }
            catch (Exception ex) {
                ExceptionTracker.getInstance().capture(BuildSampleDatabase.class, ex);
                ex.printStackTrace();
                localSession.rollback();
                if (localSession != null) {
                    localSession.close();
                }
            }
        }
        finally {
            if (localSession != null) {
                localSession.close();
            }
        }
    }

    private Pair<AutoNumberingScheme, AutoNumberingScheme> createAutoNumberingSchemes(CollectionChoice cc) {
        String accGroup;
        Pair<AutoNumberingScheme, AutoNumberingScheme> pair = new Pair<AutoNumberingScheme, AutoNumberingScheme>();
        String catGroup = cc.getCatNumGroup();
        if (StringUtils.isNotEmpty((String)catGroup)) {
            AutoNumberingScheme catANS = this.getAutoNumberingScheme(CollectionObject.class, catGroup);
            if (catANS == null) {
                catANS = DataBuilder.createAutoNumberingScheme(catGroup, "", cc.getCatalogNumberingFmtName(), false, CollectionObject.getClassTableId());
                this.addAutoNumberingScheme(CollectionObject.class, catANS);
            }
            pair.first = catANS;
        }
        if (StringUtils.isNotEmpty((String)(accGroup = cc.getAccNumGroup()))) {
            AutoNumberingScheme accANS = this.getAutoNumberingScheme(Accession.class, accGroup);
            if (accANS == null) {
                accANS = DataBuilder.createAutoNumberingScheme(accGroup, "", cc.getAccessionNumberingFmtName(), false, Accession.getClassTableId());
                this.addAutoNumberingScheme(Accession.class, accANS);
            }
            pair.second = accANS;
        }
        return pair;
    }

    public Collection createFishCollection(Discipline discipline, SpecifyUser user, Agent userAgent, Division division, Journal journal, List<Object> taxa, List<Object> geos, String colPrefix, String colName, boolean isVoucherCol, boolean doTissues, CollectionChoice choice) {
        Locality farmpond;
        Locality lake;
        Locality forestStream;
        this.createStep = 0;
        this.frame.setProcess(0, 15);
        this.frame.setDesc("Creating Collection " + colName);
        this.startTx();
        Pair<AutoNumberingScheme, AutoNumberingScheme> pairANS = this.createAutoNumberingSchemes(choice);
        AutoNumberingScheme cns = (AutoNumberingScheme)pairANS.first;
        AutoNumberingScheme accessionNS = (AutoNumberingScheme)pairANS.second;
        this.persist((Object)cns);
        this.persist((Object)accessionNS);
        this.commitTx();
        this.startTx();
        log.info((Object)"Creating a Collection");
        Collection collection = DataBuilder.createCollection(colPrefix, colName, choice.getCatalogNumberingFmtName(), cns, discipline, false);
        this.persist((Object)collection);
        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
        division.addReference(accessionNS, "numberingSchemes");
        this.persist((Object)division);
        Map<String, SpPrincipal> groupMap = DataBuilder.createStandardGroups(this.session, collection);
        user.addUserToSpPrincipalGroup(groupMap.get(SpecifyUserTypes.UserType.Manager.toString()));
        this.persist((Object)user);
        String userPrefix = isVoucherCol ? "" : "Tis";
        DataBuilder.createAndAddTesterToCollection(this.session, String.valueOf(userPrefix) + "FishTester", "fishtester@brc.ku.edu", String.valueOf(userPrefix) + "FishTester", "", "Fish", "", "Tester", "", discipline, division, collection, groupMap, "Guest");
        this.commitTx();
        log.info((Object)"Creating picklists");
        BuildSampleDatabase.createPickLists(this.session, null);
        BldrPickList colMethods = BuildSampleDatabase.createPickLists(this.session, discipline);
        this.frame.setProcess(++this.createStep);
        this.startTx();
        AppContextMgr.getInstance().setClassObject(SpecifyUser.class, user);
        user.addReference(userAgent, "agents");
        this.persist((Object)user);
        this.frame.setProcess(++this.createStep);
        Vector<Object> dataObjects = new Vector<Object>();
        this.standardQueries(dataObjects, userAgent);
        this.persist(dataObjects);
        dataObjects.clear();
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        Vector<Locality> localities = new Vector<Locality>();
        String POINT = "Point";
        String LINE = "Line";
        String RECT = "Rectangle";
        if (isVoucherCol) {
            log.info((Object)"Creating localities");
            forestStream = DataBuilder.createLocality("Unnamed forest stream pond", (Geography)geos.get(12));
            localities.add(forestStream);
            this.globalLocalities.add(forestStream);
            forestStream.setLatLongType(POINT);
            forestStream.setOriginalLatLongUnit(0);
            forestStream.setLat1text("38.925467 deg N");
            forestStream.setLatitude1(new BigDecimal(38.925467));
            forestStream.setLong1text("94.984867 deg W");
            forestStream.setLongitude1(new BigDecimal(-94.984867));
            lake = DataBuilder.createLocality("Deep, dark lake pond", (Geography)geos.get(17));
            localities.add(lake);
            this.globalLocalities.add(lake);
            lake.setLatLongType(RECT);
            lake.setOriginalLatLongUnit(1);
            lake.setLat1text("41.548842 deg N");
            lake.setLatitude1(new BigDecimal(41.548842));
            lake.setLong1text("93.732129 deg W");
            lake.setLongitude1(new BigDecimal(-93.732129));
            lake.setLat2text("41.642195 deg N");
            lake.setLatitude2(new BigDecimal(41.642195));
            lake.setLong2text("100.403180 deg W");
            lake.setLongitude2(new BigDecimal(-100.40318));
            Geography douglasKS = null;
            for (Object o : geos) {
                Geography g;
                if (!(o instanceof Geography) || (g = (Geography)o).getFullName().indexOf("Douglas") != 0) continue;
                douglasKS = g;
            }
            Locality clintonLake = DataBuilder.createLocality("Clinton Lake", douglasKS);
            localities.add(clintonLake);
            this.globalLocalities.add(clintonLake);
            farmpond = DataBuilder.createLocality("Shoal Creek at Schermerhorn Park, S of Galena at Rt. 26", (Geography)geos.get(11));
            localities.add(farmpond);
            this.globalLocalities.add(farmpond);
            farmpond.setLatLongType(LINE);
            farmpond.setOriginalLatLongUnit(2);
            farmpond.setLat1text("41.642187 deg N");
            farmpond.setLatitude1(new BigDecimal(41.642187));
            farmpond.setLong1text("100.403163 deg W");
            farmpond.setLongitude1(new BigDecimal(-100.403163));
            farmpond.setLat2text("49.647435 deg N");
            farmpond.setLatitude2(new BigDecimal(49.647435));
            farmpond.setLong2text("-55.112163 deg W");
            farmpond.setLongitude2(new BigDecimal(-55.112163));
            this.persist((Object)forestStream);
            this.persist((Object)lake);
            this.persist((Object)farmpond);
            this.persist((Object)clintonLake);
        } else {
            forestStream = this.globalLocalities.get(0);
            lake = this.globalLocalities.get(1);
            farmpond = this.globalLocalities.get(2);
            localities.addAll(this.globalLocalities);
        }
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating agents and addresses");
        Vector<Agent> agents = new Vector<Agent>();
        Agent johnByrn = null;
        Agent ku = new Agent();
        if (isVoucherCol) {
            johnByrn = DataBuilder.createAgent("mr", "John", "D", "Byrn", "jb", "jb@net.edu");
            agents.add(DataBuilder.createAgent("mr", "David", "D", "Smith", "ds", "ds@whitehouse.gov"));
            agents.add(DataBuilder.createAgent("mr", "Robert", "H", "Burk", "rb", "beach@net.edu"));
            agents.add(DataBuilder.createAgent("mrs", "Margaret", "H", "Johnson", "jm", "jm@net.edu"));
            agents.add(DataBuilder.createAgent("mr", "Kip", "C", "Spencer", "kcs", "kip@ku.edu"));
            agents.add(johnByrn);
            agents.add(DataBuilder.createAgent("sir", "Dudley", "X", "Thompson", "dxt", ""));
            agents.add(DataBuilder.createAgent("mr", "Joe", "A", "Campbell", "jb", ""));
            agents.add(DataBuilder.createAgent("mr", "Joe", "A", "Tester", "jb", ""));
            agents.add(DataBuilder.createAgent("mr", "Mitch", "A", "Smyth", "mas", "mas@ku.edu"));
            agents.add(userAgent);
            ku.initialize();
            ku.setAbbreviation("KU");
            ku.setAgentType((byte)0);
            ku.setLastName("University of Kansas");
            ku.setEmail("webadmin@ku.edu");
            ku.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
            ku.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
            agents.add(ku);
            ((Agent)agents.get(0)).setOrganization(ku);
            ((Agent)agents.get(1)).setOrganization(ku);
            ((Agent)agents.get(2)).setOrganization(ku);
            ((Agent)agents.get(3)).setOrganization(ku);
            ((Agent)agents.get(8)).setOrganization(ku);
            Agent otherAgent = new Agent();
            otherAgent.initialize();
            otherAgent.setAbbreviation("O");
            otherAgent.setAgentType((byte)2);
            otherAgent.setLastName("The Other Guys");
            otherAgent.setEmail("other@other.com");
            otherAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
            otherAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
            agents.add(otherAgent);
            ArrayList<GroupPerson> gpList = new ArrayList<GroupPerson>();
            this.startTx();
            Agent gm1 = DataBuilder.createAgent("mr", "John", "A", "Lyon", "jal", "jal@group.edu");
            Agent gm2 = DataBuilder.createAgent("mr", "Dave", "D", "Jones", "ddj", "ddj@group.edu");
            this.persist((Object)gm1);
            this.persist((Object)gm2);
            this.commitTx();
            Agent groupAgent = new Agent();
            groupAgent.initialize();
            groupAgent.setAbbreviation("GRP");
            groupAgent.setAgentType((byte)3);
            groupAgent.setLastName("The Group");
            groupAgent.setEmail("group@group.com");
            groupAgent.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
            groupAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
            agents.add(groupAgent);
            gpList.add(DataBuilder.createGroupPerson(groupAgent, gm1, 0, division));
            gpList.add(DataBuilder.createGroupPerson(groupAgent, gm2, 1, division));
            this.globalAgents.addAll(agents);
            Vector<AgentVariant> agentVariants = new Vector<AgentVariant>();
            agentVariants.add(DataBuilder.createAgentVariant(AgentVariant.VARIANT, "John Variant #1", johnByrn));
            agentVariants.add(DataBuilder.createAgentVariant(AgentVariant.VERNACULAR, "John VERNACULAR #1", johnByrn));
            Vector<Address> addrs = new Vector<Address>();
            addrs.add(DataBuilder.createAddress((Agent)agents.get(1), "1600 Pennsylvania Avenue NW", null, "Washington", "DC", "USA", "20500", 0));
            addrs.add(DataBuilder.createAddress((Agent)agents.get(1), "??? Mississippi", null, "Lawrence", "KS", "USA", "66045", 1));
            addrs.add(DataBuilder.createAddress((Agent)agents.get(2), "1 Main St", "", "Lenexa", "KS", "USA", "66071"));
            addrs.add(DataBuilder.createAddress((Agent)agents.get(3), "13355 Inverness", "Bldg #3", "Lawrence", "KS", "USA", "66047"));
            addrs.add(DataBuilder.createAddress((Agent)agents.get(4), "Natural History Museum", "Cromwell Rd", "London", null, "UK", "SW7 5BD"));
            addrs.add(DataBuilder.createAddress((Agent)agents.get(6), "1212 Apple Street", null, "Chicago", "IL", "USA", "01010"));
            addrs.add(DataBuilder.createAddress((Agent)agents.get(8), "11911 Oak Ln", null, "Orion", "KS", "USA", "66061"));
            addrs.add(DataBuilder.createAddress(ku, null, null, "Lawrence", "KS", "USA", "66045"));
            addrs.add(DataBuilder.createAddress(userAgent, "1214 East Street", null, "Grinnell", "IA", "USA", "56060"));
            this.persist(agents);
            this.persist(agentVariants);
            this.persist(gpList);
        } else {
            agents.addAll(this.globalAgents);
            johnByrn = (Agent)agents.get(4);
            ku = (Agent)agents.get(10);
        }
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating collecting events, collectors and a collecting trip");
        Collector collectorMitch = DataBuilder.createCollector((Agent)agents.get(8), 2);
        Collector collectorJim = DataBuilder.createCollector((Agent)agents.get(1), 1);
        this.calendar.set(1993, 3, 19, 11, 56, 0);
        String stationFieldNumber = String.format(this.STATION_FIELD_FORMAT, this.stationFieldNumberCounter++);
        CollectingEvent ce1 = DataBuilder.createCollectingEvent(forestStream, this.calendar, stationFieldNumber, new Collector[]{collectorMitch, collectorJim});
        ce1.setStartDateVerbatim("19 Mar 1993, 11:56 AM");
        this.calendar.set(1993, 3, 19, 13, 3, 0);
        ce1.setEndDate(this.calendar);
        ce1.setEndDateVerbatim("19 Mar 1993, 1:03 PM");
        ce1.setMethod(colMethods.getItem(1).getValue());
        AttributeDef cevAttrDef = DataBuilder.createAttributeDef(AttributeIFace.FieldType.StringType, "ParkName", discipline, null);
        this.persist((Object)cevAttrDef);
        CollectingEventAttr cevAttr = DataBuilder.createCollectingEventAttr(ce1, cevAttrDef, "Sleepy Hollow", null);
        Collector collectorMeg = DataBuilder.createCollector((Agent)agents.get(2), 1);
        Collector collectorRod = DataBuilder.createCollector((Agent)agents.get(3), 2);
        this.calendar.set(1993, 3, 20, 6, 12, 0);
        stationFieldNumber = String.format(this.STATION_FIELD_FORMAT, this.stationFieldNumberCounter++);
        CollectingEvent ce2 = DataBuilder.createCollectingEvent(farmpond, this.calendar, stationFieldNumber, new Collector[]{collectorMeg, collectorRod});
        ce2.setStartDateVerbatim("20 Mar 1993, 6:12 AM");
        this.calendar.set(1993, 3, 20, 7, 31, 0);
        ce2.setEndDate(this.calendar);
        ce2.setEndDateVerbatim("20 Mar 1993, 7:31 AM");
        ce2.setMethod(colMethods.getItem(2).getValue());
        CollectingTrip trip = DataBuilder.createCollectingTrip("My Collecint Trip", "Sample collecting trip", new CollectingEvent[]{ce1, ce2});
        int[] mn = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        Vector<CollectingEvent> ceList = new Vector<CollectingEvent>();
        boolean oldWay = false;
        if (!oldWay) {
            int monInx = this.rand.nextInt(12);
            int dayInx = this.rand.nextInt(mn[monInx]);
            this.calendar.set(1990 + this.rand.nextInt(15), monInx + 1, dayInx + 1, this.rand.nextInt(24), this.rand.nextInt(60), this.rand.nextInt(60));
            stationFieldNumber = String.format(this.STATION_FIELD_FORMAT, this.stationFieldNumberCounter++);
            Collector collector = null;
            int coltrInx = this.rand.nextInt(4);
            switch (coltrInx) {
                case 0: {
                    collector = collectorMitch;
                    break;
                }
                case 1: {
                    collector = collectorJim;
                    break;
                }
                case 2: {
                    collector = collectorMeg;
                    break;
                }
                case 3: {
                    collector = collectorRod;
                    break;
                }
                default: {
                    collector = collectorRod;
                }
            }
            Locality loc = this.globalLocalities.get(this.rand.nextInt(this.globalLocalities.size()));
            CollectingEvent ce = DataBuilder.createCollectingEvent(loc, this.calendar, stationFieldNumber, new Collector[]{collector});
            ceList.add(ce);
            dataObjects.add(ce);
        }
        dataObjects.add(trip);
        dataObjects.add(ce1);
        dataObjects.add(cevAttr);
        dataObjects.add(ce2);
        dataObjects.add(collectorMitch);
        dataObjects.add(collectorJim);
        dataObjects.add(collectorMeg);
        dataObjects.add(collectorRod);
        this.persist(dataObjects);
        dataObjects.clear();
        log.info((Object)"Creating a permit");
        Calendar issuedDate = Calendar.getInstance();
        issuedDate.set(1993, 1, 12);
        Calendar startDate = Calendar.getInstance();
        startDate.set(1993, 2, 1);
        Calendar endDate = Calendar.getInstance();
        endDate.set(1993, 5, 30);
        Permit permit = DataBuilder.createPermit("1993-FISH-0001", "US Dept Wildlife", issuedDate, startDate, endDate, null);
        permit.setIssuedTo(ku);
        permit.setIssuedBy((Agent)agents.get(4));
        dataObjects.add(permit);
        log.info((Object)"Creating a repository agreement");
        RepositoryAgreement repoAg = new RepositoryAgreement();
        repoAg.initialize();
        repoAg.setDivision(division);
        repoAg.setRepositoryAgreementNumber("KU-1992-01");
        repoAg.setOriginator(ku);
        Calendar received = Calendar.getInstance();
        received.set(1992, 2, 10);
        repoAg.setDateReceived(received);
        Calendar repoEndDate = Calendar.getInstance();
        received.set(2010, 2, 9);
        repoAg.setEndDate(repoEndDate);
        dataObjects.add(repoAg);
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating collection objects");
        Vector<DNASequence> dnaObjs = new Vector<DNASequence>();
        Vector<CollectionObject> collObjs = new Vector<CollectionObject>();
        Collection col = collection;
        Calendar[] catDates = new Calendar[oldWay ? 8 : 50];
        int i = 0;
        while (i < catDates.length) {
            catDates[i] = Calendar.getInstance();
            catDates[i].set(catDates[i].get(1), 1, 12 + i);
            ++i;
        }
        String prefix = "000000";
        if (oldWay) {
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + "100", "RSC100", (Agent)agents.get(0), col, 3, ce1, catDates[0], "BuildSampleDatabase"));
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + "101", "RSC101", (Agent)agents.get(0), col, 2, ce1, catDates[1], "BuildSampleDatabase"));
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + "102", "RSC102", (Agent)agents.get(1), col, 7, ce1, catDates[2], "BuildSampleDatabase"));
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + "103", "RSC103", (Agent)agents.get(1), col, 12, ce1, catDates[3], "BuildSampleDatabase"));
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + "104", "RSC104", (Agent)agents.get(2), col, 8, ce2, catDates[4], "BuildSampleDatabase"));
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + "105", "RSC105", (Agent)agents.get(2), col, 1, ce2, catDates[5], "BuildSampleDatabase"));
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + "106", "RSC106", (Agent)agents.get(2), col, 1, ce2, catDates[6], "BuildSampleDatabase"));
            collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + "107", "RSC107", (Agent)agents.get(3), col, 1, ce2, catDates[7], "BuildSampleDatabase"));
        } else {
            int i2 = 0;
            while (i2 < catDates.length) {
                Integer catNum = i2 + 100;
                int agentInx = this.rand.nextInt(agents.size());
                CollectingEvent ce = (CollectingEvent)ceList.get(this.rand.nextInt(ceList.size()));
                collObjs.add(DataBuilder.createCollectionObject(String.valueOf(prefix) + catNum, "RSC" + catNum, (Agent)agents.get(agentInx), col, this.rand.nextInt(12) + 1, ce, catDates[i2], "BuildSampleDatabase"));
                ++i2;
            }
            char[] syms = new char[]{'A', 'C', 'T', 'G'};
            int i3 = 0;
            while (i3 < catDates.length) {
                int monInx = this.rand.nextInt(12);
                int dayInx = this.rand.nextInt(mn[monInx]);
                Calendar cal = Calendar.getInstance();
                cal.set(2006 + this.rand.nextInt(3), monInx + 1, dayInx + 1, this.rand.nextInt(24), this.rand.nextInt(60), this.rand.nextInt(60));
                DNASequence dna = new DNASequence();
                dna.initialize();
                dna.setCollectionMemberId(((CollectionObject)collObjs.get(i3)).getCollectionMemberId());
                dna.setCollectionObject((CollectionObject)collObjs.get(i3));
                int agentInx = this.rand.nextInt(agents.size());
                dna.setCreatedByAgent((Agent)agents.get(agentInx));
                dna.setSequencer((Agent)agents.get(agentInx));
                StringBuilder sb = new StringBuilder();
                int j = 0;
                while (j < 652) {
                    sb.append(syms[this.rand.nextInt(syms.length)]);
                    ++j;
                }
                dna.setGeneSequence(sb.toString());
                if (this.rand.nextInt(3) < 2) {
                    Calendar submDate = (Calendar)cal.clone();
                    submDate.add(5, 12);
                }
                dnaObjs.add(dna);
                ++i3;
            }
        }
        AttributeDef colObjAttrDef = DataBuilder.createAttributeDef(AttributeIFace.FieldType.StringType, "MoonPhase", discipline, null);
        colObjAttrDef.setDiscipline(discipline);
        discipline.getAttributeDefs().add(colObjAttrDef);
        CollectionObjectAttr colObjAttr = DataBuilder.createCollectionObjectAttr((CollectionObject)collObjs.get(0), colObjAttrDef, "Full", null);
        dataObjects.add(colObjAttrDef);
        dataObjects.addAll(collObjs);
        dataObjects.addAll(dnaObjs);
        dataObjects.add(colObjAttr);
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating determinations");
        Vector<Determination> determs = new Vector<Determination>();
        Calendar recent = Calendar.getInstance();
        recent.set(2006, 10, 27, 13, 44, 0);
        Calendar longAgo = Calendar.getInstance();
        longAgo.set(1976, 1, 29, 8, 12, 0);
        Calendar whileBack = Calendar.getInstance();
        whileBack.set(2002, 7, 4, 9, 33, 12);
        int baseInx = 41 - (this.doShallowTaxonTree ? 30 : 0);
        if (oldWay) {
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(0), (Agent)agents.get(0), (Taxon)taxa.get(baseInx + 1), true, recent));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(1), (Agent)agents.get(0), (Taxon)taxa.get(baseInx + 2), true, recent));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(2), (Agent)agents.get(0), (Taxon)taxa.get(baseInx + 3), true, recent));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(3), (Agent)agents.get(0), (Taxon)taxa.get(baseInx + 4), true, recent));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), (Agent)agents.get(0), (Taxon)taxa.get(baseInx + 5), true, recent));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(5), (Agent)agents.get(0), (Taxon)taxa.get(baseInx + 6), true, recent));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(6), (Agent)agents.get(3), (Taxon)taxa.get(baseInx + 7), true, recent));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(7), (Agent)agents.get(4), (Taxon)taxa.get(baseInx + 8), true, recent));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(0), (Agent)agents.get(0), (Taxon)taxa.get(baseInx), false, longAgo));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(1), (Agent)agents.get(1), (Taxon)taxa.get(baseInx + 7), false, whileBack));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(2), (Agent)agents.get(1), (Taxon)taxa.get(baseInx + 9), false, whileBack));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(3), (Agent)agents.get(2), (Taxon)taxa.get(baseInx + 10), false, whileBack));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), (Agent)agents.get(2), (Taxon)taxa.get(baseInx + 10), false, whileBack));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), (Agent)agents.get(3), (Taxon)taxa.get(baseInx + 13), false, longAgo));
            determs.add(DataBuilder.createDetermination((CollectionObject)collObjs.get(4), (Agent)agents.get(4), (Taxon)taxa.get(baseInx + 12), false, longAgo));
            ((Determination)determs.get(13)).setRemarks("This determination is totally wrong.  What a foolish determination.");
        } else {
            for (CollectionObject co : collObjs) {
                determs.add(DataBuilder.createDetermination(co, (Agent)agents.get(0), (Taxon)taxa.get(baseInx + this.rand.nextInt(13)), true, recent));
            }
        }
        this.persist(determs);
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating preparations");
        Vector<PrepType> prepTypesForSaving = this.loadPrepTypes(discipline.getType());
        Vector<PrepType> pt = new Vector<PrepType>();
        if (doTissues) {
            pt.clear();
            PrepType tissuePT = DataBuilder.createPrepType(collection, "Tissue");
            int i4 = 0;
            while (i4 < prepTypesForSaving.size()) {
                pt.add(tissuePT);
                ++i4;
            }
            prepTypesForSaving.clear();
            prepTypesForSaving.add(tissuePT);
        } else {
            pt.addAll(prepTypesForSaving);
        }
        Vector<Preparation> preps = new Vector<Preparation>();
        Calendar prepDate = Calendar.getInstance();
        if (oldWay) {
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(0), (Agent)agents.get(0), (CollectionObject)collObjs.get(0), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(0), (Agent)agents.get(0), (CollectionObject)collObjs.get(1), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(0), (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(0), (Agent)agents.get(1), (CollectionObject)collObjs.get(3), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(0), (Agent)agents.get(2), (CollectionObject)collObjs.get(4), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(0), (Agent)agents.get(2), (CollectionObject)collObjs.get(5), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(0), (Agent)agents.get(3), (CollectionObject)collObjs.get(6), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(0), (Agent)agents.get(3), (CollectionObject)collObjs.get(7), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(1), (Agent)agents.get(1), (CollectionObject)collObjs.get(0), (Storage)locs.get(11), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(1), (Agent)agents.get(1), (CollectionObject)collObjs.get(1), (Storage)locs.get(11), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(1), (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(10), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(1), (Agent)agents.get(2), (CollectionObject)collObjs.get(3), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(1), (Agent)agents.get(3), (CollectionObject)collObjs.get(4), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(1), (Agent)agents.get(0), (CollectionObject)collObjs.get(5), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(2), (Agent)agents.get(1), (CollectionObject)collObjs.get(6), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(2), (Agent)agents.get(1), (CollectionObject)collObjs.get(7), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(2), (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(3), (Agent)agents.get(1), (CollectionObject)collObjs.get(0), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(3), (Agent)agents.get(1), (CollectionObject)collObjs.get(1), (Storage)locs.get(7), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(3), (Agent)agents.get(1), (CollectionObject)collObjs.get(2), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(3), (Agent)agents.get(1), (CollectionObject)collObjs.get(3), (Storage)locs.get(8), this.rand.nextInt(20) + 1, prepDate));
            preps.add(DataBuilder.createPreparation((PrepType)pt.get(3), (Agent)agents.get(1), (CollectionObject)collObjs.get(4), (Storage)locs.get(9), this.rand.nextInt(20) + 1, prepDate));
        } else {
            for (CollectionObject co : collObjs) {
                preps.add(DataBuilder.createPreparation((PrepType)pt.get(0), (Agent)agents.get(this.rand.nextInt(4)), co, (Storage)locs.get(this.rand.nextInt(6) + 7), this.rand.nextInt(20) + 1, prepDate));
            }
        }
        dataObjects.add(collection);
        dataObjects.addAll(prepTypesForSaving);
        dataObjects.addAll(preps);
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        log.info((Object)"Creating accessions and accession agents");
        this.calendar.set(2006, 10, 27, 23, 59, 59);
        int yr = 2000 + (int)(this.rand.nextDouble() * 7.0);
        Accession acc1 = DataBuilder.createAccession(division, "gift", "complete", String.valueOf(yr) + "-IC-001", DateFormat.getInstance().format(this.calendar.getTime()), this.calendar, this.calendar);
        acc1.setText1("Ichthyology");
        acc1.setRepositoryAgreement(repoAg);
        Agent donor = (Agent)agents.get(4);
        Agent receiver = (Agent)agents.get(1);
        Agent reviewer = (Agent)agents.get(2);
        Vector<AccessionAgent> accAgents = new Vector<AccessionAgent>();
        accAgents.add(DataBuilder.createAccessionAgent("donor", donor, acc1, null));
        accAgents.add(DataBuilder.createAccessionAgent("receiver", receiver, acc1, null));
        accAgents.add(DataBuilder.createAccessionAgent("reviewer", reviewer, acc1, null));
        Accession acc2 = DataBuilder.createAccession(division, "field_work", "inprocess", String.valueOf(yr) + "-IC-002", DateFormat.getInstance().format(this.calendar.getTime()), this.calendar, this.calendar);
        Agent donor2 = (Agent)agents.get(5);
        Agent receiver2 = (Agent)agents.get(3);
        Agent reviewer2 = (Agent)agents.get(1);
        accAgents.add(DataBuilder.createAccessionAgent("donor", donor2, acc2, null));
        accAgents.add(DataBuilder.createAccessionAgent("receiver", receiver2, acc2, null));
        accAgents.add(DataBuilder.createAccessionAgent("reviewer", reviewer2, acc2, null));
        dataObjects.add(acc1);
        dataObjects.add(acc2);
        dataObjects.addAll(accAgents);
        this.persist(dataObjects);
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        this.createLoanExamples(preps, agents, dataObjects);
        this.frame.setProcess(++this.createStep);
        this.persist(dataObjects);
        dataObjects.clear();
        String name = String.valueOf(discipline.getName()) + " DataSet";
        WorkbenchTemplate wbTemplate = DataBuilder.createWorkbenchTemplate(user, name, "These are the remarks");
        WorkbenchTemplateMappingItem wbtmi0 = DataBuilder.createWorkbenchMappingItem("CollectionObject", 1, "fieldNumber", "Field Number", 25, 0, 0, wbTemplate);
        WorkbenchTemplateMappingItem wbtmi1 = DataBuilder.createWorkbenchMappingItem("CollectionObject", 1, "catalogedDate", "Cataloged Date", 25, 1, 1, wbTemplate);
        WorkbenchTemplateMappingItem wbtmi2 = DataBuilder.createWorkbenchMappingItem("CollectionObject", 1, "catalogNumber", "Catalog Number", 25, 2, 2, wbTemplate);
        WorkbenchTemplateMappingItem wbtmi3 = DataBuilder.createWorkbenchMappingItem("CollectionObject", 1, "collectionObjectYesNo1", "Yes/No", 8, 3, 3, wbTemplate);
        dataObjects.add(wbTemplate);
        dataObjects.add(wbtmi0);
        dataObjects.add(wbtmi1);
        dataObjects.add(wbtmi2);
        dataObjects.add(wbtmi3);
        Workbench workBench = DataBuilder.createWorkbench(user, name, "These are the remarks", "field_notebook.cvs", wbTemplate);
        dataObjects.add(workBench);
        int i5 = 1;
        while (i5 <= 14) {
            WorkbenchRow wbRow = workBench.addRow();
            WorkbenchDataItem wbdi0 = DataBuilder.createWorkbenchDataItem(wbRow, "RS-10" + i5, 0);
            int date = i5 * 547 % 31 + 1;
            Object dateStr = "0" + Integer.toString(date);
            dateStr = ((String)dateStr).substring(((String)dateStr).length() - 2);
            WorkbenchDataItem wbdi1 = DataBuilder.createWorkbenchDataItem(wbRow, "03/" + (String)dateStr + "/2007", 1);
            WorkbenchDataItem wbdi2 = DataBuilder.createWorkbenchDataItem(wbRow, "CN-10" + i5, 2);
            String boolValAsStr = null;
            switch (i5 % 3) {
                case 0: {
                    boolValAsStr = "true";
                    break;
                }
                case 1: {
                    boolValAsStr = "false";
                    break;
                }
                case 2: {
                    boolValAsStr = "";
                }
            }
            boolValAsStr = "";
            WorkbenchDataItem wbdi3 = DataBuilder.createWorkbenchDataItem(wbRow, boolValAsStr, 3);
            WorkbenchRowImage wbRowImage = null;
            File f = new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "demo_files" + File.separator + "card" + i5 + (i5 == 2 ? ".png" : ".jpg"));
            if (f.exists()) {
                try {
                    int imageIndex = wbRow.addImage(f);
                    if (imageIndex > -1) {
                        wbRowImage = wbRow.getRowImage(imageIndex);
                    }
                }
                catch (IOException e) {
                    String msg = UIRegistry.getResourceString("WB_IMG_ERR_LOAD");
                    UIRegistry.getStatusBar().setErrorMessage(msg, e);
                    log.error((Object)msg, (Throwable)e);
                }
            }
            dataObjects.add(wbRow);
            dataObjects.add(wbdi0);
            dataObjects.add(wbdi1);
            dataObjects.add(wbdi2);
            if (wbRowImage != null) {
                dataObjects.add(wbRowImage);
            }
            if (wbdi3 != null) {
                dataObjects.add(wbdi3);
            }
            ++i5;
        }
        this.startTx();
        this.persist(dataObjects);
        this.commitTx();
        dataObjects.clear();
        this.frame.setProcess(++this.createStep);
        this.startTx();
        log.info((Object)"Creating attachments and attachment metadata");
        try {
            String attachmentFilesLoc = String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "demo_files" + File.separator;
            String[] names = new String[]{"Beach", "Smyth", "Spears", "Kumin", "Bentley"};
            String[] photos = new String[]{"beach.jpg", "rod.jpg", "rod.jpg", "meg.jpg", "andy.jpg"};
            for (Agent agent : agents) {
                int i6 = 0;
                while (i6 < names.length) {
                    if (agent.getLastName() != null && agent.getLastName().startsWith(names[i6])) {
                        String photoPath = String.valueOf(attachmentFilesLoc) + photos[i6];
                        File file = new File(String.valueOf(attachmentFilesLoc) + photos[i6]);
                        if (file.exists()) {
                            Attachment photoAttachment = DataBuilder.createAttachment(photoPath, "image/jpeg");
                            dataObjects.add(photoAttachment);
                            AgentAttachment agentAttach = new AgentAttachment();
                            agentAttach.initialize();
                            agentAttach.setAgent(agent);
                            agentAttach.setAttachment(photoAttachment);
                            agentAttach.setOrderIndex(0);
                            dataObjects.add(agentAttach);
                            AttachmentMetadata copyrightData = new AttachmentMetadata();
                            copyrightData.initialize();
                            copyrightData.setName("Copyright");
                            copyrightData.setValue("2008");
                            photoAttachment.getMetadata().add(copyrightData);
                            copyrightData.setAttachment(photoAttachment);
                            dataObjects.add(copyrightData);
                            AttachmentMetadata defPhotoIndicator = new AttachmentMetadata();
                            defPhotoIndicator.initialize();
                            defPhotoIndicator.setName("Default Photo");
                            defPhotoIndicator.setValue("yes");
                            photoAttachment.getMetadata().add(defPhotoIndicator);
                            defPhotoIndicator.setAttachment(photoAttachment);
                            dataObjects.add(defPhotoIndicator);
                            AttachmentUtils.getAttachmentManager().setStorageLocationIntoAttachment(photoAttachment, true);
                            photoAttachment.storeFile(false);
                        }
                    }
                    ++i6;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not create attachments", (Throwable)e);
        }
        this.addConservatorData(agents, collObjs);
        this.commitTx();
        this.frame.setProcess(++this.createStep);
        List taxa2 = this.session.createQuery("SELECT t FROM Taxon t WHERE t.name = 'Ammocrypta'").list();
        Vector<ReferenceWork> rwList = new Vector<ReferenceWork>();
        this.startTx();
        rwList.addAll(journal.getReferenceWorks());
        TaxonCitation taxonCitation = new TaxonCitation();
        taxonCitation.initialize();
        Taxon ammocrypta = (Taxon)taxa2.get(0);
        taxonCitation.setTaxon(ammocrypta);
        taxonCitation.setReferenceWork((ReferenceWork)rwList.get(0));
        ((ReferenceWork)rwList.get(0)).addTaxonCitations(taxonCitation);
        ammocrypta.getTaxonCitations().add(taxonCitation);
        dataObjects.add(taxonCitation);
        this.persist((Object)taxonCitation);
        if (isVoucherCol) {
            Locality locality = (Locality)localities.get(0);
            LocalityCitation localityCitation = new LocalityCitation();
            localityCitation.initialize();
            localityCitation.setLocality(locality);
            locality.getLocalityCitations().add(localityCitation);
            localityCitation.setReferenceWork((ReferenceWork)rwList.get(1));
            ((ReferenceWork)rwList.get(1)).addLocalityCitations(localityCitation);
            dataObjects.add(localityCitation);
            this.persist((Object)localityCitation);
        }
        this.commitTx();
        this.frame.setProcess(++this.createStep);
        return collection;
    }

    public void createDisciplines(String usernameArg, String passwordArg) {
        this.createStep = 0;
        this.frame.setProcess(0, 4);
        this.frame.setProcess(++this.createStep);
        String username = this.initPrefs.getProperty("useragent.username", usernameArg);
        String email = this.initPrefs.getProperty("useragent.email", "ku@ku.edu");
        String userType = this.initPrefs.getProperty("useragent.usertype", SpecifyUserTypes.UserType.Manager.toString());
        String password = this.initPrefs.getProperty("useragent.password", passwordArg);
        System.out.println("----- User Agent -----");
        System.out.println("Userame:   " + username);
        Institution institution = DataBuilder.createInstitution("Natural History Museum");
        this.startTx();
        SpecifyUser specifyAdminUser = DataBuilder.createAdminGroupAndUser(this.session, institution, null, username, email, password, userType);
        this.dataType = DataBuilder.createDataType("Biota");
        this.persist((Object)institution);
        this.persist((Object)this.dataType);
        this.persist((Object)specifyAdminUser);
        this.commitTx();
        this.frame.setProcess(++this.createStep);
        if (this.isChoosen(DisciplineType.STD_DISCIPLINES.fish, false) || this.isChoosen(DisciplineType.STD_DISCIPLINES.fish, true)) {
            this.createFishCollection(DisciplineType.getDiscipline("fish"), institution, specifyAdminUser, this.getChoice(DisciplineType.STD_DISCIPLINES.fish, false));
        }
        this.frame.setOverall(this.steps++);
        if (this.isChoosen(DisciplineType.STD_DISCIPLINES.invertpaleo, false)) {
            this.createSingleInvertPaleoCollection(DisciplineType.getDiscipline("invertpaleo"), institution, specifyAdminUser, this.getChoice(DisciplineType.STD_DISCIPLINES.invertpaleo, false));
        }
        this.frame.setOverall(this.steps++);
        if (this.isChoosen(DisciplineType.STD_DISCIPLINES.botany, false)) {
            if (!this.doHugeBotany) {
                this.createSingleBotanyCollection(DisciplineType.getDiscipline("botany"), institution, specifyAdminUser, this.getChoice(DisciplineType.STD_DISCIPLINES.botany, false));
            } else {
                this.createHugeBotanyCollection(DisciplineType.getDiscipline("botany"), institution, specifyAdminUser, this.getChoice(DisciplineType.STD_DISCIPLINES.botany, false));
            }
        }
        DisciplineType.STD_DISCIPLINES[] sTD_DISCIPLINESArray = DisciplineType.STD_DISCIPLINES.values();
        int n = sTD_DISCIPLINESArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisciplineType.STD_DISCIPLINES disp = sTD_DISCIPLINESArray[n2];
            if (disp != DisciplineType.STD_DISCIPLINES.botany && disp != DisciplineType.STD_DISCIPLINES.invertpaleo && disp != DisciplineType.STD_DISCIPLINES.fish && this.isChoosen(disp, false)) {
                this.frame.setOverall(this.steps++);
                String method = null;
                switch (disp) {
                    case herpetology: {
                        method = "trap";
                        break;
                    }
                    case paleobotany: {
                        method = "dug";
                        break;
                    }
                    case vertpaleo: {
                        method = "dug";
                        break;
                    }
                    case bird: {
                        method = "shot";
                        break;
                    }
                    case mammal: {
                        method = "trap";
                        break;
                    }
                    case insect: {
                        method = "trap";
                        break;
                    }
                    case invertebrate: {
                        method = "trap";
                        break;
                    }
                    default: {
                        method = "XXX";
                    }
                }
                DisciplineType dType = DisciplineType.getDiscipline(disp);
                log.debug((Object)("Building " + dType.getName()));
                if (XMLHelper.getConfigDir(String.valueOf(dType.getFolder()) + File.separator + "taxon_init.xml").exists()) {
                    this.createGenericCollection(dType, institution, specifyAdminUser, this.getChoice(disp, false), method);
                }
            }
            ++n2;
        }
        this.frame.setOverall(this.steps++);
    }

    public static List<Object> createSimpleLithoStrat(LithoStratTreeDef def, boolean doAddTreeNodes) {
        log.info((Object)("createSimpleLithoStrat " + def.getName()));
        Vector<Object> newObjs = new Vector<Object>();
        LithoStratTreeDefItem planet = new LithoStratTreeDefItem();
        planet.initialize();
        planet.setName(UIRegistry.getResourceString("Surface"));
        planet.setRankId(0);
        planet.setIsEnforced(true);
        planet.setFullNameSeparator(", ");
        LithoStratTreeDefItem superLitho = new LithoStratTreeDefItem();
        superLitho.initialize();
        superLitho.setName(UIRegistry.getResourceString("SuperLitho"));
        superLitho.setRankId(100);
        superLitho.setFullNameSeparator(", ");
        LithoStratTreeDefItem group = new LithoStratTreeDefItem();
        group.initialize();
        group.setName(UIRegistry.getResourceString("Group"));
        group.setRankId(200);
        group.setIsInFullName(true);
        group.setFullNameSeparator(", ");
        LithoStratTreeDefItem formation = new LithoStratTreeDefItem();
        formation.initialize();
        formation.setName(UIRegistry.getResourceString("Formation"));
        formation.setRankId(300);
        formation.setIsInFullName(true);
        formation.setFullNameSeparator(", ");
        LithoStratTreeDefItem member = new LithoStratTreeDefItem();
        member.initialize();
        member.setName(UIRegistry.getResourceString("Member"));
        member.setRankId(400);
        member.setIsInFullName(true);
        member.setFullNameSeparator(", ");
        LithoStratTreeDefItem bed = new LithoStratTreeDefItem();
        bed.initialize();
        bed.setName(UIRegistry.getResourceString("Bed"));
        bed.setRankId(500);
        bed.setIsInFullName(true);
        bed.setFullNameSeparator(", ");
        planet.setTreeDef(def);
        Set<LithoStratTreeDefItem> defItems = def.getTreeDefItems();
        defItems.add(planet);
        newObjs.add(planet);
        if (doAddTreeNodes) {
            bed.setParent(member);
            member.setParent(formation);
            formation.setParent(group);
            group.setParent(superLitho);
            superLitho.setParent(planet);
            superLitho.setTreeDef(def);
            group.setTreeDef(def);
            formation.setTreeDef(def);
            member.setTreeDef(def);
            bed.setTreeDef(def);
            defItems.add(superLitho);
            defItems.add(group);
            defItems.add(formation);
            defItems.add(member);
            defItems.add(bed);
            newObjs.add(superLitho);
            newObjs.add(group);
            newObjs.add(formation);
            newObjs.add(member);
            newObjs.add(bed);
            LithoStrat earth = new LithoStrat();
            earth.initialize();
            earth.setName(UIRegistry.getResourceString("Earth"));
            earth.setFullName(earth.getName());
            earth.setDefinition(def);
            earth.setDefinitionItem(planet);
            earth.setNodeNumber(1);
            earth.setHighestChildNodeNumber(1);
            earth.setIsAccepted(true);
            newObjs.add(earth);
        }
        return newObjs;
    }

    public static List<Object> createSimpleGeography(GeographyTreeDef geoTreeDef, boolean doAddTreeNodes) {
        log.info((Object)("createSimpleGeography " + geoTreeDef.getName()));
        Vector<Object> newObjs = new Vector<Object>();
        GeographyTreeDefItem root = DataBuilder.createGeographyTreeDefItem(null, geoTreeDef, "   ", 0);
        root.setIsEnforced(true);
        GeographyTreeDefItem cont = DataBuilder.createGeographyTreeDefItem(root, geoTreeDef, "Continent", 100);
        GeographyTreeDefItem country = DataBuilder.createGeographyTreeDefItem(cont, geoTreeDef, "Country", 200);
        GeographyTreeDefItem state = DataBuilder.createGeographyTreeDefItem(country, geoTreeDef, "State", 300);
        state.setIsInFullName(true);
        GeographyTreeDefItem county = DataBuilder.createGeographyTreeDefItem(state, geoTreeDef, "County", 400);
        county.setIsInFullName(true);
        newObjs.add(root);
        newObjs.add(cont);
        newObjs.add(country);
        newObjs.add(state);
        newObjs.add(county);
        Geography earth = null;
        if (doAddTreeNodes) {
            earth = DataBuilder.createGeography(geoTreeDef, null, "Earth", root.getRankId());
            newObjs.add(earth);
            Geography northAmerica = DataBuilder.createGeography(geoTreeDef, earth, "North America", cont.getRankId());
            Geography geography = DataBuilder.createGeography(geoTreeDef, northAmerica, "United States", country.getRankId());
            List<Geography> states = DataBuilder.createGeographyChildren(geoTreeDef, geography, new String[]{"Kansas", "Iowa", "Nebraska"}, state.getRankId());
            newObjs.add(northAmerica);
            newObjs.add(geography);
            newObjs.addAll(states);
            List<Geography> counties = DataBuilder.createGeographyChildren(geoTreeDef, states.get(0), new String[]{"Cherokee", "Douglas", "Johnson", "Osage", "Sedgwick"}, county.getRankId());
            newObjs.addAll(counties);
            counties = DataBuilder.createGeographyChildren(geoTreeDef, states.get(1), new String[]{"Blackhawk", "Fayette", "Polk", "Woodbury", "Johnson"}, county.getRankId());
            newObjs.addAll(counties);
            counties = DataBuilder.createGeographyChildren(geoTreeDef, states.get(2), new String[]{"Dakota", "Logan", "Valley", "Wheeler", "Johnson"}, county.getRankId());
            newObjs.addAll(counties);
        }
        int i = 0;
        for (Object e : newObjs) {
            if (e instanceof Geography) {
                log.debug((Object)(String.valueOf(i) + " " + ((Geography)e).getName()));
            }
            ++i;
        }
        if (doAddTreeNodes) {
            TreeHelper.fixFullnameForNodeAndDescendants(earth);
            earth.setNodeNumber(1);
            BuildSampleDatabase.fixNodeNumbersFromRoot(earth);
        }
        return newObjs;
    }

    public static List<Object> createSimpleGeologicTimePeriod(GeologicTimePeriodTreeDef treeDef, boolean doAddTreeNode) {
        log.info((Object)("createSimpleGeologicTimePeriod " + treeDef.getName()));
        Vector<Object> newObjs = new Vector<Object>();
        GeologicTimePeriodTreeDefItem defItemLevel0 = DataBuilder.createGeologicTimePeriodTreeDefItem(null, treeDef, "Level 0", 0);
        GeologicTimePeriodTreeDefItem defItemLevel1 = DataBuilder.createGeologicTimePeriodTreeDefItem(defItemLevel0, treeDef, "Level 1", 100);
        GeologicTimePeriodTreeDefItem defItemLevel2 = DataBuilder.createGeologicTimePeriodTreeDefItem(defItemLevel1, treeDef, "Level 2", 200);
        GeologicTimePeriodTreeDefItem defItemLevel3 = DataBuilder.createGeologicTimePeriodTreeDefItem(defItemLevel2, treeDef, "Level 3", 300);
        newObjs.add(defItemLevel0);
        newObjs.add(defItemLevel1);
        newObjs.add(defItemLevel2);
        newObjs.add(defItemLevel3);
        defItemLevel0.setIsInFullName(false);
        defItemLevel1.setIsInFullName(false);
        defItemLevel2.setIsInFullName(true);
        defItemLevel3.setIsInFullName(true);
        GeologicTimePeriod level0 = DataBuilder.createGeologicTimePeriod(treeDef, null, "Place Holder", 10.0f, 0.0f, defItemLevel0.getRankId());
        newObjs.add(level0);
        if (doAddTreeNode) {
            GeologicTimePeriod level1 = DataBuilder.createGeologicTimePeriod(treeDef, level0, "Some Really Big Time Period", 5.0f, 0.0f, defItemLevel1.getRankId());
            GeologicTimePeriod level2 = DataBuilder.createGeologicTimePeriod(treeDef, level1, "A Slightly Smaller Time Period", 1.74f, 0.0f, defItemLevel2.getRankId());
            GeologicTimePeriod level3_1 = DataBuilder.createGeologicTimePeriod(treeDef, level2, "Yesterday", 0.1f, 0.0f, defItemLevel3.getRankId());
            GeologicTimePeriod level3_2 = DataBuilder.createGeologicTimePeriod(treeDef, level2, "A couple of days ago", 0.2f, 0.1f, defItemLevel3.getRankId());
            GeologicTimePeriod level3_3 = DataBuilder.createGeologicTimePeriod(treeDef, level2, "Last week", 0.7f, 1.4f, defItemLevel3.getRankId());
            newObjs.add(level1);
            newObjs.add(level2);
            newObjs.add(level3_1);
            newObjs.add(level3_2);
            newObjs.add(level3_3);
        }
        TreeHelper.fixFullnameForNodeAndDescendants(level0);
        level0.setNodeNumber(1);
        BuildSampleDatabase.fixNodeNumbersFromRoot(level0);
        return newObjs;
    }

    public static List<Object> createSimpleStorage(StorageTreeDef stgTreeDef) {
        log.info((Object)("createSimpleStorage " + stgTreeDef.getName()));
        locs = new Vector<Object>();
        StorageTreeDefItem building = DataBuilder.createStorageTreeDefItem(null, stgTreeDef, "building", 0);
        building.setIsEnforced(true);
        StorageTreeDefItem room = DataBuilder.createStorageTreeDefItem(building, stgTreeDef, "room", 100);
        room.setIsInFullName(true);
        StorageTreeDefItem freezer = DataBuilder.createStorageTreeDefItem(room, stgTreeDef, "freezer", 200);
        freezer.setIsInFullName(true);
        StorageTreeDefItem shelf = DataBuilder.createStorageTreeDefItem(freezer, stgTreeDef, "shelf", 300);
        shelf.setIsInFullName(true);
        Storage dyche = DataBuilder.createStorage(stgTreeDef, null, "Dyche Hall", building.getRankId());
        Storage rm606 = DataBuilder.createStorage(stgTreeDef, dyche, "Room 606", room.getRankId());
        Storage freezerA = DataBuilder.createStorage(stgTreeDef, rm606, "Freezer A", freezer.getRankId());
        Storage shelf5 = DataBuilder.createStorage(stgTreeDef, freezerA, "Shelf 5", shelf.getRankId());
        Storage shelf4 = DataBuilder.createStorage(stgTreeDef, freezerA, "Shelf 4", shelf.getRankId());
        Storage shelf3 = DataBuilder.createStorage(stgTreeDef, freezerA, "Shelf 3", shelf.getRankId());
        Storage shelf2 = DataBuilder.createStorage(stgTreeDef, freezerA, "Shelf 2", shelf.getRankId());
        Storage shelf1 = DataBuilder.createStorage(stgTreeDef, freezerA, "Shelf 1", shelf.getRankId());
        Storage rm701 = DataBuilder.createStorage(stgTreeDef, dyche, "Room 701", room.getRankId());
        Storage freezerA_701 = DataBuilder.createStorage(stgTreeDef, rm701, "Freezer A", freezer.getRankId());
        Storage shelf1_701 = DataBuilder.createStorage(stgTreeDef, freezerA_701, "Shelf 1", shelf.getRankId());
        Storage rm703 = DataBuilder.createStorage(stgTreeDef, dyche, "Room 703", room.getRankId());
        Storage freezerA_703 = DataBuilder.createStorage(stgTreeDef, rm703, "Freezer A", freezer.getRankId());
        Storage shelf1_703 = DataBuilder.createStorage(stgTreeDef, freezerA_703, "Shelf 1", shelf.getRankId());
        Storage shelf2_703 = DataBuilder.createStorage(stgTreeDef, freezerA_703, "Shelf 2", shelf.getRankId());
        Storage shelf3_703 = DataBuilder.createStorage(stgTreeDef, freezerA_703, "Shelf 3", shelf.getRankId());
        locs.add(building);
        locs.add(room);
        locs.add(freezer);
        locs.add(shelf);
        locs.add(dyche);
        locs.add(rm606);
        locs.add(freezerA);
        locs.add(shelf5);
        locs.add(shelf4);
        locs.add(shelf3);
        locs.add(shelf2);
        locs.add(shelf1);
        locs.add(rm701);
        locs.add(freezerA_701);
        locs.add(shelf1_701);
        locs.add(rm703);
        locs.add(freezerA_703);
        locs.add(shelf1_703);
        locs.add(shelf2_703);
        locs.add(shelf3_703);
        TreeHelper.fixFullnameForNodeAndDescendants(dyche);
        dyche.setNodeNumber(1);
        BuildSampleDatabase.fixNodeNumbersFromRoot(dyche);
        return locs;
    }

    public static List<Object> createSimpleFishTaxonTree(TaxonTreeDef taxonTreeDef, boolean doShallow) {
        Set<TaxonTreeDefItem> newItems;
        log.info((Object)("createSimpleFishTaxonTree " + taxonTreeDef.getName()));
        Vector<Object> newObjs = new Vector<Object>();
        if (doShallow) {
            Object[][] taxonItems = new Object[][]{{0, "Taxonomy Root", true, false}, {100, "Order", true, false}, {110, "Suborder", false, false}, {140, "Family", false, false}, {180, "Genus", true, true}, {220, "Species", false, true}};
            newItems = TreeFactory.addStandardTaxonDefItems(taxonTreeDef, taxonItems);
        } else {
            newItems = TreeFactory.addStandardTaxonDefItems(taxonTreeDef);
        }
        newObjs.addAll(newItems);
        for (TaxonTreeDefItem item : newItems) {
            if (item.getRankId().equals(180)) {
                item.setFormatToken("%G");
                continue;
            }
            if (item.getRankId().equals(220)) {
                item.setFormatToken("%S");
                continue;
            }
            if (!item.getRankId().equals(230)) continue;
            item.setFormatToken("%SS");
        }
        Taxon life = DataBuilder.createTaxon(taxonTreeDef, null, "Life", 0);
        Taxon animalia = null;
        Taxon chordata = null;
        Taxon vertebrata = null;
        Taxon osteichthyes = null;
        Taxon actinopterygii = null;
        Taxon neopterygii = null;
        Taxon teleostei = null;
        Taxon acanthopterygii = null;
        if (!doShallow) {
            animalia = DataBuilder.createTaxon(taxonTreeDef, life, "Animalia", 10);
            chordata = DataBuilder.createTaxon(taxonTreeDef, animalia, "Chordata", 30);
            vertebrata = DataBuilder.createTaxon(taxonTreeDef, chordata, "Vertebrata", 40);
            osteichthyes = DataBuilder.createTaxon(taxonTreeDef, vertebrata, "Osteichthyes", 50);
            actinopterygii = DataBuilder.createTaxon(taxonTreeDef, osteichthyes, "Actinopterygii", 60);
            neopterygii = DataBuilder.createTaxon(taxonTreeDef, actinopterygii, "Neopterygii", 70);
            teleostei = DataBuilder.createTaxon(taxonTreeDef, neopterygii, "Teleostei", 80);
            acanthopterygii = DataBuilder.createTaxon(taxonTreeDef, teleostei, "Acanthopterygii", 90);
        }
        Taxon perciformes = DataBuilder.createTaxon(taxonTreeDef, doShallow ? life : acanthopterygii, "Perciformes", 100);
        Taxon percoidei = DataBuilder.createTaxon(taxonTreeDef, perciformes, "Percoidei", 110);
        Taxon percidae = DataBuilder.createTaxon(taxonTreeDef, percoidei, "Percidae", 140);
        Taxon ammocrypta = DataBuilder.createTaxon(taxonTreeDef, percidae, "Ammocrypta", 180);
        ammocrypta.setCommonName("sand darters");
        newObjs.add(life);
        if (!doShallow) {
            newObjs.add(animalia);
            newObjs.add(chordata);
            newObjs.add(vertebrata);
            newObjs.add(osteichthyes);
            newObjs.add(actinopterygii);
            newObjs.add(neopterygii);
            newObjs.add(teleostei);
            newObjs.add(acanthopterygii);
        }
        newObjs.add(perciformes);
        newObjs.add(percoidei);
        newObjs.add(percidae);
        newObjs.add(ammocrypta);
        String[] speciesNames = new String[]{"asprella", "beanii", "bifascia", "clara", "meridiana", "pellucida", "vivax"};
        String[] commonNames = new String[]{"crystal darter", "naked sand darter", "Florida sand darter", "western sand darter", "southern sand darter", "eastern sand darter", "scaly sand darter"};
        List<Object> kids = DataBuilder.createTaxonChildren(taxonTreeDef, ammocrypta, speciesNames, commonNames, 220);
        newObjs.addAll(kids);
        Taxon carangidae = DataBuilder.createTaxon(taxonTreeDef, percoidei, "Carangidae", 140);
        Taxon caranx = DataBuilder.createTaxon(taxonTreeDef, carangidae, "Caranx", 180);
        newObjs.add(carangidae);
        newObjs.add(caranx);
        String[] speciesNames2 = new String[]{"bartholomaei", "caballus", "caninus", "crysos", "dentex", "hippos", "latus"};
        String[] commonNames2 = new String[]{"yellow jack", "green jack", "Pacific crevalle jack", "blue runner", "white trevally", "crevalle jack", "horse-eye jack"};
        kids = DataBuilder.createTaxonChildren(taxonTreeDef, caranx, speciesNames2, commonNames2, 220);
        newObjs.addAll(kids);
        int baseInx = 53 - (doShallow ? 30 : 0);
        Taxon fusus = DataBuilder.createTaxon(taxonTreeDef, caranx, "fusus", 220);
        fusus.setCommonName("Blue runner");
        Taxon crysos = (Taxon)newObjs.get(baseInx);
        fusus.setAcceptedTaxon(crysos);
        fusus.setIsAccepted(false);
        Taxon carangus = DataBuilder.createTaxon(taxonTreeDef, caranx, "carangus", 220);
        carangus.setCommonName("Blacktailed trevally");
        Taxon hippos = (Taxon)newObjs.get(baseInx + 2);
        carangus.setAcceptedTaxon(hippos);
        carangus.setIsAccepted(false);
        Taxon etheostoma = DataBuilder.createTaxon(taxonTreeDef, percidae, "Etheostoma", 180);
        etheostoma.setCommonName("smoothbelly darters");
        Taxon meridianum = DataBuilder.createTaxon(taxonTreeDef, etheostoma, "meridianum", 220);
        meridianum.setCommonName("southern sand darter");
        Taxon merdiana = (Taxon)newObjs.get(baseInx - 8);
        merdiana.setAcceptedTaxon(meridianum);
        merdiana.setIsAccepted(false);
        Taxon pellucidum = DataBuilder.createTaxon(taxonTreeDef, etheostoma, "pellucidum", 220);
        pellucidum.setCommonName("eastern sand darter");
        Taxon pellucida = (Taxon)newObjs.get(baseInx - 7);
        pellucidum.setAcceptedTaxon(pellucida);
        pellucidum.setIsAccepted(false);
        Taxon ethVivax = DataBuilder.createTaxon(taxonTreeDef, etheostoma, "vivax", 220);
        ethVivax.setCommonName("scaly sand darter");
        Taxon vivax = (Taxon)newObjs.get(baseInx - 6);
        ethVivax.setAcceptedTaxon(vivax);
        ethVivax.setIsAccepted(false);
        Taxon beani = DataBuilder.createTaxon(taxonTreeDef, ammocrypta, "beani", 220);
        beani.setCommonName("naked sand darter");
        Taxon beanii = (Taxon)newObjs.get(baseInx - 11);
        beani.setAcceptedTaxon(beanii);
        beani.setIsAccepted(false);
        Taxon crystallaria = DataBuilder.createTaxon(taxonTreeDef, percidae, "Crystallaria", 180);
        crystallaria.setCommonName("crystal darters");
        Taxon crysAsprella = DataBuilder.createTaxon(taxonTreeDef, crystallaria, "asprella", 220);
        crysAsprella.setCommonName("crystal darter");
        Taxon asprella = (Taxon)newObjs.get(baseInx - 12);
        asprella.setAcceptedTaxon(crysAsprella);
        asprella.setIsAccepted(false);
        newObjs.add(fusus);
        newObjs.add(carangus);
        newObjs.add(etheostoma);
        newObjs.add(meridianum);
        newObjs.add(pellucidum);
        newObjs.add(ethVivax);
        newObjs.add(beani);
        newObjs.add(crystallaria);
        newObjs.add(crysAsprella);
        TreeHelper.fixFullnameForNodeAndDescendants(life);
        life.setNodeNumber(1);
        BuildSampleDatabase.fixNodeNumbersFromRoot(life);
        return newObjs;
    }

    public static List<Object> createSimpleBotanyTaxonTree(TaxonTreeDef taxonTreeDef) {
        log.info((Object)("createSimpleBotanyTaxonTree " + taxonTreeDef.getName()));
        Vector<Object> newObjs = new Vector<Object>();
        Object[][] taxonItems = new Object[][]{{0, "Taxonomy Root", true, false}, {10, "Kingdom", true, false}, {30, "Division", false, false}, {60, "Class", false, false}, {100, "Order", false, false}, {140, "Family", false, false}, {180, "Genus", true, true}, {220, "Species", false, true}, {240, "Variety", false, true}};
        Set<TaxonTreeDefItem> newItems = TreeFactory.addStandardTaxonDefItems(taxonTreeDef, taxonItems);
        newObjs.addAll(newItems);
        for (TaxonTreeDefItem item : newItems) {
            if (item.getRankId().equals(180)) {
                item.setFormatToken("%G");
                continue;
            }
            if (item.getRankId().equals(220)) {
                item.setFormatToken("%S");
                continue;
            }
            if (!item.getRankId().equals(230)) continue;
            item.setFormatToken("%SS");
        }
        Taxon life = DataBuilder.createTaxon(taxonTreeDef, null, "Life", 0);
        Taxon Plantae = DataBuilder.createTaxon(taxonTreeDef, life, "Plantae", 10);
        Taxon Magnoliophyta = DataBuilder.createTaxon(taxonTreeDef, Plantae, "Magnoliophyta", 30);
        Taxon Magnoliopsida = DataBuilder.createTaxon(taxonTreeDef, Magnoliophyta, "Magnoliopsida", 60);
        Taxon Sapindales = DataBuilder.createTaxon(taxonTreeDef, Magnoliopsida, "Sapindales", 100);
        Taxon Sapindaceae = DataBuilder.createTaxon(taxonTreeDef, Sapindales, "Sapindaceae", 140);
        Taxon Acer = DataBuilder.createTaxon(taxonTreeDef, Sapindaceae, "Acer", 180);
        newObjs.add(life);
        newObjs.add(Plantae);
        newObjs.add(Magnoliophyta);
        newObjs.add(Magnoliopsida);
        newObjs.add(Sapindales);
        newObjs.add(Sapindaceae);
        newObjs.add(Acer);
        String[] speciesNames = new String[]{"saccharum", "platanoides", "circinatum", "palmatum"};
        String[] commonNames = new String[]{"Sugar Maple", "Norway Maple", "Vine Maple", "apanese Maple"};
        List<Object> kids = DataBuilder.createTaxonChildren(taxonTreeDef, Acer, speciesNames, commonNames, 220);
        newObjs.addAll(kids);
        Taxon Aesculus = DataBuilder.createTaxon(taxonTreeDef, Sapindaceae, "Aesculus", 180);
        newObjs.add(Aesculus);
        String[] speciesNames2 = new String[]{"arguta", "californica", "chinensis", "glabra"};
        String[] commonNames2 = new String[]{"Texas Buckeye", "California Buckeye", "Chinese Horse-chestnut", "Ohio Buckeye"};
        kids = DataBuilder.createTaxonChildren(taxonTreeDef, Aesculus, speciesNames2, commonNames2, 220);
        newObjs.addAll(kids);
        TreeHelper.fixFullnameForNodeAndDescendants(life);
        life.setNodeNumber(1);
        BuildSampleDatabase.fixNodeNumbersFromRoot(life);
        return newObjs;
    }

    public static Journal createJournalsAndReferenceWork() {
        Journal journal = DataBuilder.createJournal("Fish times", "FT");
        ReferenceWork rw = DataBuilder.createReferenceWork((byte)1, "Why Do Fish Have Scales?", "Fish Publishing", "NYC", "12/12/1900", "Vol 1.", "Pages 234-236", null, "112974-4532", true, journal);
        rw = DataBuilder.createReferenceWork((byte)1, "Can Fish think?", "Fish Publishing", "Chicago", "12/12/1901", "Vol 2", "Pages 1-10", null, "64543-4532", true, journal);
        rw = DataBuilder.createReferenceWork((byte)1, "The Taxon Def of Blubber Fish?", "Icthy Publishing", "SFO", "12/12/1960", "Vol 200", "Pages 10-100", null, "856433-4532", false, journal);
        return journal;
    }

    public static int fixNodeNumbersFromRoot(Treeable root) {
        int nextNodeNumber = root.getNodeNumber();
        for (Treeable child : root.getChildren()) {
            child.setNodeNumber(++nextNodeNumber);
            nextNodeNumber = BuildSampleDatabase.fixNodeNumbersFromRoot(child);
        }
        root.setHighestChildNodeNumber(nextNodeNumber);
        return nextNodeNumber;
    }

    public void persist(Object o) {
        if (this.session != null) {
            try {
                this.session.saveOrUpdate(o);
            }
            catch (Exception ex) {
                UIRegistry.showError(ex.toString());
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
    }

    public void persist(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.persist(o);
            ++n2;
        }
    }

    public void persist(List<?> oList) {
        if (oList != null) {
            int max;
            int n = max = this.frame != null ? this.frame.getOrigMax() : 0;
            if (this.frame != null) {
                this.frame.setProcess(0, oList.size());
            }
            int cnt = 0;
            for (Object o : oList) {
                if (this.frame != null) {
                    this.frame.setProcess(++cnt);
                }
                this.persist(o);
            }
            if (this.frame != null) {
                this.frame.setProcess(oList.size());
                this.frame.setOrigMax(max);
            }
        }
    }

    public void startTx() {
        this.trans = this.session.beginTransaction();
    }

    public void commitTx() {
        try {
            if (this.trans == null) {
                throw new RuntimeException("Transaction is null");
            }
            this.trans.commit();
            this.trans = null;
        }
        catch (Exception ex) {
            this.rollbackTx();
            this.trans = null;
            UIRegistry.showError(ex.toString());
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void rollbackTx() {
        if (this.trans == null) {
            throw new RuntimeException("Transaction is null");
        }
        this.trans.rollback();
    }

    public Object getFirstObjectByClass(List<Object> objects, Class<?> clazz) {
        Object ret = null;
        for (Object o : objects) {
            if (o.getClass() != clazz) continue;
            ret = o;
            break;
        }
        return ret;
    }

    public <T> T getObjectByClass(List<?> objects, Class<T> clazz, int index) {
        T ret = null;
        int i = -1;
        for (Object o : objects) {
            if (o.getClass() == clazz) {
                ++i;
            }
            if (i != index) continue;
            ret = (T)o;
            break;
        }
        return ret;
    }

    protected List<?> getObjectsByClass(List<Object> objects, Class<?> clazz) {
        Vector<Object> rightClass = new Vector<Object>();
        for (Object o : objects) {
            if (o.getClass() != clazz) continue;
            rightClass.add(o);
        }
        return rightClass;
    }

    public ProgressFrame createProgressFrame(String title) {
        if (this.frame == null) {
            this.frame = new ProgressFrame(title, "SpecifyLargeIcon");
            this.frame.pack();
        }
        return this.frame;
    }

    public void buildSetup(String[] args) {
        boolean doEmptyBuild = false;
        UIRegistry.setEmbeddedDBPath(UIRegistry.getDefaultEmbeddedDBPath());
        if (args != null && args.length > 0) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                String[] pair = StringUtils.split((String)arg, (String)"=");
                if (pair.length == 2) {
                    String option = pair[0];
                    String value = pair[1];
                    if (option.equals("-Dappdir")) {
                        UIRegistry.setDefaultWorkingPath(value);
                    } else if (option.equals("-Dappdatadir")) {
                        UIRegistry.setBaseAppDataDir(value);
                    } else if (option.equals("-Dembeddeddbdir")) {
                        UIRegistry.setEmbeddedDBPath(value);
                    } else if (option.equals("-Dmobile")) {
                        UIRegistry.setEmbeddedDBPath(UIRegistry.getDefaultMobileEmbeddedDBPath());
                    }
                }
                ++n2;
            }
        }
        if (StringUtils.isEmpty((String)UIRegistry.getAppName())) {
            UIRegistry.setAppName("Specify");
        }
        if (this.hideFrame) {
            System.out.println("Embedded DB Path [ " + UIRegistry.getEmbeddedDBPath() + " ]");
        }
        IconManager.setApplicationClass(Specify.class);
        IconManager.aliasImages("SpBuilder", "AppIcon");
        this.createProgressFrame("Building Specify Database");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
        System.setProperty("edu.ku.brc.af.auth.SecurityMgr", "edu.ku.brc.af.auth.specify.SpecifySecurityMgr");
        AppPrefsCache.setUseLocalOnly(true);
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        localPrefs.load();
        this.backstopPrefs = BuildSampleDatabase.getInitializePrefs(null);
        String driverName = this.backstopPrefs.getProperty("initializer.drivername", "MySQL");
        String databaseName = this.backstopPrefs.getProperty("initializer.databasename", "testfish");
        Properties props = BuildSampleDatabase.getInitializePrefs(databaseName);
        this.initPrefs = props.size() > 0 ? props : this.backstopPrefs;
        Pair<String, String> dbUser = new Pair<String, String>(this.initPrefs.getProperty("initializer.dbUserName", "Specify"), this.initPrefs.getProperty("initializer.dbPassword", "Specify"));
        Pair<String, String> saUser = new Pair<String, String>(this.initPrefs.getProperty("initializer.saUserName", "Master"), this.initPrefs.getProperty("initializer.saPassword", "Master"));
        Pair<String, String> cmUser = new Pair<String, String>(this.initPrefs.getProperty("useragent.username", "testuser"), this.initPrefs.getProperty("useragent.password", "testuser"));
        if (!doEmptyBuild) {
            this.setupDlg = new SetUpBuildDlg(databaseName, driverName, dbUser, saUser, cmUser, this);
            UIHelper.centerAndShow(this.setupDlg);
        }
    }

    protected void startBuild(final String dbName, final String driverName, final Pair<String, String> dbUser, final Pair<String, String> saUser, final Pair<String, String> cmUser, List<CollectionChoice> selectedChoicesArg) {
        AppContextMgr.getInstance().setHasContext(true);
        this.selectedChoices = selectedChoicesArg;
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    BuildSampleDatabase.this.build(dbName, driverName, dbUser, saUser, cmUser);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }

            @Override
            public void finished() {
                BuildSampleDatabase.this.frame.setVisible(false);
                BuildSampleDatabase.this.frame.dispose();
                DBConnection.shutdown();
                System.exit(0);
            }
        };
        worker.start();
    }

    public static boolean createSpecifySAUser(String hostName, String itUsername, String itPassword, String saUsername, String saPassword, String databaseName) {
        DBMSUserMgr mgr = DBMSUserMgr.getInstance();
        mgr.setHostName(hostName);
        boolean isOK = false;
        isOK = mgr.connectToDBMS(itUsername, itPassword, hostName) ? (!mgr.doesUserExists(saUsername) ? mgr.createUser(saUsername, saPassword, databaseName, 31) : true) : false;
        mgr.close();
        return isOK;
    }

    public boolean buildEmptyDatabase(Properties props, boolean doFromWizard) {
        String dbName;
        block16: {
            String connStr;
            String itPassword;
            String itUsername;
            DatabaseDriverInfo driverInfo;
            block15: {
                this.createProgressFrame("Building Specify Database");
                dbName = props.getProperty("dbName");
                this.frame.adjustProgressFrame();
                this.frame.setTitle("Building Specify Database");
                if (!this.hideFrame) {
                    UIHelper.centerWindow(this.frame);
                    this.frame.setVisible(true);
                    ImageIcon imgIcon = IconManager.getIcon("AppIcon", IconManager.IconSize.Std16);
                    if (imgIcon != null) {
                        this.frame.setIconImage(imgIcon.getImage());
                    }
                } else {
                    System.out.println("Building Specify Database Username[" + props.getProperty("dbUserName") + "]");
                }
                this.frame.setProcessPercent(true);
                this.frame.setOverall(0, 4);
                this.frame.getCloseBtn().setVisible(false);
                this.steps = 0;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BuildSampleDatabase.this.frame.getProcessProgress().setIndeterminate(true);
                        BuildSampleDatabase.this.frame.getProcessProgress().setString("");
                        BuildSampleDatabase.this.frame.setDesc("Creating Database Schema for " + dbName);
                        BuildSampleDatabase.this.frame.setOverall(BuildSampleDatabase.this.steps++);
                    }
                });
                driverInfo = (DatabaseDriverInfo)props.get("driver");
                try {
                    if (this.hideFrame) {
                        System.out.println("Creating schema");
                    }
                    itUsername = props.getProperty("dbUserName");
                    itPassword = props.getProperty("dbPassword");
                    boolean doBuild = true;
                    if (doBuild) {
                        SpecifySchemaGenerator.generateSchema(driverInfo, props.getProperty("hostName"), dbName, itUsername, itPassword);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BuildSampleDatabase.this.frame.getProcessProgress().setIndeterminate(true);
                            BuildSampleDatabase.this.frame.getProcessProgress().setString("");
                            BuildSampleDatabase.this.frame.setDesc("Logging into " + dbName + "....");
                            BuildSampleDatabase.this.frame.setOverall(BuildSampleDatabase.this.steps++);
                        }
                    });
                    connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Create, props.getProperty("hostName"), dbName);
                    if (connStr == null) {
                        connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, props.getProperty("hostName"), dbName);
                    }
                    if (UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, connStr, itUsername, itPassword)) break block15;
                    if (this.hideFrame) {
                        System.out.println("Login Failed!");
                    }
                    return false;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            String saUserName = props.getProperty("saUserName");
            String saPassword = props.getProperty("saPassword");
            BuildSampleDatabase.createSpecifySAUser(props.getProperty("hostName"), itUsername, itPassword, saUserName, saPassword, dbName);
            if (UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, connStr, saUserName, saPassword)) break block16;
            if (this.hideFrame) {
                System.out.println("Login Failed!");
            }
            return false;
        }
        this.setSession(HibernateUtil.getCurrentSession());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BuildSampleDatabase.this.frame.getProcessProgress().setIndeterminate(true);
                BuildSampleDatabase.this.frame.getProcessProgress().setString("");
                BuildSampleDatabase.this.frame.setDesc("Creating database " + dbName + "....");
                BuildSampleDatabase.this.frame.setOverall(BuildSampleDatabase.this.steps++);
            }
        });
        Thumbnailer thumb = new Thumbnailer();
        File thumbFile = XMLHelper.getConfigDir("thumbnail_generators.xml");
        thumb.registerThumbnailers(thumbFile);
        thumb.setQuality(0.5f);
        thumb.setMaxHeight(128);
        thumb.setMaxWidth(128);
        File attLoc = UIRegistry.getAppDataSubDir("AttachmentStorage", true);
        FileUtils.cleanDirectory((File)attLoc);
        FileStoreAttachmentManager attachMgr = new FileStoreAttachmentManager(attLoc);
        AttachmentUtils.setAttachmentManager(attachMgr);
        AttachmentUtils.setThumbnailer(thumb);
        if (this.hideFrame) {
            System.out.println("Creating Empty Database");
        }
        this.createEmptyInstitution(props, true, true, doFromWizard);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BuildSampleDatabase.this.frame.getProcessProgress().setIndeterminate(true);
                BuildSampleDatabase.this.frame.getProcessProgress().setString("");
                BuildSampleDatabase.this.frame.setDesc("Saving data into " + dbName + "....");
                BuildSampleDatabase.this.frame.setOverall(BuildSampleDatabase.this.steps++);
            }
        });
        if (this.hideFrame) {
            System.out.println("Persisting Data...");
        }
        HibernateUtil.getCurrentSession().close();
        if (this.hideFrame) {
            System.out.println("Done.");
        }
        this.frame.setVisible(false);
        this.frame.dispose();
        SpecifyDeleteHelper.showTableCounts("EmptyDB.txt", true);
        return true;
    }

    protected void persistDataObjects(List<?> dataObjects) {
        log.info((Object)"Persisting in-memory objects to DB");
        this.frame.setProcess(0);
        this.frame.getProcessProgress().setIndeterminate(true);
        this.frame.getProcessProgress().setString("");
        this.frame.setDesc("Getting Session...");
        this.frame.setOverall(this.steps++);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BuildSampleDatabase.this.frame.setDesc("Saving data...");
                BuildSampleDatabase.this.frame.setOverall(BuildSampleDatabase.this.steps++);
            }
        });
        this.startTx();
        this.persist(dataObjects);
        this.commitTx();
    }

    protected void build(final String dbName, String driverName, Pair<String, String> dbUser, Pair<String, String> saUser, Pair<String, String> cmUser) throws SQLException {
        this.frame.setDefaultCloseOperation(2);
        this.frame.pack();
        Dimension size = this.frame.getSize();
        size.width = Math.max(size.width, 500);
        this.frame.setSize(size);
        this.frame.setTitle("Building Specify Database");
        if (!this.hideFrame) {
            UIHelper.centerWindow(this.frame);
            this.frame.setVisible(true);
            ImageIcon imgIcon = IconManager.getIcon("AppIcon", IconManager.IconSize.Std16);
            if (imgIcon != null) {
                this.frame.setIconImage(imgIcon.getImage());
            }
        }
        this.frame.setProcessPercent(true);
        this.frame.setOverall(0, 7 + this.selectedChoices.size());
        this.frame.getCloseBtn().setVisible(false);
        String databaseHost = this.initPrefs.getProperty("initializer.host", "localhost");
        this.frame.setTitle("Building -> Database: " + dbName + " Driver: " + driverName + " User: " + (String)cmUser.first);
        this.steps = 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BuildSampleDatabase.this.frame.getProcessProgress().setIndeterminate(true);
                BuildSampleDatabase.this.frame.getProcessProgress().setString("");
                BuildSampleDatabase.this.frame.setDesc("Creating Database Schema for " + dbName);
                BuildSampleDatabase.this.frame.setOverall(BuildSampleDatabase.this.steps++);
            }
        });
        DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver(driverName);
        if (driverInfo == null) {
            String msg = "Couldn't find driver by name [" + driverInfo + "] in driver list.";
            UIRegistry.showError(msg);
            throw new RuntimeException(msg);
        }
        String newConnStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHost, dbName, (String)saUser.first, (String)saUser.second, driverInfo.getName());
        DBConnection.checkForEmbeddedDir(newConnStr);
        if (DBConnection.isEmbedded(newConnStr)) {
            try {
                Class.forName(driverInfo.getDriverClassName());
                DBConnection testDB = DBConnection.createInstance(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, newConnStr, (String)saUser.first, (String)saUser.second);
                testDB.getConnection();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            DBConnection.getInstance().setDatabaseName(null);
        }
        SpecifySchemaGenerator.generateSchema(driverInfo, databaseHost, dbName, (String)dbUser.first, (String)dbUser.second);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BuildSampleDatabase.this.frame.setDesc("Logging in...");
                BuildSampleDatabase.this.frame.setOverall(BuildSampleDatabase.this.steps++);
            }
        });
        if (UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHost, dbName), (String)saUser.first, (String)saUser.second)) {
            BuildSampleDatabase.createSpecifySAUser(databaseHost, (String)dbUser.first, (String)dbUser.second, (String)saUser.first, (String)saUser.second, dbName);
            boolean single = true;
            if (single) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BuildSampleDatabase.this.frame.setDesc("Creating data...");
                        BuildSampleDatabase.this.frame.setOverall(BuildSampleDatabase.this.steps++);
                    }
                });
                try {
                    Thumbnailer thumb = new Thumbnailer();
                    File thumbFile = XMLHelper.getConfigDir("thumbnail_generators.xml");
                    thumb.registerThumbnailers(thumbFile);
                    thumb.setQuality(0.5f);
                    thumb.setMaxHeight(128);
                    thumb.setMaxWidth(128);
                    this.frame.setDesc("Cleaning Attachment Cache...");
                    this.frame.setOverall(this.steps++);
                    File attLoc = UIRegistry.getAppDataSubDir("AttachmentStorage", true);
                    try {
                        FileUtils.cleanDirectory((File)attLoc);
                    }
                    catch (IOException e) {
                        String msg = "failed to connect to directory location to delete directory: " + attLoc;
                        log.warn((Object)msg);
                        UIRegistry.showError(msg);
                    }
                    FileStoreAttachmentManager attachMgr = new FileStoreAttachmentManager(attLoc);
                    AttachmentUtils.setAttachmentManager(attachMgr);
                    AttachmentUtils.setThumbnailer(thumb);
                    this.setSession(HibernateUtil.getCurrentSession());
                    this.createDisciplines((String)cmUser.first, (String)cmUser.second);
                    attachMgr.cleanup();
                    this.frame.setDesc("Done Saving data...");
                    this.frame.setOverall(this.steps++);
                    this.frame.setDesc("Copying Preferences...");
                    this.frame.setOverall(this.steps++);
                    AppPreferences remoteProps = AppPreferences.getRemote();
                    for (Object key : this.initPrefs.keySet()) {
                        String keyStr = (String)key;
                        if (keyStr.startsWith("initializer.") || keyStr.startsWith("useragent.")) continue;
                        remoteProps.put(keyStr, (String)this.initPrefs.get(key));
                    }
                    AppPreferences.getRemote().flush();
                    this.frame.setDesc("Build Completed.");
                    this.frame.setOverall(this.steps++);
                    BuildSampleDatabase.assignPermssions();
                    log.info((Object)"Done");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        this.rollbackTx();
                        log.error((Object)"Failed to persist DB objects", (Throwable)e);
                        UIRegistry.showError("Failed to persist DB objects");
                        return;
                    }
                    catch (Exception e2) {
                        log.error((Object)"Failed to persist DB objects.  Rollback failed.  DB may be in inconsistent state.", (Throwable)e2);
                        UIRegistry.showError("Failed to persist DB objects. Rollback failed.");
                        return;
                    }
                }
            }
        } else {
            log.error((Object)"Login failed");
            UIRegistry.showError("Login failed");
            return;
        }
        System.out.println("All done");
        if (this.frame != null) {
            this.frame.processDone();
        }
        String schemaKey = "schemaSize";
        int schemaFileSize = 0;
        File schemaFile = XMLHelper.getConfigDir("specify_datamodel.xml");
        if (schemaFile != null) {
            schemaFileSize = (int)schemaFile.length();
            AppPreferences.getLocalPrefs().putInt(schemaKey, schemaFileSize);
        }
        JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), "The build completed successfully.", "Complete", 1);
    }

    public static void assignPermssions() {
    }

    public static void turnOnHibernateLogging(Level level) {
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            Logger logger = (Logger)e.nextElement();
            if (!StringUtils.contains((String)logger.getName(), (String)"hibernate")) continue;
            logger.setLevel(level);
        }
    }

    public static Properties getInitializePrefs(String databaseName) {
        Properties properties = new Properties();
        try {
            String base = UIRegistry.getDefaultWorkingPath();
            File initFile = new File(String.valueOf(base) + File.separator + (databaseName != null ? String.valueOf(databaseName) + "_" : "") + "init.prefs");
            if (initFile.exists()) {
                properties.load(new FileInputStream(initFile));
                return properties;
            }
            log.debug((Object)("Couldn't find Init Prefs [" + initFile.getAbsolutePath() + "]"));
        }
        catch (Exception ex) {
            ExceptionTracker.getInstance().capture(BuildSampleDatabase.class, ex);
            System.err.println(ex);
        }
        return new Properties();
    }

    public static void loadLocalization(String tableName, SpLocaleContainerItem memoryItemArg, SpLocaleContainerItem newItem, SpLocaleContainerItem dispItem, boolean hideGenericFields, boolean isFish) {
        SpLocaleContainerItem memoryItem = dispItem != null ? dispItem : memoryItemArg;
        String itemName = memoryItem.getName();
        newItem.setName(itemName);
        newItem.setType(memoryItem.getType());
        newItem.setFormat(memoryItem.getFormat());
        newItem.setIsUIFormatter(memoryItem.getIsUIFormatter());
        newItem.setPickListName(memoryItem.getPickListName());
        newItem.setWebLinkName(memoryItem.getWebLinkName());
        newItem.setIsHidden(memoryItem.getIsHidden());
        newItem.setIsRequired(memoryItem.getIsRequired());
        BuildSampleDatabase.mergeOrCreateStr(memoryItem, newItem, isFish);
        if (newItem.getId() == null) {
            BuildSampleDatabase.setParentForItemStrs(newItem.getNames(), newItem, true);
            BuildSampleDatabase.setParentForItemStrs(newItem.getDescs(), newItem, false);
        }
    }

    protected static void setParentForItemStrs(Set<SpLocaleItemStr> strItems, SpLocaleContainerItem item, boolean isForNames) {
        for (SpLocaleItemStr str : strItems) {
            if (isForNames) {
                str.setItemName(item);
                continue;
            }
            str.setItemDesc(item);
        }
    }

    protected static void setParentForContainerStrs(Set<SpLocaleItemStr> strItems, SpLocaleContainer container, boolean isForNames) {
        for (SpLocaleItemStr str : strItems) {
            if (isForNames) {
                str.setContainerName(container);
                continue;
            }
            str.setContainerDesc(container);
        }
    }

    protected static HashMap<String, SpLocaleItemStr> makeHash(Set<SpLocaleItemStr> strItems) {
        HashMap<String, SpLocaleItemStr> strHash = new HashMap<String, SpLocaleItemStr>();
        for (SpLocaleItemStr nm : strItems) {
            strHash.put(nm.getLanguage(), nm);
        }
        return strHash;
    }

    protected static void mergeOrCreateStr(SpLocaleBase memBase, SpLocaleBase dbBase, boolean isFish) {
        SpLocaleItemStr str;
        String lang;
        HashMap<String, SpLocaleItemStr> namesHash = null;
        HashMap<String, SpLocaleItemStr> descsHash = null;
        if (dbBase != null && dbBase.getId() != null) {
            namesHash = BuildSampleDatabase.makeHash(dbBase.getNamesSet());
            descsHash = BuildSampleDatabase.makeHash(dbBase.getDescsSet());
        }
        for (SpLocaleItemStr nm : memBase.getNamesSet()) {
            lang = nm.getLanguage();
            str = null;
            if (namesHash != null) {
                str = namesHash.get(lang);
            }
            if (str == null) {
                str = new SpLocaleItemStr();
                str.initialize();
            }
            String title = nm.getText();
            if (!isFish && title.equals("Collecting Event")) {
                title = "Collecting Information";
            } else if (memBase.getName().equals("taxononly")) {
                title = UIRegistry.getResourceString("WB_TAXONIMPORT_ONLY");
            }
            str.setText(title);
            if (debugOn) {
                System.out.println(nm.getText());
            }
            str.setLanguage(nm.getLanguage());
            str.setCountry(nm.getCountry());
            str.setVariant(nm.getVariant());
            if (dbBase == null || str.getId() != null) continue;
            dbBase.getNamesSet().add(str);
            if (dbBase instanceof SpLocaleContainer) {
                str.setContainerName((SpLocaleContainer)dbBase);
                continue;
            }
            str.setItemName((SpLocaleContainerItem)dbBase);
        }
        for (SpLocaleItemStr desc : memBase.getDescsSet()) {
            lang = desc.getLanguage();
            str = null;
            if (descsHash != null) {
                str = descsHash.get(lang);
            }
            if (str == null) {
                str = new SpLocaleItemStr();
                str.initialize();
            }
            str.setText(desc.getText());
            str.setLanguage(desc.getLanguage());
            str.setCountry(desc.getCountry());
            str.setVariant(desc.getVariant());
            if (dbBase == null || str.getId() != null) continue;
            dbBase.getDescsSet().add(str);
            if (dbBase instanceof SpLocaleContainer) {
                str.setContainerDesc((SpLocaleContainer)dbBase);
                continue;
            }
            str.setItemDesc((SpLocaleContainerItem)dbBase);
        }
    }

    private static void loadLocalization(Integer disciplineId, String disciplineName, SpLocaleContainer memoryContainer, SpLocaleContainer newContainer, boolean hideGenericFields, String catFmtName, String accFmtName, UpdateType updateType, DataProviderSessionIFace session) {
        boolean doDBUpdate;
        boolean isColObj = memoryContainer.getName().equals("collectionobject");
        boolean isAccession = memoryContainer.getName().equals("accession");
        boolean isFish = disciplineName.equals("fish");
        boolean isImport = updateType == UpdateType.eImport;
        boolean isMerge = updateType == UpdateType.eMerge;
        boolean isLocalize = updateType == UpdateType.eLocalize;
        boolean bl = doDBUpdate = isLocalize || isImport;
        if (newContainer.getId() == null) {
            newContainer.setName(memoryContainer.getName());
            newContainer.setType(memoryContainer.getType());
            newContainer.setFormat(newContainer.getFormat());
            newContainer.setIsUIFormatter(newContainer.getIsUIFormatter());
            newContainer.setPickListName(newContainer.getPickListName());
            newContainer.setWebLinkName(newContainer.getWebLinkName());
            newContainer.setIsHidden(newContainer.getIsHidden());
            if (session != null) {
                try {
                    session.saveOrUpdate(newContainer);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        BuildSampleDatabase.mergeOrCreateStr(memoryContainer, newContainer, isFish);
        if (newContainer.getId() == null) {
            BuildSampleDatabase.setParentForContainerStrs(newContainer.getNames(), newContainer, true);
            BuildSampleDatabase.setParentForContainerStrs(newContainer.getDescs(), newContainer, false);
        }
        if (session != null) {
            try {
                session.saveOrUpdate(newContainer);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Hashtable<String, SpLocaleContainerItem> dispItemHash = new Hashtable<String, SpLocaleContainerItem>();
        if (SchemaI18NService.getCurrentLocale().getLanguage().equals("en") && memoryContainer instanceof DisciplineBasedContainer) {
            DisciplineBasedContainer dbc = (DisciplineBasedContainer)memoryContainer;
            Set<SpLocaleContainerItem> itemsSet = dbc.getDisciplineItems(disciplineName);
            for (SpLocaleContainerItem item : itemsSet) {
                dispItemHash.put(item.getName(), item);
            }
        }
        for (SpLocaleContainerItem item : memoryContainer.getItems()) {
            Integer id;
            String sql;
            String fullSQL;
            int cnt;
            String itemSQL = null;
            boolean okToCreate = true;
            if ((isImport || isMerge || isLocalize) && (cnt = BasicSQLUtils.getCountAsInt(fullSQL = "SELECT COUNT(*)" + (sql = String.format(" FROM splocalecontainer c INNER JOIN splocalecontaineritem ci ON c.SpLocaleContainerID = ci.SpLocaleContainerID WHERE ci.Name = '%s' AND c.DisciplineID = %d AND c.SpLocaleContainerID = %d", item.getName(), disciplineId, newContainer.getId())))) > 0) {
                okToCreate = false;
                if (cnt == 1) {
                    itemSQL = "SELECT ci.SpLocaleContainerItemID" + sql;
                }
            }
            if (okToCreate) {
                SpLocaleContainerItem newItem = new SpLocaleContainerItem();
                newItem.initialize();
                newContainer.getItems().add(newItem);
                newItem.setContainer(newContainer);
                SpLocaleContainerItem dispItem = (SpLocaleContainerItem)dispItemHash.get(item.getName());
                BuildSampleDatabase.loadLocalization(memoryContainer.getName(), item, newItem, dispItem, hideGenericFields, isFish);
                if (!isLocalize) {
                    if (isColObj && catFmtName != null && item.getName().equals("catalogNumber")) {
                        newItem.setFormat(catFmtName);
                        newItem.setIsUIFormatter(true);
                    }
                    if (isAccession && accFmtName != null && item.getName().equals("accessionNumber")) {
                        newItem.setFormat(accFmtName);
                        newItem.setIsUIFormatter(true);
                    }
                }
                if (session == null) continue;
                try {
                    session.saveOrUpdate(newItem);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (itemSQL == null || isMerge || (id = BasicSQLUtils.getCount(itemSQL)) == null) continue;
            SpLocaleContainerItem dbItem = session.get(SpLocaleContainerItem.class, id);
            if (!isLocalize) {
                dbItem.setFormat(item.getFormat());
                dbItem.setIsUIFormatter(item.getIsUIFormatter());
                dbItem.setPickListName(item.getPickListName());
                dbItem.setWebLinkName(item.getWebLinkName());
                dbItem.setIsHidden(item.getIsHidden());
                dbItem.setIsRequired(item.getIsRequired());
            }
            try {
                if (!doDBUpdate) {
                    session.beginTransaction();
                }
                BuildSampleDatabase.setItemStrs(dbItem, true, dbItem.getNames(), item.getNames(), session);
                BuildSampleDatabase.setItemStrs(dbItem, false, dbItem.getDescs(), item.getDescs(), session);
                session.saveOrUpdate(dbItem);
                if (doDBUpdate) continue;
                session.commit();
            }
            catch (Exception e) {
                if (!isImport) {
                    session.rollback();
                }
                e.printStackTrace();
            }
        }
    }

    private static String mkKey(SpLocaleItemStr item) {
        return String.format("%s %s %s", item.getLanguage(), item.getCountry() != null ? item.getCountry() : "", item.getVariant() != null ? item.getVariant() : "");
    }

    private static void setItemStrs(SpLocaleContainerItem dbItem, boolean isName, Set<SpLocaleItemStr> dbSet, Set<SpLocaleItemStr> memSet, DataProviderSessionIFace session) throws Exception {
        HashMap<String, SpLocaleItemStr> hash = new HashMap<String, SpLocaleItemStr>();
        for (SpLocaleItemStr dbItemStr : dbSet) {
            hash.put(BuildSampleDatabase.mkKey(dbItemStr), dbItemStr);
        }
        for (SpLocaleItemStr memItem : memSet) {
            String txt;
            SpLocaleItemStr dbItmStr = (SpLocaleItemStr)hash.get(BuildSampleDatabase.mkKey(memItem));
            if (dbItmStr == null) {
                dbItmStr = new SpLocaleItemStr();
                dbItmStr.initialize();
                dbSet.add(dbItmStr);
                if (isName) {
                    dbItmStr.setItemName(dbItem);
                } else {
                    dbItmStr.setItemDesc(dbItem);
                }
            }
            String memText = memItem.getText();
            String dbText = dbItmStr.getText();
            boolean doUpdate = dbItmStr.getId() == null || memText == null && dbText != null || memText != null && dbText == null || memText != null && dbText != null && !memText.equals(dbText);
            String string = txt = doUpdate ? memText : dbText;
            if (txt == null) {
                txt = "";
            }
            dbItmStr.setText(txt);
            dbItmStr.setLanguage(memItem.getLanguage());
            dbItmStr.setCountry(memItem.getCountry());
            dbItmStr.setVariant(memItem.getVariant());
            if (!doUpdate) continue;
            session.saveOrUpdate(dbItmStr);
        }
    }

    public void loadSchemaLocalization(Discipline discipline, Byte schemaType, DBTableIdMgr tableMgr, String catFmtName, String accFmtName) {
        this.loadSchemaLocalization(discipline, schemaType, tableMgr, catFmtName, accFmtName, UpdateType.eBuildNew, null, null, null);
    }

    public void loadSchemaLocalization(Discipline discipline, Byte schemaType, DBTableIdMgr tableMgr, String catFmtName, String accFmtName, UpdateType updateType, DataProviderSessionIFace sessionArg) {
        this.loadSchemaLocalization(discipline, schemaType, tableMgr, catFmtName, accFmtName, updateType, null, null, sessionArg);
    }

    public boolean loadSchemaLocalization(Discipline discipline, Byte schemaType, DBTableIdMgr tableMgr, String catFmtName, String accFmtName, UpdateType updateType, File externalFile, SimpleGlassPane glassPane, DataProviderSessionIFace sessionArg) {
        List<Locale> availLocales;
        boolean isUpdate = updateType == UpdateType.eImport || updateType == UpdateType.eMerge;
        boolean isLocalize = updateType == UpdateType.eLocalize;
        boolean isImportOrLocalize = updateType == UpdateType.eImport || updateType == UpdateType.eLocalize;
        HiddenTableMgr hiddenTableMgr = new HiddenTableMgr();
        SchemaLocalizerXMLHelper schemaLocalizer = new SchemaLocalizerXMLHelper(schemaType, tableMgr);
        if (!schemaLocalizer.loadWithExternalFile(externalFile, !isImportOrLocalize)) {
            return false;
        }
        boolean hideGenericFields = true;
        String dispName = discipline.getType().toString();
        if (isLocalize && (availLocales = schemaLocalizer.getAvailLocales()).size() > 1) {
            UIRegistry.displayErrorDlgLocalized("BSD.TOOMANYLOCALES", new Object[0]);
            return false;
        }
        float progressCnt = 0.0f;
        float len = schemaLocalizer.getSpLocaleContainers().size();
        for (SpLocaleContainer spLocaleContainer : schemaLocalizer.getSpLocaleContainers()) {
            String sql;
            String fullSQL;
            int cnt;
            progressCnt += 1.0f;
            if (glassPane != null) {
                glassPane.setProgress((int)((double)(progressCnt / len) * 100.0));
            }
            Integer spcId = null;
            boolean okToCreate = true;
            if ((isUpdate || isLocalize) && (cnt = BasicSQLUtils.getCountAsInt(fullSQL = "SELECT COUNT(*)" + (sql = String.format(" FROM splocalecontainer WHERE Name = '%s' AND SchemaType = %d AND DisciplineID = %d", spLocaleContainer.getName(), schemaType, discipline.getId())))) > 0) {
                okToCreate = false;
                fullSQL = "SELECT SpLocaleContainerID" + sql;
                spcId = BasicSQLUtils.getCount(fullSQL);
            }
            SpLocaleContainer container = null;
            if (okToCreate) {
                container = new SpLocaleContainer();
                container.initialize();
                container.setName(spLocaleContainer.getName());
                container.setType(spLocaleContainer.getType());
                container.setSchemaType(schemaType);
                container.setDiscipline(discipline);
                container.setIsHidden(hiddenTableMgr.isHidden(discipline.getType(), spLocaleContainer.getName()));
                if (sessionArg != null) {
                    try {
                        sessionArg.saveOrUpdate(container);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
            } else {
                container = (SpLocaleContainer)sessionArg.getData("FROM SpLocaleContainer WHERE id = " + spcId);
            }
            BuildSampleDatabase.loadLocalization(discipline.getId(), dispName, spLocaleContainer, container, hideGenericFields, catFmtName, accFmtName, updateType, sessionArg);
            if (!okToCreate) continue;
            discipline.getSpLocaleContainers().add(container);
            container.setDiscipline(discipline);
        }
        return true;
    }

    public void createPickLists(Discipline discipline, Collection collection, Agent userAgent, Byte schemaType, DBTableIdMgr tableMgr) {
        SchemaLocalizerXMLHelper schemaLocalizer = new SchemaLocalizerXMLHelper(schemaType, tableMgr);
        for (PickList pl : schemaLocalizer.getPickLists(discipline.getType())) {
            pl.setCreatedByAgent(userAgent);
            pl.setCollection(collection);
            this.persist((Object)pl);
        }
    }

    public static void doShowHideTablesAndFields(String disciplineDirName, Discipline discipline) {
        block23: {
            String showFieldsFileName = "show_fields.xml";
            String dirName = disciplineDirName != null ? String.valueOf(disciplineDirName) + File.separator : "";
            String filePath = XMLHelper.getConfigDirPath(String.valueOf(dirName) + "show_fields.xml");
            File showFieldsFile = new File(filePath);
            if (showFieldsFile.exists()) {
                Connection conn = DBConnection.getInstance().getConnection();
                PreparedStatement tblStmt = null;
                PreparedStatement fldStmt = null;
                try {
                    try {
                        tblStmt = conn.prepareStatement("UPDATE splocalecontainer SET IsHidden=? WHERE DisciplineID = ? AND Name = ?");
                        fldStmt = conn.prepareStatement("UPDATE splocalecontaineritem SET IsHidden=? WHERE SpLocaleContainerItemID = ?");
                        Element root = XMLHelper.readDOMFromConfigDir(String.valueOf(dirName) + "show_fields.xml");
                        if (root == null) break block23;
                        StringBuilder sb = new StringBuilder("In show_fields.xml there were the following errors:\n");
                        boolean isErr = false;
                        List tables = root.selectNodes("/tables/table");
                        for (Element table : tables) {
                            String tName = XMLHelper.getAttr(table, NAME, null);
                            boolean isShwTbl = XMLHelper.getAttr(table, SHOW, true);
                            String doSetTbl = XMLHelper.getAttr(table, SHOW, null);
                            if (!StringUtils.isNotEmpty((String)tName)) continue;
                            DBTableInfo tbl = DBTableIdMgr.getInstance().getInfoByTableName(tName.toLowerCase());
                            if (tbl != null) {
                                if (StringUtils.isNotEmpty((String)doSetTbl)) {
                                    tblStmt.setBoolean(1, !isShwTbl);
                                    tblStmt.setInt(2, discipline.getId());
                                    tblStmt.setString(3, tName);
                                    tblStmt.executeUpdate();
                                }
                                List fields = table.selectNodes("field");
                                for (Element fieldEl : fields) {
                                    String fName = XMLHelper.getAttr(fieldEl, NAME, null);
                                    boolean isShown = XMLHelper.getAttr(fieldEl, SHOW, true);
                                    if (!StringUtils.isNotEmpty((String)fName)) continue;
                                    DBTableChildIFace childInfo = tbl.getItemByName(fName);
                                    if (childInfo != null) {
                                        String sql = String.format("SELECT ci.SpLocaleContainerItemID FROM splocalecontainer AS c INNER Join splocalecontaineritem AS ci ON c.SpLocaleContainerID = ci.SpLocaleContainerID WHERE ci.Name = '%s' AND c.Name = '%s' AND c.DisciplineID = %d", fName, tName, discipline.getId());
                                        Integer id = BasicSQLUtils.getCount(sql);
                                        if (id != null) {
                                            fldStmt.setBoolean(1, !isShown);
                                            fldStmt.setInt(2, id);
                                            fldStmt.executeUpdate();
                                            continue;
                                        }
                                        sb.append("Unable to find [" + disciplineDirName + "] for table name [" + tName + "] has bad field name[" + fName + "]\n");
                                        continue;
                                    }
                                    sb.append("[" + disciplineDirName + "] for table name [" + tName + "] has bad field name[" + fName + "]\n");
                                    isErr = true;
                                }
                                continue;
                            }
                            sb.append("[" + disciplineDirName + "] has bad table name [" + tName + "]\n");
                            isErr = true;
                        }
                        if (isErr) {
                            UIRegistry.showError(sb.toString());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        ExceptionTracker.getInstance().capture(BuildSampleDatabase.class, ex);
                        try {
                            if (tblStmt != null) {
                                tblStmt.close();
                            }
                            if (fldStmt != null) {
                                fldStmt.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    try {
                        if (tblStmt != null) {
                            tblStmt.close();
                        }
                        if (fldStmt != null) {
                            fldStmt.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void makeFieldVisible(String disciplineDirName, Discipline discipline) {
        Element root;
        String showFieldsFileName = "show_fields.xml";
        String dirName = disciplineDirName != null ? String.valueOf(disciplineDirName) + File.separator : "";
        String filePath = XMLHelper.getConfigDirPath(String.valueOf(dirName) + "show_fields.xml");
        File showFieldsFile = new File(filePath);
        if (showFieldsFile.exists() && (root = XMLHelper.readDOMFromConfigDir(String.valueOf(dirName) + "show_fields.xml")) != null) {
            List tables = root.selectNodes("/tables/table");
            for (Element table : tables) {
                String tName = XMLHelper.getAttr(table, "name", null);
                if (!StringUtils.isNotEmpty((String)tName)) continue;
                DBTableInfo tbl = DBTableIdMgr.getInstance().getInfoByTableName(tName.toLowerCase());
                if (tbl != null) {
                    List fields = table.selectNodes("field");
                    for (Element fieldEl : fields) {
                        String fName = XMLHelper.getAttr(fieldEl, "name", null);
                        if (!StringUtils.isNotEmpty((String)fName)) continue;
                        DBFieldInfo fld = tbl.getFieldByName(fName);
                        if (fld != null) {
                            BuildSampleDatabase.setFieldVisible(tbl.getName(), fld.getName(), discipline);
                            continue;
                        }
                        UIRegistry.showError("show_list.xml in [" + disciplineDirName + "] for table name [" + tName + "] has bad field name[" + fName + "]");
                    }
                    continue;
                }
                UIRegistry.showError("show_list.xml in [" + disciplineDirName + "] has bad table name [" + tName + "]");
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void setFieldVisible(String tableName, String fieldName, Discipline discipline) {
        localSession = null;
        try {
            localSession = DataProviderFactory.getInstance().createSession();
            sql = "FROM SpLocaleContainer as sp INNER JOIN sp.discipline as d WHERE sp.name = '" + tableName + "' AND d.id = " + discipline.getId();
            cols = (Object[])localSession.getData(sql);
            if (cols == null || cols.length <= 0) ** GOTO lbl-1000
            container = (SpLocaleContainer)cols[0];
            if (container == null) return;
            var8_8 = container.getItems().iterator();
            if (true) ** GOTO lbl22
lbl-1000:
            // 1 sources

            {
                System.err.println("Couldn't find Table [" + tableName + "] for discipline[" + discipline.getId() + "]");
                return;
                do {
                    if ((item = var8_8.next()).getName().equals(fieldName)) {
                        item.setIsHidden(false);
                        localSession.beginTransaction();
                        localSession.save(item);
                        localSession.commit();
                        localSession.flush();
                        return;
                    }
lbl22:
                    // 3 sources

                    ** try [egrp 2[TRYBLOCK] [1 : 167->225)] { 
lbl23:
                    // 1 sources

                } while (var8_8.hasNext());
                return;
            }
        }
lbl25:
        // 2 sources

        catch (Exception ex) {
            ex.printStackTrace();
            ExceptionTracker.getInstance().capture(BuildSampleDatabase.class, ex);
            return;
        }
        finally {
            if (localSession != null) {
                localSession.close();
            }
        }
    }

    public static void main(final String[] args) {
        System.setProperty(DBMSUserMgr.factoryName, "edu.ku.brc.dbsupport.MySQLDMBSUserMgr");
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
        new HiddenTableMgr();
        try {
            if (!System.getProperty("os.name").equals("Mac OS X")) {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((String)UIRegistry.getAppName())) {
            UIRegistry.setAppName("Specify");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BuildSampleDatabase builder = new BuildSampleDatabase();
                builder.buildSetup(args);
            }
        });
    }

    public HashSet<String> getColumnNamesFromXLS(String fileName, boolean doUserProvidedFile) {
        File file = TaxonLoadSetupPanel.getFileForTaxon(fileName, doUserProvidedFile);
        if (file == null) {
            return null;
        }
        HashSet<String> nameHash = new HashSet<String>();
        try {
            String[] cells = new String[35];
            FileInputStream input = new FileInputStream(file);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)input);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            HSSFSheet sheet = workBook.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            rows = sheet.rowIterator();
            if (rows.hasNext()) {
                int i = 0;
                while (i < cells.length) {
                    cells[i] = null;
                    ++i;
                }
                HSSFRow row = (HSSFRow)rows.next();
                Iterator cellsIter = row.cellIterator();
                while (cellsIter.hasNext()) {
                    HSSFCell cell = (HSSFCell)cellsIter.next();
                    if (cell == null) continue;
                    nameHash.add(StringUtils.trim((String)cell.getRichStringCellValue().getString()));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return nameHash;
    }

    public String getXLSCellValueAsStr(HSSFCell cell) {
        String value = null;
        if (cell == null) {
            value = "";
        } else {
            switch (cell.getCellType()) {
                case 0: {
                    if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                        DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
                        SimpleDateFormat simpDateFmt = scrDateFormat != null && scrDateFormat.getSimpleDateFormat() != null ? scrDateFormat.getSimpleDateFormat() : this.sdf;
                        value = simpDateFmt.format(cell.getDateCellValue());
                        break;
                    }
                    double numeric = cell.getNumericCellValue();
                    value = this.numFmt.format(numeric);
                    break;
                }
                case 1: {
                    value = cell.getRichStringCellValue().getString();
                    break;
                }
                case 3: {
                    value = "";
                    break;
                }
                case 4: {
                    value = Boolean.toString(cell.getBooleanCellValue());
                    break;
                }
                default: {
                    value = "";
                    log.error((Object)("unsuported cell type[" + cell.getCellType() + "]"));
                }
            }
        }
        return value;
    }

    public Taxon convertTaxonFromXLS(TaxonTreeDef treeDef, String fileName, boolean doUserProvidedFile) {
        int counter;
        Taxon root;
        Hashtable taxonHash;
        block36: {
            taxonHash = new Hashtable();
            taxonHash.clear();
            File file = TaxonLoadSetupPanel.getFileForTaxon(fileName, doUserProvidedFile);
            if (file == null) {
                return null;
            }
            Vector<TaxonTreeDefItem> rankedItems = new Vector<TaxonTreeDefItem>();
            Hashtable<String, Boolean> colNames = new Hashtable<String, Boolean>();
            for (TaxonTreeDefItem item : treeDef.getTreeDefItems()) {
                colNames.put(item.getName().toLowerCase(), true);
                rankedItems.add(item);
            }
            Collections.sort(rankedItems, new Comparator<TaxonTreeDefItem>(){

                @Override
                public int compare(TaxonTreeDefItem o1, TaxonTreeDefItem o2) {
                    return o1.getRankId().compareTo(o2.getRankId());
                }
            });
            Connection conn = null;
            Statement stmt = null;
            TaxonTreeDefItem rootTreeDefItem = (TaxonTreeDefItem)rankedItems.get(0);
            Set<Taxon> rootKids = rootTreeDefItem.getTreeEntries();
            root = rootKids.iterator().next();
            Vector<Pair<String, Integer>> nodeList = new Vector<Pair<String, Integer>>();
            Pair<String, Integer> rootNode = new Pair<String, Integer>(root.getName(), root.getId());
            nodeList.add(rootNode);
            counter = 0;
            int numDataCols = 0;
            try {
                try {
                    this.startTx();
                    for (TaxonTreeDefItem item : treeDef.getTreeDefItems()) {
                        this.persist((Object)item);
                    }
                    this.persist((Object)root);
                    this.commitTx();
                    String[] cells = new String[35];
                    String[] header = new String[35];
                    FileInputStream input = new FileInputStream(file);
                    POIFSFileSystem fs = new POIFSFileSystem((InputStream)input);
                    HSSFWorkbook workBook = new HSSFWorkbook(fs);
                    HSSFSheet sheet = workBook.getSheetAt(0);
                    Iterator rows = sheet.rowIterator();
                    int lastRowNum = sheet.getLastRowNum();
                    if (this.frame != null) {
                        final int mx = lastRowNum;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BuildSampleDatabase.this.frame.setProcess(0, mx);
                            }
                        });
                    }
                    conn = DBConnection.getInstance().createConnection();
                    stmt = conn.createStatement();
                    int rowCnt = 0;
                    rows = sheet.rowIterator();
                    block12: while (rows.hasNext()) {
                        HSSFCell cell;
                        int i;
                        Iterator cellsIter;
                        HSSFRow row;
                        ++rowCnt;
                        int i2 = 0;
                        while (i2 < cells.length) {
                            cells[i2] = null;
                            ++i2;
                        }
                        if (counter == 0) {
                            row = (HSSFRow)rows.next();
                            cellsIter = row.cellIterator();
                            i = 0;
                            while (cellsIter.hasNext()) {
                                cell = (HSSFCell)cellsIter.next();
                                if (cell == null) continue;
                                cells[i] = this.getXLSCellValueAsStr(cell);
                                header[i] = cells[i];
                                ++i;
                            }
                            i = 0;
                            while (i < cells.length) {
                                if (cells[i] == null) break;
                                if (colNames.get(cells[i].toLowerCase()) == null) {
                                    for (String key : colNames.keySet()) {
                                        System.err.println("key[" + key + "]");
                                    }
                                    System.err.println("Not Found: [" + cells[i].toLowerCase() + "]");
                                    break;
                                }
                                numDataCols = i + 1;
                                ++i;
                            }
                            this.loadIndexes(cells);
                            counter = 1;
                            String[] stringArray = header;
                            int n = header.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String hdr = stringArray[n2];
                                if (hdr == null) continue block12;
                                int inx = 0;
                                for (TaxonTreeDefItem item : rankedItems) {
                                    if (hdr.equalsIgnoreCase(item.getName())) {
                                        log.debug((Object)("Header: " + hdr + " -> " + inx));
                                        this.taxonIndexes.put(hdr, inx);
                                        item.setIsInFullName(item.getRankId() >= 180);
                                    } else {
                                        log.debug((Object)("Header: " + hdr + " -> skipped."));
                                    }
                                    ++inx;
                                }
                                ++n2;
                            }
                            continue;
                        }
                        if (counter % 100 == 0 && this.frame != null) {
                            this.frame.setProcess(counter);
                        }
                        row = (HSSFRow)rows.next();
                        cellsIter = row.cellIterator();
                        i = 0;
                        while (cellsIter.hasNext() && i < cells.length) {
                            cell = (HSSFCell)cellsIter.next();
                            if (cell == null) continue;
                            cells[i] = this.getXLSCellValueAsStr(cell);
                            ++i;
                        }
                        this.convertTaxonNodes(conn, stmt, header, cells, numDataCols, rootNode, nodeList, rankedItems, root.getDefinition().getId());
                        ++counter;
                    }
                    stmt.executeUpdate("UPDATE taxon SET IsAccepted = true WHERE IsAccepted IS NULL and AcceptedID IS NULL");
                    conn.close();
                    ((InputStream)input).close();
                    if (this.frame != null) {
                        this.frame.setProcess(lastRowNum);
                    }
                    root = (Taxon)this.session.createQuery("FROM Taxon WHERE id = " + root.getId()).list().get(0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(BackupServiceFactory.class, ex);
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        break block36;
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                    break block36;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.frame != null) {
            this.frame.setDesc("Saving Taxon Tree...");
            this.frame.getProcessProgress().setIndeterminate(true);
        }
        NodeNumberer nodeNumberer = new NodeNumberer(root.getDefinition());
        nodeNumberer.doInBackground();
        log.info((Object)("Converted " + counter + " Taxon records"));
        taxonHash.clear();
        return root;
    }

    private void loadIndexes(String[] cells) {
        int i = FAMILY_COMMON_NAME;
        while (i <= SUBSPECIES_COMMON_NAME) {
            int inx = 0;
            while (inx < cells.length) {
                if (cells[inx] == null) break;
                System.out.println(String.valueOf(cells[inx]) + "  " + TaxonIndexNames[i]);
                if (cells[inx].equals(TaxonIndexNames[i])) {
                    System.out.println("** " + TaxonIndexNames[i] + " -> " + inx);
                    this.taxonExtraColsIndexes.put(TaxonIndexNames[i].toLowerCase(), inx);
                    break;
                }
                ++inx;
            }
            ++i;
        }
    }

    public void convertTaxonNodes(Connection conn, Statement stmt, String[] header, String[] levelNames, int numColumns, Pair<String, Integer> parent, Vector<Pair<String, Integer>> nodeList, Vector<TaxonTreeDefItem> rankedItems, int txTreeDefId) throws SQLException {
        String fullName = "";
        int i = 0;
        while (i < numColumns) {
            Integer depthInx;
            int inx = i + 1;
            if (StringUtils.isEmpty((String)levelNames[i]) || (depthInx = this.taxonIndexes.get(header[i])) == null && this.taxonExtraColsIndexes.get(header[i]) != null) break;
            TaxonTreeDefItem ttdi = rankedItems.get(depthInx);
            if (ttdi.getIsInFullName().booleanValue()) {
                if (StringUtils.isNotEmpty((String)ttdi.getTextBefore())) {
                    fullName = String.valueOf(fullName) + ttdi.getTextBefore();
                }
                fullName = String.valueOf(fullName) + levelNames[i];
                if (StringUtils.isNotEmpty((String)ttdi.getTextAfter())) {
                    fullName = String.valueOf(fullName) + ttdi.getTextAfter();
                }
                if (StringUtils.isNotEmpty((String)ttdi.getFullNameSeparator())) {
                    fullName = String.valueOf(fullName) + ttdi.getFullNameSeparator();
                }
            }
            if (inx == nodeList.size() || !levelNames[i].equals(nodeList.get((int)inx).first)) {
                int j = inx;
                while (j < nodeList.size()) {
                    this.recycler.push(nodeList.get(j));
                    ++j;
                }
                nodeList.setSize(inx);
                Pair<String, Integer> node = this.createTaxonNode(conn, stmt, levelNames[i], txTreeDefId, ttdi, (Integer)nodeList.get((int)i).second, fullName.trim(), levelNames);
                nodeList.add(node);
            }
            ++i;
        }
    }

    protected Pair<String, Integer> createTaxonNode(Connection conn, Statement stmt, String name, int txTreeDefId, TaxonTreeDefItem tdi, Integer parentId, String fullName, String[] levelNames) throws SQLException {
        this.gSQLStr.setLength(0);
        this.gSQLStr.append("INSERT INTO taxon (Name, TaxonTreeDefID, FullName, TaxonTreeDefItemID, RankID, ParentID, TimestampCreated, Version");
        this.addExtraColumns(this.gSQLStr, tdi.getRankId(), levelNames, true);
        this.gSQLStr.append(") VALUES (");
        this.gSQLStr.append("\"");
        this.gSQLStr.append(name);
        this.gSQLStr.append("\",");
        this.gSQLStr.append(txTreeDefId);
        this.gSQLStr.append(",");
        this.gSQLStr.append("\"");
        if (StringUtils.isNotEmpty((String)fullName)) {
            this.gSQLStr.append(fullName);
        } else {
            this.gSQLStr.append(name);
        }
        this.gSQLStr.append("\"");
        this.gSQLStr.append(",");
        this.gSQLStr.append(tdi.getId());
        this.gSQLStr.append(',');
        this.gSQLStr.append(tdi.getRankId());
        this.gSQLStr.append(',');
        this.gSQLStr.append(parentId);
        this.gSQLStr.append(',');
        this.gSQLStr.append(nowStr);
        this.gSQLStr.append(",1");
        this.addExtraColumns(this.gSQLStr, tdi.getRankId(), levelNames, false);
        this.gSQLStr.append(")");
        stmt.executeUpdate(this.gSQLStr.toString());
        Integer newId = BasicSQLUtils.getInsertedId(stmt);
        if (newId == null) {
            throw new RuntimeException("Couldn't get the Taxon's inserted ID");
        }
        ++this.recCnt;
        if (this.recycler.size() > 0) {
            Pair<String, Integer> p = this.recycler.pop();
            p.first = name;
            p.second = newId;
            return p;
        }
        return new Pair<String, Integer>(name, newId);
    }

    protected void addExtraColumns(StringBuilder sb, int rankId, String[] cells, boolean doFieldNames) {
        switch (rankId) {
            case 140: {
                this.loadTaxonFields(sb, new int[]{FAMILY_COMMON_NAME}, cells, doFieldNames);
                break;
            }
            case 220: {
                this.loadTaxonFields(sb, new int[]{SPECIES_AUTHOR, SPECIES_SOURCE, SPECIES_LSID, SPECIES_COMMON_NAME}, cells, doFieldNames);
                break;
            }
            case 230: {
                this.loadTaxonFields(sb, new int[]{SUBSPECIES_AUTHOR, SUBSPECIES_SOURCE, SUBSPECIES_LSID, SUBSPECIES_COMMON_NAME}, cells, doFieldNames);
                break;
            }
        }
    }

    private void loadTaxonFields(StringBuilder sb, int[] indexes, String[] cells, boolean doFieldNames) {
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            String data;
            Integer gotten;
            int inx = nArray[n2];
            if (TaxonIndexNames[inx] != null && (gotten = this.taxonExtraColsIndexes.get(TaxonIndexNames[inx].toLowerCase())) != null && StringUtils.isNotEmpty((String)(data = cells[index = gotten.intValue()]))) {
                sb.append(",");
                if (doFieldNames) {
                    sb.append(TaxonFieldNames[inx]);
                } else {
                    data = StringUtils.replace((String)data, (String)"'", (String)"\\'");
                    sb.append("'" + data + "'");
                }
            }
            ++n2;
        }
    }

    public GeologicTimePeriod convertChronoStratFromXLS(GeologicTimePeriodTreeDef treeDef, Agent userAgent) {
        this.startTx();
        GeologicTimePeriodTreeDefItem root = DataBuilder.createGeologicTimePeriodTreeDefItem(null, treeDef, "Root", 0);
        GeologicTimePeriodTreeDefItem era = DataBuilder.createGeologicTimePeriodTreeDefItem(root, treeDef, "Erathem/Era", 100);
        GeologicTimePeriodTreeDefItem period = DataBuilder.createGeologicTimePeriodTreeDefItem(era, treeDef, "System/Period", 200);
        GeologicTimePeriodTreeDefItem series = DataBuilder.createGeologicTimePeriodTreeDefItem(period, treeDef, "Series/Epoch", 300);
        GeologicTimePeriodTreeDefItem member = DataBuilder.createGeologicTimePeriodTreeDefItem(series, treeDef, "Stage/Age", 400);
        this.persist((Object)root);
        this.commitTx();
        series.setIsInFullName(true);
        this.frame.setDesc("Building ChronoStratigraphy Tree...");
        Hashtable chronoHash = new Hashtable();
        chronoHash.clear();
        String fileName = "chronostrat_tree.xls";
        File file = XMLHelper.getConfigDir("../demo_files/" + fileName);
        if (!file.exists()) {
            log.error((Object)("Couldn't file[" + file.getAbsolutePath() + "] checking the config dir"));
            file = XMLHelper.getConfigDir(fileName);
            if (!file.exists()) {
                file = new File("Specify/demo_files/" + fileName);
            }
        }
        if (file == null || !file.exists()) {
            log.error((Object)("Couldn't file[" + file.getAbsolutePath() + "]"));
            return null;
        }
        GeologicTimePeriod rootNode = new GeologicTimePeriod();
        rootNode.initialize();
        rootNode.setName(UIRegistry.getResourceString("Root"));
        rootNode.setFullName(rootNode.getName());
        rootNode.setRankId(0);
        rootNode.setDefinition(treeDef);
        rootNode.setDefinitionItem(root);
        rootNode.setCreatedByAgent(userAgent);
        int counter = 0;
        try {
            this.startTx();
            this.persist((Object)rootNode);
            String[] cells = new String[4];
            FileInputStream input = new FileInputStream(file);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)input);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            HSSFSheet sheet = workBook.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            int lastRowNum = sheet.getLastRowNum();
            if (this.frame != null) {
                final int mx = lastRowNum;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BuildSampleDatabase.this.frame.setProcess(0, mx);
                    }
                });
            }
            while (rows.hasNext()) {
                if (counter == 0) {
                    counter = 1;
                    continue;
                }
                if (counter % 100 == 0) {
                    if (this.frame != null) {
                        this.frame.setProcess(counter);
                    }
                    log.info((Object)("Converted " + counter + " ChronoStrat records"));
                }
                HSSFRow row = (HSSFRow)rows.next();
                Iterator cellsIter = row.cellIterator();
                int i = 0;
                while (cellsIter.hasNext() && i < 4) {
                    HSSFCell cell = (HSSFCell)cellsIter.next();
                    if (cell == null) continue;
                    cells[i] = StringUtils.trim((String)cell.getRichStringCellValue().getString());
                    ++i;
                }
                int j = i;
                while (j < 4) {
                    cells[j] = null;
                    ++j;
                }
                GeologicTimePeriod newGeo = this.convertChronoStratRecord(cells[0], cells[1], cells[2], cells[3], rootNode, userAgent);
                ++counter;
            }
            ((InputStream)input).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.frame != null) {
            this.frame.setProcess(counter);
        }
        log.info((Object)("Converted " + counter + " ChronoStrat records"));
        TreeHelper.fixFullnameForNodeAndDescendants(rootNode);
        rootNode.setNodeNumber(1);
        BuildSampleDatabase.fixNodeNumbersFromRoot(rootNode);
        this.commitTx();
        log.info((Object)("Converted " + counter + " Stratigraphy records"));
        chronoHash.clear();
        return rootNode;
    }

    protected GeologicTimePeriod convertChronoStratRecord(String continent, String country, String state, String county, GeologicTimePeriod geoRoot, Agent userAgent) {
        String[] levelNames = new String[]{continent, country, state, county};
        int levelsToBuild = 0;
        int i = levelNames.length;
        while (i > 0) {
            if (StringUtils.isNotEmpty((String)levelNames[i - 1])) {
                levelsToBuild = i;
                break;
            }
            --i;
        }
        i = 0;
        while (i < levelsToBuild) {
            if (StringUtils.isEmpty((String)levelNames[i])) {
                levelNames[i] = "(Empty)";
            }
            ++i;
        }
        GeologicTimePeriod prevLevelGeo = geoRoot;
        int i2 = 0;
        while (i2 < levelsToBuild) {
            GeologicTimePeriod newLevelGeo;
            prevLevelGeo = newLevelGeo = this.buildChronoStratLevel(levelNames[i2], prevLevelGeo, userAgent);
            ++i2;
        }
        return prevLevelGeo;
    }

    protected GeologicTimePeriod buildChronoStratLevel(String nameArg, GeologicTimePeriod parentArg, Agent userAgent) {
        String name = nameArg;
        if (name == null) {
            name = "N/A";
        }
        Set<GeologicTimePeriod> children = parentArg.getChildren();
        for (GeologicTimePeriod child : children) {
            if (!name.equalsIgnoreCase(child.getName())) continue;
            return child;
        }
        GeologicTimePeriod newGeo = new GeologicTimePeriod();
        newGeo.initialize();
        newGeo.setName(name);
        newGeo.setParent(parentArg);
        parentArg.addChild(newGeo);
        newGeo.setDefinition(parentArg.getDefinition());
        newGeo.setCreatedByAgent(userAgent);
        int newGeoRank = parentArg.getRankId() + 100;
        GeologicTimePeriodTreeDefItem defItem = parentArg.getDefinition().getDefItemByRank(newGeoRank);
        newGeo.setDefinitionItem(defItem);
        newGeo.setRankId(newGeoRank);
        this.persist((Object)newGeo);
        return newGeo;
    }

    public static void fixNumericCatalogNumbers(UIFieldFormatterIFace fmt) {
        Connection conn = DBConnection.getInstance().createConnection();
        Statement stmt = null;
        Statement updtStmt = null;
        try {
            try {
                stmt = conn.createStatement();
                updtStmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("select CollectionObjectID, CatalogNumber FROM collectionobject");
                while (rs.next()) {
                    int id = rs.getInt(1);
                    String catNum = (String)fmt.formatFromUI(rs.getString(2));
                    updtStmt.executeUpdate("UPDATE collectionobject SET CatalogNumber='" + catNum + "' WHERE CollectionObjectID = " + id);
                }
                rs.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stmt.close();
                    updtStmt.close();
                    conn.close();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                stmt.close();
                updtStmt.close();
                conn.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static enum UpdateType {
        eBuildNew,
        eImport,
        eMerge,
        eLocalize;

    }
}

