/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import edu.ku.brc.specify.ui.treetables.TreeNode;
import edu.ku.brc.specify.ui.treetables.TreeTableViewer;
import edu.ku.brc.specify.ui.treetables.TreeViewerListModel;
import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TreeViewerNodeRenderer
implements ListCellRenderer,
ListDataListener {
    protected Icon open;
    protected Icon closed;
    protected TreeViewerListModel model;
    protected JList list;
    protected SortedMap<Integer, Integer> columnWidths;
    protected boolean widthsValid;
    protected Color[] bgs;
    protected int leadTextOffset;
    protected int tailTextOffset;
    protected TreeNodeUI nodeUI;
    protected boolean firstTime = true;
    protected Stroke lineStroke;
    protected Color lineColor;
    protected Color synonymyColor;
    protected TreeTableViewer<?, ?, ?> treeViewer;
    protected boolean renderTooltip = true;
    protected Stack<Pair<Integer, Integer>> intPairRecycler = new Stack();
    protected StringBuilder nameStrBldr = new StringBuilder();
    protected boolean recalc = true;
    protected Hashtable<Integer, Pair<Integer, Integer>> anchorRankHash = new Hashtable();
    protected Hashtable<Integer, Pair<Integer, Integer>> textRankHash = new Hashtable();
    protected Hashtable<Integer, Pair<Integer, Integer>> colRankHash = new Hashtable();
    protected BufferedImage bgImg = null;
    protected int numVisRanks = 0;

    public TreeViewerNodeRenderer(TreeTableViewer<?, ?, ?> ttv, TreeViewerListModel model, Color[] bgColors, Color lineColor, Color synonymyColor) {
        this.model = model;
        this.treeViewer = ttv;
        this.bgs = new Color[2];
        this.bgs[0] = bgColors[0];
        this.bgs[1] = bgColors[1];
        this.synonymyColor = synonymyColor;
        this.open = IconManager.getIcon("Down", IconManager.IconSize.NonStd);
        this.closed = IconManager.getIcon("Forward", IconManager.IconSize.NonStd);
        this.leadTextOffset = 24;
        this.tailTextOffset = 8;
        this.columnWidths = Collections.synchronizedSortedMap(new TreeMap());
        this.widthsValid = false;
        model.addListDataListener(this);
        this.lineStroke = new BasicStroke(1.5f, 1, 1);
        this.lineColor = lineColor;
        this.nodeUI = new TreeNodeUI();
    }

    public TreeNodeUI getNodeUI() {
        return this.nodeUI;
    }

    public void setRenderTooltip(boolean renderTooltip) {
        this.renderTooltip = renderTooltip;
    }

    public Color[] getBackgroundColors() {
        return this.bgs;
    }

    public Component getListCellRendererComponent(JList l, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.list = l;
        if (!(value instanceof TreeNode)) {
            return UIHelper.createLabel("Item must be an instance of TreeNode");
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.computeMissingColumnWidths(l.getGraphics());
        }
        TreeNode node = (TreeNode)value;
        this.nodeUI.setNode(node);
        this.nodeUI.setSelected(isSelected);
        this.nodeUI.setHasFocus(cellHasFocus);
        if (!this.renderTooltip) {
            this.nodeUI.setToolTipText(null);
            return this.nodeUI;
        }
        if (node.getTooltipText() == null) {
            this.nameStrBldr.setLength(0);
            this.nameStrBldr.append("<html><div style=\"font-family: sans-serif; font-size: 12pt\">");
            this.nameStrBldr.append(node.getFullName());
            Set<Pair<Integer, String>> idsAndNames = node.getSynonymIdsAndNames();
            if (idsAndNames.size() > 0) {
                this.nameStrBldr.append("</div><<div style=\"font-family: sans-serif; font-size: 10pt\">");
                this.nameStrBldr.append("<br>");
                if (idsAndNames.size() > 1) {
                    this.nameStrBldr.append(String.valueOf(UIRegistry.getResourceString("TTV_SYNONYMS")) + ":");
                } else {
                    this.nameStrBldr.append(String.valueOf(UIRegistry.getResourceString("TTV_SYNONYM")) + ":");
                }
                ArrayList<String> justNames = new ArrayList<String>();
                for (Pair<Integer, String> idAndName : idsAndNames) {
                    justNames.add((String)idAndName.second);
                }
                Collections.sort(justNames);
                for (String name : justNames) {
                    this.nameStrBldr.append("<br>");
                    this.nameStrBldr.append(name);
                }
                this.nameStrBldr.append("</ul>");
            }
            if (node.getAcceptedParentFullName() != null) {
                this.nameStrBldr.append("</div><br><div style=\"font-family: sans-serif; font-size: 10pt\">");
                this.nameStrBldr.append(UIRegistry.getResourceString("TTV_PREFERRED_NAME"));
                this.nameStrBldr.append(": ");
                this.nameStrBldr.append(node.getAcceptedParentFullName());
            }
            this.nameStrBldr.append("</div></html>");
            node.setTooltipText(this.nameStrBldr.toString());
        }
        this.nodeUI.setToolTipText(node.getTooltipText());
        return this.nodeUI;
    }

    public Pair<Integer, Integer> getRecycledIntPair() {
        return this.intPairRecycler.size() == 0 ? new Pair() : this.intPairRecycler.pop();
    }

    public void recycle(Pair<Integer, Integer> item) {
        if (item != null) {
            this.intPairRecycler.push(item);
        }
    }

    public synchronized Pair<Integer, Integer> getTextBoundsForRank(Integer rank) {
        if (rank == null) {
            return null;
        }
        Pair<Integer, Integer> bounds = this.getColumnBoundsForRank(rank);
        if (bounds == null) {
            return null;
        }
        Pair<Integer, Integer> textBounds = this.textRankHash.get((int)rank);
        if (textBounds == null) {
            textBounds = this.getRecycledIntPair();
            textBounds.first = (Integer)bounds.first + this.leadTextOffset;
            textBounds.second = (Integer)bounds.second - this.tailTextOffset;
            this.textRankHash.put(rank, textBounds);
        }
        return textBounds;
    }

    public synchronized Pair<Integer, Integer> getAnchorBoundsForRank(Integer rank) {
        if (rank == null) {
            return null;
        }
        Pair<Integer, Integer> anchorBnds = this.anchorRankHash.get(rank);
        if (anchorBnds == null) {
            anchorBnds = this.getRecycledIntPair();
            Pair<Integer, Integer> bounds = this.getColumnBoundsForRank(rank);
            if (bounds == null) {
                return null;
            }
            anchorBnds.first = (Integer)bounds.first;
            anchorBnds.second = (Integer)bounds.first + this.leadTextOffset;
            this.anchorRankHash.put(rank, anchorBnds);
        }
        return anchorBnds;
    }

    public synchronized Pair<Integer, Integer> getColumnBoundsForRank(Integer rank) {
        if (rank == null) {
            return null;
        }
        List<Integer> visibleRanks = this.model.getVisibleRanks();
        if (!visibleRanks.contains(rank)) {
            return null;
        }
        Pair<Integer, Integer> colBounds = this.colRankHash.get(rank);
        if (colBounds == null) {
            Integer colWidth;
            colBounds = this.getRecycledIntPair();
            int widthsOfLowerColumns = 0;
            for (Integer r : visibleRanks) {
                if (r >= rank) break;
                Integer colWidth2 = (Integer)this.columnWidths.get(r);
                widthsOfLowerColumns += colWidth2.intValue();
            }
            if ((colWidth = (Integer)this.columnWidths.get(rank)) == null) {
                this.recycle(colBounds);
                return null;
            }
            colBounds.first = widthsOfLowerColumns;
            colBounds.second = widthsOfLowerColumns + colWidth;
            this.colRankHash.put(rank, colBounds);
        }
        return colBounds;
    }

    public synchronized void computeMissingColumnWidths(Graphics g) {
        int defaultColumnWidth = g.getFontMetrics().stringWidth("WWWWWWWWWWWWW");
        for (Integer rank : this.model.getVisibleRanks()) {
            if (this.columnWidths.containsKey(rank)) continue;
            this.columnWidths.put(rank, defaultColumnWidth);
        }
        this.widthsValid = true;
    }

    public synchronized void removeUnusedColumnWidths() {
        HashSet<Integer> ranksWithWidths = new HashSet<Integer>();
        ranksWithWidths.addAll(this.columnWidths.keySet());
        List<Integer> visibleRanks = this.model.getVisibleRanks();
        for (Integer rankWithWidth : ranksWithWidths) {
            if (visibleRanks.contains(rankWithWidth)) continue;
            this.columnWidths.remove(rankWithWidth);
        }
    }

    public synchronized int getColumnWidth(int rank) {
        return (Integer)this.columnWidths.get(rank);
    }

    public void reset() {
        this.bgImg = null;
        this.intPairRecycler.addAll(this.anchorRankHash.values());
        this.intPairRecycler.addAll(this.textRankHash.values());
        this.intPairRecycler.addAll(this.colRankHash.values());
        this.anchorRankHash.clear();
        this.textRankHash.clear();
        this.colRankHash.clear();
    }

    public synchronized void changeColumnWidth(int rank, int change) {
        int width = (Integer)this.columnWidths.get(rank);
        this.columnWidths.put(rank, width + change);
        this.reset();
        this.treeViewer.updateAllUI();
    }

    protected synchronized int[] getRanksSurroundingPoint(int x) {
        int[] ranks = new int[]{-1, -1};
        boolean leftSet = false;
        boolean rightSet = false;
        for (int rank : this.model.getVisibleRanks()) {
            Pair<Integer, Integer> rankBounds = this.getColumnBoundsForRank(rank);
            if (Math.abs((Integer)rankBounds.first - x) < 4) {
                ranks[1] = rank;
                rightSet = true;
                continue;
            }
            if (Math.abs((Integer)rankBounds.second - x) >= 4) continue;
            ranks[0] = rank;
            leftSet = true;
        }
        if (leftSet || rightSet) {
            return ranks;
        }
        return null;
    }

    public synchronized int getSumOfColumnWidths() {
        int width = 0;
        for (Integer w : this.columnWidths.values()) {
            width += w.intValue();
        }
        return width;
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.widthsValid = false;
        if (this.list.getGraphics() != null) {
            this.computeMissingColumnWidths(this.list.getGraphics());
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.widthsValid = false;
        this.removeUnusedColumnWidths();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.widthsValid = false;
        if (this.list != null && this.list.getGraphics() != null) {
            this.computeMissingColumnWidths(this.list.getGraphics());
        }
    }

    public class TreeNodeUI
    extends JPanel {
        protected TreeNode treeNode;
        protected boolean hasFocus;
        protected boolean selected;
        protected boolean isOpen = false;

        public boolean isHasFocus() {
            return this.hasFocus;
        }

        public void setHasFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        public TreeNode getTreeNode() {
            return this.treeNode;
        }

        public void setNode(TreeNode node) {
            this.treeNode = node;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Override
        public Dimension getPreferredSize() {
            if (!TreeViewerNodeRenderer.this.widthsValid) {
                TreeViewerNodeRenderer.this.computeMissingColumnWidths(TreeViewerNodeRenderer.this.list.getGraphics());
            }
            Dimension prefSize = new Dimension(TreeViewerNodeRenderer.this.getSumOfColumnWidths(), TreeViewerNodeRenderer.this.list.getFixedCellHeight());
            return prefSize;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (TreeViewerNodeRenderer.this.list.getFont() != null) {
                this.setFont(TreeViewerNodeRenderer.this.list.getFont());
            }
            if (!TreeViewerNodeRenderer.this.widthsValid) {
                TreeViewerNodeRenderer.this.computeMissingColumnWidths(TreeViewerNodeRenderer.this.list.getGraphics());
                TreeViewerNodeRenderer.this.widthsValid = true;
            }
            GraphicsUtils.turnOnAntialiasedDrawing(g);
            g.setColor(TreeViewerNodeRenderer.this.list.getForeground());
            this.drawBackgroundColors(g);
            this.drawTreeLinesToLowerNodes(g);
            this.drawOpenClosedIcon(g);
            this.drawNodeAnchors(g);
            this.drawNodeString(g);
        }

        public void drawBackgroundColors(Graphics graphics) {
            boolean sizeChanged;
            Dimension size = this.getSize();
            boolean bl = sizeChanged = TreeViewerNodeRenderer.this.bgImg == null || size.width > TreeViewerNodeRenderer.this.bgImg.getWidth() || size.height > TreeViewerNodeRenderer.this.bgImg.getHeight();
            if (sizeChanged || TreeViewerNodeRenderer.this.model.getVisibleRanks().size() != TreeViewerNodeRenderer.this.numVisRanks) {
                if (TreeViewerNodeRenderer.this.bgImg != null) {
                    TreeViewerNodeRenderer.this.reset();
                }
                TreeViewerNodeRenderer.this.bgImg = new BufferedImage(size.width, size.height, 1);
                Graphics2D g = TreeViewerNodeRenderer.this.bgImg.createGraphics();
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, size.width, size.height);
                List<Integer> visRanksList = TreeViewerNodeRenderer.this.model.getVisibleRanks();
                int cellHeight = TreeViewerNodeRenderer.this.list.getFixedCellHeight();
                int i = 0;
                for (Integer rank : visRanksList) {
                    Pair<Integer, Integer> startEnd = TreeViewerNodeRenderer.this.getColumnBoundsForRank(rank);
                    g.setColor(TreeViewerNodeRenderer.this.bgs[i % 2]);
                    g.fillRect((Integer)startEnd.first, 0, (Integer)startEnd.second - (Integer)startEnd.first, cellHeight);
                    ++i;
                }
                TreeViewerNodeRenderer.this.numVisRanks = visRanksList.size();
                g.dispose();
            }
            graphics.drawImage(TreeViewerNodeRenderer.this.bgImg, 0, 0, null);
        }

        public void drawBackgroundColors(Graphics g, int yStart, int yEnd) {
            Color orig = g.getColor();
            int i = 0;
            for (Integer rank : TreeViewerNodeRenderer.this.model.getVisibleRanks()) {
                Pair<Integer, Integer> startEnd = TreeViewerNodeRenderer.this.getColumnBoundsForRank(rank);
                g.setColor(TreeViewerNodeRenderer.this.bgs[i % 2]);
                g.fillRect((Integer)startEnd.first, yStart, (Integer)startEnd.second - (Integer)startEnd.first, yEnd);
                ++i;
            }
            g.setColor(orig);
        }

        private void drawNodeAnchors(Graphics g) {
            TreeNode node = this.treeNode;
            TreeNode parent = TreeViewerNodeRenderer.this.model.getNodeById(this.treeNode.getParentId());
            Graphics2D g2d = (Graphics2D)g;
            Stroke origStroke = g2d.getStroke();
            Color origColor = g.getColor();
            g2d.setStroke(TreeViewerNodeRenderer.this.lineStroke);
            g.setColor(TreeViewerNodeRenderer.this.lineColor);
            int cellHeight = TreeViewerNodeRenderer.this.list.getFixedCellHeight();
            int midCell = cellHeight / 2;
            if (node != TreeViewerNodeRenderer.this.model.getVisibleRoot() && parent != null) {
                Pair<Integer, Integer> parentAnchorBounds = TreeViewerNodeRenderer.this.getAnchorBoundsForRank(parent.getRank());
                Pair<Integer, Integer> nodeAnchorBounds = TreeViewerNodeRenderer.this.getAnchorBoundsForRank(node.getRank());
                boolean isLastKid = TreeViewerNodeRenderer.this.model.parentHasChildrenAfterNode(parent, node);
                if (!isLastKid) {
                    g.drawLine((Integer)parentAnchorBounds.second, 0, (Integer)parentAnchorBounds.second, midCell);
                    g.drawLine((Integer)parentAnchorBounds.second + 1, midCell, (Integer)nodeAnchorBounds.first, midCell);
                } else {
                    g.drawLine((Integer)parentAnchorBounds.second, 0, (Integer)parentAnchorBounds.second, cellHeight);
                    g.drawLine((Integer)parentAnchorBounds.second + 1, midCell, (Integer)nodeAnchorBounds.first, midCell);
                }
            }
            g2d.setStroke(origStroke);
            g.setColor(origColor);
        }

        private void drawTreeLinesToLowerNodes(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke origStroke = g2d.getStroke();
            Color origColor = g.getColor();
            g2d.setStroke(TreeViewerNodeRenderer.this.lineStroke);
            g.setColor(TreeViewerNodeRenderer.this.lineColor);
            TreeNode node = this.treeNode;
            TreeNode parent = TreeViewerNodeRenderer.this.model.getNodeById(this.treeNode.getParentId());
            int cellHeight = TreeViewerNodeRenderer.this.list.getFixedCellHeight();
            while (node != TreeViewerNodeRenderer.this.model.getVisibleRoot() && parent != null) {
                if (TreeViewerNodeRenderer.this.model.parentHasChildrenAfterNode(parent, node)) {
                    Pair<Integer, Integer> anchorBnds = TreeViewerNodeRenderer.this.getAnchorBoundsForRank(parent.getRank());
                    if (parent.getRank() != this.treeNode.getParentRank()) {
                        g.drawLine((Integer)anchorBnds.second, 0, (Integer)anchorBnds.second, cellHeight);
                    }
                }
                node = parent;
                parent = TreeViewerNodeRenderer.this.model.getNodeById(node.getParentId());
            }
            g2d.setStroke(origStroke);
            g.setColor(origColor);
        }

        private void drawOpenClosedIcon(Graphics g) {
            if (!this.treeNode.isHasChildren()) {
                return;
            }
            Boolean hasVisKids = this.treeNode.hasVisualChildren();
            if (hasVisKids == null) {
                hasVisKids = TreeViewerNodeRenderer.this.model.showingChildrenOf(this.treeNode);
                this.treeNode.setHasVisualChildren(hasVisKids);
            }
            Icon openCloseIcon = hasVisKids != false ? TreeViewerNodeRenderer.this.open : TreeViewerNodeRenderer.this.closed;
            int cellHeight = TreeViewerNodeRenderer.this.list.getFixedCellHeight();
            Pair<Integer, Integer> anchorBounds = TreeViewerNodeRenderer.this.getAnchorBoundsForRank(this.treeNode.getRank());
            int anchorStartX = anchorBounds.getFirst();
            int widthDiff = (Integer)anchorBounds.second - (Integer)anchorBounds.first - openCloseIcon.getIconWidth();
            int heightDiff = cellHeight - openCloseIcon.getIconHeight();
            openCloseIcon.paintIcon(TreeViewerNodeRenderer.this.list, g, anchorStartX + (int)(0.5 * (double)widthDiff), 0 + (int)(0.5 * (double)heightDiff));
        }

        private void drawNodeString(Graphics g) {
            Color startingColor = g.getColor();
            if (this.treeNode.getAcceptedParentFullName() != null) {
                g.setColor(TreeViewerNodeRenderer.this.synonymyColor);
            }
            TreeViewerNodeRenderer.this.nameStrBldr.setLength(0);
            TreeViewerNodeRenderer.this.nameStrBldr.append(this.treeNode.getName());
            Graphics2D g2d = (Graphics2D)g;
            FontMetrics fm = g.getFontMetrics();
            int cellHeight = TreeViewerNodeRenderer.this.list.getFixedCellHeight();
            int baselineAdj = (int)(0.5 * (double)fm.getAscent() + 0.5 * (double)cellHeight);
            Pair<Integer, Integer> stringBounds = TreeViewerNodeRenderer.this.getTextBoundsForRank(this.treeNode.getRank());
            int stringStartX = stringBounds.getFirst();
            int stringEndX = stringBounds.getSecond();
            int stringLength = stringEndX - stringStartX;
            int stringY = baselineAdj;
            if (this.selected) {
                g2d.setColor(TreeViewerNodeRenderer.this.list.getSelectionBackground());
                g2d.fillRoundRect(stringStartX - 2, 1, stringLength + 4, cellHeight - 2, 8, 8);
                g2d.setColor(TreeViewerNodeRenderer.this.list.getSelectionForeground());
            }
            if (this.treeNode == TreeViewerNodeRenderer.this.model.getDropLocationNode()) {
                Color selBG = TreeViewerNodeRenderer.this.list.getSelectionBackground();
                Color secondarySelectionColor = new Color(selBG.getRed(), selBG.getGreen(), selBG.getBlue(), 127);
                g2d.setColor(secondarySelectionColor);
                g2d.fillRoundRect(stringStartX - 2, 1, stringLength + 4, cellHeight - 2, 8, 8);
                g2d.setColor(TreeViewerNodeRenderer.this.list.getSelectionForeground());
            }
            if (this.treeNode.getAssociatedRecordCount() > 0) {
                TreeViewerNodeRenderer.this.nameStrBldr.append(" (");
                TreeViewerNodeRenderer.this.nameStrBldr.append(this.treeNode.getAssociatedRecordCount());
            }
            if (!this.treeNode.isHasChildren()) {
                Pair<Integer, Integer> colBnds = TreeViewerNodeRenderer.this.getColumnBoundsForRank(this.treeNode.getRank());
                Stroke origStroke = g2d.getStroke();
                g2d.setStroke(TreeViewerNodeRenderer.this.lineStroke);
                Color origColor = g.getColor();
                g.setColor(TreeViewerNodeRenderer.this.lineColor);
                g.drawLine((Integer)colBnds.first + 1, cellHeight / 2, stringStartX - 4, cellHeight / 2);
                g2d.setStroke(origStroke);
                g.setColor(origColor);
            }
            if (this.treeNode.getAssociatedRecordCount2() > 0 && this.treeNode.isHasChildren()) {
                if (this.treeNode.getAssociatedRecordCount() > 0) {
                    TreeViewerNodeRenderer.this.nameStrBldr.append(", ");
                } else {
                    TreeViewerNodeRenderer.this.nameStrBldr.append(" (0, ");
                }
                TreeViewerNodeRenderer.this.nameStrBldr.append(this.treeNode.getAssociatedRecordCount2());
                TreeViewerNodeRenderer.this.nameStrBldr.append(")");
            } else if (this.treeNode.getAssociatedRecordCount() > 0) {
                TreeViewerNodeRenderer.this.nameStrBldr.append(")");
            }
            String clippedName = GraphicsUtils.clipString(fm, TreeViewerNodeRenderer.this.nameStrBldr.toString(), stringLength);
            g.drawString(clippedName, stringStartX, stringY);
            g.setColor(startingColor);
        }

        private void drawParentageStrings(Graphics g) {
            TreeNode node = this.treeNode;
            FontMetrics fm = g.getFontMetrics();
            int cellHeight = TreeViewerNodeRenderer.this.list.getFixedCellHeight();
            int baselineAdj = (int)(0.5 * (double)fm.getAscent() + 0.5 * (double)cellHeight);
            int parentId = node.getParentId();
            TreeNode parent = TreeViewerNodeRenderer.this.model.getNodeById(parentId);
            while (parent != null && node != parent) {
                String name = parent.getName();
                Pair<Integer, Integer> stringBounds = TreeViewerNodeRenderer.this.getTextBoundsForRank(parent.getRank());
                if (stringBounds != null) {
                    int stringStartX = stringBounds.getFirst();
                    int stringEndX = stringBounds.getSecond();
                    int stringLength = stringEndX - stringStartX;
                    int stringY = baselineAdj;
                    String clippedName = GraphicsUtils.clipString(fm, name, stringLength);
                    g.drawString(clippedName, stringStartX, stringY);
                }
                node = parent;
                parentId = node.getParentId();
                parent = TreeViewerNodeRenderer.this.model.getNodeById(parentId);
            }
        }
    }
}

