/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import edu.ku.brc.specify.ui.treetables.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class TreeViewerListModel
extends AbstractListModel {
    protected Vector<TreeNode> nodes = new Vector(100);
    protected TreeNode visibleRoot;
    protected int visibleSize;
    protected TreeNode dropLocationNode;
    protected Set<Integer> idsShowingChildren = new HashSet<Integer>();
    protected boolean doAddAllRanks = false;

    public TreeViewerListModel(TreeNode rootNode) {
        this.visibleRoot = rootNode;
        if (rootNode != null) {
            this.nodes.add(rootNode);
            this.visibleSize = 1;
        } else {
            this.visibleSize = 0;
        }
    }

    @Override
    public synchronized TreeNode getElementAt(int index) {
        int visibleRootIndex = this.nodes.indexOf(this.visibleRoot);
        TreeNode node = this.nodes.get(visibleRootIndex + index);
        return node;
    }

    @Override
    public synchronized int getSize() {
        return this.visibleSize;
    }

    public TreeNode getDropLocationNode() {
        return this.dropLocationNode;
    }

    public void setDropLocationNode(Object dropLocationNode) {
        TreeNode prevDropLocNode = this.dropLocationNode;
        this.dropLocationNode = dropLocationNode instanceof TreeNode ? (TreeNode)dropLocationNode : null;
        if (prevDropLocNode != null) {
            int nodeIndex = this.indexOf(prevDropLocNode);
            this.fireContentsChanged(this, nodeIndex, nodeIndex);
        }
    }

    public synchronized TreeNode getVisibleRoot() {
        return this.visibleRoot;
    }

    public synchronized TreeNode getRoot() {
        return this.nodes.get(0);
    }

    public synchronized void setVisibleRoot(TreeNode node) {
        if (!this.nodes.contains(node)) {
            throw new IllegalArgumentException("Passed in node must already be in the TreeViewerListModel");
        }
        if (node == this.visibleRoot) {
            return;
        }
        int startSize = this.getSize();
        int startingVisRootIndex = this.nodes.indexOf(this.visibleRoot);
        int newVisRootIndex = this.nodes.indexOf(node);
        int startingLastVisIndex = this.findLastVisibleIndex();
        TreeNode startingVisRoot = this.visibleRoot;
        this.visibleRoot = node;
        int newLastVisIndex = this.findLastVisibleIndex();
        this.visibleSize = newLastVisIndex - newVisRootIndex + 1;
        if (this.isDescendantOfNode(node, startingVisRoot)) {
            this.fireIntervalRemoved(this, 0, newVisRootIndex - startingVisRootIndex - 1);
            if (newLastVisIndex != startingLastVisIndex) {
                this.fireIntervalRemoved(this, this.visibleSize, startSize - (newVisRootIndex - startingVisRootIndex) - 1);
            }
        } else {
            this.fireIntervalAdded(this, 0, startingVisRootIndex - newVisRootIndex - 1);
            if (newLastVisIndex != startingLastVisIndex) {
                this.fireIntervalAdded(this, startSize + (startingVisRootIndex - newVisRootIndex), this.visibleSize - 1);
            }
        }
    }

    public synchronized boolean parentHasChildrenAfterNode(TreeNode parent, TreeNode node) {
        int nodeIndex = this.nodes.indexOf(node);
        int i = nodeIndex + 1;
        while (i < this.nodes.size()) {
            TreeNode n = this.nodes.get(i);
            if (parent.getId() == n.getParentId()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized TreeNode getFirstChild(TreeNode parent) {
        int nodeIndex = this.nodes.indexOf(parent);
        int i = nodeIndex + 1;
        while (i < this.nodes.size()) {
            TreeNode n = this.nodes.get(i);
            if (parent.getId() == n.getParentId()) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public synchronized TreeNode getNodeById(long id) {
        for (TreeNode t : this.nodes) {
            if ((long)t.getId() != id) continue;
            return t;
        }
        return null;
    }

    public synchronized boolean isDescendantOfNode(TreeNode node, TreeNode ancestor) {
        if (node == ancestor) {
            return true;
        }
        TreeNode n = node;
        while (n.getParentId() != n.getId()) {
            if (n.getParentId() == ancestor.getId()) {
                return true;
            }
            n = this.getNodeById(n.getParentId());
        }
        return false;
    }

    protected synchronized int findLastVisibleIndex() {
        int i = this.nodes.indexOf(this.visibleRoot);
        while (i < this.nodes.size()) {
            TreeNode nodeI = this.nodes.get(i);
            if (!this.isDescendantOfNode(nodeI, this.visibleRoot)) {
                return i - 1;
            }
            ++i;
        }
        return this.nodes.size() - 1;
    }

    public synchronized void showChildNodes(List<TreeNode> childNodes, TreeNode parent) {
        if (parent == null || childNodes == null) {
            return;
        }
        if (!this.isDescendantOfNode(parent, this.visibleRoot)) {
            return;
        }
        if (this.idsShowingChildren.contains(parent.getId())) {
            return;
        }
        this.idsShowingChildren.add(parent.getId());
        int parentIndex = this.nodes.indexOf(parent);
        this.nodes.addAll(parentIndex + 1, childNodes);
        this.visibleSize += childNodes.size();
        this.fireIntervalAdded(this, parentIndex + 1, parentIndex + childNodes.size());
    }

    public synchronized List<Integer> getVisibleRanks() {
        int startIndex;
        ArrayList<Integer> visibleRanks = new ArrayList<Integer>();
        int i = startIndex = this.nodes.indexOf(this.visibleRoot);
        while (i < startIndex + this.visibleSize) {
            TreeNode node = this.nodes.get(i);
            int rank = node.getRank();
            if (!visibleRanks.contains(rank) || this.doAddAllRanks) {
                visibleRanks.add(rank);
            }
            ++i;
        }
        Collections.sort(visibleRanks);
        return visibleRanks;
    }

    public synchronized void removeChildNodes(TreeNode parent) {
        if (parent == null) {
            return;
        }
        int startingSize = this.nodes.size();
        int parentIndex = this.nodes.indexOf(parent);
        if (parentIndex == -1) {
            return;
        }
        this.recursivelyRemoveChildNodesInternal(parent);
        int sizeChange = startingSize - this.nodes.size();
        this.visibleSize -= sizeChange;
        this.fireIntervalRemoved(this, parentIndex + 1, parentIndex + sizeChange);
    }

    protected synchronized void recursivelyRemoveChildNodesInternal(TreeNode parent) {
        if (!this.idsShowingChildren.contains(parent.getId())) {
            return;
        }
        this.idsShowingChildren.remove(parent.getId());
        int parentIndex = this.nodes.indexOf(parent);
        long parentId = parent.getId();
        while (parentIndex + 1 < this.nodes.size()) {
            TreeNode nextNode = this.nodes.get(parentIndex + 1);
            if ((long)nextNode.getParentId() != parentId) break;
            this.recursivelyRemoveChildNodesInternal(nextNode);
            this.nodes.remove(nextNode);
        }
    }

    public synchronized boolean showingChildrenOf(TreeNode node) {
        return this.idsShowingChildren.contains(node.getId());
    }

    protected synchronized void nodeValuesChanged(TreeNode node) {
        int indexOfNode = this.nodes.indexOf(node) - this.nodes.indexOf(this.visibleRoot);
        if (indexOfNode >= 0) {
            this.fireContentsChanged(this, indexOfNode, indexOfNode);
        }
    }

    public synchronized void layoutChanged() {
        this.fireContentsChanged(this, 0, this.visibleSize - 1);
    }

    public synchronized int indexOf(TreeNode node) {
        int visRootIndex;
        int i = this.nodes.indexOf(node);
        if (i >= (visRootIndex = this.nodes.indexOf(this.visibleRoot))) {
            return i - visRootIndex;
        }
        return -1;
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public TreeNode getNode(int index) {
        return this.nodes.get(index);
    }
}

