/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import edu.ku.brc.specify.ui.treetables.TreeViewerListModel;
import edu.ku.brc.specify.ui.treetables.TreeViewerNodeRenderer;
import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.util.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TreeViewerListHeader
extends JPanel
implements ListDataListener {
    protected JList list;
    protected TreeViewerListModel model;
    protected TreeViewerNodeRenderer cellRenderer;
    protected Color textColor;
    protected Color[] bgs;
    protected Font font = null;
    protected HashMap<Integer, String> rankToNameMap = new HashMap();
    protected boolean resizingColumns = false;
    protected Integer expandingRank;
    protected int mostRecentX = -1;
    protected int minColWidth = 50;
    protected BasicStroke basicStroke8 = new BasicStroke(8.0f);

    public TreeViewerListHeader(JList list, TreeViewerListModel tvlm, TreeViewerNodeRenderer listCellRenderer, Map<Integer, String> rankToNameMap) {
        this.list = list;
        this.model = tvlm;
        this.cellRenderer = listCellRenderer;
        this.bgs = listCellRenderer.getBackgroundColors();
        this.model.addListDataListener(this);
        if (list.getFont() != null) {
            this.setFont(list.getFont());
        }
        this.setTextColor(list.getForeground());
        this.setBackground(list.getBackground());
        this.rankToNameMap.putAll(rankToNameMap);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreeViewerListHeader.this.pressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TreeViewerListHeader.this.released(e);
            }
        };
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TreeViewerListHeader.this.dragged(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                TreeViewerListHeader.this.hover(e);
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseMotionAdapter);
    }

    protected void pressed(MouseEvent e) {
        int[] ranksBeingChanged = this.cellRenderer.getRanksSurroundingPoint(e.getX());
        if (ranksBeingChanged == null || ranksBeingChanged[0] == -1) {
            return;
        }
        this.expandingRank = ranksBeingChanged[0];
        this.mostRecentX = e.getX();
        this.resizingColumns = true;
    }

    protected void hover(MouseEvent e) {
        int[] ranksBeingChanged = this.cellRenderer.getRanksSurroundingPoint(e.getX());
        if (ranksBeingChanged == null || ranksBeingChanged[0] == -1) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(11));
    }

    protected void dragged(MouseEvent e) {
        if (this.resizingColumns) {
            int x = e.getX();
            int change = x - this.mostRecentX;
            int currentColWidth = this.cellRenderer.getColumnWidth(this.expandingRank);
            if (currentColWidth + change < this.minColWidth) {
                change = currentColWidth - this.minColWidth;
            }
            if (change == 0) {
                return;
            }
            this.cellRenderer.changeColumnWidth(this.expandingRank, change);
            this.list.invalidate();
            this.list.repaint();
            this.repaint();
            this.setCursor(Cursor.getPredefinedCursor(11));
            this.mostRecentX = x;
        }
    }

    protected void released(MouseEvent e) {
        if (this.resizingColumns) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.resizingColumns = false;
        }
    }

    @Override
    protected synchronized void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicsUtils.turnOnAntialiasedDrawing(g);
        g2.setColor(this.getBackground());
        int w = this.getWidth();
        int h = this.getHeight();
        g2.fillRect(0, 0, w, h);
        int i = 0;
        for (Integer rank : this.model.getVisibleRanks()) {
            String rankName = this.rankToNameMap.get(rank);
            Pair<Integer, Integer> colBounds = this.cellRenderer.getColumnBoundsForRank(rank);
            if (colBounds == null || colBounds.first == null || colBounds.second == null) continue;
            g.setColor(this.bgs[i % 2]);
            g.fillRect((Integer)colBounds.first, 0, (Integer)colBounds.second - (Integer)colBounds.first, this.getHeight());
            ++i;
            g.setColor(this.textColor);
            Font gFont = g.getFont();
            if (this.font == null) {
                this.font = gFont.deriveFont(1).deriveFont((float)gFont.getSize());
            }
            g.setFont(this.font);
            FontMetrics fm = g.getFontMetrics();
            int margin = 4;
            String clippedName = GraphicsUtils.clipString(g.getFontMetrics(), rankName, (Integer)colBounds.second - (Integer)colBounds.first - 2 * margin);
            int x = ((Integer)colBounds.second - (Integer)colBounds.first - fm.stringWidth(clippedName)) / 2;
            int startX = (Integer)colBounds.first + x;
            g.drawString(clippedName, startX, this.getHeight() / 2);
            g.setFont(gFont);
        }
        g2.setColor(this.getBackground());
        g2.setStroke(this.basicStroke8);
        g2.drawLine(0, h, w, h);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @Override
    public int getWidth() {
        return this.list.getWidth();
    }

    @Override
    public int getHeight() {
        int fallback = 32;
        Graphics g = this.list.getGraphics();
        if (g == null) {
            return fallback;
        }
        FontMetrics fm = g.getFontMetrics();
        if (fm == null) {
            return fallback;
        }
        return fm.getHeight() + 20;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.invalidate();
        this.list.invalidate();
        this.list.repaint();
        this.repaint();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.invalidate();
        this.list.invalidate();
        this.list.repaint();
        this.repaint();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.invalidate();
        this.list.invalidate();
        this.list.repaint();
        this.repaint();
    }
}

