/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.EditViewCompSwitcherPanel;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.tasks.DualViewSearchable;
import edu.ku.brc.specify.tasks.TreeTaskMgr;
import edu.ku.brc.specify.treeutils.ChildNodeCounter;
import edu.ku.brc.specify.treeutils.TreeDataService;
import edu.ku.brc.specify.treeutils.TreeDataServiceFactory;
import edu.ku.brc.specify.treeutils.TreeFactory;
import edu.ku.brc.specify.treeutils.TreeHelper;
import edu.ku.brc.specify.treeutils.TreeMergeException;
import edu.ku.brc.specify.treeutils.TreeMerger;
import edu.ku.brc.specify.treeutils.TreeMergerUIIFace;
import edu.ku.brc.specify.ui.treetables.DropDialog;
import edu.ku.brc.specify.ui.treetables.FindPanel;
import edu.ku.brc.specify.ui.treetables.TreeDataGhostDropJList;
import edu.ku.brc.specify.ui.treetables.TreeNode;
import edu.ku.brc.specify.ui.treetables.TreeNodePopupMenu;
import edu.ku.brc.specify.ui.treetables.TreeViewerListHeader;
import edu.ku.brc.specify.ui.treetables.TreeViewerListModel;
import edu.ku.brc.specify.ui.treetables.TreeViewerNodeRenderer;
import edu.ku.brc.ui.DragDropCallback;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class TreeTableViewer<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
extends BaseSubPane
implements DragDropCallback,
DualViewSearchable {
    protected static final Logger log = Logger.getLogger(TreeTableViewer.class);
    private static final int SINGLE_VIEW_MODE = 0;
    private static final int DUAL_VIEW_MODE = 1;
    private static final boolean debugFind = false;
    protected JStatusBar statusBar;
    protected TreeViewerListModel listModel;
    protected TreeDataGhostDropJList[] lists;
    protected JScrollPane[] scrollers;
    protected TreeViewerNodeRenderer listCellRenderer;
    protected TreeViewerListHeader[] listHeaders;
    protected JPanel[] treeListPanels;
    protected FindPanel findPanel;
    protected D treeDef;
    protected List<TreeDefItemIface<T, D, I>> sortedTreeDefItems = null;
    protected String findName;
    protected int resultsIndex;
    protected List<T> findResults;
    protected Integer lastFoundNodeId = null;
    protected boolean isInitialized;
    protected int mode;
    protected TreeNodePopupMenu popupMenu;
    protected boolean busy;
    protected String busyReason;
    protected List<AbstractButton> allButtons;
    protected JButton subtree0;
    protected JButton wholeTree0;
    protected JButton toParent0;
    protected JButton syncViews0;
    protected JButton toggle0;
    protected JButton newChild0 = null;
    protected JButton editNode0 = null;
    protected JButton deleteNode0 = null;
    protected boolean isEditMode;
    protected boolean canAdd;
    protected boolean canDelete;
    protected JButton subtree1;
    protected JButton wholeTree1;
    protected JButton toParent1;
    protected JButton syncViews1;
    protected JButton toggle1;
    protected JButton newChild1 = null;
    protected JButton editNode1 = null;
    protected JButton deleteNode1 = null;
    protected TreeDataService<T, D, I> dataService;
    protected BusinessRulesIFace businessRules;
    protected Set<Integer> idsToReexpand = new HashSet<Integer>();
    protected boolean restoreTreeState = false;
    protected String selNodePrefName;
    protected Icon icon_split;
    protected Icon icon_single;
    protected boolean doUnlock = true;
    protected ExecutorService countGrabberExecutor;

    public TreeTableViewer(D treeDef, String name, Taskable task, boolean isEditMode) {
        super(name, task);
        this.isEditMode = isEditMode;
        PermissionSettings perms = DBTableIdMgr.getInstance().getByShortClassName(treeDef.getNodeClass().getSimpleName()).getPermissions();
        this.canAdd = isEditMode && perms.canAdd();
        this.canDelete = isEditMode && perms.canDelete();
        this.treeDef = treeDef;
        this.sortedTreeDefItems = this.buildSortedTreeDefItems();
        this.allButtons = new Vector<AbstractButton>();
        this.statusBar = UIRegistry.getStatusBar();
        this.popupMenu = new TreeNodePopupMenu(this, isEditMode, this.canAdd, this.canDelete);
        this.getLayout().removeLayoutComponent(this.progressBarPanel);
        this.dataService = TreeDataServiceFactory.createService();
        this.businessRules = DBTableIdMgr.getInstance().getBusinessRule(treeDef.getNodeClass());
        this.restoreTreeState = AppPreferences.getRemote().getBoolean("TreeEditor.RestoreTreeExpansionState", false);
        this.selNodePrefName = "selected_node:" + treeDef.getClass().getSimpleName() + ":" + treeDef.getTreeDefId();
        this.countGrabberExecutor = Executors.newFixedThreadPool(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showingPane(boolean show) {
        super.showingPane(show);
        if (show) {
            TreeTableViewer treeTableViewer = this;
            synchronized (treeTableViewer) {
                if (!this.isInitialized) {
                    this.isInitialized = true;
                    UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString(this.isEditMode ? "TTV_OpeningTreeEditor" : "TTV_OpeningTreeViewer"), 24);
                    edu.ku.brc.helpers.SwingWorker bgThread = new edu.ku.brc.helpers.SwingWorker(){

                        @Override
                        public Object construct() {
                            TreeTableViewer.this.initTreeLists();
                            return true;
                        }

                        @Override
                        public void finished() {
                            UIRegistry.clearGlassPaneMsg();
                        }
                    };
                    bgThread.start();
                }
            }
        }
    }

    protected void setStatusBarText(String key) {
        if (this.statusBar != null) {
            this.statusBar.setText(key == null ? "" : UIRegistry.getResourceString(key));
        }
    }

    protected void setStatusBarText(String key, Object ... params) {
        if (this.statusBar != null) {
            this.statusBar.setText(key == null ? "" : String.format(UIRegistry.getResourceString(key), params));
        }
    }

    protected void setNameIntoStatusBarText(String name) {
        if (this.statusBar != null) {
            this.statusBar.setText(name);
        }
    }

    protected void initTreeLists() {
        T rootRecord = this.dataService.getRootNode(this.treeDef);
        TreeNode rootNode = rootRecord == null ? null : this.createNode(rootRecord);
        this.listModel = new TreeViewerListModel(rootNode);
        if (rootNode != null) {
            this.idsToReexpand.add(rootNode.getId());
            List<TreeNode> childNodes = this.showChildren(rootRecord);
            this.showTree();
            this.showCounts(rootRecord, childNodes);
        } else {
            UIRegistry.displayErrorDlg(UIRegistry.getResourceString("TreeTableViewer.NoRootNodeForTree"));
        }
    }

    protected void showTree() {
        String selectedNodeId;
        MouseListener ml;
        MouseListener[] mouseListeners;
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreeTableViewer.this.mouseButtonClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TreeTableViewer.this.mouseButtonPressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TreeTableViewer.this.mouseButtonReleased(e);
            }
        };
        AppPreferences remotePrefs = AppPreferences.getRemote();
        Class clazz = this.treeDef.getNodeClass();
        Color[] bgs = new Color[]{remotePrefs.getColor("Treeeditor.TreeColColor1." + clazz.getSimpleName(), new Color(202, 238, 255)), remotePrefs.getColor("Treeeditor.TreeColColor2." + clazz.getSimpleName(), new Color(151, 221, 255))};
        Color synonomyColor = remotePrefs.getColor("Treeeditor.SynonymyColor." + clazz.getSimpleName(), Color.BLUE);
        Color lineColor = new Color(0, 0, 0, 102);
        this.listCellRenderer = new TreeViewerNodeRenderer(this, this.listModel, bgs, lineColor, synonomyColor);
        ListSelectionListener listSelListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                TreeDataGhostDropJList sourceList = (TreeDataGhostDropJList)e.getSource();
                TreeNode node = (TreeNode)sourceList.getSelectedValue();
                TreeTableViewer.this.newNodeSelected(sourceList, node);
                TreeTableViewer.this.listModel.setDropLocationNode(null);
            }
        };
        this.lists = new TreeDataGhostDropJList[2];
        this.scrollers = new JScrollPane[2];
        this.listHeaders = new TreeViewerListHeader[2];
        this.treeListPanels = new JPanel[2];
        int rowHeight = 20;
        this.lists[0] = new TreeDataGhostDropJList(this.listModel, this, this.isEditMode);
        this.listModel.addListDataListener(this.listCellRenderer);
        MouseListener[] mouseListenerArray = mouseListeners = this.lists[0].getMouseListeners();
        int n = mouseListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ml = mouseListenerArray[n2];
            this.lists[0].removeMouseListener(ml);
            ++n2;
        }
        this.lists[0].addMouseListener(mouseListener);
        mouseListenerArray = mouseListeners;
        n = mouseListeners.length;
        n2 = 0;
        while (n2 < n) {
            ml = mouseListenerArray[n2];
            this.lists[0].addMouseListener(ml);
            ++n2;
        }
        this.lists[0].setSelectionMode(0);
        this.lists[0].setCellRenderer(this.listCellRenderer);
        this.lists[0].addListSelectionListener(listSelListener);
        this.lists[0].setFixedCellHeight(rowHeight);
        this.lists[1] = new TreeDataGhostDropJList(this.listModel, this, this.isEditMode);
        mouseListenerArray = mouseListeners = this.lists[1].getMouseListeners();
        n = mouseListeners.length;
        n2 = 0;
        while (n2 < n) {
            ml = mouseListenerArray[n2];
            this.lists[1].removeMouseListener(ml);
            ++n2;
        }
        this.lists[1].addMouseListener(mouseListener);
        mouseListenerArray = mouseListeners;
        n = mouseListeners.length;
        n2 = 0;
        while (n2 < n) {
            ml = mouseListenerArray[n2];
            this.lists[1].addMouseListener(ml);
            ++n2;
        }
        this.lists[1].setSelectionMode(0);
        this.lists[1].setCellRenderer(this.listCellRenderer);
        this.lists[1].addListSelectionListener(listSelListener);
        this.lists[1].setFixedCellHeight(rowHeight);
        HashMap<Integer, String> rankNamesMap = new HashMap<Integer, String>();
        for (TreeDefItemIface defItem : this.treeDef.getTreeDefItems()) {
            rankNamesMap.put(defItem.getRankId(), defItem.getDisplayText());
        }
        this.listHeaders[0] = new TreeViewerListHeader(this.lists[0], this.listModel, this.listCellRenderer, rankNamesMap);
        this.listHeaders[1] = new TreeViewerListHeader(this.lists[1], this.listModel, this.listCellRenderer, rankNamesMap);
        this.scrollers[0] = new JScrollPane(this.lists[0]);
        this.scrollers[0].setBackground(Color.WHITE);
        this.scrollers[0].setVerticalScrollBarPolicy(22);
        this.scrollers[0].setColumnHeaderView(this.listHeaders[0]);
        this.scrollers[1] = new JScrollPane(this.lists[1]);
        this.scrollers[1].setBackground(Color.WHITE);
        this.scrollers[1].setVerticalScrollBarPolicy(22);
        this.scrollers[1].setColumnHeaderView(this.listHeaders[1]);
        ImageIcon icon_subtree = IconManager.getIcon("TTV_Subtree", IconManager.IconSize.Std16);
        ImageIcon icon_wholeTree = IconManager.getIcon("TTV_WholeTree", IconManager.IconSize.Std16);
        ImageIcon icon_syncViews = IconManager.getIcon("TTV_SyncViews", IconManager.IconSize.Std16);
        ImageIcon icon_newChild = IconManager.getIcon("TTV_NewChild", IconManager.IconSize.Std16);
        ImageIcon icon_editNode = IconManager.getIcon("TTV_EditNode", IconManager.IconSize.Std16);
        ImageIcon icon_viewNode = IconManager.getIcon("ViewForm16", IconManager.IconSize.Std16);
        ImageIcon icon_delNode = IconManager.getIcon("TTV_DelNode", IconManager.IconSize.Std16);
        ImageIcon icon_toParent = IconManager.getIcon("TTV_ToParent", IconManager.IconSize.Std16);
        this.icon_split = IconManager.getIcon("TTV_SplitViewMode", IconManager.IconSize.Std16);
        this.icon_single = IconManager.getIcon("TTV_SingleViewMode", IconManager.IconSize.Std16);
        JPanel buttonPanel0 = new JPanel();
        buttonPanel0.setLayout(new BoxLayout(buttonPanel0, 3));
        this.subtree0 = new JButton(icon_subtree);
        this.subtree0.setSize(20, 20);
        this.subtree0.setToolTipText(UIRegistry.getResourceString("TTV_ZOOM_IN"));
        this.subtree0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.zoomInOneLevel(TreeTableViewer.this.lists[0]);
            }
        });
        this.wholeTree0 = new JButton(icon_wholeTree);
        this.wholeTree0.setSize(20, 20);
        this.wholeTree0.setToolTipText(UIRegistry.getResourceString("TTV_ZOOM_OUT"));
        this.wholeTree0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.zoomOutOneLevel(TreeTableViewer.this.lists[0]);
            }
        });
        this.wholeTree0.setEnabled(false);
        this.toParent0 = new JButton(icon_toParent);
        this.toParent0.setSize(20, 20);
        this.toParent0.setToolTipText("Select Parent");
        this.toParent0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.selectParentOfSelection(TreeTableViewer.this.lists[0]);
            }
        });
        this.syncViews0 = new JButton(icon_syncViews);
        this.syncViews0.setSize(20, 20);
        this.syncViews0.setToolTipText(UIRegistry.getResourceString("TTV_SYNC_WITH_BOTTOM"));
        this.syncViews0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.syncViewWithOtherView(TreeTableViewer.this.lists[0]);
            }
        });
        this.syncViews0.setEnabled(false);
        this.toggle0 = new JButton(this.icon_split);
        this.toggle0.setSize(20, 20);
        this.toggle0.setToolTipText(UIRegistry.getResourceString("TTV_SPLIT_VIEW"));
        this.toggle0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.toggleViewMode();
            }
        });
        if (this.canAdd) {
            this.newChild0 = new JButton(icon_newChild);
            this.newChild0.setSize(20, 20);
            this.newChild0.setToolTipText("Add Child to Selection");
            this.newChild0.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TreeTableViewer.this.addChildToSelectedNode(TreeTableViewer.this.lists[0]);
                }
            });
        }
        this.editNode0 = new JButton(this.isEditMode ? icon_editNode : icon_viewNode);
        this.editNode0.setSize(20, 20);
        if (this.isEditMode) {
            this.editNode0.setToolTipText(UIRegistry.getResourceString("TreeTableViewer.EditSelectedNode"));
        } else {
            this.editNode0.setToolTipText(UIRegistry.getResourceString("TreeTableViewer.ViewSelectedNode"));
        }
        this.editNode0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.editSelectedNode(TreeTableViewer.this.lists[0]);
            }
        });
        if (this.canDelete) {
            this.deleteNode0 = new JButton(icon_delNode);
            this.deleteNode0.setSize(20, 20);
            this.deleteNode0.setToolTipText(UIRegistry.getResourceString("TTV_DELETE_TOOLTIP"));
            this.deleteNode0.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TreeTableViewer.this.deleteSelectedNode(TreeTableViewer.this.lists[0]);
                }
            });
        }
        JLabel viewLabel0 = UIHelper.createLabel(UIRegistry.getResourceString("View"));
        viewLabel0.setSize(32, viewLabel0.getHeight());
        buttonPanel0.add(viewLabel0);
        viewLabel0.setAlignmentX(0.5f);
        buttonPanel0.add(this.subtree0);
        this.subtree0.setAlignmentX(0.5f);
        buttonPanel0.add(this.wholeTree0);
        this.wholeTree0.setAlignmentX(0.5f);
        buttonPanel0.add(this.toParent0);
        this.toParent0.setAlignmentX(0.5f);
        buttonPanel0.add(this.toggle0);
        this.toggle0.setAlignmentX(0.5f);
        buttonPanel0.add(Box.createRigidArea(new Dimension(20, 20)));
        if (this.isEditMode) {
            JLabel editLabel0 = UIHelper.createLabel(UIRegistry.getResourceString("EDIT"));
            editLabel0.setSize(32, editLabel0.getHeight());
            buttonPanel0.add(editLabel0);
            editLabel0.setAlignmentX(0.5f);
        }
        buttonPanel0.add(this.editNode0);
        this.editNode0.setAlignmentX(0.5f);
        if (this.canAdd) {
            buttonPanel0.add(this.newChild0);
            this.newChild0.setAlignmentX(0.5f);
        }
        if (this.canDelete) {
            buttonPanel0.add(this.deleteNode0);
            this.deleteNode0.setAlignmentX(0.5f);
        }
        if (this.canAdd || this.canDelete) {
            buttonPanel0.add(Box.createVerticalGlue());
        }
        buttonPanel0.add(this.syncViews0);
        this.syncViews0.setAlignmentX(0.5f);
        this.allButtons.add(this.subtree0);
        this.allButtons.add(this.wholeTree0);
        this.allButtons.add(this.toParent0);
        this.allButtons.add(this.toggle0);
        if (this.canAdd) {
            this.allButtons.add(this.newChild0);
        }
        this.allButtons.add(this.editNode0);
        if (this.canDelete) {
            this.allButtons.add(this.deleteNode0);
        }
        this.treeListPanels[0] = new JPanel();
        this.treeListPanels[0].setLayout(new BorderLayout());
        this.treeListPanels[0].add((Component)this.scrollers[0], "Center");
        this.treeListPanels[0].add((Component)buttonPanel0, "East");
        this.findPanel = new FindPanel(this, 1);
        this.treeListPanels[0].add((Component)this.findPanel, "South");
        JPanel buttonPanel1 = new JPanel();
        buttonPanel1.setLayout(new BoxLayout(buttonPanel1, 3));
        this.subtree1 = new JButton(icon_subtree);
        this.subtree1.setSize(20, 20);
        this.subtree1.setToolTipText(UIRegistry.getResourceString("TTV_ZOOM_IN"));
        this.subtree1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.showSubtreeOfSelection(TreeTableViewer.this.lists[1]);
            }
        });
        this.wholeTree1 = new JButton(icon_wholeTree);
        this.wholeTree1.setSize(20, 20);
        this.wholeTree1.setToolTipText(UIRegistry.getResourceString("TTV_ZOOM_OUT"));
        this.wholeTree1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.zoomOutOneLevel(TreeTableViewer.this.lists[1]);
            }
        });
        this.wholeTree1.setEnabled(false);
        this.toParent1 = new JButton(icon_toParent);
        this.toParent1.setSize(20, 20);
        this.toParent1.setToolTipText("Go To Parent");
        this.toParent1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.selectParentOfSelection(TreeTableViewer.this.lists[1]);
            }
        });
        this.syncViews1 = new JButton(icon_syncViews);
        this.syncViews1.setSize(20, 20);
        this.syncViews1.setToolTipText(UIRegistry.getResourceString("TTV_SYNC_WITH_TOP"));
        this.syncViews1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.syncViewWithOtherView(TreeTableViewer.this.lists[1]);
            }
        });
        this.toggle1 = new JButton(this.icon_single);
        this.toggle1.setSize(20, 20);
        this.toggle1.setToolTipText(UIRegistry.getResourceString("TTV_SINGLE_VIEW"));
        this.toggle1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.toggleViewMode();
            }
        });
        if (this.canAdd) {
            this.newChild1 = new JButton(icon_newChild);
            this.newChild1.setSize(20, 20);
            this.newChild1.setToolTipText("Add Child to Selection");
            this.newChild1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TreeTableViewer.this.addChildToSelectedNode(TreeTableViewer.this.lists[1]);
                }
            });
        }
        this.editNode1 = new JButton(this.isEditMode ? icon_editNode : icon_viewNode);
        this.editNode1.setSize(20, 20);
        if (this.isEditMode) {
            this.editNode1.setToolTipText(UIRegistry.getResourceString("TreeTableViewer.EditSelectedNode"));
        } else {
            this.editNode1.setToolTipText(UIRegistry.getResourceString("TreeTableViewer.ViewSelectedNode"));
        }
        this.editNode1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.editSelectedNode(TreeTableViewer.this.lists[1]);
            }
        });
        if (this.canDelete) {
            this.deleteNode1 = new JButton(icon_delNode);
            this.deleteNode1.setSize(20, 20);
            this.deleteNode1.setToolTipText("Delete Selected Node");
            this.deleteNode1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TreeTableViewer.this.deleteSelectedNode(TreeTableViewer.this.lists[1]);
                }
            });
        }
        JLabel viewLabel1 = UIHelper.createLabel("View");
        viewLabel1.setSize(32, viewLabel1.getHeight());
        buttonPanel1.add(viewLabel1);
        viewLabel1.setAlignmentX(0.5f);
        buttonPanel1.add(this.subtree1);
        this.subtree1.setAlignmentX(0.5f);
        buttonPanel1.add(this.wholeTree1);
        this.wholeTree1.setAlignmentX(0.5f);
        buttonPanel1.add(this.toParent1);
        this.toParent1.setAlignmentX(0.5f);
        buttonPanel1.add(this.toggle1);
        this.toggle1.setAlignmentX(0.5f);
        buttonPanel1.add(Box.createRigidArea(new Dimension(20, 20)));
        if (this.isEditMode) {
            JLabel editLabel1 = UIHelper.createLabel(UIRegistry.getResourceString("EDIT"));
            editLabel1.setSize(32, editLabel1.getHeight());
            buttonPanel1.add(editLabel1);
            editLabel1.setAlignmentX(0.5f);
        }
        buttonPanel1.add(this.editNode1);
        this.editNode1.setAlignmentX(0.5f);
        if (this.canAdd) {
            buttonPanel1.add(this.newChild1);
            this.newChild1.setAlignmentX(0.5f);
        }
        if (this.canDelete) {
            buttonPanel1.add(this.deleteNode1);
            this.deleteNode1.setAlignmentX(0.5f);
        }
        if (this.canDelete || this.canAdd) {
            buttonPanel1.add(Box.createVerticalGlue());
        }
        buttonPanel1.add(this.syncViews1);
        this.syncViews1.setAlignmentX(0.5f);
        this.allButtons.add(this.subtree1);
        this.allButtons.add(this.wholeTree1);
        this.allButtons.add(this.toParent1);
        this.allButtons.add(this.toggle1);
        if (this.canAdd) {
            this.allButtons.add(this.newChild1);
        }
        this.allButtons.add(this.editNode1);
        if (this.canDelete) {
            this.allButtons.add(this.deleteNode1);
        }
        this.treeListPanels[1] = new JPanel();
        this.treeListPanels[1].setLayout(new BorderLayout());
        this.treeListPanels[1].add((Component)this.scrollers[1], "Center");
        this.treeListPanels[1].add((Component)buttonPanel1, "East");
        this.setViewMode(0);
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeTableViewer.this.findPanel.expand();
            }
        };
        KeyStroke key = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(1).put(key, "Find");
        this.getActionMap().put("Find", findAction);
        this.lists[0].getInputMap(1).put(key, findAction);
        this.lists[0].getActionMap().put("Find", findAction);
        this.lists[1].getInputMap(1).put(key, findAction);
        this.lists[1].getActionMap().put("Find", findAction);
        this.newNodeSelected(this.lists[0], null);
        this.newNodeSelected(this.lists[1], null);
        AppPreferences prefs = AppPreferences.getRemote();
        if (prefs != null && !(selectedNodeId = prefs.get(this.selNodePrefName, "null")).equals("null")) {
            Integer nodeId = null;
            try {
                nodeId = Integer.parseInt(selectedNodeId);
            }
            catch (NumberFormatException nfe) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(TreeTableViewer.class, nfe);
                nodeId = null;
                log.warn((Object)"'selected_node' preference contained unparsable value.  Removing value.");
                prefs.remove(this.selNodePrefName);
            }
            if (nodeId != null) {
                try {
                    T nodeRecord = this.dataService.getNodeById(this.treeDef.getNodeClass(), nodeId);
                    if (nodeRecord != null) {
                        this.showPathToNode(nodeRecord);
                        TreeNode node = this.listModel.getNodeById(nodeRecord.getTreeId().intValue());
                        this.lists[0].setSelectedValue(node, true);
                        this.lists[0].setSelectedValue(node, true);
                        this.scrollToShowNode(node, 0);
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(TreeTableViewer.class, e);
                    log.warn((Object)"Failed to show and select previously selected node");
                }
            }
        }
        UIRegistry.forceTopFrameRepaint();
        MouseMotionAdapter tooltipRendererListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point p = e.getPoint();
                JList sourceList = (JList)e.getSource();
                int cellIndex = sourceList.locationToIndex(p);
                if (cellIndex == -1) {
                    return;
                }
                TreeNode nodeUnderMouse = TreeTableViewer.this.listModel.getElementAt(cellIndex);
                if (nodeUnderMouse == null) {
                    return;
                }
                Pair<Integer, Integer> textBounds = TreeTableViewer.this.listCellRenderer.getTextBoundsForRank(nodeUnderMouse.getRank());
                if (textBounds == null) {
                    return;
                }
                TreeTableViewer.this.listCellRenderer.setRenderTooltip(p.x >= (Integer)textBounds.first && p.x <= (Integer)textBounds.second);
            }
        };
        this.lists[0].addMouseMotionListener(tooltipRendererListener);
        this.lists[1].addMouseMotionListener(tooltipRendererListener);
    }

    public void updateAllUI() {
        this.listModel.layoutChanged();
    }

    protected void toggleViewMode() {
        if (this.mode == 0) {
            this.setViewMode(1);
        } else {
            this.setViewMode(0);
        }
        this.syncViews0.setEnabled(this.mode == 1);
        this.syncViews1.setEnabled(this.mode == 1);
        this.updateAllUI();
        UIRegistry.forceTopFrameRepaint();
    }

    protected void setViewMode(int newMode) {
        this.removeAll();
        this.mode = newMode;
        if (this.mode == 0) {
            this.add((Component)this.treeListPanels[0], "Center");
            this.toggle0.setToolTipText(UIRegistry.getResourceString("TTV_SPLIT_VIEW"));
            this.toggle0.setIcon(this.icon_split);
        } else {
            this.add((Component)new JSplitPane(0, this.treeListPanels[0], this.treeListPanels[1]), "Center");
            this.toggle0.setToolTipText(UIRegistry.getResourceString("TTV_SINGLE_VIEW"));
            this.toggle0.setIcon(this.icon_single);
        }
        this.updateAllUI();
    }

    protected void syncViewWithOtherView(JList list) {
        if (list == this.lists[0]) {
            Point p = this.scrollers[1].getViewport().getViewPosition();
            this.scrollers[0].getViewport().setViewPosition(p);
        } else {
            Point p = this.scrollers[0].getViewport().getViewPosition();
            this.scrollers[1].getViewport().setViewPosition(p);
        }
    }

    public void addChildToSelectedNode(JList list) {
        Object selection = list.getSelectedValue();
        if (selection == null) {
            return;
        }
        TreeNode parent = (TreeNode)selection;
        T parentRecord = this.getRecordForNode(parent);
        Object parentDefItem = parentRecord.getDefinitionItem();
        if (parentDefItem.getChild() == null) {
            log.info((Object)"Cannot add child node below this rank");
            String msg = UIRegistry.getResourceString("TTV_NO_KIDS_ADD_BELOW");
            this.statusBar.setErrorMessage(msg);
            UIRegistry.displayErrorDlg(msg);
            return;
        }
        Class<?> newT = TreeFactory.createNewTreeable(parentRecord.getClass(), "");
        newT.setDefinitionItem(parentDefItem.getChild());
        newT.setDefinition(parentRecord.getDefinition());
        newT.setParent(parentRecord);
        this.statusBar.setText(null);
        this.showEditDialog(newT, true, null);
    }

    public void unSynSelectedNode(JList list) {
        Object selection = list.getSelectedValue();
        if (selection == null) {
            return;
        }
        TreeNode node = (TreeNode)selection;
        TreeNode acceptedNode = ((TreeViewerListModel)list.getModel()).getNodeById(node.getAcceptedParentId().intValue());
        T nodeRecord = this.getRecordForNode(node);
        log.debug((Object)("Node selected for Un-synonymize: " + node));
        TreeNode nodeParent = this.listModel.getNodeById(node.getParentId());
        TreeNode acceptedNodeParent = null;
        if (acceptedNode != null) {
            acceptedNodeParent = this.listModel.getNodeById(acceptedNode.getParentId());
        }
        this.hideChildren(nodeParent);
        if (acceptedNodeParent != null && acceptedNodeParent != nodeParent) {
            this.hideChildren(acceptedNodeParent);
        }
        String statusMsg = this.dataService.unSynonymize(nodeRecord);
        node.setAcceptedParentId(null);
        node.setAcceptedParentFullName(null);
        if (acceptedNode != null) {
            acceptedNode.removeSynonym(node.getId());
        }
        Vector<TreeNode> bogusity = new Vector<TreeNode>(1);
        bogusity.add(nodeParent);
        nodeParent.setHasCalcCount(false);
        nodeParent.setHasCalcCount2(false);
        this.showCounts(this.getRecordForNode(nodeParent), bogusity);
        this.showChildren(nodeParent);
        if (acceptedNodeParent != null && acceptedNodeParent != nodeParent) {
            bogusity.clear();
            bogusity.add(acceptedNodeParent);
            acceptedNodeParent.setHasCalcCount(false);
            acceptedNodeParent.setHasCalcCount2(false);
            this.showCounts(this.getRecordForNode(acceptedNodeParent), bogusity);
            this.showChildren(acceptedNodeParent);
        }
        UIRegistry.displayStatusBarText(statusMsg);
        this.updateAllUI();
    }

    public void deleteSelectedNode(JList list) {
        Object selection = list.getSelectedValue();
        if (selection == null) {
            return;
        }
        TreeNode node = (TreeNode)selection;
        T nodeRecord = this.getRecordForNode(node);
        int numNodesToDelete = this.dataService.getDescendantCount(nodeRecord) + 1;
        int userChoice = 0;
        if (numNodesToDelete > 1) {
            String msg = String.format(UIRegistry.getResourceString("TTV_CONFIRM_DELETE"), numNodesToDelete);
            userChoice = JOptionPane.showConfirmDialog(this, msg, UIRegistry.getResourceString("TTV_CONFIRM_DELETE_TITLE"), 2, 2);
        }
        if (userChoice == 0) {
            UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TTV_Deleting"), 24);
            TreeNode parent = this.listModel.getNodeById(node.getParentId());
            this.hideChildren(parent);
            if (this.dataService.deleteTreeNode(nodeRecord)) {
                this.setStatusBarText("TTV_NODES_DELETED", numNodesToDelete);
            } else {
                this.statusBar.setErrorMessage(UIRegistry.getResourceString("TTV_PROBLEM_DELETING"));
            }
            this.listCellRenderer.reset();
            this.listHeaders[0].repaint();
            this.listHeaders[1].repaint();
            this.showChildren(parent);
            UIRegistry.clearGlassPaneMsg();
        }
    }

    public void initializeNodeAssociations(T node) {
        this.dataService.initializeRelatedObjects(node);
    }

    public void editSelectedNode(JList list) {
        TreeNode selection = (TreeNode)list.getSelectedValue();
        if (selection == null) {
            return;
        }
        T nodeRecord = this.getRecordForNode(selection);
        this.showEditDialog(nodeRecord, false, selection);
    }

    public synchronized void showSubtreeOfSelection(JList list) {
        TreeNode selectedNode = (TreeNode)list.getSelectedValue();
        if (selectedNode == null) {
            return;
        }
        this.listModel.setVisibleRoot(selectedNode);
        list.setSelectedValue(selectedNode, true);
        list.setSelectedValue(selectedNode, true);
        this.wholeTree0.setEnabled(true);
        this.wholeTree1.setEnabled(true);
        this.updateAllUI();
    }

    public synchronized void zoomInOneLevel(JList list) {
        TreeNode selectedNode = (TreeNode)list.getSelectedValue();
        this.listCellRenderer.reset();
        this.listHeaders[0].repaint();
        this.listHeaders[1].repaint();
        TreeNode visibleRoot = this.listModel.getVisibleRoot();
        if (visibleRoot.hasChildren && (selectedNode == null || selectedNode.getRank() > visibleRoot.getRank())) {
            TreeNode childNode;
            if (selectedNode == null) {
                childNode = this.listModel.getFirstChild(visibleRoot);
            } else if (selectedNode.getParentId() == visibleRoot.getId()) {
                childNode = selectedNode;
            } else {
                TreeNode child = selectedNode;
                TreeNode parent = this.listModel.getNodeById(selectedNode.getParentId());
                while (parent != null && parent.getRank() > visibleRoot.getRank()) {
                    child = parent;
                    parent = this.listModel.getNodeById(parent.getParentId());
                }
                childNode = parent != null ? child : this.listModel.getFirstChild(visibleRoot);
            }
            this.listModel.setVisibleRoot(childNode);
            list.setSelectedValue(selectedNode, true);
            list.setSelectedValue(selectedNode, true);
            this.wholeTree0.setEnabled(this.listModel.getVisibleRoot().getRank() > 0);
            this.wholeTree1.setEnabled(this.listModel.getVisibleRoot().getRank() > 0);
            this.enableSubTreeButtons();
            this.updateAllUI();
        }
    }

    public synchronized void zoomOutOneLevel(JList list) {
        TreeNode selectedNode = (TreeNode)list.getSelectedValue();
        this.listCellRenderer.reset();
        this.listHeaders[0].repaint();
        this.listHeaders[1].repaint();
        TreeNode visibleRoot = this.listModel.getVisibleRoot();
        TreeNode parentNode = this.listModel.getNodeById(visibleRoot.getParentId());
        this.listModel.setVisibleRoot(parentNode);
        list.setSelectedValue(selectedNode, true);
        list.setSelectedValue(selectedNode, true);
        if (this.listModel.getVisibleRoot().getRank() == 0) {
            this.wholeTree0.setEnabled(false);
            this.wholeTree1.setEnabled(false);
        }
        this.enableSubTreeButtons();
        this.updateAllUI();
    }

    public synchronized void showWholeTree(JList list) {
        Object selection = list.getSelectedValue();
        this.listModel.setVisibleRoot(this.listModel.getRoot());
        if (selection != null) {
            list.setSelectedValue(selection, true);
            list.setSelectedValue(selection, true);
        }
    }

    public void selectParentOfSelection(TreeDataGhostDropJList list) {
        Object selection = list.getSelectedValue();
        if (selection == null) {
            return;
        }
        TreeNode node = (TreeNode)selection;
        int parentId = node.getParentId();
        if (parentId != node.getId()) {
            TreeNode parentNode = this.listModel.getNodeById(parentId);
            list.setClickOnText(true);
            list.setSelectedValue(parentNode, true);
            list.setSelectedValue(parentNode, true);
            list.setClickOnText(false);
            int listIndex = list == this.lists[0] ? 0 : 1;
            this.scrollToShowNode(parentNode, listIndex);
        }
    }

    @Override
    public void find(String nodeName, int where, boolean wrap, boolean isExact) {
        this.setStatusBarText(null);
        this.findName = nodeName;
        this.findResults = this.dataService.findByName(this.treeDef, nodeName, isExact);
        if (this.findResults.isEmpty()) {
            log.info((Object)("Search for '" + nodeName + "' returned no results"));
            this.setStatusBarText("TTV_FIND_NO_RESULTS", nodeName);
            return;
        }
        this.findPanel.getNextButton().setEnabled(this.findResults.size() > 1);
        Treeable firstMatch = (Treeable)this.findResults.get(0);
        this.resultsIndex = 0;
        this.showPathToNodeForFind(firstMatch);
        TreeNode firstMatchNode = this.listModel.getNodeById(firstMatch.getTreeId().intValue());
        if (firstMatchNode != null) {
            this.lastFoundNodeId = firstMatchNode.getId();
            if ((where & 1) != 0) {
                this.setSelectedNode(0, firstMatchNode);
                this.scrollToShowNode(firstMatchNode, 0);
            }
            if ((where & 2) != 0) {
                if (this.mode == 0) {
                    this.toggleViewMode();
                }
                this.setSelectedNode(1, firstMatchNode);
                this.scrollToShowNode(firstMatchNode, 1);
            }
        } else {
            this.setStatusBarText("TTV_FIND_NO_RESULTS", nodeName);
        }
    }

    protected void scrollToShowNode(TreeNode node, int listIndex) {
    }

    @Override
    public void findNext(String key, int where, boolean wrap, boolean isExact) {
        this.setStatusBarText(null);
        if (key != null && !key.equals(this.findName)) {
            this.find(key, where, wrap, isExact);
            return;
        }
        if (this.findResults != null && this.findResults.size() > 0 && this.findName != null) {
            log.info((Object)("Searching for next node from previous search: " + this.findName));
            if (this.findResults.size() - 1 == this.resultsIndex && !wrap) {
                this.setStatusBarText("TTV_FIND_NO_RESULTS", key);
                return;
            }
            this.resultsIndex = (this.resultsIndex + 1) % this.findResults.size();
            Treeable nextNode = (Treeable)this.findResults.get(this.resultsIndex);
            this.showPathToNodeForFind(nextNode);
            TreeNode nextMatchNode = this.listModel.getNodeById(nextNode.getTreeId().intValue());
            if ((where & 1) != 0) {
                this.setSelectedNode(0, nextMatchNode);
                this.scrollToShowNode(nextMatchNode, 0);
            }
            if ((where & 2) != 0) {
                if (this.mode == 0) {
                    this.toggleViewMode();
                }
                this.setSelectedNode(1, nextMatchNode);
                this.scrollToShowNode(nextMatchNode, 1);
            }
        }
    }

    public void findNext(int where, boolean wrap, T current, boolean isExact) {
        this.setStatusBarText(null);
        List<T> matches = this.dataService.findByName(this.treeDef, current.getName(), isExact);
        if (matches.size() == 1) {
            this.setStatusBarText("TTV_FIND_NO_MORE_MATCHES");
            return;
        }
        int curIndex = -1;
        int i = 0;
        while (i < matches.size()) {
            Treeable match = (Treeable)matches.get(i);
            if (match.getTreeId().equals(current.getTreeId())) {
                curIndex = i;
            }
            ++i;
        }
        if (!wrap && curIndex == matches.size() - 1) {
            this.setStatusBarText("TTV_FIND_NO_MORE_MATCHES");
            return;
        }
        Treeable nextNode = (Treeable)matches.get((curIndex + 1) % matches.size());
        this.showPathToNodeForFind(nextNode);
        TreeNode nextMatchNode = this.listModel.getNodeById(nextNode.getTreeId().intValue());
        if ((where & 1) != 0) {
            this.setSelectedNode(0, nextMatchNode);
            this.scrollToShowNode(nextMatchNode, 0);
        }
        if ((where & 2) != 0) {
            if (this.mode == 0) {
                this.toggleViewMode();
            }
            this.setSelectedNode(1, nextMatchNode);
            this.scrollToShowNode(nextMatchNode, 1);
        }
    }

    protected void setSelectedNode(int listInx, TreeNode node) {
        this.lists[listInx].setClickOnText(true);
        this.lists[listInx].setSelectedValue(node, true);
        this.lists[listInx].setSelectedValue(node, true);
        this.lists[listInx].setClickOnText(false);
    }

    public void findNext(JList where, boolean wrap, TreeNode currentNode) {
        this.setStatusBarText(null);
        T currentRecord = this.getRecordForNode(currentNode);
        if (where == this.lists[0]) {
            this.findNext(1, wrap, currentRecord, (boolean)AppPreferences.getLocalPrefs().getBoolean("FindPanel.Exact", true));
        } else if (where == this.lists[1]) {
            this.findNext(2, wrap, currentRecord, (boolean)AppPreferences.getLocalPrefs().getBoolean("FindPanel.Exact", true));
        }
    }

    protected T findLastVisibleNode(List<T> pathToNode, TreeNode visRoot) {
        Treeable visNode = null;
        int visNodeIndex = 0;
        for (Treeable node : pathToNode) {
            if (node.getTreeId().intValue() == visRoot.getId()) {
                visNode = node;
                break;
            }
            ++visNodeIndex;
        }
        if (visNode != null) {
            int lastFndIndex = -1;
            int startIndex = this.listModel.indexOf(visRoot);
            int i = visNodeIndex;
            while (i < pathToNode.size()) {
                boolean fnd = false;
                int j = startIndex;
                while (j < this.listModel.getSize()) {
                    if (((Treeable)pathToNode.get(i)).getTreeId().intValue() == this.listModel.getElementAt(j).getId()) {
                        fnd = true;
                        startIndex = j + 1;
                        break;
                    }
                    ++j;
                }
                if (!fnd) {
                    lastFndIndex = i;
                    return (T)((Treeable)pathToNode.get(i - 1));
                }
                ++i;
            }
            if (lastFndIndex == -1) {
                return (T)((Treeable)pathToNode.get(pathToNode.size() - 1));
            }
        }
        return null;
    }

    protected boolean showPathToNodeForFind(T node) {
        List pathToNode = node.getAllAncestors();
        Vector fullList = new Vector(pathToNode);
        fullList.add(node);
        Object lastVisiblenode = this.findLastVisibleNode(fullList, this.listModel.getVisibleRoot());
        if (node == lastVisiblenode) {
            return false;
        }
        if (lastVisiblenode != null) {
            int i = pathToNode.indexOf(lastVisiblenode);
            while (i < pathToNode.size()) {
                Treeable pathRecord = (Treeable)pathToNode.get(i);
                List<TreeNode> childNodes = this.showChildren(pathRecord);
                this.showCounts(pathRecord, childNodes);
                ++i;
            }
        }
        return true;
    }

    protected boolean showPathToNode(T node) {
        List pathToNode = node.getAllAncestors();
        TreeNode visRoot = this.listModel.getVisibleRoot();
        boolean pathContainsVisRoot = false;
        Treeable visRootRecord = null;
        for (Treeable pathItem : pathToNode) {
            if (pathItem.getTreeId().intValue() != visRoot.getId()) continue;
            pathContainsVisRoot = true;
            visRootRecord = pathItem;
            break;
        }
        if (!pathContainsVisRoot) {
            return false;
        }
        int i = pathToNode.indexOf(visRootRecord);
        while (i < pathToNode.size()) {
            Treeable pathRecord = (Treeable)pathToNode.get(i);
            List<TreeNode> childNodes = this.showChildren(pathRecord);
            this.showCounts(pathRecord, childNodes);
            ++i;
        }
        return true;
    }

    protected String getEditDialogHelpContext(Class<?> nodeClass) {
        return null;
    }

    protected void updateSynonymNames(final TreeNode treeNode) {
        new edu.ku.brc.helpers.SwingWorker(){

            @Override
            public Object construct() {
                block2: {
                    block3: {
                        Set<Pair<Integer, String>> syns = treeNode.getSynonymIdsAndNames();
                        if (treeNode.getAcceptedParentId() != null) break block3;
                        for (Pair<Integer, String> syn : syns) {
                            TreeNode synNode = TreeTableViewer.this.listModel.getNodeById(syn.getFirst().intValue());
                            if (synNode == null) continue;
                            synNode.setAcceptedParentFullName(treeNode.getFullName());
                        }
                        break block2;
                    }
                    TreeNode senior = TreeTableViewer.this.listModel.getNodeById(treeNode.getAcceptedParentId().intValue());
                    if (senior == null) break block2;
                    Set<Pair<Integer, String>> seniorjuniors = senior.getSynonymIdsAndNames();
                    for (Pair<Integer, String> junior : seniorjuniors) {
                        if (!junior.getFirst().equals(treeNode.getId())) continue;
                        junior.setSecond(treeNode.getFullName());
                        break;
                    }
                }
                return null;
            }
        }.start();
    }

    protected void showEditDialog(T node, final boolean isNewObject, final TreeNode treeNode) {
        boolean hidTreeNodeChildren;
        Integer acceptedNodeIdBefore;
        String viewName = TreeFactory.getAppropriateViewName(node);
        Frame parentFrame = (Frame)UIRegistry.get("frame");
        String displayName = "NODE_EDIT_DISPLAY_NAME";
        boolean isEdit = this.isEditMode;
        String title = isNewObject ? UIRegistry.getResourceString("TTV_NEW_NODE_TITLE") : (isEdit ? UIRegistry.getResourceString("TTV_EDIT_NODE_TITLE") : UIRegistry.getResourceString("TTV_VIEW_NODE_TITLE"));
        String closeBtnText = isEdit ? UIRegistry.getResourceString("SAVE") : UIRegistry.getResourceString("CLOSE");
        String className = node.getClass().getName();
        DBTableInfo nodeTableInfo = DBTableIdMgr.getInstance().getInfoById(node.getTableId());
        String idFieldName = nodeTableInfo.getIdFieldName();
        int options = 8;
        if (isNewObject) {
            options |= 4;
        }
        ViewBasedDisplayDialog dialog = new ViewBasedDisplayDialog(parentFrame, null, viewName, displayName, title, closeBtnText, className, idFieldName, isEdit, options);
        dialog.setModal(true);
        dialog.setData(node);
        dialog.setHelpContext(this.getEditDialogHelpContext(node.getClass()));
        dialog.preCreateUI();
        for (Viewable viewable : dialog.getMultiView().getViewables()) {
            Component parentComp;
            if (!(viewable instanceof FormViewObj)) continue;
            FormViewObj form = (FormViewObj)viewable;
            UIValidator.setIgnoreAllValidation(this, true);
            if (isNewObject && (parentComp = form.getControlByName("parent")) != null) {
                while (!(parentComp instanceof EditViewCompSwitcherPanel) && parentComp != null) {
                    parentComp = parentComp.getParent();
                }
                if (parentComp != null) {
                    ((EditViewCompSwitcherPanel)parentComp).putIntoViewMode();
                }
            }
            UIValidator.setIgnoreAllValidation(this, false);
        }
        String nodeNameBefore = node.getName();
        Integer parentIdBefore = node.getParent() != null ? node.getParent().getTreeId() : null;
        Integer n = acceptedNodeIdBefore = node.getAcceptedParent() != null ? node.getAcceptedParent().getTreeId() : null;
        if (isEdit) {
            dialog.getMultiView().getCurrentView().getValidator().validateForm();
        }
        dialog.pack();
        boolean bl = hidTreeNodeChildren = treeNode != null && isEdit && this.listModel.parentHasChildrenAfterNode(treeNode, treeNode);
        if (hidTreeNodeChildren) {
            this.hideChildren(treeNode);
        }
        dialog.setVisible(true);
        String nodeNameAfter = node.getName();
        Integer parentIdAfter = node.getParent() != null ? node.getParent().getTreeId() : null;
        final boolean acceptedAfter = node.getIsAccepted() != null ? node.getIsAccepted() : true;
        final boolean nameChanged = !nodeNameBefore.equals(nodeNameAfter);
        boolean parentChanged = parentIdBefore == null && parentIdAfter != null || parentIdBefore != null && parentIdAfter == null || parentIdBefore != null && parentIdAfter != null && parentIdBefore.longValue() != parentIdAfter.longValue();
        log.debug((Object)("nameChange:    " + nameChanged));
        log.debug((Object)("parentChanged: " + parentChanged));
        log.debug((Object)("acceptedAfter: " + acceptedAfter));
        log.debug((Object)("acceptedNodeIdBefore: " + acceptedNodeIdBefore));
        if (dialog.getBtnPressed() == 1 && isEdit) {
            final FormViewObj fvo = dialog.getMultiView().getCurrentViewAsFormViewObj();
            if (fvo != null) {
                fvo.traverseToGetDataFromForms();
            }
            UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TTV_Saving"), 24);
            edu.ku.brc.helpers.SwingWorker bgThread = new edu.ku.brc.helpers.SwingWorker(){
                boolean success;
                boolean afterSaveSuccess;
                T mergedNode;

                @Override
                public Object construct() {
                    this.afterSaveSuccess = this.success = fvo.saveObject();
                    this.mergedNode = (Treeable)fvo.getDataObj();
                    return this.success;
                }

                @Override
                public void finished() {
                    if (this.success) {
                        TreeNode acceptedParentBefore;
                        Object parent;
                        TreeNode editedNode = TreeTableViewer.this.listModel.getNodeById(this.mergedNode.getTreeId().intValue());
                        if (isNewObject) {
                            for (Integer rank : TreeTableViewer.this.listModel.getVisibleRanks()) {
                                if (this.mergedNode.getRankId().equals(rank)) break;
                                if (this.mergedNode.getRankId().compareTo(rank) >= 0) continue;
                                TreeTableViewer.this.listCellRenderer.reset();
                                TreeTableViewer.this.listHeaders[0].repaint();
                                TreeTableViewer.this.listHeaders[1].repaint();
                                break;
                            }
                            if ((parent = this.mergedNode.getParent()) != null) {
                                TreeNode parentNode = TreeTableViewer.this.listModel.getNodeById(parent.getTreeId().intValue());
                                parentNode.setHasChildren(true);
                                TreeTableViewer.this.hideChildren(parentNode);
                                List<TreeNode> childNodes = TreeTableViewer.this.showChildren(parent);
                                TreeTableViewer.this.showCounts(parent, childNodes);
                            }
                        } else {
                            editedNode.setName(this.mergedNode.getName());
                            editedNode.setFullName(this.mergedNode.getFullName());
                            editedNode.setRank(this.mergedNode.getRankId());
                            TreeTableViewer.this.listModel.nodeValuesChanged(editedNode);
                            if (hidTreeNodeChildren) {
                                TreeTableViewer.this.showChildren(treeNode);
                            }
                            if (nameChanged) {
                                parent = this.mergedNode.getParent();
                                if (parent != null) {
                                    TreeNode parentNode = TreeTableViewer.this.listModel.getNodeById(parent.getTreeId().intValue());
                                    parentNode.setHasChildren(true);
                                    TreeTableViewer.this.hideChildren(parentNode);
                                    List<TreeNode> childNodes = TreeTableViewer.this.showChildren(parent);
                                    TreeTableViewer.this.showCounts(parent, childNodes);
                                }
                                TreeTableViewer.this.updateSynonymNames(treeNode);
                            }
                        }
                        if (acceptedAfter && acceptedNodeIdBefore != null && (acceptedParentBefore = TreeTableViewer.this.listModel.getNodeById(acceptedNodeIdBefore.intValue())) != null) {
                            acceptedParentBefore.removeSynonym(editedNode.getId());
                            editedNode.setAcceptedParentFullName(null);
                            editedNode.setAcceptedParentId(null);
                            TreeTableViewer.this.listModel.nodeValuesChanged(acceptedParentBefore);
                            TreeTableViewer.this.listModel.nodeValuesChanged(editedNode);
                        }
                        if (!this.afterSaveSuccess) {
                            String msg = UIRegistry.getResourceString("TTV_METADATA_PROBLEM");
                            UIRegistry.displayErrorDlg(msg);
                            TreeTableViewer.this.statusBar.setErrorMessage(msg);
                        }
                    } else {
                        String msg = UIRegistry.getResourceString("TTV_TRANS_PROBLEM");
                        UIRegistry.displayErrorDlg(msg);
                        TreeTableViewer.this.statusBar.setErrorMessage(msg);
                    }
                    UIRegistry.clearGlassPaneMsg();
                    TreeTableViewer.this.updateAllUI();
                }
            };
            bgThread.start();
        }
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    protected void newNodeSelected(final JList sourceList, final TreeNode selectedNode) {
        boolean canAddChild;
        boolean nonNullSelection;
        String statusBarText = null;
        if (selectedNode != null) {
            statusBarText = selectedNode.getFullName();
        }
        this.setNameIntoStatusBarText(statusBarText);
        boolean bl = nonNullSelection = selectedNode != null;
        boolean bl2 = selectedNode != null ? selectedNode.getRank() < this.getHighestPossibleNodeRank() : (canAddChild = false);
        boolean isVisibleRoot = selectedNode != null ? selectedNode.getId() == this.listModel.getVisibleRoot().getId() : false;
        this.popupMenu.setSelectionSensativeButtonsEnabled(nonNullSelection);
        if (sourceList == this.lists[0]) {
            this.popupMenu.setNewEnabled(canAddChild && nonNullSelection);
            this.editNode0.setEnabled(nonNullSelection);
            if (this.canAdd) {
                this.newChild0.setEnabled(canAddChild && nonNullSelection);
            }
            this.enableSubTreeButtons();
            this.toParent0.setEnabled(!isVisibleRoot);
            if (this.canDelete) {
                this.deleteNode0.setEnabled(false);
            }
            this.popupMenu.setDeleteEnabled(false);
        } else {
            this.popupMenu.setNewEnabled(canAddChild && nonNullSelection);
            this.editNode1.setEnabled(nonNullSelection);
            if (this.canAdd) {
                this.newChild1.setEnabled(canAddChild && nonNullSelection);
            }
            this.enableSubTreeButtons();
            this.toParent1.setEnabled(!isVisibleRoot && nonNullSelection);
            if (this.canDelete) {
                this.deleteNode1.setEnabled(false);
            }
            this.popupMenu.setDeleteEnabled(false);
        }
        this.popupMenu.setUnSynEnabled(selectedNode != null && selectedNode.getAcceptedParentId() != null);
        edu.ku.brc.helpers.SwingWorker bgWork = new edu.ku.brc.helpers.SwingWorker(){
            private T nodeRecord;
            private boolean swCanDelete = false;

            @Override
            public Object construct() {
                this.nodeRecord = null;
                if (selectedNode != null) {
                    this.nodeRecord = TreeTableViewer.this.getRecordForNode(selectedNode);
                }
                this.swCanDelete = TreeTableViewer.this.businessRules != null ? TreeTableViewer.this.businessRules.okToEnableDelete(this.nodeRecord) : false;
                this.swCanDelete = this.swCanDelete && selectedNode != TreeTableViewer.this.listModel.getVisibleRoot();
                return null;
            }

            @Override
            public void finished() {
                boolean validSelection;
                super.finished();
                if (selectedNode != sourceList.getSelectedValue()) {
                    return;
                }
                boolean bl = validSelection = selectedNode != null;
                if (sourceList == TreeTableViewer.this.lists[0]) {
                    if (TreeTableViewer.this.canDelete) {
                        TreeTableViewer.this.deleteNode0.setEnabled(this.swCanDelete && validSelection);
                    }
                    TreeTableViewer.this.popupMenu.setDeleteEnabled(this.swCanDelete && validSelection);
                } else {
                    if (TreeTableViewer.this.canDelete) {
                        TreeTableViewer.this.deleteNode1.setEnabled(this.swCanDelete && validSelection);
                    }
                    TreeTableViewer.this.popupMenu.setDeleteEnabled(this.swCanDelete && validSelection);
                }
            }
        };
        bgWork.start();
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    protected String getSynonymizeTextKey() {
        if (this.treeDef.getNodeClass().equals(Taxon.class)) {
            return "TreeTableViewer.SynonymizeTextTaxon";
        }
        if (this.treeDef.getNodeClass().equals(Geography.class)) {
            return "TreeTableViewer.SynonymizeTextGeography";
        }
        return "TreeTableViewer.SynonymizeText";
    }

    protected String getMergeTextKey() {
        if (this.treeDef.getNodeClass().equals(Taxon.class)) {
            return "TreeTableViewer.MergeTextTaxon";
        }
        if (this.treeDef.getNodeClass().equals(Geography.class)) {
            return "TreeTableViewer.MergeTextGeography";
        }
        if (this.treeDef.getNodeClass().equals(GeologicTimePeriod.class)) {
            return "TreeTableViewer.MergeTextGeologicTimePeriod";
        }
        if (this.treeDef.getNodeClass().equals(LithoStrat.class)) {
            return "TreeTableViewer.MergeTextLithoStrat";
        }
        if (this.treeDef.getNodeClass().equals(Storage.class)) {
            return "TreeTableViewer.MergeTextStorage";
        }
        return "TreeTableViewer.MergeText";
    }

    protected String getMoveTextKey() {
        if (this.treeDef.getNodeClass().equals(Taxon.class)) {
            return "TreeTableViewer.MoveTextTaxon";
        }
        if (this.treeDef.getNodeClass().equals(Geography.class)) {
            return "TreeTableViewer.MoveTextGeography";
        }
        if (this.treeDef.getNodeClass().equals(GeologicTimePeriod.class)) {
            return "TreeTableViewer.MoveTextGeologicTimePeriod";
        }
        if (this.treeDef.getNodeClass().equals(LithoStrat.class)) {
            return "TreeTableViewer.MoveTextLithoStrat";
        }
        if (this.treeDef.getNodeClass().equals(Storage.class)) {
            return "TreeTableViewer.MoveTextStorage";
        }
        return "TreeTableViewer.MoveText";
    }

    private NODE_DROPTYPE askForDropAction(T draggedRecord, T droppedOnRecord, TreeNode droppedOnNode, TreeNode draggedNode) {
        boolean isSynonymizeOK = this.treeDef.isSynonymySupported() && this.isSynonymizeOK(droppedOnNode, draggedNode, this.treeDef.getSynonymizedLevel());
        boolean isMoveOK = this.isMoveOK(droppedOnNode, draggedNode);
        boolean isMergeOK = this.isMergeOK(droppedOnNode, draggedNode);
        DropDialog dlg = new DropDialog((Frame)UIRegistry.getTopWindow(), isMoveOK, isSynonymizeOK, isMergeOK, draggedRecord.getName(), droppedOnNode.getName(), this.getMoveTextKey(), this.getSynonymizeTextKey(), this.getMergeTextKey());
        dlg.createUI();
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled() && dlg.getBtnPressed() != 4) {
            return dlg.getAction();
        }
        return NODE_DROPTYPE.CANCEL_DROP;
    }

    @Override
    public boolean dropOccurred(Object dragged, Object droppedOn, int dropAction) {
        T droppedRecord;
        this.setStatusBarText(null);
        if (dragged == droppedOn) {
            return false;
        }
        this.listModel.setDropLocationNode(null);
        this.repaint();
        if (!(dragged instanceof TreeNode) || !(droppedOn instanceof TreeNode)) {
            log.warn((Object)"Ignoring drag and drop of unhandled types of objects");
            return false;
        }
        final TreeNode draggedNode = (TreeNode)dragged;
        final TreeNode droppedOnNode = (TreeNode)droppedOn;
        final T draggedRecord = this.getRecordForNode(draggedNode);
        NODE_DROPTYPE nodeDropAction = this.askForDropAction(draggedRecord, droppedRecord = this.getRecordForNode(droppedOnNode), droppedOnNode, draggedNode);
        if (nodeDropAction == NODE_DROPTYPE.SYNONIMIZE_NODE) {
            log.info((Object)("User requested new link be created between " + draggedNode.getName() + " and " + droppedOnNode.getName()));
            UsageTracker.incrUsageCount("TreeTableViewer.SynonomizeNode");
            if (draggedNode.getAcceptedParentId() != null && droppedOnNode.getId() == draggedNode.getAcceptedParentId().intValue()) {
                return false;
            }
            new SwingWorker<Boolean, Object>(){
                boolean result = false;

                protected void finalize() throws Throwable {
                    super.finalize();
                    if (!this.isDone()) {
                        log.error((Object)"A background thread for a tree synonymize action did not terminate correctly.");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UIRegistry.clearGlassPaneMsg();
                            }
                        });
                    }
                }

                @Override
                public Boolean doInBackground() {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UIRegistry.writeGlassPaneMsg(String.format(UIRegistry.getResourceString("TreeTableViewer.Synonymizing"), draggedRecord.getName()), 24);
                            }
                        });
                        final TreeNode draggedNodeParent = TreeTableViewer.this.listModel.getNodeById(draggedNode.getParentId());
                        final TreeNode droppedNodeParent = TreeTableViewer.this.listModel.getNodeById(droppedOnNode.getParentId());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TreeTableViewer.this.hideChildren(draggedNodeParent);
                                if (droppedNodeParent != draggedNodeParent) {
                                    TreeTableViewer.this.hideChildren(droppedNodeParent);
                                }
                            }
                        });
                        String statusMsg = TreeTableViewer.this.dataService.synonymize(draggedRecord, droppedRecord);
                        if (statusMsg == null) {
                            draggedNode.setAcceptedParentId(droppedOnNode.getId());
                            for (Pair<Integer, String> idAndName : draggedNode.getSynonymIdsAndNames()) {
                                if (idAndName.first != null) {
                                    int synNodeID = (Integer)idAndName.first;
                                    TreeNode synNode = TreeTableViewer.this.listModel.getNodeById(synNodeID);
                                    if (synNode == null) continue;
                                    synNode.setAcceptedParentId(droppedOnNode.getId());
                                    synNode.setAcceptedParentFullName(droppedOnNode.getFullName());
                                    droppedOnNode.getSynonymIdsAndNames().add(new Pair<Integer, String>(synNode.getId(), synNode.getFullName()));
                                    continue;
                                }
                                String msg = "** - JDS - ** idAndName.first was null and shouldn't have been.";
                                log.error((Object)msg);
                                UIRegistry.displayErrorDlg(msg);
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    draggedNode.getSynonymIdsAndNames().clear();
                                    draggedNode.setAcceptedParentFullName(droppedOnNode.getFullName());
                                    droppedOnNode.getSynonymIdsAndNames().add(new Pair<Integer, String>(draggedNode.getId(), draggedNode.getFullName()));
                                    Vector<TreeNode> bogusity = new Vector<TreeNode>(1);
                                    bogusity.add(draggedNodeParent);
                                    draggedNodeParent.setHasCalcCount(false);
                                    draggedNodeParent.setHasCalcCount2(false);
                                    TreeTableViewer.this.showCounts(TreeTableViewer.this.getRecordForNode(draggedNodeParent), bogusity);
                                    TreeTableViewer.this.showChildren(draggedNodeParent);
                                    if (droppedNodeParent != draggedNodeParent) {
                                        droppedNodeParent.setHasCalcCount(false);
                                        droppedNodeParent.setHasCalcCount2(false);
                                        bogusity.clear();
                                        bogusity.add(droppedNodeParent);
                                        TreeTableViewer.this.showCounts(TreeTableViewer.this.getRecordForNode(droppedNodeParent), bogusity);
                                        TreeTableViewer.this.showChildren(droppedNodeParent);
                                    }
                                }
                            });
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TreeTableViewer.this.updateAllUI();
                            }
                        });
                        if (statusMsg != null) {
                            TreeTableViewer.this.statusBar.setText(statusMsg);
                        }
                        this.result = statusMsg == null;
                        return this.result;
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                        return false;
                    }
                }

                @Override
                protected void done() {
                    super.done();
                    log.info((Object)"Synonymization finished. Clearing glasspane.");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.clearGlassPaneMsg();
                        }
                    });
                    if (!this.result) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UIRegistry.displayErrorDlgLocalized("TreeTableViewer.TreeOperationFailed", UIRegistry.getResourceString("TreeTableViewer.SynOp"));
                                SubPaneMgr.getInstance().removePane(TreeTableViewer.this, false);
                            }
                        });
                    }
                }
            }.execute();
            return true;
        }
        if (nodeDropAction == NODE_DROPTYPE.MOVE_NODE) {
            final T child = draggedRecord;
            final T newParent = droppedRecord;
            final TreeNode oldParentNode = this.listModel.getNodeById(draggedNode.getParentId());
            final TreeNode newParentNode = droppedOnNode;
            log.info((Object)("move requested: " + child.getFullName() + " to " + newParent.getFullName()));
            UsageTracker.incrUsageCount("TreeTableViewer.MoveNode");
            if (!TreeHelper.canChildBeReparentedToNode(child, newParent)) {
                log.info((Object)("Cannot reparent " + child.getName() + " to " + newParent.getName()));
                return false;
            }
            new SwingWorker<Boolean, Object>(){
                Boolean result = false;

                protected void finalize() throws Throwable {
                    super.finalize();
                    if (!this.isDone()) {
                        log.error((Object)"A background thread for a tree move action did not terminate correctly.");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UIRegistry.clearGlassPaneMsg();
                            }
                        });
                    }
                }

                @Override
                public Boolean doInBackground() {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UIRegistry.writeGlassPaneMsg(String.format(UIRegistry.getResourceString("TreeTableViewer.Moving"), child.getName()), 24);
                                TreeTableViewer.this.hideChildren(oldParentNode);
                                TreeTableViewer.this.hideChildren(droppedOnNode);
                            }
                        });
                        int moveResult = TreeTableViewer.this.dataService.moveTreeNode(child, newParent);
                        if (moveResult == 64) {
                            String msg = UIRegistry.getResourceString("TTV_UNKOWN_MOVE_ERROR");
                            TreeTableViewer.this.statusBar.setErrorMessage(msg);
                            UIRegistry.displayErrorDlg(msg);
                        }
                        final TreeNode oldParentNodeReshow = TreeTableViewer.this.listModel.getNodeById(oldParentNode.getId());
                        final TreeNode newParentNodeReshow = TreeTableViewer.this.listModel.getNodeById(newParentNode.getId());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (oldParentNodeReshow != null) {
                                    TreeTableViewer.this.showChildren(oldParentNodeReshow);
                                }
                                if (newParentNodeReshow != null) {
                                    newParentNodeReshow.setHasChildren(true);
                                    TreeTableViewer.this.showChildren(newParentNodeReshow);
                                }
                            }
                        });
                        this.result = moveResult != 64;
                        return this.result;
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                        return false;
                    }
                }

                @Override
                protected void done() {
                    super.done();
                    log.info((Object)"Moved Node. Clearing glasspane.");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.clearGlassPaneMsg();
                        }
                    });
                    if (!this.result.booleanValue()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UIRegistry.displayErrorDlgLocalized("TreeTableViewer.TreeOperationFailed", UIRegistry.getResourceString("TreeTableViewer.MoveOp"));
                                SubPaneMgr.getInstance().removePane(TreeTableViewer.this, false);
                            }
                        });
                    }
                }
            }.execute();
            return true;
        }
        if (nodeDropAction == NODE_DROPTYPE.MERGE_NODE) {
            UsageTracker.incrUsageCount("WB.ShowWorkbenchProps");
            final TreeNode oldParentNode = this.listModel.getNodeById(draggedNode.getParentId());
            final TreeNode newParentNode = droppedOnNode;
            log.info((Object)("merging " + oldParentNode.fullName + "(" + oldParentNode.id + ") into " + newParentNode.fullName + "(" + newParentNode.id + ")"));
            UsageTracker.incrUsageCount("TreeTableViewer.MergeNodes");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeTableViewer.this.hideChildren(oldParentNode);
                    TreeTableViewer.this.hideChildren(newParentNode);
                }
            });
            TreeMergerUIIFace face = new TreeMergerUIIFace<T, D, I>(){

                @Override
                public Integer choose(List<Integer> choices, boolean mustChoose) {
                    System.out.print(mustChoose ? "You MUST choose: " : "Choose: ");
                    for (Integer id : choices) {
                        System.out.print(id + "  ");
                    }
                    System.out.println();
                    return null;
                }

                @Override
                public void merged(Integer toMergeId, Integer mergeIntoId) {
                    System.out.println("merged " + toMergeId + " into " + mergeIntoId);
                }

                @Override
                public void merging(Integer toMergeId, Integer mergeIntoId) {
                    System.out.println("merging " + toMergeId + " into " + mergeIntoId);
                }

                @Override
                public void moved(Integer movedId, Integer oldParentId, Integer newParentId) {
                    System.out.println("moved " + movedId + " from " + oldParentId + " to " + newParentId);
                }
            };
            final TreeMerger merger = new TreeMerger(this.treeDef);
            merger.addListener(face);
            new SwingWorker<Object, Object>(){
                Boolean result = false;
                Exception killer = null;

                @Override
                protected Object doInBackground() throws Exception {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TreeTableViewer.Merging"), 24);
                            TreeTableViewer.this.hideChildren(oldParentNode);
                            TreeTableViewer.this.hideChildren(droppedOnNode);
                        }
                    });
                    try {
                        merger.mergeTrees(draggedNode.getId(), droppedOnNode.getId());
                        this.result = true;
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                        this.result = false;
                        this.killer = ex;
                    }
                    return this.result;
                }

                @Override
                protected void done() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.clearGlassPaneMsg();
                        }
                    });
                    if (this.result.booleanValue()) {
                        try {
                            TreeTableViewer.this.treeDef.updateAllNodes(null, true, true);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(TreeTableViewer.class, ex);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TreeTableViewer.this.showChildren(oldParentNode);
                            TreeTableViewer.this.showChildren(newParentNode);
                        }
                    });
                    if (!this.result.booleanValue() && this.killer != null) {
                        if (this.killer instanceof TreeMergeException) {
                            UIRegistry.displayErrorDlg(this.killer.getMessage());
                        } else {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(TreeTableViewer.class, this.killer);
                        }
                    }
                }
            }.execute();
        }
        return false;
    }

    private boolean isSynonymizeOK(TreeNode droppedOnNode, TreeNode draggedNode, int rankLevel) {
        if (draggedNode.getAcceptedParentId() == null && droppedOnNode.getAcceptedParentId() == null) {
            Integer acceptedChildren;
            if (draggedNode.isHasChildren() && (acceptedChildren = BasicSQLUtils.getCount("select count(*) from " + this.treeDef.getNodeClass().getSimpleName().toLowerCase() + " where ParentId = " + draggedNode.getId() + " and IsAccepted")) != null && acceptedChildren > 0) {
                return false;
            }
            int draggedRankId = draggedNode.getRank();
            int droppedRankId = droppedOnNode.getRank();
            if (rankLevel == -1 || draggedRankId >= rankLevel && droppedRankId >= rankLevel || draggedRankId == droppedRankId) {
                boolean descendant = this.listModel.isDescendantOfNode(droppedOnNode, draggedNode);
                return !descendant;
            }
        }
        return false;
    }

    private List<TreeDefItemIface<T, D, I>> buildSortedTreeDefItems() {
        Vector<TreeDefItemIface<T, D, I>> result = new Vector<TreeDefItemIface<T, D, I>>(this.treeDef.getTreeDefItems());
        Collections.sort(result, new Comparator<TreeDefItemIface<T, D, I>>(){

            @Override
            public int compare(TreeDefItemIface<T, D, I> arg0, TreeDefItemIface<T, D, I> arg1) {
                return arg0.getRankId().compareTo(arg1.getRankId());
            }
        });
        return result;
    }

    private String getTreeTableName() {
        Class cls = this.treeDef.getNodeClass();
        try {
            Method tblIdGetter = cls.getMethod("getClassTableId", null);
            Integer tableId = (Integer)tblIdGetter.invoke(null, null);
            return DBTableIdMgr.getInstance().getInfoById(tableId).getName();
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (InvocationTargetException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    private List<Object> getInvalidChildRanksForMerge(TreeNode upper, TreeNode lower) {
        String sql = null;
        String tbl = this.getTreeTableName();
        if (tbl != null) {
            sql = "select distinct RankID from " + tbl + " where ParentID = " + upper.getId() + " and RankID <= " + lower.getRank() + " order by RankID";
        }
        if (sql != null) {
            return BasicSQLUtils.querySingleCol(sql);
        }
        log.error((Object)("Unable to check ranks for merge: upper=" + upper.getFullName() + ", lower=" + lower.getFullName()));
        return null;
    }

    private boolean isMergeOK(TreeNode droppedOnNode, TreeNode draggedNode) {
        boolean synOK;
        boolean bl = synOK = droppedOnNode.getAcceptedParentId() == null;
        if (!synOK) {
            return false;
        }
        if (droppedOnNode.getRank() != draggedNode.getRank()) {
            Object draggedDef = this.treeDef.getDefItemByRank(draggedNode.getRank());
            if (droppedOnNode.getRank() < draggedNode.getRank()) {
                if (draggedDef.getIsEnforced() != null && draggedDef.getIsEnforced().booleanValue()) {
                    return false;
                }
                for (TreeDefItemIface<T, D, I> di : this.sortedTreeDefItems) {
                    if (draggedDef.getIsEnforced() == null || !draggedDef.getIsEnforced().booleanValue() || di.getRankId() <= droppedOnNode.getRank() || di.getRankId() >= draggedNode.getRank()) continue;
                    return false;
                }
            } else {
                List<Object> invalidRanks = this.getInvalidChildRanksForMerge(draggedNode, droppedOnNode);
                if (invalidRanks == null || invalidRanks.size() > 0) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isMoveOK(TreeNode droppedOnNode, TreeNode draggedNode) {
        return TreeHelper.canChildBeReparentedToNode(draggedNode.getRank(), droppedOnNode.getRank(), this.treeDef) && draggedNode.getParentId() != droppedOnNode.getId() && droppedOnNode.getAcceptedParentId() == null;
    }

    @Override
    public boolean dropAcceptable(Object dragged, Object droppedOn, int dropAction) {
        boolean isOK;
        if (dragged == droppedOn) {
            this.listModel.setDropLocationNode(null);
            this.setStatusBarText(null);
            if (UIHelper.getOSType() != UIHelper.OSTYPE.Windows) {
                this.repaint();
            }
            return false;
        }
        if (UIHelper.getOSType() != UIHelper.OSTYPE.Windows) {
            this.repaint();
        }
        if (!(dragged instanceof TreeNode) || !(droppedOn instanceof TreeNode)) {
            this.listModel.setDropLocationNode(null);
            this.setStatusBarText(null);
            return false;
        }
        TreeNode droppedOnNode = (TreeNode)droppedOn;
        TreeNode draggedNode = (TreeNode)dragged;
        boolean isNodeDiff = this.listModel.getDropLocationNode() != droppedOnNode;
        this.listModel.setDropLocationNode(null);
        String msg = "";
        boolean bl = isOK = this.treeDef.isSynonymySupported() && this.isSynonymizeOK(droppedOnNode, draggedNode, this.treeDef.getSynonymizedLevel());
        if (isOK) {
            this.listModel.setDropLocationNode(droppedOn);
            if (isNodeDiff) {
                msg = UIRegistry.getResourceString("TreeViewer.SYN_IS_OK");
            }
        }
        if (this.isMoveOK(droppedOnNode, draggedNode)) {
            if (!isOK) {
                this.listModel.setDropLocationNode(droppedOn);
                isOK = true;
            }
            if (isNodeDiff) {
                msg = String.valueOf(msg) + (msg.length() > 0 ? ", " : "") + UIRegistry.getResourceString("TreeViewer.MOVE_IS_OK");
            }
        }
        if (this.isMergeOK(droppedOnNode, draggedNode)) {
            if (!isOK) {
                this.listModel.setDropLocationNode(droppedOn);
                isOK = true;
            }
            if (isNodeDiff) {
                msg = String.valueOf(msg) + (msg.length() > 0 ? ", " : "") + UIRegistry.getResourceString("TreeViewer.MERGE_IS_OK");
            }
        }
        if (isNodeDiff) {
            UIRegistry.getStatusBar().setText(isOK ? msg : "");
        }
        return isOK;
    }

    @Override
    public void dragDropEnded(boolean success) {
        this.listModel.setDropLocationNode(null);
    }

    public void showPopup(MouseEvent e) {
        int index;
        TreeDataGhostDropJList list;
        if (this.clickIsOnText(e)) {
            Point p;
            list = (TreeDataGhostDropJList)e.getSource();
            index = list.locationToIndex(p = e.getPoint());
            if (index == -1) {
                return;
            }
        } else {
            return;
        }
        list.setSelectedIndex(index);
        list.setSelectedIndex(index);
        this.popupMenu.setList(list);
        this.popupMenu.show(list, e.getX(), e.getY());
    }

    protected boolean clickIsOnText(MouseEvent e) {
        Point p;
        TreeDataGhostDropJList list = (TreeDataGhostDropJList)e.getSource();
        int index = list.locationToIndex(p = e.getPoint());
        if (index == -1) {
            return false;
        }
        TreeNode t = this.listModel.getElementAt(index);
        Integer rank = t.getRank();
        Pair<Integer, Integer> textBounds = this.listCellRenderer.getTextBoundsForRank(rank);
        return (Integer)textBounds.first < p.x && p.x < (Integer)textBounds.second;
    }

    protected boolean clickIsOnExpansionIcon(MouseEvent e) {
        Point p;
        TreeDataGhostDropJList list = (TreeDataGhostDropJList)e.getSource();
        int index = list.locationToIndex(p = e.getPoint());
        if (index == -1) {
            return false;
        }
        ListModel model = list.getModel();
        TreeNode t = (TreeNode)model.getElementAt(index);
        Integer rank = t.getRank();
        Pair<Integer, Integer> anchorBounds = this.listCellRenderer.getAnchorBoundsForRank(rank);
        return (Integer)anchorBounds.first < p.x && p.x < (Integer)anchorBounds.second;
    }

    protected void enableSubTreeButtons() {
        this.enableSubTreeButton(this.subtree0, this.lists[0]);
        this.enableSubTreeButton(this.subtree1, this.lists[1]);
    }

    protected void enableSubTreeButton(JButton btn, JList list) {
        TreeNode selected;
        TreeNode root = this.listModel.getVisibleRoot();
        if (root == (selected = (TreeNode)list.getSelectedValue())) {
            btn.setEnabled(false);
            return;
        }
        TreeNode testNode = selected != null ? selected : root;
        List<Integer> ranks = this.listModel.getVisibleRanks();
        int lowestRank = ranks.get(ranks.size() - 1);
        btn.setEnabled(lowestRank != testNode.getRank() || testNode != root);
    }

    public void mouseButtonClicked(MouseEvent e) {
        Point p;
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
        if (e.getButton() != 1) {
            return;
        }
        TreeDataGhostDropJList list = (TreeDataGhostDropJList)e.getSource();
        int index = list.locationToIndex(p = e.getPoint());
        if (index == -1) {
            return;
        }
        ListModel model = list.getModel();
        TreeNode treeNode = (TreeNode)model.getElementAt(index);
        if (this.clickIsOnExpansionIcon(e) || e.getClickCount() == 2 && this.clickIsOnText(e)) {
            treeNode.setHasVisualChildren(null);
            if (this.listModel.showingChildrenOf(treeNode)) {
                this.hideChildren(treeNode);
                this.enableSubTreeButtons();
            } else {
                List<TreeNode> childrenShown = this.showChildren(treeNode);
                if (childrenShown.size() > 0) {
                    TreeNode firstChild = childrenShown.get(0);
                    int listIndex = list == this.lists[0] ? 0 : 1;
                    this.scrollToShowNode(firstChild, listIndex);
                    this.enableSubTreeButtons();
                }
            }
            this.listCellRenderer.reset();
            this.listHeaders[0].repaint();
            this.listHeaders[1].repaint();
        } else {
            e.consume();
        }
    }

    protected int getHighestPossibleNodeRank() {
        return this.sortedTreeDefItems.get(this.sortedTreeDefItems.size() - 1).getRankId();
    }

    public void mouseButtonReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mouseButtonPressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
        if (e.getButton() != 1) {
            return;
        }
        TreeDataGhostDropJList list = (TreeDataGhostDropJList)e.getSource();
        boolean clickIsOnText = this.clickIsOnText(e);
        if (clickIsOnText) {
            list.setClickOnText(true);
        } else {
            list.setClickOnText(false);
        }
    }

    @Override
    public boolean aboutToShutdown() {
        if (this.lists != null) {
            try {
                T selectedNode = this.getSelectedNode(this.lists[0]);
                AppPreferences appPrefs = AppPreferences.getRemote();
                if (appPrefs != null) {
                    if (selectedNode != null) {
                        appPrefs.put(this.selNodePrefName, selectedNode.getTreeId().toString());
                    } else {
                        appPrefs.remove(this.selNodePrefName);
                    }
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(TreeTableViewer.class, e);
                log.error((Object)"Unknown error when trying to store the selected node id during tree viewer shutdown.", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.countGrabberExecutor.shutdownNow();
        if (this.doUnlock) {
            TaskSemaphoreMgr.unlock(this.name, this.treeDef.getClass().getSimpleName(), TaskSemaphoreMgr.SCOPE.Discipline);
        }
        super.shutdown();
        TreeTaskMgr.checkLocks();
    }

    public void setDoUnlock(boolean doUnlock) {
        this.doUnlock = doUnlock;
    }

    public boolean isDoUnlock() {
        return this.doUnlock;
    }

    public T getSelectedNode(JList list) {
        if (this.lists[0] == list || this.lists[1] == list) {
            TreeNode node = (TreeNode)list.getSelectedValue();
            if (node == null) {
                return null;
            }
            return this.getRecordForNode(node);
        }
        throw new IllegalArgumentException("Provided JList must be one of the TTV display lists");
    }

    public TreeNodePopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    private TreeNode createNode(T dataRecord) {
        int parentRank;
        int parentId;
        String nodeName = dataRecord.getName();
        String fullName = dataRecord.getFullName();
        int id = dataRecord.getTreeId();
        int rank = dataRecord.getRankId();
        Object acceptedParent = dataRecord.getAcceptedParent();
        Object parentRecord = dataRecord.getParent();
        if (parentRecord == null) {
            parentId = id;
            parentRank = -1;
        } else {
            parentId = parentRecord.getTreeId();
            parentRank = parentRecord.getRankId();
        }
        int descCount = this.dataService.getDescendantCount(dataRecord);
        Set<T> synonyms = this.dataService.getSynonyms(dataRecord);
        HashSet<Integer> synIds = new HashSet<Integer>();
        HashSet<String> synNames = new HashSet<String>();
        for (Treeable syn : synonyms) {
            synIds.add(syn.getTreeId());
            synNames.add(syn.getFullName());
        }
        Set<Pair<Integer, String>> synIdsAndNames = this.dataService.getSynonymIdsAndNames(dataRecord.getClass(), id);
        Integer acceptParentId = acceptedParent != null ? acceptedParent.getTreeId() : null;
        String acceptParentFullName = acceptedParent != null ? acceptedParent.getFullName() : null;
        TreeNode node = new TreeNode(nodeName, fullName, id, parentId, rank, parentRank, descCount != 0, acceptParentId, acceptParentFullName, synIdsAndNames);
        node.setDataObjClass(dataRecord.getClass());
        return node;
    }

    public void repaintLists() {
        if (this.lists != null) {
            TreeDataGhostDropJList[] treeDataGhostDropJListArray = this.lists;
            int n = this.lists.length;
            int n2 = 0;
            while (n2 < n) {
                TreeDataGhostDropJList lst = treeDataGhostDropJListArray[n2];
                if (lst != null) {
                    lst.repaint();
                }
                ++n2;
            }
        }
    }

    protected synchronized void showCounts(T dbRecord, List<TreeNode> childNodes) {
        String propName = "TreeEditor.Rank.Threshold." + dbRecord.getClass().getSimpleName();
        final int rankThreshold = AppPreferences.getRemote().getInt(propName, -1);
        Class<?> dbRecClass = dbRecord.getClass();
        boolean isHQL = TreeFactory.isQueryHQL(dbRecClass);
        for (TreeNode newNode : childNodes) {
            if (!newNode.shouldCalcCount()) continue;
            TreeNode node = newNode;
            Runnable getAssocRecCount = new Runnable((Treeable)dbRecord, node, dbRecClass, isHQL){
                private final /* synthetic */ Treeable val$dbRecord;
                private final /* synthetic */ TreeNode val$node;
                private final /* synthetic */ Class val$dbRecClass;
                private final /* synthetic */ boolean val$isHQL;
                {
                    this.val$dbRecord = treeable;
                    this.val$node = treeNode;
                    this.val$dbRecClass = clazz;
                    this.val$isHQL = bl;
                }

                @Override
                public void run() {
                    try {
                        if (rankThreshold == -1 || this.val$dbRecord.getRankId() >= rankThreshold) {
                            new ChildNodeCounter(TreeTableViewer.this, 1, this.val$node, TreeFactory.getRelatedRecordCountSQLSingleNode(this.val$dbRecClass), null, this.val$isHQL);
                            new ChildNodeCounter(TreeTableViewer.this, 2, this.val$node, TreeFactory.getNodeNumberQuery(this.val$dbRecClass), TreeFactory.getRelatedRecordCountSQLForRange(this.val$dbRecClass, this.val$node), this.val$isHQL);
                        }
                    }
                    catch (Exception e) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(TreeTableViewer.class, e);
                        log.error((Object)e);
                        e.printStackTrace();
                    }
                }
            };
            this.countGrabberExecutor.submit(getAssocRecCount);
        }
    }

    protected synchronized List<TreeNode> showChildren(T dbRecord) {
        List<TreeNode> childNodes = this.dataService.getChildTreeNodes(dbRecord);
        TreeNode parentNode = this.listModel.getNodeById(dbRecord.getTreeId().intValue());
        if (childNodes.size() == 0) {
            if (parentNode != null) {
                parentNode.setHasChildren(false);
                parentNode.setHasVisualChildren(false);
                this.listModel.nodeValuesChanged(parentNode);
            }
            return childNodes;
        }
        if (parentNode != null) {
            parentNode.setHasVisualChildren(true);
        }
        this.listModel.showChildNodes(childNodes, parentNode);
        if (parentNode != null) {
            this.idsToReexpand.add(parentNode.getId());
        }
        if (this.restoreTreeState) {
            for (TreeNode childNode : childNodes) {
                if (!this.idsToReexpand.contains(childNode.getId())) continue;
                this.idsToReexpand.remove(childNode.getId());
                this.showChildrenInTimer(childNode);
            }
        }
        return childNodes;
    }

    protected void showChildrenInTimer(final TreeNode childNode) {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableViewer.this.showChildren(childNode);
            }
        };
        Timer swingTimer = new Timer(200, al);
        swingTimer.setRepeats(false);
        swingTimer.start();
    }

    protected synchronized List<TreeNode> showChildren(TreeNode parent) {
        T dbRecord = this.getRecordForNode(parent);
        List<TreeNode> childNodes = this.showChildren(dbRecord);
        this.showCounts(dbRecord, childNodes);
        return childNodes;
    }

    protected synchronized void hideChildren(TreeNode parent) {
        parent.setHasVisualChildren(null);
        this.idsToReexpand.remove(parent.getId());
        this.listModel.removeChildNodes(parent);
    }

    private T getRecordForNode(TreeNode node) {
        T record = this.dataService.getNodeById(this.treeDef.getNodeClass(), node.getId());
        return record;
    }

    public static enum NODE_DROPTYPE {
        MOVE_NODE,
        SYNONIMIZE_NODE,
        MERGE_NODE,
        CANCEL_DROP;

    }
}

