/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import edu.ku.brc.specify.ui.treetables.TreeNode;
import edu.ku.brc.specify.ui.treetables.TreeTableViewer;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TreeNodePopupMenu
extends JPopupMenu {
    protected JList list;
    protected TreeTableViewer ttv;
    protected JMenuItem delete;
    protected JMenuItem unSyn;
    protected JMenuItem find;
    protected JMenuItem edit;
    protected JMenuItem newChild;
    protected JMenuItem subtree;
    protected List<AbstractButton> selectionSensativeButtons;

    public TreeNodePopupMenu(TreeTableViewer owner, boolean isEditMode, boolean canAdd, boolean canDelete) {
        this.ttv = owner;
        this.subtree = new JMenuItem(UIRegistry.getResourceString("TTV_ZOOM_IN"));
        this.find = new JMenuItem(UIRegistry.getResourceString("TTV_FIND_NEXT"));
        this.selectionSensativeButtons = new Vector<AbstractButton>();
        this.selectionSensativeButtons.add(this.subtree);
        this.selectionSensativeButtons.add(this.find);
        this.edit = new JMenuItem(isEditMode ? UIRegistry.getResourceString("TTV_EDITING") : UIRegistry.getResourceString("TTV_VIEWING"));
        if (isEditMode) {
            this.delete = canDelete ? new JMenuItem(UIRegistry.getResourceString("TTV_DELETE")) : null;
            this.unSyn = new JMenuItem(UIRegistry.getResourceString("TTV_UNSYN"));
            this.newChild = canAdd ? new JMenuItem(UIRegistry.getResourceString("TTV_NEW_CHILD")) : null;
            this.selectionSensativeButtons.add(this.edit);
            if (canAdd) {
                this.selectionSensativeButtons.add(this.newChild);
            }
            if (canDelete) {
                this.selectionSensativeButtons.add(this.delete);
            }
            this.selectionSensativeButtons.add(this.unSyn);
        } else {
            this.delete = null;
            this.unSyn = null;
            this.newChild = null;
        }
        this.subtree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeNodePopupMenu.this.ttv.showSubtreeOfSelection(TreeNodePopupMenu.this.list);
            }
        });
        this.find.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeNode selection = (TreeNode)TreeNodePopupMenu.this.list.getSelectedValue();
                if (selection == null) {
                    return;
                }
                TreeNodePopupMenu.this.ttv.findNext(TreeNodePopupMenu.this.list, true, selection);
            }
        });
        this.add(this.subtree);
        this.add(this.find);
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeNodePopupMenu.this.ttv.editSelectedNode(TreeNodePopupMenu.this.list);
            }
        });
        this.add(this.edit);
        if (isEditMode) {
            if (canDelete) {
                this.delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        TreeNodePopupMenu.this.ttv.deleteSelectedNode(TreeNodePopupMenu.this.list);
                    }
                });
                this.add(this.delete);
            }
            this.unSyn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TreeNodePopupMenu.this.ttv.unSynSelectedNode(TreeNodePopupMenu.this.list);
                }
            });
            if (canAdd) {
                this.newChild.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        TreeNodePopupMenu.this.ttv.addChildToSelectedNode(TreeNodePopupMenu.this.list);
                    }
                });
                this.add(this.newChild);
            }
            this.add(this.unSyn);
        }
    }

    public void setList(JList list) {
        this.list = list;
    }

    public JList getList() {
        return this.list;
    }

    public void setDeleteEnabled(boolean enable) {
        if (this.delete != null) {
            this.delete.setEnabled(enable);
        }
    }

    public void setUnSynEnabled(boolean enable) {
        if (this.unSyn != null) {
            this.unSyn.setEnabled(enable);
        }
    }

    public void setNewEnabled(boolean enable) {
        if (this.newChild != null) {
            this.newChild.setEnabled(enable);
        }
    }

    public void setEditEnabled(boolean enable) {
        if (this.edit != null) {
            this.edit.setEnabled(enable);
        }
    }

    public void setFindEnabled(boolean enable) {
        this.find.setEnabled(enable);
    }

    public void setSubtreeEnabled(boolean enable) {
        this.subtree.setEnabled(enable);
    }

    public void setSelectionSensativeButtonsEnabled(boolean enable) {
        for (AbstractButton ab : this.selectionSensativeButtons) {
            ab.setEnabled(enable);
        }
    }

    public JMenuItem add(JMenuItem menuItem, boolean selectionSensative) {
        JMenuItem mi = super.add(menuItem);
        if (selectionSensative) {
            this.selectionSensativeButtons.add(menuItem);
        }
        return mi;
    }
}

