/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.util.Pair;
import java.util.Iterator;
import java.util.Set;

public class TreeNode {
    protected String name;
    protected String fullName;
    protected boolean hasChildren;
    protected int id;
    protected int parentId;
    protected Class<?> dataObjClass;
    protected int rank;
    protected int parentRank;
    protected int nodeNumber;
    protected int highestChildNodeNumber;
    protected boolean isCalcCount = false;
    protected boolean hasCalcCount = false;
    protected boolean isCalcCount2 = false;
    protected boolean hasCalcCount2 = false;
    protected int associatedRecordCount = -1;
    protected int associatedRecordCount2 = -1;
    protected Integer acceptedParentId;
    protected String acceptedParentFullName;
    protected Set<Pair<Integer, String>> synonymIdsAndNames;
    protected Boolean hasVisualChildren = null;
    protected String tooltipText = null;

    public TreeNode(String name, String fullName, int id, int parentId, int rank, int parentRank, boolean hasChildren, Integer acceptedParentId, String acceptedParentFullName, Set<Pair<Integer, String>> synonymIdsAndNames) {
        this.name = name;
        this.fullName = fullName;
        this.id = id;
        this.parentId = parentId;
        this.rank = rank;
        this.parentRank = parentRank;
        this.hasChildren = hasChildren;
        this.acceptedParentId = acceptedParentId;
        this.acceptedParentFullName = acceptedParentFullName;
        this.synonymIdsAndNames = synonymIdsAndNames;
    }

    public Class<?> getDataObjClass() {
        return this.dataObjClass;
    }

    public void setDataObjClass(Class<?> dataObjClass) {
        this.dataObjClass = dataObjClass;
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.tooltipText = null;
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.tooltipText = null;
        this.fullName = fullName;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public int getParentRank() {
        return this.parentRank;
    }

    public void setParentRank(int parentRank) {
        this.parentRank = parentRank;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getAssociatedRecordCount() {
        return this.associatedRecordCount;
    }

    public void setAssociatedRecordCount(int associatedRecordCount) {
        this.associatedRecordCount = associatedRecordCount;
    }

    public int getAssociatedRecordCount2() {
        return this.associatedRecordCount2;
    }

    public void setAssociatedRecordCount2(int associatedRecordCount2) {
        this.associatedRecordCount2 = associatedRecordCount2;
    }

    public synchronized boolean isCalcCount() {
        return this.isCalcCount;
    }

    public synchronized void setCalcCount(boolean isCalcCount) {
        this.isCalcCount = isCalcCount;
    }

    public synchronized boolean isHasCalcCount() {
        return this.hasCalcCount;
    }

    public synchronized void setHasCalcCount(boolean hasCalcCount) {
        this.hasCalcCount = hasCalcCount;
    }

    public synchronized boolean isCalcCount2() {
        return this.isCalcCount2;
    }

    public synchronized void setCalcCount2(boolean isCalcCount2) {
        this.isCalcCount2 = isCalcCount2;
    }

    public synchronized boolean isHasCalcCount2() {
        return this.hasCalcCount2;
    }

    public synchronized void setHasCalcCount2(boolean hasCalcCount2) {
        this.hasCalcCount2 = hasCalcCount2;
    }

    public synchronized boolean shouldCalcCount() {
        if (this.dataObjClass != null && this.dataObjClass.equals(Taxon.class) && this.acceptedParentId != null) {
            return false;
        }
        boolean isCalc = !(!this.isCalcCount && !this.hasCalcCount || !this.isCalcCount2 && !this.hasCalcCount2);
        return !isCalc;
    }

    public Integer getAcceptedParentId() {
        return this.acceptedParentId;
    }

    public String getAcceptedParentFullName() {
        return this.acceptedParentFullName;
    }

    public void setAcceptedParentFullName(String acceptedParentFullName) {
        this.tooltipText = null;
        this.acceptedParentFullName = acceptedParentFullName;
    }

    public void setAcceptedParentId(Integer acceptedParentId) {
        this.acceptedParentId = acceptedParentId;
    }

    public Set<Pair<Integer, String>> getSynonymIdsAndNames() {
        return this.synonymIdsAndNames;
    }

    public Boolean hasVisualChildren() {
        return this.hasVisualChildren;
    }

    public void setHasVisualChildren(Boolean hasVisualChildren) {
        this.hasVisualChildren = hasVisualChildren;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    public void removeSynonym(Integer synonymNodeId) {
        this.tooltipText = null;
        Iterator<Pair<Integer, String>> iter = this.synonymIdsAndNames.iterator();
        while (iter.hasNext()) {
            if (!((Integer)iter.next().first).equals(synonymNodeId)) continue;
            iter.remove();
            return;
        }
    }

    public void setSynonymIdsAndNames(Set<Pair<Integer, String>> synonymIdsAndNames) {
        this.synonymIdsAndNames = synonymIdsAndNames;
    }

    public String toString() {
        String memoryLocation = "00000000" + Integer.toHexString(this.hashCode());
        memoryLocation = memoryLocation.substring(memoryLocation.length() - 8);
        return String.valueOf(this.getClass().getSimpleName()) + "@0x" + memoryLocation + ": " + this.name + ", " + this.id + ", " + this.rank + ", " + this.parentId + ", " + this.parentRank;
    }

    public boolean removeSynonym(int synonymId) {
        boolean result = false;
        for (Pair<Integer, String> syn : this.synonymIdsAndNames) {
            if (!syn.getFirst().equals(synonymId)) continue;
            this.synonymIdsAndNames.remove(syn);
            result = true;
            break;
        }
        return result;
    }
}

