/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.StaleObjectException;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.TreeDefItemStandardEntry;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.tasks.TreeTaskMgr;
import edu.ku.brc.specify.treeutils.TreeDataService;
import edu.ku.brc.specify.treeutils.TreeDataServiceFactory;
import edu.ku.brc.specify.treeutils.TreeFactory;
import edu.ku.brc.specify.ui.treetables.TreeDefEditorTableModel;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Rankable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class TreeDefinitionEditor<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
extends BaseSubPane {
    private static final Logger log = Logger.getLogger(TreeDefinitionEditor.class);
    protected D displayedDef;
    protected BusinessRulesIFace businessRules;
    public static final String TREE_DEF_EDIT = "treedefedit";
    public static final String TREE_DEF_EDITOR = "treedefeditor";
    public static final String TREE_DEF_EDIT_TYPE = "treedefedittype";
    public static final int NEW_ITEM = 0;
    public static final int DELETED_ITEM = 1;
    public static final int EDITED_ITEM = 2;
    public static final int EDITED_DEF = 3;
    protected JPanel titlePanel;
    protected EditDeleteAddPanel edaPanel = null;
    protected JTable defItemsTable;
    protected TreeDefEditorTableModel<T, D, I> tableModel;
    protected JLabel defNameLabel;
    protected JButton editDefButton;
    protected JStatusBar statusBar;
    protected boolean isEditMode;
    protected boolean doUnlock = true;

    public TreeDefinitionEditor(D treeDef, String name, Taskable task, boolean isEditMode) {
        super(name, task);
        this.isEditMode = isEditMode;
        if (treeDef == null) {
            throw new NullPointerException("treeDef must be non-null");
        }
        this.displayedDef = treeDef;
        this.businessRules = DBTableIdMgr.getInstance().getBusinessRule(treeDef.getNodeClass());
        UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TTV_Loading"), 24);
        this.initUI();
        this.repaint();
        this.initTreeDefEditorComponent(this.displayedDef);
        UIRegistry.clearGlassPaneMsg();
        this.selectionValueChanged();
    }

    public D getDisplayedTreeDef() {
        return this.displayedDef;
    }

    @Override
    public boolean aboutToShutdown() {
        return true;
    }

    @Override
    public void shutdown() {
        if (this.doUnlock) {
            TaskSemaphoreMgr.unlock(this.name, this.displayedDef.getClass().getSimpleName(), TaskSemaphoreMgr.SCOPE.Discipline);
        }
        super.shutdown();
        TreeTaskMgr.checkLocks();
    }

    public void setDoUnlock(boolean doUnlock) {
        this.doUnlock = doUnlock;
    }

    public boolean isDoUnlock() {
        return this.doUnlock;
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        Dimension horizSpacer = new Dimension(5, 0);
        this.statusBar = UIRegistry.getStatusBar();
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 2));
        this.defNameLabel = UIHelper.createLabel("");
        this.titlePanel.add(Box.createHorizontalGlue());
        this.titlePanel.add(this.defNameLabel);
        this.titlePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        if (this.isEditMode) {
            this.editDefButton = UIHelper.createIconBtn("EditIcon", "TTV_EDIT_TREDEF_TITLE", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TreeDefinitionEditor.this.showDefEditDialog(TreeDefinitionEditor.this.displayedDef);
                }
            });
            this.editDefButton.setEnabled(true);
            this.titlePanel.add(Box.createRigidArea(horizSpacer));
            this.titlePanel.add(this.editDefButton);
        } else {
            this.editDefButton = null;
        }
        this.titlePanel.add(Box.createHorizontalGlue());
        if (this.isEditMode) {
            ActionListener deleteAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TreeDefinitionEditor.this.deleteItem(TreeDefinitionEditor.this.defItemsTable.getSelectedRow());
                }
            };
            ActionListener newItemAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TreeDefinitionEditor.this.newItem(TreeDefinitionEditor.this.defItemsTable.getSelectedRow());
                }
            };
            ActionListener editItemAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TreeDefinitionEditor.this.editTreeDefItem(TreeDefinitionEditor.this.defItemsTable.getSelectedRow());
                }
            };
            this.edaPanel = new EditDeleteAddPanel(editItemAction, deleteAction, newItemAction, "TTV_EDIT_TDI", "TTV_DEL_TDI", "TTV_NEW_TDI");
        }
    }

    protected void initTreeDefEditorComponent(D treeDef) {
        Set defItems = treeDef.getTreeDefItems();
        this.tableModel = new TreeDefEditorTableModel(defItems);
        this.defItemsTable = new JTable(this.tableModel);
        this.defItemsTable.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
        this.defItemsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TreeDefinitionEditor.this.editTreeDefItem((this).TreeDefinitionEditor.this.defItemsTable.getSelectedRow());
                        }
                    });
                }
            }
        });
        this.defItemsTable.setRowHeight(24);
        BiColorTableCellRenderer centeredRenderer = new BiColorTableCellRenderer();
        TableColumn tc = this.defItemsTable.getColumnModel().getColumn(2);
        tc.setCellRenderer(centeredRenderer);
        tc = this.defItemsTable.getColumnModel().getColumn(3);
        tc.setCellRenderer(centeredRenderer);
        if (this.isEditMode) {
            this.defItemsTable.setRowSelectionAllowed(true);
            this.defItemsTable.setColumnSelectionAllowed(false);
            this.defItemsTable.setSelectionMode(0);
        } else {
            this.defItemsTable.setRowSelectionAllowed(false);
        }
        UIHelper.makeTableHeadersCentered(this.defItemsTable, false);
        this.defNameLabel.setText(treeDef.getName());
        Font f = this.defNameLabel.getFont();
        Font boldF = f.deriveFont(1);
        this.defNameLabel.setFont(boldF);
        this.add((Component)UIHelper.createScrollPane(this.defItemsTable), "Center");
        this.add((Component)this.titlePanel, "North");
        if (this.edaPanel != null) {
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p,10px", "p"));
            pb.add((Component)this.edaPanel, new CellConstraints().xy(2, 1));
            this.add((Component)pb.getPanel(), "South");
            this.addSelectionListener();
        }
        this.repaint();
    }

    protected void addSelectionListener() {
        ListSelectionListener sl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TreeDefinitionEditor.this.clearStatus();
                TreeDefinitionEditor.this.selectionValueChanged();
            }
        };
        this.defItemsTable.getSelectionModel().addListSelectionListener(sl);
    }

    protected void selectionValueChanged() {
        if (this.isEditMode) {
            int selectionIndex = this.defItemsTable.getSelectedRow();
            if (selectionIndex == -1) {
                this.edaPanel.getDelBtn().setEnabled(false);
                this.edaPanel.getAddBtn().setEnabled(false);
                this.edaPanel.getEditBtn().setEnabled(false);
            } else {
                if (this.businessRules == null || this.businessRules.okToEnableDelete(this.tableModel.get(selectionIndex))) {
                    this.edaPanel.getDelBtn().setEnabled(true);
                } else {
                    this.edaPanel.getDelBtn().setEnabled(false);
                }
                this.edaPanel.getAddBtn().setEnabled(true);
                this.edaPanel.getEditBtn().setEnabled(true);
            }
        }
    }

    public void clearStatus() {
        this.statusBar.setText(null);
    }

    public void showError(String error) {
        this.statusBar.setErrorMessage(error, null);
    }

    public void showMessage(String message) {
        this.statusBar.setText(message);
    }

    protected boolean equalsWithNullChecks(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null && obj2 != null) {
            return false;
        }
        if (obj1 != null && obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    protected boolean needToRebuildFullNames(I before, I after) {
        if (!this.equalsWithNullChecks(before.getIsInFullName(), after.getIsInFullName())) {
            return true;
        }
        if (!this.equalsWithNullChecks(before.getTextBefore(), after.getTextBefore())) {
            return after.getIsInFullName();
        }
        if (!this.equalsWithNullChecks(before.getTextAfter(), after.getTextAfter())) {
            return after.getIsInFullName();
        }
        if (!this.equalsWithNullChecks(before.getFullNameSeparator(), after.getFullNameSeparator())) {
            return after.getIsInFullName();
        }
        return false;
    }

    protected void editTreeDefItem(final int index) {
        if (index == -1 || !this.isEditMode) {
            return;
        }
        log.info((Object)("Edit row " + index));
        I uiDefItem = this.tableModel.get(index);
        DataProviderSessionIFace tmpSession = DataProviderFactory.getInstance().createSession();
        final TreeDefItemIface defItem = (TreeDefItemIface)tmpSession.load(uiDefItem.getClass(), uiDefItem.getTreeDefItemId());
        log.info((Object)"loaded defItem for editing");
        if (defItem == null) {
            this.statusBar.setErrorMessage("The tree def has been changed by another user.  The def editor must be reloaded.");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)"initializing tree editor");
                    UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TTV_Loading"), 24);
                    TreeDefinitionEditor.this.initTreeDefEditorComponent(TreeDefinitionEditor.this.displayedDef);
                    log.info((Object)"initialized tree editor");
                    TreeDefinitionEditor.this.repaint();
                    UIRegistry.clearGlassPaneMsg();
                    log.info((Object)"invoking selectionValueChanged()");
                    TreeDefinitionEditor.this.selectionValueChanged();
                }
            });
            tmpSession.close();
            return;
        }
        tmpSession.close();
        final TreeDefItemIface beforeItem = TreeFactory.createNewTreeDefItem(defItem.getClass(), null, null);
        log.info((Object)"created beforeItem");
        beforeItem.setIsInFullName(this.boolVal(defItem.getIsInFullName(), false));
        beforeItem.setTextBefore(defItem.getTextBefore());
        beforeItem.setTextAfter(defItem.getTextAfter());
        beforeItem.setFullNameSeparator(defItem.getFullNameSeparator());
        beforeItem.setIsEnforced(this.boolVal(defItem.getIsEnforced(), false));
        String viewName = TreeFactory.getAppropriateViewName(defItem);
        Frame parentFrame = (Frame)UIRegistry.get("frame");
        String displayName = "NODE_EDIT_DISPLAY_NAME";
        boolean isEdit = true;
        String closeBtnText = isEdit ? UIRegistry.getResourceString("SAVE") : UIRegistry.getResourceString("CLOSE");
        String className = defItem.getClass().getName();
        DBTableInfo nodeTableInfo = DBTableIdMgr.getInstance().getInfoById(((DataModelObjBase)((Object)defItem)).getTableId());
        String idFieldName = nodeTableInfo.getIdFieldName();
        int options = 8;
        String title = UIRegistry.getResourceString("TreeRankEditDialogTitle");
        log.info((Object)"creating dialog");
        ViewBasedDisplayDialog dialog = new ViewBasedDisplayDialog(parentFrame, null, viewName, displayName, title, closeBtnText, className, idFieldName, isEdit, options);
        log.info((Object)"created dialog");
        dialog.setModal(true);
        dialog.setData(defItem);
        dialog.preCreateUI();
        dialog.setVisible(true);
        if (dialog.getBtnPressed() == 1) {
            UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TTV_Saving"), 24);
            SwingWorker bgThread = new SwingWorker(){
                boolean success;
                I mergedItem;

                @Override
                public Object construct() {
                    block12: {
                        if (TreeDefinitionEditor.this.needToRebuildFullNames(beforeItem, defItem) && !UIRegistry.displayConfirmLocalized(UIRegistry.getResourceString("Confirm"), "TDE_ChangesRequireFullNameUpdate", "OK", "Cancel", 1)) {
                            return false;
                        }
                        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                        try {
                            this.mergedItem = session.merge(defItem);
                        }
                        catch (StaleObjectException e1) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(TreeDefinitionEditor.class, e1);
                            UIRegistry.showLocalizedError("UPDATE_DATA_STALE");
                            if (session != null) {
                                session.close();
                            }
                            session = DataProviderFactory.getInstance().createSession();
                            this.mergedItem = (TreeDefItemIface)session.load(defItem.getClass(), defItem.getTreeDefItemId());
                            this.success = false;
                            return this.success;
                        }
                        this.success = true;
                        if (TreeDefinitionEditor.this.businessRules != null) {
                            TreeDefinitionEditor.this.businessRules.beforeSave(this.mergedItem, session);
                        }
                        try {
                            try {
                                session.beginTransaction();
                                session.saveOrUpdate(this.mergedItem);
                                if (TreeDefinitionEditor.this.businessRules != null && !TreeDefinitionEditor.this.businessRules.beforeSaveCommit(this.mergedItem, session)) {
                                    throw new Exception("Business rules processing failed");
                                }
                                session.commit();
                                TreeDefinitionEditor.this.notifyApplication(this.mergedItem, 2);
                                log.info((Object)("Successfully saved changes to " + this.mergedItem.getName()));
                                if (TreeDefinitionEditor.this.businessRules != null && this.success) {
                                    TreeDefinitionEditor.this.businessRules.afterSaveCommit(defItem, session);
                                }
                            }
                            catch (Exception e) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(TreeDefinitionEditor.class, e);
                                this.success = false;
                                UIRegistry.showLocalizedError("UNRECOVERABLE_DB_ERROR");
                                log.error((Object)"Error while saving node changes.  Rolling back transaction.", (Throwable)e);
                                session.rollback();
                                session.close();
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            session.close();
                            throw throwable;
                        }
                        session.close();
                    }
                    return this.success;
                }

                @Override
                public void finished() {
                    if (this.success) {
                        if (TreeDefinitionEditor.this.needToRebuildFullNames(beforeItem, defItem)) {
                            try {
                                TreeDefinitionEditor.this.displayedDef.updateAllFullNames(null, true, true, defItem.getRankId());
                            }
                            catch (Exception ex) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(TreeDefinitionEditor.class, ex);
                                UIRegistry.showLocalizedError("UNRECOVERABLE_DB_ERROR");
                                log.error((Object)"Error while updating full names.  Full names may not correspond to tree definition.", (Throwable)ex);
                            }
                        }
                        TreeDefinitionEditor.this.tableModel.set(index, this.mergedItem);
                    }
                    UIRegistry.clearGlassPaneMsg();
                }
            };
            bgThread.start();
        }
    }

    protected void refreshDef() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            this.displayedDef = (TreeDefIface)session.get(this.displayedDef.getClass(), this.displayedDef.getTreeDefId());
            ((DataModelObjBase)this.displayedDef).forceLoad();
        }
        finally {
            session.close();
        }
    }

    protected void notifyApplication(Object editItem, int action) {
        this.refreshDef();
        AppContextMgr.getInstance().setClassObject(this.displayedDef.getClass(), this.displayedDef);
        CommandAction cmd = new CommandAction(TREE_DEF_EDITOR, TREE_DEF_EDIT, editItem);
        cmd.setProperty(TREE_DEF_EDIT_TYPE, action);
        CommandDispatcher.dispatch(cmd);
    }

    protected List<String> getNodesThatMustBeFixedBeforeEdit(I itemBeforeEdits, I itemAfterEdits) {
        boolean fullnameBefore = this.boolVal(itemBeforeEdits.getIsInFullName(), false);
        boolean enforcedBefore = this.boolVal(itemBeforeEdits.getIsEnforced(), false);
        String textBeforeBefore = this.stringVal(itemBeforeEdits.getTextBefore(), "");
        String textAfterBefore = this.stringVal(itemBeforeEdits.getTextAfter(), "");
        String separatorBefore = this.stringVal(itemBeforeEdits.getFullNameSeparator(), "");
        boolean fullname = this.boolVal(itemAfterEdits.getIsInFullName(), false);
        boolean enforced = this.boolVal(itemAfterEdits.getIsEnforced(), false);
        String textBefore = this.stringVal(itemAfterEdits.getTextBefore(), "");
        String textAfter = this.stringVal(itemAfterEdits.getTextAfter(), "");
        String separator = this.stringVal(itemAfterEdits.getFullNameSeparator(), "");
        boolean fullnameChanged = fullnameBefore ^ fullname;
        boolean enforcedChanged = enforcedBefore ^ enforced;
        boolean textBeforeChanged = !textBeforeBefore.equals(textBefore);
        boolean textAfterChanged = !textAfterBefore.equals(textAfter);
        boolean separatorChanged = !separatorBefore.equals(separator);
        List<String> problematicNodes = null;
        TreeDataService treeDataServ = TreeDataServiceFactory.createService();
        if (fullnameChanged || textBeforeChanged || textAfterChanged || separatorChanged) {
            problematicNodes = treeDataServ.nodeNamesAtLevel(itemAfterEdits.getRankId(), itemAfterEdits.getTreeDef());
        }
        if (enforcedChanged && enforced) {
            try {
                problematicNodes = treeDataServ.nodesSkippingOverLevel(itemAfterEdits.getRankId(), itemAfterEdits.getTreeDef());
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(TreeDefinitionEditor.class, e);
                System.err.println(e);
            }
        }
        return problematicNodes;
    }

    protected TreeDefItemStandardEntry getNewItemStdLevel(I parent, I child) {
        List<TreeDefItemStandardEntry> stds = this.displayedDef.getStandardLevels();
        LinkedList<TreeDefItemStandardEntry> options = new LinkedList<TreeDefItemStandardEntry>();
        for (TreeDefItemStandardEntry std : stds) {
            if (std.getRank() <= parent.getRankId() || child != null && std.getRank() >= child.getRankId()) continue;
            options.add(std);
        }
        if (options.size() == 0) {
            return new TreeDefItemStandardEntry("", -1);
        }
        ChooseFromListDlg dlg = new ChooseFromListDlg((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("TreeDefinitionEditor.41"), 11, options);
        dlg.setApplyLabel(UIRegistry.getResourceString("TreeDefinitionEditor.42"));
        dlg.setCloseOnApply(true);
        dlg.setModal(true);
        UIHelper.centerAndShow(dlg);
        TreeDefItemStandardEntry selection = null;
        if (dlg.getBtnPressed() == 1) {
            selection = (TreeDefItemStandardEntry)dlg.getSelectedObject();
        } else if (dlg.getBtnPressed() == 8) {
            selection = new TreeDefItemStandardEntry("", -1);
        }
        dlg.dispose();
        return selection;
    }

    protected Integer getNewItemRank(TreeDefItemStandardEntry stdLevel, I parent, I child) {
        Integer result = null;
        if (stdLevel != null && stdLevel.getRank() != -1) {
            result = stdLevel.getRank();
        } else if (child != null) {
            result = (int)(0.5 * (double)(child.getRankId() + parent.getRankId()));
        } else {
            TreeDefItemStandardEntry stdChild = null;
            List<TreeDefItemStandardEntry> stds = this.displayedDef.getStandardLevels();
            Collections.sort(stds);
            for (TreeDefItemStandardEntry std : this.displayedDef.getStandardLevels()) {
                if (std.getRank() <= parent.getRankId()) continue;
                stdChild = std;
                break;
            }
            result = stdChild == null ? Integer.valueOf(parent.getRankId() + this.displayedDef.getRankIncrement()) : Integer.valueOf((int)(0.5 * (double)(stdChild.getRank() + parent.getRankId())));
        }
        if (this.displayedDef.getDefItemByRank(result) != null) {
            result = null;
        }
        return result;
    }

    protected void newItem(int index) {
        if (index == -1) {
            return;
        }
        I uiParent = this.tableModel.get(index);
        DataProviderSessionIFace tmpSession = DataProviderFactory.getInstance().createSession();
        TreeDefItemIface parent = (TreeDefItemIface)tmpSession.load(uiParent.getClass(), uiParent.getTreeDefItemId());
        if (parent == null) {
            this.statusBar.setErrorMessage(UIRegistry.getResourceString("TreeDefinitionEditor.18"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TTV_Loading"), 24);
                    TreeDefinitionEditor.this.initTreeDefEditorComponent(TreeDefinitionEditor.this.displayedDef);
                    TreeDefinitionEditor.this.repaint();
                    UIRegistry.clearGlassPaneMsg();
                    TreeDefinitionEditor.this.selectionValueChanged();
                }
            });
            tmpSession.close();
            return;
        }
        tmpSession.close();
        Rankable origChild = parent.getChild();
        Rankable newItem = TreeFactory.createNewTreeDefItem(parent.getClass(), null, UIRegistry.getResourceString("TreeDefinitionEditor.46"));
        TreeDefItemStandardEntry stdLevel = this.getNewItemStdLevel(parent, origChild);
        if (stdLevel == null) {
            return;
        }
        Integer rank = this.getNewItemRank(stdLevel, parent, origChild);
        if (rank == null) {
            log.error((Object)("Unable to determine rank for new item. Parent=" + parent + ". Child=" + origChild + "."));
            UIRegistry.getStatusBar().setErrorMessage(UIRegistry.getResourceString("TreeDefinitionEditor.50"));
            return;
        }
        newItem.setRankId(rank);
        boolean isRequiredLevel = this.displayedDef.isRequiredLevel(stdLevel.getRank());
        newItem.setIsEnforced(isRequiredLevel);
        if (stdLevel.getRank() != -1) {
            newItem.setName(stdLevel.getTitle());
        }
        newItem.setTreeDef(this.displayedDef);
        newItem.setParent(parent);
        if (origChild != null) {
            newItem.setChild(origChild);
            origChild.setParent((Rankable)newItem);
        }
        String viewName = TreeFactory.getAppropriateViewName(newItem);
        Frame parentFrame = (Frame)UIRegistry.get("frame");
        String displayName = "NODE_EDIT_DISPLAY_NAME";
        boolean isEdit = true;
        String closeBtnText = isEdit ? UIRegistry.getResourceString("SAVE") : UIRegistry.getResourceString("CLOSE");
        String className = newItem.getClass().getName();
        DBTableInfo nodeTableInfo = DBTableIdMgr.getInstance().getInfoById(((DataModelObjBase)((Object)newItem)).getTableId());
        String idFieldName = nodeTableInfo.getIdFieldName();
        int options = 12;
        String title = UIRegistry.getResourceString("TreeRankEditDialogTitle");
        ViewBasedDisplayDialog dialog = new ViewBasedDisplayDialog(parentFrame, null, viewName, displayName, title, closeBtnText, className, idFieldName, isEdit, options);
        dialog.setModal(true);
        dialog.setData(newItem);
        dialog.preCreateUI();
        if (stdLevel != null) {
            dialog.getOkBtn().setEnabled(true);
        }
        dialog.setVisible(true);
        if (dialog.getBtnPressed() == 1) {
            UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TTV_Saving"), 24);
            SwingWorker bgThread = new SwingWorker((TreeDefItemIface)newItem, isRequiredLevel, (TreeDefItemIface)origChild, parent, index){
                boolean success;
                private final /* synthetic */ TreeDefItemIface val$newItem;
                private final /* synthetic */ boolean val$isRequiredLevel;
                private final /* synthetic */ TreeDefItemIface val$origChild;
                private final /* synthetic */ TreeDefItemIface val$parent;
                private final /* synthetic */ int val$index;
                {
                    this.val$newItem = treeDefItemIface;
                    this.val$isRequiredLevel = bl;
                    this.val$origChild = treeDefItemIface2;
                    this.val$parent = treeDefItemIface3;
                    this.val$index = n;
                }

                @Override
                public Object construct() {
                    List<String> nodesToChange;
                    this.success = true;
                    if (this.val$newItem.getIsEnforced() != null && this.val$newItem.getIsEnforced().booleanValue() && (nodesToChange = TreeDefinitionEditor.this.getNodesThatMustBeFixedToEnforceNewLevel(this.val$newItem)) != null && nodesToChange.size() > 0) {
                        StringBuilder message = new StringBuilder("<html><h3><center>");
                        if (this.val$isRequiredLevel) {
                            message.append(UIRegistry.getResourceString("TDE_CantAddNewEnforcedLevel"));
                        } else {
                            message.append(UIRegistry.getResourceString("TDE_CantEnforceNewLevel"));
                        }
                        message.append("</center></h3><ul>");
                        for (String node : nodesToChange) {
                            message.append("<li>" + node);
                        }
                        message.append("</ul></html>");
                        UIRegistry.showLocalizedError(message.toString());
                        if (this.val$isRequiredLevel) {
                            this.success = false;
                        } else {
                            this.val$newItem.setIsEnforced(false);
                        }
                    }
                    if (this.success) {
                        DataProviderSessionIFace session;
                        block20: {
                            session = DataProviderFactory.getInstance().createSession();
                            if (TreeDefinitionEditor.this.businessRules != null) {
                                TreeDefinitionEditor.this.businessRules.beforeSave(this.val$newItem, session);
                                if (this.val$origChild != null) {
                                    TreeDefinitionEditor.this.businessRules.beforeSave(this.val$origChild, session);
                                }
                            }
                            try {
                                try {
                                    session.beginTransaction();
                                    session.saveOrUpdate(this.val$newItem);
                                    if (TreeDefinitionEditor.this.businessRules != null) {
                                        if (!TreeDefinitionEditor.this.businessRules.beforeSaveCommit(this.val$newItem, session)) {
                                            throw new Exception("Business rules processing failed");
                                        }
                                        if (this.val$origChild != null && !TreeDefinitionEditor.this.businessRules.beforeSaveCommit(this.val$origChild, session)) {
                                            throw new Exception("Business rules processing failed");
                                        }
                                    }
                                    session.commit();
                                    TreeDefinitionEditor.this.displayedDef.getTreeDefItems().add(this.val$newItem);
                                    TreeDefinitionEditor.this.notifyApplication(this.val$newItem, 0);
                                    log.info((Object)("Successfully saved changes to " + this.val$newItem.getName()));
                                }
                                catch (Exception e) {
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(TreeDefinitionEditor.class, e);
                                    this.success = false;
                                    UIRegistry.showLocalizedError("UNRECOVERABLE_DB_ERROR");
                                    log.error((Object)"Error while saving node changes.  Rolling back transaction.", (Throwable)e);
                                    session.rollback();
                                    session.close();
                                    break block20;
                                }
                            }
                            catch (Throwable throwable) {
                                session.close();
                                throw throwable;
                            }
                            session.close();
                        }
                        session = DataProviderFactory.getInstance().createSession();
                        session.refresh(this.val$newItem);
                        session.refresh(this.val$parent);
                        if (this.val$origChild != null) {
                            session.refresh(this.val$origChild);
                        }
                        if (TreeDefinitionEditor.this.businessRules != null && this.success) {
                            TreeDefinitionEditor.this.businessRules.afterSaveCommit(this.val$newItem, session);
                            if (this.val$origChild != null) {
                                TreeDefinitionEditor.this.businessRules.afterSaveCommit(this.val$origChild, session);
                            }
                        }
                        session.close();
                    }
                    return this.success;
                }

                @Override
                public void finished() {
                    if (this.success) {
                        TreeDefinitionEditor.this.tableModel.set(this.val$index, this.val$parent);
                        TreeDefinitionEditor.this.tableModel.add(this.val$newItem, this.val$parent);
                        if (this.val$origChild != null) {
                            TreeDefinitionEditor.this.tableModel.set(this.val$index + 2, this.val$origChild);
                        }
                    }
                    UIRegistry.clearGlassPaneMsg();
                }
            };
            bgThread.start();
        } else {
            newItem.setTreeDef(null);
            newItem.setParent(null);
            newItem.setChild(null);
        }
    }

    protected List<String> getNodesThatMustBeFixedToEnforceNewLevel(I newItem) {
        boolean enforced = this.boolVal(newItem.getIsEnforced(), false);
        List<String> problematicNodes = null;
        if (enforced) {
            TreeDataService treeDataServ = TreeDataServiceFactory.createService();
            problematicNodes = treeDataServ.nodesSkippingOverLevel(newItem.getRankId(), newItem.getTreeDef());
        }
        return problematicNodes;
    }

    protected void deleteItem(final int index) {
        if (index == -1) {
            return;
        }
        I uiItem = this.tableModel.get(index);
        DataProviderSessionIFace tmpSession = DataProviderFactory.getInstance().createSession();
        final TreeDefItemIface itemToDelete = (TreeDefItemIface)tmpSession.load(uiItem.getClass(), uiItem.getTreeDefItemId());
        if (itemToDelete == null) {
            this.statusBar.setErrorMessage(UIRegistry.getResourceString("TreeDefinitionEditor.17"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TTV_Loading"), 24);
                    TreeDefinitionEditor.this.initTreeDefEditorComponent(TreeDefinitionEditor.this.displayedDef);
                    TreeDefinitionEditor.this.repaint();
                    UIRegistry.clearGlassPaneMsg();
                    TreeDefinitionEditor.this.selectionValueChanged();
                }
            });
            tmpSession.close();
            return;
        }
        tmpSession.close();
        UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TTV_Deleting"), 24);
        SwingWorker bgThread = new SwingWorker(){
            boolean success;
            I mergedItem;

            @Override
            public Object construct() {
                Object child;
                Object parent;
                DataProviderSessionIFace session;
                block20: {
                    session = DataProviderFactory.getInstance().createSession();
                    try {
                        this.mergedItem = session.merge(itemToDelete);
                    }
                    catch (StaleObjectException e1) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(TreeDefinitionEditor.class, e1);
                        UIRegistry.showLocalizedError("UPDATE_DATA_STALE");
                        if (session != null) {
                            session.close();
                        }
                        session = DataProviderFactory.getInstance().createSession();
                        this.mergedItem = (TreeDefItemIface)session.load(itemToDelete.getClass(), itemToDelete.getTreeDefItemId());
                        this.success = false;
                        return this.success;
                    }
                    this.success = true;
                    parent = this.mergedItem.getParent();
                    child = this.mergedItem.getChild();
                    this.mergedItem.setParent(null);
                    this.mergedItem.setChild(null);
                    parent.setChild(child);
                    if (child != null) {
                        child.setParent(parent);
                    }
                    this.mergedItem.getTreeDef().getTreeDefItems().remove(this.mergedItem);
                    this.mergedItem.setTreeDef(null);
                    if (TreeDefinitionEditor.this.businessRules != null) {
                        this.mergedItem = (TreeDefItemIface)TreeDefinitionEditor.this.businessRules.beforeDelete(this.mergedItem, session);
                        TreeDefinitionEditor.this.businessRules.beforeSave(parent, session);
                        if (child != null) {
                            TreeDefinitionEditor.this.businessRules.beforeSave(child, session);
                        }
                    }
                    try {
                        try {
                            session.beginTransaction();
                            session.saveOrUpdate(parent);
                            if (child != null) {
                                session.saveOrUpdate(child);
                            }
                            session.delete(this.mergedItem);
                            if (TreeDefinitionEditor.this.businessRules != null) {
                                if (!TreeDefinitionEditor.this.businessRules.beforeDeleteCommit(this.mergedItem, session)) {
                                    throw new Exception("Business rules processing failed");
                                }
                                if (!TreeDefinitionEditor.this.businessRules.beforeSaveCommit(parent, session)) {
                                    throw new Exception("Business rules processing failed");
                                }
                                if (child != null && !TreeDefinitionEditor.this.businessRules.beforeSaveCommit(child, session)) {
                                    throw new Exception("Business rules processing failed");
                                }
                            }
                            session.commit();
                            DataModelObjBase deletedObj = (DataModelObjBase)((Object)itemToDelete);
                            for (TreeDefItemIface item : TreeDefinitionEditor.this.displayedDef.getTreeDefItems()) {
                                if (!((DataModelObjBase)((Object)item)).getId().equals(deletedObj.getId())) continue;
                                TreeDefinitionEditor.this.displayedDef.getTreeDefItems().remove(item);
                                break;
                            }
                            TreeDefinitionEditor.this.notifyApplication(itemToDelete, 1);
                            log.info((Object)("Successfully deleted " + this.mergedItem.getName()));
                        }
                        catch (Exception e) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(TreeDefinitionEditor.class, e);
                            this.success = false;
                            UIRegistry.showLocalizedError("UNRECOVERABLE_DB_ERROR");
                            log.error((Object)"Error while saving node changes.  Rolling back transaction.", (Throwable)e);
                            session.rollback();
                            session.close();
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        session.close();
                        throw throwable;
                    }
                    session.close();
                }
                session = DataProviderFactory.getInstance().createSession();
                session.refresh(parent);
                if (child != null) {
                    session.refresh(child);
                }
                if (TreeDefinitionEditor.this.businessRules != null && this.success) {
                    TreeDefinitionEditor.this.businessRules.afterDeleteCommit(this.mergedItem);
                    TreeDefinitionEditor.this.businessRules.afterSaveCommit(parent, session);
                    if (child != null) {
                        TreeDefinitionEditor.this.businessRules.afterSaveCommit(child, session);
                    }
                }
                session.close();
                return this.success;
            }

            @Override
            public void finished() {
                TreeDefinitionEditor.this.tableModel.remove(index);
                UIRegistry.clearGlassPaneMsg();
            }
        };
        bgThread.start();
    }

    protected void showDefEditDialog(D treeDef) {
        DataProviderSessionIFace tmpSession = DataProviderFactory.getInstance().createSession();
        final TreeDefIface def = (TreeDefIface)tmpSession.load(treeDef.getClass(), treeDef.getTreeDefId());
        if (def == null) {
            this.statusBar.setErrorMessage("The tree currently being displayed has been deleted by another user.  It must now be closed.");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubPaneMgr.getInstance().removePane(TreeDefinitionEditor.this);
                }
            });
            tmpSession.close();
            return;
        }
        tmpSession.close();
        String viewName = TreeFactory.getAppropriateViewName(treeDef);
        Frame parentFrame = (Frame)UIRegistry.get("frame");
        String displayName = "NODE_EDIT_DISPLAY_NAME";
        boolean isEdit = true;
        String closeBtnText = isEdit ? UIRegistry.getResourceString("SAVE") : UIRegistry.getResourceString("CLOSE");
        String className = def.getClass().getName();
        DBTableInfo nodeTableInfo = DBTableIdMgr.getInstance().getInfoById(((DataModelObjBase)((Object)def)).getTableId());
        String idFieldName = nodeTableInfo.getIdFieldName();
        int options = 8;
        int fullNameDir = def.getFullNameDirection();
        String title = UIRegistry.getResourceString("TreeDefEditDialogTitle");
        ViewBasedDisplayDialog dialog = new ViewBasedDisplayDialog(parentFrame, null, viewName, displayName, title, closeBtnText, className, idFieldName, isEdit, options);
        dialog.setModal(true);
        dialog.setData(def);
        dialog.preCreateUI();
        dialog.setVisible(true);
        if (dialog.getBtnPressed() == 1) {
            final boolean treeRebuildRequired = fullNameDir != def.getFullNameDirection();
            UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("TTV_Saving"), 24);
            SwingWorker bgThread = new SwingWorker(){
                boolean success;
                D mergedDef;

                @Override
                public Object construct() {
                    DataProviderSessionIFace session;
                    block12: {
                        if (treeRebuildRequired && !UIRegistry.displayConfirmLocalized(UIRegistry.getResourceString("Confirm"), "TDE_ChangesRequireFullNameUpdate", "OK", "Cancel", 1)) {
                            return false;
                        }
                        session = DataProviderFactory.getInstance().createSession();
                        try {
                            this.mergedDef = session.merge(def);
                        }
                        catch (StaleObjectException e1) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(TreeDefinitionEditor.class, e1);
                            UIRegistry.showLocalizedError("UPDATE_DATA_STALE");
                            if (session != null) {
                                session.close();
                            }
                            session = DataProviderFactory.getInstance().createSession();
                            this.mergedDef = (TreeDefIface)session.load(def.getClass(), def.getTreeDefId());
                            this.success = false;
                            return this.success;
                        }
                        this.success = true;
                        if (TreeDefinitionEditor.this.businessRules != null) {
                            TreeDefinitionEditor.this.businessRules.beforeSave(this.mergedDef, session);
                        }
                        try {
                            try {
                                session.beginTransaction();
                                session.saveOrUpdate(this.mergedDef);
                                if (TreeDefinitionEditor.this.businessRules != null && !TreeDefinitionEditor.this.businessRules.beforeSaveCommit(this.mergedDef, session)) {
                                    throw new Exception("Business rules processing failed");
                                }
                                session.commit();
                                TreeDefinitionEditor.this.notifyApplication(TreeDefinitionEditor.this.displayedDef, 3);
                                log.info((Object)("Successfully saved changes to " + this.mergedDef.getName()));
                            }
                            catch (Exception e) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(TreeDefinitionEditor.class, e);
                                this.success = false;
                                UIRegistry.showLocalizedError("UNRECOVERABLE_DB_ERROR");
                                log.error((Object)"Error while saving node changes.  Rolling back transaction.", (Throwable)e);
                                session.rollback();
                                session.close();
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            session.close();
                            throw throwable;
                        }
                        session.close();
                    }
                    session = DataProviderFactory.getInstance().createSession();
                    session.refresh(def);
                    if (TreeDefinitionEditor.this.businessRules != null && this.success) {
                        TreeDefinitionEditor.this.businessRules.afterSaveCommit(def, session);
                    }
                    session.close();
                    return this.success;
                }

                @Override
                public void finished() {
                    if (treeRebuildRequired) {
                        try {
                            int minRank = -1;
                            for (TreeDefItemIface item : def.getTreeDefItems()) {
                                if (item.getIsInFullName() == null || !item.getIsInFullName().booleanValue() || minRank != -1 && minRank <= item.getRankId()) continue;
                                minRank = item.getRankId();
                            }
                            TreeDefinitionEditor.this.displayedDef.updateAllFullNames(null, true, true, minRank);
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(TreeDefinitionEditor.class, ex);
                            UIRegistry.showLocalizedError("UNRECOVERABLE_DB_ERROR");
                            log.error((Object)"Error while updating full names.  Full names may not correspond to tree definition.", (Throwable)ex);
                        }
                    }
                    if (this.success) {
                        TreeDefinitionEditor.this.defNameLabel.setText(def.getName());
                    }
                    UIRegistry.clearGlassPaneMsg();
                }
            };
            bgThread.start();
        }
    }

    private boolean boolVal(Boolean b, boolean defaultVal) {
        return b != null ? b : defaultVal;
    }

    private String stringVal(String s, String defaultVal) {
        return s != null ? s : defaultVal;
    }
}

