/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.RankBasedComparator;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class TreeDefEditorTableModel<T extends Treeable<T, D, I>, D extends TreeDefIface<T, D, I>, I extends TreeDefItemIface<T, D, I>>
extends AbstractTableModel {
    public static final int NAME_COL = 0;
    public static final int REMARKS_COL = 1;
    public static final int FULLNAME_COL = 2;
    public static final int ENFORCED_COL = 3;
    public static final int TEXT_BEFORE_COL = 4;
    public static final int TEXT_AFTER_COL = 5;
    public static final int SEPARATOR_COL = 6;
    public static final String YES = UIRegistry.getResourceString("YES");
    public static final String NO = UIRegistry.getResourceString("NO");
    protected Vector<I> tableData;

    public TreeDefEditorTableModel(Set<? extends I> defItems) {
        this.tableData = new Vector<I>(defItems);
        Collections.sort(this.tableData, new RankBasedComparator());
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return this.tableData.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TreeDefItemIface row = (TreeDefItemIface)this.tableData.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.getDisplayText().toString();
            }
            case 1: {
                return row.getRemarks();
            }
            case 2: {
                return row.getIsInFullName() != null && row.getIsInFullName() != false ? YES : NO;
            }
            case 3: {
                return row.getIsEnforced() != null && row.getIsEnforced() != false ? YES : NO;
            }
            case 4: {
                return row.getTextBefore();
            }
            case 5: {
                return row.getTextAfter();
            }
            case 6: {
                return row.getFullNameSeparator();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        TreeDefItemIface row = (TreeDefItemIface)this.tableData.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                row.setName((String)aValue);
                break;
            }
            case 1: {
                row.setRemarks((String)aValue);
                break;
            }
            case 2: {
                row.setIsInFullName((Boolean)aValue);
                break;
            }
            case 3: {
                row.setIsEnforced((Boolean)aValue);
                break;
            }
            case 4: {
                row.setTextBefore((String)aValue);
                break;
            }
            case 5: {
                row.setTextAfter((String)aValue);
                break;
            }
            case 6: {
                row.setFullNameSeparator((String)aValue);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return UIRegistry.getResourceString("Name");
            }
            case 1: {
                return UIRegistry.getResourceString("Remarks");
            }
            case 2: {
                return UIRegistry.getResourceString("InFullName");
            }
            case 3: {
                return UIRegistry.getResourceString("Enforced");
            }
            case 4: {
                return UIRegistry.getResourceString("TextBefore");
            }
            case 5: {
                return UIRegistry.getResourceString("TextAfter");
            }
            case 6: {
                return UIRegistry.getResourceString("Separator");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public synchronized void add(I newDefItem, I parentDefItem) {
        int parentIndex = this.indexOf(parentDefItem);
        if (parentIndex == -1) {
            throw new IllegalArgumentException("parent item must already be in the table");
        }
        this.tableData.add(parentIndex + 1, newDefItem);
        this.fireTableRowsInserted(parentIndex + 1, parentIndex + 1);
    }

    protected int indexOf(I defItem) {
        if (defItem == null || defItem.getTreeDefItemId() == null) {
            return -1;
        }
        int i = 0;
        while (i < this.tableData.size()) {
            TreeDefItemIface item = (TreeDefItemIface)this.tableData.get(i);
            if (defItem.getTreeDefItemId().equals(item.getTreeDefItemId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public I get(int index) {
        return (I)((TreeDefItemIface)this.tableData.get(index));
    }

    public I set(int index, I element) {
        TreeDefItemIface oldItem = (TreeDefItemIface)this.tableData.set(index, element);
        this.fireTableRowsUpdated(index, index);
        return (I)oldItem;
    }

    public synchronized void remove(int index) {
        this.tableData.remove(index);
        this.fireTableRowsDeleted(index, index);
    }
}

