/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.treeutils.HibernateTreeDataServiceImpl;
import edu.ku.brc.specify.ui.treetables.TreeBrowserFindPanel;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TreeBrowserPanel
extends JPanel {
    protected static final Logger log = Logger.getLogger(TreeBrowserPanel.class);
    protected String tableName;
    protected Class<?> clazz;
    protected DBTableInfo tableInfo;
    protected String columns;
    protected JTree tree;
    protected BrowseTreeNode root;
    protected TreeBrowserFindPanel treeBrowserFindPanel;
    protected Vector<Integer> foundNodesList = new Vector();
    protected int currentFoundIndex;
    protected String searchText = "";
    protected Hashtable<Integer, String> treeDefRankNamesHash = new Hashtable();

    public TreeBrowserPanel(String tableName, Class<?> clazz, int treeDefId, int rootId) {
        super(new BorderLayout());
        this.tableName = tableName;
        this.clazz = clazz;
        this.tableInfo = DBTableIdMgr.getInstance().getByClassName(clazz.getName());
        this.columns = QueryAdjusterForDomain.getInstance().getSpecialColumns(this.tableInfo, false);
        String clsName = clazz.getSimpleName();
        String sql = String.format("SELECT RankID, Name FROM %streedefitem WHERE %sTreeDefID = %d AND RankID > 0 ORDER BY RankID", clsName.toLowerCase(), clsName, treeDefId);
        log.debug((Object)sql);
        for (Object[] row : BasicSQLUtils.query(sql)) {
            this.treeDefRankNamesHash.put((Integer)row[0], row[1].toString());
        }
        Vector<Object[]> titleVector = BasicSQLUtils.query(String.format("SELECT FullName, Name, RankID FROM %s WHERE %sID = %d", tableName, clazz.getSimpleName(), rootId));
        Object[] titleRow = titleVector.get(0);
        this.root = new BrowseTreeNode(rootId, (Integer)titleRow[2], titleRow[0] != null ? titleRow[0].toString() : titleRow[1].toString());
        this.tree = new JTree(new DefaultTreeModel(this.root));
        this.tree.setCellRenderer(new SpTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.treeBrowserFindPanel = new TreeBrowserFindPanel(this, 1);
        this.add((Component)UIHelper.createScrollPane(this.tree, true), "Center");
        this.add((Component)this.treeBrowserFindPanel, "South");
    }

    public void find(final String key, boolean wrap, final boolean isExact) {
        this.searchText = key;
        boolean doOldWay = true;
        if (doOldWay) {
            this.findByName(key, isExact);
        } else {
            String BROWSERTREESEARCH = "BROWSERTREESEARCH";
            final JStatusBar statusBar = UIRegistry.getStatusBar();
            statusBar.setIndeterminate("BROWSERTREESEARCH", true);
            String msg = UIRegistry.getLocalizedMessage("TREEBROWSESEARCH", this.searchText);
            statusBar.setText(msg);
            UIRegistry.writeSimpleGlassPaneMsg(msg, 24);
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    TreeBrowserPanel.this.findByName(key, isExact);
                    return null;
                }

                @Override
                public void finished() {
                    statusBar.setProgressDone("BROWSERTREESEARCH");
                    statusBar.setText(UIRegistry.getLocalizedMessage("TREEBROWSESEARCH_FND", TreeBrowserPanel.this.foundNodesList.size(), TreeBrowserPanel.this.searchText));
                    UIRegistry.clearSimpleGlassPaneMsg();
                }
            };
            worker.start();
        }
    }

    public boolean doFindNext() {
        boolean doOldWay = true;
        if (doOldWay) {
            if (this.currentFoundIndex < this.foundNodesList.size()) {
                this.doFind(this.currentFoundIndex++);
            }
        } else if (this.currentFoundIndex < this.foundNodesList.size() - 1) {
            ++this.currentFoundIndex;
            String BROWSERTREESEARCH = "BROWSERTREESEARCH";
            final JStatusBar statusBar = UIRegistry.getStatusBar();
            statusBar.setIndeterminate("BROWSERTREESEARCH", true);
            String msg = UIRegistry.getLocalizedMessage("TREEBROWSESEARCH", this.searchText);
            statusBar.setText(msg);
            UIRegistry.writeSimpleGlassPaneMsg(msg, 24);
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    TreeBrowserPanel.this.doFind(TreeBrowserPanel.this.currentFoundIndex++);
                    return null;
                }

                @Override
                public void finished() {
                    statusBar.setProgressDone("BROWSERTREESEARCH");
                    statusBar.setText(UIRegistry.getLocalizedMessage("TREEBROWSESEARCH_FND", TreeBrowserPanel.this.foundNodesList.size(), TreeBrowserPanel.this.searchText));
                    UIRegistry.clearSimpleGlassPaneMsg();
                }
            };
            worker.start();
        }
        return this.currentFoundIndex < this.foundNodesList.size();
    }

    protected void doFind(int index) {
        Integer id = this.foundNodesList.get(index);
        Stack<Integer> idPath = new Stack<Integer>();
        while (id != null) {
            idPath.push(id);
            String sql = String.format(" SELECT ParentID FROM %s WHERE %s = %d", this.tableName, this.tableInfo.getPrimaryKeyName(), id);
            System.out.println(sql);
            id = BasicSQLUtils.getCount(sql);
        }
        ArrayList<BrowseTreeNode> treePath = new ArrayList<BrowseTreeNode>();
        BrowseTreeNode parentNode = this.root;
        treePath.add(this.root);
        int i = idPath.size() - 2;
        while (i >= 0) {
            int searchId = (Integer)idPath.get(i);
            int j = 0;
            while (j < parentNode.getChildCount()) {
                BrowseTreeNode childNode = (BrowseTreeNode)parentNode.getChildAt(j);
                if (childNode.getId() == searchId) {
                    parentNode = childNode;
                    treePath.add(childNode);
                    childNode.getChildCount();
                    break;
                }
                ++j;
            }
            --i;
        }
        for (BrowseTreeNode btn : treePath) {
            System.out.println("-> " + btn.getTitle());
        }
        TreePath selTreePath = new TreePath(treePath.toArray());
        this.tree.getSelectionModel().setSelectionPath(selTreePath);
        this.tree.scrollPathToVisible(selTreePath);
    }

    public synchronized void findByName(String name, boolean isExact) {
        this.foundNodesList.clear();
        try {
            String newName = name;
            if (!isExact) {
                if (newName.contains("*")) {
                    // empty if block
                }
                if (!(newName = newName.replace("*", "%")).endsWith("%")) {
                    newName = String.valueOf(newName) + "%";
                }
            }
            String sql = String.format(" SELECT %s FROM %s WHERE " + this.columns + " AND Name LIKE '%s'", this.tableInfo.getPrimaryKeyName(), this.tableName, newName);
            log.debug((Object)sql);
            for (Object idObj : BasicSQLUtils.querySingleCol(sql)) {
                this.foundNodesList.add((Integer)idObj);
                log.debug((Object)((Integer)idObj));
            }
            if (!this.foundNodesList.isEmpty()) {
                this.currentFoundIndex = 0;
                this.treeBrowserFindPanel.getNextButton().setEnabled(this.doFindNext());
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(HibernateTreeDataServiceImpl.class, ex);
            log.error((Object)ex);
        }
    }

    class BrowseTreeNode
    extends DefaultMutableTreeNode {
        private boolean areChildrenDefined = false;
        private int id;
        private int rankId;
        private Integer numChildren = null;
        private String title;

        public BrowseTreeNode(int id, int rankId, String title) {
            this.id = id;
            this.rankId = rankId;
            this.title = title;
        }

        @Override
        public boolean isLeaf() {
            if (this.numChildren == null) {
                this.numChildren = BasicSQLUtils.getCount(String.format("SELECT COUNT(*) FROM %s WHERE ParentID = %d", TreeBrowserPanel.this.tableName, this.id));
            }
            return this.numChildren != null ? this.numChildren == 0 : true;
        }

        public boolean isLoaded() {
            return this.numChildren != null;
        }

        @Override
        public int getChildCount() {
            if (!this.areChildrenDefined) {
                this.loadChildNodes();
            }
            return super.getChildCount();
        }

        public int getId() {
            return this.id;
        }

        public int getRankId() {
            return this.rankId;
        }

        public String getTitle() {
            return this.title;
        }

        public void loadChildNodes() {
            this.areChildrenDefined = true;
            String sql = String.format("SELECT %sID, FullName, RankID FROM %s WHERE ParentID = %d ORDER BY FullName", TreeBrowserPanel.this.clazz.getSimpleName(), TreeBrowserPanel.this.tableName, this.id);
            Vector<Object[]> rows = BasicSQLUtils.query(sql);
            this.numChildren = rows.size();
            for (Object[] row : rows) {
                Integer nodeId = (Integer)row[0];
                String title = row[1].toString();
                this.add(new BrowseTreeNode(nodeId, (Integer)row[2], title));
            }
        }

        @Override
        public String toString() {
            return this.title;
        }
    }

    class SpTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected JLabel leftLbl;
        protected JLabel rightLbl;
        protected DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

        public SpTreeCellRenderer() {
            this.setOpaque(false);
            this.leftLbl = new JLabel();
            this.rightLbl = new JLabel();
            this.rightLbl.setForeground(Color.LIGHT_GRAY);
            this.leftLbl.setOpaque(true);
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,2px,f:p:g", "p"), (JPanel)this);
            pb.add((Component)this.leftLbl, cc.xy(1, 1));
            pb.add((Component)this.rightLbl, cc.xy(3, 1));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            BrowseTreeNode node = (BrowseTreeNode)value;
            String level = "";
            if (node.getParent() == null || node.getParent().getChildAt(0) == node) {
                level = " (" + TreeBrowserPanel.this.treeDefRankNamesHash.get(node.getRankId()) + ")";
            }
            if (selected) {
                this.leftLbl.setForeground(this.defaultRenderer.getTextSelectionColor());
                this.leftLbl.setBackground(this.defaultRenderer.getBackgroundSelectionColor());
            } else {
                this.leftLbl.setForeground(this.defaultRenderer.getTextNonSelectionColor());
                this.leftLbl.setBackground(this.defaultRenderer.getBackgroundNonSelectionColor());
            }
            this.leftLbl.setText(node.getTitle());
            this.rightLbl.setText(level);
            return this;
        }
    }
}

