/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.specify.ui.treetables.TreeBrowserPanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class TreeBrowserFindPanel
extends JPanel
implements TimingTarget {
    protected TreeBrowserPanel treeBrowserPanel;
    protected JButton closeButton;
    protected JLabel findLabel;
    protected JTextField entryField;
    protected JButton findButton;
    protected JButton nextButton;
    protected JCheckBox exactChk;
    protected int mode;
    protected boolean hasBeenContracted = false;
    protected Dimension prefSize;
    protected Dimension contractedSize;
    protected boolean animationInProgress = false;
    protected boolean shrinking = false;
    protected boolean expanding = false;
    public static final int EXPANDED = 1;
    public static final int CONTRACTED = -1;

    public TreeBrowserFindPanel(TreeBrowserPanel treeBrowserPanel, int startingMode) {
        this.setLayout(new BoxLayout(this, 2));
        this.treeBrowserPanel = treeBrowserPanel;
        String find = UIRegistry.getResourceString("FIND");
        String next = UIRegistry.getResourceString("NEXT");
        this.closeButton = UIHelper.createIconBtn("Close", IconManager.IconSize.NonStd, "", false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeBrowserFindPanel.this.contract();
            }
        });
        this.closeButton.setEnabled(true);
        this.closeButton.setFocusable(false);
        this.closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((JButton)e.getSource()).setIcon(IconManager.getIcon("CloseHover"));
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((JButton)e.getSource()).setIcon(IconManager.getIcon("Close"));
                super.mouseExited(e);
            }
        });
        this.findLabel = UIHelper.createLabel(String.valueOf(find) + ": ");
        this.entryField = UIHelper.createTextField(32);
        this.entryField.setMaximumSize(this.entryField.getPreferredSize());
        this.findButton = UIHelper.createButton(find);
        this.findButton.setEnabled(false);
        this.nextButton = UIHelper.createButton(next);
        this.nextButton.setEnabled(false);
        this.exactChk = UIHelper.createCheckBox(UIRegistry.getResourceString("FindPanel.Exact"));
        this.exactChk.setSelected(AppPreferences.getLocalPrefs().getBoolean("FindPanel.Exact", true));
        this.exactChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AppPreferences.getLocalPrefs().putBoolean("FindPanel.Exact", TreeBrowserFindPanel.this.exactChk.isSelected());
            }
        });
        this.exactChk.setToolTipText(UIRegistry.getResourceString("FindPanel.ExactChkTT"));
        this.add(this.closeButton);
        this.add(Box.createRigidArea(this.closeButton.getPreferredSize()));
        this.add(this.findLabel);
        this.add(this.entryField);
        this.add(this.findButton);
        this.add(this.nextButton);
        this.add(this.exactChk);
        this.add(Box.createHorizontalGlue());
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() == TreeBrowserFindPanel.this.findButton || ae.getSource() == TreeBrowserFindPanel.this.entryField && TreeBrowserFindPanel.this.entryField.getText().length() > 0) {
                    TreeBrowserFindPanel.this.findClicked();
                } else if (ae.getSource() == TreeBrowserFindPanel.this.nextButton) {
                    TreeBrowserFindPanel.this.nextClicked();
                }
            }
        };
        this.entryField.addActionListener(buttonListener);
        this.findButton.addActionListener(buttonListener);
        this.nextButton.addActionListener(buttonListener);
        this.entryField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                boolean enable = TreeBrowserFindPanel.this.entryField.getText().length() > 0;
                TreeBrowserFindPanel.this.findButton.setEnabled(enable);
                TreeBrowserFindPanel.this.nextButton.setEnabled(false);
            }
        });
        this.mode = 1;
        if (startingMode == -1) {
            this.mode = startingMode;
        }
        this.prefSize = super.getPreferredSize();
        this.contractedSize = new Dimension(this.prefSize.width, 0);
    }

    public void expand() {
        if (this.mode == 1 || this.expanding || this.shrinking) {
            return;
        }
        this.expanding = true;
        Animator expander = new Animator(450, (TimingTarget)this);
        expander.start();
    }

    public void contract() {
        if (this.mode == -1 || this.shrinking || this.expanding) {
            return;
        }
        this.shrinking = true;
        if (!this.hasBeenContracted) {
            UIRegistry.displayInfoMsgDlgLocalized("FindPanel.RESTORE_HINT", new Object[0]);
            this.hasBeenContracted = true;
        }
        Animator expander = new Animator(300, (TimingTarget)this);
        expander.start();
    }

    protected void findClicked() {
        this.treeBrowserPanel.find(this.entryField.getText(), true, this.exactChk.isSelected());
    }

    protected void nextClicked() {
        this.nextButton.setEnabled(this.treeBrowserPanel.doFindNext());
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.shrinking || this.expanding) {
            return this.prefSize;
        }
        if (this.mode == -1) {
            return this.contractedSize;
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void begin() {
        this.animationInProgress = true;
    }

    public void end() {
        this.animationInProgress = false;
        if (this.expanding) {
            this.mode = 1;
            this.expanding = false;
            this.entryField.requestFocus();
        }
        if (this.shrinking) {
            this.mode = -1;
            this.shrinking = false;
        }
        Container c = this.getParent();
        ((Component)c).invalidate();
        ((Component)c).doLayout();
        ((Component)c).validate();
        c.repaint();
    }

    public void repeat() {
    }

    public void timingEvent(float fraction) {
        float sizeFrac = fraction;
        if (this.shrinking) {
            sizeFrac = 1.0f - fraction;
        }
        this.prefSize.height = (int)((float)super.getPreferredSize().height * sizeFrac);
        Container c = this.getParent();
        ((Component)c).invalidate();
        ((Component)c).doLayout();
        ((Component)c).validate();
        c.repaint();
        this.invalidate();
        this.repaint();
        this.validate();
    }

    public JButton getNextButton() {
        return this.nextButton;
    }
}

