/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.specify.tasks.DualViewSearchable;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.MultiStateToggleButton;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class FindPanel
extends JPanel
implements TimingTarget {
    protected DualViewSearchable views;
    protected JButton closeButton;
    protected JLabel findLabel;
    protected JTextField entryField;
    protected JButton findButton;
    protected JButton nextButton;
    protected MultiStateToggleButton whereToggleButton;
    protected JCheckBox exactChk;
    protected int mode;
    protected boolean hasBeenContracted = false;
    protected Dimension prefSize;
    protected Dimension contractedSize;
    protected boolean animationInProgress = false;
    protected boolean shrinking = false;
    protected boolean expanding = false;
    public static final int EXPANDED = 1;
    public static final int CONTRACTED = -1;

    public FindPanel(DualViewSearchable views, int startingMode) {
        this.setLayout(new BoxLayout(this, 2));
        this.views = views;
        String find = UIRegistry.getResourceString("FIND");
        String next = UIRegistry.getResourceString("NEXT");
        ImageIcon up = IconManager.getIcon("Top", IconManager.IconSize.Std16);
        ImageIcon down = IconManager.getIcon("Bottom", IconManager.IconSize.Std16);
        ImageIcon both = IconManager.getIcon("Both", IconManager.IconSize.Std16);
        this.closeButton = UIHelper.createIconBtn("Close", IconManager.IconSize.NonStd, "", false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FindPanel.this.contract();
            }
        });
        this.closeButton.setEnabled(true);
        this.closeButton.setFocusable(false);
        this.closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((JButton)e.getSource()).setIcon(IconManager.getIcon("CloseHover"));
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((JButton)e.getSource()).setIcon(IconManager.getIcon("Close"));
                super.mouseExited(e);
            }
        });
        this.findLabel = UIHelper.createLabel(String.valueOf(find) + ": ");
        this.entryField = UIHelper.createTextField(32);
        this.entryField.setMaximumSize(this.entryField.getPreferredSize());
        this.findButton = UIHelper.createButton(find);
        this.findButton.setEnabled(false);
        this.nextButton = UIHelper.createButton(next);
        this.nextButton.setEnabled(false);
        this.whereToggleButton = new MultiStateToggleButton(up, down, both);
        this.whereToggleButton.setStateIndex(0);
        this.whereToggleButton.setToolTipText(UIRegistry.getResourceString("FindPanel.WhereBtnTTUp"));
        this.whereToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                switch (FindPanel.this.whereToggleButton.getStateIndex()) {
                    case 0: {
                        FindPanel.this.whereToggleButton.setToolTipText(UIRegistry.getResourceString("FindPanel.WhereBtnTTLow"));
                        break;
                    }
                    case 1: {
                        FindPanel.this.whereToggleButton.setToolTipText(UIRegistry.getResourceString("FindPanel.WhereBtnTTBoth"));
                        break;
                    }
                    case 2: {
                        FindPanel.this.whereToggleButton.setToolTipText(UIRegistry.getResourceString("FindPanel.WhereBtnTTUp"));
                        break;
                    }
                    default: {
                        FindPanel.this.whereToggleButton.setToolTipText(null);
                    }
                }
            }
        });
        this.exactChk = UIHelper.createCheckBox(UIRegistry.getResourceString("FindPanel.Exact"));
        this.exactChk.setSelected(AppPreferences.getLocalPrefs().getBoolean("FindPanel.Exact", true));
        this.exactChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AppPreferences.getLocalPrefs().putBoolean("FindPanel.Exact", FindPanel.this.exactChk.isSelected());
            }
        });
        this.exactChk.setToolTipText(UIRegistry.getResourceString("FindPanel.ExactChkTT"));
        this.add(this.closeButton);
        this.add(Box.createRigidArea(this.closeButton.getPreferredSize()));
        this.add(this.findLabel);
        this.add(this.entryField);
        this.add(this.findButton);
        this.add(this.nextButton);
        this.add(this.whereToggleButton);
        this.add(this.exactChk);
        this.add(Box.createHorizontalGlue());
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() == FindPanel.this.findButton || ae.getSource() == FindPanel.this.entryField && FindPanel.this.entryField.getText().length() > 0) {
                    FindPanel.this.findClicked();
                } else if (ae.getSource() == FindPanel.this.nextButton) {
                    FindPanel.this.nextClicked();
                }
            }
        };
        this.entryField.addActionListener(buttonListener);
        this.findButton.addActionListener(buttonListener);
        this.nextButton.addActionListener(buttonListener);
        this.entryField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                boolean enable = FindPanel.this.entryField.getText().length() > 0;
                FindPanel.this.findButton.setEnabled(enable);
                FindPanel.this.nextButton.setEnabled(enable);
            }
        });
        this.mode = 1;
        if (startingMode == -1) {
            this.mode = startingMode;
        }
        this.prefSize = super.getPreferredSize();
        this.contractedSize = new Dimension(this.prefSize.width, 0);
    }

    public void expand() {
        if (this.mode == 1 || this.expanding || this.shrinking) {
            return;
        }
        this.expanding = true;
        Animator expander = new Animator(450, (TimingTarget)this);
        expander.start();
    }

    public void contract() {
        if (this.mode == -1 || this.shrinking || this.expanding) {
            return;
        }
        this.shrinking = true;
        if (!this.hasBeenContracted) {
            UIRegistry.displayInfoMsgDlgLocalized("FindPanel.RESTORE_HINT", new Object[0]);
            this.hasBeenContracted = true;
        }
        Animator expander = new Animator(300, (TimingTarget)this);
        expander.start();
    }

    protected void findClicked() {
        this.views.find(this.entryField.getText(), this.getWhere(), true, this.exactChk.isSelected());
    }

    protected void nextClicked() {
        this.views.findNext(this.entryField.getText(), this.getWhere(), true, this.exactChk.isSelected());
    }

    protected int getWhere() {
        switch (this.whereToggleButton.getStateIndex()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 1;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.shrinking || this.expanding) {
            return this.prefSize;
        }
        if (this.mode == -1) {
            return this.contractedSize;
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void begin() {
        this.animationInProgress = true;
    }

    public void end() {
        this.animationInProgress = false;
        if (this.expanding) {
            this.mode = 1;
            this.expanding = false;
            this.entryField.requestFocus();
        }
        if (this.shrinking) {
            this.mode = -1;
            this.shrinking = false;
        }
        Container c = this.getParent();
        ((Component)c).invalidate();
        ((Component)c).doLayout();
        ((Component)c).validate();
        c.repaint();
    }

    public void repeat() {
    }

    public void timingEvent(float fraction) {
        float sizeFrac = fraction;
        if (this.shrinking) {
            sizeFrac = 1.0f - fraction;
        }
        this.prefSize.height = (int)((float)super.getPreferredSize().height * sizeFrac);
        Container c = this.getParent();
        ((Component)c).invalidate();
        ((Component)c).doLayout();
        ((Component)c).validate();
        c.repaint();
        this.invalidate();
        this.repaint();
        this.validate();
    }

    public JButton getNextButton() {
        return this.nextButton;
    }
}

