/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.treetables;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.ui.treetables.TreeTableViewer;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.View;

public class DropDialog
extends CustomDialog {
    public static final int MERGE_BTN = 16;
    public static final int SYNMOVEMERGE = 31;
    public static final int SYN = 7;
    public static final int SYNMOVE = 15;
    public static final int SYNMERGE = 23;
    public static final int MOVEMERGE = 23;
    public static final int MERGE = 22;
    public static final int MOVE = 7;
    private static final int synOption = 0;
    private static final int moveOption = 1;
    private static final int mergeOption = 2;
    protected JButton mergeBtn = null;
    protected final boolean isMoveOK;
    protected final boolean isSynOK;
    protected final boolean isMergeOK;
    protected TreeTableViewer.NODE_DROPTYPE okAction = TreeTableViewer.NODE_DROPTYPE.CANCEL_DROP;
    protected TreeTableViewer.NODE_DROPTYPE applyAction = TreeTableViewer.NODE_DROPTYPE.CANCEL_DROP;
    protected int buttonCnt = 0;

    public DropDialog(Frame frame, boolean isMoveOK, boolean isSynOK, boolean isMergeOK, String droppedName, String droppedOnName, String synDescKey, String moveDescKey, String mergeDescKey) throws HeadlessException {
        super(frame, UIRegistry.getResourceString("DropDlg.DlgTitle"), true, 3, DropDialog.buildContentPanel(isMoveOK, isSynOK, isMergeOK, droppedName, droppedOnName, synDescKey, moveDescKey, mergeDescKey));
        this.isMoveOK = isMoveOK;
        this.isSynOK = isSynOK;
        this.isMergeOK = isMergeOK;
        this.setup();
    }

    protected static String getOptionText(int option, String droppedName, String droppedOnName) {
        if (option == 1) {
            return "<html><b>" + UIRegistry.getResourceString("TreeTableView.MOVE_NODE") + "</b>: " + String.format(UIRegistry.getResourceString("DropDlg.MOVE_NODE_TEXT"), droppedName, droppedOnName) + "</html>";
        }
        if (option == 0) {
            return "<html><b>" + UIRegistry.getResourceString("TreeTableView.SYNONIMIZE_NODE") + "</b>: " + String.format(UIRegistry.getResourceString("DropDlg.SYN_NODE_TEXT"), droppedOnName, droppedName) + "</html>";
        }
        if (option == 2) {
            return "<html><b>" + UIRegistry.getResourceString("DropDlg.Merge") + "</b>: " + String.format(UIRegistry.getResourceString("DropDlg.MERGE_NODE_TEXT"), droppedName, droppedOnName) + "</html>";
        }
        return "";
    }

    protected static String getOptionInfo(int option, String droppedName, String droppedOnName, String synDescKey, String moveDescKey, String mergeDescKey) {
        if (option == 1) {
            return String.format(UIRegistry.getResourceString(moveDescKey), droppedName, droppedOnName, droppedName, droppedName, droppedName);
        }
        if (option == 0) {
            return String.format(UIRegistry.getResourceString(synDescKey), droppedName, droppedOnName, droppedOnName, droppedName, droppedOnName, droppedName, droppedOnName);
        }
        if (option == 2) {
            return String.format(UIRegistry.getResourceString(mergeDescKey), droppedName, droppedOnName, droppedName, droppedOnName, droppedName, droppedOnName, droppedOnName, droppedOnName, droppedName, droppedOnName, droppedName, droppedOnName, droppedOnName, droppedName, droppedOnName);
        }
        return "";
    }

    protected static String getOptionInfoTT(int option) {
        if (option == 1) {
            return String.valueOf(UIRegistry.getResourceString("DropDlg.MoreInfoOn")) + " " + UIRegistry.getResourceString("TreeTableView.MOVE_NODE");
        }
        if (option == 0) {
            return String.valueOf(UIRegistry.getResourceString("DropDlg.MoreInfoOn")) + " " + UIRegistry.getResourceString("TreeTableView.SYNONIMIZE_NODE");
        }
        if (option == 2) {
            return String.valueOf(UIRegistry.getResourceString("DropDlg.MoreInfoOn")) + " " + UIRegistry.getResourceString("DropDlg.Merge");
        }
        return "";
    }

    protected static int computeWhichBtns(boolean isMoveOK, boolean isSynOK, boolean isMergeOK) {
        if (isMoveOK && isSynOK && isMergeOK) {
            return 31;
        }
        if (isMoveOK && isMergeOK) {
            return 23;
        }
        if (isMoveOK && isSynOK) {
            return 15;
        }
        if (isMoveOK) {
            return 7;
        }
        if (isSynOK && isMergeOK) {
            return 23;
        }
        if (isSynOK) {
            return 7;
        }
        if (isMergeOK) {
            return 22;
        }
        return 0;
    }

    protected static String getInfoDlgHelpContext(int option) {
        switch (option) {
            case 1: {
                return "Trees_Reparent";
            }
            case 0: {
                return "Trees_Synonymize";
            }
            case 2: {
                return "Trees_Merge";
            }
        }
        return "drag_drop";
    }

    protected static Component buildContentPanel(boolean isMoveOK, boolean isSynOK, boolean isMergeOK, final String droppedName, final String droppedOnName, final String synDescKey, final String moveDescKey, final String mergeDescKey) {
        int numOptions = 0;
        boolean[] options = new boolean[]{isSynOK, isMoveOK, isMergeOK};
        String rowLayout = "5dlu";
        int o = 0;
        while (o < options.length) {
            if (options[o]) {
                ++numOptions;
                rowLayout = String.valueOf(rowLayout) + ", 5dlu, f:p";
            }
            ++o;
        }
        rowLayout = String.valueOf(rowLayout) + ", 7dlu";
        CellConstraints cc = new CellConstraints();
        String colLayout = "5dlu, f:p:g, 2dlu, f:p, 5dlu";
        PanelBuilder pb = new PanelBuilder(new FormLayout(colLayout, rowLayout));
        int row = 0;
        int opt = 0;
        while (opt < options.length) {
            if (options[opt]) {
                JLabel actLbl = UIHelper.createLabel(DropDialog.getOptionText(opt, droppedName, droppedOnName));
                final int optNo = opt;
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        JTextArea ta = new JTextArea(DropDialog.getOptionInfo(optNo, droppedName, droppedOnName, moveDescKey, synDescKey, mergeDescKey));
                        ta.setLineWrap(true);
                        ta.setWrapStyleWord(true);
                        ta.setEditable(false);
                        View v = ta.getUI().getRootView(ta);
                        v.setSize(600.0f, 2.1474836E9f);
                        String pref = Float.toString(v.getPreferredSpan(1));
                        pref = pref.substring(0, pref.indexOf("."));
                        Integer preferredHeight = new Integer(pref);
                        ta.setPreferredSize(new Dimension(600, preferredHeight));
                        CustomDialog cd = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("DropDlg.TreeActionDetailTitle"), true, 5, ta, 1);
                        cd.setHelpContext(DropDialog.getInfoDlgHelpContext(optNo));
                        cd.createUI();
                        UIHelper.centerAndShow(cd);
                    }
                };
                JButton actInfoBtn = UIHelper.createIconBtn("InfoIcon", IconManager.IconSize.Std16, DropDialog.getOptionInfoTT(opt), al);
                actInfoBtn.setEnabled(true);
                pb.add((Component)actLbl, cc.xy(2, 1 + (row + 1) * 2));
                pb.add((Component)actInfoBtn, cc.xy(4, 1 + (row + 1) * 2));
                ++row;
            }
            ++opt;
        }
        return pb.getPanel();
    }

    protected void setup() {
        this.whichBtns = DropDialog.computeWhichBtns(this.isMoveOK, this.isSynOK, this.isMergeOK);
        if (this.whichBtns == 31) {
            this.setOkLabel(UIRegistry.getResourceString("TreeTableView.SYNONIMIZE_NODE"));
            this.setApplyLabel(UIRegistry.getResourceString("TreeTableView.MOVE_NODE"));
            this.okAction = TreeTableViewer.NODE_DROPTYPE.SYNONIMIZE_NODE;
            this.applyAction = TreeTableViewer.NODE_DROPTYPE.MOVE_NODE;
        } else if (this.whichBtns == 23 && !this.isSynOK) {
            this.setOkLabel(UIRegistry.getResourceString("TreeTableView.MOVE_NODE"));
            this.okAction = TreeTableViewer.NODE_DROPTYPE.MOVE_NODE;
        } else if (this.whichBtns == 15) {
            this.setOkLabel(UIRegistry.getResourceString("TreeTableView.SYNONIMIZE_NODE"));
            this.setApplyLabel(UIRegistry.getResourceString("TreeTableView.MOVE_NODE"));
            this.okAction = TreeTableViewer.NODE_DROPTYPE.SYNONIMIZE_NODE;
            this.applyAction = TreeTableViewer.NODE_DROPTYPE.MOVE_NODE;
        } else if (this.whichBtns == 7 && this.isMoveOK) {
            this.setOkLabel(UIRegistry.getResourceString("TreeTableView.MOVE_NODE"));
            this.okAction = TreeTableViewer.NODE_DROPTYPE.MOVE_NODE;
        } else if (this.whichBtns == 23) {
            this.setOkLabel(UIRegistry.getResourceString("TreeTableView.SYNONIMIZE_NODE"));
            this.okAction = TreeTableViewer.NODE_DROPTYPE.SYNONIMIZE_NODE;
        } else if (this.whichBtns == 7 && this.isSynOK) {
            this.setOkLabel(UIRegistry.getResourceString("TreeTableView.SYNONIMIZE_NODE"));
            this.okAction = TreeTableViewer.NODE_DROPTYPE.SYNONIMIZE_NODE;
        }
    }

    @Override
    protected void createButtons() {
        this.setHelpContext("Trees_Drag");
        super.createButtons();
        if ((this.whichBtns & 0x10) == 16) {
            this.mergeBtn = UIHelper.createButton(UIRegistry.getResourceString("DropDlg.Merge"));
            this.mergeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DropDialog.this.mergeBtnPressed();
                }
            });
        }
        this.setCloseOnApplyClk(this.applyBtn != null);
    }

    protected void mergeBtnPressed() {
        this.isCancelled = false;
        this.btnPressed = 16;
        this.setVisible(false);
    }

    @Override
    protected JPanel buildButtonBar() {
        Vector<JButton> bv = new Vector<JButton>();
        if ((this.whichBtns & 1) == 1) {
            bv.add(this.okBtn);
        }
        if ((this.whichBtns & 8) == 8) {
            bv.add(this.applyBtn);
        }
        if ((this.whichBtns & 0x10) == 16) {
            bv.add(this.mergeBtn);
        }
        bv.add(this.cancelBtn);
        bv.add(this.helpBtn);
        JButton[] bs = new JButton[bv.size()];
        int b = 0;
        while (b < bv.size()) {
            bs[b] = (JButton)bv.get(b);
            ++b;
        }
        boolean leftToRight = UIHelper.getOSType() != UIHelper.OSTYPE.MacOSX;
        return ButtonBarFactory.buildRightAlignedBar((JButton[])bs, (boolean)leftToRight);
    }

    public TreeTableViewer.NODE_DROPTYPE getAction() {
        if (this.btnPressed == 1) {
            return this.okAction;
        }
        if (this.btnPressed == 8) {
            return this.applyAction;
        }
        if (this.btnPressed == 16) {
            return TreeTableViewer.NODE_DROPTYPE.MERGE_NODE;
        }
        return TreeTableViewer.NODE_DROPTYPE.CANCEL_DROP;
    }
}

