/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.db;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.ui.db.ResultSetTableModel;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SaveRecordSetDlg
extends JDialog {
    private static final Logger log = Logger.getLogger(SaveRecordSetDlg.class);
    protected JTable srcTable;
    protected JTable dstTable;
    protected ResultSetTableModel srcModel;
    protected ResultSetTableModel dstModel;
    protected JButton selectAllBtn;
    protected JButton deselectAllBtn;
    protected JButton addAllBtn;
    protected JButton addAllSelectedBtn;
    protected JButton cancelBtn;
    protected JButton okBtn;

    public SaveRecordSetDlg(ResultSetTableModel srcModel, int[] preSelectedRows) {
        this.srcModel = srcModel;
        this.createUI(preSelectedRows);
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    protected void createUI(int[] preSelectedRows) {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        namePanel.add((Component)UIHelper.createI18NFormLabel("RecordSet_Name"), "West");
        JTextField nameTxtFld = UIHelper.createTextField("");
        namePanel.add((Component)nameTxtFld, "Center");
        panel.add((Component)namePanel, "North");
        try {
            this.srcTable = new JTable(this.srcModel);
            this.srcTable.setRowSelectionAllowed(true);
            this.srcTable.setDefaultRenderer(String.class, new BiColorTableCellRenderer(true));
            this.dstTable = new JTable(this.dstModel);
            this.dstTable.setRowSelectionAllowed(true);
            this.dstTable.setDefaultRenderer(String.class, new BiColorTableCellRenderer(true));
            JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.srcTable), new JScrollPane(this.dstTable));
            splitPane.setDividerLocation(325);
            panel.add((Component)splitPane, "Center");
            this.selectAllBtn = UIHelper.createButton(UIRegistry.getResourceString("SELECTALL"));
            this.deselectAllBtn = UIHelper.createButton(UIRegistry.getResourceString("DeselectAll"));
            this.addAllBtn = UIHelper.createButton(UIRegistry.getResourceString("AddAll"));
            this.addAllSelectedBtn = UIHelper.createButton(UIRegistry.getResourceString("AddAllSelected"));
            this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
            this.okBtn = UIHelper.createButton(UIRegistry.getResourceString("OK"));
            ButtonBarBuilder btnBuilder = new ButtonBarBuilder();
            btnBuilder.addGriddedButtons(new JButton[]{this.selectAllBtn, this.deselectAllBtn, this.addAllBtn, this.addAllSelectedBtn, this.cancelBtn, this.okBtn});
            this.selectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SaveRecordSetDlg.this.srcTable.selectAll();
                }
            });
            this.deselectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SaveRecordSetDlg.this.srcTable.clearSelection();
                }
            });
            this.addAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SaveRecordSetDlg.this.addAll();
                }
            });
            this.addAllSelectedBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SaveRecordSetDlg.this.addAddSelected();
                }
            });
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SaveRecordSetDlg.this.setVisible(false);
                }
            });
            panel.add((Component)btnBuilder.getPanel(), "South");
            this.setSize(btnBuilder.getPanel().getPreferredSize().width + 20, 600);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SaveRecordSetDlg.class, ex);
            log.error((Object)ex);
        }
        this.setContentPane(panel);
    }

    protected void addAll() {
        this.srcTable.selectAll();
        this.srcTable.clearSelection();
    }

    protected void addAddSelected() {
        this.srcTable.clearSelection();
    }
}

