/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.ui.db.ResultSetTableModel;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class ResultSetTableModelDirect
extends AbstractTableModel {
    private static final Logger log = Logger.getLogger(ResultSetTableModel.class);
    protected ResultSet resultSet = null;
    protected ResultSetMetaData metaData = null;
    protected Vector<Class<?>> classNames = new Vector();
    protected int currentRow = 0;
    protected int numRows = 0;
    protected String[] columnNames = null;

    public ResultSetTableModelDirect(ResultSet resultSet) {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(ResultSetTableModelDirect.class, ex);
                log.error((Object)ex);
            }
        }
        this.resultSet = resultSet;
        try {
            if (this.resultSet != null) {
                this.metaData = this.resultSet.getMetaData();
                int i = 1;
                while (i <= this.metaData.getColumnCount()) {
                    this.classNames.addElement(Class.forName(this.metaData.getColumnClassName(i)));
                    ++i;
                }
                if (!this.resultSet.first()) {
                    return;
                }
                if (this.resultSet.last()) {
                    this.numRows = this.resultSet.getRow();
                }
                this.resultSet.first();
                this.currentRow = 1;
            }
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(ResultSetTableModelDirect.class, ex);
            log.error((Object)"In constructor of ResultSetTableModel", (Throwable)ex);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ResultSetTableModelDirect.class, ex);
            log.error((Object)"In constructor of ResultSetTableModel", (Throwable)ex);
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public int getColumnCount() {
        if (this.columnNames != null) {
            return this.columnNames.length;
        }
        try {
            return this.metaData == null ? 0 : this.metaData.getColumnCount();
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(ResultSetTableModelDirect.class, ex);
            log.error((Object)"In getColumnCount", (Throwable)ex);
            return 0;
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.classNames.size() == 0 ? String.class : this.classNames.elementAt(column);
    }

    @Override
    public String getColumnName(int column) {
        if (this.columnNames != null) {
            return this.columnNames[column];
        }
        if (this.metaData == null) {
            return "N/A";
        }
        try {
            return this.metaData.getColumnName(column + 1);
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(ResultSetTableModelDirect.class, ex);
            return "N/A";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int rowArg, int colArg) {
        int column = colArg + 1;
        int row = rowArg;
        if (this.resultSet == null) {
            return null;
        }
        try {
            if (++row == 1) {
                if (!this.resultSet.first()) {
                    log.error((Object)"Error doing resultSet.first");
                    return null;
                }
                this.currentRow = 1;
                return this.resultSet.getObject(column);
            }
            if (this.currentRow + 1 == row) {
                if (!this.resultSet.next()) {
                    log.error((Object)"Error doing resultSet.next");
                    return null;
                }
                ++this.currentRow;
                return this.resultSet.getObject(column);
            }
            if (!this.resultSet.absolute(row)) {
                log.error((Object)("Error doing resultSet.absolute(" + row + ")"));
                return null;
            }
            this.currentRow = row;
            return this.resultSet.getObject(column);
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(ResultSetTableModelDirect.class, ex);
            log.error((Object)"getValueAt", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    public void clear() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(ResultSetTableModelDirect.class, ex);
                log.error((Object)ex);
            }
            this.resultSet = null;
        }
        this.metaData = null;
        this.classNames.clear();
        this.currentRow = 0;
        this.numRows = 0;
    }

    public RecordSetIFace getRecordSet(int[] rows, int column, boolean returnAll) {
        RecordSet rs;
        block8: {
            rs = new RecordSet();
            rs.initialize();
            if (!(returnAll || rows != null && rows.length != 0)) {
                return rs;
            }
            if (this.resultSet.first()) break block8;
            log.error((Object)"Error doing resultSet.first");
            return null;
        }
        try {
            if (rows == null) {
                do {
                    rs.addItem(this.resultSet.getInt(column + 1));
                } while (this.resultSet.next());
                return rs;
            }
            int i = 0;
            while (i < rows.length) {
                if (this.resultSet.absolute(rows[i])) {
                    rs.addItem(this.resultSet.getInt(column + 1));
                }
                ++i;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ResultSetTableModelDirect.class, ex);
            log.error((Object)ex);
        }
        return null;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }
}

