/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.db;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.forms.DataObjectSettable;
import edu.ku.brc.af.ui.forms.DataObjectSettableFactory;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.dbsupport.JPAQuery;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.SQLExecutionListener;
import edu.ku.brc.dbsupport.SQLExecutionProcessor;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.tasks.subpane.ESResultsTablePanelIFace;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ResultSetTableModel
extends DefaultTableModel
implements SQLExecutionListener,
CustomQueryListener {
    private static final Logger log = Logger.getLogger(ResultSetTableModel.class);
    protected static DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
    protected static int VISIBLE_ROWS = 10;
    protected ESResultsTablePanelIFace parentERTP;
    protected Vector<Class<?>> classNames = new Vector();
    protected Vector<String> colNames = new Vector();
    protected int currentRow = 0;
    protected QueryForIdResultsIFace results;
    protected boolean doSequentially;
    protected int numColumns = 0;
    protected Vector<Integer> ids = null;
    protected Vector<Vector<Object>> cache = new Vector();
    protected List<ERTICaptionInfo> captionInfo = null;
    protected int[] columnIndexMapper = null;
    protected PropertyChangeListener propertyListener = null;
    protected JStatusBar statusBar = UIRegistry.getStatusBar();
    protected boolean doDebug = AppPreferences.getLocalPrefs().getBoolean("esdebug", false);
    protected int startInx = 0;
    protected int endInx = 0;
    protected boolean useColOffset = false;

    public ResultSetTableModel(ESResultsTablePanelIFace parentERTP, QueryForIdResultsIFace results) {
        this(parentERTP, results, false);
    }

    public ResultSetTableModel(ESResultsTablePanelIFace parentERTP, QueryForIdResultsIFace results, boolean doSequentially, boolean doSelfStart) {
        this.parentERTP = parentERTP;
        this.results = results;
        this.doSequentially = doSequentially;
        this.captionInfo = results.getVisibleCaptionInfo();
        if (!results.showProgress()) {
            this.statusBar = null;
        }
        this.initialize();
        if (doSelfStart) {
            this.startDataAquisition(doSequentially);
        }
    }

    public ResultSetTableModel(ESResultsTablePanelIFace parentERTP, QueryForIdResultsIFace results, boolean doSequentially) {
        this(parentERTP, results, doSequentially, true);
    }

    protected void initialize() {
    }

    public void startDataAcquisition() {
        this.startDataAquisition(this.doSequentially);
    }

    protected void startDataAquisition(boolean doSequentiallyArg) {
        if (this.statusBar != null) {
            this.statusBar.incrementRange(this.getClass().getSimpleName());
        }
        if (this.results.isHQL()) {
            List<ERTICaptionInfo> captions = this.results.getVisibleCaptionInfo();
            this.numColumns = captions.size();
            for (ERTICaptionInfo caption : captions) {
                Class<?> cls = caption.getColClass();
                this.classNames.addElement(cls == Boolean.class ? String.class : cls);
                this.colNames.addElement(caption.getColName());
            }
            JPAQuery jpaQuery = null;
            String sqlStr = this.results.getSQL(this.results.getSearchTerm(), this.ids);
            if (sqlStr != null) {
                jpaQuery = new JPAQuery(sqlStr, (CustomQueryListener)this);
                jpaQuery.setMaxResults(this.results.getMaxTableRows());
                jpaQuery.setParams(this.results.getParams());
                if (doSequentiallyArg) {
                    jpaQuery.execute();
                } else {
                    this.results.setQueryTask(jpaQuery.start());
                }
            }
        } else {
            SQLExecutionProcessor sqlProc = new SQLExecutionProcessor(this, this.results.getSQL(this.results.getSearchTerm(), this.ids));
            if (doSequentiallyArg) {
                sqlProc.execute();
            } else {
                sqlProc.start();
            }
        }
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public void cleanUp() {
        this.parentERTP = null;
        this.results = null;
        this.propertyListener = null;
        for (Vector<Object> list : this.cache) {
            list.clear();
        }
        this.cache.clear();
        if (this.ids != null) {
            this.ids.clear();
        }
    }

    @Override
    public int getColumnCount() {
        if (this.captionInfo != null) {
            return this.captionInfo.size();
        }
        return this.numColumns;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class<?> cls = this.getColumnClass2(column);
        if (cls == Calendar.class) {
            return String.class;
        }
        return cls;
    }

    protected Class<?> getColumnClass2(int column) {
        if (this.captionInfo != null) {
            if (this.captionInfo.get(column).getColClass() == null) {
                return String.class;
            }
            return this.captionInfo.get(column).getColClass();
        }
        if (this.classNames.size() > 0) {
            Class<?> classObj = this.classNames.elementAt(column);
            if (classObj == Calendar.class || classObj == Date.class || classObj == java.util.Date.class || classObj == Timestamp.class) {
                return String.class;
            }
            return classObj;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        if (this.captionInfo != null) {
            return this.captionInfo.get(column).getColLabel();
        }
        if (column > -1 && column < this.colNames.size()) {
            return this.colNames.get(column);
        }
        return "N/A";
    }

    public Object getCacheValueAt(int row, int column) {
        if (row > -1 && row < this.cache.size()) {
            Vector<Object> rowArray = this.cache.get(row);
            if (column > -1 && column < rowArray.size()) {
                return rowArray.get(column);
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row > -1 && row < this.cache.size()) {
            Vector<Object> rowArray = this.cache.get(row);
            if (column > -1 && column < rowArray.size()) {
                UIFieldFormatterIFace formatter;
                Object obj = rowArray.get(column);
                Class<?> dataClassObj = this.getColumnClass2(column);
                if (obj == null && (dataClassObj == null || dataClassObj == String.class)) {
                    return "";
                }
                if (obj instanceof Calendar) {
                    return scrDateFormat.format((Calendar)obj);
                }
                if (obj instanceof Timestamp) {
                    return scrDateFormat.format((java.util.Date)obj);
                }
                if (obj instanceof Date || obj instanceof java.util.Date) {
                    return scrDateFormat.format((java.util.Date)obj);
                }
                if (obj instanceof Boolean) {
                    return UIRegistry.getResourceString(obj.toString());
                }
                UIFieldFormatterIFace uIFieldFormatterIFace = formatter = this.captionInfo != null ? this.captionInfo.get(column).getUiFieldFormatter() : null;
                if (formatter != null && formatter.isInBoundFormatter()) {
                    return formatter.formatToUI(obj);
                }
                return obj;
            }
        }
        return "No Data";
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
    }

    @Override
    public int getRowCount() {
        return this.cache == null ? 0 : this.cache.size();
    }

    public Integer getRowId(int index) {
        return this.ids.get(index);
    }

    @Override
    public void removeRow(int index) {
        this.cache.remove(index);
        this.ids.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public QueryForIdResultsIFace getQueryForIdResults() {
        return this.results;
    }

    public RecordSetIFace getRecordSet(int[] rows, boolean returnAll) {
        RecordSet rs = new RecordSet();
        rs.setType(RecordSet.GLOBAL);
        rs.initialize();
        if (!(returnAll || rows != null && rows.length != 0)) {
            return rs;
        }
        if (rows == null) {
            for (Integer id : this.ids) {
                rs.addItem(id);
            }
        } else {
            int[] nArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                int inx = nArray[n2];
                rs.addItem(this.ids.get(inx));
                ++n2;
            }
        }
        return rs;
    }

    public void clear() {
        if (this.ids != null) {
            this.ids.clear();
        }
        if (this.cache != null) {
            for (Vector<Object> row : this.cache) {
                row.clear();
            }
            this.cache.clear();
        }
        this.classNames.clear();
        this.colNames.clear();
        this.currentRow = 0;
    }

    public void setPropertyListener(PropertyChangeListener propertyListener) {
        this.propertyListener = propertyListener;
    }

    protected void setField(DataObjectSettable setter, Object parent, String fieldName, Class<?> fieldClass, ResultSet resultSet, int colIndex) throws SQLException {
        Object fieldDataObj = resultSet.getObject(colIndex + 1);
        if (fieldDataObj != null) {
            if (fieldClass == String.class) {
                setter.setFieldValue(parent, fieldName, fieldDataObj);
            } else if (fieldClass == Byte.class) {
                setter.setFieldValue(parent, fieldName, resultSet.getByte(colIndex + 1));
            } else if (fieldClass == Short.class) {
                setter.setFieldValue(parent, fieldName, resultSet.getShort(colIndex + 1));
            } else {
                setter.setFieldValue(parent, fieldName, fieldDataObj);
            }
        }
    }

    @Override
    public synchronized void exectionDone(SQLExecutionProcessor process, ResultSet resultSet) {
        block48: {
            if (this.statusBar != null) {
                this.statusBar.incrementValue(this.getClass().getSimpleName());
            }
            if (resultSet == null || this.results == null) {
                log.error((Object)("The " + (resultSet == null ? "resultSet" : "results") + " is null."));
                if (this.propertyListener != null) {
                    this.propertyListener.propertyChange(new PropertyChangeEvent(this, "rowCount", null, 0));
                }
                return;
            }
            List<ERTICaptionInfo> captions = this.results.getVisibleCaptionInfo();
            try {
                if (!resultSet.next()) break block48;
                ResultSetMetaData metaData = resultSet.getMetaData();
                boolean hasCompositeObj = false;
                DataObjSwitchFormatter dataObjFormatter = null;
                UIFieldFormatterIFace formatter = null;
                Object compObj = null;
                ERTICaptionInfo aggCaption = null;
                ERTICaptionInfo compositeCaption = null;
                Vector aggList = null;
                DataObjectSettable aggSetter = null;
                Stack aggListRecycler = null;
                DataObjectSettable dataSetter = null;
                this.numColumns = captions.size();
                for (ERTICaptionInfo caption : captions) {
                    this.colNames.addElement(caption.getColLabel());
                    int inx = caption.getPosIndex() + 1;
                    Class cls = null;
                    try {
                        cls = Class.forName(metaData.getColumnClassName(inx));
                        if (cls == Calendar.class || cls == Date.class || cls == java.util.Date.class) {
                            cls = String.class;
                        }
                    }
                    catch (SQLException ex) {
                        cls = String.class;
                    }
                    this.classNames.addElement(cls);
                    caption.setColClass(cls);
                    if (caption.getAggregatorName() != null) {
                        aggList = new Vector();
                        aggListRecycler = new Stack();
                        aggCaption = caption;
                        aggSetter = DataObjectSettableFactory.get(aggCaption.getAggClass().getName(), "edu.ku.brc.af.ui.forms.DataSetterForObj");
                        if (aggCaption.getSubClass() != null) {
                            dataSetter = DataObjectSettableFactory.get(aggCaption.getSubClass().getName(), "edu.ku.brc.af.ui.forms.DataSetterForObj");
                            continue;
                        }
                        dataSetter = aggSetter;
                        continue;
                    }
                    if (caption.getColInfoList() == null) continue;
                    formatter = caption.getUiFieldFormatter();
                    if (formatter != null) {
                        compositeCaption = caption;
                        continue;
                    }
                    hasCompositeObj = true;
                    aggCaption = caption;
                    dataObjFormatter = caption.getDataObjFormatter();
                    if (dataObjFormatter != null) {
                        if (dataObjFormatter.getDataClass() != null) {
                            aggSetter = DataObjectSettableFactory.get(dataObjFormatter.getDataClass().getName(), "edu.ku.brc.af.ui.forms.DataSetterForObj");
                            continue;
                        }
                        log.error((Object)("formatterObj.getDataClass() was null for " + caption.getColName()));
                        continue;
                    }
                    log.error((Object)("DataObjFormatter was null for " + caption.getColName()));
                }
                if (aggCaption != null) {
                    int i;
                    block5: for (ERTICaptionInfo.ColInfo colInfo : aggCaption.getColInfoList()) {
                        i = 0;
                        while (i < metaData.getColumnCount()) {
                            String colName = StringUtils.substringAfterLast((String)colInfo.getColumnName(), (String)".");
                            if (colName.equalsIgnoreCase(metaData.getColumnName(i + 1))) {
                                colInfo.setPosition(i);
                                continue block5;
                            }
                            ++i;
                        }
                    }
                    String ordColName = aggCaption.getOrderCol();
                    if (StringUtils.isNotEmpty((String)ordColName)) {
                        String colName = StringUtils.substringAfterLast((String)ordColName, (String)".");
                        i = 0;
                        while (i < metaData.getColumnCount()) {
                            if (colName.equalsIgnoreCase(metaData.getColumnName(i + 1))) {
                                aggCaption.setOrderColIndex(i);
                                break;
                            }
                            ++i;
                        }
                        if (aggCaption.getOrderColIndex() == -1) {
                            log.error((Object)("Agg Order Column Index wasn't found [" + ordColName + "]"));
                        }
                    }
                }
                if (this.ids == null) {
                    this.ids = new Vector();
                } else {
                    this.ids.clear();
                }
                DataObjFieldFormatMgr dataObjMgr = DataObjFieldFormatMgr.getInstance();
                Vector<Object> row = null;
                boolean firstTime = true;
                int prevId = Integer.MAX_VALUE;
                int numCols = resultSet.getMetaData().getColumnCount();
                do {
                    int id = resultSet.getInt(1);
                    if (aggCaption != null && !hasCompositeObj) {
                        if (firstTime) {
                            prevId = id;
                            row = new Vector();
                            firstTime = false;
                            this.cache.add(row);
                            this.ids.add(id);
                        } else if (id != prevId) {
                            if (row != null && aggList != null) {
                                int aggInx = captions.indexOf(aggCaption);
                                row.remove(aggInx);
                                row.insertElementAt(dataObjMgr.aggregate(aggList, aggCaption.getAggClass()), aggInx);
                                if (aggListRecycler != null) {
                                    aggListRecycler.addAll(aggList);
                                }
                                aggList.clear();
                                row = new Vector();
                                this.cache.add(row);
                                this.ids.add(id);
                            }
                            prevId = id;
                        } else if (row == null) {
                            row = new Vector();
                            this.cache.add(row);
                            this.ids.add(id);
                        }
                    } else {
                        row = new Vector<Object>();
                        this.cache.add(row);
                        this.ids.add(id);
                    }
                    for (ERTICaptionInfo caption : captions) {
                        int posIndex = caption.getPosIndex();
                        if (caption == aggCaption) {
                            if (hasCompositeObj) {
                                if (aggSetter != null && row != null && dataObjFormatter != null) {
                                    if (compObj == null) {
                                        compObj = aggCaption.getAggClass().newInstance();
                                    }
                                    for (ERTICaptionInfo.ColInfo colInfo : aggCaption.getColInfoList()) {
                                        this.setField(aggSetter, compObj, colInfo.getFieldName(), colInfo.getFieldClass(), resultSet, colInfo.getPosition());
                                    }
                                    row.add(DataObjFieldFormatMgr.getInstance().format(compObj, compObj.getClass()));
                                    continue;
                                }
                                if (formatter != null) {
                                    int len = compositeCaption.getColInfoList().size();
                                    Object[] val = new Object[len];
                                    int i = 0;
                                    for (ERTICaptionInfo.ColInfo colInfo : compositeCaption.getColInfoList()) {
                                        int colInx = colInfo.getPosition() + posIndex + 1;
                                        val[i++] = colInx < numCols ? resultSet.getObject(colInx) : "(Missing Data)";
                                    }
                                    row.add(formatter.formatToUI(val));
                                    continue;
                                }
                                log.error((Object)("Aggregator is null! [" + aggCaption.getAggregatorName() + "] or row or aggList"));
                                continue;
                            }
                            if (aggSetter != null && row != null && aggList != null) {
                                Object dataObj;
                                Object aggObj = aggListRecycler.size() == 0 ? aggCaption.getAggClass().newInstance() : aggListRecycler.pop();
                                Object aggSubObj = aggCaption.getSubClass() != null ? aggCaption.getSubClass().newInstance() : null;
                                aggList.add(aggObj);
                                if (aggSubObj != null) {
                                    aggSetter.setFieldValue(aggObj, aggCaption.getSubClassFieldName(), aggSubObj);
                                    dataObj = aggSubObj;
                                } else {
                                    dataObj = aggObj;
                                }
                                for (ERTICaptionInfo.ColInfo colInfo : aggCaption.getColInfoList()) {
                                    this.setField(dataSetter, dataObj, colInfo.getFieldName(), colInfo.getFieldClass(), resultSet, colInfo.getPosition());
                                }
                                row.add("PlaceHolder");
                                continue;
                            }
                            if (aggSetter != null && aggList != null) continue;
                            log.error((Object)("Aggregator is null! [" + aggCaption.getAggregatorName() + "] or aggList[" + aggList + "]"));
                            continue;
                        }
                        if (row == null) continue;
                        Object obj = caption.processValue(resultSet.getObject(posIndex + 1));
                        row.add(obj);
                    }
                } while (resultSet.next());
                if (aggCaption != null && aggList != null && aggList.size() > 0 && row != null) {
                    int aggInx = captions.indexOf(aggCaption);
                    row.remove(aggInx);
                    String colStr = StringUtils.isNotEmpty((String)aggCaption.getAggregatorName()) ? DataObjFieldFormatMgr.getInstance().aggregate(aggList, aggCaption.getAggregatorName()) : DataObjFieldFormatMgr.getInstance().aggregate(aggList, aggCaption.getAggClass());
                    row.insertElementAt(colStr, aggInx);
                    aggList.clear();
                    aggListRecycler.clear();
                }
                this.fireTableStructureChanged();
                this.fireTableDataChanged();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.propertyListener != null) {
            this.propertyListener.propertyChange(new PropertyChangeEvent(this, "rowCount", null, new Integer(this.cache.size())));
        }
    }

    @Override
    public synchronized void executionError(SQLExecutionProcessor process, Exception ex) {
        if (this.statusBar != null) {
            this.statusBar.incrementValue(this.getClass().getSimpleName());
        }
    }

    @Override
    public void exectionDone(CustomQueryIFace customQuery) {
        if (this.statusBar != null) {
            this.statusBar.incrementValue(this.getClass().getSimpleName());
        }
        this.results.queryTaskDone(customQuery);
        List<?> list = customQuery.getDataObjects();
        List<ERTICaptionInfo> captions = this.results.getVisibleCaptionInfo();
        if (this.ids == null) {
            this.ids = new Vector();
        } else {
            this.ids.clear();
        }
        if (!customQuery.isInError() && !customQuery.isCancelled() && list != null && list.size() > 0) {
            int maxTableRows = this.results.getMaxTableRows();
            int rowNum = 0;
            for (Object rowObj : list) {
                if (rowNum == maxTableRows || customQuery.isCancelled()) break;
                Vector<Object> row = new Vector<Object>(rowObj.getClass().isArray() ? ((Object[])rowObj).length : 1);
                if (rowObj != null && rowObj.getClass().isArray()) {
                    Object[] rowCols = (Object[])rowObj;
                    int capInx = 0;
                    int col = 0;
                    while (col < rowCols.length) {
                        Object colObj = rowCols[col];
                        ERTICaptionInfo capInfo = captions.get(capInx);
                        if (col == 0) {
                            if (colObj instanceof Integer) {
                                this.ids.add((Integer)colObj);
                                if (this.doDebug) {
                                    log.debug((Object)("*** 1 Adding id[" + colObj + "]"));
                                }
                            } else {
                                row.add(capInfo.processValue(colObj));
                                ++capInx;
                            }
                        } else if (capInfo.getColName() == null && capInfo.getColInfoList().size() > 0) {
                            int len = capInfo.getColInfoList().size();
                            Object[] val = new Object[len];
                            int i = 0;
                            while (i < capInfo.getColInfoList().size()) {
                                val[i] = capInfo.processValue(rowCols[col + i]);
                                ++i;
                            }
                            row.add(capInfo.getUiFieldFormatter().formatToUI(val));
                            col += capInfo.getColInfoList().size() - 1;
                            ++capInx;
                        } else {
                            Object obj = capInfo.processValue(colObj);
                            row.add(obj);
                            if (this.doDebug) {
                                log.debug((Object)("*** 2 Adding id[" + obj + "]"));
                            }
                            ++capInx;
                        }
                        ++col;
                    }
                } else {
                    row.add(rowObj);
                }
                this.cache.add(row);
                ++rowNum;
            }
            this.results.cacheFilled(this.cache);
            this.fireTableDataChanged();
        }
        if (this.propertyListener != null) {
            this.propertyListener.propertyChange(new PropertyChangeEvent(this, "rowCount", null, new Integer(this.cache.size())));
        }
        if (this.parentERTP != null) {
            CommandAction cmdAction = new CommandAction("Express_Search", "SearchComplete", customQuery);
            cmdAction.setProperty("QueryForIdResultsIFace", this.results);
            cmdAction.setProperty("ESResultsTablePanelIFace", this.parentERTP);
            CommandDispatcher.dispatch(cmdAction);
        }
    }

    @Override
    public void executionError(CustomQueryIFace customQuery) {
        UIRegistry.getStatusBar().incrementValue(this.getClass().getSimpleName());
    }

    public ESResultsTablePanelIFace getParentERTP() {
        return this.parentERTP;
    }

    public boolean isLoadingCells() {
        return false;
    }

    public QueryForIdResultsIFace getResults() {
        return this.results;
    }
}

