/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.ui.db.PickListDBAdapter;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PickListTableAdapter
extends PickListDBAdapter {
    protected static final Logger logger = Logger.getLogger(PickListTableAdapter.class);

    public PickListTableAdapter(PickList pickList) {
        this.pickList = pickList;
        if (pickList != null) {
            this.fill(PickListDBAdapterIFace.Type.valueOf(pickList.getType().byteValue()));
        }
    }

    protected String buildHQL(DBTableInfo tableInfo, String fieldName) {
        String specialWhereClause;
        StringBuffer strBuf = new StringBuffer();
        if (fieldName != null) {
            strBuf.append("SELECT ");
            strBuf.append(tableInfo.getAbbrev());
            strBuf.append('.');
            strBuf.append(fieldName);
        }
        strBuf.append("FROM ");
        strBuf.append(tableInfo.getShortClassName());
        strBuf.append(" ");
        strBuf.append(tableInfo.getAbbrev());
        String joinSnipet = QueryAdjusterForDomain.getInstance().getJoinClause(tableInfo, true, null, false);
        if (joinSnipet != null) {
            strBuf.append(' ');
            strBuf.append(joinSnipet);
            strBuf.append(' ');
        }
        if (StringUtils.isNotEmpty((String)(specialWhereClause = QueryAdjusterForDomain.getInstance().getSpecialColumns(tableInfo, true)))) {
            strBuf.append(" WHERE ");
            strBuf.append(specialWhereClause);
        }
        return strBuf.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void fill(PickListDBAdapterIFace.Type type) {
        if (type == PickListDBAdapterIFace.Type.Item) return;
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(DBTableIdMgr.getInstance().getIdByShortName(this.pickList.getTableName()));
        if (tableInfo == null) throw new RuntimeException("Error looking up PickLIst's Table Name [" + this.pickList.getTableName() + "]");
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                String sqlStr = this.buildHQL(tableInfo, type == PickListDBAdapterIFace.Type.TableField ? this.pickList.getFieldName() : null);
                if (StringUtils.isNotEmpty((String)sqlStr)) {
                    List<?> dataList = session.getDataList(sqlStr);
                    if (dataList == null || dataList.isEmpty()) return;
                    if (type == PickListDBAdapterIFace.Type.TableField) {
                        String string = this.pickList.getFormatter();
                        boolean hasFormatter = StringUtils.isNotEmpty((String)string);
                        for (Object obj : dataList) {
                            void var8_14;
                            if (obj instanceof Object[]) {
                                Object object = ((Object[])obj)[0];
                            }
                            String valStr = hasFormatter ? String.format(string, var8_14) : var8_14.toString();
                            this.items.add(this.pickList.addItem(valStr, valStr));
                        }
                        return;
                    } else {
                        for (Object obj : dataList) {
                            void var8_17;
                            void var6_8;
                            if (obj instanceof Object[]) {
                                Object object = ((Object[])obj)[0];
                            }
                            if (this.pickList.getFormatter() != null) {
                                String string = DataObjFieldFormatMgr.getInstance().format((Object)var6_8, this.pickList.getFormatter());
                            } else {
                                String string = ((FormDataObjIFace)var6_8).getIdentityTitle();
                            }
                            this.items.add(this.pickList.addItem((String)var8_17, var6_8));
                        }
                    }
                    return;
                } else {
                    log.error((Object)("Query String is empty for tableId[" + tableInfo.getTableId() + "]"));
                }
                return;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PickListTableAdapter.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
                if (session == null) return;
                session.close();
            }
            return;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    @Override
    public PickListItemIFace addItem(String title, String value) {
        throw new RuntimeException("This type of PickList cannot be added to");
    }
}

