/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.db;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.PickListItem;
import edu.ku.brc.specify.ui.db.PickListDBAdapter;
import edu.ku.brc.specify.ui.db.PickListTableAdapter;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class PickListDBAdapterFactory
extends edu.ku.brc.af.ui.db.PickListDBAdapterFactory
implements CommandListener {
    protected static final String APP_CMD_TYPE = "App";
    protected static final String APP_START_ACT = "StartUp";
    protected static final String APP_RESTART_ACT = "AppRestart";
    protected static final String PICKLIST_TYPE = "PICKLIST";
    protected static final Logger log = Logger.getLogger(PickListDBAdapterFactory.class);
    protected static SoftReference<Hashtable<String, PickList>> hashSoftRef = null;

    public PickListDBAdapterFactory() {
        CommandDispatcher.register(PICKLIST_TYPE, this);
        CommandDispatcher.register(APP_CMD_TYPE, this);
        Hashtable hash = new Hashtable();
        hashSoftRef = new SoftReference(hash);
    }

    @Override
    public PickListDBAdapterIFace create(String name, boolean createWhenNotFound) {
        PickList pickList = this.getPickListInternal(name);
        if (pickList == null) {
            return new PickListDBAdapter(name);
        }
        if (pickList.getType().byteValue() == PickListDBAdapterIFace.Type.Item.value()) {
            return new PickListDBAdapter(pickList);
        }
        return new PickListTableAdapter(pickList);
    }

    @Override
    public PickListIFace getPickList(String name) {
        return this.getPickListInternal(name);
    }

    private Hashtable<String, PickList> getHash() {
        Hashtable<String, PickList> hash = null;
        if (hashSoftRef != null && (hash = hashSoftRef.get()) == null) {
            hash = new Hashtable();
            hashSoftRef = new SoftReference<Hashtable<String, PickList>>(hash);
        }
        return hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PickList getPickListInternal(String name) {
        Hashtable<String, PickList> hash = this.getHash();
        PickList pickList = null;
        if (hash != null) {
            boolean doLoad = true;
            pickList = hash.get(name);
            if (pickList != null) {
                int version = BasicSQLUtils.getCount("SELECT Version FROM picklist WHERE PickListID = " + pickList.getId());
                boolean bl = doLoad = version != pickList.getVersion();
            }
            if (!doLoad) return pickList;
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    String sql = "FROM PickList WHERE name = '" + name + "' AND collectionId = " + AppContextMgr.getInstance().getClassObject(Collection.class).getCollectionId();
                    pickList = (PickList)session.getData(sql);
                    if (pickList == null) return pickList;
                    hash.put(name, pickList);
                    return pickList;
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(PickListDBAdapterFactory.class, ex);
                    log.error((Object)ex);
                    ex.printStackTrace();
                    if (session == null) return pickList;
                    session.close();
                }
                return pickList;
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        } else {
            log.error((Object)"PickList hash was null!");
        }
        return pickList;
    }

    @Override
    public PickListIFace createPickList() {
        PickList pl = new PickList();
        pl.initialize();
        return pl;
    }

    @Override
    public PickListItemIFace createPickListItem() {
        PickListItem pli = new PickListItem();
        pli.initialize();
        return pli;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isAction(APP_RESTART_ACT) || cmdAction.isAction(APP_START_ACT)) {
            Hashtable<String, PickList> hash = hashSoftRef.get();
            if (hash != null) {
                hash.clear();
            }
        } else if (cmdAction.isType(PICKLIST_TYPE) && cmdAction.isAction("CLEAR")) {
            String pickListName = (String)cmdAction.getData();
            Hashtable<String, PickList> hash = this.getHash();
            if (hash != null) {
                hash.remove(pickListName);
            }
        }
    }
}

