/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.PickListItem;
import edu.ku.brc.ui.AutoCompComboBoxModelIFace;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PickListDBAdapter
extends AbstractListModel
implements PickListDBAdapterIFace,
MutableComboBoxModel,
AutoCompComboBoxModelIFace {
    protected static final Logger log = Logger.getLogger(PickListDBAdapter.class);
    protected static PickListItemIFace searchablePLI = new PickListItem();
    protected Vector<PickListItemIFace> items = new Vector();
    protected PickList pickList = null;
    protected Object selectedObject = null;
    protected boolean doAutoSaveOnAdd = true;
    protected boolean needsToBeSaved = false;
    protected Vector<ChangeListener> changeListeners = new Vector();

    protected PickListDBAdapter() {
        PickList pl = new PickList();
        pl.initialize();
        this.pickList = pl;
    }

    public PickListDBAdapter(PickList pickList) {
        this.pickList = pickList;
        this.loadItems(false);
        super.fireContentsChanged(this, 0, this.items.size() - 1);
    }

    protected void loadItems(boolean doReload) {
        block10: {
            if (doReload) {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        this.pickList = session.get(PickList.class, this.pickList.getId());
                    }
                    catch (Exception exception) {
                        if (session != null) {
                            session.close();
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
        }
        this.items.clear();
        for (PickListItemIFace pli : this.pickList.getItems()) {
            this.items.add(pli);
        }
        Collections.sort(this.items);
    }

    public PickListDBAdapter(String name) {
        this.pickList = new PickList();
        this.pickList.initialize();
        this.pickList.setName(name);
        DataModelObjBase.save(this.pickList);
    }

    @Override
    public void setAutoSaveOnAdd(boolean doAutoSave) {
        this.doAutoSaveOnAdd = doAutoSave;
    }

    @Override
    public PickListIFace getPickList() {
        return this.pickList;
    }

    @Override
    public Vector<PickListItemIFace> getList() {
        return this.items;
    }

    @Override
    public PickListItemIFace getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public PickListItemIFace addItem(String title, String value) {
        if (this.pickList.getReadOnly().booleanValue()) {
            throw new RuntimeException("Trying to add an item to a readonly picklist [" + this.pickList.getName() + "]");
        }
        int sizeLimit = 50;
        Integer sizeLimitInt = this.pickList.getSizeLimit();
        if (sizeLimitInt != null) {
            sizeLimit = sizeLimitInt;
        }
        searchablePLI.setTitle(title);
        int index = Collections.binarySearch(this.items, searchablePLI);
        if (index < 0) {
            this.needsToBeSaved = true;
            int version = BasicSQLUtils.getCount("SELECT Version FROM picklist WHERE PickListID = " + this.pickList.getId());
            if (version != this.pickList.getVersion()) {
                this.loadItems(true);
            }
            if (this.items.size() >= sizeLimit && sizeLimit > 0) {
                PickListItemIFace oldest = null;
                for (PickListItemIFace pli : this.items) {
                    if (oldest != null && pli.getTimestampCreated().getTime() >= oldest.getTimestampCreated().getTime()) continue;
                    oldest = pli;
                }
                this.items.remove(oldest);
                this.pickList.removeItem(oldest);
            }
            PickListItem item = new PickListItem(title, value, new Timestamp(System.currentTimeMillis()));
            this.items.add(item);
            if (this.pickList != null) {
                this.pickList.addItem(item);
                item.setPickList(this.pickList);
                this.pickList.reorder();
            }
            Collections.sort(this.items);
            if (this.doAutoSaveOnAdd) {
                this.save();
            }
            super.fireContentsChanged(this, 0, this.items.size() - 1);
            for (ChangeListener cl : this.changeListeners) {
                cl.stateChanged(new ChangeEvent(this));
            }
            return item;
        }
        return this.items.elementAt(index);
    }

    @Override
    public void save() {
        log.debug((Object)("Listeners: " + this.getListDataListeners().length));
        if (this.needsToBeSaved) {
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    session.beginTransaction();
                    session.saveOrUpdate(this.pickList);
                    session.commit();
                    this.needsToBeSaved = false;
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(PickListDBAdapter.class, e);
                    if (session != null) {
                        session.rollback();
                    }
                    e.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.pickList.getReadOnly();
    }

    @Override
    public boolean isTabledBased() {
        return this.pickList == null ? false : this.pickList.getType() > 0;
    }

    @Override
    public PickListDBAdapterIFace.Type getType() {
        switch (this.pickList.getType()) {
            case 0: {
                return PickListDBAdapterIFace.Type.Item;
            }
            case 1: {
                return PickListDBAdapterIFace.Type.Table;
            }
            case 2: {
                return PickListDBAdapterIFace.Type.TableField;
            }
        }
        throw new RuntimeException("Unknown picklist type[" + this.pickList.getType() + "]");
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        if (l != null) {
            this.changeListeners.add(l);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        if (l != null) {
            this.changeListeners.remove(l);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getElementAt(int index) {
        if (index >= 0 && index < this.items.size()) {
            return this.items.elementAt(index);
        }
        return null;
    }

    @Override
    public int getSize() {
        if (this.pickList.getId() == 28) {
            log.debug((Object)("Size: " + this.items.size() + "  Id: " + this.pickList.getId()));
        }
        return this.items.size();
    }

    public void addElement(Object anObject) {
        if (anObject instanceof PickListItemIFace) {
            PickListItemIFace item = (PickListItemIFace)anObject;
            this.items.add(item);
            item.setPickList(this.pickList);
            if (this.pickList != null) {
                this.pickList.addItem(item);
                this.pickList.reorder();
            }
            Collections.sort(this.items);
            super.fireContentsChanged(this, 0, this.items.size() - 1);
        } else if (anObject instanceof String) {
            this.addItem((String)anObject, (String)anObject);
        } else {
            throw new RuntimeException("Inserting item that is not a String or PickListItemIFace");
        }
        this.fireIntervalAdded(this, this.items.size() - 1, this.items.size() - 1);
        if (this.items.size() == 1 && this.selectedObject == null) {
            this.setSelectedItem(anObject);
        }
    }

    public void insertElementAt(Object obj, int index) {
        if (obj instanceof PickListItemIFace) {
            PickListItemIFace item = (PickListItemIFace)obj;
            this.items.insertElementAt((PickListItemIFace)obj, index);
            item.setPickList(this.pickList);
            if (this.pickList != null) {
                this.pickList.addItem(item);
                this.pickList.reorder();
            }
        } else if (obj instanceof String) {
            this.addItem((String)obj, (String)obj);
        } else {
            throw new RuntimeException("Inserting item that is not a String or PickListItemIFace");
        }
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElement(Object anObject) {
        int index = this.items.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
        if (this.pickList != null) {
            this.pickList.reorder();
        }
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            PickListItemIFace item = (PickListItemIFace)this.selectedObject;
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
            if (this.pickList != null) {
                this.pickList.removeItem(item);
            }
        }
        this.items.removeElementAt(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void add(Object item) {
    }

    @Override
    public boolean isMutable() {
        return !this.isReadOnly();
    }
}

