/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.db;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.ui.db.AskForNumbersDlg;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;

public class NumberEditorPanel
extends JPanel {
    protected ChangeListener changeListner;
    protected JTextArea mainTextArea;
    protected JTextArea editTextArea;
    protected JButton moveBtn;
    protected JButton clearBtn;
    protected boolean isOK = true;

    public NumberEditorPanel(JTextArea mainTextArea, ChangeListener changeListner, String titleKey) {
        this.mainTextArea = mainTextArea;
        this.changeListner = changeListner;
        this.createUI(titleKey);
    }

    private void createUI(String titleKey) {
        this.editTextArea = UIHelper.createTextArea(5, 40);
        this.moveBtn = UIHelper.createI18NButton("AFN_MOVE_UP");
        this.clearBtn = UIHelper.createI18NButton("AFN_CLEAR");
        this.editTextArea.setLineWrap(true);
        this.editTextArea.setWrapStyleWord(true);
        CellConstraints cc = new CellConstraints();
        PanelBuilder vpb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,p,f:p:g,p,f:p:g"));
        vpb.add((Component)this.moveBtn, cc.xy(1, 2));
        vpb.add((Component)this.clearBtn, cc.xy(1, 4));
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,4px,p", "p,2px,f:p:g"), (JPanel)this);
        pb.addSeparator(UIRegistry.getResourceString(titleKey), cc.xyw(1, 1, 3));
        pb.add((Component)UIHelper.createScrollPane(this.editTextArea), cc.xy(1, 3));
        pb.add((Component)vpb.getPanel(), cc.xy(3, 3));
        this.moveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberEditorPanel.this.moveNumbersUp();
            }
        });
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberEditorPanel.this.editTextArea.setText("");
                NumberEditorPanel.this.isOK = true;
                NumberEditorPanel.this.changeListner.stateChanged(null);
            }
        });
        this.editTextArea.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                NumberEditorPanel.this.updateBtnUI(true);
            }
        });
    }

    public boolean isOK() {
        return this.isOK;
    }

    public void setNumbers(List<String> numbers) {
        AskForNumbersDlg.buildNumberList(numbers, this.editTextArea);
        this.updateBtnUI(false);
        this.editTextArea.setEnabled(true);
        this.editTextArea.setEditable(true);
        this.isOK = numbers == null;
    }

    private void moveNumbersUp() {
        String txt = this.mainTextArea.getText().trim();
        StringBuilder sb = new StringBuilder(txt);
        if (!txt.endsWith(",")) {
            sb.append(", ");
        }
        sb.append(this.editTextArea.getText().trim());
        this.mainTextArea.setText(sb.toString());
        this.editTextArea.setText("");
        this.updateBtnUI(false);
        this.isOK = true;
        this.changeListner.stateChanged(null);
    }

    private void updateBtnUI(boolean enable) {
        this.moveBtn.setEnabled(enable);
        this.clearBtn.setEnabled(this.editTextArea.getText().length() > 0);
    }
}

