/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.db;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.ui.CatalogNumberFormatter;
import edu.ku.brc.specify.ui.db.NumberEditorPanel;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AskForNumbersDlg
extends CustomDialog
implements ChangeListener {
    private static final Logger log = Logger.getLogger(AskForNumbersDlg.class);
    private static final String AND_COLLID = " AND CollectionMemberID = COLLID";
    protected Class<? extends FormDataObjIFace> dataClass;
    protected Vector<String> numbersList = new Vector();
    protected Vector<Integer> dataObjsIds = new Vector();
    protected String labelKey;
    protected String fieldName;
    protected JTextArea textArea;
    protected NumberEditorPanel errorPanel;
    protected NumberEditorPanel missingPanel;
    protected ArrayList<String> numErrorList = new ArrayList();
    protected ArrayList<String> numMissingList = new ArrayList();
    protected PanelBuilder pb;

    public AskForNumbersDlg(String titleKey, String labelKey, Class<? extends FormDataObjIFace> dataClass, String fieldName) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString(titleKey), true, 7, null);
        this.labelKey = labelKey;
        this.dataClass = dataClass;
        this.fieldName = fieldName;
        this.helpContext = "AskForCatNumbers";
    }

    @Override
    public void createUI() {
        super.createUI();
        this.textArea = UIHelper.createTextArea(5, 30);
        this.errorPanel = new NumberEditorPanel(this.textArea, this, "AFN_NUMFMT_ERROR");
        this.missingPanel = new NumberEditorPanel(this.textArea, this, "AFN_NOTFND_ERROR");
        CellConstraints cc = new CellConstraints();
        this.pb = new PanelBuilder(new FormLayout("f:p:g", "p,2px,p,4px,f:p:g,4px,f:p:g"));
        this.pb.addSeparator(UIRegistry.getResourceString(this.labelKey), cc.xy(1, 1));
        this.pb.add((Component)UIHelper.createScrollPane(this.textArea), cc.xy(1, 3));
        this.contentPanel = this.pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.textArea.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                AskForNumbersDlg.this.checkStatus();
            }
        });
        this.getOkBtn().setEnabled(false);
        this.pack();
    }

    protected boolean processNumbers() {
        boolean isOK;
        block31: {
            this.dataObjsIds.clear();
            this.numbersList.clear();
            this.numErrorList.clear();
            this.numMissingList.clear();
            this.errorPanel.setNumbers(null);
            this.missingPanel.setNumbers(null);
            DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(this.dataClass.getName());
            DBFieldInfo fi = ti.getFieldByName(this.fieldName);
            boolean hasColMemID = ti.getFieldByColumnName("CollectionMemberID", true) != null;
            UIFieldFormatterIFace formatter = fi.getFormatter();
            char rangeSeparator = formatter != null ? (formatter.hasDash() ? (char)'/' : '-') : (char)' ';
            isOK = true;
            String fieldStr = this.textArea.getText().trim();
            if (formatter != null && formatter.isNumeric() && ti.getTableId() == 1 && this.fieldName.equals("catalogNumber")) {
                fieldStr = CatalogNumberFormatter.preParseNumericCatalogNumbers(fieldStr, formatter);
            }
            if (StringUtils.isNotEmpty((String)fieldStr)) {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        String[] toks;
                        session = DataProviderFactory.getInstance().createSession();
                        String[] stringArray = toks = StringUtils.split((String)fieldStr, (char)',');
                        int n = toks.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block28: {
                                String fldStr = stringArray[n2];
                                String numToken = fldStr.trim();
                                if (formatter != null && StringUtils.contains((String)numToken, (char)rangeSeparator)) {
                                    String fldNum = null;
                                    String endFldNum = null;
                                    String[] tokens = StringUtils.split((String)numToken, (char)rangeSeparator);
                                    if (tokens.length == 2) {
                                        try {
                                            if (!(!formatter.isNumeric() || StringUtils.isNumeric(fldNum) && StringUtils.isNumeric(endFldNum))) {
                                                this.numErrorList.add(fldStr.trim());
                                                isOK = false;
                                                break block28;
                                            }
                                            fldNum = (String)formatter.formatFromUI(tokens[0].trim());
                                            endFldNum = (String)formatter.formatFromUI(tokens[1].trim());
                                        }
                                        catch (NumberFormatException ex) {
                                            UsageTracker.incrHandledUsageCount();
                                            ExceptionTracker.getInstance().capture(AskForNumbersDlg.class, ex);
                                            this.numErrorList.add(numToken);
                                            isOK = false;
                                        }
                                        String sql = String.format("SELECT id FROM %s WHERE %s >= '%s' AND %s <= '%s' %s", ti.getClassName(), this.fieldName, fldNum, this.fieldName, endFldNum, hasColMemID ? AND_COLLID : "");
                                        sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
                                        List<?> list = session.getDataList(sql);
                                        for (Object obj : list) {
                                            this.dataObjsIds.add((Integer)obj);
                                        }
                                        this.numbersList.add(numToken);
                                    } else {
                                        this.numErrorList.add(numToken);
                                        isOK = false;
                                    }
                                } else {
                                    String fldValForDB;
                                    block29: {
                                        fldValForDB = numToken;
                                        try {
                                            if (formatter != null) {
                                                if (formatter.isNumeric() && !StringUtils.isNumeric((String)numToken)) {
                                                    this.numErrorList.add(numToken);
                                                    isOK = false;
                                                    break block28;
                                                }
                                                fldValForDB = (String)formatter.formatFromUI(numToken);
                                                break block29;
                                            }
                                            fldValForDB = numToken;
                                        }
                                        catch (NumberFormatException ex) {
                                            UsageTracker.incrHandledUsageCount();
                                            ExceptionTracker.getInstance().capture(AskForNumbersDlg.class, ex);
                                            this.numErrorList.add(numToken);
                                            isOK = false;
                                        }
                                    }
                                    if (StringUtils.isNotEmpty((String)fldValForDB)) {
                                        String sql = String.format("SELECT id FROM %s WHERE %s = '%s' %s", ti.getClassName(), this.fieldName, fldValForDB, hasColMemID ? AND_COLLID : "");
                                        sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
                                        Integer recordId = (Integer)session.getData(sql);
                                        if (recordId != null) {
                                            this.dataObjsIds.add(recordId);
                                            this.numbersList.add(numToken);
                                        } else {
                                            this.numMissingList.add(numToken);
                                            isOK = false;
                                        }
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(AskForNumbersDlg.class, ex);
                        log.error((Object)ex);
                        ex.printStackTrace();
                        if (session != null) {
                            session.close();
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
        }
        AskForNumbersDlg.buildNumberList(this.numbersList, this.textArea);
        this.pb.getPanel().removeAll();
        CellConstraints cc = new CellConstraints();
        this.pb.addSeparator(UIRegistry.getResourceString(this.labelKey), cc.xy(1, 1));
        this.pb.add((Component)UIHelper.createScrollPane(this.textArea), cc.xy(1, 3));
        int y = 5;
        if (this.numErrorList.size() > 0) {
            this.errorPanel.setNumbers(this.numErrorList);
            this.pb.add((Component)UIHelper.createScrollPane(this.errorPanel), cc.xy(1, y));
            y += 2;
        }
        if (this.numMissingList.size() > 0) {
            this.missingPanel.setNumbers(this.numMissingList);
            this.pb.add((Component)UIHelper.createScrollPane(this.missingPanel), cc.xy(1, y));
            y += 2;
        }
        if (!isOK) {
            this.pack();
        }
        return isOK;
    }

    protected static void buildNumberList(List<String> list, JTextArea ta) {
        StringBuilder sb = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (String num : list) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(num);
            }
        }
        ta.setText(sb.toString());
    }

    @Override
    protected void okButtonPressed() {
        if (this.processNumbers()) {
            super.okButtonPressed();
        }
        this.checkStatus();
    }

    public Vector<Integer> getNumbersList() {
        return this.dataObjsIds;
    }

    public RecordSetIFace getRecordSet() {
        if (this.dataObjsIds.size() > 0) {
            RecordSet rs = new RecordSet();
            rs.initialize();
            rs.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
            rs.setDbTableId(DBTableIdMgr.getInstance().getByClassName(this.dataClass.getName()).getTableId());
            for (Integer id : this.dataObjsIds) {
                rs.addItem(id);
            }
            return rs;
        }
        return null;
    }

    private void checkStatus() {
        this.getOkBtn().setEnabled(this.textArea.getText().length() > 0 && this.errorPanel.isOK() && this.missingPanel.isOK());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.checkStatus();
    }
}

