/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.containers;

import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.ui.containers.ContainerTreePanel;
import edu.ku.brc.specify.ui.containers.DefaultTreeTransferHandler;
import edu.ku.brc.ui.DataFlavorTableExt;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostMouseInputAdapter;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GhostActionableTree
extends JTree
implements GhostActionable,
TreeExpansionListener {
    private List<DataFlavor> dropFlavors = new ArrayList<DataFlavor>();
    private DefaultMutableTreeNode selectedNode = null;
    private Color clearColor = new Color(255, 255, 255, 255);
    private ContainerTreePanel treePanel;
    private HashSet<Object> expandedTreeObjects = new HashSet();
    private boolean supressExpansionEvent = false;
    private Insets autoscrollInsets = new Insets(20, 20, 20, 20);

    public GhostActionableTree(ContainerTreePanel treePanel) {
        this.treePanel = treePanel;
        this.init();
    }

    public GhostActionableTree(ContainerTreePanel treePanel, TreeModel newModel) {
        super(newModel);
        this.treePanel = treePanel;
        this.init();
    }

    private void init() {
        this.dropFlavors.add(new DataFlavorTableExt(GhostActionableTree.class, "Record_Set", CollectionObject.getClassTableId()));
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getPath() != null) {
                    GhostActionableTree.this.selectedNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                }
            }
        });
        this.addTreeExpansionListener(this);
        this.setBorder(BorderFactory.createLineBorder(this.clearColor, 2));
        this.setAutoscrolls(true);
        this.setShowsRootHandles(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setEditable(false);
        new DefaultTreeTransferHandler(this, 3);
    }

    @Override
    public void setModel(TreeModel newModel) {
        if (this.expandedTreeObjects != null) {
            this.expandedTreeObjects.clear();
        }
        super.setModel(newModel);
    }

    public void setClearColor(Color clearColor) {
        this.clearColor = clearColor;
    }

    @Override
    public void createMouseInputAdapter() {
    }

    @Override
    public void doAction(GhostActionable source) {
        Object dataObj = source.getData();
        if (dataObj instanceof RecordSetIFace) {
            RecordSetIFace rs = (RecordSetIFace)dataObj;
            this.treePanel.addRecordSet(rs);
        }
    }

    @Override
    public BufferedImage getBufferedImage() {
        return null;
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public Object getDataForClass(Class<?> classObj) {
        return null;
    }

    @Override
    public List<DataFlavor> getDragDataFlavors() {
        return null;
    }

    @Override
    public List<DataFlavor> getDropDataFlavors() {
        return this.dropFlavors;
    }

    @Override
    public GhostMouseInputAdapter getMouseInputAdapter() {
        return null;
    }

    @Override
    public void setActive(boolean isActive) {
        boolean isSelectedOK = this.selectedNode != null && this.selectedNode.getUserObject() instanceof Container;
        boolean isTreeOK = this.selectedNode == null && this.getRowCount() == 1;
        boolean isOK = isActive && (isTreeOK || isSelectedOK);
        this.setBorder(BorderFactory.createLineBorder(isOK ? RolloverCommand.getActiveColor() : this.clearColor, 2));
    }

    @Override
    public void setData(Object data) {
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public void cleanUp() {
        this.treePanel = null;
    }

    public void autoscroll(Point cursorLocation) {
        Insets insets = this.getAutoscrollInsets();
        Rectangle outer = this.getVisibleRect();
        Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
        if (!inner.contains(cursorLocation)) {
            Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.scrollRectToVisible(scrollRect);
        }
    }

    public Insets getAutoscrollInsets() {
        return this.autoscrollInsets;
    }

    public static DefaultMutableTreeNode makeDeepCopy(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode copy = new DefaultMutableTreeNode(node.getUserObject());
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            copy.add(GhostActionableTree.makeDeepCopy((DefaultMutableTreeNode)e.nextElement()));
        }
        return copy;
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        Object[] objsPath = path.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)objsPath[objsPath.length - 1];
        Object userObj = node.getUserObject();
        this.expandedTreeObjects.remove(userObj);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path;
        Object[] objsPath;
        if (!this.supressExpansionEvent && (objsPath = (path = e.getPath()).getPath()).length > 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)objsPath[objsPath.length - 1];
            Object userObject = node.getUserObject();
            this.expandedTreeObjects.add(userObject);
        }
    }

    public void restoreTree() {
        this.restoreTreeNode(this, new TreePath(this.getModel().getRoot()), null);
    }

    private void restoreTreeNode(JTree tree, TreePath parent, DefaultMutableTreeNode treeNode) {
        Object myUserObject;
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> en = node.children();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode dmTreeNode = (DefaultMutableTreeNode)en.nextElement();
                TreePath path = parent.pathByAddingChild(dmTreeNode);
                this.restoreTreeNode(tree, path, dmTreeNode);
            }
        }
        if (treeNode != null && this.expandedTreeObjects.contains(myUserObject = treeNode.getUserObject())) {
            tree.expandPath(parent);
        }
    }
}

