/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.containers;

import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.ui.containers.AbstractTreeTransferHandler;
import edu.ku.brc.specify.ui.containers.GhostActionableTree;
import java.awt.Point;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeTransferHandler
extends AbstractTreeTransferHandler {
    public DefaultTreeTransferHandler(GhostActionableTree tree, int action) {
        super(tree, action, true);
    }

    public boolean canPerformActionX(GhostActionableTree target, DefaultMutableTreeNode draggedNode, int action, Point location) {
        TreePath pathTarget = target.getPathForLocation(location.x, location.y);
        if (pathTarget == null) {
            target.setSelectionPath(null);
            return false;
        }
        target.setSelectionPath(pathTarget);
        if (action == 1) {
            return false;
        }
        if (action == 2) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
            return !draggedNode.isRoot() && parentNode != draggedNode.getParent() && !draggedNode.isNodeDescendant(parentNode);
        }
        return false;
    }

    @Override
    public boolean canPerformAction(GhostActionableTree target, DefaultMutableTreeNode draggedNode, int action, Point location) {
        TreePath pathTarget = target.getPathForLocation(location.x, location.y);
        if (pathTarget == null) {
            target.setSelectionPath(null);
            return false;
        }
        DefaultMutableTreeNode hoverNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
        if (hoverNode.isLeaf() && hoverNode.getUserObject() instanceof CollectionObject) {
            target.setSelectionPath(null);
            return false;
        }
        if (action == 1) {
            target.setSelectionPath(null);
            return false;
        }
        if (action == 2) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
            if (draggedNode.isRoot() || parentNode == draggedNode.getParent() || draggedNode.isNodeDescendant(parentNode)) {
                target.setSelectionPath(null);
                return false;
            }
            target.setSelectionPath(pathTarget);
            return true;
        }
        target.setSelectionPath(null);
        return false;
    }

    @Override
    public boolean executeDrop(GhostActionableTree target, DefaultMutableTreeNode draggedNode, DefaultMutableTreeNode newParentNode, int action) {
        if (action == 1) {
            DefaultMutableTreeNode newNode = GhostActionableTree.makeDeepCopy(draggedNode);
            ((DefaultTreeModel)target.getModel()).insertNodeInto(newNode, newParentNode, newParentNode.getChildCount());
            TreePath treePath = new TreePath(newNode.getPath());
            target.scrollPathToVisible(treePath);
            target.setSelectionPath(treePath);
            return true;
        }
        if (action == 2) {
            draggedNode.removeFromParent();
            ((DefaultTreeModel)target.getModel()).insertNodeInto(draggedNode, newParentNode, newParentNode.getChildCount());
            TreePath treePath = new TreePath(draggedNode.getPath());
            target.scrollPathToVisible(treePath);
            target.setSelectionPath(treePath);
            return true;
        }
        return false;
    }
}

