/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.containers;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.ui.containers.ContainerTreePanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.lang.StringUtils;

public class ContainerTreeRenderer
extends DefaultTreeCellRenderer {
    protected Color bgColor = Color.WHITE;
    protected HashMap<Class<?>, ImageIcon> iconHash = new HashMap();
    protected HashMap<Class<?>, ImageIcon> iconFadedHash = new HashMap();
    protected HashMap<Short, ImageIcon> typeIconHash = new HashMap();
    protected UIFieldFormatterIFace catNumFmt;
    protected Object userObj = null;
    protected Component layoutComp;
    protected ImageIcon img1 = null;
    protected ImageIcon img2 = null;
    protected String txt1 = null;
    protected String txt2 = null;
    protected boolean isEditable = false;
    protected boolean isViewMode = false;
    protected boolean isSelected = false;
    protected boolean isContainer = false;
    protected boolean isColObj = false;
    protected boolean hasColObj = false;
    protected int iconSep = 8;
    protected Point transPoint = null;
    protected Rectangle[] hitRects = new Rectangle[3];
    protected ImageIcon addImgIcon = IconManager.getIcon("AddRecord", IconManager.IconSize.Std16);
    protected ImageIcon delImgIcon = IconManager.getIcon("DelRecord", IconManager.IconSize.Std16);
    protected ImageIcon schImgIcon = IconManager.getIcon("Search", IconManager.IconSize.Std16);
    protected ImageIcon edtImgIcon = IconManager.getIcon("EditIcon", IconManager.IconSize.NonStd);
    protected ImageIcon viewImgIcon = IconManager.getIcon("ViewForm", IconManager.IconSize.Std16);
    protected RenderingHints renderingHints = UIHelper.createTextRenderingHints();

    public ContainerTreeRenderer(Component layoutComp, boolean isEditable, boolean isViewMode) {
        Class[] cls;
        this.isEditable = isEditable;
        this.isViewMode = isViewMode;
        Class[] classArray = cls = new Class[]{Container.class, CollectionObject.class};
        int n = cls.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            this.iconHash.put(c, IconManager.getIcon(c.getSimpleName(), IconManager.IconSize.Std24));
            this.iconFadedHash.put(c, IconManager.getIcon(c.getSimpleName(), IconManager.IconSize.Std24Fade));
            ++n2;
        }
        this.setIcon(this.iconHash.get(cls[0]));
        String[] fNames = new String[]{"Container", "Folder", "Sheet", "PlantSpecimen"};
        int i = 0;
        while (i < fNames.length) {
            this.typeIconHash.put((short)i, IconManager.getIcon(fNames[i], IconManager.IconSize.Std24));
            i = (short)(i + 1);
        }
        this.catNumFmt = DBTableIdMgr.getFieldFormatterFor(CollectionObject.class, "CatalogNumber");
        this.layoutComp = layoutComp;
        i = 0;
        while (i < this.hitRects.length) {
            this.hitRects[i] = new Rectangle();
            ++i;
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.isSelected = sel;
        this.img1 = null;
        this.img2 = null;
        this.txt1 = null;
        this.txt2 = null;
        this.setIcon(null);
        this.setText(null);
        if (value instanceof DefaultMutableTreeNode) {
            this.isColObj = false;
            this.isContainer = false;
            this.hasColObj = false;
            this.userObj = ((DefaultMutableTreeNode)value).getUserObject();
            if (this.userObj instanceof Container) {
                this.isContainer = true;
                boolean bl = this.hasColObj = ((Container)this.userObj).getCollectionObject() != null;
            }
            if (this.userObj instanceof String) {
                this.txt1 = this.userObj.toString();
            } else if (this.userObj instanceof ContainerTreePanel.ParentNodeInfo) {
                ContainerTreePanel.ParentNodeInfo pni = (ContainerTreePanel.ParentNodeInfo)this.userObj;
                this.txt1 = pni.getTitle();
                if (pni.type != null) {
                    this.img1 = this.typeIconHash.get(pni.type.shortValue());
                }
            } else {
                Class<?> cls = this.userObj.getClass();
                this.img1 = this.iconHash.get(cls);
                if (cls == Container.class) {
                    CollectionObject colObj;
                    Container c = (Container)this.userObj;
                    this.txt1 = c.getName();
                    if (c.getType() != null && c.getType() > 0) {
                        this.img1 = this.typeIconHash.get(c.getType());
                    }
                    if ((colObj = c.getCollectionObject()) != null) {
                        String catNum = StringUtils.isNotEmpty((String)colObj.getCatalogNumber()) ? (String)this.catNumFmt.formatToUI(colObj.getCatalogNumber()) : null;
                        this.txt2 = catNum != null ? catNum : " ";
                        this.img2 = IconManager.getIcon("CollectionObject", IconManager.IconSize.Std16);
                    } else {
                        this.txt2 = " (Not Cataloged) ";
                    }
                } else if (this.userObj instanceof CollectionObject) {
                    this.isColObj = true;
                    CollectionObject colObj = (CollectionObject)this.userObj;
                    String catNum = StringUtils.isNotEmpty((String)colObj.getCatalogNumber()) ? (String)this.catNumFmt.formatToUI(colObj.getCatalogNumber()) : null;
                    this.txt1 = catNum != null ? catNum : " ";
                    this.img1 = this.iconHash.get(CollectionObject.class);
                } else {
                    this.txt1 = this.userObj.toString();
                }
            }
            Dimension prefDim = this.getPreferredSize();
            this.setSize(prefDim);
        }
        return this;
    }

    @Override
    public Dimension getSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        dim.height = IconManager.IconSize.Std24.size() + 2;
        int width = 10;
        if (this.img1 != null) {
            width += this.img1.getIconWidth();
        }
        if (this.txt1 != null) {
            width += this.getIconTextGap();
            width += fm.stringWidth(this.txt1);
        }
        if (this.img2 != null) {
            width += this.iconSep;
            width += this.img2.getIconWidth() + 1;
        }
        if (this.txt2 != null) {
            width += this.getIconTextGap();
            width += fm.stringWidth(this.txt2);
        }
        dim.width = width;
        int numIcons = 0;
        if (this.isColObj) {
            numIcons = 1;
        } else if (this.isViewMode) {
            numIcons = 2;
        } else if (this.isEditable) {
            numIcons = 2;
        }
        dim.width += IconManager.IconSize.Std16.size() * numIcons + this.iconSep * numIcons;
        return dim;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHints(this.renderingHints);
        FontMetrics fm = g2d.getFontMetrics();
        int imgY = this.img1 != null ? (d.height - 24) / 2 : 0;
        int imgY2 = this.img1 != null ? (d.height - 16) / 2 : 0;
        int txtY = (d.height - fm.getHeight()) / 2 + fm.getAscent();
        int x = 0;
        Color color = g2d.getColor();
        if (this.img1 != null) {
            g2d.drawImage(this.img1.getImage(), x, imgY, null);
            x += this.img1.getIconWidth();
        }
        int iconInx = 0;
        if (this.txt1 != null) {
            g2d.setColor(this.getForeground());
            g.drawString(this.txt1, x += this.getIconTextGap(), txtY);
            x += fm.stringWidth(this.txt1);
            g2d.setColor(color);
        }
        if (this.isContainer) {
            if (this.hasColObj) {
                if (this.img2 != null) {
                    ++x;
                    g2d.drawImage(this.img2.getImage(), x += this.iconSep, imgY2, null);
                    x += this.img2.getIconWidth();
                }
                if (this.txt2 != null) {
                    g2d.setColor(this.getForeground());
                    g.drawString(this.txt2, x += this.getIconTextGap(), txtY);
                    x += fm.stringWidth(this.txt2);
                    g2d.setColor(color);
                }
                if (this.isSelected) {
                    x += this.iconSep;
                    x += this.drawIcon(g2d, x, imgY2, this.viewImgIcon, iconInx++);
                    if (this.isEditable) {
                        x += this.drawIcon(g2d, x, imgY2, this.delImgIcon, iconInx++);
                    }
                }
            } else if (this.isSelected) {
                x += this.iconSep;
                x += this.drawIcon(g2d, x, imgY2, this.schImgIcon, iconInx++);
                x += this.drawIcon(g2d, x, imgY2, this.addImgIcon, iconInx++);
            }
        } else if (this.isSelected) {
            x += this.iconSep;
            x += this.drawIcon(g2d, x, imgY2, this.viewImgIcon, iconInx++);
        }
        g2d.dispose();
    }

    private int drawIcon(Graphics2D g2d, int xc, int yc, ImageIcon imgIcon, int hitsInx) {
        g2d.drawImage(imgIcon.getImage(), xc, yc, null);
        this.hitRects[hitsInx].setBounds(xc, yc, imgIcon.getIconWidth(), imgIcon.getIconHeight());
        Point p = this.hitRects[hitsInx].getLocation();
        SwingUtilities.convertPointToScreen(p, this);
        this.hitRects[hitsInx].setLocation(p);
        return imgIcon.getIconWidth() + this.iconSep;
    }

    public void setBGColor(Color bkgdColor) {
        this.bgColor = bkgdColor;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public Rectangle[] getHitRects() {
        Rectangle[] rects = new Rectangle[this.hitRects.length];
        int i = 0;
        while (i < rects.length) {
            rects[i] = new Rectangle(this.hitRects[i]);
            ++i;
        }
        return rects;
    }
}

