/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.ui.containers;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.db.ViewBasedDisplayPanel;
import edu.ku.brc.af.ui.db.ViewBasedSearchDialogIFace;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.ui.containers.ContainerTreeRenderer;
import edu.ku.brc.specify.ui.containers.GhostActionableTree;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.EditDeleteAddVertPanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;

public class ContainerTreePanel
extends JPanel
implements CommandListener {
    private static final String GETSQL = "SELECT pcn.ContainerID FROM container cn LEFT JOIN container pcn ON cn.ParentID = pcn.ContainerID WHERE cn.ContainerID = ?";
    protected static final Color bgColor = Color.WHITE;
    protected static final int ROW_HEIGHT = 26;
    protected static final Color bannerColor = new Color(30, 144, 255);
    protected Component header = null;
    protected Container rootContainer;
    protected CollectionObject rootColObj;
    protected Container currContainer;
    protected CollectionObject currColObj;
    protected HashSet<Integer> colObjIdHash = new HashSet();
    protected HashSet<Integer> containerIdHash = new HashSet();
    protected GhostActionableTree tree;
    protected DefaultTreeModel model;
    protected JScrollPane scrollPane;
    protected ViewBasedDisplayPanel containerPanel;
    protected boolean isViewMode = false;
    protected EditDeleteAddVertPanel edaColObjPanel;
    protected EditDeleteAddVertPanel edaContnrPanel;
    protected JButton searchCOBtn;
    protected JButton searchCNBtn;
    protected JLabel colObjIcon;
    protected JLabel containerIcon;
    protected JLabel colObjAssocIcon;
    protected JLabel containerAssocIcon;
    protected ContainerTreeRenderer treeRenderer = null;
    protected FormViewObj formViewObj = null;
    protected ChangeListener changeListener = null;

    public ContainerTreePanel(ChangeListener changeListener, boolean isViewModeArg, Container rootCon, CollectionObject rootCO) {
        this.changeListener = changeListener;
        this.isViewMode = isViewModeArg;
        this.rootContainer = rootCon;
        this.rootColObj = rootCO;
        CommandDispatcher.register("DATA_ENTRY", this);
        this.createUI();
    }

    private void createUI() {
        Component comp;
        CellConstraints cc = new CellConstraints();
        this.edaColObjPanel = new EditDeleteAddVertPanel(this.getEditColObjAL(), this.getDelColObjAL(), this.getAddColObjAL());
        this.edaContnrPanel = new EditDeleteAddVertPanel(this.getEditContainerAL(), this.getDelContainerAL(), this.getAddContainerAL());
        this.set(this.rootContainer, this.rootColObj);
        this.scrollPane = UIHelper.createScrollPane(this.tree, true);
        this.treeRenderer = new ContainerTreeRenderer(null, !this.isViewMode, this.isViewMode);
        this.treeRenderer.setEditable(true);
        this.treeRenderer.setLeafIcon(IconManager.getIcon(CollectionObject.class.getSimpleName(), IconManager.IconSize.Std32));
        this.treeRenderer.setVerticalTextPosition(0);
        this.tree.setCellRenderer(this.treeRenderer);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContainerTreePanel.this.mousePressedOnTree(e);
                    }
                });
            }
        });
        this.colObjAssocIcon = new JLabel(IconManager.getIcon(CollectionObject.class.getSimpleName(), IconManager.IconSize.Std20));
        this.containerAssocIcon = new JLabel(IconManager.getIcon(Container.class.getSimpleName(), IconManager.IconSize.Std20));
        this.colObjIcon = new JLabel(IconManager.getIcon(CollectionObject.class.getSimpleName(), IconManager.IconSize.Std20));
        this.containerIcon = new JLabel(IconManager.getIcon(Container.class.getSimpleName(), IconManager.IconSize.Std20));
        this.searchCOBtn = UIHelper.createIconBtn("Search", IconManager.IconSize.Std20, "", true, null);
        this.searchCNBtn = UIHelper.createIconBtn("Search", IconManager.IconSize.Std20, "", true, null);
        this.colObjIcon.setEnabled(false);
        this.containerIcon.setEnabled(false);
        this.containerPanel = new ViewBasedDisplayPanel(null, "ContainerBrief", Container.class.getName(), true, 0);
        PanelBuilder rpb = null;
        if (!this.isViewMode) {
            rpb = new PanelBuilder(new FormLayout("f:p:g", "p,2px,p,2px,p,10px,p, 20px,p,2px,p,10px,p,f:p:g"));
            PanelBuilder cnCOLblPB = new PanelBuilder(new FormLayout("p,1px,p", "p"));
            cnCOLblPB.add((Component)this.containerAssocIcon, cc.xy(1, 1));
            cnCOLblPB.add((Component)this.colObjAssocIcon, cc.xy(3, 1));
            this.containerAssocIcon.setEnabled(false);
            this.colObjAssocIcon.setEnabled(false);
            int y = 1;
            rpb.add((Component)this.containerIcon, cc.xy(1, y));
            rpb.add((Component)this.edaContnrPanel, cc.xy(1, y += 2));
            rpb.add((Component)this.searchCNBtn, cc.xy(1, y += 2));
            rpb.addSeparator("", cc.xy(1, y += 2));
            rpb.add((Component)this.colObjIcon, cc.xy(1, y += 2));
            rpb.add((Component)this.edaColObjPanel, cc.xy(1, y += 2));
            rpb.add((Component)this.searchCOBtn, cc.xy(1, y += 2));
            y += 2;
        }
        PanelBuilder pb = new PanelBuilder(new FormLayout("l:p,8px,f:p:g", "f:p:g,10px,p,2px,p"), (JPanel)this);
        if (rpb != null) {
            pb.add((Component)rpb.getPanel(), cc.xy(1, 1));
        }
        pb.add((Component)this.scrollPane, cc.xy(3, 1));
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ContainerTreePanel.this.updateBtnUI();
                ContainerTreePanel.this.currContainer = null;
                ContainerTreePanel.this.currColObj = null;
                DefaultMutableTreeNode node = ContainerTreePanel.this.getSelectedTreeNode();
                if (node != null) {
                    if (node.getUserObject() instanceof Container) {
                        ContainerTreePanel.this.currContainer = (Container)node.getUserObject();
                        if (ContainerTreePanel.this.containerPanel != null) {
                            ContainerTreePanel.this.containerPanel.getMultiView().setData(ContainerTreePanel.this.currContainer);
                        }
                    } else if (node.getUserObject() instanceof CollectionObject) {
                        ContainerTreePanel.this.currColObj = (CollectionObject)node.getUserObject();
                    }
                }
            }
        });
        GhostGlassPane glassPane = (GhostGlassPane)UIRegistry.get("glasspane");
        glassPane.add(this.tree);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.searchCOBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContainerTreePanel.this.addColObjToContainer(true, false);
            }
        });
        this.searchCNBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContainerTreePanel.this.addContainer(true);
            }
        });
        FormViewObj fvo = this.containerPanel.getMultiView().getCurrentViewAsFormViewObj();
        if (fvo != null && (comp = (Component)fvo.getCompById("nm")) instanceof ValTextField) {
            final ValTextField nameTF = (ValTextField)fvo.getCompById("nm");
            nameTF.getDocument().addDocumentListener(new DocumentAdaptor(){

                @Override
                protected void changed(DocumentEvent e) {
                    ContainerTreePanel.this.nameFieldChanged(nameTF.getText());
                    if (ContainerTreePanel.this.changeListener != null) {
                        ContainerTreePanel.this.changeListener.stateChanged(null);
                    }
                }
            });
            final ValComboBox typeCBX = (ValComboBox)fvo.getCompById("typ");
            typeCBX.getComboBox().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickListItemIFace pli = (PickListItemIFace)typeCBX.getComboBox().getSelectedItem();
                    ContainerTreePanel.this.typeChanged(pli == null ? -1 : Integer.parseInt(pli.getValue()));
                    if (ContainerTreePanel.this.changeListener != null) {
                        ContainerTreePanel.this.changeListener.stateChanged(null);
                    }
                }
            });
        }
    }

    private boolean checkForChanges() {
        boolean isOK = this.containerPanel.getMultiView().getCurrentViewAsFormViewObj().isDataCompleteAndValid(true);
        return isOK;
    }

    private void mousePressedOnTree(MouseEvent e) {
        Point pnt = e.getLocationOnScreen();
        int i = 0;
        Rectangle[] rectangleArray = this.treeRenderer.getHitRects();
        int n = rectangleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle r = rectangleArray[n2];
            if (r.contains(pnt)) {
                DefaultMutableTreeNode node = this.getSelectedTreeNode();
                if (node == null) break;
                if (node.getUserObject() instanceof Container) {
                    Container cn = (Container)node.getUserObject();
                    if (cn == null) break;
                    if (!this.isViewMode) {
                        if (cn.getCollectionObject() != null) {
                            if (i == 0) {
                                this.editColObj(cn.getCollectionObject());
                                break;
                            }
                            this.delColObj();
                            break;
                        }
                        if (i == 0) {
                            this.addColObjToContainer(true, true);
                            break;
                        }
                        this.addColObjToContainer(false, true);
                        break;
                    }
                    if (cn.getCollectionObject() == null || i != 0) break;
                    this.viewColObj();
                    break;
                }
                if (!(node.getUserObject() instanceof CollectionObject)) break;
                if (this.isViewMode) {
                    if (i != 0) break;
                    this.viewColObj();
                    break;
                }
                if (i != 0) break;
                this.editColObj();
                break;
            }
            ++i;
            ++n2;
        }
    }

    public void cleanUp() {
        GhostGlassPane glassPane = (GhostGlassPane)UIRegistry.get("glasspane");
        glassPane.remove(this.tree);
        this.tree.cleanUp();
    }

    public void nameFieldChanged(String text) {
        if (this.currContainer != null) {
            this.currContainer.setName(text);
        }
        this.model.nodeChanged((TreeNode)this.model.getRoot());
    }

    public void typeChanged(int type) {
        if (this.currContainer != null) {
            this.currContainer.setType((short)type);
        }
        this.model.nodeChanged((TreeNode)this.model.getRoot());
    }

    private Integer getTopMostParentId(Integer containerId) {
        if (containerId != null) {
            PreparedStatement pStmt = null;
            try {
                pStmt = DBConnection.getInstance().getConnection().prepareStatement(GETSQL);
                Integer pContainerId = containerId;
                do {
                    pStmt.setInt(1, pContainerId);
                    pContainerId = null;
                    ResultSet rs = pStmt.executeQuery();
                    if (rs.next()) {
                        pContainerId = (Integer)rs.getObject(1);
                    }
                    rs.close();
                } while (pContainerId != null);
                Integer n = pContainerId;
                return n;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void set(Container rootCon, CollectionObject rootCO) {
        Integer rootParentId;
        this.rootContainer = rootCon;
        this.rootColObj = rootCO;
        this.colObjIdHash.clear();
        this.containerIdHash.clear();
        if (rootCon != null && (rootParentId = this.getTopMostParentId(rootCon.getId())) != null) {
            this.rootContainer = this.getContainerFromDB(rootParentId);
            this.rootColObj = this.rootContainer.getCollectionObject();
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        rootNode.setUserObject(this.rootContainer != null ? this.rootContainer : this.rootColObj);
        if (this.rootContainer != null) {
            this.loadContainerTree(rootNode, this.rootContainer, null);
        } else if (this.rootColObj != null) {
            this.loadContainerTree(rootNode, null, this.rootColObj);
        } else {
            rootNode.setUserObject("New Container");
        }
        this.model = new DefaultTreeModel(rootNode);
        if (this.tree == null) {
            this.tree = new GhostActionableTree(this, this.model);
            this.tree.setRowHeight(26);
            this.tree.setBackground(bgColor);
            this.tree.setEditable(false);
            this.tree.setVisibleRowCount(15);
            this.registerPrintContextMenu(this.tree);
        } else {
            this.tree.setModel(this.model);
        }
        this.model.reload();
        if (this.containerPanel != null) {
            this.containerPanel.getMultiView().setData(rootCon);
        }
    }

    private void loadContainerTree(DefaultMutableTreeNode parentNode, Container container, CollectionObject colObj) {
        if (container != null) {
            container.forceLoad();
            int cnt = parentNode.getChildCount();
            Vector<CollectionObject> coKids = new Vector<CollectionObject>(container.getCollectionObjectKids());
            Collections.sort(coKids);
            for (CollectionObject co : coKids) {
                cnt = parentNode.getChildCount();
                DefaultMutableTreeNode node = new DefaultMutableTreeNode();
                node.setUserObject(co);
                this.colObjIdHash.add(co.getId());
                this.model.insertNodeInto(node, parentNode, cnt);
                this.loadContainerTree(node, null, co);
            }
            Vector<Container> cnKids = new Vector<Container>(container.getChildrenList());
            Collections.sort(cnKids);
            for (Container cn : cnKids) {
                cnt = parentNode.getChildCount();
                DefaultMutableTreeNode node = new DefaultMutableTreeNode();
                node.setUserObject(cn);
                this.containerIdHash.add(cn.getId());
                this.model.insertNodeInto(node, parentNode, cnt);
                this.loadContainerTree(node, cn, null);
            }
        } else if (colObj != null && colObj.getContainer() != null) {
            this.loadContainerTree(parentNode, colObj.getContainer(), null);
        }
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        DefaultMutableTreeNode node;
        TreePath path;
        boolean isNodeSelected;
        boolean bl = isNodeSelected = this.tree.getSelectionCount() > -1;
        if (isNodeSelected && (path = this.tree.getSelectionModel().getSelectionPath()) != null && (node = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1)) != null) {
            return node;
        }
        return null;
    }

    public void addRecordSet(RecordSetIFace rs) {
        if (!this.checkForChanges()) {
            return;
        }
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            ArrayList<Integer> inUseIds = new ArrayList<Integer>();
            ArrayList<CollectionObject> alreadyHasContainer = new ArrayList<CollectionObject>();
            ArrayList<CollectionObject> alreadyContained = new ArrayList<CollectionObject>();
            DefaultMutableTreeNode parentNode = this.getSelectedTreeNode();
            if (parentNode == null) {
                if (this.tree.getRowCount() == 1) {
                    parentNode = (DefaultMutableTreeNode)this.model.getRoot();
                } else {
                    return;
                }
            }
            try {
                for (RecordSetItemIFace rsi : rs.getItems()) {
                    Integer coId = rsi.getRecordId();
                    if (!this.colObjIdHash.contains(coId)) {
                        CollectionObject dbCO;
                        if (coId == null || (dbCO = session.get(CollectionObject.class, coId)) == null) continue;
                        if (dbCO.getContainer() == null) {
                            if (dbCO.getContainerOwner() == null) {
                                this.addColObjAsChild(parentNode, dbCO);
                                continue;
                            }
                            alreadyContained.add(dbCO);
                            continue;
                        }
                        alreadyHasContainer.add(dbCO);
                        continue;
                    }
                    inUseIds.add(coId);
                }
                if (inUseIds.size() > 0 || alreadyHasContainer.size() > 0 || alreadyContained.size() > 0) {
                    UIRegistry.showError("These COs were not added.");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ContainerTreePanel.class, ex);
            }
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void updateBtnUI() {
        this.containerAssocIcon.setEnabled(false);
        this.colObjAssocIcon.setEnabled(false);
        this.colObjIcon.setEnabled(false);
        this.containerIcon.setEnabled(false);
        if (this.tree != null) {
            boolean isNodeSelected;
            boolean bl = isNodeSelected = this.tree.getSelectionCount() > 0;
            if (isNodeSelected) {
                Object dataObj;
                DefaultMutableTreeNode node;
                TreePath path = this.tree.getSelectionModel().getSelectionPath();
                if (path != null && path.getPathCount() > 0 && (node = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1)) != null && (dataObj = node.getUserObject()) != null) {
                    boolean isContainer = dataObj instanceof Container;
                    if (isContainer) {
                        int[] selInxs = this.tree.getSelectionRows();
                        Container cntr = (Container)dataObj;
                        this.edaContnrPanel.getEditBtn().setEnabled(selInxs[0] > 0);
                        if (!this.isViewMode) {
                            this.edaContnrPanel.getAddBtn().setEnabled(true);
                            this.edaContnrPanel.getDelBtn().setEnabled(selInxs[0] > 0);
                        } else {
                            this.edaContnrPanel.getEditBtn().setEnabled(selInxs[0] > -1);
                        }
                        if (!this.isViewMode) {
                            this.colObjAssocIcon.setEnabled(true);
                            this.containerAssocIcon.setEnabled(true);
                        } else {
                            this.containerAssocIcon.setEnabled(cntr.getCollectionObject() != null);
                            this.colObjAssocIcon.setEnabled(cntr.getCollectionObject() != null);
                        }
                        this.colObjIcon.setEnabled(!this.isViewMode);
                        this.containerIcon.setEnabled(true);
                        if (!this.isViewMode) {
                            this.edaColObjPanel.getAddBtn().setEnabled(true);
                            this.edaColObjPanel.getDelBtn().setEnabled(false);
                        }
                        this.edaColObjPanel.getEditBtn().setEnabled(false);
                        this.searchCOBtn.setEnabled(true);
                        this.searchCNBtn.setEnabled(true);
                    } else {
                        this.edaContnrPanel.setEnabled(false);
                        this.containerIcon.setEnabled(false);
                        this.colObjIcon.setEnabled(true);
                        this.edaColObjPanel.getEditBtn().setEnabled(true);
                        if (!this.isViewMode) {
                            this.edaColObjPanel.getDelBtn().setEnabled(true);
                            this.edaColObjPanel.getAddBtn().setEnabled(false);
                            this.searchCOBtn.setEnabled(false);
                            this.searchCNBtn.setEnabled(false);
                        }
                        this.containerAssocIcon.setEnabled(false);
                        this.colObjAssocIcon.setEnabled(false);
                    }
                }
            } else {
                this.edaColObjPanel.setEnabled(false);
                this.edaContnrPanel.setEnabled(false);
                this.colObjIcon.setEnabled(false);
                this.containerIcon.setEnabled(false);
                this.searchCOBtn.setEnabled(false);
                this.searchCNBtn.setEnabled(false);
                this.containerAssocIcon.setEnabled(false);
                this.colObjAssocIcon.setEnabled(false);
            }
        }
    }

    private void editColObj() {
        CollectionObject co;
        DefaultMutableTreeNode node;
        if (this.checkForChanges() && (node = this.getSelectedTreeNode()) != null && node.getUserObject() instanceof CollectionObject && (co = this.editColObj((CollectionObject)node.getUserObject())) != null) {
            node.setUserObject(co);
        }
    }

    private void delColObj() {
        DefaultMutableTreeNode node;
        if (this.checkForChanges() && (node = this.getSelectedTreeNode()) != null) {
            if (node.getUserObject() instanceof Container) {
                Container cn = (Container)node.getUserObject();
                CollectionObject co = cn.getCollectionObject();
                if (cn != null) {
                    cn.getCollectionObjects().clear();
                    co.setContainer(null);
                    this.model.nodeChanged(node);
                }
            } else {
                CollectionObject co = (CollectionObject)node.getUserObject();
                this.colObjIdHash.remove(co.getId());
                this.model.removeNodeFromParent(node);
            }
        }
    }

    private Container getContainerFromDB(Integer containerId) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            Container container = session.get(Container.class, containerId);
            container.forceLoad();
            Container container2 = container;
            return container2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ContainerTreePanel.class, ex);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private FormDataObjIFace forceLoad(FormDataObjIFace fdo) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            FormDataObjIFace mergedObj = session.merge(fdo);
            mergedObj.forceLoad();
            FormDataObjIFace formDataObjIFace = mergedObj;
            return formDataObjIFace;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ContainerTreePanel.class, ex);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private void saveColObj(MultiView mv, CollectionObject colObj) {
        mv.getDataFromUI();
        FormViewObj fvo = mv.getCurrentViewAsFormViewObj();
        if (fvo != null) {
            fvo.saveObject();
        }
    }

    private CollectionObject editColObj(CollectionObject colObj) {
        ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), null, "CollectionObject", null, "CollectionObject", "Save", null, null, true, 792){

            @Override
            protected void okButtonPressed() {
                MultiView mvParent = this.getMultiView();
                ContainerTreePanel.this.saveColObj(mvParent, (CollectionObject)mvParent.getCurrentViewAsFormViewObj().getDataObj());
                super.okButtonPressed();
            }
        };
        Object dataObj = null;
        dlg.setWhichBtns(3);
        if (colObj == null) {
            dlg.getMultiView().getCurrentViewAsFormViewObj().createNewObjectByAdding();
            dataObj = dlg.getMultiView().getCurrentViewAsFormViewObj().getCurrentDataObj();
        } else {
            dataObj = colObj;
        }
        dlg.getMultiView().getCurrentViewAsFormViewObj().setDataObj(dataObj);
        UIHelper.centerAndShow(dlg);
        if (dlg.getBtnPressed() == 1) {
            return (CollectionObject)dlg.getMultiView().getCurrentViewAsFormViewObj().getDataObj();
        }
        return null;
    }

    private Container createContainer(Container parentContainer) {
        return this.createOrEditContainer(null, parentContainer);
    }

    private Container createOrEditContainer(Container container, final Container parentContainer) {
        ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), null, "ContainerBrief", null, "Container", "Save", null, null, true, 792){

            @Override
            protected void okButtonPressed() {
                MultiView mvParent = this.getMultiView();
                mvParent.getDataFromUI();
                FormViewObj fvo = mvParent.getCurrentViewAsFormViewObj();
                if (fvo != null) {
                    if (parentContainer != null) {
                        Container newContainer = (Container)fvo.getDataObj();
                        newContainer.setParent(parentContainer);
                        parentContainer.getChildren().add(newContainer);
                    }
                    fvo.saveObject();
                }
                super.okButtonPressed();
            }
        };
        dlg.setWhichBtns(3);
        if (container == null) {
            dlg.getMultiView().getCurrentViewAsFormViewObj().createNewObjectByAdding();
            Object dataObj = dlg.getMultiView().getCurrentViewAsFormViewObj().getCurrentDataObj();
            dlg.getMultiView().getCurrentViewAsFormViewObj().setDataObj(dataObj);
        } else {
            dlg.getMultiView().setData(container);
        }
        UIHelper.centerAndShow(dlg);
        if (dlg.getBtnPressed() == 1) {
            return (Container)dlg.getMultiView().getCurrentViewAsFormViewObj().getDataObj();
        }
        return null;
    }

    private Object searchForDataObj(Class<?> cls) {
        try {
            String title = String.valueOf(cls.getSimpleName()) + "Search";
            ViewBasedSearchDialogIFace srchDlg = UIRegistry.getViewbasedFactory().createSearchDialog(null, title);
            if (srchDlg != null) {
                UIHelper.centerAndShow(srchDlg.getDialog());
                if (!srchDlg.isCancelled()) {
                    return this.forceLoad((FormDataObjIFace)srchDlg.getSelectedObject());
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyAppContextMgr.class, ex);
        }
        return null;
    }

    private void addColObjToContainer(boolean doAddBySearch, boolean doAssociate) {
        DefaultMutableTreeNode parentNode;
        if (this.checkForChanges() && (parentNode = this.getSelectedTreeNode()) != null) {
            CollectionObject co;
            Container container = (Container)parentNode.getUserObject();
            CollectionObject collectionObject = co = doAddBySearch ? (CollectionObject)this.searchForDataObj(CollectionObject.class) : this.editColObj(null);
            if (co != null) {
                if (doAssociate) {
                    co.setContainer(container);
                    container.getCollectionObjects().add(co);
                    this.saveObjs(co, container);
                    this.model.nodeChanged(parentNode);
                } else {
                    this.addColObjAsChild(parentNode, co);
                }
            }
        }
    }

    private void addColObjAsChild(DefaultMutableTreeNode parentNodeArg, CollectionObject colObj) {
        DefaultMutableTreeNode parentNode;
        DefaultMutableTreeNode defaultMutableTreeNode = parentNode = parentNodeArg == null ? this.getSelectedTreeNode() : parentNodeArg;
        if (parentNode != null && colObj != null) {
            Container container = (Container)parentNode.getUserObject();
            colObj.setContainerOwner(container);
            container.getCollectionObjectKids().add(colObj);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
            newNode.setUserObject(colObj);
            this.colObjIdHash.add(colObj.getId());
            int inx = parentNode.getChildCount();
            this.model.insertNodeInto(newNode, parentNode, inx);
            this.model.nodesWereInserted(parentNode, new int[]{inx});
            this.model.nodeChanged(parentNode);
            this.model.reload();
            this.tree.restoreTree();
            this.expandToNode(newNode);
        }
    }

    private void editContainer() {
        DefaultMutableTreeNode node;
        if (this.checkForChanges() && (node = this.getSelectedTreeNode()) != null && node.getUserObject() instanceof Container) {
            Container container = (Container)node.getUserObject();
            this.createOrEditContainer(container, null);
            this.model.nodeChanged(node);
        }
    }

    private void recursePrune(DefaultMutableTreeNode node, ArrayList<Container> containersToBeDeleted, ArrayList<CollectionObject> colObjsToBeUpdated) {
        if (node.getUserObject() instanceof Container) {
            Container cn = (Container)node.getUserObject();
            if (cn.getId() != null) {
                containersToBeDeleted.add(cn);
                this.containerIdHash.remove(cn.getId());
                CollectionObject co = cn.getCollectionObject();
                if (co != null) {
                    cn.getCollectionObjects().clear();
                    co.setContainer(null);
                    colObjsToBeUpdated.add(cn.getCollectionObject());
                    this.colObjIdHash.remove(co.getId());
                }
                int i = 0;
                while (i < node.getChildCount()) {
                    this.recursePrune((DefaultMutableTreeNode)node.getChildAt(i), containersToBeDeleted, colObjsToBeUpdated);
                    ++i;
                }
                cn.getChildren().clear();
                for (CollectionObject coKid : cn.getCollectionObjectKids()) {
                    coKid.setContainerOwner(null);
                    colObjsToBeUpdated.add(coKid);
                    this.colObjIdHash.remove(coKid.getId());
                }
                cn.getCollectionObjectKids().clear();
            }
        } else {
            CollectionObject co = (CollectionObject)node.getUserObject();
            co.setContainer(null);
            co.setContainerOwner(null);
            colObjsToBeUpdated.add(co);
            this.colObjIdHash.remove(co.getId());
        }
        node.setUserObject(null);
        this.model.removeNodeFromParent(node);
    }

    private void delContainer() {
        DefaultMutableTreeNode node;
        if (this.checkForChanges() && (node = this.getSelectedTreeNode()) != null) {
            ArrayList<Container> containersToBeDeleted = new ArrayList<Container>();
            ArrayList<CollectionObject> colObjsToBeUpdated = new ArrayList<CollectionObject>();
            this.recursePrune(node, containersToBeDeleted, colObjsToBeUpdated);
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    session.beginTransaction();
                    for (CollectionObject co : colObjsToBeUpdated) {
                        CollectionObject mergedCO = session.merge(co);
                        session.update(mergedCO);
                    }
                    for (Container cn : containersToBeDeleted) {
                        session.delete(cn);
                    }
                    session.commit();
                }
                catch (Exception ex) {
                    session.rollback();
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ContainerTreePanel.class, ex);
                    try {
                        if (session != null) {
                            session.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (session != null) {
                        session.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean saveObjs(Object ... objs) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            session.beginTransaction();
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                session.saveOrUpdate(obj);
                ++n2;
            }
            session.commit();
            return true;
        }
        catch (Exception ex) {
            session.rollback();
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ContainerTreePanel.class, ex);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private void expandToNode(final DefaultMutableTreeNode bottomNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] path;
                if (ContainerTreePanel.this.model != null && bottomNode != null && bottomNode.getParent() != null && (path = ContainerTreePanel.this.model.getPathToRoot(bottomNode)) != null && path.length > 0) {
                    ContainerTreePanel.this.tree.expandPath(new TreePath(path));
                }
            }
        });
    }

    private void addContainer(boolean doSearch) {
        DefaultMutableTreeNode parentNode;
        if (this.checkForChanges() && (parentNode = this.getSelectedTreeNode()) != null) {
            Container newContainer;
            Container parentContainer = (Container)parentNode.getUserObject();
            Container container = newContainer = doSearch ? (Container)this.searchForDataObj(Container.class) : this.createContainer(parentContainer);
            if (newContainer != null) {
                if (doSearch) {
                    newContainer.setParent(parentContainer);
                    parentContainer.getChildren().add(newContainer);
                    this.saveObjs(newContainer, parentContainer);
                }
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
                newNode.setUserObject(newContainer);
                if (newContainer.getId() != null) {
                    this.containerIdHash.add(newContainer.getId());
                }
                int inx = parentNode.getChildCount();
                this.model.insertNodeInto(newNode, parentNode, inx);
                this.model.nodesWereInserted(parentNode, new int[]{inx});
                this.model.nodeChanged(parentNode);
                this.model.reload();
                this.tree.restoreTree();
                this.expandToNode(newNode);
            }
        }
    }

    private void viewContainer() {
        DefaultMutableTreeNode node = this.getSelectedTreeNode();
        if (node != null && node.getUserObject() instanceof Container) {
            String title = DBTableIdMgr.getInstance().getTitleForId(Container.getClassTableId());
            ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), null, "Container", null, title, "Close", null, null, false, 8);
            dlg.setWhichBtns(1);
            dlg.getMultiView().getCurrentViewAsFormViewObj().setDataObj(node.getUserObject());
            UIHelper.centerAndShow(dlg);
        }
    }

    private void viewColObj() {
        Object dataObj = null;
        DefaultMutableTreeNode node = this.getSelectedTreeNode();
        if (node != null) {
            if (node.getUserObject() instanceof Container) {
                Container cn = (Container)node.getUserObject();
                dataObj = cn.getCollectionObject();
            } else if (node.getUserObject() instanceof CollectionObject) {
                dataObj = node.getUserObject();
            }
        }
        if (dataObj != null) {
            String title = DBTableIdMgr.getInstance().getTitleForId(CollectionObject.getClassTableId());
            ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), null, "CollectionObject", null, title, "Close", null, null, false, 8);
            dlg.setWhichBtns(1);
            dlg.getMultiView().getCurrentViewAsFormViewObj().setDataObj(dataObj);
            UIHelper.centerAndShow(dlg);
        }
    }

    public void setFVO(FormViewObj fvo) {
        this.formViewObj = fvo;
    }

    private ActionListener getEditColObjAL() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ContainerTreePanel.this.isViewMode) {
                    ContainerTreePanel.this.editColObj();
                } else {
                    ContainerTreePanel.this.viewColObj();
                }
            }
        };
        return al;
    }

    private ActionListener getDelColObjAL() {
        if (this.isViewMode) {
            return null;
        }
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContainerTreePanel.this.delColObj();
            }
        };
        return al;
    }

    private ActionListener getAddColObjAL() {
        if (this.isViewMode) {
            return null;
        }
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContainerTreePanel.this.addColObjToContainer(false, false);
            }
        };
        return al;
    }

    private ActionListener getEditContainerAL() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ContainerTreePanel.this.isViewMode) {
                    ContainerTreePanel.this.editContainer();
                } else {
                    ContainerTreePanel.this.viewContainer();
                }
            }
        };
        return al;
    }

    private ActionListener getDelContainerAL() {
        if (this.isViewMode) {
            return null;
        }
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContainerTreePanel.this.delContainer();
            }
        };
        return al;
    }

    private ActionListener getAddContainerAL() {
        if (this.isViewMode) {
            return null;
        }
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContainerTreePanel.this.addContainer(false);
            }
        };
        return al;
    }

    public void print(JTree actionableTree) {
        DefaultMutableTreeNode clonedTree = GhostActionableTree.makeDeepCopy((DefaultMutableTreeNode)actionableTree.getModel().getRoot());
        GhostActionableTree printTree = new GhostActionableTree(this, new DefaultTreeModel(clonedTree));
        printTree.setRowHeight(26);
        ContainerTreeRenderer renderer = new ContainerTreeRenderer(null, false, false);
        renderer.setBGColor(Color.WHITE);
        renderer.setFont(this.getFont().deriveFont(8.0f));
        printTree.setCellRenderer(renderer);
        int row = 0;
        while (row < printTree.getRowCount()) {
            printTree.expandRow(row);
            ++row;
        }
        PrintablePanel p = new PrintablePanel(new BorderLayout(), printTree);
        p.add((Component)printTree, "Center");
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(new Copies(1));
        aset.add(OrientationRequested.PORTRAIT);
        aset.add(PrintQuality.HIGH);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(p);
        boolean ok = job.printDialog();
        if (ok) {
            try {
                job.print(aset);
            }
            catch (PrinterException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void registerPrintContextMenu(final JTree actionTree) {
        actionTree.addMouseListener(new MouseAdapter(){

            private void displayMenu(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem printMenu = new JMenuItem(UIRegistry.getResourceString("Print"));
                    menu.add(printMenu);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                    printMenu.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            ContainerTreePanel.this.print(actionTree);
                        }
                    });
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                this.displayMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                this.displayMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                this.displayMenu(e);
            }
        });
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isAction("Save") && cmdAction.getData() instanceof Container) {
            System.out.println(cmdAction);
        }
    }

    class ParentNodeInfo {
        boolean hasColObj;
        String containerName;
        String colObjName;
        Integer type;

        public ParentNodeInfo(boolean hasColObj, String containerName, String colObjName, int type) {
            this.hasColObj = hasColObj;
            this.containerName = containerName;
            this.colObjName = colObjName;
            this.type = type;
        }

        public String getTitle() {
            if (StringUtils.isNotEmpty((String)this.containerName) && StringUtils.isNotEmpty((String)this.colObjName)) {
                return String.format("%s - %s", this.containerName, this.colObjName);
            }
            if (StringUtils.isNotEmpty((String)this.containerName)) {
                return this.containerName;
            }
            if (StringUtils.isNotEmpty((String)this.colObjName)) {
                return this.containerName;
            }
            return "";
        }

        public String toString() {
            return this.getTitle();
        }
    }

    class PrintablePanel
    extends JPanel
    implements Printable {
        protected GhostActionableTree gTree;

        public PrintablePanel(LayoutManager layout, GhostActionableTree tree) {
            super(layout);
            this.gTree = tree;
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int index) throws PrinterException {
            Graphics2D g2 = (Graphics2D)g;
            if (index > 0) {
                return 1;
            }
            int w = (int)pageFormat.getWidth();
            int h = (int)pageFormat.getHeight();
            double imgWidth = pageFormat.getImageableWidth() * 1.5;
            double imgHeight = pageFormat.getImageableHeight() * 1.5;
            int imgW = (int)imgWidth;
            int imgH = (int)imgHeight;
            this.setBounds(0, 0, imgW, imgH);
            BufferedImage fullSizeImg = new BufferedImage(imgW, imgH, 1);
            Graphics2D fsG = (Graphics2D)((Image)fullSizeImg).getGraphics();
            this.gTree.setBounds(0, 0, imgW, imgH);
            this.gTree.printAll(fsG);
            fsG.dispose();
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g2.drawImage(fullSizeImg, 0, 0, w, h, 0, 0, imgW, imgH, null);
            return 0;
        }
    }
}

